'\"
'\" Copyright (c) 1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
.so man.macros
.TH load n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
load \- Load machine code and initialize new commands.
.SH SYNOPSIS
\fBload \fIfileName packageName \fR?\fIinterp\fR?
.BE

.SH DESCRIPTION
.PP
This command loads binary code from a file into the
application's address space and calls an initialization procedure
in the package to incorporate it into an interpreter.  \fIfileName\fR
is the name of the file containing the code;  its exact form varies
from system to system but on most systems it is a shared library,
such as a \fB.so\fR file under Solaris or a DLL under Windows.
.PP
Once the file has been loaded into the application's address space,
one of two initialization procedures will be invoked in the new code.
Typically the initialization procedure will add new commands to a
Tcl interpreter.
The name of the initialization procedure is determined by
\fIpackageName\fR and whether or not the target interpreter
is a safe one.  For normal interpreters the name of the initialization
procedure will have the form \fIpkg\fB_Init\fR, where \fIpkg\fR
is the same as \fIpackageName\fR except that the first letter is
converted to upper case and all other letters
are converted to lower case.  For example, if \fIpackageName\fR is
\fBfoo\fR or \fBFOo\fR, the initialization procedure's name will
be \fBFoo_Init\fR.
.PP
If the target interpreter is a safe interpreter, then the name
of the initialization procedure will be \fIpkg\fB_SafeInit\fR
instead of \fIpkg\fB_Init\fR.
.PP
The initialization procedure must match the following prototype:
.CS
typedef int Tcl_PackageInitProc(Tcl_Interp *\fIinterp\fR);
.CE
The \fIinterp\fR argument identifies the interpreter in which the
package is to be loaded.  The initialization procedure must return
TCL_OK or TCL_ERROR to indicate whether or not it completed
successfully;  in the event of an error it should set \fIinterp->result\fR
to point to an error message.  The result of the \fBload\fR command
will be the result returned by the initialization procedure.
.PP
The target interpreter is the same as the invoking interpreter
unless the \fIinterp\fR option is specified.  If \fIinterp\fR is
specified it gives the path name of an interpreter in which to load
the package (see the \fBinterp\fR manual entry for details on
interpreter path names).  It is not possible to unload or reload
a package.
.PP
The actual loading of a file will only be done once for each \fIfileName\fR
in an application.  If a given \fIfileName\fR is loaded into multiple
interpreters, then the first \fBload\fR will load the code and
call the initialization procedure;  subsequent \fBload\fRs will
call the initialization procedure without loading the code again.
It is not possible to unload or reload a package.

.SH BUGS
.PP
If the same file is \fBload\fRed by different \fIfileName\fRs, it will
be loaded into the process's address space multiple times.  The
behavior of this varies from system to system (some systems may
detect the redundant loads, others may not).

.SH "SEE ALSO"
\fBinfo sharedlibextension\fR

.SH KEYWORDS
binary code, loading, shared library
