/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : SOCKET_RAW
    Description : GNU/Linux Raw Socket Implementation
    Author      : David Martnez Oliviera
    Date        : October 14, 2000
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>

/*
***************************************************
  Private Data Struct for class SOCKET_RAW
***************************************************
*/
 
typedef struct
  {
    ESint32		s;  /* Socket Handler */
}DtSOCKET_RAW;
/*
***************************************************
  Method Declaration for class SOCKET_RAW
***************************************************
*/
 
ESint32 EDMAPROC 
SOCKET_RAWinitZ (OBJID IdObj, EPChar proto_name)
{
  DtSOCKET_RAW	*m;
  ESint32       proto;

  m = (DtSOCKET_RAW *) edma_get_data_ref (IdObj);
  
  proto = -1;

  /* Get proto identifier */
  if (strcmp (proto_name, "TCP") == 0)
    {
      proto = IPPROTO_TCP;
    }
  if (strcmp (proto_name, "UDP") == 0)
    {
      proto = IPPROTO_UDP;
    }
  if (strcmp (proto_name, "ICMP") == 0)
    {
      proto = IPPROTO_ICMP;
    }
  if (strcmp (proto_name, "IP") == 0)
    proto = IPPROTO_IP;

  if (proto != -1) 
    {
      /* Raw Socket Creation */
      m->s = socket (PF_INET, SOCK_RAW, proto);
    }
  else
    return -1;

  if (m->s == -1)
    {
      edma_printf_obj (IdObj,"[ERROR] Can't create %s raw socket",proto_name);
    }
  
  return 0;
}


ESint32 EDMAPROC 
SOCKET_RAWreadsAsS32(OBJID IdObj, EDMAT_BUFFER datos, EPSint32 len)
{
  DtSOCKET_RAW	*m;
  ESint32       r;

  m = (DtSOCKET_RAW*) edma_get_data_ref (IdObj);

  memset (datos.dat, 0, datos.Size);
  r = read (m->s, datos.dat, datos.Size);
  *len = r;
  if (r == -1)
    {
      *len = -1;
      edma_printf_obj (IdObj, "%s", "[Error] read: Can't read data");
      return -1;
    }
  return 0;
}


ESint32 EDMAPROC 
SOCKET_RAWclose(OBJID IdObj)
{
  DtSOCKET_RAW	*m;
  
  m = (DtSOCKET_RAW*) edma_get_data_ref (IdObj);
  close (m->s);

  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
