/**
 * Functions prototypes

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/functions.h,v 1.4 2004/01/16 19:55:45 Beuc Exp $
 */

#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include <SDL.h>
#include "util.h"
#include "typedefs.h"
#include "constants.h"

void finiObjects ();
void check_midi (void);
void init_scripts (void);
int load_script (char filename[15], int sprite, /*bool*/int set_sprite);
void strchar (char *string, char ch);

/* DWORD PlayCD(HWND hWndNotify, BYTE bTrack); */
/* DWORD killcd(HWND hWndNotify, BYTE bTrack); */
DWORD PlayCD (BYTE bTrack);
DWORD killcd (BYTE bTrack);
void update_status_all (void);
int add_sprite (int x1, int y, int brain, int pseq, int pframe);
void add_exp (int num, int h);
/*bool*/int locate (int script, char proc[20]);
/*bool*/int exist (char name[255]);
BOOL SoundStopEffect (int sound);
void draw_status_all (void);
/*BOOL*/int SoundDestroyEffect (int sound);
int SoundPlayEffect (int sound, int min, int plus, int sound3d, /*bool*/int repeat);
void SoundLoadBanks (void);
BOOL StopMidi (void);
void check_seq_status (int h);
BOOL PlayMidi (char *sFileName);
void get_word (char line[300], int word, char *crap);

/* void Msg( LPSTR fmt, ... ); */
void run_script (int script);
void add_text (char *tex, char *filename);
void program_idata (void);
void draw_map_game (void);
int realhard (int tile);
void kill_repeat_sounds_all (void);
int process_line (int script, char *s, /*bool*/int doelse);
void SoundLoadBanks (void);
void replace (const char *this1, char *that, char *line);
/*bool*/int seperate_string (char str[255], int num, char liney, char *return1);
void clear_talk (void);
void reverse (char *st);
char *lmon (long money, char *dest);

/* void dderror (HRESULT hErr); */
/*bool*/int compare (char *orig, char *comp);
BOOL CreateSoundBuffer (DWORD dwBuf, DWORD dwBufSize, DWORD dwFreq,
			DWORD dwBitsPerSample, DWORD dwBlkAlign,
			BOOL bStereo);
/* void log_path (bool playing); */

/* BOOL ReadData (LPDIrectSOUNDBUFFER lpDSB, FILE * pFile, DWORD dwSize, DWORD dwPos); */
BOOL init_mouse ();
BOOL CreateBufferFromWaveFile (char *FileName, DWORD dwBuf);
/*bool*/int getkey (int key);
int GetKeyboard (int key);

/* void Msg (LPSTR fmt, ...); */
/* void TRACE (LPSTR fmt, ...); */
SDL_Surface *DDSethLoad (char *szBitmap, int dx, int dy, int sprite);
char key_convert (int key);
void SaySmall (char thing[500], int px, int py, int r, int g, int b);
void Say (char thing[500], int px, int py);
void Saytiny (char thing[2000], int px, int py, int r, int g, int b);
void flip_it_second (void);
/*bool*/int exist (char name[255]);
void add_text (char *tex, char *filename);
int getpic (int h);
void add_hardness (int sprite, int num);
void setup_anim (int fr, int start, int delay);
SDL_Surface *DDTileLoad (char *szBitmap, int dx, int dy, int sprite);
/*BOOL*/int DSDisable (void);
byte get_hard (int h, int x1, int y1);
byte get_hard_play (int h, int x1, int y1);
byte get_hard_map (int h, int x1, int y1);
void fill_hardxy (struct rect box);
void add_exp (int num, int h);
int realhard (int tile);
void fill_whole_hard (void);
void drawallhard (void);
void fix_dead_sprites (void);
void load_map (const int num);
void save_map (const int num);
void save_info (void);
void save_game (int num);
void kill_all_vars (void);
void attach (void);
/*bool*/int add_time_to_saved_game (int num);
/*bool*/int load_game (int num);
void kill_cur_item (void);
void kill_cur_item_script (char name[20]);
void kill_cur_magic_script (char name[20]);
void kill_cur_magic (void);
void update_screen_time (void);
/*bool*/int load_game_small (int num, char *line, int *mytime);
void load_info (void);
void save_hard (void);
void load_hard (void);
void blit_background (void);
void draw_wait ();
SDL_Surface *DDCreateSurface (DWORD width, DWORD height, BOOL sysmem,
			      BOOL trans);
void load_sprite_pak (char org[100], int nummy, int speed, int xoffset,
		      int yoffset, struct rect hardbox, /*bool*/int notanim, /*bool*/int black,
		      /*bool*/int leftalign, /*bool*/int samedir);
void load_sprites (char org[100], int nummy, int speed, int xoffset,
		   int yoffset, struct rect hardbox, /*bool*/int notanim, /*bool*/int black,
		   /*bool*/int leftalign);
void figure_out (char line[255], int load_seq);
void program_idata (void);
void make_idata (int type, int myseq, int myframe, int xoffset, int yoffset,
		 struct rect crect);
void pre_figure_out (char line[255], int load_seq);
/*bool*/int initfonts (char fontname[255]);
void kill_fonts ();
int draw_num (int mseq, char nums[50], int mx, int my);
int next_raise (void);
void draw_exp ();
void draw_strength ();
void draw_defense ();
void draw_magic ();
void draw_level ();
void draw_gold ();
void draw_bar (int life, int seqman);
void draw_health (void);
void draw_icons (void);
void draw_virtical (int percent, int mx, int my, int mseq, int mframe);
void draw_virt2 (int percent, int mx, int my, int mseq, int mframe);
void draw_hor (int percent, int mx, int my, int mseq, int mframe);
void draw_hor2 (int percent, int mx, int my, int mseq, int mframe);
void draw_mlevel (int percent);
void draw_status_all (void);
/*bool*/int inside_box (int x1, int y1, struct rect box);
int add_sprite_dumb (int x1, int y, int brain, int pseq, int pframe,
		     int size);
/*bool*/int get_box (int h, struct rect * box_crap, struct rect * box_real);
void reload_sprites (char name[100], int nummy, int junk);
void refigure_out (char line[255]);
void reload_batch (void);
void strchar (char *string, char ch);	/* This acts in the same way as strcat except it combines a string and  a single character, updating the null at the end. */
void kill_callbacks_owned_by_script (int script);
void kill_script (int k);
void kill_all_scripts (void);
void kill_all_scripts_for_real (void);
/*bool*/int read_next_line (int script, char *line);
char *decompress (FILE * in);
char *decompress_nocomp (FILE * in);
int load_script (char filename[15], int sprite, /*bool*/int set_sprite);
void strip_beginning_spaces (char *s);
/*bool*/int locate (int script, char proc[20]);
/*bool*/int locate_goto (char proc[50], int script);
void decipher (char *crap, int script);
void decipher_string (char line[200], int script);
/*bool*/int get_parms (char proc_name[20], int script, char *h, int p[10]);
int add_callback (char name[20], int n1, int n2, int script);
int add_sprite (int x1, int y, int brain, int pseq, int pframe);
void check_sprite_status (int h);
void check_frame_status (int h, int frame);
void check_seq_status (int h);
void check_base (int base);
void check_sprite_status_full (int h);
int say_text (char text[200], int h, int script);
int say_text_xy (char text[200], int mx, int my, int script);
int does_sprite_have_text (int sprite);
int var_exists (char name[20], int scope);
void make_int (char name[80], int value, int scope, int script);
int var_equals (char name[20], char newname[20], char math, int script,
		char rest[200]);
void get_word (char line[300], int word, char *crap);
int var_figure (char h[200], int script);
void kill_text_owned_by (int sprite);
/*bool*/int text_owned_by (int sprite);
void kill_text_owned_by_safe (int sprite);
void kill_scripts_owned_by (int sprite);
void kill_sprite_all (int sprite);
void kill_returning_stuff (int script);
/*bool*/int talk_get (int script);
/*bool*/int nothing_playing (void);
/*bool*/int cdplaying (void);
void init_midi (void);

/* DWORD playMIDIFile (HWND hWndNotify, LPSTR lpszMIDIFileName); */
DWORD playMIDIFile (char *lpszMIDIFileName);
BOOL PlayMidi (char *sFileName);
void check_midi (void);

/* DWORD killcd (HWND hWndNotify, BYTE bTrack); */
/* DWORD PlayCD (HWND hWndNotify, BYTE bTrack); */
DWORD getCDTrackStartTimes (void);
BOOL PauseMidi ();
BOOL ResumeMidi ();
BOOL StopMidi ();
BOOL ReplayMidi ();
void get_right (char line[200], char thing[100], char *ret);
void int_prepare (char line[100], int script);
int change_sprite (int h, int val, int *change);
int change_edit (int h, int val, unsigned short *change);
int change_edit_char (int h, int val, unsigned char *change);
int change_sprite_noreturn (int h, int val, int *change);
void draw_sprite_game (SDL_Surface * lpdest, int h);
void changedir (int dir1, int k, int base);
void update_play_changes (void);
void update_status_all (void);
void place_sprites_game (void);
/*bool*/int kill_last_sprite (void);
void show_bmp (char name[80], int showdot, int reserved, int script);
void copy_bmp (char name[80]);
BOOL playing (int sound);
int get_pan (int h);
int get_vol (int h);
void kill_repeat_sounds (void);
void kill_repeat_sounds_all (void);
void update_sound (void);
int playbank (int sound, int min, int plus, int sound3d, /*bool*/int repeat);
int SoundPlayEffect (int sound, int min, int plus, int sound3d, /*bool*/int repeat);
int hurt_thing (int h, int damage, int special);
void random_blood (int mx, int my, int h);
BOOL SoundStopEffect (int sound);

/* BOOL DSEnable (HWND hwnd); */
/* BOOL InitSound (HWND hwndOwner); */
void draw_map_game (void);
void place_sprites_game_background (void);
void draw_map_game_background (void);
void fill_back_sprites (void);
void add_item (char name[10], int mseq, int mframe, /*bool*/int magic);
void fill_screen (int num);
void fill_hard_sprites (void);

int process_line (int script, char *s, /*bool*/int doelse);

/* Processes a single uncompressed DinkC line
** Parameters: (int) script: The execution graph frame [script] this is from
**             (char *) s: The line to execute
**             (bool) doelse: Whether, upon encountering an 'else' statement, the next line should be
**                            marked as 'to be ignored' (rinfo[script]->skipnext)
** Returns   : (int) 0 if 's' was processed in its entirety
**                   1 if 's' changed the current stack frame (end or beginning of block)
**                   2 ?
**                   3 ?
**                   4 ?
**                   5 ?
**              (char *) s: 
**              (int) returnint: The numeric result of evaluating the line in a functional sense (e.g. (1+2) evaluates to 3) 
** Effects   :  rinfo[script]->skipnext modified to skip next line
** Recursive and mutually recursive with run_script.
*/

void run_script (int script);

/* Executes a pre-allocated execution graph frame [script]
** Parameters: (int) script: The execution graph frame [script] to run
**             
** See also load_script(), which instantiates execution graph frames [scripts]
*/

void process_callbacks (void);

void init_scripts (void);

/* Runs the 'main' procedure of all active sprites
** Effects   : Any effects mandated by the appropriate scripts, debug output in debug mode
** Iterates over 'rinfo', gathers sprites from there and checks activity in 'spr'.
*/



void text_draw (int h);
void draw_damage (int h);
void duck_brain (int h);
void pill_brain (int h);
void people_brain (int h);
void no_brain (int h);
void shadow_brain (int h);
void dragon_brain (int h);
void pig_brain (int h);
void bounce_brain (int h);
void missile_brain (int h, /*bool*/int repeat);
void missile_brain_expire (int h);
void mouse_brain (int h);
void human_brain (int h);
void one_time_brain_for_real (int h);
void scale_brain (int h);
void repeat_brain (int h);
void text_brain (int h);
void button_brain (int h);
void one_time_brain (int h);

void process_talk ();
void draw_item (int num, /*bool*/int magic, int mseq, int mframe);
void process_show_bmp (void);
void drawscreenlock (void);
void move (int u, int amount, char kind, char kindy);
void make_missile (int x1, int y1, int dir, int speed, int seq, int frame,
		   int strength);
/*bool*/int transition (void);
void CyclePalette ();
void up_cycle (void);
void flip_it (void);
void draw_box (struct rect box, int color);

/*BOOL*/int DestroySound (void);
/*BOOL*/int SoundDestroyEffect (int sound);

/*bool*/int check_for_kill_script (int i);
/*bool*/int check_for_duck_script (int i);

void process_bow (int h);
void run_through_tag_list (int h, int strength);
void run_through_tag_list_push (int h);
void run_through_touch_damage_list (int h);
void process_warp_man (void);
void run_through_mouse_list (int h, /*bool*/int special);
void process_item (void);
void process_animated_tiles (void);
int special_block (int block, int h);

void get_last_sprite (void);
/*bool*/int not_in_this_base (int seq, int base);
/*bool*/int in_this_base (int seq, int base);
void automove (int j);
int autoreverse (int j);
int autoreverse_diag (int j);
void add_kill_sprite (int h);
void done_moving (int h);
int get_distance_and_dir (int h, int h1, int *dir);
void process_follow (int h);
void process_target (int h);
void process_move (int h);
void change_dir_to_diag (int *dir);
void find_action (int h);
int check_if_move_is_legal (int u);
void grab_trick (int trick);
void did_player_cross_screen (/*bool*/int real, int h);
/*bool*/int run_through_tag_list_talk (int h);
int find_sprite (int block);
void UpdateCursorPosition (int dx, int dy);

BOOL keypressed (void);
void check_joystick (void);
BOOL CheckJoyStickPresent (void);
void Scrawl_OnMouseInput (void);

void updateFrame (void);

/*bool*/int check_arg (int argc, char *args[]);

#endif
