#include <gamalib/ellipsoids.h>
#include <cstring>

// This file was generated by GNU GaMa (program ellipsoids_xml) from
// http://www.gnu.org/software/gama/xml/ellipsoids.xml revision 0.10

namespace GaMaLib {

const char * const gama_ellipsoid_caption[] = { "",
   "Airy ellipsoid 1830",
   "Modified Airy",
   "Appl. Physics. 1965",
   "Andrae 1876 (Denmark, Iceland)",
   "Australian National 1965",
   "Bessel ellipsoid 1841",
   "Bessel 1841 (Namibia)",
   "Clarke ellipsoid 1858 1st",
   "Clarke ellipsoid 1858 2nd",
   "Clarke ellipsoid 1866",
   "Clarke ellipsoid 1880",
   "Clarke ellipsoid 1880 (modified)",
   "Comm. des Poids et Mesures 1799",
   "Delambre 1810 (Belgium)",
   "Engelis 1985",
   "Everest 1830",
   "Everest 1948",
   "Everest 1956",
   "Everest 1969",
   "Everest (Sabah and Sarawak)",
   "Fisher 1960 (Mercury Datum)",
   "Modified Fisher 1960",
   "Fischer 1968",
   "GRS 67 (IUGG 1967)",
   "Geodetic Reference System 1980",
   "Hayford 1909 (International)",
   "Helmert ellipsoid 1906",
   "Hough",
   "IAU 1976",
   "International 1924 (Hayford 1909)",
   "Kaula 1961",
   "Krassovski ellipsoid 1940",
   "Lerch 1979",
   "Maupertius 1738",
   "Mercury spheroid 1960",
   "MERIT 1983",
   "New International 1967",
   "Naval Weapons Lab., 1965",
   "Plessis 1817 (France)",
   "Southeast Asia",
   "Soviet Geodetic System 85",
   "Schott 1900 spheroid",
   "South American Spheroid 1969",
   "Walbeck",
   "WGS 60",
   "WGS 66",
   "WGS 72",
   "World Geodetic System 1984"
};

int set(Ellipsoid* E, gama_ellipsoid T)
{
   switch(T) {
   case ellipsoid_airy :
      E->set_ab( 6377563.396, 6356256.910 );
      break;
   case ellipsoid_airy_mod :
      E->set_ab( 6377340.189, 6356034.446 );
      break;
   case ellipsoid_apl1965 :
      E->set_af1( 6378137, 298.25 );
      break;
   case ellipsoid_andrae1876 :
      E->set_af1( 6377104.43, 300.0 );
      break;
   case ellipsoid_australian :
      E->set_af1( 6378160, 298.25 );
      break;
   case ellipsoid_bessel :
      E->set_ab( 6377397.15508, 6356078.96290 );
      break;
   case ellipsoid_bessel_nam :
      E->set_af1( 6377483.865, 299.1528128 );
      break;
   case ellipsoid_clarke1858a :
      E->set_ab( 6378361, 6356685 );
      break;
   case ellipsoid_clarke1858b :
      E->set_ab( 6378558, 6355810 );
      break;
   case ellipsoid_clarke1866 :
      E->set_ab( 6378206.4, 6356583.8 );
      break;
   case ellipsoid_clarke1880 :
      E->set_ab( 6378316, 6356582 );
      break;
   case ellipsoid_clarke1880m :
      E->set_af1( 6378249.145, 293.4663 );
      break;
   case ellipsoid_cpm1799 :
      E->set_af1( 6375738.7, 334.29 );
      break;
   case ellipsoid_delambre :
      E->set_af1( 6376428, 311.5 );
      break;
   case ellipsoid_engelis :
      E->set_af1( 6378136.05, 298.2566 );
      break;
   case ellipsoid_everest1830 :
      E->set_af1( 6377276.345, 300.8017 );
      break;
   case ellipsoid_everest1848 :
      E->set_af1( 6377304.063, 300.8017 );
      break;
   case ellipsoid_everest1856 :
      E->set_af1( 6377301.243, 300.8017 );
      break;
   case ellipsoid_everest1869 :
      E->set_af1( 6377295.664, 300.8017 );
      break;
   case ellipsoid_everest_ss :
      E->set_af1( 6377298.556, 300.8017 );
      break;
   case ellipsoid_fisher1960 :
      E->set_af1( 6378166, 298.3 );
      break;
   case ellipsoid_fisher1960m :
      E->set_af1( 6378155, 298.3 );
      break;
   case ellipsoid_fischer1968 :
      E->set_af1( 6378150, 298.3 );
      break;
   case ellipsoid_grs67 :
      E->set_af1( 6378160, 298.2471674270 );
      break;
   case ellipsoid_grs80 :
      E->set_af1( 6378137, 298.257222101 );
      break;
   case ellipsoid_hayford :
      E->set_af1( 6378388, 297 );
      break;
   case ellipsoid_helmert :
      E->set_af1( 6378200, 298.3 );
      break;
   case ellipsoid_hough :
      E->set_af1( 6378270, 297 );
      break;
   case ellipsoid_iau76 :
      E->set_af1( 6378140, 298.257 );
      break;
   case ellipsoid_international :
      E->set_af1( 6378388, 297 );
      break;
   case ellipsoid_kaula :
      E->set_af1( 6378163, 298.24 );
      break;
   case ellipsoid_krassovski :
      E->set_af1( 6378245, 298.3 );
      break;
   case ellipsoid_lerch :
      E->set_af1( 6378139, 298.257 );
      break;
   case ellipsoid_mprts :
      E->set_af1( 6397300, 191.0 );
      break;
   case ellipsoid_mercury :
      E->set_af1( 6378166, 298.3 );
      break;
   case ellipsoid_merit :
      E->set_af1( 6378137, 298.257 );
      break;
   case ellipsoid_new_intl :
      E->set_ab( 6378157.5, 6356772.2 );
      break;
   case ellipsoid_nwl1965 :
      E->set_af1( 6378145, 298.25 );
      break;
   case ellipsoid_plessis :
      E->set_ab( 6376523, 6355863 );
      break;
   case ellipsoid_se_asia :
      E->set_ab( 6378155, 6356773.3205 );
      break;
   case ellipsoid_sgs85 :
      E->set_af1( 6378136, 298.257 );
      break;
   case ellipsoid_schott :
      E->set_af1( 6378157, 304.5 );
      break;
   case ellipsoid_sa1969 :
      E->set_af1( 6378160, 298.25 );
      break;
   case ellipsoid_walbeck :
      E->set_ab( 6376896, 6355834.8467 );
      break;
   case ellipsoid_wgs60 :
      E->set_af1( 6378165, 298.3 );
      break;
   case ellipsoid_wgs66 :
      E->set_af1( 6378145, 298.25 );
      break;
   case ellipsoid_wgs72 :
      E->set_af1( 6378135, 298.26 );
      break;
   case ellipsoid_wgs84 :
      E->set_af1( 6378137, 298.257223563 );
      break;
   default :
      return 1;
   }

   return 0;
}

gama_ellipsoid ellipsoid(const char* s)
{
   using namespace std;

   gama_ellipsoid T = ellipsoid_unknown;

   if      (!strcmp("airy", s))  T = ellipsoid_airy;
   else if (!strcmp("airy_mod", s))  T = ellipsoid_airy_mod;
   else if (!strcmp("apl1965", s))  T = ellipsoid_apl1965;
   else if (!strcmp("andrae1876", s))  T = ellipsoid_andrae1876;
   else if (!strcmp("australian", s))  T = ellipsoid_australian;
   else if (!strcmp("bessel", s))  T = ellipsoid_bessel;
   else if (!strcmp("bessel_nam", s))  T = ellipsoid_bessel_nam;
   else if (!strcmp("clarke1858a", s))  T = ellipsoid_clarke1858a;
   else if (!strcmp("clarke1858b", s))  T = ellipsoid_clarke1858b;
   else if (!strcmp("clarke1866", s))  T = ellipsoid_clarke1866;
   else if (!strcmp("clarke1880", s))  T = ellipsoid_clarke1880;
   else if (!strcmp("clarke1880m", s))  T = ellipsoid_clarke1880m;
   else if (!strcmp("cpm1799", s))  T = ellipsoid_cpm1799;
   else if (!strcmp("delambre", s))  T = ellipsoid_delambre;
   else if (!strcmp("engelis", s))  T = ellipsoid_engelis;
   else if (!strcmp("everest1830", s))  T = ellipsoid_everest1830;
   else if (!strcmp("everest1848", s))  T = ellipsoid_everest1848;
   else if (!strcmp("everest1856", s))  T = ellipsoid_everest1856;
   else if (!strcmp("everest1869", s))  T = ellipsoid_everest1869;
   else if (!strcmp("everest_ss", s))  T = ellipsoid_everest_ss;
   else if (!strcmp("fisher1960", s))  T = ellipsoid_fisher1960;
   else if (!strcmp("fisher1960m", s))  T = ellipsoid_fisher1960m;
   else if (!strcmp("fischer1968", s))  T = ellipsoid_fischer1968;
   else if (!strcmp("grs67", s))  T = ellipsoid_grs67;
   else if (!strcmp("grs80", s))  T = ellipsoid_grs80;
   else if (!strcmp("hayford", s))  T = ellipsoid_hayford;
   else if (!strcmp("helmert", s))  T = ellipsoid_helmert;
   else if (!strcmp("hough", s))  T = ellipsoid_hough;
   else if (!strcmp("iau76", s))  T = ellipsoid_iau76;
   else if (!strcmp("international", s))  T = ellipsoid_international;
   else if (!strcmp("kaula", s))  T = ellipsoid_kaula;
   else if (!strcmp("krassovski", s))  T = ellipsoid_krassovski;
   else if (!strcmp("lerch", s))  T = ellipsoid_lerch;
   else if (!strcmp("mprts", s))  T = ellipsoid_mprts;
   else if (!strcmp("mercury", s))  T = ellipsoid_mercury;
   else if (!strcmp("merit", s))  T = ellipsoid_merit;
   else if (!strcmp("new_intl", s))  T = ellipsoid_new_intl;
   else if (!strcmp("nwl1965", s))  T = ellipsoid_nwl1965;
   else if (!strcmp("plessis", s))  T = ellipsoid_plessis;
   else if (!strcmp("se_asia", s))  T = ellipsoid_se_asia;
   else if (!strcmp("sgs85", s))  T = ellipsoid_sgs85;
   else if (!strcmp("schott", s))  T = ellipsoid_schott;
   else if (!strcmp("sa1969", s))  T = ellipsoid_sa1969;
   else if (!strcmp("walbeck", s))  T = ellipsoid_walbeck;
   else if (!strcmp("wgs60", s))  T = ellipsoid_wgs60;
   else if (!strcmp("wgs66", s))  T = ellipsoid_wgs66;
   else if (!strcmp("wgs72", s))  T = ellipsoid_wgs72;
   else if (!strcmp("wgs84", s))  T = ellipsoid_wgs84;

   return T;
}

}      // namespace GaMaLib
