;; Scheduling description for z990 (cpu 2084).
;;   Copyright (C) 2003,2004 Free Software Foundation, Inc.
;;   Contributed by Hartmut Penner (hpenner@de.ibm.com) and
;;                  Ulrich Weigand (uweigand@de.ibm.com).

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 2, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the Free
;; Software Foundation, 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

(define_automaton "x_ipu")

(define_cpu_unit "x_e1_r,x_e1_s,x_e1_t"  "x_ipu")
(define_cpu_unit "x_wr_r,x_wr_s,x_wr_t,x_wr_fp" "x_ipu")
(define_cpu_unit "x_s1,x_s2,x_s3,x_s4"   "x_ipu")
(define_cpu_unit "x_t1,x_t2,x_t3,x_t4"   "x_ipu")
(define_cpu_unit "x_f1,x_f2,x_f3,x_f4,x_f5,x_f6"   "x_ipu")
(define_cpu_unit "x_store_tok"   "x_ipu")
(define_cpu_unit "x_ms,x_mt"   "x_ipu")

(define_reservation "x-e1-st" "(x_e1_s | x_e1_t)")

(define_reservation "x-e1-np" "(x_e1_r + x_e1_s + x_e1_t)")

(absence_set "x_e1_r" "x_e1_s,x_e1_t")
(absence_set "x_e1_s" "x_e1_t")

;; Try to avoid int <-> fp transitions.

(define_reservation "x-x" "x_s1|x_t1,x_s2|x_t2,x_s3|x_t3,x_s4|x_t4")
(define_reservation "x-f" "x_f1,x_f2,x_f3,x_f4,x_f5,x_f6")
(define_reservation "x-wr-st" "((x_wr_s | x_wr_t),x-x)")
(define_reservation "x-wr-np" "((x_wr_r + x_wr_s + x_wr_t),x-x)")
(define_reservation "x-wr-fp" "x_wr_fp,x-f")
(define_reservation "x-mem"   "x_ms|x_mt")

(absence_set "x_wr_fp"
             "x_s1,x_s2,x_s3,x_s4,x_t1,x_t2,x_t3,x_t4,x_wr_s,x_wr_t")

(absence_set "x_e1_r,x_wr_r,x_wr_s,x_wr_t"
             "x_f1,x_f2,x_f3,x_f4,x_f5,x_f6,x_wr_fp")

;; Don't have any load type insn in same group as store

(absence_set "x_ms,x_mt" "x_store_tok")


;;
;; Simple insns
;;

(define_insn_reservation "x_int" 1
  (and (eq_attr "cpu" "z990")
       (and (eq_attr "type" "integer")
            (eq_attr "atype" "reg")))
  "x-e1-st,x-wr-st")

(define_insn_reservation "x_agen" 1
  (and (eq_attr "cpu" "z990")
       (and (eq_attr "type" "integer")
            (eq_attr "atype" "agen")))
  "x-e1-st,x-wr-st")

(define_insn_reservation "x_lr" 1
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "lr"))
  "x-e1-st,x-wr-st") 

(define_insn_reservation "x_la" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "la"))
  "x-e1-st,x-wr-st") 

(define_insn_reservation "x_larl" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "larl"))
  "x-e1-st,x-wr-st") 

(define_insn_reservation "x_load" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "load"))
  "x-e1-st+x-mem,x-wr-st") 

(define_insn_reservation "x_store" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "store"))
  "x-e1-st+x_store_tok,x-wr-st") 

(define_insn_reservation "x_branch" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "branch"))
  "x_e1_r,x_wr_r") 

(define_insn_reservation "x_call" 5 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "jsr"))
  "x-e1-np*5,x-wr-np") 

;;
;; Multicycle insns
;;

(define_insn_reservation "x_cs" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "cs"))
  "x-e1-np,x-wr-np") 

(define_insn_reservation "x_vs" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "vs"))
  "x-e1-np*10,x-wr-np") 

(define_insn_reservation "x_stm" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "stm"))
  "(x-e1-np+x_store_tok)*10,x-wr-np") 

(define_insn_reservation "x_lm" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "lm"))
  "x-e1-np*10,x-wr-np") 

(define_insn_reservation "x_other" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "other"))
  "x-e1-np,x-wr-np") 

;;
;; Floating point insns
;;

(define_insn_reservation "x_fsimpd" 6 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "fsimpd,fmuld"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_fsimps" 6 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "fsimps,fmuls"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_fdivd" 36
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "fdivd,fsqrtd"))
  "x_e1_t*30,x-wr-fp") 

(define_insn_reservation "x_fdivs" 36 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "fdivs,fsqrts"))
  "x_e1_t*30,x-wr-fp") 

(define_insn_reservation "x_floadd" 6 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "floadd"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_floads" 6 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "floads"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_fstored" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "fstored"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_fstores" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "fstores"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_ftoi" 1 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "ftoi"))
  "x_e1_t*3,x-wr-fp") 

(define_insn_reservation "x_itof" 7 
  (and (eq_attr "cpu" "z990")
       (eq_attr "type" "itof"))
  "x_e1_t*3,x-wr-fp") 

(define_bypass 1 "x_fsimpd" "x_fstored")

(define_bypass 1 "x_fsimps" "x_fstores")

(define_bypass 1 "x_floadd" "x_fsimpd,x_fstored,x_floadd")
	         
(define_bypass 1 "x_floads" "x_fsimps,x_fstores,x_floads")

;;
;; s390_agen_dep_p returns 1, if a register is set in the 
;; first insn and used in the dependent insn to form a address.
;;

;;
;; If an instruction uses a register to address memory, it needs
;; to be set 5 cycles in advance.
;; 

(define_bypass 5 "x_int,x_agen,x_lr" 
                 "x_agen,x_la,x_branch,x_call,x_load,x_store,x_cs,x_stm,x_lm,x_other"
	         "s390_agen_dep_p")

(define_bypass 9 "x_int,x_agen,x_lr" 
                 "x_floadd, x_floads, x_fstored, x_fstores,\
		  x_fsimpd, x_fsimps, x_fdivd, x_fdivs"
	         "s390_agen_dep_p")
;;
;; A load type instruction uses a bypass to feed the result back	
;; to the address generation pipeline stage. 
;;

(define_bypass 4 "x_load"    
                 "x_agen,x_la,x_branch,x_call,x_load,x_store,x_cs,x_stm,x_lm,x_other"
	         "s390_agen_dep_p")

(define_bypass 5 "x_load"
                 "x_floadd, x_floads, x_fstored, x_fstores,\
		  x_fsimpd, x_fsimps, x_fdivd, x_fdivs"
	         "s390_agen_dep_p")

;;
;; A load address type instruction uses a bypass to feed the 
;; result back to the address generation pipeline stage. 
;;

(define_bypass 3 "x_larl,x_la" 
                 "x_agen,x_la,x_branch,x_call,x_load,x_store,x_cs,x_stm,x_lm,x_other"
	         "s390_agen_dep_p")

(define_bypass 5 "x_larl, x_la"
                 "x_floadd, x_floads, x_fstored, x_fstores,\
		  x_fsimpd, x_fsimps, x_fdivd, x_fdivs"
	         "s390_agen_dep_p")

;;
;; Operand forwarding
;;

(define_bypass 0 "x_lr,x_la,x_load" "x_int,x_lr")


