# make-prototype.awk: generate `prototype' HTML.

# Copyright (C) 2013 Free Software Foundation, Inc.

# This file is part of GNUnited Nations.

# GNUnited Nations is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.

# GNUnited Nations is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with GNUnited Nations.  If not, see <http://www.gnu.org/licenses/>.

# Fallback for awks who don't support RT.
BEGIN { RT = "\n" }

# Read whole file to `text'.
{ text = text $0 RT }

END {

# Program's name to prepend error messages.
  my_name = "make-prototype.awk: "
  if (!match(text, /<title>.*<\/div>.*<div id="footer">/))
    {
      print my_name \
        "`<title>' followed by `</div>' and `<div id=\"footer\">' not found" \
         > "/dev/stderr"
      exit 1
    }
  output = ""
  parts[3] = substr (text, RSTART + RLENGTH)
  text = substr (text, 1, RSTART + RLENGTH - 1)
  if (RSTART > 1)
    {
      output = substr (text, 1, RSTART - 1)
      text = substr (text, RSTART)
    }
  match(text, /.*<\/div>/)
  parts[1] = substr (text, 1, RLENGTH - 6)
  parts[2] = substr (text, RLENGTH + 1 - 6)
  output = output "<gnun></gnun>"\
    "<!-- This file is automatically generated by GNUnited Nations! -->\n" \
    parts[1] \
"\n" \
"<div style=\"font-size: small;\">\n" \
"<!--TRANSLATORS: Use space (SPC) as msgstr if you don't have notes.-->\n" \
"*GNUN-SLOT: TRANSLATOR'S NOTES*</div>\n" \
    parts[2]

  if(!match (parts[3], /<p>.*[$]Date:/))
    {
      print my_name \
        "no `<p>' followed by `$Date:' after `<div id=\"footer\">' found" \
         > "/dev/stderr"
      exit 1
    }
  tail[1] = substr (parts[3], 1, RSTART + RLENGTH - 1)
  tail[2] = substr (parts[3], RSTART + RLENGTH)
  match (tail[1], /.*<p>/)
  tail[2] = substr (tail[1], RSTART + RLENGTH - 3) tail[2]
  tail[1] = substr (tail[1], 1, RSTART + RLENGTH - 1 - 3)
  printf "%s", output tail[1] \
"\n" \
"<div class=\"translators-credits\">\n" \
"<!--TRANSLATORS: Use space (SPC) as msgstr if you don't want credits.-->\n" \
"*GNUN-SLOT: TRANSLATOR'S CREDITS*</div>\n\n\n " tail[2]
}
