/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.testing;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import org.gnunet.util.Client;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.Server;

public class TestingServer {
    public final Server server;
    private final ServerSocketChannel srvChan;

    public TestingServer() {
        this(RelativeTime.FOREVER, true);
    }

    public TestingServer(RelativeTime idleTimeout, boolean requireFound) {
        try {
            this.srvChan = ServerSocketChannel.open();
            this.srvChan.configureBlocking(false);
            this.srvChan.socket().bind(null);
        }
        catch (IOException e) {
            throw new RuntimeException("TestingServer creation failed");
        }
        this.server = new Server(idleTimeout, requireFound);
        this.server.addAcceptSocket(this.srvChan);
    }

    public Client createClient() {
        SocketAddress socketAddress = this.srvChan.socket().getLocalSocketAddress();
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new RuntimeException("unknown type of socket address");
        }
        InetSocketAddress saddr = (InetSocketAddress)socketAddress;
        String hostname = saddr.getHostName();
        if (hostname == null) {
            throw new RuntimeException("localhost SocketAddress has no hostname");
        }
        return new Client(hostname, this.srvChan.socket().getLocalPort());
    }
}

