/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.test;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import gnu.prolog.Version;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.ParseException;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.TermReader;
import gnu.prolog.io.TermWriter;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Iterator;

public class GoalRunner {
    public static final String USAGE = "usage: java gnu.prolog.test.GoalRunner\n                                      [-o|--once]\n                                      [-t|--threads <threads>]\n                                      [-i|--iterations <iterations>]\n                                      <text to load> <goal to run>";
    public static final String EXAMPLE = "example: java gnu.prolog.test.GoalRunner append.pro append([a,b],[c,d],R)";

    private GoalRunner() {
    }

    private static void usage() {
        System.out.println(USAGE);
        System.out.println(EXAMPLE);
        System.exit(-1);
    }

    public static void main(String[] args) {
        try {
            int c;
            System.out.println("GNU Prolog for Java (" + Version.getVersion() + ") Goal runner (c) Constantine Plotnikov, 1997-1999.");
            LongOpt[] longOptions = new LongOpt[]{new LongOpt("once", 0, null, 111), new LongOpt("threads", 1, null, 116), new LongOpt("iterations", 1, null, 105)};
            Getopt opts = new Getopt("GoalRunner", args, "ot:i:", longOptions);
            int threads = 1;
            int iterations = 1;
            boolean once = false;
            block12: while ((c = opts.getopt()) != -1) {
                switch (c) {
                    case 111: {
                        once = true;
                        continue block12;
                    }
                    case 116: {
                        try {
                            threads = Integer.parseInt(opts.getOptarg());
                        }
                        catch (NumberFormatException e) {
                            System.err.println("-t|--threads takes an integer argument not" + opts.getOptarg());
                            GoalRunner.usage();
                        }
                        continue block12;
                    }
                    case 105: {
                        try {
                            iterations = Integer.parseInt(opts.getOptarg());
                        }
                        catch (NumberFormatException e) {
                            System.err.println("-i|--iterations takes an integer argument not" + opts.getOptarg());
                            GoalRunner.usage();
                        }
                        continue block12;
                    }
                    case 63: {
                        System.err.println("The option '" + (char)opts.getOptopt() + "' is not valid");
                        GoalRunner.usage();
                        continue block12;
                    }
                }
                System.err.println("getopt() returned " + (char)c);
                GoalRunner.usage();
            }
            int argumentsStartIndex = opts.getOptind();
            if (args.length - argumentsStartIndex != 2) {
                GoalRunner.usage();
            }
            String textToLoad = args[argumentsStartIndex];
            String goalToRun = args[argumentsStartIndex + 1];
            Environment env = new Environment();
            env.ensureLoaded(AtomTerm.get(textToLoad));
            Runner[] runners = new Runner[threads];
            for (int j = 0; j < iterations; ++j) {
                int i;
                for (i = 0; i < threads; ++i) {
                    runners[i] = new Runner("it: " + j + " t:" + i, env, once, goalToRun);
                    runners[i].start();
                }
                for (i = 0; i < threads; ++i) {
                    runners[i].join();
                    runners[i] = null;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class Runner
    extends Thread {
        private Environment env;
        private boolean once;
        private String goalToRun;

        public Runner(String name, Environment environment, boolean once, String goalToRun) {
            super(name);
            this.env = environment;
            this.once = once;
            this.goalToRun = goalToRun;
        }

        @Override
        public void run() {
            Interpreter interpreter = this.env.createInterpreter();
            this.env.runInitialization(interpreter);
            Iterator<PrologTextLoaderError> i$ = this.env.getLoadingErrors().iterator();
            while (i$.hasNext()) {
                PrologTextLoaderError element;
                PrologTextLoaderError err = element = i$.next();
                System.err.println(err);
            }
            LineNumberReader kin = new LineNumberReader(new InputStreamReader(System.in));
            StringReader rd = new StringReader(this.goalToRun);
            TermReader trd = new TermReader(rd, this.env);
            TermWriter out = new TermWriter(new OutputStreamWriter(System.out));
            ReadOptions rd_ops = new ReadOptions(this.env.getOperatorSet());
            try {
                Term goalTerm = trd.readTermEof(rd_ops);
                Interpreter.Goal goal = interpreter.prepareGoal(goalTerm);
                while (true) {
                    long startTime = System.currentTimeMillis();
                    int rc = interpreter.execute(goal);
                    long stopTime = System.currentTimeMillis();
                    this.env.getUserOutput().flushOutput(null);
                    System.out.println("time = " + (stopTime - startTime) + "ms");
                    String response = "n";
                    switch (rc) {
                        case 0: {
                            WriteOptions options = new WriteOptions(new OperatorSet());
                            for (String name : rd_ops.variableNames.keySet()) {
                                out.print(name + " = ");
                                out.print(options, rd_ops.variableNames.get(name).dereference());
                                out.print("; ");
                            }
                            out.println();
                            if (this.once) {
                                out.print("SUCCESS. redo suppressed by command line option \"-once\"");
                                return;
                            }
                            out.print("SUCCESS. redo (y/n/a)?");
                            out.flush();
                            response = kin.readLine();
                            if ("a".equals(response)) {
                                interpreter.stop(goal);
                                goal = interpreter.prepareGoal(goalTerm);
                            }
                            if (!"n".equals(response)) break;
                            return;
                        }
                        case 1: {
                            WriteOptions options = new WriteOptions(new OperatorSet());
                            for (String name : rd_ops.variableNames.keySet()) {
                                out.print(name + " = ");
                                out.print(options, rd_ops.variableNames.get(name).dereference());
                                out.print("; ");
                            }
                            out.println();
                            out.println("SUCCESS LAST");
                            out.flush();
                            return;
                        }
                        case -1: {
                            out.println("FAIL");
                            out.flush();
                            return;
                        }
                        case -2: {
                            this.env.closeStreams();
                            out.println("HALT");
                            out.flush();
                            System.exit(interpreter.getExitCode());
                            return;
                        }
                    }
                }
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            catch (PrologException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

