/* -*- Mode: c++ -*- */

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Sample application to illustrate the use of a GrSimpleScopeSink.
 * The input here is provided by the VrSigSource signal generator.
 */

#include <VrChirpSource.h>
#include <GrFFTSink.h>
#include <VrNullSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include "VrGUI.h" 

#define SAMPLING_FREQUENCY                         20e6


#define IOTYPE short


GrFFTSink<IOTYPE> *scope_sink;

int main(int argc, char **argv) {
  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();

  VrSink<IOTYPE> *sink;
  VrChirpSource<IOTYPE> source (SAMPLING_FREQUENCY, 32767, 4);
  GrFFTSink<IOTYPE> scope_sink (vert, 50, 150, 1024);

  sink = &scope_sink;

  NWO_CONNECT (&source, sink);

  VrMultiTask m;
  m.add (sink);
  m.start();

  guimain->start();

  while (1) {
    guimain->processEvents(10 /*ms*/);
    m.process();
  }
}
