/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <GrOscopeSinkX.h>
#include <gr_OscopeGuts.h>

GrOscopeSinkX::GrOscopeSinkX (int input_itemsize)
  : GrSink (input_itemsize), d_guts (0)
{
}

GrOscopeSinkX::~GrOscopeSinkX ()
{
  delete d_guts;
}

// ----------------------------------------------------------------

bool
GrOscopeSinkX::setUpdateRate (double update_rate)
{
  return d_guts->setUpdateRate (update_rate);
}

bool
GrOscopeSinkX::setDecimationCount (int decimation_count)
{
  return d_guts->setDecimationCount (decimation_count);
}

bool
GrOscopeSinkX::setTriggerChannel (int channel)
{
  return d_guts->setTriggerChannel (channel);
}

bool
GrOscopeSinkX::setTriggerMode (gr_TriggerMode mode)
{
  return d_guts->setTriggerMode (mode);
}

bool
GrOscopeSinkX::setTriggerLevel (double trigger_level)
{
  return d_guts->setTriggerLevel (trigger_level);
}


bool
GrOscopeSinkX::setTriggerLevelAuto ()
{
  return d_guts->setTriggerLevelAuto ();
}

// ACCESSORS

int
GrOscopeSinkX::getNumChannels () const
{
  return d_guts->getNumChannels ();
}

double
GrOscopeSinkX::getSamplingRate () const
{
  return d_guts->getSamplingRate ();
}

double
GrOscopeSinkX::getUpdateRate () const
{
  return d_guts->getUpdateRate ();
}

int
GrOscopeSinkX::getDecimationCount () const
{
  return d_guts->getDecimationCount ();
}

int
GrOscopeSinkX::getTriggerChannel () const
{
  return d_guts->getTriggerChannel ();
}

gr_TriggerMode
GrOscopeSinkX::getTriggerMode () const
{
  return d_guts->getTriggerMode ();
}

double
GrOscopeSinkX::getTriggerLevel () const
{
  return d_guts->getTriggerLevel ();
}

int
GrOscopeSinkX::getSamplesPerOutputRecord () const
{
  return d_guts->getSamplesPerOutputRecord ();
}
