#!/usr/bin/env python
#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

# DSB AM transmitter using USRP


from GnuRadio import *

def build_graph (to_file):
    interp_rate = 64
    sample_rate = 125e6/interp_rate
    #sample_rate = 125e6/512
    which_board = 0
    channel_bitmask = 0
    carrier_ampl = 10000
    station_freq = 1e6

    fg = gr_FlowGraph ()

    sig1 = VrSigSourceF (sample_rate, VR_DC_WAVE, 0, 1.0)
    # sig2 = VrSigSourceF (sample_rate, VR_SIN_WAVE, 144000, 0.20)
    # one = VrSigSourceF (sample_rate, VR_DC_WAVE, 0, 1.0)

    # sum = 1 + sig1 + sig2

    sum = GrAddFF ()
    fg.connect (sig1, sum)
    # fg.connect (sig2, sum)
    # fg.connect (one, sum)

    amp = VrAmpFF (carrier_ampl)
    fg.connect (sum, amp)
    
    if to_file:
        dst = GrFileSink (sizeof_float, "am_dsb.dat")
        fg.connect (amp, dst)
    else:
        f2c = GrFloatToComplex ()
        dst = GrUsrpSink (which_board, channel_bitmask, interp_rate)
        dst.set_tx_freq (0, station_freq)

        fg.connect (amp, f2c)
        fg.connect (f2c, dst)

    return fg

if __name__ == '__main__':
    to_file = False
    fg = build_graph (to_file)
    fg.start ()                           # fork thread(s) and return immediately
    # your GUI mail loop goes here...
    # fg.wait ();                         # wait (forever)
    raw_input ('Press Enter to quit: ')
    fg.stop ()
