/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRGUPPIBUFFER_H_
#define _VRGUPPIBUFFER_H_

#include <unistd.h>
#include <sys/mman.h>

template<class T> class VrGuppiBuffer;

#include <VrSigProc.h>
#include <VrConnect.h>
#include <VrBuffer.h>
#include <guppi.h>

template<class T> class VrGuppiBuffer : public VrBuffer {
private:
  int guppi_fd;
  unsigned long	bufferSize_bytes;
  virtual void allocateBuffer(unsigned int arg_type_size); 
public:
  VrGuppiBuffer(VrSigProc *m,int gupfd) : VrBuffer(m) {guppi_fd=gupfd; }
};

template<class T> void
VrGuppiBuffer<T>::allocateBuffer(unsigned int arg_type_size)
{
  bufferSize = 0;	// FIXME should allow user to set this somehow
  type_size = arg_type_size;
  if(bufferSize<3*1024*PAGE_SIZE/sizeof(T))
    bufferSize=3*1024*PAGE_SIZE/sizeof(T); //minimum for Guppi

  bufferSize_bytes = bufferSize*sizeof(T);

  //Integral # of pages
  if((bufferSize_bytes % PAGE_SIZE) != 0) {
    bufferSize_bytes = (bufferSize_bytes/PAGE_SIZE + 1) * PAGE_SIZE;

    bufferSize = bufferSize_bytes/sizeof(T);
  }

  if((ioctl(guppi_fd, GIOCSETBUFSIZE, bufferSize_bytes/PAGE_SIZE)) < 0) {
    perror("VrGuppiBuffer(allocateBuffer): Failed to set buffersize");
    exit(-1);
  }

  if((ioctl(guppi_fd, GIOCSTART)) < 0) {
    perror("VrGuppiBuffer(allocateBuffer): start receive failed");
    exit(-1);
  }

  //Find a place big enough for the buffer
  char *start = NULL;
  int fdz = open("/dev/zero",O_RDONLY);
  if((start=(char *) mmap(0,bufferSize_bytes*2,PROT_NONE,MAP_SHARED,fdz,0)) == MAP_FAILED ||
     munmap(start,bufferSize_bytes*2) == -1) {
    perror("Could not allocate mmap memory for guppi buffer");
    exit(-1);
    return;
  }
  close(fdz);

  //MMap the buffer in twice
  if((mmap(start,bufferSize_bytes,PROT_READ,MAP_FIXED|MAP_SHARED,guppi_fd,0)) == MAP_FAILED ||
     (mmap(start+bufferSize_bytes,bufferSize_bytes,PROT_READ,MAP_FIXED|MAP_SHARED,guppi_fd,0)) == MAP_FAILED) {
    perror("Could not mmap Guppi buffer");
    exit(-1);
    return;
  }

  bufferDupStart = ((char *)start) + bufferSize * type_size;
  //  cerr << upstream->name() <<" (guppi)bufferDupStart = "<<(void *) bufferDupStart<<endl; 
} 
#endif 
