/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gr_chunks_to_symbols_bc.h>
#include <gr_io_signature.h>
#include <assert.h>

gr_chunks_to_symbols_bc_sptr
gr_make_chunks_to_symbols_bc (const std::vector<gr_complex> symbol_table)
{
  return gr_chunks_to_symbols_bc_sptr (new gr_chunks_to_symbols_bc (symbol_table));
}

gr_chunks_to_symbols_bc::gr_chunks_to_symbols_bc (const std::vector<gr_complex>symbol_table)
  : gr_sync_block ("chunks_to_symbols_bc",
		   gr_make_io_signature (1, 1, sizeof (unsigned char)),
		   gr_make_io_signature (1, 1, sizeof (gr_complex))),
    d_symbol_table(symbol_table)
{
}

int
gr_chunks_to_symbols_bc::work (int noutput_items,
			gr_vector_const_void_star &input_items,
			gr_vector_void_star &output_items)
{
  const unsigned char *in = (unsigned char *) input_items[0];
  gr_complex *out = (gr_complex *) output_items[0];
  for(int i=0;i<noutput_items;i++) {
    assert (in[i] < d_symbol_table.size());
    out[i]=d_symbol_table[in[i]];		
  }		
  return noutput_items;
}



  
