#!/usr/bin/env python

"""
Read samples from the USRP and write to file formatted as binary
single-precision complex values.

"""

from gnuradio import gr, gru
from gnuradio import usrp
from gnuradio.eng_option import eng_option
from optparse import OptionParser

def main ():
    parser = OptionParser (option_class=eng_option)
    parser.add_option ("-d", "--decim", type="int", default=16,
                       help="set fgpa decimation rate to DECIM")
    parser.add_option ("-c", "--ddc-freq", type="eng_float", default=0,
                       help="set Rx ddc frequency to FREQ", metavar="FREQ")
    parser.add_option ("-m", "--mux", type="intx", default=0x32103210,
                       help="set fpga FR_RX_MUX register to MUX")
    parser.add_option ("-g", "--gain", type="eng_float", default=0,
                       help="set Rx PGA gain in dB (default 0 dB)")
    parser.add_option ("-o", "--output-file", default="usrp_rx.dat",
                       help="write data to FILE", metavar="FILE")
    (options, args) = parser.parse_args ()

    fg = gr.flow_graph ()

    u = usrp.source_c (0, options.decim, 1, gru.hexint(options.mux), 0)
    u.set_rx_freq (0, options.ddc_freq)
    u.set_pga (0, options.gain)
    u.set_pga (1, options.gain)

    dst = gr.file_sink (gr.sizeof_gr_complex, options.output_file)
    fg.connect (u, dst)
    
    fg.start ()
    print 'USB sample rate = %g' % (u.adc_freq () / u.decim_rate (),)
    raw_input ('Press Enter to quit: ')
    fg.stop ()


if __name__ == '__main__':
    main ()

