/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright(C) 2000, 2001 Edgar Denny(e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <ctype.h>

#include "food.h"
#include "load_data.h"
#include "wrap_mysql.h"

/* a list of nutrient numbers. */
static GList *nutr_no_list = NULL;

/* create a list of nutrient numbers. */
static void
create_nutr_no_list()
{
	char *query;

	query = g_strdup( "SELECT nutr_no FROM nutr_def");
	nutr_no_list = get_glist_fields_query_db( query);
}

/* return a list of nutrient numbers. */
GList *
gnutr_get_nutr_no_list()
{
	if ( !nutr_no_list) create_nutr_no_list();

	g_assert( nutr_no_list);
	return nutr_no_list;
}

/* a list of nutrient descriptions. */
static GList *nutr_desc_list = NULL;

/* create a list of nutrient descriptions. */
static void
create_nutr_desc_glist()
{
	char *query;
	nutr_desc_list = NULL;

	query = g_strdup( "SELECT nutr_desc FROM nutr_def");
	nutr_desc_list = get_glist_fields_query_db( query);
	g_free( query);
	g_assert( nutr_desc_list);
}

/* return the list of nutrient descriptions. */
GList *
gnutr_get_nutr_desc_glist()
{
	if ( !nutr_desc_list) create_nutr_desc_glist();

	g_assert( nutr_desc_list);
	return nutr_desc_list;
}

/* a list of the food group descriptions. */
static GList *fd_gp_desc_list = NULL;

/* create the list of food group descriptions. */
static void
create_fd_group_desc_glist()
{
	char *query;
	char *extra;

	query = g_strdup( "SELECT gp_desc FROM fd_group");
	fd_gp_desc_list = get_glist_fields_query_db( query);
	g_free( query);
	g_assert( fd_gp_desc_list);

	/* Prepend the "All Foods" to the list. */
	extra = g_strdup( "All Foods");
	fd_gp_desc_list = g_list_prepend( fd_gp_desc_list, (gpointer)extra);
}

GList *
gnutr_get_fd_group_desc_glist()
{
	if ( !fd_gp_desc_list) create_fd_group_desc_glist();

	g_assert( fd_gp_desc_list);
	return fd_gp_desc_list;
}

/* a hash table where the nutrient description is the key and the
 * nutrient number is the value. */
static GHashTable *nutr_desc_nutr_no_htbl = NULL;

/* create a hash table where the nutrient description is the
 * key and the nutrient number is the value. */
static void
create_htbl_nutr_desc_nutr_no()
{
	GList *list = NULL, *ptr;
	char *query;
	char **pair;

	nutr_desc_nutr_no_htbl = g_hash_table_new( g_str_hash, g_str_equal);

	query = g_strdup( "SELECT nutr_desc, nutr_no FROM nutr_def");
	list = rows_glist_ret_val_query_db( query);
	g_assert( list);
	g_free( query);

	for ( ptr = list; ptr; ptr = ptr->next) {
		pair = (char **)ptr->data;
		g_hash_table_insert( nutr_desc_nutr_no_htbl,
			(gpointer)pair[0], (gpointer)pair[1]);
	}
	g_list_free( list);
}

/* return a hash table where the nutrient description is the key
 * and the nutrient number id the key. */
GHashTable *
get_htbl_nutr_desc_nutr_no()
{
	if ( !nutr_desc_nutr_no_htbl) create_htbl_nutr_desc_nutr_no();

	g_assert( nutr_desc_nutr_no_htbl);
	return nutr_desc_nutr_no_htbl;
}

/* a hash table where the food group description is the key and the
 * food group number is the value. */
static GHashTable *fd_gp_desc_fd_gp_no_htbl = NULL;


/* create a hash table where the food group description is the key and the
 * food group number is the value. */
static void
create_htbl_fd_gp_desc_fd_gp_no()
{
	GList *list = NULL, *ptr;
	char *query;
	char **pair;

	fd_gp_desc_fd_gp_no_htbl = g_hash_table_new( g_str_hash, g_str_equal);

	query = g_strdup( "SELECT gp_desc, fd_gp FROM fd_group");
	list = rows_glist_ret_val_query_db( query);
	g_assert( list);
	g_free( query);

	for ( ptr = list; ptr; ptr = ptr->next) {
		pair = (char **)ptr->data;
		g_hash_table_insert( fd_gp_desc_fd_gp_no_htbl,
			(gpointer)pair[0], (gpointer)pair[1]);
	}
	g_list_free( list);
}

/* return a hash table where the food group description is the key and the
 * food group number is the value. */
GHashTable *
get_htbl_fd_gp_desc_fd_gp_no()
{
	if ( !fd_gp_desc_fd_gp_no_htbl) create_htbl_fd_gp_desc_fd_gp_no();

	g_assert( fd_gp_desc_fd_gp_no_htbl);
	return fd_gp_desc_fd_gp_no_htbl;
}

/* a hash table where the food description is the key and the
 * the food number is the value. */
static GHashTable *fd_desc_fd_no_htbl = NULL;

/* create a hash table where the food description is the key and the
 * the food number is the value. */
static void
create_htbl_fd_desc_fd_no()
{
	GList *list = NULL, *ptr;
	char *query;
	char **pair;

	fd_desc_fd_no_htbl = g_hash_table_new( g_str_hash, g_str_equal);

	query = g_strdup( "SELECT fd_desc, fd_no FROM food_des");
	list = rows_glist_ret_val_query_db( query);
	g_assert( list);
	g_free( query);

	for ( ptr = list; ptr; ptr = ptr->next) {
		pair = (char **)ptr->data;
		g_hash_table_insert( fd_desc_fd_no_htbl,
			(gpointer)pair[0], (gpointer)pair[1]);
	}
	g_list_free( list);
}

/*  return a hash table where the food description is the key and the
 * the food number is the value. */
GHashTable *
get_htbl_fd_desc_fd_no()
{
	if ( !fd_desc_fd_no_htbl) create_htbl_fd_desc_fd_no();

	g_assert( fd_desc_fd_no_htbl);
	return fd_desc_fd_no_htbl;
}

/* a hash table where the food number is the key and the
 * the food description is the value. */
static GHashTable *fd_no_fd_desc_htbl = NULL;

/* create a hash table where the food number is the key and the
 * the food description is the value. */
static void
create_htbl_fd_no_fd_desc()
{
	GList *list = NULL, *ptr;
	char *query;
	char **pair;

	fd_no_fd_desc_htbl = g_hash_table_new( g_str_hash, g_str_equal);

	query = g_strdup( "SELECT fd_no, fd_desc FROM food_des");
	list = rows_glist_ret_val_query_db( query);
	g_assert( list);
	g_free( query);

	for ( ptr = list; ptr; ptr = ptr->next) {
		pair = (char **)ptr->data;
		g_hash_table_insert( fd_no_fd_desc_htbl,
			(gpointer)pair[0], (gpointer)pair[1]);
	}
	g_list_free( list);
}

/*  return a hash table where the food number is the key and the
 * the food number is the value. */
GHashTable *
get_htbl_fd_no_fd_desc()
{
	if ( !fd_no_fd_desc_htbl) create_htbl_fd_no_fd_desc();

	g_assert( fd_no_fd_desc_htbl);
	return fd_no_fd_desc_htbl;
}

/* return a list of measure descriptions for a given food number. */
GList *
gnutr_get_fd_no_msre_desc_list( char *fd_no)
{
	GList *ret_list;
	char *query;

	g_return_val_if_fail( fd_no, NULL);

	query = g_strconcat( "SELECT msre_desc FROM measure, weight ",
		"WHERE weight.fd_no = '", fd_no, "' ",
		"AND measure.msre_no = weight.msre_no", NULL);
	ret_list = get_glist_fields_query_db( query);

	/* prepend the "gm" measure. */
	ret_list = g_list_prepend( ret_list, (gpointer)"gm");

	return ret_list;
}

/* a hash table where the measure description is the key and the
 * the measure number is the value. */
static GHashTable *msre_desc_msre_no_htbl = NULL;

/* a hash table where the measure no is the key and the
 * the measure desc is the value. */
static GHashTable *msre_no_msre_desc_htbl = NULL;

/* create two hash tables which associate between the 
 * measure description and the measure number. */
static void
create_htbl_msre_desc_msre_no()
{
	GList *list = NULL, *ptr;
	char *query;
	char **pair;

	msre_desc_msre_no_htbl = g_hash_table_new( g_str_hash, g_str_equal);
	msre_no_msre_desc_htbl = g_hash_table_new( g_str_hash, g_str_equal);

	query = g_strdup( "SELECT msre_desc, msre_no FROM measure");
	list = rows_glist_ret_val_query_db( query);
	g_assert( list);
	g_free( query);

	for ( ptr = list; ptr; ptr = ptr->next) {
		pair = (char **)ptr->data;
		g_hash_table_insert( msre_desc_msre_no_htbl,
			(gpointer)pair[0], (gpointer)pair[1]);

		g_hash_table_insert( msre_no_msre_desc_htbl,
			(gpointer)pair[1], (gpointer)pair[0]);
	}
	g_hash_table_insert( msre_desc_msre_no_htbl,
		(gpointer)"gm", (gpointer)"99999");
	g_hash_table_insert( msre_no_msre_desc_htbl,
		(gpointer)"99999", (gpointer)"gm");

	g_list_free( list);
}

/* return a hash table where the measure description is the key and the
 * the measure number is the value. */
GHashTable *
get_htbl_msre_desc_msre_no()
{
	if ( !msre_desc_msre_no_htbl) create_htbl_msre_desc_msre_no();

	g_assert( msre_desc_msre_no_htbl);
	return msre_desc_msre_no_htbl;
}

/* return a hash table where the measure nunmber is the key and the
 * the measure description is the value. */
GHashTable *
get_htbl_msre_no_msre_desc()
{
	if ( !msre_no_msre_desc_htbl) create_htbl_msre_desc_msre_no();

	g_assert( msre_no_msre_desc_htbl);
	return msre_no_msre_desc_htbl;
}
