.\" -*- nroff -*-
.TH GTBL @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
gtbl \- table formatter for groff
.SH SYNOPSIS
.B gtbl
[
.B \-Cv
]
[
.IR files \|.\|.\|.
]
.SH DESCRIPTION
.B gtbl
is a preprocessor for
.B groff
for formatting tables.
Normally, it should be invoked using the
.B \-t
option of
.B groff.
It is highly compatible with
.BR tbl .
The output generated by
.B gtbl
cannot be processed with
.BR ditroff ;
it must be processed with
.BR gtroff .
If no files are given on the command line, the standard input
will be read.
A filename of
.B \-
will cause the standard input to be read.
.SH OPTIONS
.TP
.B \-C
Recognize
.B .TS
and
.B .TE
even when followed by a character other than space or newline.
.TP
.B \-v
Print the version number.
.SH USAGE
Only the differences between
.B gtbl
and
.B tbl
are described here.
.LP
The
.B f
format modifier can be followed by an arbitrary length
font name in parentheses.
.LP
There is a
.B d
format modifier which means that a vertically spanning entry
should be aligned at the bottom of its range.
.LP
There is no limit on the number of columns in a table, nor any limit
on the number of text blocks.
All the lines of a table are considered in deciding column
widths, not just the first 200.
Table continuation
.RB ( .T& )
lines are not restricted to the first 200 lines.
.LP
Numeric and alphabetic items may appear in the same column.
.LP
Numeric and alphabetic items may span horizontally.
.LP
.B gtbl
uses register, string, macro and diversion names beginning with
.BR 3 .
When using
.B gtbl
you should avoid using any names beginning with a
.BR 3 .
.SH BUGS
You should use
.BR .TS\ H / .TH
for
.I all
multi-page boxed tables.
If there is no header that you wish to appear at the top of each page
of the table, place the
.B .TH
line immediately after the format section.
Do not enclose a multi-page table within keep/release macros,
or divert it in any other way.
.LP
A text block within a table must be able to fit on one page.
.LP
The
.B bp
request cannot be used to force a page-break in a multi-page table.
Instead, define
.B BP
as follows
.IP
.B .de BP
.br
.B .ie '\e\en(.z'' .bp \e\e$1
.br
.B .el \e!.BP \e\e$1
.br
.B ..
.br
.LP
and use
.B BP
instead of
.BR bp .
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR gtroff (@MAN1EXT@)
