;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2013 Nikita Karetnikov <nikita@karetnikov.org>
;;; Copyright © 2013-2022 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2013, 2014, 2015, 2016, 2019 Andreas Enge <andreas@enge.fr>
;;; Copyright © 2014, 2015 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2014, 2017, 2021, 2022 Eric Bavier <bavier@posteo.net>
;;; Copyright © 2014, 2015 Federico Beffa <beffa@fbengineering.ch>
;;; Copyright © 2015 Omar Radwan <toxemicsquire4@gmail.com>
;;; Copyright © 2015 Pierre-Antoine Rault <par@rigelk.eu>
;;; Copyright © 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2015, 2016, 2020 Christine Lemmer-Webber <cwebber@dustycloud.org>
;;; Copyright © 2015 Eric Dvorsak <eric@dvorsak.fr>
;;; Copyright © 2015, 2016 David Thompson <davet@gnu.org>
;;; Copyright © 2015, 2016, 2017, 2019, 2022 Leo Famulari <leo@famulari.name>
;;; Copyright © 2015, 2017 Ben Woodcroft <donttrustben@gmail.com>
;;; Copyright © 2015, 2016 Erik Edrosa <erik.edrosa@gmail.com>
;;; Copyright © 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2015, 2017, 2020 Kyle Meyer <kyle@kyleam.com>
;;; Copyright © 2015, 2016 Chris Marusich <cmmarusich@gmail.com>
;;; Copyright © 2016 Danny Milosavljevic <dannym+a@scratchpost.org>
;;; Copyright © 2016 Lukas Gradl <lgradl@openmailbox.org>
;;; Copyright © 2016, 2018, 2019, 2021 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2016 Daniel Pimentel <d4n1@d4n1.org>
;;; Copyright © 2016 Sou Bunnbu <iyzsong@gmail.com>
;;; Copyright © 2016, 2017 Troy Sankey <sankeytms@gmail.com>
;;; Copyright © 2016, 2017 Nikita <nikita@n0.is>
;;; Copyright © 2016 Dylan Jeffers <sapientech@sapientech@openmailbox.org>
;;; Copyright © 2016 David Craven <david@craven.ch>
;;; Copyright © 2016-2022 Marius Bakke <marius@gnu.org>
;;; Copyright © 2016, 2017, 2021, 2022 Stefan Reichör <stefan@xsteve.at>
;;; Copyright © 2016, 2017, 2019 Alex Vong <alexvong1995@gmail.com>
;;; Copyright © 2016, 2017, 2018, 2021, 2022 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2016, 2017, 2018, 2020, 2021 Julien Lepiller <julien@lepiller.eu>
;;; Copyright © 2016–2022 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2016, 2017 Thomas Danckaert <post@thomasdanckaert.be>
;;; Copyright © 2017 Carlo Zancanaro <carlo@zancanaro.id.au>
;;; Copyright © 2017 Frederick M. Muriithi <fredmanglis@gmail.com>
;;; Copyright © 2017, 2018 Adriano Peluso <catonano@gmail.com>
;;; Copyright © 2017 Ben Sturmfels <ben@sturm.com.au>
;;; Copyright © 2017, 2018, 2019, 2021, 2022 Mathieu Othacehe <m.othacehe@gmail.com>
;;; Copyright © 2017 José Miguel Sánchez García <jmi2k@openmailbox.org>
;;; Copyright © 2017, 2020, 2021 Roel Janssen <roel@gnu.org>
;;; Copyright © 2017, 2018, 2019 Kei Kebreau <kkebreau@posteo.net>
;;; Copyright © 2017 Rutger Helling <rhelling@mykolab.com>
;;; Copyright © 2017, 2019, 2021 Brendan Tildesley <mail@brendan.scot>
;;; Copyright © 2018 Ethan R. Jones <ethanrjones97@gmail.com
;;; Copyright © 2018 Fis Trivial <ybbs.daans@hotmail.com>
;;; Copyright © 2018 Vijayalakshmi Vedantham <vijimay12@gmail.com>
;;; Copyright © 2018 Mathieu Lirzin <mthl@gnu.org>
;;; Copyright © 2018 Adam Massmann <massmannak@gmail.com>
;;; Copyright © 2016, 2018 Tomáš Čech <sleep_walker@gnu.org>
;;; Copyright © 2018-2022 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2018 Oleg Pykhalov <go.wigust@gmail.com>
;;; Copyright © 2018, 2019, 2021 Clément Lassieur <clement@lassieur.org>
;;; Copyright © 2018, 2019, 2020, 2021, 2022 Maxim Cournoyer <maxim.cournoyer@gmail.com>
;;; Copyright © 2018 Luther Thompson <lutheroto@gmail.com>
;;; Copyright © 2018 Vagrant Cascadian <vagrant@debian.org>
;;; Copyright © 2015, 2018 Pjotr Prins <pjotr.guix@thebird.nl>
;;; Copyright © 2019, 2020 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019 Sam <smbaines8@gmail.com>
;;; Copyright © 2019 Jack Hill <jackhill@jackhill.us>
;;; Copyright © 2019, 2020, 2021, 2022 Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2019, 2020 Alex Griffin <a@ajgrf.com>
;;; Copyright © 2019, 2020, 2021, 2022 Pierre Langlois <pierre.langlois@gmx.com>
;;; Copyright © 2019 Jacob MacDonald <jaccarmac@gmail.com>
;;; Copyright © 2019, 2020, 2021 Giacomo Leidi <goodoldpaul@autistici.org>
;;; Copyright © 2019 Wiktor Żelazny <wzelazny@vurv.cz>
;;; Copyright © 2019, 2020, 2021, 2022 Tanguy Le Carrour <tanguy@bioneland.org>
;;; Copyright © 2019, 2021, 2022 Mădălin Ionel Patrașcu <madalinionel.patrascu@mdc-berlin.de>
;;; Copyright © 2020 Riku Viitanen <riku.viitanen@protonmail.com>
;;; Copyright © 2020 Jakub Kądziołka <kuba@kadziolka.net>
;;; Copyright © 2020 sirgazil <sirgazil@zoho.com>
;;; Copyright © 2020 Sebastian Schott <sschott@mailbox.org>
;;; Copyright © 2020, 2021 Alexandros Theodotou <alex@zrythm.org>
;;; Copyright © 2020 Josh Marshall <joshua.r.marshall.1991@gmail.com>
;;; Copyright © 2020 Lars-Dominik Braun <ldb@leibniz-psychology.org>
;;; Copyright © 2020 Alex ter Weele <alex.ter.weele@gmail.com>
;;; Copyright © 2020, 2022 Matthew James Kraai <kraai@ftbfs.org>
;;; Copyright © 2020 Ryan Prior <rprior@protonmail.com>
;;; Copyright © 2020 Josh Holland <josh@inv.alid.pw>
;;; Copyright © 2020 Yuval Kogman <nothingmuch@woobling.org>
;;; Copyright © 2020, 2022 Michael Rohleder <mike@rohleder.de>
;;; Copyright © 2020, 2021, 2022 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Guy Fleury Iteriteka <gfleury@disroot.org>
;;; Copyright © 2020 Hendursaga <hendursaga@yahoo.com>
;;; Copyright © 2020 Malte Frank Gerdes <malte.f.gerdes@gmail.com>
;;; Copyright © 2020 Joseph LaFreniere <joseph@lafreniere.xyz>
;;; Copyright © 2020 Tim Gesthuizen <tim.gesthuizen@yahoo.de>
;;; Copyright © 2020, 2021 Bonface Munyoki Kilyungi <me@bonfacemunyoki.com>
;;; Copyright © 2020 Ekaitz Zarraga <ekaitz@elenq.tech>
;;; Copyright © 2020 Diego N. Barbato <dnbarbato@posteo.de>
;;; Copyright © 2020 Liliana Marie Prikler <liliana.prikler@gmail.com>
;;; Copyright © 2019 Kristian Trandem <kristian@devup.no>
;;; Copyright © 2020, 2021 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2020 EuAndreh <eu@euandre.org>
;;; Copyright © 2021, 2022 Morgan Smith <Morgan.J.Smith@outlook.com>
;;; Copyright © 2021, 2022 Sharlatan Hellseher <sharlatanus@gmail.com>
;;; Copyright © 2021 Ellis Kenyő <me@elken.dev>
;;; Copyright © 2021 LibreMiami <packaging-guix@libremiami.org>
;;; Copyright © 2021 Xinglu Chen <public@yoctocell.xyz>
;;; Copyright © 2021 Raghav Gururajan <rg@raghavgururajan.name>
;;; Copyright © 2021 jgart <jgart@dismail.de>
;;; Copyright © 2021 Danial Behzadi <dani.behzi@ubuntu.com>
;;; Copyright © 2021 Maxime Devos <maximedevos@telenet.be>
;;; Copyright © 2021 Hugo Lecomte <hugo.lecomte@inria.fr>
;;; Copyright © 2021 Franck Pérignon <franck.perignon@univ-grenoble-alpes.fr>
;;; Copyright © 2021, 2022 Petr Hodina <phodina@protonmail.com>
;;; Copyright © 2021 Simon Streit <simon@netpanic.org>
;;; Copyright © 2021 Daniel Meißner <daniel.meissner-i4k@ruhr-uni-bochum.de>
;;; Copyright © 2021, 2022 Pradana Aumars <paumars@courrier.dev>
;;; Copyright © 2021, 2022 Felix Gruber <felgru@posteo.net>
;;; Copyright © 2021 Sébastien Lerique <sl@eauchat.org>
;;; Copyright © 2021 Raphaël Mélotte <raphael.melotte@mind.be>
;;; Copyright © 2021 ZmnSCPxj <ZmnSCPxj@protonmail.com>
;;; Copyright © 2021 Filip Lajszczak <filip@lajszczak.dev>
;;; Copyright © 2021 Greg Hogan <code@greghogan.com>
;;; Copyright © 2022 John Kehayias <john.kehayias@protonmail.com>
;;; Copyright © 2022 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2022 Evgeny Pisemsky <evgeny@pisemsky.com>
;;; Copyright © 2022 drozdov <drozdov@portalenergy.tech>
;;; Copyright © 2022 Peter Polidoro <peter@polidoro.io>
;;; Copyright © 2022 Wamm K. D. <jaft.r@outlook.com>
;;; Copyright © 2022 Jai Vetrivelan <jaivetrivelan@gmail.com>
;;; Copyright © 2022 Artyom V. Poptsov <poptsov.artyom@gmail.com>
;;; Copyright © 2022 Paul A. Patience <paul@apatience.com>
;;; Copyright © 2022 Jean-Pierre De Jesus DIAZ <me@jeandudey.tech>
;;; Copyright © 2022 Philip McGrath <philip@philipmcgrath.com>
;;; Copyright © 2022 Marek Felšöci <marek@felsoci.sk>
;;; Copyright © 2022 Hilton Chain <hako@ultrarare.space>
;;; Copyright © 2022 Tomasz Jeneralczyk <tj@schwi.pl>
;;; Copyright © 2022 Mathieu Laparie <mlaparie@disr.it>
;;; Copyright © 2022 Garek Dyszel <garekdyszel@disroot.org>
;;; Copyright © 2022 Baptiste Strazzulla <bstrazzull@hotmail.fr>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages python-xyz)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (gnu packages)
  #:use-module (gnu packages algebra)
  #:use-module (gnu packages adns)
  #:use-module (gnu packages aidc)
  #:use-module (gnu packages attr)
  #:use-module (gnu packages backup)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages check)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages dbm)
  #:use-module (gnu packages django)
  #:use-module (gnu packages djvu)
  #:use-module (gnu packages docker)
  #:use-module (gnu packages documentation)
  #:use-module (gnu packages enchant)
  #:use-module (gnu packages file)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages fonts)
  #:use-module (gnu packages freedesktop)
  #:use-module (gnu packages gdb)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages geo)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages graphviz)
  #:use-module (gnu packages graphics)
  #:use-module (gnu packages gsasl)
  #:use-module (gnu packages gstreamer)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages inkscape)
  #:use-module (gnu packages image)
  #:use-module (gnu packages image-processing)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages jupyter)
  #:use-module (gnu packages kerberos)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages libffi)
  #:use-module (gnu packages libidn)
  #:use-module (gnu packages libusb)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages man)
  #:use-module (gnu packages markup)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages monitoring)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages ncurses)
  #:use-module (gnu packages node)
  #:use-module (gnu packages ninja)
  #:use-module (gnu packages openstack)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages photo)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-build)
  #:use-module (gnu packages python-check)
  #:use-module (gnu packages python-compression)
  #:use-module (gnu packages python-crypto)
  #:use-module (gnu packages python-science)
  #:use-module (gnu packages python-web)
  #:use-module (gnu packages qt)
  #:use-module (gnu packages rdf)
  #:use-module (gnu packages readline)
  #:use-module (gnu packages regex)
  #:use-module (gnu packages sdl)
  #:use-module (gnu packages scanner)
  #:use-module (gnu packages search)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages shells)
  #:use-module (gnu packages sphinx)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages swig)
  #:use-module (gnu packages terminals)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages textutils)
  #:use-module (gnu packages time)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages wxwidgets)
  #:use-module (gnu packages base)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg)
  #:use-module (gnu packages xdisorg)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages bdw-gc)
  #:use-module (gnu packages serialization)
  #:use-module (guix packages)
  #:use-module (guix download)
  #:use-module (guix gexp)
  #:use-module (guix git-download)
  #:use-module (guix hg-download)
  #:use-module (guix gexp)
  #:use-module (guix utils)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system cmake)
  #:use-module (guix build-system pyproject)
  #:use-module (guix build-system python)
  #:use-module (guix build-system trivial)
  #:use-module (srfi srfi-1)
  #:use-module (srfi srfi-26))

(define-public python-xmldiff
  (package
    (name "python-xmldiff")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xmldiff" version))
       (sha256
        (base32 "0qygxi3z1jwb0471k7bh5gcqf7wqm4xhrkmwhf36gjgjw46a5gh5"))))
    (build-system python-build-system)
    (propagated-inputs (list python-lxml python-six))
    (home-page "https://github.com/Shoobx/xmldiff")
    (synopsis "Creates diffs of XML files")
    (description "This Python tool figures out the differences between two
similar XML files, in the same way the @command{diff} utility does it.")
    (license license:expat)))

(define-public python-janus
  (package
    (name "python-janus")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "janus" version))
       (sha256
        (base32 "030xvl2vghi5ispfalhvch1rl6i2jsy5bf1dgjafa7vifppy04j7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "--cov=janus" "--cov=tests")))))))
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-asyncio))
    (home-page "https://github.com/aio-libs/janus/")
    (synopsis
     "Sync-async queue to interoperate between asyncio tasks and classic threads")
    (description
     "Mixed sync-async queue, supposed to be used for communicating between
classic synchronous (threaded) code and asynchronous (in terms of
@url{https://docs.python.org/3/library/asyncio.html,asyncio}) one.  Like
@url{https://en.wikipedia.org/wiki/Janus,Janus god} the queue object from the
library has two faces: synchronous and asynchronous interface.  Synchronous is
fully compatible with
@url{https://docs.python.org/3/library/queue.html,standard queue},
asynchronous one follows
@url{https://docs.python.org/3/library/asyncio-queue.html,asyncio queue
design}.")
    (license license:asl2.0)))

(define-public python-jupytext
  (package
    (name "python-jupytext")
    (version "1.14.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mwouts/jupytext")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gqpvphrp2ja9ggadx0rrk0sqbpz6kqqg62qqmw4k17469lphc8c"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              ;; some tests fail when HOME=/homeless-shelter.
              (setenv "HOME" "/tmp")
              ;; OSError: [Errno 18] Invalid cross-device link
              (setenv "TMPDIR" "/tmp")
              (when tests?
                (let ((disabled-tests
                       (list "test_create_header_with_set_formats"
                             "test_pre_commit_hook"
                             "test_sync_with_pre_commit_hook")))
                  (invoke "pytest" "-vv" "-k"
                          (string-append "not "
                                         (string-join disabled-tests
                                                      " and not "))))))))))
    (native-inputs
     (list git-minimal
           python-autopep8
           python-black
           python-flake8
           python-gitpython
           python-isort
           python-ipython-genutils
           python-jupyter-server
           python-pre-commit
           python-pytest
           python-pyaml))
    (propagated-inputs
     (list python-markdown-it-py
           python-mdit-py-plugins
           python-nbformat))
    (home-page "https://github.com/mwouts/jupytext")
    (synopsis
     "Jupyter notebooks as Markdown documents, Julia, Python or R scripts")
    (description
     "Jupytext is a plugin for Jupyter that can save Jupyter notebooks as
either Markdown files or scripts in many languages.  Common use cases for
Jupytext are:

@itemize
@item version control on Jupyter Notebooks
@item editing, merging or refactoring notebooks in your favorite text editor
@item applying Q&A checks on notebooks.
@end itemize
")
    (license license:expat)))

(define-public python-logzero
  (package
    (name "python-logzero")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "logzero" version))
       (sha256
        (base32 "10nh186vk6hpnpfycym44gja4fja0jyzw7q8dwimfd1rmv9xswvz"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-pytest-runner))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest")))))))
    (home-page "https://github.com/metachris/logzero")
    (synopsis "Robust and effective logging for Python")
    (description
     "@code{logzero} provides a fully configured Python logger object for
easy logging and rotating to a console or a file.")
    (license license:expat)))

(define-public python-logbook
  (package
    (name "python-logbook")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Logbook" version))
       (sha256
        (base32 "1s1gyfw621vid7qqvhddq6c3z2895ci4lq3g0r1swvpml2nm9x36"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'cythonize-sources
           (lambda _
             (with-directory-excursion "logbook"
               (invoke "cython" "_speedups.pyx"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Check cython build also
               (setenv "CYBUILD" "True")
               (invoke "pytest" "--cov=logbook" "-r" "s" "tests")))))))
    (native-inputs
     (list python-cython python-mock python-pytest python-pytest-cov
           python-brotli))
    (home-page "https://github.com/getlogbook/logbook")
    (synopsis "Logbook is a logging replacement for Python")
    (description
     "Logbook is a logging system for Python that replaces the standard
library’s logging module.  It was designed with both complex and simple
applications in mind and the idea to make logging fun.")
    (license license:bsd-3)))

(define-public python-ubelt
  (package
    (name "python-ubelt")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Erotemic/ubelt")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0hac9nqqvqfbca2s4g0mp1fnj0ah60bg9fb8234ibna3jww8qs33"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (setenv "HOME" "/tmp") ;else the test suite hangs
                     (invoke "pytest" "-vv" "-k"
                             (string-append
                              ;; The builder user home doesn't match HOME,
                              ;; which causes this test to fail.
                              "not userhome "
                              ;; This one pointlessly tries
                              ;; locating various binaries on
                              ;; the path.
                              "and not find_exe"))))))))
    (propagated-inputs (list python-ordered-set))
    (native-inputs
     (list python-pytest
           python-requests
           python-xdoctest))
    (home-page "https://github.com/Erotemic/ubelt")
    (synopsis "Python library for hashing, caching, timing and more")
    (description "Ubelt is a small library of simple functions that extend the
Python standard library.  It includes an @acronym{API, Application Programming
Interface} to simplify common problems such as caching, timing, computing
progress, among other things.")
    (license license:asl2.0)))

(define-public python-ueberzug
  (package
    (name "python-ueberzug")
    (version "18.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ueberzug" version))
       (sha256
        (base32
         "1hxd45dnwa9yv908acarr98n2drmar66wzq9z2qd3irj24srzr3w"))))
    (build-system python-build-system)
    (inputs
     (list libx11 libxext))
    (propagated-inputs
     (list python-attrs python-docopt python-pillow python-xlib))
    (home-page "https://github.com/seebye/ueberzug")
    (synopsis "Command line util to display images in combination with X11")
    (description "Überzug is a command line util which draws images on
terminals by using child windows.  The advantages of using Überzug are:
@itemize
@item No race conditions as a new window is created to display images.
@item Expose events will be processed, so images will be redrawn on switch
workspaces.
@item Tmux support (excluding multi pane windows).
@item Terminals without the WINDOWID environment variable are supported.
@item Chars are used as position - and size unit.
@item No memory leak (/ unlimited cache).
@end itemize")
    (license license:gpl3+)))

(define-public python-fire
  (package
    (name "python-fire")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fire" version))
       (sha256
        (base32
         "0qka44n88y3qcj7xz0k0f3qb4phcg4z0wvd4jcii9lcr6rvbiqn5"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest")))))))
    (inputs
     (list python-six python-termcolor))
    (synopsis "Library for automatically generating command line interfaces")
    (description
     "Fire is a library for automatically generating command line interfaces
from absolutely any Python object.  The following are the advantages:
@itemize
@item A simple way to create a CLI in Python.
@item A helpful tool for developing and debugging Python code.
@item Helps with exploring existing code or turning other people's code into a
command line interface.
@item Makes transitioning between Bash and Python easier.
@item Makes using a Python REPL easier by setting up the REPL with the modules
and variables you'll need already imported and created.
@end itemize")
    (home-page "https://github.com/google/python-fire")
    (license license:asl2.0)))

(define-public python-dotmap
  (package
    (name "python-dotmap")
    (version "1.3.30")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dotmap" version))
              (sha256
               (base32
                "0s5kb2v7jd0narz6m6jcicak3h5pw290wz21cdsv8pq77y9sf8aq"))))
    (build-system python-build-system)
    (home-page "https://github.com/drgrib/dotmap")
    (synopsis "Ordered, dynamically-expandable dot-access dictionary")
    (description
     "DotMap is a dot-access dictionary subclass that has dynamic
hierarchy creation, can be initialized with keys, can be initialized from a
dictionary, can be convert to a dictionary, and is ordered by insertion.")
    (license license:expat)))

(define-public python-twodict
  (package
    (name "python-twodict")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "twodict" version))
       (sha256
        (base32 "0ifv7dv18jn2lg0a3l6zdlvmmlda2ivixfjbsda58a2ay6kxznr0"))))
    (build-system python-build-system)
    (home-page "https://github.com/MrS0m30n3/twodict")
    (synopsis "Two way ordered dictionary for Python")
    (description "TwoDict is a custom dictionary in which you can get the
key:value relationship but you can also get the value:key relationship.  It also
remembers the order in which the items were inserted and supports almost all the
features of the Python's built-in dict.")
    (license license:unlicense)))

(define-public python-argopt
  (package
   (name "python-argopt")
   (version "0.7.0")
   (source (origin
            (method url-fetch)
            (uri (pypi-uri "argopt" version))
            (sha256
             (base32
              "0ybs7kkp0cpl8zn1lvf7481xhssg1bbhh5la2cjzdm5yibashyxa"))))
   (build-system python-build-system)
   (native-inputs
    (list python-coverage python-nose python-setuptools ; Won't build without this.
          python-setuptools-scm))
   (propagated-inputs
    (list python-toml python-flake8))
   (home-page "https://github.com/casperdcl/argopt")
   (synopsis "Generate a command-line interface from a docstring")
   (description "This package provides tools to define a command line interface
from a docstring rather than the other way around.")
   (license license:mpl2.0)))

(define-public python-cachetools
  (package
    (name "python-cachetools")
    (version "4.2.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cachetools" version))
              (sha256
               (base32
                "1zqc098gk6y614lxwqd9z2gm8lldgvrpid133pnlm4m048gfvdb1"))))
    (build-system python-build-system)
    (home-page "https://github.com/tkem/cachetools/")
    (synopsis "Extensible memoizing collections and decorators")
    (description "This module provides various memoizing collections and
decorators, including variants of the Python standard library's
@code{lru_cache} function decorator.")
    (license license:expat)))

(define-public python-cobib
  (package
    (name "python-cobib")
    (version "3.5.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cobib" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "16nbrbvascbf6cb7yvn9q793dy8zx703pqrmk3mswib9a19mnx3n"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-beautifulsoup4
           python-bibtexparser
           python-pylatexenc
           python-requests
           python-requests-oauthlib
           python-ruamel.yaml))
    (native-inputs
     (list python-future
           python-pyte
           python-pytest))
    (home-page "https://gitlab.com/mrossinek/cobib")
    (synopsis "Terminal-based bibliography management tool")
    (description
     "@command{cobib} is a command-line based bibliography management tool.
It uses a plain-text database, a location-independent library, and features
git integration, command-line support, and a curses-based TUI.")
    (license license:expat)))

(define-public python-colorful
  (package
    (name "python-colorful")
    (version "0.5.4")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/timofurrer/colorful")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fcz5v8b318a3dsdha4c874jsf3wmcw3f25bv2csixclyzacli98"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage python-flake8 python-pytest))
    (propagated-inputs
     (list python-colorama))
    (home-page "http://github.com/timofurrer/colorful")
    (synopsis "Terminal string styling")
    (description "Colorful provides an array of text styles, that can be used
as functions or string constants to form colored terminal output.")
    (license license:expat)))

(define-public python-yaspin
  (package
    (name "python-yaspin")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "yaspin" version))
       (sha256
        (base32 "1iirah0kydrdp505qnjj6gi54avcr7z0hbkfx9vmh8myr30rpz6q"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/pavdmyt/yaspin")
    (synopsis "Yet Another Terminal Spinner")
    (description "Yaspin provides a terminal spinner to indicate the progress
during long operations.")
    (license license:expat)))

(define-public python-lunr
  (package
    (name "python-lunr")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "lunr" version))
       (sha256
        (base32 "106akalywfmnypzkdrhgz4n4740a8xayspybsw59kq06vz8i2qrc"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock python-pytest))
    (propagated-inputs
     (list python-nltk-3.4))
    (home-page
     "https://github.com/yeraydiazdiaz/lunr.py")
    (synopsis "Full-text search library")
    (description "This package provides python library for full-text search.
It indexes documents and provides a search interface for retrieving documents
that best match text queries.")
    (license license:expat)))

(define-public python-mdit-py-plugins
  (package
    (name "python-mdit-py-plugins")
    (version "0.3.1")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/executablebooks/mdit-py-plugins")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "00ybbfb6dzn9q5qnvnm8bmhd84s215ik7pcdb4r35zhwiv2ikizz"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-markdown-it-py
           python-attrs))
    (native-inputs
     (list python-coverage
           python-flit-core
           python-pytest
           python-pytest-cov
           python-pytest-regressions))
    (home-page "https://github.com/executablebooks/mdit-py-plugins")
    (synopsis "Collection of plugins for markdown-it-py")
    (description "This package contains a collection of plugins for
@code{markdown-it-py} like:
@enumerate
@item amsmath,
@item attrs,
@item container,
@item definition list,
@item dollarmath,
@item field list,
@item footnote,
@item textmath, and
@item wordcount.
@end enumerate")
    (license license:expat)))

(define-public python-mdurl
  (package
    (name "python-mdurl")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/executablebooks/mdurl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0csc777q42jzv4zgdzxmwp8xqlb92ws1jvj09m2smh4klw67q5f3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit python-pytest))
    (home-page "https://github.com/executablebooks/mdurl")
    (synopsis "Markdown URL utilities")
    (description
     "This package implements a Python port of the JavaScript @code{mdurl}.")
    (license license:expat)))

(define-public python-mrkd
  (package
    (name "python-mrkd")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "mrkd" version))
        (sha256
          (base32 "1bvaqbna1ihb4y2mv9pmvqcq3r9j6lwbbii99dani8lxx4dqqvs5"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-jinja2 python-mistune python-pygments))
    (home-page "https://pypi.org/project/mrkd/")
    (synopsis "Python Markdown implementation")
    (description
     "@code{mrkd} writes man pages using Markdown, and convert them to Roff or
HTML")
    (license license:bsd-3)))

(define-public python-mkdocs
  (package
    (name "python-mkdocs")
    (version "1.3.0")
    (source
     (origin
       ;; The tests suite appears to be incomplete in the PyPI archive.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mkdocs/mkdocs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1n5rdllrxvhnxmdrddf55p3s86dakx0rq2gg6bj6pr6jg2pn932b"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Requirements refer to a specific version of dependencies,
         ;; which are too old. So we patch to refer to any later version.
         (add-after 'unpack 'patch-requirements
           (lambda _
             (substitute* "setup.py"
               (("==") ">="))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "unittest"
                       "discover" "-p" "*tests.py" "mkdocs"
                       "--top-level-directory" ".")))))))
    (propagated-inputs
     (list python-babel
           python-click
           python-ghp-import
           python-importlib-metadata
           python-jinja2
           python-markdown
           python-markupsafe
           python-mdx-gh-links
           python-mergedeep
           python-packaging
           python-pyyaml
           python-pyyaml-env-tag
           python-watchdog))
    (home-page "https://www.mkdocs.org")
    (synopsis "Project documentation with Markdown")
    (description "MkDocs is a static site generator geared towards building
project documentation.  Documentation source files are written in Markdown, and
configured with a single YAML configuration file.")
    (license license:bsd-3)))

(define-public python-mkdocs-markdownextradata-plugin
  (package
    (name "python-mkdocs-markdownextradata-plugin")
    (version "0.2.5")
    (source (origin
       ;; Use git, as there are some test files missing from the PyPI release,
       ;; see https://github.com/rosscdh/mkdocs-markdownextradata-plugin/issues/41.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/rosscdh/mkdocs-markdownextradata-plugin")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1a3868s9m7pzyfncpjbjsa9vw5nihssl2v47pxj7h6qa67kvlk3g"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (propagated-inputs (list python-mkdocs python-pyyaml))
    (home-page "https://github.com/rosscdh/mkdocs-markdownextradata-plugin/")
    (synopsis "Inject mkdocs.yml extra variables into the MkDocs markdown
template")
    (description
     "This package provides a MkDocs plugin that injects the mkdocs.yml extra
variables into the markdown template")
    (license license:expat)))

(define-public python-pymdown-extensions
  (package
    (name "python-pymdown-extensions")
    (version "8.1.1")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "pymdown-extensions" version))
       (sha256
        (base32 "0d8pdndrl1kj105lq7r6kw2dnhcvll6h2qs07w71mcpi7gx728v3"))))
    (build-system python-build-system)
    ;; FIXME: "AssertionError: False is not true"
    (arguments
     `(#:tests? #f))
    (propagated-inputs
     (list python-markdown))
    (home-page "https://github.com/facelessuser/pymdown-extensions")
    (synopsis "Extension pack for Python Markdown")
    (description "PyMdown Extensions is a collection of extensions for Python
Markdown.  All extensions are found under the module namespace of pymdownx.")
    (license license:expat)))

(define-public python-plotille
  (package
    (name "python-plotille")
    (version "4.0.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "plotille" version))
              (sha256
               (base32
                "0fvsk6glxfphhqy405h05rj3v95jd1byl5hv2fyd5l31wln23shj"))))
    (build-system python-build-system)
    (native-inputs (list python-six))
    (home-page "https://github.com/tammoippen/plotille")
    (synopsis "Plot in the terminal using braille dots")
    (description
     "Plotille provides a figure class and graphing functions to create plots,
scatter plots, histograms and heatmaps in the terminal using braille dots.")
    (license license:expat)))

(define-public python-mdx-gh-links
  (package
    (name "python-mdx-gh-links")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mdx_gh_links" version))
       (sha256
        (base32 "167k1jbp3jifxbnlpi6wy0z1skam7gqv2sixb5bhggb2vypqvysr"))))
    (build-system python-build-system)
    (arguments (list #:tests? #f))      ;tests connect github
    (propagated-inputs (list python-markdown))
    (home-page "https://github.com/Python-Markdown/github-links/")
    (synopsis "Python-Markdown extension adding support for shorthand links")
    (description "This package is an extension to Python-Markdown which adds
support for shorthand links to GitHub users, repositories, issues and
commits.")
    (license license:bsd-3)))

(define-public python-mkdocs-material
  (package
    (name "python-mkdocs-material")
    (version "7.1.3")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "mkdocs-material" version))
       (sha256
        (base32 "0ci9xiasq9nfn09v11m7p49vzazdbgslw7rpzjd6y3hsmn9vljz3"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Requirement mkdocs-material-extensions
         ;; in-turn requires mkdocs-material. This causes
         ;; circular dependency, so we remove this requirement.
         (add-after 'unpack 'patch-requirements
           (lambda _
             (substitute* "requirements.txt"
               (("mkdocs-material-extensions.*$") "")))))))
    (propagated-inputs
     (list python-markdown python-mkdocs python-pygments
           python-pymdown-extensions))
    (home-page "https://squidfunk.github.io/mkdocs-material/")
    (synopsis "Material Design theme for MkDocs")
    (description "This package provides a theme plugin for the static site
generator MkDocs.")
    (license license:expat)))

(define-public python-slixmpp
  (package
    (name "python-slixmpp")
    (version "1.5.2")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://lab.louiz.org/poezio/slixmpp.git")
         (commit
          (string-append "slix-" version))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "15mqxcws14bjvh5jcfwl86zsvrymkdw3ya07vb44md7vfnsnclwx"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch
           (lambda _
             (substitute* "setup.py"
               (("'CC', 'cc'")
                "'CC', 'gcc'"))
             #t)))))
    (native-inputs
     `(("cython" ,python-cython)
       ("gnupg" ,gnupg)
       ("pkg-config" ,pkg-config)))
    (propagated-inputs
     (list python-aiodns python-aiohttp python-pyasn1
           python-pyasn1-modules))
    (inputs
     (list libidn python)) ; We are building a Python extension.
    (synopsis "XMPP library without threads")
    (description "Slixmpp is a XMPP library for Python 3.7+.  It is a fork of
SleekXMPP.  Its goal is to only rewrite the core of the library (the low level
socket handling, the timers, the events dispatching) in order to remove all
threads.")
    (home-page "https://lab.louiz.org/poezio/slixmpp")
    (license license:expat)))

(define-public python-tenacity
  (package
    (name "python-tenacity")
    (version "8.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "tenacity" version))
              (sha256
               (base32
                "0bwkvjpjfyi9dgszzad9aww2vc00w3bczjnbifi92cp7wch2l923"))))
    (build-system python-build-system)
    (native-inputs
     (list python-setuptools-scm python-tornado python-typeguard
           python-pytest))
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda _ (invoke "pytest" "-vv"))))))
    (home-page "https://github.com/jd/tenacity")
    (synopsis "Retrying library for python")
    (description "Tenacity is a general-purpose python library to simplify the
task of adding retry behavior to just about anything.")
    (license license:asl2.0)))

(define-public python-pytelegrambotapi
  (package
    (name "python-pytelegrambotapi")
    (version "3.7.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eternnoir/pyTelegramBotAPI")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r7g5zs0fk3g2dxvbpl0pi730x7r2kalrhn30fs0pvc15a59fmxz"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (with-directory-excursion "tests"
                 (invoke "py.test")))
             #t)))))
    (propagated-inputs
     (list python-requests))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/eternnoir/pyTelegramBotAPI")
    (synopsis "Python Telegram bot api")
    (description "This package provides a simple, but extensible Python
implementation for the Telegram Bot API.")
    (license license:gpl2)))

(define-public python-colorlog
  (package
    (name "python-colorlog")
    (version "6.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorlog" version))
       (sha256
        (base32 "1s7x0v872h8aks8xp01wmv6hzisxqjrh1svbbcycir0980h76krl"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/borntyping/python-colorlog")
    (synopsis "Log formatting with colors for python")
    (description "The @code{colorlog.ColoredFormatter} is a formatter for use
with Python's logging module that outputs records using terminal colors.")
    (license license:expat)))

(define-public python-pyprind
  (package
    (name "python-pyprind")
    (version "2.11.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PyPrind" version))
              (sha256
               (base32
                "1gscnlvj37m421ch3akm3kddxqkrgbg5zrpwy2ky1j59w6vclzg3"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-psutil))
    (home-page "https://github.com/rasbt/pyprind")
    (synopsis "Python Progress Bar and Percent Indicator Utility")
    (description "The PyPrind (Python Progress Indicator) module provides a
progress bar and a percentage indicator object that let you track the progress
of a loop structure or other iterative computation.")
    (license license:bsd-3)))

(define-public python-glymur
  (package
    (name "python-glymur")
    (version "0.12.0")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/quintusdias/glymur")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03nny8k42yxdyw7sjv43szmg23x3rqplbaf7m0a0lpvwla1dl78i"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-library-locations
            (lambda* (#:key inputs #:allow-other-keys)
              ;; XXX: It's a workaround for Python inability to find the
              ;; .so libraries with ctypes.util.find_library()
              (substitute* '("glymur/config.py")
                (("path = find_library\\(libname\\)")
                 (string-append
                  "if libname == \"openjp2\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libopenjp2.so") "\"\n"
                  "    elif libname == \"tiff\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libtiff.so") "\"\n"
                  "    elif libname == \"c\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libc.so.6") "\"\n")))))
          (add-before 'check 'disable-failing-tests
            (lambda _
              ;; Failing test due to inability of
              ;; ctypes.util.find_library() to determine library path,
              ;; which is patched above.
              (delete-file "tests/test_config.py"))))))
    (native-inputs
     (list python-pytest))
    (inputs
     (list openjpeg  ; glymur/lib/openjp2.py
           libtiff)) ; glymur/lib/tiff.py
    (propagated-inputs
     (list python-lxml
           python-numpy
           python-packaging))
    (home-page "https://github.com/quintusdias/glymur")
    (synopsis "Python interface to OpenJPEG and LibTIFF")
    (description
     "This package provides Python interface to the OpenJPEG library which
allows one to read and write JPEG 2000 files")
    (license license:expat)))

(define-public python-gphoto2
  (package
    (name "python-gphoto2")
    (version "2.2.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gphoto2" version))
              (sha256
               (base32
                "118zm25c8mlajfl0pzssnwz4b8lamj9dgymla9rn4nla7l244a0r"))))
    (build-system python-build-system)
    (native-inputs
     (list pkg-config))
    (inputs
     (list libgphoto2))
    (home-page "https://github.com/jim-easterbrook/python-gphoto2")
    (synopsis "Python interface to libgphoto2")
    (description "@code{python-gphoto2} is a comprehensive Python interface
(or binding) to @code{libgphoto2}.  It is built using @code{SWIG} to
automatically generate the interface code.")
    (license license:gpl3+)))

(define-public python-colour
  (package
    (name "python-colour")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "colour" version))
              (sha256
               (base32
                "1visbisfini5j14bdzgs95yssw6sm4pfzyq1n3lfvbyjxw7i485g"))))
    (build-system python-build-system)
    (native-inputs
     (list python-d2to1))
    (home-page "https://github.com/vaab/colour")
    (synopsis "Convert and manipulate various color representations")
    (description "Pythonic way to manipulate color representations (HSL, RVB,
web, X11, ...).")
    (license license:expat)))

(define-public python-d2to1
  (package
    (name "python-d2to1")
    (version "0.2.12.post1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "d2to1" version))
              (sha256
               (base32
                "09fq7pq1z8d006xh5z75rm2lk61v6yn2xhy53z4gsgibhqb2vvs9"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/embray/d2to1")
    (synopsis "Allows for distutils2-like setup.cfg files as package metadata
in python")
    (description "The python package d2to1 (the d is for distutils) allows
using distutils2-like setup.cfg files for a package's metadata with a
distribute/setuptools setup.py script.")
    (license license:bsd-2)))

(define-public python-rawkit
  (package
    (name "python-rawkit")
    (version "0.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rawkit" version))
              (sha256
               (base32
                "0vrhrpr70i61y5q5ysk341x1539ff1q1k82g59zq69lv16s0f76s"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock))
    (inputs
     (list libraw))
    (home-page "https://rawkit.readthedocs.io")
    (synopsis "Ctypes-based LibRaw binding for Python")
    (description "The rawkit package provides two modules:  rawkit and libraw.
The rawkit module provides a high-level Pythonic interface for developing raw
photos, while the libraw module provides a CTypes based interface for
interacting with the low-level LibRaw C APIs.")
    (license license:expat)))

(define-public python-easygui
  (package
    (name "python-easygui")
    (version "0.98.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "easygui" version))
              (sha256
               (base32
                "1zmvmwgxyzvm83818skhn8b4wrci4kmnixaax8q3ia5cn7xrmj6v"))))
    (build-system python-build-system)
    (propagated-inputs
     (list `(,python "tk")))
    (home-page "https://github.com/robertlugg/easygui")
    (synopsis "GUI programming module for Python")
    (description "EasyGUI is a module for very simple, very easy GUI
programming in Python.  EasyGUI is different from other GUI generators in that
EasyGUI is NOT event-driven.  Instead, all GUI interactions are invoked by
simple function calls.")
    (license license:bsd-3)))

(define-public python-pymd4c
  (package
    (name "python-pymd4c")
    (version "0.4.6.0b1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymd4c" version))
       (sha256
        (base32 "07s3arn85ri92im6x3ipljdmrxmpik7irs06i6lm17j1x6j9841d"))))
    (build-system python-build-system)
    (inputs
     (list md4c))
    (native-inputs
     (list python-flake8 python-pkgconfig pkg-config))
    (home-page "https://github.com/dominickpastore/pymd4c")
    (synopsis "Python bindings for MD4C")
    (description
     "PyMD4C provides Python bindings for MD4c, a C Markdown parser, compliant
to CommonMark.")
    (license license:expat)))

(define-public python-pymediainfo
  (package
    (name "python-pymediainfo")
    (version "4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymediainfo" version))
       (sha256
        (base32
         "0mhpxs7vlqx8w75z93dy7nnvx89kwfdjkla03l19an15rlyqyspd"))))
    (build-system python-build-system)
    (native-inputs
     (list python-setuptools-scm python-pytest))
    (inputs
     (list libmediainfo))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-libmediainfo
           (lambda _
             (substitute* "pymediainfo/__init__.py"
               (("libmediainfo.so.0")
                (search-input-file %build-inputs
                                   "/lib/libmediainfo.so.0")))))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               ;; Skip the only failing test "test_parse_url" because it tries
               ;; to access the internet.
               (invoke "pytest" "-vv" "-k" "not test_parse_url")))))))
    (home-page
     "https://github.com/sbraz/pymediainfo")
    (synopsis
     "Python wrapper for the mediainfo library")
    (description
     "This package provides a Python wrapper for the mediainfo library to
access the technical and tag data for video and audio files.")
    (license license:expat)))

(define-public python-psutil
  (package
    (name "python-psutil")
    (version "5.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "psutil" version))
       (sha256
        (base32 "0p1bf6ndcssqh0ic828ggwhzhm67mzj3ffq6043v0fvc1fhn3f7y"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: some tests do not return and time out.  Some tests fail because
     ;; some processes survive kill().
     '(#:tests? #f))
    (home-page "https://github.com/giampaolo/psutil")
    (synopsis "Library for retrieving information on running processes")
    (description
     "@code{psutil} (Python system and process utilities) is a library for
retrieving information on running processes and system utilization (CPU,
memory, disks, network) in Python.  It is useful mainly for system monitoring,
profiling and limiting process resources and management of running processes.
It implements many functionalities offered by command line tools such as: ps,
top, lsof, netstat, ifconfig, who, df, kill, free, nice, ionice, iostat,
iotop, uptime, pidof, tty, taskset, pmap.")
    (license license:bsd-3)))

(define-public python-shapely
  (package
    (name "python-shapely")
    (version "1.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Shapely" version))
       (sha256
        (base32 "130rqd0czi128wm5pdn47v4m6czxd7pkzanbya8q48gsm8ffb5d1"))))
    (build-system python-build-system)
    (native-inputs
     (list python-cython python-matplotlib python-pytest
           python-pytest-cov))
    (inputs
     (list geos))
    (propagated-inputs
     (list python-numpy))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-geos-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((geos (assoc-ref inputs "geos"))
                   (glibc (assoc-ref inputs ,(if (%current-target-system)
                                                 "cross-libc" "libc"))))
               (substitute* '("shapely/geos.py" "shapely/_buildcfg.py")
                 (("_lgeos = load_dll\\('geos_c', fallbacks=.*\\)")
                  (string-append "_lgeos = load_dll('geos_c', fallbacks=['"
                                 geos "/lib/libgeos_c.so'])"))
                 (("free = load_dll\\('c'\\)\\.free")
                  (string-append "free = load_dll('c', fallbacks=['"
                                 glibc "/lib/libc.so.6']).free"))
                 (("free = load_dll\\('c', fallbacks=.*\\)\\.free")
                  (string-append "free = load_dll('c', fallbacks=['"
                                 glibc "/lib/libc.so.6']).free"))))
             #t)))))
    (home-page "https://github.com/Toblerity/Shapely")
    (synopsis "Library for the manipulation and analysis of geometric objects")
    (description "Shapely is a Python package for manipulation and analysis of
planar geometric objects.  It is based on the @code{GEOS} library.")
    (license license:bsd-3)))

(define-public python-shortuuid
  (package
    (name "python-shortuuid")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shortuuid" version))
       (sha256
        (base32
         "1f8i4zwj5vmpzbz6b17bljy4399gx5aq7vsyw63sz2qgyjcd73yh"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pep8))
    (home-page "https://github.com/skorokithakis/shortuuid")
    (synopsis "Generator library for concise, unambiguous and URL-safe UUIDs")
    (description
     "@code{shortuuid} is a Python library for generating concise, unambiguous
and URL-safe UUIDs.  UUIDs are generated using the built-in Python @code{uuid}
module and then similar looking characters are removed.")
    (license license:bsd-3)))

(define-public python-logwrap
  (package
    (name "python-logwrap")
    (version "8.2.0.post0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "logwrap" version))
       (sha256
        (base32
         "1dv7gny3rfci5cal2ipr6d0pcz3yhka7af96dfsd3ir1mxy8p1j9"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f  ; Tests not included in pypi release.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest"))
             #t)))))
    (native-inputs
     (list python-cython python-pytest python-setuptools-scm python-toml
           python-wheel))
    (home-page "https://github.com/python-useful-helpers/logwrap")
    (synopsis "Decorator for logging function arguments")
    (description "This package provides a decorator to log function arguments
and function call return values in a human-readable way.")
    (license license:asl2.0)))

(define-public python-clyent
  (package
    (name "python-clyent")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "clyent" version))
       (sha256
        (base32
         "1r9987qmy1pz3hq54160bapqsywpq14waw4w9x3ly8hmq7kpgfbj"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock))
    (home-page "https://github.com/Anaconda-Platform/clyent")
    (synopsis "Command line client library")
    (description "Clyent is a Python command line utility library.  It is used
by @code{binstar}, @code{binstar-build}, and @code{chalmers}.")
    (license license:bsd-3)))

(define-public python-babel
  (package
    (name "python-babel")
    (version "2.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Babel" version))
       (sha256
        (base32
         "0l9cvfmsz0hlvcinxaf6xf2f02ldgw3xq9i1fc7lk5zf24vma53n"))))
    (build-system python-build-system)
    (native-inputs
     (list python-freezegun python-pytest tzdata-for-tests))
    (propagated-inputs
     (list python-pytz))
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest" "-vv"))))))
    (home-page "https://babel.pocoo.org/")
    (synopsis
     "Tools for internationalizing Python applications")
    (description
     "Babel is composed of two major parts:
- tools to build and work with gettext message catalogs
- a Python interface to the CLDR (Common Locale Data Repository), providing
access to various locale display names, localized number and date formatting,
etc.")
    (license license:bsd-3)))

(define-public python-bidict
  (package
    (name "python-bidict")
    (version "0.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bidict" version))
       (sha256
        (base32
         "02dy0b1k7qlhn7ajyzkrvxhyhjj0hzcq6ws3zjml9hkdz5znz92g"))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage
           python-hypothesis
           python-pre-commit
           python-py
           python-pytest
           python-pytest-benchmark
           python-pytest-cov
           python-setuptools-scm
           python-sortedcollections
           python-sortedcontainers
           python-sphinx
           python-sphinx-autodoc-typehints
           python-tox))
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'relax-reqs
                    (lambda _
                      (substitute* "setup.py"
                        (("sortedcollections < 2") "sortedcollections"))
                      #t))
                  (replace 'check
                    (lambda _ (invoke "./run_tests.py"))))))
    (home-page "https://bidict.readthedocs.io")
    (synopsis "Bidirectional mapping library")
    (description "The @code{bidict} library provides several data structures
for working with bidirectional mappings in Python.")
    (license license:mpl2.0)))

(define-public python-bip39
  (package
    (name "python-bip39")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bip39" version))
       (sha256
        (base32 "18m7d3gi7vj2zi0bl1z7m0nhcj6i8j9vj4vil276siagnpkv64ry"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/de-centralized-systems/python-bip39/")
    (synopsis "Self-contained and simple BIP39 implementation in Python")
    (description
     "This package provides a self-contained and simple BIP39
implementation written in Python.  It includes a @code{bip39.py} executable.

BIP39 is a standardized mapping between binary data (the @emph{entropy}),
and a list of words that are easier to remember for humans (the
@emph{mnemonic}).")
    (license license:expat)))

(define-public python-bitarray
  (package
    (name "python-bitarray")
    (version "1.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bitarray" version))
              (sha256
               (base32
                "177fj6wbw5jln54wpp6plcqy2329wjkwqwvgz7022rrg3xfrq49g"))))
    (build-system python-build-system)
    (home-page "https://github.com/ilanschnell/bitarray")
    (synopsis "Efficient arrays of booleans")
    (description "This package provides an object type which efficiently
represents an array of booleans.  Bitarrays are sequence types and behave very
much like usual lists.  Eight bits are represented by one byte in a contiguous
block of memory.  The user can select between two representations:
little-endian and big-endian.  All of the functionality is implemented in C.
Methods for accessing the machine representation are provided.  This can be
useful when bit level access to binary files is required, such as portable
bitmap image files.  Also, when dealing with compressed data which uses
variable bit length encoding, you may find this module useful.")
    (license license:psfl)))

(define-public python-boolean.py
  (package
    (name "python-boolean.py")
    (version "3.6")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bastikr/boolean.py")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wc89y73va58cj7dsx6c199zpxsy9q53dsffsdj6zmc90inqz6qs"))))
    (build-system python-build-system)
    (home-page "https://github.com/bastikr/boolean.py")
    (synopsis "Boolean algebra in one Python module")
    (description
     "This is a small Python library that implements boolean algebra.
It defines two base elements, @code{TRUE} and @code{FALSE}, and a
@code{Symbol} class that can take on one of these two values.  Calculations
are done only in terms of @code{AND}, @code{OR}, and @code{NOT}---other
compositions like @code{XOR} and @code{NAND} are emulated on top of them.
Expressions are constructed from parsed strings or directly in Python.")
    (license license:bsd-2)))

(define-public python-hdf4
  (package
   (name "python-hdf4")
   (version "0.9")
   (source
    (origin
      (method url-fetch)
      (uri (pypi-uri name version))
      (sha256
       (base32
        "1hjiyrxvxk9817qyqky3nar4y3fs4z8wxz0n884zzb5wi6skrjks"))))
   (build-system python-build-system)
   (native-inputs `(("nose" ,python-nose)))
   (propagated-inputs `(("numpy" ,python-numpy)))
   (inputs
    `(("hdf4" ,hdf4)
      ("libjpeg" ,libjpeg-turbo)
      ("zlib" ,zlib)))
   (arguments
    `(#:phases
      (modify-phases %standard-phases
        (replace 'check
          (lambda _
            (invoke "./runexamples.sh")
            (invoke "nosetests" "-v"))))))
   (home-page "https://github.com/fhs/python-hdf4")
   (synopsis "Python interface to the NCSA HDF4 library")
   (description
    "Python-HDF4 is a python wrapper around the NCSA HDF version 4 library,
which implements the SD (Scientific Dataset), VS (Vdata) and V (Vgroup) API’s.
NetCDF files can also be read and modified.  Python-HDF4 is a fork of
@url{http://hdfeos.org/software/pyhdf.php,pyhdf}.")
   (license license:expat)))

(define-public python-h5netcdf
  (package
    (name "python-h5netcdf")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "h5netcdf" version))
       (sha256
        (base32 "1b2dcgf5rwy7pb7hr4prkc5vgcw9qc2was20dmnj90lbrpx08rvp"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv" "h5netcdf/tests")))))))
    (native-inputs
     (list python-netcdf4
           python-pytest
           python-setuptools-scm))
    (propagated-inputs
     (list python-h5py python-packaging))
    (home-page "https://h5netcdf.org")
    (synopsis "Python interface for the netCDF4 file-format based on h5py")
    (description "This package provides Python interface for the netCDF4
file-format that reads and writes local or remote HDF5 files directly via h5py
or h5pyd, without relying on the Unidata netCDF library")
    (license license:bsd-3)))

(define-public python-h5py
  (package
    (name "python-h5py")
    (version "3.6.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "h5py" version))
      (sha256
       (base32
        "0afv805vqrm5071g7alwv41920nhh8kjv4m5nbia9awj9a0x4ll7"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; no test target
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-hdf5-paths
          (lambda* (#:key inputs #:allow-other-keys)
            (setenv "HDF5_DIR" (assoc-ref inputs "hdf5")))))))
    (propagated-inputs
     (list python-six python-numpy))
    (inputs
     (list hdf5-1.10))
    (native-inputs
     (list python-cython python-pkgconfig pkg-config))
    (home-page "https://www.h5py.org/")
    (synopsis "Read and write HDF5 files from Python")
    (description
     "The h5py package provides both a high- and low-level interface to the
HDF5 library from Python.  The low-level interface is intended to be a
complete wrapping of the HDF5 API, while the high-level component supports
access to HDF5 files, datasets and groups using established Python and NumPy
concepts.")
    (license license:bsd-3)))

(define-public python-hnswlib
  (package
    (name "python-hnswlib")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hnswlib" version))
       (sha256
        (base32 "0wf1cwmxmdzfqmfhrkqdxb5spf21ylgl2bidswhzjrqhwf35c9qf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-native-optimization
           (lambda _
             (substitute* "setup.py"
               ((", '-march=native'") "")))))))
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list pybind11))
    (home-page "https://github.com/nmslib/hnswlib")
    (synopsis "Fast approximate nearest neighbor search")
    (description "Hnswlib is a header-only C++ implementation of fast
approximate nearest neighbor search with Python bindings.")
    (license license:asl2.0)))

(define-public python-pylatexenc
  (package
    (name "python-pylatexenc")
    (version "2.10")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pylatexenc" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ls09z47b5md71gkxcj7fd87ynpvv2walgp2w6z31p26xf2gvn1x"))))
    (build-system python-build-system)
    (home-page "https://github.com/phfaist/pylatexenc")
    (synopsis "LaTeX parser for Unicode/LaTeX conversion")
    (description
     "@code{python-pylatexenc} is a LaTeX parser providing LaTeX-to-Unicode and
Unicode-to-LaTeX conversion.")
    (license license:expat)))

(define-public python-pyls-black
  (package
    (name "python-pyls-black")
    (version "0.4.7")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rupert/pyls-black/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bkhfnlik89j3yamr20br4wm8975f20v33wabi2nyxvj10whr5dj"))
       ;; Patch to work with python-lsp-server.  Taken from
       ;; <https://github.com/rupert/pyls-black/pull/37>.
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "setup.cfg"
             (("python-language-server")
              "python-lsp-server"))
           (substitute* '("pyls_black/plugin.py" "tests/test_plugin.py")
             (("pyls_format_document")
              "pylsp_format_document")
             (("pyls_format_range")
              "pylsp_format_range")
             (("from pyls([ \\.])" _ char)
              (string-append "from pylsp" char)))))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"))
    (propagated-inputs
     (list python-black python-lsp-server python-tomli))
    (native-inputs
     (list python-flake8 python-isort python-mypy python-pytest
           python-pytest-runner))
    (home-page "https://github.com/rupert/pyls-black")
    (synopsis "Black plugin for the Python Language Server")
    (description "Black plugin for the Python Language Server.")
    (license license:expat)))

(define-public python-sh
  (package
    (name "python-sh")
    (version "1.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sh" version))
       (sha256
        (base32
         "03gyss1rhj4in7pgysg4q0hxp3230whinlpy1532ljs99lrx0ywx"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; XXX: A Python 2 test fails when HOME=/homeless-shelter.
             (setenv "HOME" "/tmp")
             (invoke "python" "sh.py" "test"))))))
    (native-inputs
     (list python-coverage))
    (home-page "https://github.com/amoffat/sh")
    (synopsis "Python subprocess replacement")
    (description "This package provides a replacement for Python's
@code{subprocess} feature.")
    (license license:expat)))

(define-public python-cftime
  (package
    (name "python-cftime")
    (version "1.5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cftime" version))
       (sha256
        (base32 "0l1a22zlhdpgaisibvvm7dhij4vzfm661rnv00y2snpyqxpdgi3d"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list python-check-manifest
           python-coverage
           python-coveralls
           python-cython
           python-pytest-cov
           python-sphinx
           python-twine
           python-wheel))
    (home-page "https://unidata.github.io/cftime/")
    (synopsis "Library for time handling")
    (description
     "This package provides time-handling functionality that used to be part
of the netcdf4 package before.")
    (license license:expat)))

(define-public python-netcdf4
  (package
    (name "python-netcdf4")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "netCDF4" version))
       (sha256
        (base32
         "0qxs8r1qmsmg760wm5q0wqlcm7hdd3k7cghryw6wvqd3v5rs7vwm"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure-locations
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "HDF5_DIR" (assoc-ref inputs "hdf5"))
             #t)))))
    (native-inputs
     (list python-cython))
    (propagated-inputs
     (list python-numpy python-cftime))
    (inputs
     (list netcdf hdf4 hdf5))
    (home-page "https://github.com/Unidata/netcdf4-python")
    (synopsis "Python/numpy interface to the netCDF library")
    (description "Netcdf4-python is a Python interface to the netCDF C
library.  netCDF version 4 has many features not found in earlier
versions of the library and is implemented on top of HDF5.  This module
can read and write files in both the new netCDF 4 and the old netCDF 3
format, and can create files that are readable by HDF5 clients.  The
API is modelled after @code{Scientific.IO.NetCDF}, and should be familiar
to users of that module.")
    ;; The software is mainly ISC, but includes some files covered
    ;; by the Expat license.
    (license (list license:isc license:expat))))

(define-public python-ncclient
  (package
    (name "python-ncclient")
    (version "0.6.12")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/ncclient/ncclient")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0cb568z5syg6hh0dv813bw7s1mjy7ga5xzxbm9naf4zz2qfdg4js"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-lxml python-paramiko))
    (home-page "https://github.com/ncclient/ncclient")
    (synopsis "Python library for NETCONF clients")
    (description "@code{ncclient} is a Python library that facilitates
client-side scripting and application development around the NETCONF
protocol.")
    (license license:asl2.0)))

(define-public python-ncls
  (package
    (name "python-ncls")
    (version "0.0.65")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ncls" version))
              (sha256
               (base32
                "1wx06xqknd2r98w8z93f47g5dpxzn92kamhj8vkq0nj569hf7cg1"))))
    (build-system python-build-system)
    (propagated-inputs (list python-numpy))
    (home-page "https://github.com/endrebak/ncls")
    (synopsis "Nested containment list data structure")
    (description
     "This package provides a wrapper for the nested containment list data
structure.  It is a static interval-tree that is fast for both construction
and lookups.")
    (license license:bsd-3)))

(define-public python-license-expression
  (package
    (name "python-license-expression")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "license-expression" version))
       (sha256
        (base32 "1g0sgphss8hbi1rpl4avy1nmbixmy9v194xdbvkjgl90vzgy2q3r"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-boolean.py))
    (home-page "https://github.com/nexB/license-expression")
    (synopsis "Apply boolean logic to license expressions")
    (description
     "This Python module defines a tiny language to evaluate and compare
license expressions using boolean logic.  Logical combinations of licenses can
be tested for equality, containment, and equivalence.  They can be normalised
and simplified.  It supports SPDX license expressions as well as other naming
conventions and aliases in the same expression.")
    (license license:gpl2+)))

(define-public python-wand
  (package
    (name "python-wand")
    (version "0.6.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Wand" version))
       (sha256
        (base32 "0mywzs235skwq670c80achrd34kangwy24793k1nij3651zllgrp"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'find-magickwand
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "MAGICK_HOME" (assoc-ref inputs "imagemagick"))
             (setenv "WAND_MAGICK_LIBRARY_SUFFIX" ".Q16"))))))
    (native-inputs
     (list python-pytest))
    (inputs
     (list imagemagick))
    (home-page "https://docs.wand-py.org/")
    (synopsis "MagickWand API binding for Python")
    (description
     "Wand is a ctypes-based binding for ImageMagick's MagickWand library.")
    (license license:expat)))

(define-public python-lockfile
  (package
    (name "python-lockfile")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lockfile" version))
       (sha256
        (base32
         "16gpx5hm73ah5n1079ng0vy381hl802v606npkx4x8nb0gg05vba"))))
    (build-system python-build-system)
    (arguments '(#:test-target "check"))
    (native-inputs
     (list python-pbr))
    (home-page "https://launchpad.net/pylockfile")
    (synopsis "Platform-independent file locking module")
    (description
     "The lockfile package exports a LockFile class which provides a simple
API for locking files.")
    (license license:expat)))

(define-public python-fb-re2
  (package
    (name "python-fb-re2")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/facebook/pyre2")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0snprxdnh3m45r3b0az4v0l28h90ycmfbybzla6xg1qviwv9w1ak"))))
    (build-system python-build-system)
    (inputs
     (list re2))
    (home-page "https://github.com/facebook/pyre2")
    (synopsis "Python wrapper for RE2")
    (description "This package provides a Python extension that wraps Google's
RE2 regular expression library.  It implements many of the features of
Python's built-in @code{re} module with compatible interfaces.")
    (license license:bsd-3)))

(define-public python-filelock
  (package
    (name "python-filelock")
    (version "3.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filelock" version))
       (sha256
        (base32
         "0ngzlvb5j8gqs2nxlp2b0jhzii792h66wsn694qm8kqixr225n0q"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/benediktschmitt/py-filelock")
    (synopsis "Platform independent file lock")
    (description "@code{filelock} contains a single module implementing
a platform independent file lock in Python, which provides a simple way of
inter-process communication.")
    (license license:unlicense)))

(define-public python-semantic-version
  (package
    (name "python-semantic-version")
    (version "2.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "semantic_version" version))
       (sha256
        (base32
         "0m4avx8zdkzc7qglv5zlr54g8yna5vl098drg5396ql7aph2vjyj"))))
    (build-system python-build-system)
    (home-page "https://github.com/rbarrois/python-semanticversion")
    (synopsis "Semantic versioning module for Python")
    (description
     "The @code{semantic_version} class is a small library for handling
@uref{https://semver.org/, semantic versioning} (@dfn{SemVer}) in Python.

It can compare versions, generate a new version that represents a bump in one of
the version levels, and check whether any given string is a proper semantic
version identifier.")
    (license license:bsd-3)))

(define-public python-serpent
  (package
    (name "python-serpent")
    (version "1.28")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "serpent" version))
       (sha256
        (base32 "1arnckykpkvv2qrp49l1k7q5mr5pisswl0rvdx98x8wsl1n361pk"))))
    (build-system python-build-system)
    (native-inputs
     (list python-attrs python-pytz))
    (home-page "https://github.com/irmen/Serpent")
    (synopsis "Serializer for literal Python expressions")
    (description
     "Serpent provides @code{ast.literal_eval()}-compatible object tree
serialization.  It serializes an object tree into bytes (an utf-8 encoded
string) that can be decoded and then passed as-is to @code{ast.literal_eval()}
to rebuild the original object tree.

Because only safe literals are encoded, it is safe to send serpent data to
other machines, such as over the network.")
    (license license:expat)))

(define-public python-setuptools-declarative-requirements
  (package
    (name "python-setuptools-declarative-requirements")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri
             "setuptools-declarative-requirements"
             version))
       (sha256
        (base32
         "1l8zmcnp9h8sp8hsw7b81djaa1a9yig0y7i4phh5pihqz1gdn7yi"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (propagated-inputs
     (list python-toml python-wheel))
    (home-page
     "https://github.com/s0undt3ch/setuptools-declarative-requirements")
    (synopsis "File support for setuptools declarative setup.cfg")
    (description
     "This package provides file support for setuptools declarative
@code{setup.cfg}.")
    (license license:asl2.0)))

;; The setuptools provided by Python 3.9 is too new for Tensorflow.
(define-public python-setuptools-for-tensorflow
  (hidden-package
   (package
     (inherit python-setuptools)
     (version "39.1.0")
     (source (origin
               (inherit (package-source python-setuptools))
               (uri (pypi-uri "setuptools" version ".zip"))
               (sha256
                (base32
                 "1mzdhvfhnv4lggxa8rjl0dzqxvfx377gg5sqs57v89wrp09lwj65"))))
     (arguments
      `(#:tests? #f                     ; tests require vendored resources
        #:phases
        (modify-phases %standard-phases
          (add-after 'unpack 'compatibility-fixes
            (lambda _
              ;; Python 3.9 no longer has HTMLParser
              (substitute* "setuptools/py33compat.py"
                (("html_parser.HTMLParser\\(\\).unescape")
                 "html.unescape"))
              ;; This needs distutils.msvc9compiler
              (delete-file "setuptools/tests/test_msvc.py"))))))
     (native-inputs
      (list python-pytest python-mock python-six)))))

(define-public python-uniseg
  (package
    (name "python-uniseg")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "uniseg" version ".zip"))
       (sha256
        (base32
         "05jsazvz6nbmh6l3v1rph5ydkqn1hzx1pyggdyvgp2qgmgrnmiz2"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; The test suite requires network access.
    (native-inputs
     (list unzip))
    (home-page
     "https://bitbucket.org/emptypage/uniseg-python")
    (synopsis
     "Python library to determine Unicode text segmentations")
    (description
     "Uniseg is a Python package used to determine Unicode text segmentations.
Supported segmentations include:
@enumerate
@item @dfn{Code point} (any value in the Unicode codespace)
@item @dfn{Grapheme cluster} (user-perceived character made of a single or
multiple Unicode code points, e.g. \"G\" + acute-accent)
@item Word break
@item Sentence break
@item Line break
@end enumerate")
    (license license:expat)))

(define-public python-humanfriendly
  (package
    (name "python-humanfriendly")
    (version "8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "humanfriendly" version))
       (sha256
        (base32
         "04ixg8b7p6xc8x8lffhi7wfl77xhszakhd0s6j0cf6a84j8yqlmz"))))
    (build-system python-build-system)
    (arguments
     `(;; XXX: Tests depend on coloredlogs, which in turn depends on humanfriendly.
       #:tests? #f))
    (home-page "https://humanfriendly.readthedocs.io")
    (synopsis "Human-friendly input and output in Python")
    (description
     "The functions and classes in @code{humanfriendly} can be used to make
text interfaces more user-friendly.  It includes tools to parse and format
numbers, file sizes, and timespans, timers for long-running operations, menus
to allow the user to choose from a list of options, and terminal interaction
helpers.")
    (license license:expat)))

(define-public python-textparser
  (package
    (name "python-textparser")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "textparser" version))
       (sha256
        (base32
         "0w5lyhrsvzs5a9q1l3sjgxgljrvd3ybf796w93kc39wayzvd02gh"))))
    (build-system python-build-system)
    (home-page "https://github.com/eerimoq/textparser")
    (synopsis "Fast text parser for Python")
    (description "This library provides a text parser written in the Python
language.  It aims to be fast.")
    (license license:expat)))

(define-public python-aenum
  (package
    (name "python-aenum")
    (version "2.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "aenum" version))
       (sha256
        (base32 "0r1812bjm72x73pl7y4yhffr4zbdjgxa08avsy4b3di0pqgqv0l1"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      ;; We must run the test suite module directly, as it
                      ;; fails to define the 'tempdir' variable in scope for
                      ;; the tests otherwise
                      ;; (see:https://bitbucket.org/stoneleaf/aenum/\
                      ;; issues/32/running-tests-with-python-setuppy-test).
                      (invoke "python3" "aenum/test.py")
                      ;; This one fails with "NameError: name
                      ;; 'test_pickle_dump_load' is not defined" (see:
                      ;; https://bitbucket.org/stoneleaf/aenum/issues/33
                      ;; /error-running-the-test_v3py-test-suite).
                      ;; (invoke "python3" "aenum/test_v3.py")
                      #t)))))
    (home-page "https://bitbucket.org/stoneleaf/aenum")
    (synopsis "Advanced enumerations, namedtuples and constants for Python")
    (description "The aenum library includes an @code{Enum} base class, a
metaclass-based @code{NamedTuple} implementation and a @code{NamedConstant}
class.")
    (license license:bsd-3)))

(define-public python-can
  (package
    (name "python-can")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-can" version))
       (sha256
        (base32
         "0pcbdgdw94lc2sxd56w6wdsshrs9dd5d3wp0x4sfd0drzx32inar"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'relax-version-requirements
                    (lambda _
                      (substitute* "setup.py"
                        (("mock~=2\\.0") "mock")
                        (("coverage<5") "coverage")
                        (("pytest~=4\\.6") "pytest")
                        (("pytest-timeout~=1\\.3") "pytest-timeout")
                        (("pytest-cov.*") "pytest-cov\n")
                        (("hypothesis~=4\\.56") "hypothesis"))))
                  (add-after 'unpack 'fix-broken-tests
                    ;; The tests try to run two scripts it expects should be
                    ;; in PATH, but they aren't at this time (see:
                    ;; https://github.com/hardbyte/python-can/issues/805).
                    (lambda _
                      (substitute* "test/test_scripts.py"
                        (("\"can_logger\\.py --help\"") "")
                        (("\"can_player\\.py --help\"") ""))))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-vv" "test"
                                ;; Disable tests which require specific CAN
                                ;; drivers we have no package for in Guix.
                                "--ignore" "test/test_interface_canalystii.py"
                                ;; These tests fail with "OSError: [Errno 19]
                                ;; No such device".
                                "-k" "not BasicTestUdpMulticastBusIPv")))))))
    (propagated-inputs
     (list python-msgpack python-typing-extensions python-wrapt))
    (native-inputs
     (list python-codecov
           python-coverage
           python-future
           python-hypothesis
           python-mock
           python-parameterized
           python-pyserial
           python-pytest
           python-pytest-cov
           python-pytest-runner
           python-pytest-timeout))
    (home-page "https://github.com/hardbyte/python-can")
    (synopsis "Controller Area Network (CAN) interface module for Python")
    (description "This package defines the @code{can} module, which provides
controller area network (CAN) support for Python developers; providing common
abstractions to different hardware devices, and a suite of utilities for
sending and receiving messages on a CAN bus.")
    (license license:lgpl3+)))

(define-public python-canopen
  (package
    (name "python-canopen")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "canopen" version))
       (sha256
        (base32 "1nb543wb37kj95v6bhh272lm5gkpi41q3pnsl1fxlyizm2gamj5w"))))
    (build-system python-build-system)
    (native-inputs (list python-packaging))
    (propagated-inputs (list python-can))
    (home-page "https://github.com/christiansandberg/canopen")
    (synopsis "CANopen stack implementation")
    (description
     "This package provides a Python implementation of the
@uref{https://www.can-cia.org/canopen/,CANopen standard} for
@acronym{CANs, controller-area networks}.  The aim of the project is to
support the most common parts of the CiA 301 standard in a simple
Pythonic interface.  It is mainly targeted for testing and automation
tasks rather than a standard compliant master implementation.")
    (license license:expat)))

(define-public python-caniusepython3
  (package
    (name "python-caniusepython3")
    (version "7.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "caniusepython3" version))
        (sha256
          (base32
            "0a755444ln38j8d7xb3yw0wzpd0mjrzfn6zqvsh06nw1vdaq4l28"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'relax-requirements
                    (lambda _
                      (substitute* "setup.py"
                        ;; These are for compatibility with Python 2.
                        ((".*'argparse', 'backports.functools_lru_cache',.*")
                         ""))
                      (substitute* "dev_requirements.txt"
                        ((".*pylint.*") "")) ;not actually required
                      #t))
                  (replace 'check
                    (lambda _
                      (invoke "py.test" "-k" "not NetworkTests"))))))
    (propagated-inputs
      (list python-distlib python-packaging python-requests))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://github.com/brettcannon/caniusepython3")
    (synopsis "Check for Python 3-incompatible Python libraries")
    (description "The @command{caniusepython3} command scans your project and
reports the Python 3-incompatible libraries it found.  It can also be used as
a library.")
    (license license:asl2.0)))

(define-public python-diskcache
  (package
    (name "python-diskcache")
    (version "4.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "diskcache" version))
       (sha256
        (base32
         "1q2wz5sj16zgyy1zpq516qgbnfwsavk1pl2qks0f4r62z5cmmvmw"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                   ;test suite not included in the release
    (home-page "http://www.grantjenks.com/docs/diskcache/")
    (synopsis "Disk and file backed cache library")
    (description "DiskCache is a disk and file backed persistent cache.")
    (license license:asl2.0)))

(define-public python-argparse-addons
  (package
    (name "python-argparse-addons")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argparse_addons" version))
       (sha256
        (base32 "1yx54dmnr3xggjcjk6bbdafvzp6cynrakl56wyz3jglmfvk0znpm"))))
    (build-system python-build-system)
    (home-page "https://github.com/eerimoq/argparse_addons")
    (synopsis "Extensions for Python's @code{argparse} library")
    (description "This Python library provides additional types and actions
for the standard @code{argparse} library.")
    (license license:expat)))

(define-public python-bitstruct
  (package
    (name "python-bitstruct")
    (version "8.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bitstruct" version))
       (sha256
        (base32
         "149c73yrqbph71bbyf925r2mbh2jdymqxc6d49lnylpiflf1j313"))))
    (build-system python-build-system)
    (home-page "https://github.com/eerimoq/bitstruct")
    (synopsis "Python values to and C bit field structs converter")
    (description "This module performs conversions between Python values and C
bit field structs represented as Python byte strings.  It is intended to have
a similar interface as the @code{struct} module from Python, but working on
bits instead of primitive data types like @code{char}, @code{int}, etc.")
    (license license:expat)))

(define-public python-cantools
  (package
    (name "python-cantools")
    (version "37.0.7")
    (source
     (origin
       ;; We take the sources from the Git repository as the documentation is
       ;; not included with the PyPI archive.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eerimoq/cantools")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1qcf1fcwif7w70qmhxw2b8kqh420igbinq60p1chzf98xcb0ansx"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'build 'build-doc
            (lambda _
              ;; See: https://github.com/eerimoq/cantools/issues/190.
              (substitute* "README.rst"
                (("https://github.com/eerimoq/cantools/raw/master\
/docs/monitor.png")
                 "monitor.png"))
              (invoke "make" "-C" "docs" "man" "info")))
          (add-after 'install 'install-doc
            (lambda* (#:key outputs #:allow-other-keys)
              (let* ((info (string-append #$output "/share/info"))
                     (man1 (string-append #$output "/share/man/man1")))
                (install-file "docs/_build/texinfo/cantools.info" info)
                (install-file "docs/_build/man/cantools.1" man1)))))))
    (native-inputs (list python-sphinx texinfo))
    (propagated-inputs
     (list python-argparse-addons
           python-bitstruct
           python-can
           python-crccheck
           python-diskcache
           python-matplotlib
           python-parameterized
           python-textparser))
    (home-page "https://github.com/eerimoq/cantools")
    (synopsis "Tools for the Controller Area Network (CAN) bus protocol")
    (description "This package includes Controller Area Network (CAN) related
tools that can be used to:
@itemize
@item parse DBC, KCD, SYM, ARXML 4 and CDD files
@item encode and decode CAN messages
@item multiplex simple and extended signals
@item diagnose DID encoding and decoding
@item dump the CAN decoder output
@item test CAN nodes
@item generate C source code
@item monitor the CAN bus
@end itemize")
    (license license:expat)))

(define-public python-capturer
  (package
    (name "python-capturer")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "capturer" version))
       (sha256
        (base32
         "05d6ji4j8ipiq0br7bwam38qc6hd9l1djmfxlzrxx19ziyjl4089"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (propagated-inputs
     (list python-humanfriendly))
    (home-page "https://capturer.readthedocs.io")
    (synopsis "Capture stdout and stderr streams of the current process")
    (description
     "The capturer package makes it easy to capture the stdout and stderr
streams of the current process and subprocesses.  Output can be relayed
to the terminal in real time but is also available to the Python program
for additional processing.")
    (license license:expat)))

(define-public python-case
  (package
    (name "python-case")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "case" version))
       (sha256
        (base32
         "1cagg06vfph864s6l5jb0zqliwxh647bki8j6lf4a4qrv40jnhs8"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-mock python-nose python-six))
    (native-inputs
     (list python-coverage))
    (home-page "https://github.com/celery/case")
    (synopsis "Unittest utilities and convenience methods")
    (description
     "The @code{case} package provides utilities on top of unittest, including
some helpful Python 2 compatibility convenience methods.")
    (license license:bsd-3)))

(define-public python-verboselogs
  (package
    (name "python-verboselogs")
    (version "1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "verboselogs" version))
       (sha256
        (base32
         "09z4d1jiasn7k1hs5af2ckmnrd0i1d1m04bhfjhv7z6svzfdwgg3"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; Do not run pylint plugin test, as astroid is an old
             ;; unsupported version.
             (invoke "pytest" "-v" "-k" "not test_pylint_plugin"
                     "verboselogs/tests.py"))))))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://verboselogs.readthedocs.io")
    (synopsis "Verbose logging level for Python's logging module")
    (description
     "The @code{verboselogs} package extends Python's @code{logging} module to
add the log levels NOTICE, SPAM, SUCCESS and VERBOSE.")
    (license license:expat)))

(define-public python-coloredlogs
  (package
    (name "python-coloredlogs")
    (version "10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "coloredlogs" version))
       (sha256
        (base32
         "0dkw6xp0r1dwgz4s2f58npx5nxfq51wf4l6qkm5ib27slgfs4sdq"))))
    (build-system python-build-system)
    (arguments
     `(;Tests require some updated modules
       #:tests? #f))
    (propagated-inputs
     (list python-capturer))
    (home-page "https://coloredlogs.readthedocs.io")
    (synopsis "Colored stream handler for Python's logging module")
    (description
     "The @code{coloredlogs} package enables colored terminal output for
Python's logging module.  The @code{ColoredFormatter} class inherits from
@code{logging.Formatter} and uses ANSI escape sequences to render your logging
messages in color.")
    (license license:expat)))

(define-public python-editorconfig
  (package
    (name "python-editorconfig")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "EditorConfig" version))
       (sha256
        (base32
         "0v55z351p9qkyp3bbspwywwn28sbcknhirngjbj779n3z52z63hv"))))
    (build-system python-build-system)
    (home-page "https://editorconfig.org/")
    (synopsis "EditorConfig bindings for python")
    (description "The EditorConfig project consists of a file format for
defining coding styles and a collection of text editor plugins that enable
editors to read the file format and adhere to defined styles.  EditorConfig
files are easily readable and they work nicely with version control systems.")
    ;; "fnmatch.py" and "ini.py" are licensed under psfl, the rest is bsd-2.
    (license (list license:bsd-2 license:psfl))))

(define-public dosage
  (package
    (name "dosage")
    (version "2.17")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dosage" version))
       (sha256
        (base32
         "0vmxgn9wd3j80hp4gr5iq06jrl4gryz5zgfdd2ah30d12sfcfig0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-cached-property
           python-colorama
           python-imagesize
           python-importlib-metadata
           python-lxml
           python-requests
           python-six))
    (native-inputs
     (list python-pytest-cov python-pytest-xdist python-responses
           python-setuptools-scm))
    (home-page "https://github.com/webcomics/dosage")
    (synopsis "Comic strip downloader and archiver")
    (description "Dosage is designed to keep a local copy of specific webcomics and other
picture-based content such as Picture of the Day sites.  With the @command{dosage}
command-line script you can get the latest strip of a webcomic, catch-up to the last strip
downloaded, or download a strip for a particular date or index, if possible.")
    (license license:expat)))

(define-public python-et-xmlfile
  (package
    (name "python-et-xmlfile")
    (version "1.1")
    (source
     (origin
       ;; Use a checkout because the PyPI archive does not contain tests.
       (method hg-fetch)
       (uri (hg-reference
             (url "https://foss.heptapod.net/openpyxl/et_xmlfile")
             (changeset version)))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "09r8rjc5bhkqrm5c4n9jrlvad8vrvbyswl9g0wrc1qc7nzh9mpw7"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest python-lxml))   ;used for the tests
    (home-page "https://bitbucket.org/openpyxl/et_xmlfile")
    (synopsis "Low memory implementation of @code{lxml.xmlfile}")
    (description "This Python library is based upon the @code{xmlfile} module
from @code{lxml}.  It aims to provide a low memory, compatible implementation
of @code{xmlfile}.")
    (license license:expat)))

(define-public python-openpyxl
  (package
    (name "python-openpyxl")
    (version "3.0.9")
    (source
     (origin
       ;; We use the upstream repository, as the tests are not included in the
       ;; PyPI releases.
       (method hg-fetch)
       (uri (hg-reference
             (url "https://foss.heptapod.net/openpyxl/openpyxl")
             (changeset version)))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "1p8xvc2gjw6zyzbd7qdvc3x178sm00ymrbyh9539l4fpzgxh0j9c"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest"))))))
    (native-inputs (list python-lxml python-pillow python-pytest))
    (propagated-inputs (list python-et-xmlfile python-jdcal))
    (home-page "https://openpyxl.readthedocs.io")
    (synopsis "Python library to read/write Excel 2010 XLSX/XLSM files")
    (description
     "This Python library allows reading and writing to the Excel XLSX, XLSM,
XLTX and XLTM file formats that are defined by the Office Open XML (OOXML)
standard.")
    (license license:expat)))

(define-public python-eventlet
  (package
    (name "python-eventlet")
    (version "0.33.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "eventlet" version))
       (sha256
        (base32
         "07qlyhcm0f28sxdizawvdf3d50m3hnbzz5kg3fjp7chvki44y540"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dnspython python-greenlet python-monotonic python-six))
    (native-inputs
     (list python-nose))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'avoid-OSError
           (lambda _
             ;; If eventlet tries to load greendns, an OSError is thrown when
             ;; getprotobyname is called.  Thankfully there is an environment
             ;; variable to disable the greendns import, so use it:
             (setenv "EVENTLET_NO_GREENDNS" "yes")))
         (add-after 'unpack 'delete-broken-tests
           (lambda _
             (delete-file "tests/greendns_test.py")
             (delete-file "tests/socket_test.py")))
         ;; See https://github.com/eventlet/eventlet/issues/562#issuecomment-714183009
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "nosetests" "-v" "tests/")))))))
    (home-page "https://eventlet.net")
    (synopsis "Concurrent networking library for Python")
    (description
     "Eventlet is a concurrent networking library for Python that
allows you to change how you run your code, not how you write it.
It uses @code{epoll} or @code{libevent} for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of programming
that is similar to threading, but provide the benefits of non-blocking I/O.
The event dispatch is implicit, which means you can easily use @code{Eventlet}
from the Python interpreter, or as a small part of a larger application.")
    (license license:expat)))

(define-public python-sinfo
  (package
    (name "python-sinfo")
    (version "0.3.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "sinfo" version))
              (sha256
               (base32
                "0kdsp883mx0lfyykv0p12bvs203kdm3skb8bw5wf2pc7kb393sl1"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-stdlib-list))
    (home-page "https://gitlab.com/joelostblom/session_info")
    (synopsis "Output module version information loaded in a Python session")
    (description "This package outputs version information for modules loaded
in the current session, Python, and the OS.")
    (license license:bsd-3)))

(define-public python-six
  (package/inherit python-six-bootstrap
    (name "python-six")
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-v"))))))
    (native-inputs
     `(("python-pytest" ,python-pytest-bootstrap)))))

(define-public python2-six
  (let ((base (package-with-python2 python-six)))
    (package
      (inherit base)
      ;; Reduce Python 2 closure by disabling tests and removing the native
      ;; inputs.
      (arguments (substitute-keyword-arguments (package-arguments base)
                   ((#:phases phases)
                    `(modify-phases ,phases
                       (delete 'check)))))
      (native-inputs '()))))

(define-public python-schedule
  (package
    (name "python-schedule")
    (version "0.4.3")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "schedule" version))
      (sha256
       (base32
        "0vplyjcbfrq50sphlwya749z8p2pcyi2nycw3518i0qpd9a6189i"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock))
    (home-page "https://github.com/dbader/schedule")
    (synopsis "Schedule periodic function calls in Python")
    (description
     "Schedule is an in-process scheduler for periodic jobs that uses the
builder pattern for configuration.  Schedule lets you run Python functions (or
any other callable) periodically at pre-determined intervals using a simple,
human-friendly syntax.")
    (license license:expat)))

(define-public python-scour
  (package
    (name "python-scour")
    (version "0.38.2")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/scour-project/scour")
         (commit
          (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mmfvx4wqp8gkpv0kbih89zfs9njvmd3v4dxfqii62xddpxq0f1k"))))
    (propagated-inputs
     (list python-six))
    (build-system python-build-system)
    (home-page "https://github.com/scour-project/scour")
    (synopsis "Scour is an SVG optimizer/cleaner written in Python")
    (description "The goal of Scour is to output a file that renders
identically at a fraction of the size by removing a lot of redundant
information created by most SVG editors.  Optimization options are typically
lossless but can be tweaked for more aggressive cleaning.")
    (license license:asl2.0)))

(define-public python-mechanize
  (package
    (name "python-mechanize")
    (version "0.4.5")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "mechanize" version))
      (sha256
       (base32
        "1z9kqcwb8gfq2l6i42z624kxpd8692a0c8gw2x5bbm7n848w2mb3"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-html5lib))
    (home-page "https://github.com/python-mechanize/mechanize")
    (synopsis
     "Stateful programmatic web browsing in Python")
    (description
     "Mechanize implements stateful programmatic web browsing in Python,
after Andy Lester’s Perl module WWW::Mechanize.")
    (license license:bsd-3)))

(define-public python-simpleaudio
  (package
    (name "python-simpleaudio")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simpleaudio" version))
       (sha256
        (base32
         "07glihg0fpca0gvbbvqs9q815w8xhflzdvg72yvlsm23j9j8h739"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (inputs
      (list alsa-lib))
    (home-page
     "https://github.com/hamiltron/py-simple-audio")
    (synopsis "Simple, asynchronous audio playback for Python 3")
    (description
     "The @code{simplaudio} package provides cross-platform, dependency-free
audio playback capability for Python 3 on OSX, Windows, and Linux.")
    (license license:expat))) ; MIT license

(define-public python-jsonalias
  (package
    (name "python-jsonalias")
    (version "0.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonalias" version))
              (sha256
               (base32
                "0sd7c3vyvfhhpnan77ax4f0x1whjcb5iz7jhjky7kmcpaf9lvw34"))))
    (build-system python-build-system)
    (arguments (list #:tests? #f)) ; There are no tests.
    (home-page "https://github.com/kevinheavey/jsonalias/")
    (synopsis "JSON type alias for Python")
    (description
     "This package provides a microlibrary that defines a JSON type alias for
Python.")
    (license license:expat)))

(define-public python-simplejson
  (package
    (name "python-simplejson")
    (version "3.17.6")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "simplejson" version))
      (sha256
       (base32
        "19pqqn01y6qmhhv8q6dh4p1acav49kl923kklnns2qxz5a6h766g"))))
    (build-system python-build-system)
    (native-inputs
     (list python-toml))
    (home-page "https://simplejson.readthedocs.io/en/latest")
    (synopsis
     "Json library for Python")
    (description
     "JSON (JavaScript Object Notation) is a subset of JavaScript
syntax (ECMA-262 3rd edition) used as a lightweight data interchange
format.

Simplejson exposes an API familiar to users of the standard library marshal
and pickle modules.  It is the externally maintained version of the json
library contained in Python 2.6, but maintains compatibility with Python 2.5
and (currently) has significant performance advantages, even without using
the optional C extension for speedups.  Simplejson is also supported on
Python 3.3+.")
    (license license:x11)))


(define-public python-pyicu
  (package
    (name "python-pyicu")
    (version "2.9")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "PyICU" version))
      (sha256
       (base32
        "0y2qhh443vydi3y7kmhyb6kz3z6d7qq7ld0sg88mfqalcp7dca9w"))))
    (build-system python-build-system)
    (inputs
     (list icu4c))
    (native-inputs
     (list python-pytest python-six))
    (home-page "https://gitlab.pyicu.org/main/pyicu")
    (synopsis "Python extension wrapping the ICU C++ API")
    (description
     "PyICU is a python extension wrapping the ICU C++ API.")
    (license license:x11)))

(define-public python-dogtail
  (package
    (name "python-dogtail")
    (version "0.9.11")
    (source (origin
             (method url-fetch)
             (uri
              (string-append
               "https://gitlab.com/dogtail/dogtail/-/raw/released/"
               "dogtail-" version ".tar.gz"))
             (sha256
              (base32
               "0sr38z7b2n12bvfd4xw4b5dnnhkn5zl3h0ymmnnzavcihfqia6l0"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f                      ; TODO Launching dbus for the tests
                                        ; fails
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (system "Xvfb :1 &")
               (setenv "DISPLAY" ":1")
               (invoke "dbus-run-session" "--" "nosetests" "-v" "tests/"))
             #t)))))
    (propagated-inputs
     (list python-pygobject python-pycairo python-pyatspi))
    (native-inputs
     `(("python-nose" ,python-nose)
       ("gtk+" ,gtk+)
       ("xvfb" ,xorg-server)
       ("dbus" ,dbus)
       ("gsettings-desktop-schemas" ,gsettings-desktop-schemas)
       ("gobject-introspection" ,gobject-introspection)))
    (home-page "https://gitlab.com/dogtail/dogtail/")
    (synopsis "GUI test tool and automation framework written in Python")
    (description
     "Dogtail is a GUI test tool and automation framework written in Python.
It uses Accessibility (a11y) technologies to communicate with desktop
applications. dogtail scripts are written in Python and executed like any
other Python program.")
    (license license:gpl2+)))

(define-public python-doxyqml
  (package
    (name "python-doxyqml")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "doxyqml" version))
              (sha256
               (base32
                "1f0jjqvamly4hn7f1palvq27z6yr694rfzyxrb6g0ysbbawxkvq9"))))
    (build-system python-build-system)
    (home-page "http://agateau.com/projects/doxyqml")
    (synopsis "Doxygen input filter for QML files")
    (description
     "This package provides a Doxygen input filter for QML files.")
    (license license:bsd-3)))

(define-public python-doxypypy
  (package
    (name "python-doxypypy")
    (version "0.8.8.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "doxypypy" version))
              (sha256
               (base32
                "06z0vbh975g42z5szbfvn9i3bif3xwr5pncqd4fvjzjkbi2p2xb2"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ;no test suite
    (home-page "https://github.com/Feneric/doxypypy")
    (synopsis "Doxygen filter for Python")
    (description
     "This package provides a Doxygen filter for Python.")
    (license license:gpl2+)))

(define-public python-empy
  (package
    (name "python-empy")
    (version "3.3.3")
    (source (origin
             (method url-fetch)
             (uri (string-append "http://www.alcyone.com/software/empy/empy-"
                                 version ".tar.gz"))
             (sha256
              (base32
               "1mxfy5mgp473ga1pgz2nvm8ds6z4g3hdky8523z6jzvcs9ny6hcq"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; python2 only
    (home-page "http://www.alcyone.com/software/empy/")
    (synopsis "Templating system for Python")
    (description
     "EmPy is a system for embedding Python expressions and statements in
template text; it takes an EmPy source file, processes it, and produces
output.  This is accomplished via expansions, which are special signals to the
EmPy system and are set off by a special prefix (by default the at sign, @@).
EmPy can expand arbitrary Python expressions and statements in this way, as
well as a variety of special forms.  Textual data not explicitly delimited in
this way is sent unaffected to the output, allowing Python to be used in
effect as a markup language.  Also supported are callbacks via hooks,
recording and playback via diversions, and dynamic, chainable filters.  The
system is highly configurable via command line options and embedded
commands.")
    (license license:lgpl2.1+)))

(define-public python-parse-type
  (package
    (name "python-parse-type")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "parse_type" version))
       (sha256
        (base32
         "07smqnzc9km7sbvxfyx4gdm9njrx58x8grdw6gs4gva81rk3rd10"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv" "-c" "/dev/null")))))))
    (propagated-inputs (list python-six python-parse))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/jenisys/parse_type")
    (synopsis "Extended parse module")
    (description "Parse_type extends the python parse module.")
    (license license:bsd-3)))

(define-public python-parse
  (package
    (name "python-parse")
    (version "1.18.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "parse" version))
      (sha256
       (base32
        "19063x4xdjpaf7rfxai6jpgm2k4yvkq7wha8aa8cagbjsqr60rli"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "python" "test_parse.py"))))))
    (home-page "https://github.com/r1chardj0n3s/parse")
    (synopsis "Parse strings")
    (description
     "Parse strings using a specification based on the Python @code{format()}
syntax.")
    (license license:x11)))

(define-public python-polib
  (package
    (name "python-polib")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "polib" version))
               (sha256
                (base32
                  "0aikb8gcarhifn3sadrbbs5czagih9hjv250gsrgy9v1d49pvn7s"))))
    (build-system python-build-system)
    (home-page "https://bitbucket.org/izi/polib/wiki/Home")
    (synopsis "Manipulate, create and modify gettext files")
    (description "Polib can manipulate any gettext format (po, pot and mo)
files.  It can be used to create po files from scratch or to modify
existing ones.")
    (license license:expat)))

(define-public python-polling2
  (package
    (name "python-polling2")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "polling2" version))
       (sha256
        (base32 "0hp3238fv6k1qk43gv4jwnv1mwlkmx33akbj560b9nvsry1dmdwh"))))
    (build-system python-build-system)
    (arguments '(#:tests? #false)) ; no tests included
    (native-inputs
     (list python-mock python-pytest python-pytest-runner))
    (home-page "https://github.com/ddmee/polling2")
    (synopsis "Polling utility with many configurable options")
    (description "Polling2 is a utility used to wait for a function to return
a certain expected condition.")
    (license license:expat)))

(define-public python-poyo
  (package
    (name "python-poyo")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poyo" version))
       (sha256
        (base32
         "1pflivs6j22frz0v3dqxnvc8yb8fb52g11lqr88z0i8cg2m5csg2"))))
    (build-system python-build-system)
    (home-page "https://github.com/hackebrot/poyo")
    (synopsis "Lightweight YAML Parser for Python")
    (description
     "This package provides a lightweight YAML Parser for Python.  It supports
only a chosen subset of the YAML format that is required to parse cookiecutter
user configuration files.  It does not have support for serializing into YAML
and is not compatible with JSON.")
    (license license:expat)))

(define-public python-exceptiongroup
  (package
    (name "python-exceptiongroup")
    (version "1.0.0rc8")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/agronholm/exceptiongroup")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0xsbpv22n51p6yvyvz231mf8zhbi1i88b4zmacaxxx31zrq5ifv4"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: PEP 517 manual build/install procedures copied from
          ;; python-isort.
          (replace 'build
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)
              ;; ZIP does not support timestamps before 1980.
              (setenv "SOURCE_DATE_EPOCH" "315532800")
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "tests")))))))
    (native-inputs (list python-flit-scm python-pypa-build python-pytest))
    (home-page "https://github.com/agronholm/exceptiongroup")
    (synopsis "PEP 654 backport from Python 3.11")
    (description "This is a backport of the @code{BaseExceptionGroup} and
@code{ExceptionGroup} classes from Python 3.11.")
    (license license:expat)))

(define-public python-extension-helpers
(package
  (name "python-extension-helpers")
  (version "0.1")
  (source
    (origin
      (method url-fetch)
      (uri (pypi-uri "extension-helpers" version))
      (sha256
        (base32 "10iqjzmya2h4sk765dlm1pbqypwlqyh8rw59a5m9i63d3klnz2mc"))))
  (build-system python-build-system)
  (native-inputs
    (list python-coverage python-pytest-astropy python-pytest-cov
          python-setuptools-scm))
  (home-page "https://github.com/astropy/astropy-helpers")
  (synopsis
   "Utilities for building and installing packages in the Astropy ecosystem")
  (description
    "The extension-helpers package includes many build, installation, and
documentation-related tools used by the Astropy project.")
  (license license:bsd-3)))

(define-public python-extras
  (package
    (name "python-extras")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "extras" version))
       (sha256
        (base32
         "0khvm08rcwm62wc47j8niyl6h13f8w51c8669ifivjdr23g3cbhk"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Circular dependency on testtools.
     '(#:tests? #f))
    (home-page "https://github.com/testing-cabal/extras")
    (synopsis "Useful extensions to the Python standard library")
    (description
     "Extras is a set of extensions to the Python standard library.")
    (license license:expat)))

(define-public python-mimeparse
  (package
    (name "python-mimeparse")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-mimeparse" version))
       (sha256
        (base32
         "0y2g6cl660bpz11srgqyvvm8gmywpgyx8g0xfvbiyr0af0yv1r3n"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "./mimeparse_test.py"))))))
    (home-page
     "https://github.com/dbtsai/python-mimeparse")
    (synopsis "Python library for parsing MIME types")
    (description
     "Mimeparse provides basic functions for parsing MIME type names and
matching them against a list of media-ranges.")
    (license license:expat)))

(define-public python-miniboa
  (package
    (name "python-miniboa")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "miniboa" version))
       (sha256
        (base32
         "002c1aki9hsrwj5plrwdrf3sk8rn95fqylqyjx2arrjfpsih4dgs"))))
    (build-system python-build-system)
    (home-page "https://github.com/shmup/miniboa")
    (synopsis "Simple, single-threaded Telnet server")
    (description
     "Miniboa is a simple, asynchronous, single-threaded, poll-based Telnet
server.")
    (license license:asl2.0)))

(define-public python-pafy
  (package
    (name "python-pafy")
    (version "0.5.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pafy" version))
       (sha256
        (base32
         "1a7dxi95m1043rxx1r5x3ngb66nwlq6aqcasyqqjzmmmjps4zrim"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; Currently pafy can not find itself in the tests
    (propagated-inputs
     ;; Youtube-dl is a python package which is imported in the file
     ;; "backend_youtube_dl.py", therefore it needs to be propagated.
     (list youtube-dl))
    (home-page "https://np1.github.io/pafy/")
    (synopsis "Retrieve YouTube content and metadata")
    (description
     "@code{pafy} is a python library to retrieve YouTube content and metadata.")
    (license license:lgpl3+)))

(define-public python-miniupnpc
  (package
    (name "python-miniupnpc")
    (version "2.2.3")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/miniupnp/miniupnp")
         (commit
          (string-append
           "miniupnpc_" (string-replace-substring version "." "_")))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "03q1rlzvfzm15g1bfw2zqzavlsyaypnaf2k3cz6ha7k5rirkdy0l"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'subdir
            (lambda* (#:key inputs #:allow-other-keys)
              (chdir "miniupnpc")
              (setenv "CC" #$(cc-for-target))
              (substitute* "Makefile"
                (("/bin/sh") (search-input-file inputs "/bin/sh")))))
          (add-before 'subdir 'remove-kernel-version
            ;; Avoid embedding the running kernel version for reproducible builds
            (lambda _
              (substitute*
                  "miniupnpc/updateminiupnpcstrings.sh"
                (("^OS_VERSION=`uname -r`") "OS_VERSION=Guix")))))))
    (inputs (list python))              ;we are building a Python extension
    (synopsis "UPnP client for Python")
    (description "Miniupnpc is a client library for Python programs to set up
port forwards using @acronym{UPnP, Universal Plug and Play}.")
    (home-page "http://miniupnp.free.fr")
    (license license:bsd-3)))

(define-public python-py
  (package
    (name "python-py")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py" version))
       (sha256
        (base32
         "1lqvkqk3b440g9z82gqbzlzas84wrm6ir8kplzhzavmn2pd1pf11"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: "ImportError: 'test' module incorrectly imported from
     ;; '/gnu/store/...-python-pytest-mimimal-3.0.5/lib/python3.5/site-packages'.
     ;; Expected '/tmp/guix-build-python-py-1.4.31.drv-0/py-1.4.31/py'.
     ;; Is this module globally installed?"
     '(#:tests? #f))
    (native-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/pytest-dev/py")
    (synopsis "Python library for parsing, I/O, instrospection, and logging")
    (description
     "Py is a Python library for file name parsing, .ini file parsing, I/O,
code introspection, and logging.")
    (license license:expat)))

;; Recent versions of python-fixtures and python-testrepository need
;; python-pbr for packaging, which itself needs these two packages for
;; testing.
;; To fix this circular dependency, we use a build of python-pbr, based on the
;; same source, just without any test dependencies and with tests disabled.
;; python-pbr-minmal is then used to package python-fixtures and
;; python-testrepository.
;; Strictly speaking we currently could remove the test-requirements from the
;; normal python-pbr package (and save this package) since test are disabled
;; there anyway. But this may change in future.
(define-public python-pbr-minimal
  (package
    (name "python-pbr-minimal")
    (version "5.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pbr" version))
       (sha256
        (base32
         "1j8k5d4rdhy5bw5ai1vkjzln2albah94in3vvyvxa0n42fv81baz"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (home-page "https://docs.openstack.org/pbr/latest/")
    (synopsis "Minimal build of python-pbr used for bootstrapping")
    (description
     "Used only for bootstrapping python2-pbr, you should not need this.")
    (license license:asl2.0)))

(define-public python-pbr
  (package
    (inherit python-pbr-minimal)
    (name "python-pbr")
    (arguments
     `(#:tests? #f)) ;; Most tests seem to use the Internet.
    (propagated-inputs
      (list git)) ;; pbr actually uses the "git" binary.
    (native-inputs
      `(("python-fixtures" ,python-fixtures-bootstrap)
        ;; discover, coverage, hacking, subunit
        ("python-mock" ,python-mock)
        ("python-six" ,python-six)
        ("python-sphinx" ,python-sphinx)
        ("python-testrepository" ,python-testrepository-bootstrap)
        ("python-testresources" ,python-testresources-bootstrap)
        ("python-testscenarios" ,python-testscenarios-bootstrap)
        ("python-testtools" ,python-testtools-bootstrap)
        ("python-virtualenv" ,python-virtualenv)))
    (synopsis "Enhance the default behavior of Python’s setuptools")
    (description
      "Python Build Reasonableness (PBR) is a library that injects some useful
and sensible default behaviors into your setuptools run.  It will set
versions, process requirements files and generate AUTHORS and ChangeLog file
from git information.
")))

(define-public python-pyrsistent
  (package
    (name "python-pyrsistent")
    (version "0.16.0")
    (home-page "https://github.com/tobgu/pyrsistent")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyrsistent" version))
              (sha256
               (base32
                "1lrsjgblnapfimd0alsi1as5nz2lfqv97131l7d6anbjzq2rjri8"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  ;; The package works fine with newer Pytest and Hypothesis, but
                  ;; has pinned older versions to stay compatible with Python 2.
                  (add-before 'check 'loosen-pytest-requirement
                    (lambda _
                      (substitute* "setup.py"
                        (("pytest<5") "pytest")
                        (("hypothesis<5") "hypothesis"))
                      #t)))))
    (native-inputs
     (list python-hypothesis python-pytest python-pytest-runner))
    (propagated-inputs
     (list python-six))
    (synopsis "Persistent data structures for Python")
    (description
     "Pyrsistent is a number of persistent collections (by some referred to as
functional data structures).  Persistent in the sense that they are immutable.

All methods on a data structure that would normally mutate it instead return a
new copy of the structure containing the requested updates.  The original
structure is left untouched.")
    (license license:expat)))

(define-public python-exif-read
  (package
    (name "python-exif-read")
    (version "2.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ExifRead" version))
              (sha256
               (base32
                "1b90jf6m9vxh9nanhpyvqdq7hmfx5iggw1l8kq10jrs6xgr49qkr"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ; no tests
    (home-page "https://github.com/ianare/exif-py")
    (synopsis "Python library to extract EXIF data from image files")
    (description
     "ExifRead is a Python library to extract EXIF data from tiff and jpeg
files.")
    (license license:bsd-3)))

(define-public python-pyld
  (package
    (name "python-pyld")
    (version "1.0.5")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PyLD" version))
              (sha256
               (base32
                "1ywbdbsrkg533qh8xn9ifjh2mvam6v5msrjyqq73jfpvcp89qvff"))))
    (build-system python-build-system)
    (home-page "https://github.com/digitalbazaar/pyld")
    (synopsis "Python implementation of the JSON-LD specification")
    (description
     "PyLD is an implementation of the JSON-LD specification.")
    (license license:bsd-3)))

(define-public python-cli-helpers
  (package
    (name "python-cli-helpers")
    (version "2.2.1")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dbcli/cli_helpers")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hzavh9v9lkd1dn9f0nvg80f7v4banxvcrj10zy72przqz51k1sb"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-wcwidth python-configobj python-tabulate))
    (home-page "https://github.com/dbcli/cli_helpers")
    (synopsis "Helpers for building command-line apps")
    (description
     "CLI Helpers is a Python package that makes it easy to perform common
tasks when building command-line apps.  It's a helper library for command-line
interfaces.")
    (license license:bsd-3)))

(define-public python-click
  (package
    (name "python-click")
    (version "8.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click" version))
       (sha256
        (base32
         "13kvp8visj5xh9d43brnda6q0kc1s40flxa5cw0p0a9hzf5dr0kn"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (home-page "https://palletsprojects.com/p/click/")
    (synopsis "Command line library for Python")
    (description
     "Click is a Python package for creating command line interfaces in a
composable way with as little code as necessary.  Its name stands for
\"Command Line Interface Creation Kit\".  It's highly configurable but comes
with sensible defaults out of the box.")
    (license license:bsd-3)))

(define-public python-click-7
  (package (inherit python-click)
    (name "python-click")
    (version "7.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click" version))
       (sha256
        (base32 "06kbzd6sjfkqan3miwj9wqyddfxc2b6hi7p5s4dvqjb3gif2bdfj"))))
    (arguments `())))

(define-public python-click-5
  (package (inherit python-click)
    (name "python-click")
    (version "5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click" version))
       (sha256
        (base32 "0njsm0wn31l21bi118g5825ma5sa3rwn7v2x4wjd7yiiahkri337"))))
    (arguments `())))

(define-public python-cligj
  (package
    (name "python-cligj")
    (version "0.7.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "cligj" version))
        (sha256
          (base32
            "09vbkik6kyn6yrqzl2r74vaybjk8kjykvi975hy3fsrm4gb17g54"))))
    (build-system python-build-system)
    (propagated-inputs
      (list python-click))
    (native-inputs
      (list python-pytest-cov))
    (home-page "https://github.com/mapbox/cligj")
    (synopsis "Click params for command line interfaces to GeoJSON")
    (description
      "cligj is for Python developers who create command line interfaces
for geospatial data.  cligj allows you to quickly build consistent,
well-tested and interoperable CLIs for handling GeoJSON.")
    (license license:bsd-3)))

(define-public python-vcversioner
  (package
    (name "python-vcversioner")
    (version "2.16.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "vcversioner" version))
       (sha256
        (base32
         "16z10sm78jd7ca3jbkgc3q5i8a8q7y1h21q1li21yy3rlhbhrrns"))))
    (build-system python-build-system)
    (synopsis "Python library for version number discovery")
    (description "Vcversioner is a Python library that inspects tagging
information in a variety of version control systems in order to discover
version numbers.")
    (home-page "https://github.com/habnabit/vcversioner")
    (license license:isc)))

(define-public python-jdcal
  (package
    (name "python-jdcal")
    (version "1.4.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jdcal" version))
        (sha256
          (base32
            "1j6g19jf21qprjsr8h0r7nsbss366gy8j9izq8cz53gbjvh74a27"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/phn/jdcal")
    (synopsis "Functions to convert between Julian dates Gregorian dates")
    (description "This Python library provides functions for converting
between Julian dates and Gregorian dates.")
    (license license:bsd-2)))

(define-public python-jsondiff
  (package
   (name "python-jsondiff")
   (version "1.2.0")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "jsondiff" version))
     (sha256
      (base32
       "00v3689175aqzdscrxpffm712ylp8jvcpqdg51ca22ni6721p51l"))))
   (build-system python-build-system)
   (native-inputs
    (list python-nose python-nose-random))
   (home-page
    "https://github.com/fzumstein/jsondiff")
   (synopsis "Compare JSON and JSON-like structures in Python")
   (description "@code{jsondiff} is a Python library which lets you
compare, diff, and patch JSON and JSON-like structures in Python.")
   (license license:expat)))

(define-public python-jsonschema
  (package
    (name "python-jsonschema")
    (version "3.2.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "jsonschema" version))
             (sha256
              (base32
               "0ykr61yiiizgvm3bzipa3l73rvj49wmrybbfwhvpgk3pscl5pa68"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (setenv "JSON_SCHEMA_TEST_SUITE" "json")
               (invoke "trial" "jsonschema")))))))
    (native-inputs
     `(("python-setuptools_scm" ,python-setuptools-scm)
       ("python-twisted" ,python-twisted)))
    (propagated-inputs
     (list python-attrs python-pyrsistent python-six))
    (home-page "https://github.com/Julian/jsonschema")
    (synopsis "Implementation of JSON Schema for Python")
    (description
     "Jsonschema is an implementation of JSON Schema for Python.")
    (license license:expat)))

;;; TODO: Make the default python-jsonschema on core-updates
(define-public python-jsonschema-next
  (package
    (inherit python-jsonschema)
    (version "4.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema" version))
       (sha256
        (base32 "1z0x22691jva7lwfcfh377jdmlz68zhiawxzl53k631l34k8hvbw"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-jsonschema)
       ((#:phases phases)
        #~(modify-phases #$phases
            ;; XXX: PEP 517 manual build/install procedures copied from
            ;; python-isort.
            (replace 'build
              (lambda _
                ;; ZIP does not support timestamps before 1980.
                (setenv "SOURCE_DATE_EPOCH" "315532800")
                (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
            (replace 'install
              (lambda* (#:key outputs #:allow-other-keys)
                (let ((whl (car (find-files "dist" "\\.whl$"))))
                  (invoke "pip" "--no-cache-dir" "--no-input"
                          "install" "--no-deps" "--prefix" #$output whl))))))))
    (native-inputs (list python-pypa-build
                         python-setuptools-scm
                         python-twisted))
    (propagated-inputs
     (list python-attrs
           python-importlib-metadata
           python-pyrsistent
           python-typing-extensions))))

(define-public python-schema
  (package
    (name "python-schema")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "schema" version))
       (sha256
        (base32
         "1lw28j9w9vxyigg7vkfkvi6ic9lgjkdnfvnxdr7pklslqvzmk2vm"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/keleshev/schema")
    (synopsis "Simple data validation library")
    (description
     "@code{python-schema} is a library for validating Python data
structures, such as those obtained from config-files, forms, external
services or command-line parsing, converted from JSON/YAML (or
something else) to Python data-types.")
    (license license:psfl)))

(define-public python-schema-0.5
  (package (inherit python-schema)
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "schema" version))
       (sha256
        (base32
         "10zqvpaky51kgb8nd42bk7jwl8cn2zvayxjpdc1wwmpybj92x67s"))))))

(define-public python-kitchen
  (package
    (name "python-kitchen")
    (version "1.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kitchen" version))
       (sha256
        (base32
         "1zakh6l0yjvwic9p0nkvmbidpnkygkxbigh2skmb5gccyrhbp7xg"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-chardet))
    (home-page "https://github.com/fedora-infra/kitchen")
    (synopsis "Python API for snippets")
    (description "@code{kitchen} module provides a python API for all sorts of
little useful snippets of code that everybody ends up writing for their projects
but never seem big enough to build an independent release.  Use kitchen and stop
cutting and pasting that code over and over.")
    (license (list license:lgpl2.1+
                   ;; subprocess.py, test_subprocess.py,
                   ;; kitchen/pycompat25/defaultdict.py:
                   license:psfl))))

(define-public python-roman
  (package
    (name "python-roman")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "roman" version))
       (sha256
        (base32
         "0gyp2bmw47jgpm8j64gydzqq838bgxz5gh6cm57lxlr7p26sqiic"))))
    (build-system python-build-system)
    (home-page "https://github.com/zopefoundation/roman")
    (synopsis "Integer to Roman numerals converter")
    (description
     "This package provides a small helper library to convert Arabic Numbers
to Roman Numerals.")
    (license license:psfl)))

(define-public python-unidecode
  (package
    (name "python-unidecode")
    (version "1.1.1")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "Unidecode" version))
             (sha256
              (base32
               "1s6cp2lv4m0f00hjckjz8p6m7d3n3v16jvg353llf5ia1iqsnsib"))))
    (build-system python-build-system)
    (home-page "https://pypi.org/project/Unidecode/")
    (synopsis "ASCII transliterations of Unicode text")
    (description
     "Unidecode provides ASCII transliterations of Unicode text.  Unidecode is
useful when integrating with legacy code that doesn't support Unicode, or for
ease of entry of non-Roman names on a US keyboard, or when constructing ASCII
machine identifiers from human-readable Unicode strings that should still be
somewhat intelligible.")
    (license license:gpl2+)))

(define-public python-text-unidecode
  (package
    (name "python-text-unidecode")
    (version "1.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "text-unidecode" version))
              (sha256
               (base32
                "14xb99fdv52j21dsljgsbmbaqv10ps4b453p229r29sdn4xn1mms"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/kmike/text-unidecode/")
    (synopsis "Decode Unicode data")
    (description
     "@code{text-unidecode} is a basic Python port of the @code{Text::Unidecode}
Perl library.  It can create ASCII representations of Unicode data.  In general
users should prefer the @code{python-unidecode} package which offers better
memory usage and transliteration quality.")
    ;; The user can choose either license.
    (license (list license:clarified-artistic license:gpl2+))))

(define-public python-pyjwt
  (package
    (name "python-pyjwt")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyJWT" version))
       (sha256
        (base32
         "1fmbcwfw1463wjzwbcgg3s16rad6kfb1mc5y7jbkp6v9ihh0hafl"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-cryptography python-pytest))
    (home-page "https://github.com/progrium/pyjwt")
    (synopsis "JSON Web Token implementation in Python")
    (description
     "PyJWT is a JSON Web Token implementation written in Python.")
    (license license:expat)))

(define-public python-pymsgbox
  (package
    (name "python-pymsgbox")
    (version "1.0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              ;; LICENSE.txt is not present on pypi
              (url "https://github.com/asweigart/PyMsgBox")
              (commit "55926b55f46caa969c5ddb87990ebea2737bd66f")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0zy7rjfpwlrd8b64j7jk2lb8m2npc21rnpwakpfvwgl4nxdy80rg"))))
    (arguments
     ;; Circular dependency to run tests:
     ;; Tests need pyautogui, which depends on pymsgbox.
     '(#:tests? #f))
    (build-system python-build-system)
    (home-page "https://github.com/asweigart/PyMsgBox")
    (synopsis "Python module for JavaScript-like message boxes")
    (description
     "PyMsgBox is a simple, cross-platform, pure Python module for
JavaScript-like message boxes.  Types of dialog boxes include:
@enumerate
@item alert
@item confirm
@item prompt
@item password
@end enumerate
")
    (license license:bsd-3)))

(define-public python-pympler
  (package
    (name "python-pympler")
    (home-page "https://pythonhosted.org/Pympler/")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Pympler" version))
              (sha256
               (base32
                "1ynkqpv2akldmvkll5vh5zhwj433s1d59iv0f76lygyak4silgwr"))))
    (build-system python-build-system)
    (synopsis "Measure, monitor and analyze memory behavior")
    (description
     "Pympler is a development tool to measure, monitor and analyze
the memory behavior of Python objects in a running Python application.

By pympling a Python application, detailed insight in the size and the
lifetime of Python objects can be obtained.  Undesirable or unexpected
runtime behavior like memory bloat and other @samp{pymples} can easily
be identified.

A web profiling frontend exposes process statistics, garbage
visualisation and class tracker statistics.")
    (license license:asl2.0)))

(define-public python-itsdangerous
  (package
    (name "python-itsdangerous")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "itsdangerous" version))
       (sha256
        (base32
         "1w6gfb2zhbcmrfj6digwzw1z68w6zg1q87rm6la2m412zil4swly"))))
    (build-system python-build-system)
    (home-page "https://palletsprojects.com/p/itsdangerous/")
    (synopsis "Python library for passing data to/from untrusted environments")
    (description
     "Itsdangerous provides various helpers to pass trusted data to untrusted
environments and back.")
    (license license:bsd-3)))

(define-public python-pyyaml
  (package
    (name "python-pyyaml")
    (version "6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyYAML" version))
       (sha256
        (base32
         "18imkjacvpxfgg1lbpraqywx3j7hr5dv99d242byqvrh2jf53yv8"))))
    (build-system python-build-system)
    (inputs
     (list libyaml python-cython))
    (home-page "https://pyyaml.org")
    (synopsis "YAML parser and emitter for Python")
    (description
     "PyYAML is a YAML parser and emitter for Python.  PyYAML features a
complete YAML 1.1 parser, Unicode support, pickle support, capable extension
API, and sensible error messages.  PyYAML supports standard YAML tags and
provides Python-specific tags that represent an arbitrary Python object.")
    (license license:expat)))

(define-public python-pyyaml-5
  (package
    (inherit python-pyyaml)
    (version "5.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyYAML" version))
       (sha256
        (base32
         "0pm440pmpvgv5rbbnm8hk4qga5a292kvlm1bh3x2nwr8pb5p8xv0"))))))

(define-public python-vine
  (package
    (name "python-vine")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "vine" version))
       (sha256
        (base32 "0zk3pm0g7s4qfn0gk28lfmsyplvisaxi6826cgpq5njkm4j1cfvx"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-case))
    (home-page "https://github.com/celery/vine")
    (synopsis "Promises for Python")
    (description
     "@code{vine} provides a special implementation of promises in that it can
be used both for \"promise of a value\" and lazy evaluation.  The biggest
upside for this is that everything in a promise can also be a promise,
e.g. filters, callbacks and errbacks can all be promises.")
    (license license:bsd-3)))

(define-public python-virtualenv
  (package
    (name "python-virtualenv")
    (version "20.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "virtualenv" version))
       (sha256
        (base32
         "1nbhnpzswcf3lmzn5xabmfdd7ki8r2w2i37y6wml54di6qi1l48c"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock python-pytest python-setuptools-scm))
    (propagated-inputs
     (list python-appdirs python-distlib python-filelock python-six))
    (home-page "https://virtualenv.pypa.io/")
    (synopsis "Virtual Python environment builder")
    (description
     "Virtualenv is a tool to create isolated Python environments.")
    (license license:expat)))

(define-public python-crossenv
  (package
    (name "python-crossenv")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "crossenv" version))
       (sha256
        (base32
         "07rv4650n19740ixmnsf4qbxyqlgi7f5m1cy8cq0gl01q3r6hps4"))))
    (build-system python-build-system)
    (arguments
     (list #:tests? #f)) ; tests not distributed on pypi
    (home-page "https://github.com/benfogle/virtualenv")
    (synopsis "Cross-compiling virtualenv for Python")
    (description "This package is a tool for cross-compiling extension
modules.  It creates a special virtual environment such that @command{pip} or
@file{setup.py} will cross compile packages for you, usually with no further
work on your part.")
    (license license:expat)))

(define-public python-uc-micro-py
  (package
    (name "python-uc-micro-py")
    (version "1.0.1")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/tsutsu3/uc.micro-py")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "17f55gi55rg47nm88fn3f8851ph03dgykdp011lxr3j6hk18lyfv"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/tsutsu3/uc.micro-py")
    (synopsis "Unicode data files for linkify-it-py projects")
    (description "This package contains a micro subset of Unicode data files
for linkify-it-py projects.")
    (license license:expat)))

(define-public python-linkify-it-py
  (package
    (name "python-linkify-it-py")
    (version "2.0.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/tsutsu3/linkify-it-py")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0fg0a1lc8xbb62y9krxcp708ll58dxcwm8i7rrwpkd5sh2229f6x"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-uc-micro-py))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/tsutsu3/linkify-it-py")
    (synopsis "Links recognition library with full Unicode support")
    (description "This is Python port of
@url{https://github.com/markdown-it/linkify-it, linkify-it}, which is a links
recognition library with full Unicode support.  It has features like:
@itemize
@item Full unicode support, with @i{astral} characters
@item International domains support
@item Allows rules extension and custom normalizers.
@end itemize")
    (license license:expat)))

(define-public python-markdown-it-py
  (package
    (name "python-markdown-it-py")
    (version "2.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "markdown-it-py" version))
              (sha256
               (base32
                "1nh75i72584r70alhqc479gys04s5m5g3vq601yf2njbs7z5jzng"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f                       ;pypi source does not contains tests
      #:phases
      #~(modify-phases %standard-phases
          (replace 'build
            (lambda _ (invoke "flit" "build")))
          (replace 'install
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (add-installed-pythonpath inputs outputs)
              (for-each
               (lambda (wheel)
                 (invoke "python" "-m" "pip" "install"
                         wheel (string-append "--prefix=" #$output)))
               (find-files "dist" "\\.whl$")))))))
    (native-inputs (list python-flit))
    (propagated-inputs
     (list python-mdurl
           python-typing-extensions))
    (home-page "https://github.com/executablebooks/markdown-it-py")
    (synopsis "Python port of markdown-it")
    (description
     "This is a Python port of @code{markdown-it}, and some of its associated
plugins.  The driving design philosophy of the port has been to change as
little of the fundamental code structure (file names, function name, etc) as
possible.")
    (license license:expat)))

(define-public python-markupsafe
  (package
    (name "python-markupsafe")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "MarkupSafe" version))
       (sha256
        (base32
         "02k2ynmqvvd0z0gakkf8s4idyb606r7zgga41jrkhqmigy06fk2r"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/mitsuhiko/markupsafe")
    (synopsis "XML/HTML/XHTML markup safe string implementation for Python")
    (description
     "Markupsafe provides an XML/HTML/XHTML markup safe string implementation
for Python.")
    (license license:bsd-3)))


(define-public python-jinja2
  (package
    (name "python-jinja2")
    (version "3.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Jinja2" version))
       (sha256
        (base32
         "1saawzys14l1p4kafs7hkihmnvqjq8fwxjmkjiqx3jq1nm5ys2v4"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv")
                          (format #t "test suite not run~%")))))))
    (native-inputs (list python-pytest))
    (propagated-inputs (list python-markupsafe))
    (home-page "https://jinja.palletsprojects.com/")
    (synopsis "Python template engine")
    (description
     "Jinja2 is a small but fast and easy to use stand-alone template engine
written in pure Python.")
    (license license:bsd-3)))


(define-public python-jinja2-time
  (package
    (name "python-jinja2-time")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jinja2-time" version))
       (sha256
        (base32
         "0h0dr7cfpjnjj8bgl2vk9063a53649pn37wnlkd8hxjy656slkni"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-arrow python-jinja2))
    (home-page
     "https://github.com/hackebrot/jinja2-time")
    (synopsis "Jinja2 Extension for Dates and Times")
    (description
     "This package provides an extension for the template engine Jinja2.  It
adds a 'now' tag providing a convenient access to the arrow.now() API from
templates.  A format string can be provided to control the output.")
    (license license:expat)))

(define-public python-pysdl2
  (package
    (name "python-pysdl2")
    (version "0.9.11")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PySDL2" version))
              (sha256
               (base32
                "19id1qswgcj4v4j5kn49shq1xxx3slhjpm0102w87mczsdbi1rck"))))
    (build-system python-build-system)
    (arguments
      (list #:tests? #f ;; Requires /dev/dri, OpenGL module, etc.
            #:phases
            #~(modify-phases %standard-phases
                (add-after 'unpack 'patch-paths
                  (lambda* (#:key inputs #:allow-other-keys)
                    (substitute* "sdl2/dll.py"
                    ;; Disable pysdl2-dll. It can't be packaged on GNU Guix
                    ;; as it duplicates an existing package (sdl2).
                    (("prepath = os\\.getenv\\('PYSDL2_DLL_PATH'\\)")
                     "prepath = \"system\"")
                    (("^import sdl2dll$") "")
                    (("postpath = os\\.getenv\\('PYSDL2_DLL_PATH'\\)")
                     "postpath = \"system\"")
                    (("DLL\\(.*, os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)\\)")
                     (string-append
                       "DLL(\"SDL2\", [\"SDL2\", \"SDL2-2.0\", \"SDL2-2.0.0\"], \""
                       (dirname (search-input-file inputs "/lib/libSDL2.so"))
                       "\")")))
              (substitute* "sdl2/sdlimage.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_image.so"))
                   "\"")))
              (substitute* "sdl2/sdlgfx.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_gfx.so"))
                   "\"")))
              (substitute* "sdl2/sdlmixer.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_mixer.so"))
                   "\"")))
              (substitute* "sdl2/sdlttf.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_ttf.so"))
                   "\""))))))))
    (inputs
      (list sdl2 sdl2-image sdl2-gfx sdl2-mixer sdl2-ttf))
    (home-page "https://github.com/py-sdl/py-sdl2")
    (synopsis "Python bindings around the SDL2 game development library")
    (description "PySDL2 is a pure Python wrapper around the @code{SDL2},
@code{SDL2_mixer}, @code{SDL2_image}, @code{SDL2_ttf}, and @code{SDL2_gfx}
libraries.  Instead of relying on C code, it uses the built-in ctypes module
to interface with SDL2, and provides simple Python classes and wrappers for
common SDL2 functionality.")
    (license license:cc0)))

(define-public python-pystache
  (package
    (name "python-pystache")
    (version "0.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pystache" version))
              (sha256
               (base32
                "03a73ppf5vxnsk6az5ackvc0hp6xqv2f4hi1s5c4nk4s2jr95gwk"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; FIXME: Python 3 tests are failing.
    (home-page "http://defunkt.io/pystache/")
    (synopsis "Python logic-less template engine")
    (description
     "Pystache is a Python implementation of the framework agnostic,
logic-free templating system Mustache.")
    (license license:expat)))

(define-public python-pystitcher
  (package
    (name "python-pystitcher")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/captn3m0/pystitcher")
         (commit
          (string-append "v" version))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "03yrzqhcsjdj5zprrk3bh5bbyqfy3vfhxra9974vmkir3m121394"))))
    (build-system python-build-system)
    (inputs
     (list python-html5lib python-importlib-metadata python-markdown
           python-pypdf3 python-validators))
    (home-page "https://github.com/captn3m0/pystitcher")
    (synopsis "Declaratively stitch together a PDF file from multiple sources")
    (description
     "This package stitches your PDF files together, generating customizable
bookmarks using a declarative input in the form of a markdown file.")
    (license license:expat)))

(define-public python-joblib
  (package
    (name "python-joblib")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "joblib" version))
              (sha256
               (base32
                "0d8ypyhsw1bjr96zan9ms8wbvnzbjqxniq4vcszghcrps7ngqn21"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (setenv "JOBLIB_MULTIPROCESSING" "0")
               (invoke "pytest" "-v" "joblib"
                       ;; We disable this test to avoid having to depend on ipython/jupyter
                       "-k" "not test_parallel_call_cached_function_defined_in_jupyter")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://joblib.readthedocs.io/")
    (synopsis "Using Python functions as pipeline jobs")
    (description
     "Joblib is a set of tools to provide lightweight pipelining in Python.
In particular, joblib offers: transparent disk-caching of the output values
and lazy re-evaluation (memoize pattern), easy simple parallel computing
logging and tracing of the execution.")
    (license license:bsd-3)))


(define-public python-daemon
  (package
    (name "python-daemon")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-daemon" version))
       (sha256
        (base32
         "1bxfn2bq56sd4w0nm9mqy8y0905m7fc8vmhnjxlrf49vcbqr7adx"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'adjust-tests
           (lambda _
             ;; Drop use of testtools.helpers.safe_hasattr which has
             ;; been removed in favor of hasattr.
             (substitute* "test/test_metadata.py"
               (("testtools\\.helpers\\.safe_hasattr")
                "hasattr"))
             ;; FIXME: Determine why test fails
             (substitute* "test/test_daemon.py"
               (("test_detaches_process_context")
                "skip_test_detaches_process_context")))))))
    (propagated-inputs
     (list python-lockfile))
    (native-inputs
     (list python-coverage
           python-testtools
           python-testscenarios
           python-twine
           python-mock
           python-docutils))
    (home-page "https://pagure.io/python-daemon/")
    (synopsis "Python library for making a Unix daemon process")
    (description "Python-daemon is a library that assists a Python program to
turn itself into a well-behaved Unix daemon process, as specified in PEP 3143.

This library provides a @code{DaemonContext} class that manages the following
important tasks for becoming a daemon process:
@enumerate
@item Detach the process into its own process group.
@item Set process environment appropriate for running inside a chroot.
@item Renounce suid and sgid privileges.
@item Close all open file descriptors.
@item Change the working directory, uid, gid, and umask.
@item Set appropriate signal handlers.
@item Open new file descriptors for stdin, stdout, and stderr.
@item Manage a specified PID lock file.
@item Register cleanup functions for at-exit processing.
@end enumerate")
    ;; Only setup.py is gpl3+, everything else is apache 2.0 licensed.
    (license (list license:asl2.0 license:gpl3+))))

(define-public python-anytree
  (package
    (name "python-anytree")
    (version "2.8.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "anytree" version))
              (sha256
               (base32
                "1aycpc387wqz7h9w2p53qxn43qsh3m6by6ak4kkc66x9aprr63rz"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (native-inputs
     (list ;; For tests.
           graphviz ;for 'dot'
           python-nose))
    (home-page "https://github.com/c0fec0de/anytree")
    (synopsis "Lightweight tree data library")
    (description
     "@code{anytree} is a simple, lightweight, and extensible tree data
structure for Python.")
    (license license:asl2.0)))

(define-public autokey
  (package
    (name "autokey")
    (version "0.95.10")
    (source (origin
             (method git-fetch)
             (uri (git-reference
                   (url "https://github.com/autokey/autokey")
                   (commit (string-append "v" version))))
             (file-name (git-file-name name version))
             (sha256
              (base32
               "0f0cqfnb49wwdy7zl2f2ypcnd5pc8r8n7z7ssxkq20d4xfxlgamr"))))
    (build-system python-build-system)
    (arguments
     (list
      ;; Tests are deprecated and broken until next version, see
      ;; https://github.com/autokey/autokey/issues/327
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "lib/autokey/scripting.py"
                (("\"wmctrl\"")
                 (string-append "\"" (search-input-file inputs "bin/wmctrl") "\""))
                (("\"zenity\"")
                 (string-append "\"" (search-input-file inputs "bin/zenity") "\"")))
              (substitute* "autokey-shell"
                (("'ipython3'")
                 (string-append "'" (search-input-file inputs "bin/ipython3") "'"))
                (("'python3'")
                 (string-append "'" (search-input-file inputs "bin/python3") "'")))))
          ;; Use 'prefix' instead of '=' to allow the user to use additional
          ;; GI paths from their autokey scripts.  GUIX_PYTHONPATH is already
          ;; wrapped with prefix in python-build-system's wrap.
          (add-before 'wrap 'wrap-autokey-gi
            (lambda _
              (let ((gi-typelib-path (getenv "GI_TYPELIB_PATH")))
                (for-each
                 (lambda (program)
                   (wrap-program program
                     `("GI_TYPELIB_PATH" ":" prefix (,gi-typelib-path))))
                 (map (lambda (name)
                        (string-append #$output "/bin/" name))
                      '("autokey-gtk"
                        "autokey-shell")))))))))
    (inputs
     (list bash-minimal ; for wrap-program
           gtksourceview-3
           libappindicator
           libnotify
           python-dbus
           python-ipython
           python-pygobject
           python-pyinotify
           python-pyqt+qscintilla
           python-xlib
           wmctrl
           zenity))
    (home-page "https://github.com/autokey/autokey")
    (synopsis
      "Keyboard and GUI automation utility")
    (description
      "AutoKey is a desktop automation utility for X11.  It allows the automation of
virtually any task by responding to typed abbreviations and hotkeys.  It
offers a full-featured GUI (GTK and QT versions) that makes it highly
accessible for novices, as well as a scripting interface offering the full
flexibility and power of the Python language.")
    (license license:gpl3+)))

(define-public python-docutils
  (package
    (name "python-docutils")
    (version "0.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docutils" version))
       (sha256
        (base32
         "09gii36lp1bs26cpxqyfd20xahnpbrbjzcnba2xq08y3wk97frb8"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "python" "test/alltests.py")
                          (format #t "test suite not run~%"))
                      #t)))))
    (home-page "http://docutils.sourceforge.net/")
    (synopsis "Python Documentation Utilities")
    (description
     "Docutils is a modular system for processing documentation into useful
formats, such as HTML, XML, and LaTeX.  It uses @dfn{reStructuredText}, an
easy to use markup language, for input.

This package provides tools for converting @file{.rst} files to other formats
via commands such as @command{rst2man}, as well as supporting Python code.")
    ;; Most of the source code is public domain, but some source files are
    ;; licensed under the PFSL, BSD 2-clause, and GPLv3+ licenses.
    (license (list license:public-domain license:psfl license:bsd-2 license:gpl3+))))

;; TODO: Make this the default in the next rebuild cycle.
(define-public python-docutils-0.19
  (package
    (inherit python-docutils)
    (version "0.19")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docutils" version))
              (sha256
               (base32
                "1rprvir116g5rz2bgzkzgyn6mv0z8582rz7bgxbpy2y3adkmm69k"))))))

;; awscli refuses to be built with docutils < 0.16.
(define-public python-docutils-0.15
  (package
    (inherit python-docutils)
    (version "0.15")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docutils" version))
              (sha256
               (base32
                "0ja8q6mdj6xv62jjw3phv8j5nfqi5x8hnfy4pqfcjcgz4b34k8sl"))))
    ;; tests contain Python 2 syntax.
    (arguments '(#:tests? #false))))

(define-public python-restructuredtext-lint
  (package
    (name "python-restructuredtext-lint")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "restructuredtext-lint" version))
       (sha256
        (base32
         "026rdy5h82ng4vqxk8fnprii9d6qxf7hkygiv0a8afjvdlsxmcwp"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (delete 'check)
         (add-after 'install 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "nosetests" "-v"))
             #t)))))
    (propagated-inputs
     (list python-docutils))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/twolfson/restructuredtext-lint")
    (synopsis "reStructuredText linter")
    (description "This package provides a linter for the reStructuredText
format.")
    (license license:unlicense)))

(define-public python-click-repl
  (package
    (name "python-click-repl")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/click-contrib/click-repl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16ybsnwlj2jlqcfxflky8jz7i3nhrd3f6mvkpgs95618l8lx994i"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-click python-prompt-toolkit python-six))
    (home-page "https://github.com/untitaker/click-repl")
    (synopsis "REPL plugin for Click")
    (description "This package provides a REPL plugin for Click.")
    (license license:expat)))

(define-public python-doc8
  (package
    (name "python-doc8")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "doc8" version))
       (sha256
        (base32
         "0hw5w8mpgsp51qg8nnq28p7y1jiksvz7a0axnn5bkgss3af9zy1d"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (delete 'check)
         (add-after 'install 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-v"))
             #t)))))
    (propagated-inputs
     (list python-chardet python-docutils python-restructuredtext-lint
           python-six python-stevedore))
    (native-inputs
     (list python-testtools python-pytest))
    (home-page "https://launchpad.net/doc8")
    (synopsis
     "Style checker for Sphinx (or other) RST documentation")
    (description
     "Doc8 is an opinionated style checker for reStructured Text and plain
text styles of documentation.")
    (license license:asl2.0)))

(define-public python-pygments
  (package
    (name "python-pygments")
    (version "2.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pygments" version))
       (sha256
        (base32
         "1sr6iqh21xi6p8aba4wa9pqfhjbbpcvn9jcsx0ggy4lniw8idcay"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Tests require sphinx, which depends on this.
     '(#:tests? #f))
    (home-page "https://pygments.org/")
    (synopsis "Syntax highlighting")
    (description
     "Pygments is a syntax highlighting package written in Python.")
    (license license:bsd-2)))

(define-public python-pygments-github-lexers
  (package
    (name "python-pygments-github-lexers")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygments-github-lexers" version))
       (sha256
        (base32
         "0cz14clcc9z4pn79ll8hp3xzgsrfjscak5zfsvlgrz6ngkkmgjma"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pygments))
    (home-page "https://github.com/liluo/pygments-github-lexers")
    (synopsis "Pygments Github custom lexers")
    (description "This package installs Github custom lexers to Pygments.")
    (license license:bsd-3)))

(define-public python-bump2version
  (package
    (name "python-bump2version")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bump2version" version))
       (sha256
        (base32 "1rinm4gv1fyh7xjv3v6r1p3zh5kl4ry2qifz5f7frx31mnzv4b3n"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: Tests fail with "bumpversion: error: the following arguments are
     ;; required: --new-version".
     `(#:tests? #false))
    (home-page "https://github.com/c4urself/bump2version")
    (synopsis "Version-bump your software with a single command!")
    (description
     "This package provides a small command line tool to simplify releasing
software by updating all version strings in your source code by the correct
increment.  It also creates commits and tags.")
    (license license:expat)))

(define-public python-bumpversion
  (package
    (name "python-bumpversion")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bumpversion" version))
       (sha256
        (base32
         "0zn7694yfipxg35ikkfh7kvgl2fissha3dnqad2c5bvsvmrwhi37"))))
    (build-system python-build-system)
    (home-page "https://github.com/peritus/bumpversion")
    (synopsis "Tool to bump software version")
    (description "This tool provides a command-line interface (CLI) to bump a
software version simply.")
    (license license:expat)))

(define-public python-deprecated
  (package
    (name "python-deprecated")
    (version "1.2.13")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tantale/deprecated")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0v4ys9xr8lski2r98da99spsj6hjlnnqgnhhmyhrm66myiix885c"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest")))))))
    (propagated-inputs
     (list python-wrapt))
    (native-inputs
     (list python-bumpversion python-pytest python-pytest-cov
           python-sphinx python-tox))
    (home-page "https://github.com/tantale/deprecated")
    (synopsis "Python decorator to deprecate classes, functions or methods")
    (description "The @code{deprecated} decorator provides a convenient way to deprecate
to deprecate classes, functions or methods.")
    (license license:expat)))

(define-public python-pygithub
  (package
    (name "python-pygithub")
    (version "1.55")
    (source
     ;; We fetch from the Git repo because there are no tests in the PyPI
     ;; archive.
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/PyGithub/PyGithub")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "082bxffpy4h97dsay3l75cpgfjj10kywkvicnm6xscwvah285q9y"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest"))
             #t)))))
    (propagated-inputs
     (list python-cryptography python-deprecated python-pyjwt
           python-pynacl python-requests))
    (native-inputs
     (list python-httpretty python-pytest))
    (home-page "https://pygithub.readthedocs.io/en/latest/")
    (synopsis "Python library for the GitHub API")
    (description "This library allows managing GitHub resources such as
repositories, user profiles, and organizations in your Python applications,
using version 3 of the GitHub application programming interface (API).")
    (license license:lgpl3+)))

(define-public python-rellu
  (package
    (name "python-rellu")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rellu" version))
       (sha256
        (base32
         "1w0arpj1sm7vh29nrbnca4pnp8sx42l07r17inwqcjjf9bhng66x"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-invoke python-pygithub))
    (home-page "https://github.com/robotframework/rellu")
    (synopsis "Utilities to create PyPI releases")
    (description "This collection of utilities contains tooling and templates
to assist in creating releases on GitHub and publishing them on PyPI.  It is
designed to be used by Robot Framework and tools and libraries in its
ecosystem, but can naturally be used also by other projects.")
    (license license:asl2.0)))

(define-public python-robotframework
  (package
    (name "python-robotframework")
    (version "5.0.1")
    ;; There are no tests in the PyPI archive.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/robotframework")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jjr71npzrm5mv16pya3m2dqaqgf6sc45yca5kfmc5lfislig5b8"))
       (patches (search-patches
                 "python-robotframework-atest.patch"
                 "python-robotframework-source-date-epoch.patch"))))
    (build-system python-build-system)
    (arguments
     (list
      #:modules '((guix build python-build-system)
                  (guix build utils)
                  (ice-9 ftw)
                  (ice-9 match)
                  (srfi srfi-26))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'delete-problematic-tests
            (lambda _
              ;; Tests such as 'Tilde and username in path' rely on HOME and
              ;; USER being set, on top of the user's /etc/passwd home
              ;; directory not being '/', as is the case in the Guix build
              ;; container.
              (delete-file "atest/robot/standard_libraries/\
operating_system/path_expansion.robot")))
          (add-before 'build 'build-and-install-doc
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((doc (string-append (assoc-ref outputs "doc")
                                        "/share/doc/robotframework")))
                (invoke "invoke" "library-docs" "all")
                (invoke "doc/userguide/ug2html.py" "dist") ;user guide
                (mkdir-p doc)
                (with-directory-excursion "dist"
                  (define user-guide-dir
                    (match (scandir "." (cut string-prefix?
                                             "robotframework-userguide-" <>))
                      ((dir) dir)
                      (_ (error "could not find the user guide directory"))))
                  (copy-recursively user-guide-dir doc)))))
          (replace 'check
            (lambda* (#:key native-inputs inputs tests?
                      #:allow-other-keys)
              (when tests?
                ;; Some tests require timezone data.  Otherwise, they
                ;; look up /etc/localtime, which doesn't exist, and
                ;; fail with:
                ;;
                ;; OverflowError: mktime argument out of range
                (setenv "TZDIR"
                        (search-input-directory
                         (or native-inputs inputs) "share/zoneinfo"))
                (setenv "TZ" "Europe/Paris")

                (format #t "Running unit tests...~%")
                (invoke "utest/run.py")

                (format #t "Running acceptance tests...~%")
                (invoke "xvfb-run" "atest/run.py")))))))
    (native-inputs
     (list python-docutils
           python-jsonschema-next
           python-invoke
           python-lxml
           python-pygments
           python-pyyaml
           python-rellu
           `(,python "tk")              ;used when building the HTML doc
           python-xmlschema
           scrot                        ;for taking screenshots
           tzdata-for-tests
           xvfb-run))
    (outputs '("out" "doc"))
    (home-page "https://robotframework.org")
    (synopsis "Generic automation framework")
    (description "Robot Framework is a generic automation framework for
acceptance testing, acceptance test driven development (ATDD), and robotic
process automation (RPA).")
    (license license:asl2.0)))

(define-public python-robotframework-datadriver
  (package
    (name "python-robotframework-datadriver")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-datadriver" version))
       (sha256
        (base32 "0mcyr3v98nvfnvffy096qp3jqslas7l8hh0j00lpi0mp12cd0qk9"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'skip-problematic-tests
           (lambda _
             ;; The test file 'tab-csv-file-name.tsv' contains special
             ;; characters for which there is no locale in the build
             ;; environment, causing one test to fail.
             (delete-file-recursively "atest/TestCases/csv_reader_config")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (with-directory-excursion "atest"
                 (invoke "sh" "run_atest.sh"))))))))
    (native-inputs (list python-docutils
                         python-robotframework-stacktrace))
    (propagated-inputs (list python-openpyxl
                             python-pandas
                             python-pygments
                             python-robotframework))
    (home-page "https://github.com/Snooz82/robotframework-datadriver")
    (synopsis "Data-driven test extension for Robot Framework")
    (description "DataDriver is a data-driven extension for Robot Framework.
DataDriver uses the Listener Interface of Robot Framework to create new test
cases based on a data file that contains the test data.  DataDriver supports
data files in the CSV, XLS or XLSX formats.")
    (license license:asl2.0)))

(define-public python-robotframework-lint
  ;; There is no properly tagged release; the commit below seems to correspond
  ;; to the 0.9 stable release available from PyPI.  The tests are not
  ;; included in the PyPI archive, so we fetch the sources from the upstream
  ;; Git repo.
  (let ((commit "b0619ac58a8b1be125f9c98856a664594614570f")
        (revision "0"))
    (package
      (name "python-robotframework-lint")
      (version (git-version "1.1"      ;version taken from 'rflint/version.py'
                            revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/boakley/robotframework-lint")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "180npmvzqync25b2scs878gv8q4y17dsinxyjcc10bw22msfap6b"))))
      (build-system python-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (replace 'check
             (lambda _
               (invoke "python" "-m" "robot" "-A"
                       "tests/conf/default.args" "tests"))))))
      (propagated-inputs
       (list python-robotframework))
      (home-page "https://github.com/boakley/robotframework-lint/")
      (synopsis "Static analysis tool (linter) for Robot Framework")
      (description "This package provides the @code{rflint} command-line
utility, a static analysis tool (linter) for Robot Framework source files.")
      (license license:asl2.0))))

(define-public python-robotframework-pabot
  (package
    (name "python-robotframework-pabot")
    (version "2.7.0")
    (source
     (origin
       ;; There are no tests in the PyPI archive.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mkorpela/pabot")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0246vvyaxax0nzlrffvp9vg6mh5jmvbbm87azignf0gakjidr7nn"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (invoke "pytest" "-vv" "tests")))))))
    (propagated-inputs
     (list python-robotframework python-robotframework-stacktrace))
    (native-inputs
     (list python-pytest))
    (home-page "https://pabot.org")
    (synopsis "Parallel test runner for Robot Framework")
    (description "Pabot is a parallel executor for Robot Framework tests.")
    (license license:asl2.0)))

(define-public python-sshtunnel
  (package
    (name "python-sshtunnel")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "sshtunnel" version))
              (sha256
               (base32
                "1z7rdgpp9m36ysh9pfzrn3vyiaj05bkjvcjdhj8vz0fvfjkhxjz7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv" "tests")))))))
    (propagated-inputs (list python-paramiko))
    (native-inputs (list openssh python-pytest))
    (home-page "https://github.com/pahaz/sshtunnel")
    (synopsis "Python SSH tunnels library")
    (description "@code{sshtunnel} is a Python module for easily creating SSH
tunnels in the background, using Python.")
    (license license:expat)))

(define-public python-robotframework-sshtunnellibrary
  (package
    (name "python-robotframework-sshtunnellibrary")
    (version "1.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/C-Squad/robotframework-sshtunnellibrary")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1vkkmkb8iql13xpbyj4hvnnmfgzqlr8rffgryp2082cadb3w7xrd"))))
    (build-system python-build-system)
    (arguments
     (list #:phases #~(modify-phases %standard-phases
                        (replace 'check
                          (lambda* (#:key tests? #:allow-other-keys)
                            (when tests?
                              (invoke "python" "-m" "unittest"
                                      "discover" "-s" "test")))))))
    (propagated-inputs (list python-robotframework python-sshtunnel))
    (home-page "https://github.com/C-Squad/robotframework-sshtunnellibrary")
    (synopsis "Alternative RobotFramework library for SSH tunnels")
    (description "SSHTunnelLibrary is an alternative RobotFramework
library (to the more official one that comes from the
@code{robotframework-sshlibrary} package) to support SSH tunnels.")
    (license license:asl2.0)))

(define-public python-robotframework-stacktrace
  (package
    (name "python-robotframework-stacktrace")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-stacktrace" version))
       (sha256
        (base32 "19gnwr7da1zz9clhwsmvqfjf02d195i61lzpq4253dcsgrpb6v79"))))
    (build-system python-build-system)
    (arguments
     ;; The test suite fails (see:
     ;; https://github.com/MarketSquare/robotframework-stacktrace/issues/4).
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (with-directory-excursion "tests"
                 (invoke "python" "-m" "robot" "."))))))))
    (propagated-inputs (list python-robotframework))
    (home-page "https://github.com/MarketSquare/robotframework-stacktrace")
    (synopsis "Robot Framework listener to print a stack trace on error")
    (description "StackTrace is a Robot Framework listener that prints a stack
trace directly to the terminal to ease debugging.")
    (license license:asl2.0)))

(define-public python-robotframework-sshlibrary
  (package
    (name "python-robotframework-sshlibrary")
    (version "3.8.0")
    ;; There are no tests in the PyPI archive.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/SSHLibrary")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fn72hw7xacjjpl4dd6wynh2x63i9rk8iqhj3v640db21qpcnbkw"))
       (patches (search-patches
                 "python-robotframework-sshlibrary-rf5-compat.patch"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'build-and-install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((doc (string-append
                         (assoc-ref outputs "doc")
                         "/share/doc/robotframework-sshlibrary")))
               (invoke "chmod" "-R" "+w" "docs")
               (invoke "invoke" "kw-docs" "project-docs")
               (mkdir-p doc)
               (for-each delete-file (find-files "docs" "\\.rst"))
               (copy-recursively "docs" doc))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Some tests require an SSH server; we remove them.
               (delete-file "utest/test_client_api.py")
               (delete-file "utest/test_scp.py")
               (invoke "python" "utest/run.py")))))))
    (propagated-inputs
     (list python-robotframework python-paramiko python-scp))
    (native-inputs
     (list openssh
           which
           ;; To generate the documentation
           python-docutils
           python-invoke
           python-pygments
           python-rellu))
    (outputs '("out" "doc"))
    (home-page "https://github.com/robotframework/SSHLibrary")
    (synopsis "Robot Framework library for SSH and SFTP")
    (description "SSHLibrary is a Robot Framework library providing support
for SSH and SFTP.  It has the following main usages:
@itemize @bullet
@item Executing commands on the remote machine, either blocking or non-blocking.
@item Writing and reading in an interactive shell.
@item Transferring files and directories over SFTP.
@item Ensuring that files and directories exist on the remote machine.
@end itemize")
    (license license:asl2.0)))

(define-public python-robotframework-pythonlibcore
  (package
    (name "python-robotframework-pythonlibcore")
    (version "3.0.0")
    (source
     (origin
       (method git-fetch)               ;no tests in pypi archive
       (uri (git-reference
             (url "https://github.com/robotframework/PythonLibCore")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0v89v8va65l6inh0fb34qgxawx6p29pnrmw4n5941yzdi3804rc4"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "utest/run.py")))))))
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-mockito
           python-robotframework))
    (home-page "https://github.com/robotframework/PythonLibCore")
    (synopsis "Robot Framework Python library tools")
    (description "PythonLibCore provides tools for creating larger test
libraries for Robot Framework using Python.  The Robot Framework hybrid and
dynamic library APIs give more flexibility for library than the static library
API, but they also set requirements for libraries which need to be implemented
in the library side.  PythonLibCore eases the problem by providing a simpler
interface and by handling all the requirements towards the Robot Framework
library APIs.")
    (license license:asl2.0)))

(define-public python-robotframework-seleniumlibrary
  (package
    (name "python-robotframework-seleniumlibrary")
    (version "5.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-seleniumlibrary" version))
       (sha256
        (base32 "1dihrbcid9i7daw2qy6h3xsvwaxzmyip820jw5z11n60qrl006pm"))))
    (build-system python-build-system)
    ;; XXX: Tests require ungoogled-chromium, but the chromium module would
    ;; introduce a cycle if imported here.
    (propagated-inputs
     (list python-robotframework python-robotframework-pythonlibcore
           python-selenium))
    (home-page "https://github.com/robotframework/SeleniumLibrary")
    (synopsis "Web testing library for Robot Framework")
    (description "SeleniumLibrary is a web testing library for Robot Framework
that utilizes the Selenium tool internally.")
    (license license:asl2.0)))

(define-public python-robotframework-seleniumscreenshots
  (package
    (name "python-robotframework-seleniumscreenshots")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-seleniumscreenshots" version))
       (sha256
        (base32 "05qv323hvjmy62h33ryrjaa9k1hyvp8hq5qnj8j1x3ap2ci3q3s0"))))
    (build-system python-build-system)
    (arguments
    ;; XXX: The tests require a relatively complicated setup configured in
    ;; their CI with Nix (!).
     `(#:tests? #f))
    (propagated-inputs
     (list python-robotframework python-robotframework-seleniumlibrary))
    (home-page "https://github.com/MarketSquare/robotframework-seleniumscreenshots")
    (synopsis "Robot Framework library for annotating and cropping screenshots")
    (description "The SeleniumScreenshots library for Robot Framework provides
keywords for annotating and cropping screenshots taken with SeleniumLibrary.
It is useful for scripting automatically updated screenshots for documentation
or for visual regression testing purposes.")
    (license license:bsd-3)))

(define-public python-rstr
  (package
   (name "python-rstr")
   (version "2.2.6")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "rstr" version))
     (sha256
      (base32
       "197dw8mbq0pjjz1l6h1ksi62vgn7x55d373ch74y06744qiq5sjx"))))
   (build-system python-build-system)
   (home-page "https://github.com/leapfrogonline/rstr")
   (synopsis "Generate random strings in Python")
   (description "This package provides a python module for generating
random strings of various types.  It could be useful for fuzz testing,
generating dummy data, or other applications.  It has no dependencies
outside the standard library.")
   (license license:bsd-3)))

(define-public python-scp
  (package
    (name "python-scp")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "scp" version))
       (sha256
        (base32 "1m2v09m407p097cy3xy5rxicqfzrqjwf8v5rd4qhfqkk7lllimwb"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f))                     ;tests require an SSH server
    (propagated-inputs
     (list python-paramiko))
    (home-page "https://github.com/jbardin/scp.py")
    (synopsis "SCP protocol module for Python and Paramiko")
    (description "The scp module extends the Paramiko library to send and
receive files via the SCP1 protocol, as implemented by the OpenSSH
@command{scp} program.")
    (license license:gpl2+)))

(define-public python-rst.linker
  (package
    (name "python-rst.linker")
    (version "1.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rst.linker" version))
       (sha256
        (base32 "0pqsfqqx8h0pq21k8l3k62kznrgaj2ala93c64s4d9rpbr4mgkd2"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dateutil python-six))
    (native-inputs
     (list python-setuptools-scm))
    ;; Test would require path.py, which would introduce a cyclic dependence.
    (arguments `(#:tests? #f))
    ;; Note: As of version 1.7 the documentation is not worth building.
    (home-page "https://github.com/jaraco/rst.linker")
    (synopsis "Sphinx plugin to add links and timestamps")
    (description "rst.linker automatically replaces text by a
reStructuredText external reference or timestamps.  It's primary purpose is to
augment the changelog, but it can be used for other documents, too.")
    (license license:expat)))

(define-public python-sshpubkeys
  (package
    (name "python-sshpubkeys")
    (version "3.1.0")
    (home-page "https://github.com/ojarva/python-sshpubkeys")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1h4gwmcfn84kkqh83km1vfz8sc5kr2g4gzgzmr8gz704jmqiv7nq"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-cryptography python-ecdsa))
    (synopsis "OpenSSH public key parser")
    (description
     "This package provides a library for parsing and validating OpenSSH
public key files.")
    (license license:bsd-3)))

(define-public python-feedgenerator
  (package
    (name "python-feedgenerator")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "feedgenerator" version))
       (sha256
        (base32
         "01mirwkm7xfx539hmvj7g9da1j51gw5lsx74dr0glizskjm5vq2s"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Remove pre-compiled .pyc files from source.
           (for-each delete-file-recursively
                     (find-files "." "__pycache__" #:directories? #t))
           (for-each delete-file (find-files "." "\\.pyc$"))
           #t))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pytz python-six))
    (home-page "https://github.com/getpelican/feedgenerator")
    (synopsis
     "Standalone version of Django's Atom/RSS feed generator")
    (description
     "Feedgenerator-py3k is a standalone version of Django's feedgenerator,
which can produce feeds in RSS 2.0, RSS 0.91, and Atom formats.")
    (license license:bsd-3)))

(define-public python-lsp-jsonrpc
  (package
    (name "python-lsp-jsonrpc")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-lsp-jsonrpc" version))
       (sha256
        (base32
         "1gb0fsamxndhplx25v8m0b3k7aknzy454fpa0qsqsqnv6c3igv3v"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock python-pytest))
    (propagated-inputs
     (list python-ujson))
    (home-page "https://github.com/python-lsp/python-lsp-jsonrpc")
    (synopsis "JSON RPC 2.0 server library")
    (description
     "This package provides a JSON RPC 2.0 server library for Python.")
    (license license:expat)))

(define-public python-jsonrpc-server
  (deprecated-package "python-jsonrpc-server" python-lsp-jsonrpc))

(define-public python-pydantic
  (package
    (name "python-pydantic")
    (version "1.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/samuelcolvin/pydantic")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1406kgppqa7524mxllsipj7gb8fn7pwf51l11lqik59xjhsfv94f"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-pytest python-pytest-mock))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/samuelcolvin/pydantic")
    (synopsis "Python data validation and settings management")
    (description
     "Pydantic enforces type hints at runtime, and provides user friendly
errors when data is invalid.")
    (license license:expat)))

(define-public python-pydantic-cli
  (package
    (name "python-pydantic-cli")
    (version "4.3.0")
    (source
     (origin
       (method git-fetch)               ;for tests
       (uri (git-reference
             (url "https://github.com/mpkocher/pydantic-cli")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1v4dx6n60rbsan5zpw2rgdih7lb3h0xclagn1p6zfwl0r9l9cvym"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pydantic))
    (native-inputs
     (list python-black
           python-mypy
           python-pytest))
    (home-page "https://github.com/mpkocher/pydantic-cli")
    (synopsis "Turn Pydantic defined data models into CLI tools")
    (description
     "@code{python-pydantic} enables specifying @acronym{CLI, Command Line
Interfaces} via data models provided in the JSON format.")
    (license license:expat)))

(define-public python-pydocstyle
  (package
    (name "python-pydocstyle")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydocstyle" version))
       (sha256
        (base32
         "1m1xv9clkg9lgzyza6dnj359z04vh5g0h49nhzghv7lg81gchhap"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-snowballstemmer))
    (home-page
     "https://github.com/PyCQA/pydocstyle/")
    (synopsis "Python docstring style checker")
    (description
     "This package provides a style checker for the Python Language
Server (PLS).")
    (license license:expat)))

(define-public python-lsp-server
  (package
    (name "python-lsp-server")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-lsp-server" version))
       (sha256
        (base32
         "0h6wxzmm6qjfwkkn3mnzn1fpmcp23fpbk74bi8p540q1nzccqj0v"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda _
             ;; Disable failing test.
             (invoke "python" "-m" "pytest" "-k"
                     "not test_pyqt_completion"))))))
    (propagated-inputs
     (list python-autopep8
           python-pydocstyle
           python-flake8
           python-future
           python-jedi
           python-lsp-jsonrpc
           python-pluggy
           python-pycodestyle
           python-pyflakes
           python-rope
           python-ujson
           python-yapf))
    (native-inputs
     (list python-coverage
           python-flaky
           python-matplotlib
           python-mock
           python-numpy
           python-pandas
           python-pylint
           python-pytest
           python-pytest-cov
           python-versioneer))
    (home-page "https://github.com/python-lsp/python-lsp-server")
    (synopsis "Python implementation of the Language Server Protocol")
    (description
"The Python Language Server @command{pylsp} is an implementation of the
Python 3 language specification for the Language Server Protocol (LSP).
This tool is used in text editing environments to provide a complete
and integrated feature-set for programming Python effectively.")
    (license license:expat)))

(define-public python-language-server
  (deprecated-package "python-language-server" python-lsp-server))

(define-public python-pathspec
  (package
    (name "python-pathspec")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathspec" version))
       (sha256
        (base32
         "1cdbdb3s6ldnjpwbi0bgl0xlmw4mbfxk08bbdxc3srx26na4jr75"))))
    (build-system python-build-system)
    (home-page "https://github.com/cpburnz/python-path-specification")
    (synopsis "Utility library for gitignore style pattern matching of file paths")
    (description
     "This package provides a utility library for gitignore style pattern
matching of file paths.")
    (license license:mpl2.0)))

(define-public python-black
  (package
    (name "python-black")
    (version "22.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "black" version))
       (sha256
        (base32
         "0yfahlqc7dsdp1js0cbv706apldnfnlbal9b53cww8n0hs40n0im"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'patch-source-shebangs 'use-absolute-file-names
           (lambda* (#:key native-inputs inputs #:allow-other-keys)
             (let* ((inpts (or native-inputs inputs))
                    (python3 (search-input-file inpts "/bin/python3")))
               (substitute* (find-files "tests" "\\.py$")
                 (("#!/usr/bin/env python3(\\.[0-9]+)?" _ minor-version)
                  (string-append "#!" python3 (if (string? minor-version)
                                                  minor-version
                                                  "")))))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-click
           python-attrs
           python-appdirs
           python-pathspec
           python-mypy-extensions
           python-platformdirs
           python-regex
           python-tomli
           python-typed-ast
           python-typing-extensions))
    (native-inputs
     (list python-pytest python-pytest-aiohttp python-setuptools-scm))
    (home-page "https://github.com/psf/black")
    (synopsis "The uncompromising code formatter")
    (description "Black is the uncompromising Python code formatter.")
    (license license:expat)))

(define-public python-black-macchiato
  (package
    (name "python-black-macchiato")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "black-macchiato" version))
       (sha256
        (base32
         "1drp5p697ni1xn5y2lbjpalgpkzy2i4cyxjj5pk4dxr0vk97dd7i"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-black))
    (home-page "https://github.com/wbolster/black-macchiato")
    (synopsis "Partial @code{python-black} formatting")
    (description
     "This package is built on top the @{python-black} code formatter to
enable formatting of partial files.")
    (license license:bsd-3)))

(define-public python-blinker
  (package
    (name "python-blinker")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "blinker" version))
       (sha256
        (base32
         "1dpq0vb01p36jjwbhhd08ylvrnyvcc82yxx3mwjx6awrycjyw6j7"))))
    (build-system python-build-system)
    (home-page "https://pythonhosted.org/blinker/")
    (synopsis "Fast, simple object-to-object and broadcast signaling")
    (description
     "Blinker provides a fast dispatching system that allows any number of
interested parties to subscribe to events, or \"signals\".")
    (license license:expat)))

(define-public pelican
  (package
    (name "pelican")
    (version "4.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pelican" version))
       (sha256
        (base32 "0m1kndc98hhnlq0yl05f4lzccw555pkxnrajj6lks18yh491kw8w"))))
    (build-system python-build-system)
    (inputs
     (list python-blinker
           python-dateutil
           ;; Ignoring `guix lint` warning as python-docutils is used to support
           ;; reStructuredText processing at runtime.
           python-docutils
           python-feedgenerator
           python-jinja2
           python-markdown
           python-pygments
           python-pytz
           python-rich
           python-unidecode))
    (home-page "https://blog.getpelican.com/")
    (arguments
     `(;; XXX Requires a lot more packages to do unit tests :P
       #:tests? #f))
    (synopsis "Python-based static site publishing system")
    (description
     "Pelican is a tool to generate a static blog from reStructuredText,
Markdown input files, and more.  Pelican uses Jinja2 for templating
and is very extensible.")
    (license license:agpl3+)))

(define-public mallard-ducktype
  (package
    (name "mallard-ducktype")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       ;; git-reference because tests are not included in pypi source tarball
       ;; https://issues.guix.gnu.org/issue/36755#2
       (uri (git-reference
             (url "https://github.com/projectmallard/mallard-ducktype")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1jk9bfz7g04ip78s03b0xak6d54rj4h9zpgadkziy1ji216g6y4c"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (with-directory-excursion "tests"
               (invoke "sh" "runtests")))))))
    (home-page "http://projectmallard.org")
    (synopsis "Convert Ducktype to Mallard documentation markup")
    (description
     "Ducktype is a lightweight syntax that can represent all the semantics
of the Mallard XML documentation system.  Ducktype files can be converted to
Mallard using the @command{ducktype} tool.  The yelp-tools package
provides additional functionality on the produced Mallard documents.")
    (license license:expat)))

(define-public python-cython
  (package
    (name "python-cython")
    (version "0.29.32")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Cython" version))
       (sha256
        (base32 "1xqsihpqnfal29nb5kmw8z71nd4jbsnbz7p3lkr094xpb13wycw7"))))
    (build-system python-build-system)
    ;; we need the full python package and not just the python-wrapper
    ;; because we need libpython3.3m.so
    (inputs
     (list python))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-HOME
           ;; some tests require access to "$HOME/.cython"
           (lambda _ (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             ;; Disable compiler optimizations to greatly reduce the running
             ;; time of the test suite.
             (setenv "CFLAGS" "-O0")

             (when tests?
               (invoke "python" "runtests.py" "-vv"
                       "-j" (number->string (parallel-job-count))
                       ;; XXX: On 32-bit architectures, running the parallel tests
                       ;; fails on many-core systems, see
                       ;; <https://github.com/cython/cython/issues/2807>.
                       ,@(if (not (target-64bit?))
                             '("-x" "run.parallel")
                             '())
                       ;; This test fails when running on 24 cores.
                       "-x" "cpp_stl_conversion")))))))
    (home-page "https://cython.org/")
    (synopsis "C extensions for Python")
    (description "Cython is an optimising static compiler for both the Python
programming language and the extended Cython programming language.  It makes
writing C extensions for Python as easy as Python itself.")
    (license license:asl2.0)))

(define-public python-cython-3
  (package
    (inherit python-cython)
    ;; Cython 3 is not officially released yet, so distinguish the name
    ;; for now.
    (name "python-cython-next")
    (version "3.0.0a10")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Cython" version))
              (sha256
               (base32
                "17fqacrpis05w1rpi7d7sbimrk20xf8h6d3vrz5nf6ix3899abil"))))
    (properties '())))

;; NOTE: when upgrading numpy please make sure that python-numba,
;; python-pandas and python-scipy still build, as these three packages are
;; often used together.
(define-public python-numpy
  (package
    (name "python-numpy")
    (version "1.21.6")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://github.com/numpy/numpy/releases/download/v"
             version "/numpy-" version ".tar.gz"))
       (sha256
        (base32
         "0b0c5y35rd3mvwfk5is1d5ppfw9nl4d2rgx9xkwh1p0w394wdvyl"))))
    (build-system python-build-system)
    (arguments
     (list
      #:modules '((guix build utils)
                  (guix build python-build-system)
                  (ice-9 format))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'parallelize-build
            (lambda _
              (setenv "NPY_NUM_BUILD_JOBS"
                      (number->string (parallel-job-count)))))
          (add-before 'build 'configure-blas
            (lambda* (#:key inputs #:allow-other-keys)
              (call-with-output-file "site.cfg"
                (lambda (port)
                  (format port
                          "\
[openblas]
libraries = openblas
library_dirs = ~a/lib
include_dirs = ~:*~a/include~%" #$(this-package-input "openblas"))))))
          (add-before 'build 'fix-executable-paths
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Make /gnu/store/...-bash-.../bin/sh the default shell,
              ;; instead of /bin/sh.
              (substitute* "numpy/distutils/exec_command.py"
                (("'/bin/sh'")
                 (format #f "~s" (search-input-file inputs "bin/bash"))))
              ;; Don't try to call '/bin/true' specifically.
              (substitute* "numpy/core/tests/test_cpu_features.py"
                (("/bin/true") (search-input-file inputs "bin/true")))))
          (replace 'check
            (lambda* (#:key tests? outputs inputs #:allow-other-keys)
              (when tests?
                (invoke "./runtests.py" "-vv" "--no-build" "--mode=fast"
                        "-j" (number->string (parallel-job-count))
                        ;; Contrary to scipy, the runtests.py script of numpy
                        ;; does *not* automatically provide -n when -j is used
                        ;; (see: https://github.com/numpy/numpy/issues/21359).
                        "--" "-n" (number->string (parallel-job-count))
                        "-k" (string-append
                              ;; These tests may fail on 32-bit systems (see:
                              ;; https://github.com/numpy/numpy/issues/18387).
                              "not test_float_remainder_overflow "
                              "and not test_pareto"
                              ;; These tests seem to fail on machines without
                              ;; an FPU is still under investigation upstream.
                              ;; https://github.com/numpy/numpy/issues/20635
                              #$@(if (target-riscv64?)
                                   `(" and not test_float"
                                     " and not test_fpclass")
                                   '())))))))))
    (native-inputs
     (list python-cython
           python-hypothesis-next
           python-pytest
           python-pytest-xdist
           gfortran))
    (inputs (list bash openblas))
    (home-page "https://numpy.org")
    (synopsis "Fundamental package for scientific computing with Python")
    (description "NumPy is the fundamental package for scientific computing
with Python.  It contains among other things: a powerful N-dimensional array
object, sophisticated (broadcasting) functions, tools for integrating C/C++
and Fortran code, useful linear algebra, Fourier transform, and random number
capabilities.")
    (properties
     '((upstream-name . "numpy")))
    (license license:bsd-3)))

(define-public python-numpy-next
  (package
    (inherit python-numpy)
    (name "python-numpy-next")
    (version "1.22.3")
    (source
     (origin
       (inherit (package-source python-numpy))
       (method url-fetch)
       (uri (string-append
             "https://github.com/numpy/numpy/releases/download/v"
             version "/numpy-" version ".tar.gz"))
       (sha256
        (base32
         "19dw91pqbqcniw2z57kiyqs1qp56g7kqy1bdyv664g8s62sc01m9"))))))

(define-public python-numpy-documentation
  (package
    (inherit python-numpy)
    (name "python-numpy-documentation")
    (arguments
     (list
      #:tests? #f                     ;we're only generating the documentation
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'add-gnu-freefont-to-texmf
            (lambda _
              ;; XXX: The Sphinx-generated tex output specifies the GNU
              ;; FreeFont font to be searched via its extension, which uses
              ;; kpathsea instead of fontconfig and fail (see:
              ;; https://github.com/sphinx-doc/sphinx/issues/10347).  Create a
              ;; symlink to GNU FreeFont and add it to the TEXMF tree via
              ;; GUIX_TEXMF.
              (mkdir-p "texmf-dist/fonts/opentype/public")
              (symlink (string-append
                        #$(this-package-native-input "font-gnu-freefont")
                        "/share/fonts/opentype")
                       (string-append
                        (getcwd) "/"
                        "texmf-dist/fonts/opentype/public/gnu-freefont"))
              (setenv "GUIX_TEXMF" (string-append (getenv "GUIX_TEXMF") ":"
                                                  (getcwd) "/texmf-dist"))))
          (delete 'build)
          (replace 'install
            (lambda _
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/numpy"))
                     (html (string-append doc "/html"))
                     (info (string-append data "/info"))
                     (sphinxopts (string-append
                                  "SPHINXOPTS=-j"
                                  (number->string (parallel-job-count)))))
                (with-directory-excursion "doc"
                  ;; Do not treat warnings as errors.
                  (substitute* "Makefile"
                    ((" -WT ") " -T "))
                  (setenv "HOME" "/tmp")
                  ;; Build the PDF documentation.
                  (invoke "make" "latex-build" sphinxopts)
                  (invoke "make" "-C" "build/latex" "all-pdf" sphinxopts)
                  ;; Build the HTML documentation
                  (invoke "make" "html" sphinxopts)
                  ;; Build the Info documentation.  The issues worked around
                  ;; below can be tracked at
                  ;; https://github.com/numpy/numpy/issues/12278.
                  (substitute* "source/conf.py"
                    ;; The root document should be "index", not "contents".
                    (("\"contents\"") "'index'")
                    ;; Disable Sphinx extensions that produce broken Texinfo.
                    ((".*'numpydoc'.*") "")
                    ((".*'sphinx.ext.autosummary'.*") ""))
                  (invoke "make" "info" sphinxopts)
                  ;; Install the HTML documentation.
                  (mkdir-p html)
                  (copy-recursively "build/html" html)
                  ;; Install the PDF reference and user manuals.
                  (install-file "build/latex/numpy-ref.pdf" doc)
                  (install-file "build/latex/numpy-user.pdf" doc)
                  ;; Install the info manual.
                  (install-file "build/texinfo/numpy.info" info)
                  (symlink (string-append html "/_images")
                           (string-append info "/numpy-figures")))))))))
    (native-inputs
     (list font-gnu-freefont
           perl
           python-breathe
           python-ipython
           python-matplotlib
           python-numpy
           python-numpydoc
           python-pandas
           python-pydata-sphinx-theme
           python-scipy                 ;used by matplotlib
           python-sphinx-4
           python-sphinx-panels
           texinfo
           texlive-bin
           texlive-cbfonts
           texlive-cm-super
           texlive-greek-fontenc
           texlive-latex-expdlist
           texlive-polyglossia
           texlive-xindy))
    (inputs '())
    (propagated-inputs '())
    (synopsis "Documentation for the @code{python-numpy} package")
    (description "This package provides the complete NumPy documentation in
the Texinfo, HTML, and PDF formats.")))

(define-public python-munch
  (package
    (name "python-munch")
    (version "2.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "munch" version))
        (sha256
         (base32
          "1lnvlic9g68hcmgdnv5bzp0nx2bf1kjclj54gx0s7nyl4ipmywrd"))))
    (build-system python-build-system)
    (native-inputs (list python-pbr python-pytest))
    (propagated-inputs (list python-six))
    (home-page "https://github.com/Infinidat/munch")
    (synopsis "Dot-accessible dictionary")
    (description "Munch is a dot-accessible dictionary similar to JavaScript
objects.")
    (license license:expat)))

(define-public python-colormath
  (package
    (name "python-colormath")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colormath" version))
       (sha256
        (base32
         "05qjycgxp3p2f9n6lmic68sxmsyvgnnlyl4z9w7dl9s56jphaiix"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-networkx python-numpy))
    (home-page "https://github.com/gtaylor/python-colormath")
    (synopsis "Color math and conversion library")
    (description
     "This is a Python library for color math and conversions.")
    (license license:bsd-3)))

(define-public python-sparse
  (package
    (name "python-sparse")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sparse" version))
       (sha256
        (base32
         "05ar1lhq1yy4nb78s7vpb1wz4ac4kj0r4lrd7yrf23kpmaacjpb8"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "pytest" "-v")))))))
    (propagated-inputs
     (list python-numba python-numpy python-scipy))
    (native-inputs
     (list python-dask python-pytest python-pytest-black
           python-pytest-cov))
    (home-page "https://github.com/pydata/sparse/")
    (synopsis "Library for multi-dimensional sparse arrays")
    (description
     "This package implements sparse arrays of arbitrary dimension on top of
@code{numpy} and @code{scipy.sparse}.  Sparse array is a matrix in which most
of the elements are zero.  @code{python-sparse} generalizes the
@code{scipy.sparse.coo_matrix} and @code{scipy.sparse.dok_matrix} layouts, but
extends beyond just rows and columns to an arbitrary number of dimensions.
Additionally, this project maintains compatibility with the
@code{numpy.ndarray} interface rather than the @code{numpy.matrix} interface
used in @code{scipy.sparse}.  These differences make this project useful in
certain situations where @code{scipy.sparse} matrices are not well suited, but
it should not be considered a full replacement.  It lacks layouts that are not
easily generalized like @dfn{compressed sparse row/column}(CSR/CSC) and
depends on @code{scipy.sparse} for some computations.")
    (license license:bsd-3)))

(define-public python-spectra
  (package
    (name "python-spectra")
    (version "0.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "spectra" version))
       (sha256
        (base32
         "1f322x914bhkg6r5gv1vmnir3iy0k5kih0fd2gp3rdkw32jn5cwf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "nosetests" "-v"))))))
    (propagated-inputs
     (list python-colormath))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/jsvine/spectra")
    (synopsis "Color scales and color conversion")
    (description
     "This package provides a Python library intended to make color math,
color scales, and color space conversion easy.  It has support for:

@enumerate
@item Color scales
@item Color ranges
@item Color blending
@item Brightening/darkening colors
@item Saturating/desaturating colors
@item Conversion to/from multiple color spaces.
@end enumerate\n")
    (license license:expat)))

(define-public python-pyspnego
  (package
    (name "python-pyspnego")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/jborean93/pyspnego")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0pfh2x0539f0k2qi2pbjm64b2fqp64c63xxpinvg1yfaw915kgpb"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest")))))))
    (native-inputs
     (list python-pytest python-pytest-mock))
    (propagated-inputs
     (list python-cryptography python-gssapi python-ruamel.yaml))
    (home-page "https://github.com/jborean93/pyspnego")
    (synopsis "Python SPNEGO library")
    (description "The @code{pyspnego} Python library handles Negotiate, NTLM,
Kerberos (SPNEGO) and CredSSP authentication.  It also includes a packet
parser that can be used to decode raw NTLM/SPNEGO/Kerberos tokens into a human
readable format.")
    (license license:expat)))

(define-public python-pygit2
  (package
    (name "python-pygit2")
    (version "1.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygit2" version))
       (sha256
        (base32 "068bwhirigbh2435abyv4shdxgxvyfqf4dxfmhd4hihivwrl9290"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-v")))))))
    (propagated-inputs
     (list python-cached-property python-cffi libgit2))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/libgit2/pygit2")
    (synopsis "Python bindings for libgit2")
    (description "Pygit2 is a set of Python bindings to the libgit2 shared library.")
    ;; GPL2.0 only, with linking exception.
    (license license:gpl2)))

(define-public python-patiencediff
  (package
    (name "python-patiencediff")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "patiencediff" version))
        (sha256
         (base32
          "0yjk50lsd4gnllxls925xbcdxwvmda37w2a1shk0p1nvl3fcha6q"))))
    (build-system python-build-system)
    (home-page "https://www.breezy-vcs.org/")
    (synopsis "Python implementation of the patiencediff algorithm")
    (description
     "This package contains a Python implementation of the @code{patiencediff}
algorithm.  Patiencediff provides a good balance of performance, nice output for
humans, and implementation simplicity.")
    (license license:gpl2)))

(define-public python-wmctrl
  (package
    (name "python-wmctrl")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wmctrl" version))
       (sha256
        (base32
         "1q0l1sqnj5wma87k3dsgmsyph464syjc6fl8qcpa41nan1rgzjv6"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'patch-paths
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((wmctrl (assoc-ref inputs "wmctrl")))
                        (substitute* "wmctrl.py"
                          (("'wmctrl")
                           (string-append "'" wmctrl "/bin/wmctrl")))))))))
    (inputs (list wmctrl))
    (propagated-inputs (list python-attrs))
    (home-page "https://github.com/antocuni/wmctrl")
    (synopsis "Tool to programmatically control Xorg windows")
    (description "This package provides a library for programmatically
controlling Xorg windows using Python.  The library relies on the
@command{wmctrl} to do so.")
    (license license:expat)))

(define-public python-fancycompleter
  (package
    (name "python-fancycompleter")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fancycompleter" version))
       (sha256
        (base32 "0wkj4h01pxa8prv59zl09a0i3w26k835bfpjgvyvsai4mswgxq09"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'fix-setup.py
                    (lambda _
                      (substitute* "setup.py"
                        ((".*setupmeta.*")
                         "")
                        (("versioning=.*")
                         (string-append "version='" ,version "',"))
                        ((".*pyrepl.*") ;broken on Python 3
                         "")))))))
    (home-page "https://github.com/pdbpp/fancycompleter")
    (synopsis "TAB completion library for Python")
    (description "@code{fancycompleter} is a module that adds TAB completion
to the interactive prompt.  It is an extension of the @code{rlcompleter}
module from the standard Python library.")
    (license license:bsd-3)))

(define-public python-ipdb
  (package
    (name "python-ipdb")
    (version "0.13.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipdb" version))
       (sha256
        (base32 "1ibql99agjf2gj7y0svzd5m0h81hailf4p3sj3yl9i1i8ykdj6wm"))))
    (build-system python-build-system)
    (arguments
     (list #:phases #~(modify-phases %standard-phases
                        (replace 'check
                          (lambda* (#:key tests? #:allow-other-keys)
                            (when tests?
                              (invoke "python" "-m" "unittest" "discover")))))))
    (propagated-inputs (list python-ipython python-toml python-decorator))
    (home-page "https://github.com/gotcha/ipdb")
    (synopsis "IPython-enhanced Python debugger (pdb)")
    (description "@code{ipdb} exports functions to access the IPython
debugger, which features tab completion, syntax highlighting, better
tracebacks and better introspection than Python's standard @command{pdb}
debugger, with which it shares the same interface.")
    (license license:bsd-3)))

(define-public python-pdbpp
  (package
    (name "python-pdbpp")
    (version "0.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pdbpp" version))
       (sha256
        (base32
         "1xb9yvi30rb1cdpvfdk2kg79vh3anvkz91r8bwvfp3iqv97kzr6r"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest"
                       "-k"
                       (string-append
                        ;; These tests seem to require a real TTY.
                        "not interaction_restores_previous_sigint_handler "
                        "and not python_m_pdb_uses_pdbpp"))))))))
    (propagated-inputs
     (list python-fancycompleter python-pygments python-wmctrl))
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (home-page "https://github.com/pdbpp/pdbpp")
    (synopsis "Drop-in replacement for pdb")
    (description "Pdb++ is a drop-in replacement for @code{pdb}.  It
includes the following improvements compared to @code{pdb}:
@itemize
@item auto-completion
@item syntax highlighting of code listings
@item sticky mode
@item new commands to be used from the interactive (Pdb++) prompt
@item smart command parsing
@item additional convenience functions in the @code{pdb} module.
@end itemize")
    (license license:bsd-3)))

(define-public python-pdftotext
  (package
    (name "python-pdftotext")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pdftotext" version))
       (sha256
        (base32 "1555wbgr5spj8xflrs4mwsrdmba2f9s72nk50xzqk9ghxaxdvy6a"))))
    (build-system python-build-system)
    (inputs
     (list poppler))
    (home-page "https://github.com/jalan/pdftotext")
    (synopsis "Simple PDF text extraction")
    (description "Pdftotext is a Python library of PDF text extraction.")
    (license license:expat)))

(define-public python-pluginbase
  (package
    (name "python-pluginbase")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pluginbase" version))
       (sha256
        (base32
         "11z2vvbp13828y0x3w39f29p9r9xcix7h7c4fff2w8yfiylk6v7z"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "make" "test")))))))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/mitsuhiko/pluginbase")
    (synopsis "Simple but flexible plugin system for Python")
    (description "PluginBase is a library useful in the development of
flexible plugin systems in Python.")
    (license license:bsd-3)))

(define-public python-node-semver
  (package
    (name "python-node-semver")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "node-semver" version))
       (sha256
        (base32
         "000ypfns5x72b41w5f9pk6k3jnr35scliqfbvmilyvv0178005i8"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/podhmo/python-node-semver")
    (synopsis "Python port of node-semver")
    (description "This module provides a Python version of node-semver, a
semantic version parser for Node.js.")
    (license license:expat)))

(define-public python-patch-ng
  (package
    (name "python-patch-ng")
    (version "1.17.4")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/conan-io/python-patch-ng")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0qxn4ss2s54qy87xrpcybz26kp2fwlaq41x4k9jcmp6d7p0w569m"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "tests/run_tests.py" "-v")))))))
    (home-page "https://github.com/conan-io/python-patch-ng")
    (synopsis "Python library to parse and apply unified diffs")
    (description "Patch NG (New Generation) is a command and Python library to
parse and apply unified diffs.  It has features such as:
@itemize
@item automatic correction of common patch formatting corruption
@item patch format detection (SVN, Hg, Git)
@item nice diffstat histogram.
@end itemize")
    (license license:expat)))

(define-public python-numpydoc
  (package
    (name "python-numpydoc")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numpydoc" version))
       (sha256
        (base32
         "1xjsli2fqks4iv3524v1d329siad7bbsi4kr174zvhsl1pnjds3w"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "setup.py"
               (("'Jinja2>=2.10,<3.1'")
                "'Jinja2>=2.10'"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-v" "numpydoc/tests"
                       ;; TODO: unclear why these fail.
                       "-k" "not test_MyClass and not test_my_function")))))))
    (propagated-inputs (list python-jinja2 python-sphinx))
    (native-inputs (list python-matplotlib python-pytest python-pytest-cov))
    (home-page "https://pypi.org/project/numpydoc/")
    (synopsis "Numpy's Sphinx extensions")
    (description "Sphinx extension to support docstrings in Numpy format.")
    (license license:bsd-2)))

(define-public python-numexpr
  (package
    (name "python-numexpr")
    (version "2.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numexpr" version))
       (sha256
        (base32
         "09d8yfsx33ddwfkpn8805w2mxnn4cvf47yc66g4azldpz4lnaqa3"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))          ; no tests included
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/pydata/numexpr")
    (synopsis "Fast numerical expression evaluator for NumPy")
    (description
     "Numexpr is a fast numerical expression evaluator for NumPy.  With it,
expressions that operate on arrays are accelerated and use less memory than
doing the same calculation in Python.  In addition, its multi-threaded
capabilities can make use of all your cores, which may accelerate
computations, most specially if they are not memory-bounded (e.g. those using
transcendental functions).")
    (license license:expat)))

(define-public python-cycler
  (package
    (name "python-cycler")
    (version "0.10.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cycler" version))
              (sha256
               (base32
                "1n69n23fak1gjxlrbhqisi2b9pv3ckrfj98llx3p53953082syyd"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: The current version requires 'coveralls' which we don't have.
     ;; Enable this for the next release which uses 'python-pytest'.
     '(#:tests? #f))
    (propagated-inputs
     (list python-six))
    (home-page "https://matplotlib.org/cycler/")
    (synopsis "Composable keyword argument iterator")
    (description
     "When using @code{matplotlib} and plotting more than one line, it is
common to want to be able to want to be able to cycle over one or more artist
styles; but the plotting logic can quickly become involved.
To address this and enable easy cycling over arbitrary @code{kwargs}, the
@code{Cycler} class was developed.")
    (license license:bsd-3)))

(define-public python-colorspacious
  (package
    (name "python-colorspacious")
    (version "1.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/njsmith/colorspacious")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x7nkphr6g5ql5fvgss8l56rgiyjgh6fm8zzs73i94ci9wzlm63w"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list python-nose))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "nosetests" "--all-modules" "-v" "colorspacious"))))))
    (home-page "https://github.com/njsmith/colorspacious")
    (synopsis "Python library for colorspace conversions")
    (description "@code{colorspacious} is a Python library that lets you
convert between colorspaces like sRGB, XYZ, CIEL*a*b*, CIECAM02, CAM02-UCS, etc.")
    (license license:expat)))

(define-public python-proto-matcher
  (package
    (name "python-proto-matcher")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "proto_matcher" version))
       (sha256
        (base32 "1644x0hrl398ji3281n44ymfgc3cspzfagjckhqjn4nja5nlikxg"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;no test suite
    (propagated-inputs
     (list python-protobuf python-pyhamcrest))
    (home-page "https://github.com/dayfine/proto-matcher")
    (synopsis "PyHamcrest test matchers for protocol buffers")
    (description "This package provides the following PyHamcrest test
matchers, that enable matching a protocol buffer message:
@table @code
@item equals_proto
Test the argument equals the given protobuf message.
@item approximately
Test the argument equals the given protobuf message, while comparing any float
field using approximation.
@item ignoring_field_paths
Test the argument equals the given protobuf message, while ignoring those
fields specified in the field paths.
@item ignoring_repeated_field_ordering
Test the argument equals the given protobuf message, ignoring the ordering of
any repeated field.
@item partially
Test the argument partially equals the given protobuf message, i.e. if a field
is in the argument but not in the expected message, it's ignored in the
comparison.
@end table")
    (license license:asl2.0)))

(define-public python-matplotlib
  (package
    (name "python-matplotlib")
    (version "3.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib" version))
       (sha256
        (base32 "18h78s5ld1i6mz00w258hy29909nfr3ddq6ry9kq18agw468bks8"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            ;; The version string is usually derived via setuptools-scm, but
            ;; without the git metadata available, the version string is set to
            ;; '0.0.0'.
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)))
          (add-after 'unpack 'fix-and-disable-failing-tests
            ;; XXX: Disable all image comparison tests because we're using a
            ;; newer version of FreeType than matplotlib expects.  This leads
            ;; to minor differences throughout the tests.
            (lambda _
              (substitute* (append (find-files "lib/matplotlib/tests/"
                                               "test_.*\\.py$")
                                   (find-files "lib/mpl_toolkits/tests"
                                               "test_.*\\.py$"))
                (("^from matplotlib" match)
                 (string-append "import pytest\n" match))
                (("( *)@([^_]+_)*(image_comparison|check_figures_equal)" match
                  indent)
                 (string-append indent "@pytest.mark.skip(\
reason=\"unknown minor image differences\")\n" match)))
              (substitute* "lib/matplotlib/tests/test_animation.py"
                (("/bin/sh") (which "sh")))
              (for-each delete-file
                        ;; test_normal_axes, test_get_tightbbox_polar
                        '("lib/matplotlib/tests/test_axes.py"
                          "lib/matplotlib/tests/test_polar.py"
                          ;; We don't use the webagg backend and this test
                          ;; forces it.
                          "lib/matplotlib/tests/test_backend_webagg.py"
                          ;; test_outward_ticks
                          "lib/matplotlib/tests/test_tightlayout.py"
                          ;; test_hidden_axes fails with minor extent
                          ;; differences, possibly due to the use of a
                          ;; different version of FreeType.
                          "lib/matplotlib/tests/test_constrainedlayout.py"
                          ;; Fontconfig returns no fonts.
                          "lib/matplotlib/tests/test_font_manager.py"
                          ;; The images comparison test fails
                          ;; non-deterministically when run in parallel (see:
                          ;; https://github.com/matplotlib/matplotlib/issues/22992).
                          "lib/matplotlib/tests/test_compare_images.py"))))
          (add-before 'build 'configure-environment
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Fix rounding errors when using the x87 FPU.
              (when (string-prefix? "i686" #$(%current-system))
                (setenv "CFLAGS" "-ffloat-store"))
              (call-with-output-file "mplsetup.cfg"
                (lambda (port)
                  (format port "\
[libs]
system_freetype = true
system_qhull = true

[rc_options]
backend=Agg

[directories]
basedirlist = ~a,~a

[packages]
tests = True~%" (assoc-ref inputs "tcl") (assoc-ref inputs "tk"))))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Step out of the source directory to avoid interference.
                (with-directory-excursion "/tmp"
                  ;; Run the installed tests, which is what we want since not
                  ;; everything gets built in the source directory.
                  (invoke "pytest"
                          "-n" (number->string (parallel-job-count))
                          "-m" "not network" "--pyargs" "matplotlib"
                          ;; The 'test_lazy_auto_backend_selection' fails
                          ;; because it would require an X server; skip it.
                          "-k" "not test_lazy_auto_backend_selection"))))))))
    (propagated-inputs
     (list gobject-introspection
           python-cairocffi
           python-certifi
           python-cycler
           python-dateutil
           python-fonttools
           python-kiwisolver
           python-numpy
           python-packaging
           python-pillow
           ;; ;; 'pycairo'.  However, 'pygobject' makes use of a 'pycairo' 'context'
           ;; ;; From version 1.4.0 'matplotlib' makes use of 'cairocffi' instead of
           ;; ;; https://cairocffi.readthedocs.io/en/stable/cffi_api.html#converting-pycairo-wrappers-to-cairocffi
           ;; ;; object.  For this reason we need to import both libraries.
           ;; python-pycairo
           python-pygobject
           python-pyparsing
           python-pytz
           python-six
           `(,python "tk")
           python-wxpython))
    (inputs
     (list cairo
           freetype
           glib
           libpng
           qhull
           tcl
           tk))
    (native-inputs
     (list pkg-config
           python-pytest
           python-pytest-timeout
           python-pytest-xdist
           python-setuptools-scm
           python-setuptools-scm-git-archive))
    (home-page "https://matplotlib.org/")
    (synopsis "2D plotting library for Python")
    (description
     "Matplotlib is a Python 2D plotting library which produces publication
quality figures in a variety of hardcopy formats and interactive environments
across platforms.  Matplotlib can be used in Python scripts, the python and
ipython shell, web application servers, and six graphical user interface
toolkits.")
    (license license:psfl)))

(define-public python-matplotlib-documentation
  (package
    (inherit python-matplotlib)
    (name "python-matplotlib-documentation")
    (arguments
     (list
      #:tests? #f                       ;we're only generating documentation
      #:phases
      #~(modify-phases %standard-phases
          (replace 'build
            (lambda _
              (setenv "HOME" "/tmp")
              (chdir "doc")
              (substitute* "conf.py"
                ;; The sphinx_panels extension causes a "TypeError: first
                ;; argument must be callable" to be raised when generating the
                ;; info target; remove it (see:
                ;; https://github.com/executablebooks/sphinx-panels/issues/74).
                ((".*'sphinx_panels',.*") ""))
              (invoke "make" "html" "info"
                      ;; Don't abort on warnings; build in parallel.
                      (format #f "SPHINXOPTS=-j~a" (parallel-job-count)))))
          (replace 'install
            (lambda _
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/matplotlib"))
                     (info (string-append data "/info"))
                     (html (string-append doc "/html")))
                (mkdir-p html)
                (copy-recursively "build/html" html)
                (install-file "build/texinfo/matplotlib.info" info)
                ;; The "matplotlib-figures" directory contains are a subset of
                ;; the images produced for the html target; simply create a
                ;; symlink to it, saving about 11 MiB.
                (symlink (string-append html "/_images")
                         (string-append info "/matplotlib-figures"))))))))
    (native-inputs
     (list graphviz
           inkscape/stable
           python-colorspacious
           python-mpl-sphinx-theme
           python-scipy
           python-sphinx
           python-sphinx-copybutton
           python-sphinx-gallery
           python-sphinxcontrib-svg2pdfconverter
           python-numpydoc
           python-ipython
           python-ipywidgets
           texlive-amsfonts
           texlive-amsmath
           texlive-babel
           texlive-fontspec
           texlive-unicode-math
           texlive-etoolbox
           texlive-latex-expdlist
           texlive-underscore
           texlive-latex-type1cm
           texlive-times
           texinfo))
    (synopsis "Documentation for the @code{python-matplotlib} package")))

(define-public python-matplotlib-inline
  (package
    (name "python-matplotlib-inline")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib-inline" version))
       (sha256
        (base32 "1vilzwj3xp00mxprmmn1hlafm3p23vn56s46kx3ra4qd5signjx0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-matplotlib python-traitlets))
    (arguments
     ;; Tests disabled because of a circular dependency with ipython.
     `(#:tests? #f))
    (home-page "https://github.com/ipython/matplotlib-inline")
    (synopsis "Inline Matplotlib backend for Jupyter")
    (description
     "This package provides a Matplotlib inline back-end for IPython and
Jupyter.")
    (license license:bsd-3)))

(define-public python-matplotlib-venn
  (package
    (name "python-matplotlib-venn")
    (version "0.11.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib-venn" version ".zip"))
       (sha256
        (base32
         "13w3i1wih0mij08hrgppzg0g9z50y54rc28l6gdi1r5w45l7l0dy"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; tests are not included
    (propagated-inputs
     (list python-matplotlib python-numpy python-scipy))
    (native-inputs
     (list unzip))
    (home-page "https://github.com/konstantint/matplotlib-venn")
    (synopsis "Plot area-proportional Venn diagrams")
    (description
     "This package provides tools for plotting area-proportional two- and
three-way Venn diagrams in @code{matplotlib}.")
    (license license:expat)))

(define-public python-pysnptools
  (package
    (name "python-pysnptools")
    (version "0.4.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pysnptools" version))
       (sha256
        (base32
         "0gxr0bjix307wvk0qh7vkafbxbzfpdmq0wlswpxyyaymy0fwcypv"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; no test data are included
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (if tests?
                 (begin
                   (add-installed-pythonpath inputs outputs)
                   (invoke "python3" "pysnptools/test.py"))
                 #t))))))
    (propagated-inputs
     (list python-dill
           python-h5py
           python-numpy
           python-pandas
           python-psutil
           python-scipy))
    (native-inputs
     (list python-cython))
    (home-page "http://microsoftgenomics.github.io/PySnpTools/")
    (synopsis "Library for reading and manipulating genetic data")
    (description
     "PySnpTools is a library for reading and manipulating genetic data.  It
can, for example, efficiently read whole PLINK *.bed/bim/fam files or parts of
those files.  It can also efficiently manipulate ranges of integers using set
operators such as union, intersection, and difference.")
    (license license:asl2.0)))

(define-public python-pykdtree
  (package
    (name "python-pykdtree")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pykdtree" version))
       (sha256
        (base32 "0p8n2ljdacfixkiw092974dmhy4s1c0h032ii1z9kwi9h5h5rgmy"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/storpipfugl/pykdtree")
    (synopsis "Fast kd-tree implementation with OpenMP-enabled queries")
    (description
     "@code{pykdtree} is a kd-tree implementation for fast nearest neighbour
search in Python.")
    (license license:lgpl3+)))

(define-public python-wurlitzer
  (package
    (name "python-wurlitzer")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wurlitzer" version))
       (sha256
        (base32 "0hvmbc41kdwrjns8z1s4a59a4azdvzb8q3vs7nn1li4qm4l0g3yh"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv" "test.py"))))))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://github.com/minrk/wurlitzer")
    (synopsis "Capture C-level output in context managers")
    (description
     "This library helps to redirect @code{sys.stdout} to a stream or a file
while executing some piece of code, including C code running within a Python
process.")
    (license license:expat)))

(define-public python-socksipy-branch
  (package
    (name "python-socksipy-branch")
    (version "1.01")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "SocksiPy-branch" version))
       (sha256
        (base32
         "01l41v4g7fy9fzvinmjxy6zcbhgqaif8dhdqm4w90fwcw9h51a8p"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; There are no tests
    (home-page "https://code.google.com/archive/p/socksipy-branch/")
    (synopsis "Python SOCKS module")
    (description
     "SocksiPy - A Python SOCKS client module.  It provides a
socket-like interface that supports connections to any TCP
service through the use of a SOCKS4, SOCKS5 or HTTP proxy.
The original version was developed by Dan Haim, this is a
branch created by Mario Vilas to address some open issues,
as the original project seems to have been abandoned circa 2007.")
    (license license:bsd-3)))

(define-public python-socksipychain
  (package
    (name "python-socksipychain")
    (version "2.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pagekite/PySocksipyChain")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "02pp994qmiivkdx4y6az5q80l6rzy8g6d2ipvp7kns7lsxvmc2y7"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                  ; Tests try to access the network.
    (propagated-inputs
     (list python-six))
    (home-page "http://pagekite.net/wiki/Floss/PySocksipyChain/")
    (synopsis "Python SOCKS module with chained proxies support")
    (description
     "SocksiPyChain is a modified version of the SocksiPy SOCKS module, which
adds support for arbitrary chaining of proxy servers and various modes of
TLS/SSL encryption.  It was developed for use in PageKite, and also includes
a simple netcat replacement with chaining support.")
    (license license:bsd-3)))

(define-public python-pycodestyle
  (package
    (name "python-pycodestyle")
    (version "2.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycodestyle" version))
       (sha256
        (base32
         "0zxyrg8029lzjhima6l5nk6y0z6lm5wfp9qchz3s33j3xx3mipgd"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://pycodestyle.readthedocs.io/")
    (synopsis "Python style guide checker")
    (description "@code{pycodestyle} (formerly pep8) is a tool to check
Python code against some of the style conventions in
@url{http://www.python.org/dev/peps/pep-0008/,PEP 8}.")
    (license license:expat)))

(define-public python-pycodestyle-2.6
  (package
    (inherit python-pycodestyle)
    (version "2.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pycodestyle" version))
              (sha256
               (base32
                "0bhr6ia0hmgx3nhgibc9pmkzhlh1zcqk707i5fbxgs702ll7v2n5"))))))

(define-public python-multidict
  (package
    (name "python-multidict")
    (version "5.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "multidict" version))
       (sha256
        (base32
         "1kjrxav572j45xvr1iy60zb2g8zqvrinzdkl4ax36js4vczckl8d"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv")
                          (format #t "test suite not run~%")))))))
    (native-inputs
     (list python-pytest python-pytest-cov))
    (home-page "https://github.com/aio-libs/multidict/")
    (synopsis "Multidict implementation")
    (description "Multidict is dict-like collection of key-value pairs
where key might be occurred more than once in the container.")
    (license license:asl2.0)))

(define-public python-orderedmultidict
  (package
    (name "python-orderedmultidict")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "orderedmultidict" version))
        (sha256
          (base32
            "1bc2v0yflsxjyyjx4q9wqx0j3bvzcw9z87d5pz4iqac7bsxhn1q4"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (native-inputs
     (list python-flake8 python-pycodestyle))
    (home-page "https://github.com/gruns/orderedmultidict")
    (synopsis "Python Ordered Multivalue Dictionary - omdict")
    (description "This package contains a library for ordered multivalue
dictionaries.  A multivalue dictionary is a dictionary that can store
multiple values for the same key.  An ordered multivalue dictionary is a
multivalue dictionary that retains the order of insertions and deletions.")
    (license license:unlicense)))

(define-public python-autocommand
  (package
    (name "python-autocommand")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autocommand" version))
       (sha256
        (base32 "03qp9xx4dq81ljhf56r21gp5j0lpqs1vaw99g0d84i97s3lj1m7y"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; This test fails with an invalid syntax error on 'task1 =
                ;; asyncio.async(coro_1())' (see:
                ;; https://github.com/Lucretiel/autocommand/issues/20).
                (delete-file "test/test_autoasync.py")
                (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest python-pytest-asyncio))
    (home-page "https://github.com/Lucretiel/autocommand")
    (synopsis "Python library to build a command-line from a function")
    (description "@code{autocommand} is library to automatically generate and
run simple @code{argparse} parsers from function signatures.")
    (license license:lgpl3+)))

(define-public python-autopage
  (package
    (name "python-autopage")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "autopage" version))
              (sha256
               (base32
                "169ixll1ncm2a2pcc86665ikjv2lrzs10p6c1w4yj55p3gk3xgh1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'disable-e2e-tests
            (lambda _
              ;; These tests rely on KeyboardInterrupts which do not
              ;; work in the build container.
              (delete-file "autopage/tests/test_end_to_end.py"))))))
    (native-inputs
     (list python-pypa-build
           python-setuptools
           python-wheel
           ;; For tests.
           python-fixtures
           python-pytest
           python-testtools))
    (home-page "https://github.com/zaneb/autopage")
    (synopsis "Automatic paging for console output")
    (description
     "Autopage is a Python library to automatically display terminal output
from a program in a @dfn{pager} such as @command{less}.")
    (license license:asl2.0)))

(define-public python-autopep8
  (package
    (name "python-autopep8")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autopep8" version))
       (sha256
        (base32
         "1w6vh627vrmgfbvrdcxrc3k4gxcldrb2lpgxv9irkdds851qrzb0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pycodestyle python-toml))
    (home-page "https://github.com/hhatto/autopep8")
    (synopsis "Format Python code according to the PEP 8 style guide")
    (description
     "@code{autopep8} automatically formats Python code to conform to
the PEP 8 style guide.  It uses the pycodestyle utility to determine
what parts of the code needs to be formatted.  @code{autopep8} is
capable of fixing most of the formatting issues that can be reported
by pycodestyle.")
    (license (license:non-copyleft
              "https://github.com/hhatto/autopep8/blob/master/LICENSE"))))

(define-public python-distlib
  (package
    (name "python-distlib")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "distlib" version ".zip"))
       (sha256
        (base32
         "1wdzv7fsjhrkhh1wfkarlhcwa8m00mgcpdsvknmf2qy8f9l13xpd"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'no-/bin/sh
           (lambda _
             (substitute* '("distlib/scripts.py" "tests/test_scripts.py")
               (("/bin/sh") (which "sh")))
             #t))
         (add-before 'check 'prepare-test-env
           (lambda _
             (setenv "HOME" "/tmp")
             ;; NOTE: Any value works, the variable just has to be present.
             (setenv "SKIP_ONLINE" "1")
             #t)))))
    (native-inputs (list unzip))
    (home-page "https://bitbucket.org/pypa/distlib")
    (synopsis "Distribution utilities")
    (description "Distlib is a library which implements low-level functions that
relate to packaging and distribution of Python software.  It is intended to be
used as the basis for third-party packaging tools.")
    (license license:psfl)))

(define-public python-distutils-extra
  (package
    (name "python-distutils-extra")
    (version "2.38")
    (source
     (origin
      (method url-fetch)
      (uri (string-append "https://launchpad.net/python-distutils-extra/trunk/"
                          version "/+download/python-distutils-extra-"
                          version ".tar.gz"))
      (sha256
       (base32
        "0lx15kcbby9zisx33p2h5hgakgwh2bvh0ibag8z0px4j6ifhs41x"))))
    (build-system python-build-system)
    (home-page "https://launchpad.net/python-distutils-extra/")
    (synopsis "Enhancements to Python's distutils")
    (description
     "The python-distutils-extra module enables you to easily integrate
gettext support, themed icons, and scrollkeeper-based documentation into
Python's distutils.")
    (license license:gpl2)))

(define-public python-olefile
  (package
    (name "python-olefile")
    (version "0.46")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://github.com/decalage2/olefile/releases/"
                           "download/v" version "/olefile-" version ".tar.gz"))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kjxh4gr651hpqkjfv89cfzr40hyvf3vjlda7mifiail83j7j07m"))))
    (build-system python-build-system)
    (home-page "https://www.decalage.info/python/olefileio")
    (synopsis "Read and write Microsoft OLE2 files")
    (description
     "@code{olefile} can parse, read and write Microsoft OLE2 files (Structured
Storage or Compound Document, Microsoft Office).  It is an improved version of
the OleFileIO module from PIL, the Python Image Library.")
    (license license:bsd-3)))

(define-public python-pypdf3
  (package
    (name "python-pypdf3")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyPDF3" version))
       (sha256
        (base32 "018hlq9q2qa96vw4j7ppq352znykldwy98h2w9qcpkvpi93sjqhc"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-tqdm))
    (home-page "https://github.com/sfneal/PyPDF3")
    (synopsis "Utility to read and write PDFs with Python")
    (description "PyPDF3 is a pure-python PDF library capable of splitting,
merging together, cropping, and transforming the pages of PDF files.  It can
also add custom data, viewing options, and passwords to PDF files.  It can
retrieve text and metadata from PDFs as well as merge entire files together.")
    (license license:bsd-3)))

(define-public python-pikepdf
  (package
    (name "python-pikepdf")
    (version "2.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pikepdf" version))
       (sha256
        (base32 "1phdpi9cm2pbvgcxqvwr8ck327sxhdw4dnxmzhrbf7hzydmgykg2"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #false))                ;require python-xmp-toolkit
    (native-inputs
     (list pybind11
           python-setuptools
           python-setuptools-scm
           python-setuptools-scm-git-archive
           python-toml
           python-wheel))
    (inputs
     (list qpdf))
    (propagated-inputs
     (list python-lxml python-pillow))
    (home-page "https://github.com/pikepdf/pikepdf")
    (synopsis "Read and write PDFs with Python")
    (description
     "pikepdf is a Python library for reading and writing PDF files.")
    (license license:mpl2.0)))

(define-public python-pillow
  (package
    (name "python-pillow")
    (version "9.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Pillow" version))
              (sha256
               (base32
                "011wgm1mssjchpva9wsi2a07im9czyjvik137xlp5f0g7vykdrkm"))
              (modules '((guix build utils)))
              (snippet '(begin
                          (delete-file-recursively "src/thirdparty")))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (inputs (list freetype
                  lcms
                  libjpeg-turbo
                  libtiff
                  libwebp
                  openjpeg
                  zlib))
    (propagated-inputs (list python-olefile))
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'patch-ldconfig
                    (lambda _
                      (substitute* "setup.py"
                        (("\\['/sbin/ldconfig', '-p'\\]") "['true']"))))
                  (replace 'check
                    (lambda* (#:key outputs inputs tests? #:allow-other-keys)
                      (when tests?
                        (setenv "HOME"
                                (getcwd))
                        (add-installed-pythonpath inputs outputs)
                        (invoke "python" "selftest.py" "--installed")
                        (invoke "python" "-m" "pytest" "-vv")))))))
    (home-page "https://python-pillow.org")
    (synopsis "Fork of the Python Imaging Library")
    (description
     "The Python Imaging Library adds image processing capabilities to your
Python interpreter.  This library provides extensive file format support, an
efficient internal representation, and fairly powerful image processing
capabilities.  The core image library is designed for fast access to data
stored in a few basic pixel formats.  It should provide a solid foundation for
a general image processing tool.")
    (properties `((cpe-name . "pillow")))
    (license (license:x11-style
              "http://www.pythonware.com/products/pil/license.htm"
              "The PIL Software License"))))

(define-public python-pillow-2.9
  (package
    (inherit python-pillow)
    (version "2.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "Pillow" version))
        (sha256
         (base32
           "0ada7lf3lmbdsqm3b7ja920p1pllyfhmqndr85ikpj77fmz9s5qg"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-pillow)
       ((#:tests? _ #f) #f)))
    (properties '((hidden? #t)))))

(define-public python-pillow-simd
  (package
    (inherit python-pillow)
    (name "python-pillow-simd")
    (version "9.0.0.post1")
    ;; The PyPI tarball does not include test files.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/uploadcare/pillow-simd")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dnvsln451aw3qy2cxg2ndd5mcanf5nrhxw9l7mcam730635hdm9"))))
    (inputs
     (modify-inputs (package-inputs python-pillow)
       (prepend libraqm libimagequant)))
    (home-page "https://github.com/uploadcare/pillow-simd")
    (synopsis "Fork of the Python Imaging Library (Pillow)")
    (description "This package is a fork of Pillow which adds support for SIMD
parallelism.")))

(define-public python-imagecodecs
  (package
    (name "python-imagecodecs")
    (version "2021.3.31")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "imagecodecs" version))
        (sha256
          (base32
            "0q7pslb6wd56vbcq2mdxwsiha32mxjr7mgqqfbq5w42q601p9pi0"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            ;; Unbundle 3rd party modules.
            (delete-file-recursively "3rdparty")
            ;; Delete pre-generated Cython files.
            (for-each delete-file (find-files "imagecodecs" "_.*\\.c$"))
            #t))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; Tests are disabled, because dependencies are missing.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'create-configuration
           (lambda* (#:key inputs #:allow-other-keys)
             ;; By default everything is enabled. We can selectively disable
             ;; extensions (and thus dependencies) by deleting them from the
             ;; EXTENSIONS dictionary.  This is upstream’s preferred way.
             (call-with-output-file "imagecodecs_distributor_setup.py"
               (lambda (port)
                 (format port "\
def customize_build(EXTENSIONS, OPTIONS):
    del EXTENSIONS['aec']
    del EXTENSIONS['avif']
    del EXTENSIONS['bitshuffle']
    del EXTENSIONS['deflate']
    del EXTENSIONS['jpeg2k']
    del EXTENSIONS['jpeg12']
    del EXTENSIONS['jpegls']
    del EXTENSIONS['jpegxl']
    del EXTENSIONS['jpegxr']
    del EXTENSIONS['lerc']
    del EXTENSIONS['ljpeg']
    del EXTENSIONS['lzf']
    del EXTENSIONS['zfp']
    del EXTENSIONS['zopfli']
    OPTIONS['cythonize']
")))))
         ;; XXX: The installed scripts import packages that depend on
         ;; this package; disable import check to avoid the cycle.
         (delete 'sanity-check))))
    (inputs
      (list c-blosc
            giflib
            brotli
            libjpeg-turbo
            libpng
            libtiff
            libwebp
            lz4
            snappy
            xz
            zlib
            `(,zstd "lib")))
    (propagated-inputs
      ;; For the Python library.
      (list python-numpy))
    (native-inputs
      ;; For building.
      (list python-cython
            ;; For testing. Incomplete.
            ;("python-numcodecs" ,python-numcodecs)
            ;("python-zarr" ,python-zarr)
            ;("python-pytest" ,python-pytest)
            ))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis
      "Image transformation, compression, and decompression codecs")
    (description
      "Imagecodecs is a Python library that provides block-oriented, in-memory
buffer transformation, compression, and decompression functions for use in the
tifffile, czifile, and other scientific image input/output modules.")
    (license license:bsd-3)))

(define-public python-property-manager
  (package
    (name "python-property-manager")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "property-manager" version))
       (sha256
        (base32 "0m3w4spr8f39xnm65naw29ncal4r453kn7ndqb63rwbsmslnvrwk"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest-cov))
    (propagated-inputs
     (list python-verboselogs
           python-humanfriendly
           python-coloredlogs))
    (home-page "https://github.com/xolox/python-property-manager")
    (synopsis "Useful property variants for Python programming")
    (description "The @code{property-manager} package defines several custom
property variants for Python programming including required properties,
writable properties, cached properties, etc.")
    (license license:expat))) ; MIT license

(define-public python-executing
  (package
    (name "python-executing")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "executing" version))
       (sha256
        (base32 "08q0xh9fd8k41sqpp23q6fb9bf7yj4y2q6sv30pj36vvk8pg8fy2"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; TODO: tests require python-asttokens
    (native-inputs
     (list python-setuptools-scm python-toml))
    (home-page "https://github.com/alexmojaki/executing")
    (synopsis "Get information about what a Python frame is currently doing")
    (description "This package lets you get information about what a frame is
currently doing, particularly the AST node being executed.")
    (license license:expat)))

(define-public python-executor
  (package
    (name "python-executor")
    (version "23.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "executor" version))
       (sha256
        (base32 "0g83yr54j0vcwhy6h7n0jsd7q0q630kwa6v9kqzlzrm9xj6c3ip1"))))
    (build-system python-build-system)
    (arguments
    `(#:tests? #f)) ; TODO: tests require root/sudo
    (propagated-inputs
     (list python-six
           python-property-manager
           python-fasteners
           python-virtualenv))
    (home-page "https://github.com/xolox/python-executor")
    (synopsis "Programmer friendly subprocess wrapper")
    (description "The @code{executor} package is a simple wrapper for Python’s
subprocess module that makes it very easy to handle subprocesses on UNIX
systems with proper escaping of arguments and error checking currently doing,
particularly the AST node being executed.")
    (license license:expat))) ; MIT license

(define-public python-roifile
  (package
    (name "python-roifile")
    (version "2020.11.28")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "roifile" version))
        (sha256
          (base32
            "04argnc7qccybkrj9ww18bf81ghsghhh93hnqy3p111rcdlyn66p"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ; there are none
    (propagated-inputs
      (list python-numpy))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Read and write ImageJ ROI format")
    (description "Roifile is a Python library to read, write, create, and plot
ImageJ ROIs, an undocumented and ImageJ application specific format to store
regions of interest, geometric shapes, paths, text, etc for image overlays.")
    (license license:bsd-3)))

(define-public python-tifffile
  (package
    (name "python-tifffile")
    (version "2021.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tifffile" version))
       (sha256
        (base32
         "16r0hw7shka1bqf28bv198lj2jhf2r9gy3s5zv4nf5cfsfm8pajm"))))
    (build-system python-build-system)
    ;; Tests require lfdfiles, which depends on tifffile
    (arguments `(#:tests? #f))
    (propagated-inputs
     (list python-numpy python-imagecodecs))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Read and write TIFF(r) files")
    (description "This package lets you read image and metadata from many
bio-scientific formats such as plain TIFF, BigTIFF, OME-TIFF, STK, LSM, SGI,
NIH, ImageJ, MicroManager, MD GEL, and FluoView files.  It also lets you write
numpy arrays to TIFF, BigTIFF, and ImageJ hyperstack compatible files.")
    (license license:bsd-3)))

(define-public python-lfdfiles
  (package
    (name "python-lfdfiles")
    (version "2021.2.22")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lfdfiles" version))
       (sha256
        (base32
         "12fxm4v805dgjrih7x6jnl1wd7y7jw1rkhjs3d4am8s6qk1cbar2"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            ;; Delete pre-generated Cython files.
            (for-each delete-file (find-files "lfdfiles" "_.*\\.c$"))
            #t))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; No tests exist, despite a test dependency on pytest.
    (propagated-inputs
     (list python-click python-numpy python-tifffile))
    (native-inputs (list python-cython))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Work with LFD data files")
    (description
     "Lfdfiles is a Python library and console script for reading, writing,
converting, and viewing many of the proprietary file formats used to store
experimental data and metadata at the Laboratory for Fluorescence Dynamics.")
    (license license:bsd-3)))

(define-public python-imageio
  (package
    (name "python-imageio")
    (version "2.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imageio" version))
       (sha256
        (base32
         "1ksjl523fm0fikrd85llxfba35rc1qsgwadgr6mbn9kis79xcpzv"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; many tests require online data
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key outputs inputs tests? #:allow-other-keys)
             (if tests?
                 (begin
                   ;; Make installed package available for running the tests.
                   (add-installed-pythonpath inputs outputs)
                   (invoke "pytest" "-vv"))
                 #t))))))
    (propagated-inputs
     (list python-numpy python-pillow python-psutil))
    (native-inputs
     (list python-pytest))
    (home-page "https://imageio.github.io/")
    (synopsis "Library for reading and writing a wide range of image data")
    (description
     "Imageio is a Python library that provides an easy interface to read and
write a wide range of image data, including animated images, video, volumetric
data, and scientific formats.")
    (license license:bsd-2)))

(define-public python-pyvips
  (package
    (name "python-pyvips")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyvips" version))
       (sha256
        (base32 "1dfbwwvnnsk4g2kj1pw654z9jq3mb72l1m8ma29858jpn12vn7dm"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; Maybe switch to API mode (i.e., build the C extension)?
               ;; It is advertised as faster to start up and run.
               ;; However, even with ‘pkg-config’ and ‘python-pkgconfig’ in
               ;; ‘native-inputs’, the API mode build fails with:
               ;;
               ;;   Falling back to ABI mode. Details: unable to find pkg-config package "vips"
               ;;
               ;; The build doesn't actually fail without the below
               ;; substitution, it's just slower because ‘setup.py’ tries
               ;; (unsuccessfully) to download the Python ‘pkgconfig’ module.
               (add-after 'unpack 'fix-build
                 (lambda _
                   (substitute* "setup.py"
                     (("^( +setup_)API\\(\\)\n" _ prefix)
                      (string-append prefix "ABI()\n")))))
               (add-after 'unpack 'fix-paths
                 (lambda _
                   (substitute* "pyvips/__init__.py"
                     (("^( +_vips_libname) = '(libvips.so.42)'"
                       _ var libname)
                      (format #f "~a = '~a/lib/~a'"
                              var #$(this-package-input "vips") libname))
                     (("^( +_gobject_libname) = '(libgobject-2.0.so.0)'"
                       _ var libname)
                      (format #f "~a = '~a/lib/~a'"
                              var #$(this-package-input "glib") libname)))))
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "python" "setup.py" "test")))))))
    (native-inputs
     (list python-pyperf
           python-pytest
           python-pytest-flake8
           python-pytest-runner))
    (inputs
     (list glib vips))
    (propagated-inputs
     (list python-cffi))
    (home-page "https://github.com/libvips/pyvips")
    (synopsis "Python bindings for VIPS")
    (description "The @code{pyvips} package provides Python bindings for VIPS,
a multithreaded image-processing system with low memory needs.")
    (license license:expat)))

(define-public python-pycparser
  (package
    (name "python-pycparser")
    (version "2.21")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "pycparser" version))
      (sha256
       (base32
        "01kjlyn5w2nn2saj8w1rhq7v26328pd91xwgqn32z1zp2bngsi76"))))
    (outputs '("out" "doc"))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "-m" "unittest" "discover")))
         (add-after 'install 'install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let* ((data (string-append (assoc-ref outputs "doc") "/share"))
                    (doc (string-append data "/doc/" ,name "-" ,version))
                    (examples (string-append doc "/examples")))
               (mkdir-p examples)
               (for-each (lambda (file)
                           (copy-file (string-append "." file)
                                      (string-append doc file)))
                         '("/README.rst" "/CHANGES" "/LICENSE"))
               (copy-recursively "examples" examples)))))))
    (home-page "https://github.com/eliben/pycparser")
    (synopsis "C parser in Python")
    (description
     "Pycparser is a complete parser of the C language, written in pure Python
using the PLY parsing library.  It parses C code into an AST and can serve as
a front-end for C compilers or analysis tools.")
    (license license:bsd-3)))

(define-public python2-pycparser
  (package-with-python2 python-pycparser))

(define-public python-xlsxwriter
  (package
    (name "python-xlsxwriter")
    (version "3.0.3")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jmcnamara/XlsxWriter")
             (commit (string-append "RELEASE_" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1lr7mmik6r4zns069i4zfx1cnwhz6snmlh2zsiry0cwx8cv33wpm"))))
    (build-system python-build-system)
    (home-page "https://github.com/jmcnamara/XlsxWriter")
    (synopsis "Python module for creating Excel XLSX files")
    (description
     "XlsxWriter is a Python module that can be used to write text, numbers,
formulas and hyperlinks to multiple worksheets in an Excel 2007+ XLSX file.")
    (license license:bsd-2)))

(define-public python-pywavelets
  (package
    (name "python-pywavelets")
    (version "1.2.0")
    (home-page "https://github.com/PyWavelets/pywt")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PyWavelets" version))
              (sha256
               (base32
                "13csbr6ls9q9ww53z2xwwsj0hpsz88rj2iwp623h0kmv8yq6kgbc"))
              (snippet
               #~(begin
                   (use-modules ((guix build utils)))
                   (for-each delete-file
                             (list
                               "pywt/_extensions/_cwt.c"
                               "pywt/_extensions/_dwt.c"
                               "pywt/_extensions/_pywt.c"
                               "pywt/_extensions/_pywt.h"
                               "pywt/_extensions/_swt.c"))))))
    (build-system python-build-system)
    (arguments
     '(#:modules ((ice-9 ftw)
                  (srfi srfi-1)
                  (srfi srfi-26)
                  (guix build utils)
                  (guix build python-build-system))
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (let ((cwd (getcwd))
                   (libdir (find (cut string-prefix? "lib." <>)
                                 (scandir "build"))))
               (with-directory-excursion (string-append cwd "/build/" libdir)
                 (invoke "pytest" "-vv"))))))))
    (native-inputs
     (list python-cython
           python-matplotlib ;for tests
           python-pytest))
    (propagated-inputs
     (list python-numpy))
    (synopsis "Wavelet transforms in Python")
    (description
     "PyWavelets is a library for wavelet transforms in Python.  Wavelets are
mathematical basis functions that are localized in both time and frequency.
Wavelet transforms are time-frequency transforms employing wavelets.  They are
similar to Fourier transforms, the difference being that Fourier transforms are
localized only in frequency instead of in time and frequency.")
    (license license:expat)))

(define-public python-pywal
  (package
    (name "python-pywal")
    (version "3.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dylanaraps/pywal")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "039m7dch479hlwddynacdrr0klz6a5bdly5swqbs94hfimficiyf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-home-directory
           (lambda _
             ;; Tests fail with "Permission denied: '/homeless-shelter'".
             (setenv "HOME" "/tmp")
             #t)))))
    (inputs
     (list imagemagick))
    (home-page "https://github.com/dylanaraps/pywal")
    (synopsis "Color palette generator and applicator")
    (description
     "Pywal is a tool that generates a color palette from the dominant colors
in an image.  It then applies the colors system-wide and on-the-fly in all of
your favourite programs.")
    (license license:expat)))

(define-public python-click-didyoumean
  (package
    (name "python-click-didyoumean")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click-didyoumean" version))
       (sha256
        (base32 "0dc0xrmqbw0idpx843ahzzvivmvx3fcfsm3k54lnssyra7cg117i"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))              ; no tests in PyPI and no setup.py in github
    (propagated-inputs
     (list python-click))
    (home-page "https://github.com/timofurrer/click-didyoumean")
    (synopsis "Git-like did-you-mean feature in Click")
    (description
     "This plugin enables git-like did-you-mean feature in Click.")
    (license license:expat)))

(define-public python-pywinrm
  (package
    (name "python-pywinrm")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pywinrm" version))
       (sha256
        (base32
         "10gabhhg3rgacd5ahmi2r128z99fzbrbx6mz1nnq0dxmhmn5rpjf"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-requests_ntlm python-xmltodict
           python-kerberos))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://github.com/diyan/pywinrm/")
    (synopsis
     "Python library for Windows Remote Management (WinRM)")
    (description
     "pywinrm is a Python client for the Windows Remote Management (WinRM)
service.  It allows you to invoke commands on target Windows machines from
any machine that can run Python.")
    (license license:expat)))

(define-public python-xcffib
  (package
    (name "python-xcffib")
    (version "0.11.1")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "xcffib" version))
      (sha256
       (base32
        "0nkglsm9nbhv238iagmmsjcz6lf1yfdvp5kmspphdj385vz9r50j"))))
    (build-system python-build-system)
    (inputs
     (list libxcb))
    (propagated-inputs
     (list python-cffi ; used at run time
           python-six))
    (arguments
     `(;; FIXME: Tests need more work. See ".travis.yml" in the repository.
       #:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-libxcb-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((libxcb (assoc-ref inputs "libxcb")))
               (substitute* '("xcffib/__init__.py")
                 (("soname = ctypes.util.find_library.*xcb.*")
                  (string-append "soname = \"" libxcb "/lib/libxcb.so\"\n")))
               #t)))
         (add-after 'install 'install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((doc (string-append (assoc-ref outputs "out") "/share"
                                       "/doc/" ,name "-" ,version)))
               (mkdir-p doc)
               (copy-file "README.md"
                          (string-append doc "/README.md"))
               #t))))))
    (home-page "https://github.com/tych0/xcffib")
    (synopsis "XCB Python bindings")
    (description
     "Xcffib is a replacement for xpyb, an XCB Python bindings.  It adds
support for Python 3 and PyPy.  It is based on cffi.")
    (license license:expat)))

(define-public python-cairocffi
  (package
    (name "python-cairocffi")
    (version "1.3.0")
    (source
     (origin
       ;; The PyPI archive does not include the documentation, so use Git.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Kozea/cairocffi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0lylyxyyd8csjhn5kxwzrcr6ick6pvvm1wclpmb5ni28jznxn7lb"))))
    (build-system python-build-system)
    (outputs '("out" "doc"))
    (inputs
     (list glib gtk+ gdk-pixbuf cairo))
    (native-inputs
     (list python-numpy
           python-pytest
           python-pytest-cov
           python-pytest-runner
           python-sphinx
           python-sphinx-rtd-theme))
    (propagated-inputs
     (list python-xcffib)) ; used at run time
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "cairocffi/__init__.py"
               ;; Hack the dynamic library loading mechanism.
               (("find_library\\(library_name\\)")
                "\"found\"")
               (("filenames = \\(library_filename,\\) \\+ filenames")
                "pass")
               (("libcairo.so.2")
                (search-input-file inputs "/lib/libcairo.so.2")))
             (substitute* "cairocffi/pixbuf.py"
               (("libgdk_pixbuf-2.0.so.0")
                (search-input-file inputs "/lib/libgdk_pixbuf-2.0.so.0"))
               (("libgobject-2.0.so.0")
                (search-input-file inputs "/lib/libgobject-2.0.so.0"))
               (("libglib-2.0.so.0")
                (search-input-file inputs "/lib/libglib-2.0.so.0"))
               (("libgdk-3.so.0")
                (search-input-file inputs "/lib/libgdk-3.so.0")))))
         (add-after 'unpack 'disable-linters
           ;; Their check fails; none of our business.
           (lambda _
             (substitute* "setup.cfg"
               ((".*pytest-flake8.*") "")
               ((".*pytest-isort.*") "")
               (("--flake8") "")
               (("--isort") ""))
             #t))
         (add-after 'install 'install-doc
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((data (string-append (assoc-ref outputs "doc") "/share"))
                    (doc (string-append data "/doc/" ,name "-" ,version))
                    (html (string-append doc "/html")))
               (setenv "LD_LIBRARY_PATH"
                       (string-append (assoc-ref inputs "cairo") "/lib" ":"
                                      (assoc-ref inputs "gdk-pixbuf") "/lib"))
               (setenv "LANG" "en_US.UTF-8")
               (mkdir-p html)
               (for-each (lambda (file)
                           (copy-file (string-append "." file)
                                      (string-append doc file)))
                         '("/README.rst" "/NEWS.rst"))
               (system* "python" "setup.py" "build_sphinx")
               (copy-recursively "docs/_build/html" html)
               #t))))))
    (home-page "https://github.com/Kozea/cairocffi")
    (synopsis "Python bindings and object-oriented API for Cairo")
    (description
     "Cairocffi is a CFFI-based drop-in replacement for Pycairo, a set of
Python bindings and object-oriented API for cairo.  Cairo is a 2D vector
graphics library with support for multiple backends including image buffers,
PNG, PostScript, PDF, and SVG file output.")
    (license license:bsd-3)))

(define-public python-decorator
  (package
    (name "python-decorator")
    (version "5.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "decorator" version))
       (sha256
        (base32 "1mcy64hllgm938v8k1x2a4g0q9swsnrfnsvhz59kr28a6ajgpv3j"))))
    (build-system python-build-system)
    (home-page "https://pypi.org/project/decorator/")
    (synopsis "Python module to simplify usage of decorators")
    (description
      "The aim of the decorator module is to simplify the usage of decorators
for the average programmer, and to popularize decorators usage giving examples
of useful decorators, such as memoize, tracing, redirecting_stdout, locked,
etc.  The core of this module is a decorator factory.")
    (license license:expat)))


(define-public python-drmaa
  (package
    (name "python-drmaa")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "drmaa" version))
       (sha256
        (base32 "0xzqriqyvk5b8hszbavsyxd29wm3sxirm8zvvdm73rs2iq7w4hkx"))))
    (build-system python-build-system)
    ;; The test suite requires libdrmaa which is provided by the cluster
    ;; environment.  At runtime the environment variable DRMAA_LIBRARY_PATH
    ;; should be set to the path of the libdrmaa library.
    (arguments
     '(#:tests? #f
       #:phases (modify-phases %standard-phases
                  ;; Loading the library fails because DRMAA_LIBRARY_PATH
                  ;; is not configured.
                  (delete 'sanity-check))))
    (home-page "https://pypi.org/project/drmaa/")
    (synopsis "Python bindings for the DRMAA library")
    (description
      "A Python package for Distributed Resource Management (DRM) job
submission and control.  This package is an implementation of the DRMAA 1.0
Python language binding specification.")
    (license license:bsd-3)))

(define-public python-grako
  (package
    (name "python-grako")
    (version "3.99.9")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "grako" version ".zip"))
       (sha256
        (base32
         "0r63i68wcnv63rfjkasq1ah81frz61a6mzbcnaxhrkdpx84p7hzw"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; Test file 'grako.ebnf' is missing from archive.
    (native-inputs
     (list unzip python-pytest python-pytest-runner))
    (home-page "https://bitbucket.org/neogeny/grako")
    (synopsis "EBNF parser generator")
    (description
     "Grako takes a grammar in a variation of EBNF as input, and outputs a
memoizing PEG/Packrat parser in Python.")
    (license license:bsd-3)))

(define-public python-grandalf
  (package
    (name "python-grandalf")
    (version "0.7")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bdcht/grandalf")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "03p8w8ljpb87qbyldm3s6b7qi30hfcn43h33iwlgqcf31fjsyr4g"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "setup.py" "pytest"))))))
    (native-inputs
     (list python-pytest python-pytest-runner))
    (propagated-inputs
     (list python-numpy python-ply))
    (home-page "https://github.com/bdcht/grandalf")
    (synopsis "Graph and drawing algorithms framework")
    (description
     "Grandalf is a Python package made for experimentations with graphs
drawing algorithms.  It is written in pure Python, and currently implements
two layouts: the Sugiyama hierarchical layout and the force-driven or energy
minimization approach.  While not as fast or featured as graphviz or other
libraries like OGDF (C++), it provides a way to walk and draw graphs no larger
than thousands of nodes, while keeping the source code simple enough to tweak
and hack any part of it for experimental purpose.  With a total of about 1500
lines of Python, the code involved in drawing the Sugiyama (dot) layout fits
in less than 600 lines.  The energy minimization approach is comprised of only
250 lines!

Grandalf does only 2 not-so-simple things:
@itemize
@item computing the nodes (x,y) coordinates (based on provided nodes
dimensions, and a chosen layout)
@item routing the edges with lines or nurbs
@end itemize

It doesn’t depend on any GTK/Qt/whatever graphics toolkit.  This means that it
will help you find where to draw things like nodes and edges, but it’s up to
you to actually draw things with your favorite toolkit.")
    ;; The user can choose either license.
    (license (list license:gpl2 license:epl1.0))))

(define-public python-gridmap
  (package
    (name "python-gridmap")
    (version "0.14.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pygridtools/gridmap")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0v0sgpg6pz8h61f9aqjf5xk0ipr512bbz8dxzjjylksj135qr19l"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f    ;FIXME: Requires python-cherrypy.
       #:phases (modify-phases %standard-phases
                  ;; Importing the web server module requires cherrypy, too.
                  (delete 'sanity-check))))
    (propagated-inputs
     (list python-psutil python-drmaa python-pyzmq))
    (home-page "https://github.com/pygridtools/gridmap")
    (synopsis "Create jobs on a cluster directly from Python")
    (description
      "Gridmap is a Python package to allow you to easily create jobs on the
cluster directly from Python.  You can directly map Python functions onto the
cluster without needing to write any wrapper code yourself.")
    (license license:gpl3+)))

(define-public python-honcho
  (package
    (name "python-honcho")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nickstenning/honcho")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1y0r8dw4pqcq7r4n58ixjdg1iy60lp0gxsd7d2jmhals16ij71rj"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock python-tox which)) ;for tests
    (propagated-inputs
     (list python-jinja2))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (delete 'check)
         (add-after 'install 'check
           (lambda* (#:key outputs inputs #:allow-other-keys)
             ;; fix honcho path in testsuite
             (substitute* "tests/conftest.py"
               (("'honcho'") (string-append "'" (assoc-ref outputs "out")
                                            "/bin/honcho" "'")))
             ;; It's easier to run tests after install.
             ;; Make installed package available for running the tests
             (add-installed-pythonpath inputs outputs)
             ;; Skip failing test_export
             (invoke "py.test" "-v" "-k" "not test_export"))))))
    (home-page "https://github.com/nickstenning/honcho")
    (synopsis "Manage Procfile-based applications")
    (description
      "A Procfile is a file which describes how to run an application
consisting of several processes. honcho starts all listed processes.
The output of all running processes is collected by honcho and
displayed.")
    (license license:expat)))

(define-public python-pebble
  (package
    (name "python-pebble")
    (version "4.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pebble" version))
       (sha256
        (base32 "16siqc3brbk7dp4d9sg48bjl6a8wyy24aib3il1hf4y2624draxh"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "python" "-m" "pytest" "-sv"))))))
    (home-page "https://github.com/noxdafox/pebble")
    (synopsis "Threading and multiprocessing for Python")
    (description
     "Pebble aims to help manage threads and processes in an easier way.  It
wraps Python's standard library threading and multiprocessing objects.")
    (license license:lgpl3+)))

(define-public python-pexpect
  (package
    (name "python-pexpect")
    (version "4.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pexpect" version))
       (sha256
        (base32 "032cg337h8awydgypz6f4wx848lw8dyrj4zy988x0lyib4ws8rgw"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'prepare-tests
           (lambda _
             (substitute* (find-files "tests")
               (("/bin/ls") (which "ls"))
               (("/bin/echo") (which "echo"))
               (("/bin/which") (which "which"))
               ;; Many tests try to use the /bin directory which
               ;; is not present in the build environment.
               ;; Use one that's non-empty and unlikely to change.
               (("/bin'") "/dev'")
               ;; Disable failing test.  See upstream bug report
               ;; https://github.com/pexpect/pexpect/issues/568
               (("def test_bash") "def _test_bash"))
             ;; XXX: Socket connection test gets "Connection reset by peer".
             ;; Why does it not work? Delete for now.
             (delete-file "tests/test_socket.py")
             #t))
         (replace 'check (lambda _ (invoke "nosetests" "-v"))))))
    (native-inputs
     `(("python-nose" ,python-nose)
       ("python-pytest" ,python-pytest)
       ("man-db" ,man-db)
       ("which" ,which)
       ("bash-full" ,bash)))                 ;full Bash for 'test_replwrap.py'
    (propagated-inputs
     (list python-ptyprocess))
    (home-page "http://pexpect.readthedocs.org/")
    (synopsis "Controlling interactive console applications")
    (description
     "Pexpect is a pure Python module for spawning child applications;
controlling them; and responding to expected patterns in their output.
Pexpect works like Don Libes’ Expect.  Pexpect allows your script to spawn a
child application and control it as if a human were typing commands.")
    (license license:isc)))

(define-public python-sexpdata
  (package
    (name "python-sexpdata")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sexpdata" version))
       (sha256
        (base32
         "1q4lsjyzzqrdv64l0pv4ij9nd8gqhvxqcrpxc2xpxs652sk2gj0s"))))
    (build-system python-build-system)
    (home-page "https://github.com/jd-boyd/sexpdata")
    (synopsis "S-expression parser for Python")
    (description
     "Sexpdata is an S-expression parser/serializer.  It has load and dump
functions like pickle, json or PyYAML module.")
    (license license:bsd-3)))

(define-public python-pathlib2
  (package
    (name "python-pathlib2")
    (version "2.3.7.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathlib2" version))
       (sha256
        (base32
         "0hf62d0lsf37vnr5fxqp5rfn85njgsr45j4rw71w10wbi6nyvq4z"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-scandir python-six))
    (home-page "https://pypi.org/project/pathlib2/")
    (synopsis "Object-oriented file system paths")
    (description "The goal of pathlib2 is to provide a backport of the
standard @code{pathlib} module which tracks the standard library module, so
all the newest features of the standard @code{pathlib} can be used also on
older Python versions.")
    (license license:expat)))

(define-public python-importlib-resources
  (package
    (name "python-importlib-resources")
    (version "3.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "importlib_resources" version))
              (sha256
               (base32
                "1hq626mx5jl9zfl0wdrjkxsnh8qd98fqv322n68b9251xjk4bxqr"))))
    (build-system python-build-system)
    (native-inputs (list python-setuptools-scm python-toml))
    (home-page "http://importlib-resources.readthedocs.io/")
    (synopsis "Read resources from Python packages")
    (description
     "@code{importlib_resources} is a backport of Python 3's standard library
@code{importlib.resources} module for Python 2.7, and Python 3.")
    (license license:asl2.0)))

(define-public python-importlib-metadata
  (package
    (name "python-importlib-metadata")
    (version "4.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "importlib_metadata" version))
       (sha256
        (base32
         "0f951zynlh39yicqnhrs3p1qa5p3g6ajjfcggf12y51ppxz5jk7a"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: PEP 517 manual build/install procedures copied from
          ;; python-isort.
          (replace 'build
            (lambda _
              ;; ZIP does not support timestamps before 1980.
              (setenv "SOURCE_DATE_EPOCH" "315532800")
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "tests")))))))
    (propagated-inputs (list python-zipp))
    (native-inputs
     (list python-pypa-build
           python-pyfakefs
           python-pytest
           python-setuptools-scm))
    (home-page "https://importlib-metadata.readthedocs.io/")
    (synopsis "Read metadata from Python packages")
    (description
     "@code{importlib_metadata} is a library which provides an API for
accessing an installed Python package's metadata, such as its entry points or
its top-level name.  This functionality intends to replace most uses of
@code{pkg_resources} entry point API and metadata API.  Along with
@code{importlib.resources} in Python 3.7 and newer, this can eliminate the
need to use the older and less efficient @code{pkg_resources} package.")
    (license license:asl2.0)))

(define-public python-importmagic
  (package
    (name "python-importmagic")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "importmagic" version))
       (sha256
        (base32
         "1n7qxa1snj06aw45mcfz7bxc46zp7fxj687140g2k6jcnyjmfxrz"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-v")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/alecthomas/importmagic")
    (synopsis "Library for adding, removing and managing Python imports")
    (description
     "Importmagic is a Python library for automatically managing imports by
finding unresolved symbols in Python code and their corresponding imports.")
    (license license:bsd-3)))

(define-public python-inotify-simple
  (package
    (name "python-inotify-simple")
    (version "1.3.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chrisjbillington/inotify_simple")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dv9svrcz31acyq9smjlnw75xv3x5wpn5h6s8j8h0vrqyl3d7l05"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/chrisjbillington/inotify_simple")
    (synopsis "Simple wrapper around inotify library")
    (description
     "@code{inotify-simple} is a simple wrapper around inotify library.")
    (license license:bsd-3)))

(define-public python-jaraco-classes
  (package
    (name "python-jaraco-classes")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.classes" version))
       (sha256
        (base32 "0d6g7qvfv1jlzbzh6asprqdblqd59grvlvr3nwbdqdqrmwlbfm7d"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Do not test the myproject.toml build as it tries to pull
                ;; dependencies from the Internet.
                (invoke "pytest" "-vv" "-k" "not project")))))))
    (native-inputs
     (list python-pytest
           python-pytest-black
           python-pytest-checkdocs
           python-pytest-cov
           python-pytest-enabler-bootstrap ;OK since not propagated
           python-pytest-flake8
           python-pytest-mypy
           python-setuptools-scm
           python-wheel))
    (propagated-inputs (list python-more-itertools))
    (home-page "https://github.com/jaraco/jaraco.classes")
    (synopsis "Utility functions for Python class constructs")
    (description "This Python library contains utility functions for Python
class constructs.")
    (license license:expat)))

;;; Variant used to break a cycle with python-pytest-enabler.
(define-public python-jaraco-context-bootstrap
  (hidden-package
   (package
     (name "python-jaraco-context-bootstrap")
     (version "4.1.1")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jaraco.context" version))
        (sha256
         (base32 "0hbjm1rpxf4pzmbdp9rh3ali4zqnlcr8m97bhh1nizxvzcpxim7h"))))
     (build-system python-build-system)
     (arguments (list #:tests? #f))
     (native-inputs (list python-setuptools-scm))
     (home-page "https://github.com/jaraco/jaraco.context")
     (synopsis "Context managers Python library")
     (description "This Python library provides context managers-related
procedures.")
     (license license:expat))))

(define-public python-jaraco-context
  (package/inherit python-jaraco-context-bootstrap
    (name "python-jaraco-context")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-jaraco-context-bootstrap)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:phases phases #~%standard-phases)
        #~(modify-phases #$phases
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  ;; Do not test the myproject.toml build as it tries to pull
                  ;; dependencies from the Internet.
                  (invoke "pytest" "-vv" "-k" "not project"))))))))
    (native-inputs
     (modify-inputs
         (package-native-inputs python-jaraco-context-bootstrap)
       (append python-pytest
               python-pytest-black
               python-pytest-checkdocs
               python-pytest-cov
               python-pytest-enabler-bootstrap ;OK since not propagated
               python-pytest-flake8
               python-pytest-mypy)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-jaraco-context-bootstrap)))))

;;; Variant used to break a cycle with python-pytest-enabler.
(define-public python-jaraco-functools-bootstrap
  (hidden-package
   (package
     (name "python-jaraco-functools-bootstrap")
     (version "3.5.0")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jaraco.functools" version))
        (sha256
         (base32 "186xqzs3bqhjwajnprxy3sc3h0w5vdld8spc1dxjnn9720yykq1i"))))
     (build-system python-build-system)
     (arguments (list #:tests? #f))
     (native-inputs (list python-setuptools-scm))
     (propagated-inputs (list python-more-itertools))
     (home-page "https://github.com/jaraco/jaraco.functools")
     (synopsis "Python library extending Python's @code{functools}")
     (description "This library extends the standard @code{functools} Python
module with a few extra procedures.")
     (license license:expat))))

(define-public python-jaraco-functools
  (package/inherit python-jaraco-functools-bootstrap
    (name "python-jaraco-functools")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-jaraco-functools-bootstrap)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:phases phases #~%standard-phases)
        #~(modify-phases #$phases
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  ;; Do not test the myproject.toml build as it tries to pull
                  ;; dependencies from the Internet.  Do not run a test that
                  ;; tries to emulate a broken proprietary CI set-up, fails
                  ;; to do so correctly, and then throws an error about it.
                  (invoke "pytest" "-vv" "-k"
                          "not project and not test_function_throttled"))))))))
    (native-inputs
     (modify-inputs
         (package-native-inputs python-jaraco-functools-bootstrap)
       (append python-jaraco-classes
               python-pytest
               python-pytest-black
               python-pytest-checkdocs
               python-pytest-cov
               python-pytest-enabler-bootstrap ;OK since not propagated
               python-pytest-flake8
               python-pytest-mypy)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-jaraco-functools-bootstrap)))))

(define-public python-jaraco-packaging
  (package
    (name "python-jaraco-packaging")
    (version "6.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jaraco.packaging" version))
        (sha256
          (base32
            "0zimrnkh33b9g8ffw11mjh6kvs54cy5gcjw1h5cl1r7dc833dmkm"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pytest
           python-pytest-checkdocs
           python-pytest-flake8
           python-rst.linker
           python-setuptools
           python-setuptools-scm
           python-six
           python-sphinx))
    (home-page "https://github.com/jaraco/jaraco.packaging")
    (synopsis "Tools to supplement packaging Python releases")
    (description
     "This package provides various tools to supplement packaging Python
releases.")
    (license license:expat)))

(define-public python-simplegeneric
  (package
    (name "python-simplegeneric")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simplegeneric" version ".zip"))
       (sha256
        (base32 "0wwi1c6md4vkbcsfsf8dklf3vr4mcdj4mpxkanwgb6jb1432x5yw"))))
    (build-system python-build-system)
    (native-inputs
     (list unzip))
    (home-page "http://cheeseshop.python.org/pypi/simplegeneric")
    (synopsis "Python module for simple generic functions")
    (description
     "The simplegeneric module lets you define simple single-dispatch generic
functions, akin to Python’s built-in generic functions like @code{len()},
@code{iter()} and so on.  However, instead of using specially-named methods,
these generic functions use simple lookup tables, akin to those used by
e.g. @code{pickle.dump()} and other generic functions found in the Python
standard library.")
    (license license:zpl2.1)))

(define-public python-ipython-genutils
  ;; TODO: This package is retired, check if can be removed, see description.
  (package
    (name "python-ipython-genutils")
    (version "0.1.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "ipython_genutils" version))
      (sha256
       (base32 "19l2pp1c64ansr89l3cqh19jdi2ixhssdzx0vz4n6r52a6i281is"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ; no tests
    (home-page "https://ipython.org")
    (synopsis "Vestigial utilities from IPython")
    (description
     "This package provides retired utilities from IPython.  No packages
outside IPython/Jupyter should depend on it.

This package shouldn't exist.  It contains some common utilities shared by
Jupyter and IPython projects during The Big Split.  As soon as possible, those
packages will remove their dependency on this, and this package will go
away.")
    (license license:bsd-3)))

;;; Variant used to break a cycle with python-ipykernel.
(define-public python-ipyparallel-bootstrap
  (hidden-package
   (package
     (name "python-ipyparallel-bootstrap")
     (version "8.2.1")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ipyparallel" version))
        (sha256
         (base32
          "0wiwfd7870zbmczzn96jqxxjf2zcbcaxnsl1ddn8hspwa8y4frzj"))))
     (build-system python-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases #~(modify-phases %standard-phases
                    ;; The python-ipykernel is normally propagated but is
                    ;; removed from this package to break the cycle.
                    (delete 'sanity-check))))
     (propagated-inputs
      (list python-dateutil
            python-decorator
            python-entrypoints
            python-ipython
            ;; python-ipykernel is omitted here to break a cycle.
            python-jupyter-client-bootstrap
            python-psutil
            python-pyzmq
            python-tornado-6
            python-tqdm
            python-traitlets))
     (home-page "https://ipython.org/")
     (synopsis "Interactive Parallel Computing with IPython")
     (description
      "@code{ipyparallel} is a Python package and collection of CLI scripts for
controlling clusters for Jupyter.  @code{ipyparallel} contains the following
CLI scripts:
@enumerate
@item ipcluster - start/stop a cluster
@item ipcontroller - start a scheduler
@item ipengine - start an engine
@end enumerate")
     (license license:bsd-3))))

(define-public python-ipyparallel
  (package
    (inherit python-ipyparallel-bootstrap)
    (name "python-ipyparallel")
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda _
              (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-ipython
           python-pytest
           python-pytest-asyncio
           python-pytest-cov
           python-pytest-tornado
           python-testpath))
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-ipyparallel-bootstrap)
       (replace "python-jupyter-client-bootstrap" python-jupyter-client)
       (append python-ipykernel)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-ipyparallel-bootstrap)))))

(define-public python-ipython-cluster-helper
  (package
    (name "python-ipython-cluster-helper")
    (version "0.6.4")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ipython-cluster-helper" version))
        (sha256
         (base32
          "1l6mlwxlkxpbvawfwk6qffich7ahg9hq2bxfissgz6144p3k4arj"))
        (modules '((guix build utils)))
        (snippet
         '(begin (substitute* "requirements.txt"
                   (("ipython.*") "ipython\n"))
                 #t))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f      ; Test suite can't find IPython.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (if tests?
               (begin
                 (setenv "HOME" (getcwd))
                 (add-installed-pythonpath inputs outputs)
                 (invoke "python" "example/example.py" "--local"))
               #t))))))
    (propagated-inputs
     (list python-ipyparallel
           python-ipython
           python-netifaces
           python-pyzmq
           python-setuptools
           python-six))
    (home-page "https://github.com/roryk/ipython-cluster-helper")
    (synopsis
     "Simplify IPython cluster start up and use for multiple schedulers")
    (description
     "@code{ipython-cluster-helper} creates a throwaway parallel IPython
profile, launches a cluster and returns a view.  On program exit it shuts the
cluster down and deletes the throwaway profile.")
    (license license:expat)))

(define-public python-ipython-sql
  (package
    (name "python-ipython-sql")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipython-sql" version))
       (sha256
        (base32 "1r6rz8jgrqzhkf2flwjw75d96g8l7kykmx5wli3q1988w96391ip"))))
    (build-system python-build-system)
    (arguments
     (list #:tests? #f                  ;must run under IPython
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'permit-newer-prettytable
                 ;; See https://github.com/catherinedevlin/ipython-sql/issues/202
                 (lambda _
                   (substitute* "setup.py"
                     (("prettytable<1")
                      "prettytable")))))))
    (propagated-inputs
     (list python-ipython
           python-ipython-genutils
           python-prettytable
           python-six
           python-sqlalchemy
           python-sqlparse))
    (home-page "https://github.com/catherinedevlin/ipython-sql")
    (synopsis "RDBMS access via IPython")
    (description "This library connects to a database, using SQLAlchemy URL
connect strings, then issue SQL commands within IPython or IPython Notebook.")
    (license license:expat)))

(define-public python-traitlets
  (package
    (name "python-traitlets")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "traitlets" version))
       (sha256
        (base32
         "1ivhxglsrnhqw4g98ihddn7i5f6976gpk31fijwq473wb9n4b7q5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check (lambda* (#:key tests? #:allow-other-keys)
                           (when tests?
                             (invoke "pytest" "-vv" "traitlets")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://ipython.org")
    (synopsis "Configuration system for Python applications")
    (description
     "Traitlets is a framework that lets Python classes have attributes with
type checking, dynamically calculated default values, and ‘on change’
callbacks.  The package also includes a mechanism to use traitlets for
configuration, loading values from files or from command line arguments.  This
is a distinct layer on top of traitlets, so you can use traitlets in your code
without using the configuration machinery.")
    (license license:bsd-3)))

(define-public python-jupyter-core
  (package
    (name "python-jupyter-core")
    (version "4.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append (pypi-uri "jupyter_core" version)))
       (sha256
        (base32
         "1v0s31rmwppdmww135hif03hy164j9kimirh24kxfcbvdfql9pm6"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;;  Some tests write to $HOME.
               (setenv "HOME" "/tmp")
               (invoke "pytest" "-vv"
                       "-k"
                       (string-append
                        ;; XXX: These tests fail with "ModuleNotFoundError: No
                        ;; module named 'jupyter_core'".
                        "not test_argv0 and not test_path_priority "
                        "and not test_not_on_path")))))
         (add-after 'unpack 'patch-testsuite
           (lambda _
             ;; test_not_on_path() and test_path_priority() try to run a test
             ;; that loads jupyter_core, so we need GUIX_PYTHONPATH
             (substitute* "jupyter_core/tests/test_command.py"
               (("env = \\{'PATH': ''\\}")
                "env = {'PATH': '', 'PYTHONPATH': os.environ['GUIX_PYTHONPATH']}")
               (("env = \\{'PATH':  str\\(b\\)\\}")
                "env = {'PATH': str(b), 'PYTHONPATH': os.environ['GUIX_PYTHONPATH']}"))))
         ;; Migration is running whenever etc/jupyter exists, but the
         ;; Guix-managed directory will never contain any migratable IPython
         ;; config files and cannot be written to anyway, so just pretend we
         ;; already did that.
         (add-after 'install 'disable-migration
           (lambda* (#:key outputs #:allow-other-keys)
             (mkdir-p (string-append (assoc-ref outputs "out") "/etc/jupyter"))
             (invoke "touch"
               (string-append
                 (assoc-ref outputs "out")
                 "/etc/jupyter/migrated")))))))
    (propagated-inputs (list python-traitlets))
    (native-inputs (list python-pytest))
    ;; This package provides the `jupyter` binary and thus also exports the
    ;; search paths.
    (native-search-paths
     (list (search-path-specification
            (variable "JUPYTER_CONFIG_PATH")
            (files '("etc/jupyter")))
           (search-path-specification
            (variable "JUPYTER_PATH")
            (files '("share/jupyter")))))
    (home-page "https://jupyter.org/")
    (synopsis "Jupyter base package")
    (description
     "Jupyter core is the base package on which Jupyter projects rely.")
    (license license:bsd-3)))

;; Bootstrap variant of jupyter-client, which breaks the loop between ipykernel
;; and jupyter-client by removing the former from its native-inputs and
;; disabling tests.
(define-public python-jupyter-client-bootstrap
  (hidden-package
   (package
     (name "python-jupyter-client-bootstrap")
     (version "7.2.2")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jupyter_client" version))
        (sha256
         (base32
          "12pbp177bfb3710y1a5598mwn8ffhyzmpll67m0nmalb98savnwg"))))
     (build-system python-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases
       #~(modify-phases %standard-phases
           (add-after 'unpack 'set-tool-file-names
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "jupyter_client/localinterfaces.py"
                 (("'ip'")
                  (format #f "'~a'" (search-input-file inputs "sbin/ip")))))))))
     (inputs (list iproute))
     (propagated-inputs
      (list python-dateutil
            python-entrypoints
            python-jupyter-core
            python-nest-asyncio
            python-pyzmq
            python-tornado-6
            python-traitlets))
     (home-page "https://jupyter.org/")
     (synopsis "Jupyter protocol implementation and client libraries")
     (description
      "The @code{jupyter_client} package contains the reference implementation
of the Jupyter protocol.  It also provides client and kernel management APIs
for working with kernels, and the @code{jupyter kernelspec} entrypoint for
installing @code{kernelspec}s for use with Jupyter frontends.")
     (license license:bsd-3))))

(define-public python-jupyter-client
  (let ((base python-jupyter-client-bootstrap))
    (package
      (inherit base)
      (name "python-jupyter-client")
      (arguments
       (substitute-keyword-arguments (package-arguments base)
         ((#:tests? _ #f)
          (not (%current-target-system)))
         ((#:phases phases #~%standard-phases)
          #~(modify-phases #$phases
              (replace 'check
                (lambda* (#:key tests? #:allow-other-keys)
                  (when tests?
                    ;; Some tests try to write to $HOME.
                    (setenv "HOME" "/tmp")
                    (invoke "pytest" "-vv"))))))))
      (native-inputs
       (list python-pytest
             python-pytest-asyncio
             python-pytest-timeout
             python-async-generator
             python-ipython
             python-ipykernel-bootstrap))
      (properties (alist-delete 'hidden? (package-properties base))))))

(define-public python-ipykernel
  (package
    (name "python-ipykernel")
    (version "6.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipykernel" version))
       (sha256
        (base32 "0q5yni8h08nadsn53f957p0pjsjhwl2b2lp1hqz3jn0854z2fa0f"))))
    (build-system python-build-system)
    (arguments
     (list
      #:imported-modules `(,@%python-build-system-modules
                           (guix build syscalls))
      #:modules '((guix build python-build-system)
                  (guix build syscalls)
                  (guix build utils)
                  (ice-9 match))
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (match (primitive-fork)
                  (0                    ;child process
                   (set-child-subreaper!)
                   ;; XXX: Tini provides proper PID1-like signal handling that
                   ;; reaps zombie processes, necessary for the
                   ;; 'test_shutdown_subprocesses' test to pass.

                   ;; TODO: Complete https://issues.guix.gnu.org/30948.
                   (setenv "HOME" "/tmp")
                   (execlp "tini" "--" "pytest" "-vv"))
                  (pid
                   (match (waitpid pid)
                     ((_ . status)
                      (unless (zero? status)
                        (error "`pytest' exited with status"
                               status)))))))))
          (add-after 'install 'set-python-file-name
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Record the absolute file name of the 'python' executable in
              ;; 'kernel.json'.
              (substitute* (string-append #$output "/share/jupyter"
                                          "/kernels/python3/kernel.json")
                (("\"python\"")
                 (format #f "~s" (search-input-file inputs
                                                    "/bin/python3")))))))))
    (propagated-inputs
     (list python-debugpy
           python-ipython
           python-jupyter-client        ;imported at runtime during connect
           python-matplotlib-inline
           ;;python-nest-asyncio
           ;;python-packaging
           python-psutil
           python-tornado-6
           python-traitlets))
    (inputs (list python))              ;for cross compilation
    (native-inputs
     (list python-flaky
           python-ipyparallel-bootstrap
           ;; XXX: Our Pytest package captures its native inputs in its
           ;; wrapper script (such as python-nose), which is used in the code
           ;; and causes deprecation warnings.  Using the bootstrap variant
           ;; avoids that.
           python-pytest-bootstrap
           python-pytest-timeout
           tini))
    (home-page "https://ipython.org")
    (synopsis "IPython Kernel for Jupyter")
    (description "This package provides the IPython kernel for Jupyter.")
    (license license:bsd-3)))

;; Bootstrap variant of ipykernel, which uses the bootstrap jupyter-client to
;; break the cycle between ipykernel and jupyter-client.
(define-public python-ipykernel-bootstrap
  (let ((parent python-ipykernel))
    (hidden-package
      (package
        (inherit parent)
        (name "python-ipykernel-bootstrap")
        (arguments (list #:tests? #f
                         ;; The package should normally propagate ipykernel,
                         ;; left out here to break the cycle.
                         #:phases #~(modify-phases %standard-phases
                                      (delete 'sanity-check))))
        (native-inputs '())
        (propagated-inputs
         (modify-inputs (package-propagated-inputs parent)
           (replace "python-jupyter-client" python-jupyter-client-bootstrap)
           (append python-ipyparallel-bootstrap)))))))

(define-public python-pari-jupyter
  (package
    (name "python-pari-jupyter")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pari-jupyter" version))
       (sha256
        (base32
         "1ikqvv335qfrhmlji0iclci6pnm2c3fvnxf031jr1d68j79g6ypd"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ;no test suite
    (inputs
     (list pari-gp readline python-ipykernel))
    (home-page "https://github.com/sagemath/pari-jupyter")
    (synopsis "Jupyter kernel for PARI/GP")
    (description "The package provides a PARI/GP kernel for Jupyter.")
    (license license:gpl3+)))

(define-public python-backcall
  (package
    (name "python-backcall")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backcall" version))
       (sha256
        (base32
         "07jy4562lvnhkk6kfr3cphmizy88anlhmbwb8kdzlz2ypqkvzgaw"))))
    (build-system python-build-system)
    (home-page "https://github.com/takluyver/backcall/")
    (synopsis "Specifications for callback functions passed in to an API")
    (description
     "If your code lets other people supply callback functions, it's important
to specify the function signature you expect, and check that functions support
that.  Adding extra parameters later would break other peoples code unless
you're careful.  The @code{backcall} package provides a way of specifying the
callback signature using a prototype function.")
    (license license:bsd-3)))

(define-public python-pure-eval
  (package
    (name "python-pure-eval")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pure_eval" version))
       (sha256
        (base32 "1hwsm85cwqwh6d6x4vzcimla2865s6v19ms3ym81ganzyq534i9b"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest python-setuptools-scm))
    (home-page "https://github.com/alexmojaki/pure_eval")
    (synopsis "Python library to evaluate abstract syntax tree nodes")
    (description "The @code{pure_eval} Python library can safely evaluate
abstract syntax tree (AST) nodes without side effects.")
    (license license:expat)))

(define-public python-asttokens
  (package
    (name "python-asttokens")
    (version "2.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asttokens" version))
       (sha256
        (base32 "1mglbkikxvnhrk3inbx0v1qzxwd38qjr6l35sn098yicy0ac2m4s"))))
    (build-system python-build-system)
    (propagated-inputs (list python-six))
    (native-inputs (list python-astroid python-pytest python-setuptools-scm))
    (home-page "https://github.com/gristlabs/asttokens")
    (synopsis "Python library to annotate abstract syntax trees")
    (description "The @code{asttokens} module annotates Python abstract syntax
trees (ASTs) with the positions of tokens and text in the source code that
generated them.  It makes it possible for tools that work with logical AST
nodes to find the particular text that resulted in those nodes, for example
for automated refactoring or highlighting.")
    (license license:asl2.0)))

(define-public python-littleutils
  (package
    (name "python-littleutils")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "littleutils" version))
       (sha256
        (base32 "0vwijrylppmk0nbddqvn527r9cg3zw8d6zk6r58hslry42jf7jp6"))))
    (build-system python-build-system)
    (home-page "https://github.com/alexmojaki/littleutils")
    (synopsis "Python utility function collection")
    (description "@code{littleutils} is a small collection of Python utility
functions, useful in the context of writing unit tests among other uses.")
    (license license:expat)))

(define-public python-stack-data
  (package
    (name "python-stack-data")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "stack_data" version))
       (sha256
        (base32 "04lfcj5qrn4qikjw89qbdzqwm0xm4bgm4m8rll1rafk3pm0jssa5"))))
    (build-system python-build-system)
    (propagated-inputs (list python-asttokens python-executing python-pure-eval))
    (native-inputs
     (list python-cython
           python-littleutils
           python-pygments
           python-pytest
           python-setuptools-scm
           python-typeguard))
    (home-page "https://github.com/alexmojaki/stack_data")
    (synopsis "Python stack frame and traceback manipulation library")
    (description "The @code{stack_data} Python library extracts data from
stack frames and tracebacks.  Is can be used to display more useful tracebacks
than the default.")
    (license license:expat)))

(define-public python-ipython
  (package
    (name "python-ipython")
    (version "8.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipython" version ".tar.gz"))
       (sha256
        (base32 "1hcxa713wh3axa57412iy02rj0494ljvv6gpnls4lndc5h9yprbh"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'make-docs-reproducible
           (lambda _
             (substitute* "IPython/sphinxext/ipython_directive.py"
               ((".*import datetime") "")
               ((".*datetime.datetime.now\\(\\)") "")
               (("%timeit") "# %timeit"))))
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (setenv "HOME" "/tmp/")  ;required by some tests
               (invoke "python" "-m" "pytest" "-vv")))))))
    (inputs (list readline which))
    (propagated-inputs
     (list python-backcall
           python-decorator
           python-jedi
           python-jinja2
           python-jsonschema
           python-matplotlib
           python-matplotlib-inline
           python-mistune
           python-nbformat
           python-numpy
           python-numpydoc
           python-pexpect
           python-pickleshare
           python-prompt-toolkit
           python-pygments
           python-pyzmq
           python-simplegeneric
           python-stack-data
           python-terminado
           python-traitlets))
    (native-inputs
     (list graphviz
           pkg-config
           ;; For tests.
           python-pytest
           python-requests
           python-testpath))
    (home-page "https://ipython.org")
    (synopsis "IPython is a tool for interactive computing in Python")
    (description
     "IPython provides a rich architecture for interactive computing with:
Powerful interactive shells, a browser-based notebook, support for interactive
data visualization, embeddable interpreters and tools for parallel
computing.")
    (properties '((cpe-name . "ipython")))
    (license license:bsd-3)))

(define-public python-ipython-documentation
  (package
    (inherit python-ipython)
    (name "python-ipython-documentation")
    (version (package-version python-ipython))
    (source
     (origin
       (inherit (package-source python-ipython))
       (patches (append (search-patches
                         "python-ipython-documentation-chars.patch"
                         "python-ipython-documentation-repro.patch")
                        (origin-patches (package-source python-ipython))))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-pythonpath
            (lambda _
              ;; Ensure this fixed (via the
              ;; "python-ipython-documentation-chars.patch" patch) copy of
              ;; IPython gets used.
              (setenv "PYTHONPATH" (string-append (getcwd)))))
          (add-before 'build 'configure-sphinx-for-xelatex
            (lambda _
              ;; Use XeLaTeX instead of PDFLaTeX, as it can
              ;; cope with the Unicode characters present in the
              ;; contributors page, for example.
              (substitute* "docs/source/conf.py"
                (("project = 'IPython'.*" all)
                 (string-append all "latex_engine = 'xelatex'\n")))
              ;; XXX: The Sphinx-generated ipython.tex specifies the GNU
              ;; FreeFont font to be searched via its extension, which uses
              ;; kpathsea instead of fontconfig and fail (see:
              ;; https://github.com/sphinx-doc/sphinx/issues/10347).  Create a
              ;; symlink to GNU FreeFont and add it to the TEXMF tree via
              ;; GUIX_TEXMF.
              (mkdir-p "texmf-dist/fonts/opentype/public")
              (symlink (string-append
                        #$(this-package-native-input "font-gnu-freefont")
                        "/share/fonts/opentype")
                       (string-append
                        (getcwd) "/"
                        "texmf-dist/fonts/opentype/public/gnu-freefont"))
              (setenv "GUIX_TEXMF" (string-append (getenv "GUIX_TEXMF") ":"
                                                  (getcwd) "/texmf-dist"))))
          (delete 'build)
          (delete 'check)
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/" #$name "-" #$version))
                     (html (string-append doc "/html"))
                     (info (string-append data "/info")))
                (invoke "make" "-C" "docs" "info" "html" "pdf"
                        (string-append "SPHINXOPTS=-j"
                                       (number->string (parallel-job-count))))
                (install-file "COPYING.rst" doc)
                (copy-recursively "examples" (string-append doc "/examples"))
                ;; Install HTML documentation.
                (copy-recursively "docs/build/html" html)
                ;; Likewise for the PDF.
                (install-file "docs/build/latex/ipython.pdf" doc)
                ;; Likewise for the info manual.
                (install-file "docs/build/texinfo/ipython.info" info)
                (symlink (string-append html "/_images")
                         (string-append info "/ipython-figures"))))))))
    (native-inputs
     (list fontconfig                   ;for XDG_DATA_DIRS to locate fonts
           font-gnu-freefont
           graphviz
           python-docrepr
           python-sphinx
           python-sphinx-rtd-theme
           texinfo
           texlive-bin
           texlive-polyglossia
           texlive-xindy))))

(define-public python-urwid
  (package
    (name "python-urwid")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "urwid" version))
       (sha256
        (base32
         "1bky2bra6673xx8jy0826znw6cmxs89wcwwzda8d025j3jffx2sq"))))
    (build-system python-build-system)
    (arguments
      (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'remove-vterm-tests
              ;; According to Debian these tests are cursed.
              ;; https://salsa.debian.org/python-team/packages/urwid/-/blob/debian/2.1.2-2/debian/changelog#L141
              (lambda _
                (delete-file "urwid/tests/test_vterm.py"))))))
    (home-page "http://urwid.org")
    (synopsis "Console user interface library for Python")
    (description
     "Urwid is a curses-based UI/widget library for Python.  It includes many
features useful for text console applications.")
    (license license:lgpl2.1+)))

(define-public python-urwid-readline
  (package
    (name "python-urwid-readline")
    (version "0.13")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/rr-/urwid_readline")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0y9k86p31mlr9rwnrbljvfgl183r5j60yaj0r3scljn1m0mlg8qg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (propagated-inputs (list python-urwid))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/rr-/urwid_readline")
    (synopsis "Text input widget for urwid that supports readline shortcuts")
    (description
     "This package provides a textbox edit widget for @code{python-urwid} that
supports @code{readline} shortcuts.")
    (license license:expat)))

(define-public python-textdistance
  (package
    (name "python-textdistance")
    (version "4.2.1")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/life4/textdistance")
             (commit (string-append "v." version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1g17i356fnny4k6hjr2ayy9k77jbvd6zzmngws2kbrnvhss1wgwf"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-external-test
           (lambda _
             ;; All tests in this file require external libraries.
             (delete-file "tests/test_external.py")
             #t)))))
    (native-inputs
     (list python-hypothesis
           python-isort
           python-numpy
           python-pytest
           python-pytest-runner
           python-tabulate))
    (home-page "https://github.com/life4/textdistance")
    (synopsis "Compute distance between the two texts")
    (description "@code{textdistance} is a pure Python library for comparing
distance between two or more sequences by many algorithms.")
    (license license:expat)))

(define-public python-urwidtrees
  (package
    (name "python-urwidtrees")
    (version "1.0.3")
    (source
      (origin
        (method git-fetch)
        ;; package author intends on distributing via github rather than pypi:
        ;; https://github.com/pazz/alot/issues/877#issuecomment-230173331
        (uri (git-reference
               (url "https://github.com/pazz/urwidtrees")
               (commit version)))
        (file-name (git-file-name name version))
        (sha256
          (base32
           "1y1vysx7jg0vbrarlsykhf7nmr8fc6k1fva1q3i98xq2m30s6r68"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; no tests
    (propagated-inputs (list python-urwid))
    (native-inputs (list python-mock))
    (home-page "https://github.com/pazz/urwidtrees")
    (synopsis "Tree widgets for urwid")
    (description "Urwidtrees is a Widget Container API for the @code{urwid}
toolkit.  Use it to build trees of widgets.")
    (license license:gpl3+)))

(define-public python-ua-parser
  (package
    (name "python-ua-parser")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ua-parser" version))
       (sha256
        (base32
         "0csh307zfz666kkk5idrw3crj1x8q8vsqgwqil0r1n1hs4p7ica7"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;no test suite in release
    (native-inputs
     (list python-pyyaml))
    (home-page "https://github.com/ua-parser/uap-python")
    (synopsis "User agent parser")
    (description
     "@code{ua-parser} is a Python port of Browserscope's user agent parser.")
    (license license:asl2.0)))

(define-public python-user-agents
  (package
    (name "python-user-agents")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "user-agents" version))
       (sha256
        (base32
         "09mddriffm9rkwr30081fy9n3cn976ms8pwc8p8hhlxnilbjavfk"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                  ;missing devices.json test file in release
    (propagated-inputs
     (list python-ua-parser))
    (home-page "https://github.com/selwin/python-user-agents")
    (synopsis "User Agent strings parsing library")
  (description
   "A library to identify devices (phones, tablets) and their capabilities by
parsing (browser/HTTP) user agent strings.")
  (license license:expat)))

(define-public python-pydbus
  (package
    (name "python-pydbus")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pydbus" version))
        (sha256
          (base32 "0b0gipvz7vcfa9ddmwq2jrx16d4apb0hdnl5q4i3h8jlzwp1c1s2"))))
    (build-system python-build-system)
    (propagated-inputs (list python-pygobject))
    (home-page "https://github.com/LEW21/pydbus")
    (synopsis "Pythonic D-Bus library")
    (description "Pydbus provides a pythonic interface to the D-Bus
message bus system.  Pydbus can be used to access remote objects and
also for object publication.  It is based on PyGI, the Python GObject
Introspection bindings, which is the recommended way to use GLib from Python.")
    (license license:lgpl2.1+)))

(define-public python-dbus
  (package
    (name "python-dbus")
    (version "1.2.18")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://dbus.freedesktop.org/releases/dbus-python/"
                           "dbus-python-" version ".tar.gz"))
       (sha256
        (base32 "0q3jrw515z98mqdk9x822nd95rky455zz9876f1nqna5igkd3gcj"))))
    (build-system gnu-build-system)
    (native-inputs
     (list pkg-config))
    (inputs
     `(("python" ,python-wrapper)
       ("dbus-glib" ,dbus-glib)))
    (synopsis "Python bindings for D-bus")
    (description "python-dbus provides bindings for libdbus, the reference
implementation of D-Bus.")
    (home-page "https://www.freedesktop.org/wiki/Software/DBusBindings/")
    (properties `((python2-variant . ,(delay python2-dbus))))
    (license license:expat)))

(define-public python2-dbus
  (package/inherit python-dbus
    (name "python2-dbus")
    (inputs `(("python" ,python-2)
              ,@(alist-delete "python"
                              (package-inputs python-dbus))))
    (arguments
     `(#:configure-flags '("PYTHON_VERSION=2")))))

(define-public python-dbus-next
  (package
    (name "python-dbus-next")
    (version "0.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/altdesktop/python-dbus-next")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1ahaz52kny1p9xxv6phvk4iq56rg8li390wywlxf2yslaij1188h"))))
    (build-system python-build-system)
    (native-inputs
      (list python-pytest))
    (home-page "https://github.com/altdesktop/python-dbus-next")
    (synopsis "Zero-dependency DBus library for Python with asyncio support")
    (description
     "This DBus library for Python aims to be a fully-featured high-level
library primarily geared towards integration of applications into desktop and
mobile environments.")
    (license license:expat)))

(define-public python-notify2
  (package
    (name "python-notify2")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "notify2" version))
       (sha256
        (base32
         "0z8rrv9rsg1r2qgh2dxj3dfj5xnki98kgi3w839kqby4a26i1yik"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))                    ; tests depend on system state
    (propagated-inputs
     (list python-dbus))
    (home-page "https://bitbucket.org/takluyver/pynotify2")
    (synopsis "Python interface to D-Bus notifications")
    (description
     "Pynotify2 provides a Python interface for sending D-Bus notifications.
It is a reimplementation of pynotify in pure Python, and an alternative to
the GObject Introspection bindings to libnotify for non-GTK applications.")
    (license (list license:bsd-2
                   license:lgpl2.1+))))

;; beautifulsoup4 has a totally different namespace than 3.x,
;; and pypi seems to put it under its own name, so I guess we should too
(define-public python-beautifulsoup4
  (package
    (name "python-beautifulsoup4")
    (version "4.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beautifulsoup4" version))
       (sha256
        (base32
         "14v68cpfzckfz63n9hnbsm271jvzvxscyijz83mhha7gcmdsb6md"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-soupsieve python-html5lib python-lxml))
    (home-page
     "https://www.crummy.com/software/BeautifulSoup/bs4/")
    (synopsis
     "Python screen-scraping library")
    (description
     "Beautiful Soup is a Python library designed for rapidly setting up
screen-scraping projects.  It offers Pythonic idioms for navigating,
searching, and modifying a parse tree, providing a toolkit for
dissecting a document and extracting what you need.  It automatically
converts incoming documents to Unicode and outgoing documents to UTF-8.")
    (license license:expat)))

(define-public python-soupsieve
  (package
    (name "python-soupsieve")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "soupsieve" version))
       (sha256
        (base32
         "1k70gpn2d3vgdyxbdy536dgm4kchcraxz6lmgsfg3324iy2789q5"))))
    (build-system python-build-system)
    (arguments
      ;;XXX: 2 tests fail currently despite claming they were to be
      ;;skipped. Also, beautifulsoup4 may depend on this in the future, so we
      ;;don't want to create a circular dependency.
      (list #:tests? #f
            #:phases
            #~(modify-phases %standard-phases
                ;; Circular dependency with python-beautifulsoup4.
                (delete 'sanity-check))))
    (home-page "https://github.com/facelessuser/soupsieve")
    (synopsis "CSS selector library")
    (description
     "Soup Sieve is a CSS selector library designed to be used with Beautiful
Soup 4.  It aims to provide selecting, matching, and filtering using modern
CSS selectors.  Soup Sieve currently provides selectors from the CSS level 1
specifications up through the latest CSS level 4 drafts and beyond (though
some are not yet implemented).")
    (license license:expat)))


(define-public python-netifaces
  (package
    (name "python-netifaces")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "netifaces" version))
        (sha256
          (base32
            "0cnajf5rl4w1sa72j921scbigr6zndig56cq8ggpx45jdqa7jfh4"))))
    (build-system python-build-system)
    (home-page "https://github.com/al45tair/netifaces")
    (synopsis
      "Python module for portable network interface information")
    (description
      "Netifaces is a Python module providing information on network
interfaces in an easy and portable manner.")
    (license license:expat)))

(define-public python-networkx
  (package
    (name "python-networkx")
    (version "2.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "networkx" version))
       (sha256
        (base32 "19h18f5j79l7kmwm5cvm75fadjgmkzw5m3pyvb9cnq0860q7faxx"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv" "--pyargs" "networkx")
                          (format #t "test suite not run~%")) #t)))))
    (propagated-inputs (list python-decorator))
    (native-inputs (list python-pytest))
    (home-page "https://networkx.github.io/")
    (synopsis
     "Python module for creating and manipulating graphs and networks")
    (description
     "NetworkX is a Python package for the creation, manipulation, and study
of the structure, dynamics, and functions of complex networks.")
    (license license:bsd-3)))


(define-public python-datrie
  (package
    (name "python-datrie")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "datrie" version))
       (sha256
        (base32
         "0pbn32flkrpjiwfcknmj6398qa81ba783kbcvwan3kym73v0hnsj"))))
    (build-system python-build-system)
    (native-inputs
     (list python-cython python-hypothesis python-pytest
           python-pytest-runner))
    (home-page "https://github.com/kmike/datrie")
    (synopsis "Fast, efficiently stored trie for Python")
    (description
     "This package provides a fast, efficiently stored trie implementation for
Python.")
    (license license:lgpl2.1+)))

(define-public python-amply
  (package
    (name "python-amply")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "amply" version))
       (sha256
        (base32
         "0f1db9zp0rsfzxvaz55xwh8h5rfdgr9a2a715g06ic8nknsdq4nb"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-docutils python-pyparsing))
    (native-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/willu47/amply")
    (synopsis "Load and manipulate AMPL/GLPK data as Python data structures")
    (description
     "Amply allows you to load and manipulate AMPL/GLPK data as Python data
structures.")
    (license license:epl1.0)))

(define-public python-pulp
  (package
    (name "python-pulp")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PuLP" version))
       (sha256
        (base32
         "1dammrg0f1v0r028i3rpxbf2bsyxmjq0q6ihb4x2wsdki44z3bxj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-amply))
    (home-page "https://github.com/coin-or/pulp")
    (synopsis "Linear Programming modeler")
    (description
     "PuLP is a Linear Programming modeler written in Python.  PuLP can
generate MPS or LP files and call GLPK, COIN CLP/CBC, CPLEX, and GUROBI to
solve linear problems.")
    (license license:expat)))

(define-public python-py-tes
  (package
    (name "python-py-tes")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py-tes" version))
       (sha256
        (base32 "0b272y392v0mnq0f3sm5kgcx8fn4qwfbym89hhvqxz3xkganr4pn"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-attrs python-dateutil python-future python-requests))
    (home-page "https://github.com/ohsu-comp-bio/py-tes")
    (synopsis "Library for communicating with the GA4GH Task Execution API")
    (description "This package provides a library for communicating with the
GA4GH Task Execution API.")
    (license license:expat)))

(define-public python-toposort
  (package
    (name "python-toposort")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "toposort" version))
       (sha256
        (base32
         "1b2hppzjg3p006qya3yfdnp76dwq8frl97lypdam0kw4xxb8yhm7"))))
    (build-system python-build-system)
    (home-page "https://gitlab.com/ericvsmith/toposort")
    (synopsis "Topological sort algorithm")
    (description
     "This package provides an implementation of a topological sort
algorithm.")
    (license license:asl2.0)))

(define-public python-three-merge
  (package
    (name "python-three-merge")
    (version "0.1.1")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/spyder-ide/three-merge")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fw28swh6jq4myr09j7gv68l241b8vwg470ak5xv0x4xwh2a1m86"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"))
    (propagated-inputs
     (list python-diff-match-patch))
    (native-inputs
     (list python-flaky python-pytest python-pytest-cov
           python-pytest-runner python-pytest-timeout))
    (home-page "https://github.com/spyder-ide/three-merge")
    (synopsis "Library for merging two strings with respect to a base one")
    (description
     "This package provides a Python library to perform a 3-way merge between
strings, based on @code{diff-match-patch}.  This library performs merges at a
character level, as opposed to most VCS systems, which opt for a line-based
approach.")
    (license license:expat)))

(define-public snakemake
  (package
    (name "snakemake")
    (version "5.32.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "snakemake" version))
       (sha256
        (base32 "13013gdavwvyj1qr9xfi9fpwhb3km8c3z53bja5b7ic3sb2z6dgz"))))
    (build-system python-build-system)
    (arguments
     ;; TODO: Package missing test dependencies.
     '(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         ;; For cluster execution Snakemake will call Python.  Since there is
         ;; no suitable PYTHONPATH set, cluster execution will fail.  We fix
         ;; this by calling the snakemake wrapper instead.
         (add-after 'unpack 'call-wrapper-not-wrapped-snakemake
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* "snakemake/executors/__init__.py"
               (("\\{sys.executable\\} -m snakemake")
                (string-append (assoc-ref outputs "out")
                               "/bin/snakemake")))
             #t)))))
    (propagated-inputs
     (list python-appdirs
           python-configargparse
           python-datrie
           python-docutils
           python-gitpython
           python-jinja2
           python-jsonschema
           python-nbformat
           python-networkx
           python-psutil
           python-pulp
           python-pyyaml
           python-ratelimiter
           python-requests
           python-toposort
           python-wrapt))
    (home-page "https://snakemake.readthedocs.io")
    (synopsis "Python-based execution environment for make-like workflows")
    (description
      "Snakemake aims to reduce the complexity of creating workflows by
providing a clean and modern domain specific specification language (DSL) in
Python style, together with a fast and comfortable execution environment.")
    (license license:expat)))

(define-public snakemake-6
  (package
    (inherit snakemake)
    (name "snakemake")
    (version "6.15.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snakemake/snakemake")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09yrpi9f86r9yvcm2dfjs5zy87c4j31bxama77kfd6y8yfrrjlai"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; For cluster execution Snakemake will call Python.  Since there is
         ;; no suitable GUIX_PYTHONPATH set, cluster execution will fail.  We
         ;; fix this by calling the snakemake wrapper instead.

         ;; XXX: There is another instance of sys.executable on line 692, but
         ;; it is not clear how to patch it.
         (add-after 'unpack 'call-wrapper-not-wrapped-snakemake
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* "snakemake/executors/__init__.py"
               (("\\{sys.executable\\} -m snakemake")
                (string-append (assoc-ref outputs "out")
                               "/bin/snakemake")))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (setenv "HOME" "/tmp")
               ;; This test attempts to change S3 buckets on AWS and fails
               ;; because there are no AWS credentials.
               (delete-file "tests/test_tibanna.py")
               (invoke "pytest")))))))
    (propagated-inputs
     (list python-appdirs
           python-configargparse
           python-connection-pool
           python-datrie
           python-docutils
           python-filelock
           python-gitpython
           python-jinja2
           python-jsonschema
           python-nbformat
           python-networkx
           python-psutil
           python-pulp
           python-pyyaml
           python-py-tes
           python-ratelimiter
           python-requests
           python-smart-open
           python-stopit
           python-tabulate
           python-toposort
           python-wrapt))
    (native-inputs
     (list git-minimal
           python-wrapper
           python-pytest
           python-pandas
           python-requests-mock))))

(define-public snakemake-7
  (package
    (inherit snakemake-6)
    (name "snakemake")
    (version "7.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snakemake/snakemake")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qrqbmx4cbis0wxr6dl2rdjv9v627sbirsz6v5c31vlbqwkvs04q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; For cluster execution Snakemake will call Python.  Since there is
         ;; no suitable GUIX_PYTHONPATH set, cluster execution will fail.  We
         ;; fix this by calling the snakemake wrapper instead.
         (add-after 'unpack 'call-wrapper-not-wrapped-snakemake
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* "snakemake/executors/__init__.py"
               (("self\\.get_python_executable\\(\\),")
                "")
               (("\"-m snakemake\"")
                (string-append "\"" (assoc-ref outputs "out")
                               "/bin/snakemake" "\"")))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (setenv "HOME" "/tmp")
               ;; This test attempts to change S3 buckets on AWS and fails
               ;; because there are no AWS credentials.
               (delete-file "tests/test_tibanna.py")
               ;; It's a similar story with this test, which requires access
               ;; to the Google Storage service.
               (delete-file "tests/test_google_lifesciences.py")
               (invoke "pytest")))))))
    (propagated-inputs
     (list python-appdirs
           python-configargparse
           python-connection-pool
           python-datrie
           python-docutils
           python-filelock
           python-gitpython
           python-jinja2
           python-jsonschema
           python-nbformat
           python-networkx
           python-psutil
           python-pulp
           python-pyyaml
           python-py-tes
           python-ratelimiter
           python-requests
           python-retry
           python-smart-open
           python-stopit
           python-tabulate
           python-toposort
           python-wrapt
           python-yte))
    (native-inputs
     (list git-minimal
           python-wrapper
           python-pytest
           python-pandas
           python-requests-mock))))

(define-public python-pyqrcode
  (package
    (name "python-pyqrcode")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyQRCode" version))
       (sha256
        (base32
         "1m9ln8k9v7dfbh1i81225hx5mdsh8mpf9g7r4wpbfmiyfcs7dgzx"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/mnooner256/pyqrcode")
    (synopsis "QR code generator")
    (description
     "Pyqrcode is a QR code generator written purely in Python with
SVG, EPS, PNG and terminal output.")
    (license license:bsd-3)))

(define-public python-seaborn
  (package
    (name "python-seaborn")
    (version "0.11.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "seaborn" version))
              (sha256
               (base32
                "1xpl3zb945sihsiwm9q1yyx84sakk1phcg0fprj6i0j0dllfjifg"))
              (patches (search-patches "python-seaborn-kde-test.patch"
                                       "python-seaborn-2690.patch"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'patch-more-tests
                    (lambda _
                      (substitute* "seaborn/tests/test_distributions.py"
                        (("get_contour_color\\(ax\\.collections\\[0\\]\\)")
                         "get_contour_color(ax.collections[0])")
                        (("c\\.get_color\\(\\)") "get_contour_color(c)")
                        (("def test_hue_ignores_cmap")
                         "def skip_test_hue_ignores_cmap")
                        (("def test_fill_artists")
                         "def skip_test_fill_artists")
                        (("def test_with_rug") "def skip_test_with_rug"))))
                  (add-before 'check 'start-xserver
                    (lambda _
                      (system "Xvfb :1 &")
                      (setenv "DISPLAY" ":1")))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "seaborn")))))))
    (propagated-inputs (list python-pandas python-matplotlib python-numpy
                             python-scipy))
    (native-inputs (list python-pytest xorg-server-for-tests))
    (home-page "https://seaborn.pydata.org/")
    (synopsis "Statistical data visualization")
    (description
     "Seaborn is a library for making attractive and informative statistical
graphics in Python.  It is built on top of matplotlib and tightly integrated
with the PyData stack, including support for numpy and pandas data structures
and statistical routines from scipy and statsmodels.")
    (license license:bsd-3)))


(define-public python-session-info
  (package
    (name "python-session-info")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "session_info" version))
              (sha256
               (base32
                "1dxnrgaxd2nb44n423mnrx119hmnh2yxdnzaw8mg60x7rh1mxniw"))))
    (build-system python-build-system)
    (propagated-inputs (list python-stdlib-list))
    (home-page "https://gitlab.com/joelostblom/session_info")
    (synopsis "Output version information for modules currently loaded")
    (description
     "This package outputs version information for modules loaded in the current
session, Python, and the OS.")
    (license license:bsd-3)))

(define-public python-mpmath
  (package
    (name "python-mpmath")
    (version "1.2.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/fredrik-johansson/mpmath")
                    (commit "c6a35f9ee7c294bcf4e0517bc76b268843db9499")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ifw59fjjls3mas104rh0frilvab2fhk1dkjraxlqni5n9l676im"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-version
           (lambda _
             (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" ,version)
             ;; ZIP does not support timestamps before 1980.
             (setenv "SOURCE_DATE_EPOCH" "315532800")))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (home-page "https://mpmath.org")
    (synopsis "Arbitrary-precision floating-point arithmetic in python")
    (description
     "@code{mpmath} can be used as an arbitrary-precision substitute for
Python's float/complex types and math/cmath modules, but also does much
more advanced mathematics.")
    (license license:bsd-3)))

(define-public python-bigfloat
  (package
    (name "python-bigfloat")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bigfloat" version))
       (sha256
        (base32 "1f0c1hdr39bbl5rds5r1waa1papjmjiyp0ixs64mkjiahzg6pfaq"))))
    (build-system python-build-system)
    (inputs
     (list mpfr))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/mdickinson/bigfloat")
    (synopsis "Arbitrary precision floating-point arithmetic for Python")
    (description
     "This package provides a Python interface to the MPFR library for
multiprecision arithmetic.")
    (license license:lgpl3+)))

(define-public python-plac
  (package
    (name "python-plac")
    (version "1.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "plac" version))
       (sha256
        (base32 "1410h6jw1ksi24kb55xzkwqzba2qqjwiga1s354bf3s5s1jdig9q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-tkinter
           (lambda _
             (substitute* "plac_tk.py"
               (("from Tkinter import Tk")
                "from tkinter import Tk")
               (("from ScrolledText import ScrolledText")
                "from tkinter.scrolledtext import ScrolledText")))))))
    (native-inputs
     `(("python-tkinter" ,python "tk")))
    (home-page "https://github.com/ialbert/plac")
    (synopsis "Command line arguments parser")
    (description "This package can generate command line parameters from
function signatures.")
    (license license:bsd-3)))

(define-public python-yte
  (package
    (name "python-yte")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "yte" version))
       (sha256
        (base32 "07hm1warpqi4ifqgkaz5sg887x4a44yhxafmpf835ywnpchg4s03"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list python-plac python-pyyaml))
    (home-page "https://github.com/koesterlab/yte")
    (synopsis "YAML template engine with Python expressions")
    (description
     "This package provides a YAML template engine with Python expressions.")
    (license license:expat)))

(define-public python-syllables
  (package
    (name "python-syllables")
    (version "1.0.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "syllables" version))
              (sha256
               (base32
                "0wkl6h0rg6fbsxfp0a8fnibf3l4l6lbh6z12cvcilgb6qhxzpmv3"))))
    (build-system python-build-system)
    (home-page "https://github.com/prosegrinder/python-syllables")
    (synopsis "Package for estimating the number of syllables in a word")
    (description
     "This package provides a Python package for estimating the number of
syllables in a word.")
    (license license:gpl3)))

(define-public python-sympy
  (package
    (name "python-sympy")
    (version "1.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sympy" version))
       (sha256
        (base32 "0n46x1rfy8c2a9za3yp2va5icigxj805f9fmiq8c1drwwvf808z3"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key outputs #:allow-other-keys)
             (invoke
               (or (which "python3") (which "python"))
               "-c" "import sympy; sympy.test(\"/core\")"))))))
    (propagated-inputs
     (list python-mpmath))
    (home-page "https://www.sympy.org/")
    (synopsis "Python library for symbolic mathematics")
    (description
     "SymPy is a Python library for symbolic mathematics.  It aims to become a
full-featured computer algebra system (CAS) while keeping the code as simple
as possible in order to be comprehensible and easily extensible.")
    (license license:bsd-3)))

(define-public python-q
  (package
    (name "python-q")
    (version "2.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "q" version))
       (sha256
        (base32
         "1mgfazh8fkizh6walra2zv885f3lcgr3nb02v1frfm4p8ddcy3yy"))))
    (build-system python-build-system)
    (home-page "https://github.com/zestyping/q")
    (synopsis "Quick-and-dirty debugging output for tired programmers")
    (description
     "q is a Python module for \"print\" style of debugging Python code.  It
provides convenient short API for print out of values, tracebacks, and
falling into the Python interpreter.")
    (license license:asl2.0)))

(define-public python-xlib
  (package
    (name "python-xlib")
    (version "0.29")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python-xlib/python-xlib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17cwd2knqm2vwrii3kqii9abwsnydhpg4byqx1vy7rjs6i1vbqfc"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'start-xserver
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((xorg-server (assoc-ref inputs "xorg-server")))
               ;; There must be a running X server and make check doesn't
               ;; start one.  Therefore we must do it.
               (system (format #f "~a/bin/Xvfb :1 &" xorg-server))
               (setenv "DISPLAY" ":1")
               #t))))))
    (native-inputs
     (list python-mock python-setuptools-scm xorg-server))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/python-xlib/python-xlib")
    (synopsis "Python X11 client library")
    (description
     "The Python X Library is intended to be a fully functional
X client library for Python programs.  It is useful to implement
low-level X clients.  It is written entirely in Python.")
    (license license:gpl2+)))

(define-public python-singledispatch
  (package
    (name "python-singledispatch")
    (version "3.4.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "singledispatch" version))
       (sha256
        (base32
         "171b7ip0hsq5qm83np40h3phlr36ym18w0lay0a8v08kvy3sy1jv"))))
    (build-system python-build-system)
    (native-inputs
     (list python-six)) ; required for conversion, not at run-time
    (home-page
     "https://docs.python.org/3/library/functools.html#functools.singledispatch")
    (synopsis "Backport of singledispatch feature from Python 3.4")
    (description
     "This library brings functools.singledispatch from Python 3.4 to Python
2.6-3.3.")
    (license license:expat)))

;; the python- version can be removed with python-3.5
(define-public python-backports-abc
  (package
    (name "python-backports-abc")
      (version "0.5")
      (source
        (origin
          (method url-fetch)
          (uri (pypi-uri "backports_abc" version))
          (sha256
           (base32
            "1pkv8d1zxj5f9i227dxbjczncbv7ks7ywnjwyxfjagm02i2yafq3"))))
    (build-system python-build-system)
    (home-page "https://github.com/cython/backports_abc")
    (synopsis "Backport of additions to the 'collections.abc' module")
    (description
     "Python-backports-abc provides a backport of additions to the
@code{collections.abc} module in Python-3.5.")
    (license license:psfl)))

(define-public python-backports-csv
  (package
    (name "python-backports-csv")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backports.csv" version))
       (sha256
        (base32 "0vdx5jlhs91iizc8j8l8811nqprwvdx39pgkdc82w2qkfgzxyxqj"))))
    (build-system python-build-system)
    (home-page "https://github.com/ryanhiebert/backports.csv")
    (synopsis "Backport of Python 3's csv module for Python 2")
    (description
     "Provides a  backport of Python 3's @code{csv} module for parsing
comma separated values.  The API of the @code{csv} module in Python 2
is drastically different from the @code{csv} module in Python 3.
This is due, for the most part, to the difference between str in
Python 2 and Python 3.")
    (license license:psfl)))

(define-public python-waf
  (package
    (name "python-waf")
    (version "2.0.19")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://waf.io/"
                                  "waf-" version ".tar.bz2"))
              (sha256
               (base32
                "19dvqbsvxz7ch03dh1v0znklrwxlz6yzddc3k9smzrrgny4jch6q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'build
           (lambda _
             ;; XXX: Find a way to add all extra tools.
             (let ((tools '("gccdeps"
                            "clang_compilation_database")))
               (invoke "python" "waf-light" "configure" "build"
                       (string-append "--tools="
                                      (string-join tools ","))))))
         (replace 'check
           (lambda _
             (invoke "python" "waf" "--version")))
         (replace 'install
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               (install-file "waf" (string-append out "/bin")))
             #t))
         ;; waf breaks when it is wrapped.
         (delete 'wrap))))
    (home-page "https://waf.io/")
    (synopsis "Python-based build system")
    (description
     "Waf is a Python-based framework for configuring, compiling and installing
applications.")
    (license license:bsd-3)))

(define-public python-pyzmq
  (package
    (name "python-pyzmq")
    (version "22.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyzmq" version))
       (sha256
        (base32 "0737kizh53n4rjq1xbm6nhr0bq65xflg04i1d8fcky0nwwrw1pcf"))
       (snippet
        #~(begin
            (use-modules (guix build utils))
            ;; The bundled zeromq source code.
            (delete-file-recursively "bundled")
            ;; Delete cythonized files.
            (for-each delete-file
                      (list "zmq/backend/cython/constants.c"
                            "zmq/backend/cython/context.c"
                            "zmq/backend/cython/_device.c"
                            "zmq/backend/cython/error.c"
                            "zmq/backend/cython/message.c"
                            "zmq/backend/cython/_poll.c"
                            "zmq/backend/cython/_proxy_steerable.c"
                            "zmq/backend/cython/socket.c"
                            "zmq/backend/cython/utils.c"
                            "zmq/backend/cython/_version.c"
                            "zmq/devices/monitoredqueue.c"))))))
    (build-system python-build-system)
    (arguments
     `(#:configure-flags
       (list (string-append "--zmq=" (assoc-ref %build-inputs "zeromq")))
       #:phases
       (modify-phases %standard-phases
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (inputs
     (list zeromq))
    (native-inputs
     (list pkg-config python-cython python-pytest))
    (home-page "https://github.com/zeromq/pyzmq")
    (synopsis "Python bindings for 0MQ")
    (description
     "PyZMQ is the official Python binding for the ZeroMQ messaging library.")
    (license license:bsd-4)))

(define-public python-immutabledict
  (package
    (name "python-immutabledict")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "immutabledict" version))
       (sha256
        (base32 "0fpc4gbk7inpfbgdypsg6c18bmdjw8gwx47bjw0hvixn3gghxnqx"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; no tests in PyPI release and no setup.py in GitHub
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/corenting/immutabledict")
    (synopsis "Immutable wrapper around dictionaries")
    (description
     "@dfn{immutabledict} is an immutable wrapper around dictionaries.
It implements the complete mapping interface and can be used as a drop-in
replacement for dictionaries where immutability is desired.")
    (license license:expat)))

(define-public python-emoji
  (package
    (name "python-emoji")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "emoji" version))
       (sha256
        (base32 "0923mpixwq6hdpkgvi4r46alfvf608iq975rb8lnqpq29j71mmjk"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/carpedm20/emoji/")
    (synopsis "Emoji terminal output for Python")
    (description "This package provides Emoji terminal output for Python.  The
entire set of Emoji codes as defined by the Unicode Consortium is supported in
addition to a bunch of aliases.")
    (license license:bsd-3)))

(define-public python-sarge
  (package
    (name "python-sarge")
    (version "0.1.7.post1") ; post release only to correct errors in metadata
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sarge" version))
       (sha256
        (base32 "0g9a53mfnp96877n1yq2jdk1mcv3xm0d93iisvgcn2prdsp45zv4"))))
    (build-system python-build-system)
    (home-page "https://docs.red-dove.com/sarge/")
    (synopsis "Subprocess wrapper with command pipeline functionality")
    (description "@code{sarge} is a wrapper for subprocess which provides
command pipeline functionality.")
    (license license:bsd-3)))

(define-public python-zipstream-new
  (package
    (name "python-zipstream-new")
    (version "1.1.8")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/arjan-s/python-zipstream")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14vhgg8mcjqi8cpzrw8qzbij2fr2a63l2a8fhil21k2r8vzv92cv"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/arjan-s/python-zipstream")
    (synopsis "Zipfile generator that takes input files as well as streams")
    (description "@code{zipstream.py} is a zip archive generator based on
@code{zipfile.py}.  It was created to generate a zip file generator for
streaming.  This is beneficial for when you want to provide a downloadable
archive of a large collection of regular files, which would be infeasible
to generate the archive prior to downloading or of a very large file that
you do not want to store entirely on disk or on memory.")
    ;; No copyright headers in the source.  The LICENSE file indicates GPL3.
    (license license:gpl3)))

(define-public python-sentry-sdk
  (package
    (name "python-sentry-sdk")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/getsentry/sentry-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "128bm136l5zprr3sqqb8j3d6k5i1fhz853mzvh3w8g0w1dw763mx"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest" "-k"
                       (string-append
                        ;; This test requires extra dependencies.
                        "not test_auto_enabling_integrations"
                        "_catches_import_error"
                        ;; Tests below run pip command.
                        " and not test_unhandled_exception"
                        " and not test_timeout_error"
                        " and not test_performance_no_error"
                        " and not test_performance_error"
                        " and not test_traces_sampler_gets_correct"
                        "_values_in_sampling_context"
                        " and not test_handled_exception"
                        ;; Tests below require network.
                        " and not test_crumb_capture"
                        " and not test_crumb_capture"
                        " and not test_crumb_capture_hint"
                        " and not test_httplib_misuse"
                        ;; Fails with IndexError.
                        " and not test_session_mode_defaults_to"
                        "_request_mode_in_wsgi_handler"))))))))
    (native-inputs
     (list python-django
           python-executing
           python-gevent
           python-jsonschema
           python-mock
           python-pyrsistent
           python-pytest
           python-pytest-cov
           python-pytest-django
           python-pytest-forked
           python-pytest-localserver
           python-werkzeug))
    (propagated-inputs
     (list python-certifi python-urllib3))
    (home-page "https://github.com/getsentry/sentry-python")
    (synopsis "Python SDK for Sentry")
    (description "This package provides a Python SDK for the Sentry
application monitoring and error tracking software.")
    (license license:bsd-2)))

(define-public python-pep8
  ;; This package has been renamed to ‘pycodestyle’ and is no longer updated.
  ;; Its last release (1.7.1) adds only a scary warning to this effect, breaking
  ;; some dependents' test suites, and nothing more.
  (package
    (name "python-pep8")
    (version "1.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pep8" version))
        (sha256
          (base32
           "002rkl4lsn6x2mxmf8ar00l0m8i3mzrc6pnzz77blyksmpsxa4x1"))
        (patches (search-patches "python-pep8-stdlib-tokenize-compat.patch"))))
    (build-system python-build-system)
    (home-page "https://pep8.readthedocs.org/")
    (synopsis "Python style guide checker")
    (description
     "This tools checks Python code against some of the style conventions in
PEP 8.")
    (license license:expat)))

(define-public python-pep8-naming
  (package
    (name "python-pep8-naming")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pep8-naming" version))
       (sha256
        (base32
         "1dc0b6xw1cxp01v9zsv4ryk49rfs1lngfpvzsixgp8b7z3ffcf4z"))))
    (build-system python-build-system)
    (propagated-inputs (list python-flake8))
    (home-page "https://github.com/PyCQA/pep8-naming")
    (synopsis "Check PEP-8 naming conventions")
    (description
     "This package provides the @code{pep8-naming} Python module, a
plugin for flake8 to check PEP-8 naming conventions.")
    (license license:expat)))

(define-public python-pep517
  (package
    (inherit python-pep517-bootstrap)
    (name "python-pep517")
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (delete-file "pytest.ini")
                      (delete-file "tests/test_meta.py")
                      (if tests?
                          (invoke "pytest") #t))))))
    (native-inputs (list python-mock python-pytest python-testpath))))

(define-public python-pyproject-metadata
  (package
    (name "python-pyproject-metadata")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/FFY00/python-pyproject-metadata")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "00zahgw9zjfqwf0218bj5k732aibnn68cq1p8f0wmbirb7fy5k31"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: PEP 517 manual build/install procedures copied from
          ;; python-isort.
          (replace 'build
            (lambda _
              ;; ZIP does not support timestamps before 1980.
              (setenv "SOURCE_DATE_EPOCH" "315532800")
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'check
            (lambda* (#:key tests? inputs outputs #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv"
                        ;; Two parameterized test_load tests are currently
                        ;; failing (see:
                        ;; https://github.com/FFY00/python-pep621/issues/14).
                        "-k" "not test_load"))))
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl)))))))
    (propagated-inputs (list python-packaging))
    (native-inputs (list python-pypa-build python-pytest python-tomli))
    (home-page "https://github.com/FFY00/python-pyproject-metadata")
    (synopsis "Dataclass for PEP 621 metadata")
    (description "This project does not implement the parsing of
@file{pyproject.toml} containing PEP 621 metadata.  Instead, given a Python
data structure representing PEP 621 metadata (already parsed), it will
validate this input and generate a PEP 643-compliant metadata
file (e.g. @file{PKG-INFO}).")
    (license license:expat)))

;; pep621 was renamed to pyproject-metadata.
(define-public python-pep621
  (deprecated-package "python-pep621" python-pyproject-metadata))

(define-public python-pyflakes
  (package
    (name "python-pyflakes")
    (version "2.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyflakes" version))
        (sha256
         (base32
          "0k5jn8jpxni264wxf6cc3xcd1qckc0pww30bsd77mwzdf8l5ra05"))))
    (build-system python-build-system)
    (home-page "https://github.com/PyCQA/pyflakes")
    (synopsis "Passive checker of Python programs")
    (description
      "Pyflakes statically checks Python source code for common errors.")
    (license license:expat)))

(define-public python-pyflakes-2.2
  (package
    (inherit python-pyflakes)
    (version "2.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyflakes" version))
              (sha256
               (base32
                "1j3zqbiwkyicvww499bblq33x0bjpzdrxajhaysr7sk7x5gdgcim"))
              (patches
               (search-patches "python-pyflakes-test-location.patch"))))))

(define-public python-mccabe
  (package
    (name "python-mccabe")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mccabe" version))
       (sha256
        (base32
         "07w3p1qm44hgxf3vvwz84kswpsx6s7kvaibzrsx5dzm0hli1i3fx"))))
    (build-system python-build-system)
    (native-inputs
     (list python-toml python-pytest-bootstrap python-pytest-runner))
    (home-page "https://github.com/PyCQA/mccabe")
    (synopsis "McCabe checker, plugin for flake8")
    (description "This package provides a Flake8 plug-in to compute the McCabe
cyclomatic complexity of Python source code.")
    (license license:expat)))

(define-public python-autoflake8
  (package
    (name "python-autoflake8")
    (version "0.4.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/fsouza/autoflake8")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0jx7bkslbhr24yvq60pl39faz2r6g93f1zm1gygswl0rzr5zmgnh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-aiofiles
           python-poetry-core
           python-pytest
           python-pytest-xdist))
    (propagated-inputs (list python-pyflakes))
    (home-page "https://github.com/fsouza/autoflake8")
    (synopsis "Automatically fix issues reported by flake8")
    (description "Tool to automatically fix some issues reported by
@command{flake8}.")
    (license license:expat)))

(define-public python-flake8
  (package
    (name "python-flake8")
    (version "4.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "flake8" version))
              (sha256
               (base32
                "03c7mnk34wfz7a0m5zq0273y94awz69fy5iww8alh4a4v96h6vl0"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-v")))))))
    (propagated-inputs
     (list python-entrypoints
           python-mccabe
           python-pycodestyle
           python-pyflakes))
    (native-inputs (list python-pytest))
    (home-page "https://gitlab.com/pycqa/flake8")
    (synopsis "The modular source code checker: pep8, pyflakes and co")
    (description
     "Flake8 is a wrapper around PyFlakes, pep8 and python-mccabe.")
    (license license:expat)))

(define-public python-flake8-3.8
  (package
    (inherit python-flake8)
    (version "3.8.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "flake8" version))
              (sha256
               (base32
                "0fvcrsbyzjpcli8ldbpsdbpmf238nkvwc1dy4hy82lf63rvfinma"))))
    (propagated-inputs
     (list python-pycodestyle-2.6 python-entrypoints python-pyflakes-2.2
           python-mccabe))))

(define-public python-flake8-blind-except
  (package
    (name "python-flake8-blind-except")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-blind-except" version))
       (sha256
        (base32 "05nxsxfzfhwsm8gys90228imm2qbnqnw5y8bfqyfngnbkmd5fnpj"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; no tests
    (native-inputs (list python-pycodestyle))
    (home-page "https://github.com/elijahandrews/flake8-blind-except")
    (synopsis "Check for blind @code{except:} statements")
    (description "This package provides a flake8 extension that checks for
blind @code{except:} statements.")
    (license license:expat)))

(define-public python-flake8-bugbear
  (package
    (name "python-flake8-bugbear")
    (version "20.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-bugbear" version))
       (sha256
        (base32
         "0qiihb242fygzyrfynq913ak7cdmx8mcac9c0zk3y5gv16qf80mx"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'disable-test
           (lambda _
             ;; This test fails on slow computers.
             (substitute* "tests/test_bugbear.py"
               (("def test_does_not_crash_on_any_valid_code")
                "def _test_does_not_crash_on_any_valid_code")))))))
    (native-inputs
     (list python-hypothesis python-hypothesmith))
    (propagated-inputs
     (list python-attrs python-flake8))
    (home-page "https://github.com/PyCQA/flake8-bugbear")
    (synopsis
      "Flake8 plugin for finding likely bugs and design problems in your program")
    (description
     "This package contains a plugin for Flake8 finding likely bugs and
design problems in your program.  It contains warnings that don't belong
in pyflakes and pycodestyle.")
    (license license:expat)))

(define-public python-flake8-continuation
  (package
    (name "python-flake8-continuation")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-continuation" version))
       (sha256
        (base32
         "0dzaw8jr7yhlabxhrblnrizxx17xa9ngjnbr1kidg5lapq6b9q1y"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-flake8 python-pycodestyle python-six))
    (home-page "https://github.com/planetlabs/flake8-continuation")
    (synopsis "Flake8 Line Continuation Plugin")
    (description "A Flake8 plugin that checks for the line continuation
style to be in the preferred method according to PEP-8, specifically:
@quotation
The preferred way of wrapping long lines is by using Python's implied
line continuation inside parentheses, brackets and braces.  Long lines
can be broken over multiple lines by wrapping expressions in parentheses.
These should be used in preference to using a backslash for line continuation.
@end quotation")
    (license license:asl2.0)))

(define-public python-flake8-debugger
  (package
    (name "python-flake8-debugger")
    (version "4.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-debugger" version))
       (sha256
        (base32 "0h1qlzbxxhjsw6kg3mcml9h8byy77m9a5z06z2dnvqs115b05c2j"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))              ; no tests in PyPI and no setup.py in GitHub
    (propagated-inputs
     (list python-flake8 python-pycodestyle))
    (home-page "https://github.com/jbkahn/flake8-debugger")
    (synopsis "@code{ipdb} and @code{pdb} statement checker plugin for flake8")
    (description "This package provides a Flake8 plugin that checks for
@code{ipdb} and @code{pdb} imports and set traces, as well as
@code{from IPython.terminal.embed}, @code{import InteractiveShellEmbed}
and @code{InteractiveShellEmbed()()}.")
    (license license:expat)))

(define-public python-flake8-implicit-str-concat
  (package
    (name "python-flake8-implicit-str-concat")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_implicit_str_concat" version))
       (sha256
        (base32 "1v0y29xlmbr2q12a4nnpm1dm9aw1mjiys1x8jif4z8c90d63cqm6"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f         ;no tests
       #:phases (modify-phases %standard-phases
                  (add-after 'unpack 'loosen-requirements
                    (lambda _
                      ;; Permit newer versions of attrs.  Remove for >0.2.
                      (substitute* "setup.py"
                        ((", <21") "")))))))
    (propagated-inputs
     (list python-attrs python-more-itertools))
    (home-page "https://github.com/keisheiled/flake8-implicit-str-concat")
    (synopsis "Flake8 plugin to encourage correct string literal concatenation")
    (description
     "This is a plugin for the Python code checking tool Flake8 to encourage
correct string literal concatenation.

It looks for style problems like implicitly concatenated string literals on
the same line (which can be introduced by the code formatting tool Black), or
unnecessary plus operators for explicit string literal concatenation.")
    (license license:expat)))

(define-public python-flake8-print
  (package
    (name "python-flake8-print")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-print" version))
       (sha256
        (base32 "05k5kkvyk6fdmvnacxfzypk74vbl3pmva13dqg1aljfwnxsc7yjs"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-flake8 python-pycodestyle python-six))
    (home-page "https://github.com/jbkahn/flake8-print")
    (synopsis "Print statement checker plugin for Flake8")
    (description
     "This plugin for Flake8 checks for @code{print} statements in Python
files.")
    (license license:expat)))

(define-public python-flake8-pyi
  (package
    (name "python-flake8-pyi")
    (version "20.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-pyi" version))
       (sha256
        (base32
         "0b27n2pmrxcc7nva4wp2i7mrag0fnq0firvhg1ljq593a45b5qyf"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-attrs python-flake8 python-pyflakes))
    (home-page "https://github.com/ambv/flake8-pyi")
    (synopsis
      "Flake8 plugin that provides specializations for type hinting stub files")
    (description
     "This package contains a plugin that provides specializations for
type hinting stub files, especially interesting for linting typeshed.  It
adds the @file{.pyi} extension to the default value of the @code{--filename}
command-line argument to Flake8.  This means stubs are linted by default with
this plugin enabled, without needing to explicitly list every file.  It
modifies PyFlakes runs for @file{.pyi} files to defer checking type annotation
expressions after the entire file has been read.  This enables support for
first-class forward references that stub files use.")
    (license license:expat)))

(define-public python-flake8-pie
  (package
    (name "python-flake8-pie")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-pie" version))
       (sha256
        (base32 "0kgipl5gljlp7aa7ykx15pswpzkd0d0qiznihb2z0d9a73181dyd"))))
    (build-system python-build-system)
    (home-page "https://github.com/sbdchd/flake8-pie")
    (synopsis "Flake8 extension that implements lints")
    (description
     "This package provides a flake8 extension that implements miscellaneous
lints.")
    (license license:bsd-2)))

(define-public python-flake8-quotes
  (package
    (name "python-flake8-quotes")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-quotes" version))
       (sha256
        (base32
         "0ph5s6lxgpzz4an0ax6s5xjqypqmngwr5b1i0h9pqhzghplic49z"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-flake8))
    (home-page "https://github.com/zheller/flake8-quotes/")
    (synopsis "Flake8 lint for quotes")
    (description "This package provides a Flake8 lint for quotes.")
    (license license:expat)))

(define-public python-flake8-todo
  (package
    (name "python-flake8-todo")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-todo" version))
       (sha256
        (base32
         "05arm0sch3r8248035kilmf01z0mxsahw6vpbbz0d343zy8m8k3f"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pycodestyle))
    (home-page "https://github.com/schlamar/flake8-todo")
    (synopsis "TODO notes checker, plugin for flake8")
    (description
     "This package provides the @code{flake8-todo} Python module, a
TODO notes checker plugin for flake8.")
    (license license:expat)))

(define-public python-flake8-isort
  (package
    (name "python-flake8-isort")
    (version "4.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "flake8-isort" version))
        (sha256
          (base32 "05r7z0j9rqgy0a9261bhisairrz6w8hy5hy5kf2mhvhfnx53056q"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv")))))))
    (propagated-inputs (list python-flake8 python-isort python-testfixtures))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/gforcada/flake8-isort")
    (synopsis "Flake8 plugin integrating isort")
    (description "This package provides a flake8 plugin that integrates isort,
extending flake8 so that it can warn about badly sorted Python import
directives.")
    (license license:gpl2+)))

(define-public python-autoflake
  (package
    (name "python-autoflake")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autoflake" version))
       (sha256
        (base32 "0nzr057dbmgprp4a52ymafdkdd5zp2wcqf42913xc7hhvvdbj338"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pyflakes))
    (home-page "https://github.com/myint/autoflake")
    (synopsis "Removes unused imports and unused variables")
    (description
     "@code{autoflake} removes unused imports and unused variables from Python
code as reported by @code{pyflakes}.

By default, it only removes unused imports for modules that are part of the
standard library.  Removal of unused variables is also disabled by default.
It also removes useless @code{pass} statements.")
    (license license:expat)))

(define-public python-mistune
  (package
    (name "python-mistune")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mistune" version))
       (sha256
        (base32
         "0vkmsh0x480rni51lhyvigfdf06b9247z868pk3bal1wnnfl58sr"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose python-cython))
    (home-page "https://github.com/lepture/mistune")
    (synopsis "Markdown parser in pure Python")
    (description "This package provides a fast markdown parser in pure
Python.")
    (license license:bsd-3)))

;; 2.0 is not released yet, but some packages have started using it.
(define-public python-mistune-next
  (package
    (inherit python-mistune)
    (name "python-mistune-next")
    (version "2.0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "mistune" version))
              (sha256
               (base32
                "024q9l6mgd37wa25w7dhskv1m3zsj5lf0w9cfyx7l9p2adhadq4y"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))))

(define-public python-markdown
  (package
    (name "python-markdown")
    (version "3.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Markdown" version))
       (sha256
        (base32
         "0jbs73nincha8fkfxx267sfxac6pl0ckszjbqbb8gk4dhs8v9d9i"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose python-pyyaml))
    (home-page "https://python-markdown.github.io/")
    (synopsis "Python implementation of Markdown")
    (description
     "This package provides a Python implementation of John Gruber's
Markdown.  The library features international input, various Markdown
extensions, and several HTML output formats.  A command line wrapper
markdown_py is also provided to convert Markdown files to HTML.")
    (license license:bsd-3)))

(define-public python-mdx-include
  (package
    (name "python-mdx-include")
    (version "1.4.1")
    (source (origin
              ;; Use git, as there are some test files missing from the PyPI
              ;; release, see https://github.com/neurobin/mdx_include/issues/9
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/neurobin/mdx_include")
                    ;; Releases are not tagged on github, see
                    ;; https://github.com/neurobin/mdx_include/issues/10
                    (commit "683e6be7a00a1ef4d673ad0294458fa61bc97286")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0qpzgln4ybd7pl0m9s19dv60aq9cvwrk7x3yz96kjhcywaa5w386"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'disable-test-requiring-network
           (lambda _
             (substitute* "mdx_include/test/test.py"
               (("(\\s+def )test_(cache|config|default)\\(" _ pre post)
                (string-append pre "__off__test_" post "("))))))))
    (propagated-inputs (list python-cyclic python-markdown python-rcslice))
    (home-page "https://github.com/neurobin/mdx_include")
    (synopsis "Python Markdown extension to include local or remote files")
    (description "Include extension for Python Markdown.  It lets you include
local or remote (downloadable) files into your markdown at arbitrary
positions.

This project is motivated by markdown-include and provides the same
functionalities with some extras.")
    (license license:bsd-3)))

(define-public python-ptyprocess
  (package
    (name "python-ptyprocess")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ptyprocess" version))
       (sha256
        (base32
         "0ra31k10v3629xq0kdn8lwmfbi97anmk48r03yvh7mks0kq96hg6"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "nosetests"))))))
    (home-page "https://github.com/pexpect/ptyprocess")
    (synopsis "Run a subprocess in a pseudo terminal")
    (description
     "This package provides a Python library used to launch a subprocess in a
pseudo terminal (pty), and interact with both the process and its pty.")
    (license license:isc)))

(define-public python-cram
  (package
    (name "python-cram")
    (version "0.7")
    (home-page "https://bitheap.org/cram/")
    (source (origin
              (method url-fetch)
              (uri (list (string-append home-page "cram-"
                                        version ".tar.gz")
                         (pypi-uri "cram" version)))
              (sha256
               (base32
                "0bvz6fwdi55rkrz3f50zsy35gvvwhlppki2yml5bj5ffy9d499vx"))))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-source
           (lambda _
             (substitute* (find-files "cram" ".*\\.py$")
               ;; Replace default shell path.
               (("/bin/sh") (which "sh")))
             (substitute* (find-files "tests" ".*\\.t$")
               (("md5") "md5sum")
               (("/bin/bash") (which "bash"))
               (("/bin/sh") (which "sh")))
             (substitute* "cram/_test.py"
               ;; This hack works around a bug triggered by substituting
               ;; the /bin/sh paths. "tests/usage.t" compares the output of
               ;; "cram -h", which breaks the output at 80 characters. This
               ;; causes the line showing the default shell to break into two
               ;; lines, but the test expects a single line...
               (("env\\['COLUMNS'\\] = '80'")
                "env['COLUMNS'] = '160'"))

             (substitute* "Makefile"
               ;; Recent versions of python-coverage have caused the test
               ;; coverage to decrease (as of version 0.7).  Allow that.
               (("--fail-under=100")
                "--fail-under=90"))

             #t))
         (replace 'check
           ;; The test phase uses the built library and executable.
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (setenv "PATH" (string-append (getenv "PATH") ":"
                                           (assoc-ref outputs "out") "/bin"))
             (invoke "make" "test"))))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage which))
    (synopsis "Simple testing framework for command line applications")
    (description
     "Cram is a functional testing framework for command line applications.
Cram tests look like snippets of interactive shell sessions.  Cram runs each
command and compares the command output in the test with the command’s actual
output.")
    (license license:gpl2+)))

(define-public python-crccheck
  (package
    (name "python-crccheck")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "crccheck" version))
       (sha256
        (base32 "15psg7wjfbpmmry54ffwg6pg63mnv7mkwmb0a7884axnr8qj55j5"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (home-page "https://sourceforge.net/projects/crccheck/")
    (synopsis "Calculation library for CRCs and checksums")
    (description "@code{crccheck} is a calculation library for CRCs and
checksums.  It implement more than a hundred checksum routines.")
    (license license:gpl3+)))

(define-public python-crashtest
  (package
    (name "python-crashtest")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "crashtest" version))
        (sha256
          (base32 "1p9p7mn8x2j9psc4jxab98897v4i9s4fliyfw8rp8v4bx1n7pjj2"))))
    (build-system python-build-system)
    (home-page "https://github.com/sdispater/crashtest")
    (synopsis "Manage Python errors with ease")
    (description
     "Python library that makes exceptions handling and inspection easier.")
    (license license:expat)))

(define-public python-stdlib-list
  (package
    (name "python-stdlib-list")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "stdlib-list" version))
              (sha256
               (base32
                "17vdn4q0sdlndc2fr9svapxx6366hnrhkn0fswp1xmr0jxqh7rd1"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; Tests require more dependencies.
    (native-inputs
     (list python-sphinx))
    (home-page "https://github.com/jackmaney/python-stdlib-list")
    (synopsis "Python Standard Libraries")
    (description "This package contains a list of Python Standard Libraries.")
    (license license:expat)))

(define-public python-stopit
  (package
    (name "python-stopit")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "stopit" version))
       (sha256
        (base32 "0vcrcvky249q4rbgmwf18mwmnypfk8jpn4h6knyjf86r7xc9rwzp"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ;there are none
    (home-page "https://pypi.python.org/pypi/stopit")
    (synopsis "Timeout control decorator and context managers")
    (description
     "Raise asynchronous exceptions in other threads, control the timeout of
blocks or callables with two context managers and two decorators.")
    (license license:expat)))

(define-public python-timeout-decorator
  (package
    (name "python-timeout-decorator")
    (version "0.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "timeout-decorator" version))
              (sha256
               (base32
                "1mxk2qyydhzncm93z08kvj5ssxq3fr2n7pkrrji28nqwvdc2ybva"))))
    (build-system python-build-system)
    (home-page "https://github.com/pnpnpn/timeout-decorator")
    (synopsis "Timeout decorator")
    (description "This package provides a decorator that raises an error
when an operation takes longer than expected.")
    (license license:expat)))

(define-public python-straight-plugin
  (package
    (name "python-straight-plugin")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "straight.plugin" version))
       (sha256
        (base32
         "069pjll4383p4kkgvcc40hgyvf79j2wdbpgwz77yigzxksh1gj62"))))
    (build-system python-build-system)
    (home-page "https://github.com/ironfroggy/straight.plugin")
    (synopsis "Simple namespaced plugin facility")
    (description "Straight Plugin provides a type of plugin you can create from
almost any existing Python modules, and an easy way for outside developers to
add functionality and customization to your projects with their own plugins.")
    (license license:expat)))

(define-public python-pysendfile
  (package
    (name "python-pysendfile")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pysendfile" version))
       (sha256
        (base32 "05qf0m32isflln1zjgxlpw0wf469lj86vdwwqyizp1h94x5l22ji"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (setenv "HOME" "/tmp")
                         (invoke "make" "test")))))))
    (home-page "https://github.com/giampaolo/pysendfile")
    (synopsis "Python interface to sendfile(2)")
    (description "The @{pysendfile} Python library provides an interface to
the @code{sendfile(2)} system call.")
    (license license:expat)))

(define-public python-pyftpdlib
  (package
    (name "python-pyftpdlib")
    (version "1.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyftpdlib" version))
       (sha256
        (base32 "0pnv2byzmzg84q5nmmhn1xafvfil85qa5y52bj455br93zc5b9px"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke
                 "pytest"
                 ;; Deselect failing tests.
                 "-k" (string-append
                       ;; Using Pytest instead of the Makefile causes the
                       ;; command line tests to fail on unknown Pytest
                       ;; arguments.
                       "not TestCommandLineParser "
                       ;; https://github.com/giampaolo/pyftpdlib/issues/478
                       "and not test_use_gmt_times "
                       ;; https://github.com/giampaolo/pyftpdlib/issues/550
                       "and not test_masquerade_address "
                       ;; https://github.com/giampaolo/pyftpdlib/issues/500
                       "and not test_rest_on_stor "
                       "and not test_stor_ascii"))))))))
    (native-inputs (list python-psutil python-pytest))
    (propagated-inputs (list python-pyopenssl python-pysendfile))
    (home-page "https://github.com/giampaolo/pyftpdlib/")
    (synopsis "Asynchronous and scalable Python FTP server library")
    (description "The Python FTP server library provides a high-level
interface to write efficient, scalable and asynchronous FTP servers with
Python.  It is the most complete @url{http://www.faqs.org/rfcs/rfc959.html,
RFC-959} FTP server implementation available for Python, and has the following
traits:
@itemize
@item
It is lightweight, fast and scalable.
@item
It uses the @code{sendfile(2)} system call for uploads.
@item
It uses @code{epoll}, @code{kqueue} and @code{select} to handle concurrency
asynchronously.
@item
It supports FTPS (@url{http://tools.ietf.org/html/rfc4217, RFC-4217}),
IPv6 (RFC-2428), Unicode file names (@url{http://tools.ietf.org/html/rfc2640,
RFC-2640}) and MLSD/MLST commands (RFC-3659).
@item
It has a flexible system of @samp{authorizers} able to manage both
@samp{virtual} and @samp{real} users.
@end itemize")
    (license license:expat)))

(define-public python-fs
  (package
    (name "python-fs")
    (version "2.4.16")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fs" version))
       (sha256
        (base32 "04ykd7q49qgv13hl2n71lzihs2c9099r50lmd85vgx0k2bawg5xf"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (setenv "HOME" "/tmp")
                         (invoke "pytest" "-m" "not slow")))))))
    (propagated-inputs
     (list python-appdirs python-pytz python-six))
    (native-inputs
     (list python-mock python-parameterized python-pyftpdlib python-pytest))
    (home-page "https://github.com/PyFilesystem/pyfilesystem2/")
    (synopsis "File system abstraction layer for Python")
    (description "PyFilesystem's @code{FS} object is a file system abstraction
sharing similarities with Python's own @code{file} object for single files.
It allows opening all the files under a given directory recursively, as a
single @code{FS} object.  This enables, for example, counting the combined
number of lines in the contained files easily.")
    (license license:expat)))

;;; Tests are left out in the main package to avoid cycles.
(define-public python-fonttools
  (hidden-package
   (package
     (name "python-fonttools")
     (version "4.28.5")
     (source (origin
               (method url-fetch)
               (uri (pypi-uri "fonttools" version ".zip"))
               (sha256
                (base32
                 "1jhl5n3rfqq7fznvsh6r80n7ylap1a7ppq1040y8cflhyz80ap2l"))))
     (build-system python-build-system)
     (native-inputs
      (list unzip))
     (arguments '(#:tests? #f))
     (home-page "https://github.com/fonttools/fonttools")
     (synopsis "Tools to manipulate font files")
     (description
      "FontTools/TTX is a library to manipulate font files from Python.  It
supports reading and writing of TrueType/OpenType fonts, reading and writing
of AFM files, reading (and partially writing) of PS Type 1 fonts.  The package
also contains a tool called “TTX” which converts TrueType/OpenType fonts to and
from an XML-based format.")
     (license license:expat))))

;;; Rename 'python-fonttools' in next cycle, renaming the current
;;; 'python-fonttools' to 'python-fonttools-minimal'.
(define-public python-fonttools-full
  (package/inherit python-fonttools
    (arguments
     (substitute-keyword-arguments (package-arguments python-fonttools)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:phases phases '%standard-phases)
        `(modify-phases ,phases
           (replace 'check
             (lambda* (#:key tests? #:allow-other-keys)
               (when tests?
                 (invoke "pytest" "-vv"
                         "-k"
                         ;; XXX: These tests need .trm files that are
                         ;; not shipped with the PyPI release.
                         (format #f "not ~a"
                                 (string-join
                                  '("test_read_fontdimens_mathsy"
                                    "test_read_fontdimens_mathex"
                                    "test_read_fontdimens_vanilla"
                                    "test_read_boundary_char"
                                    "fontTools.tfmLib")
                                  " and not "))))))))))
    (native-inputs
     (modify-inputs (package-native-inputs python-fonttools)
       (append python-pytest)))
    (propagated-inputs
     (list python-brotli
           python-fs
           python-lxml
           python-lz4
           python-scipy
           python-unicodedata2
           python-zopfli))
    (properties (alist-delete 'hidden? (package-properties python-fonttools)))))

(define-public python-fonttools-next
  (package
    (inherit python-fonttools-full)
    (version "4.37.1")
    (source (origin
              (inherit (package-source python-fonttools-full))
              (method url-fetch)
              (uri (pypi-uri "fonttools" version ".zip"))
              (sha256
               (base32
                "1ryc1wca2v92wn24baryj5fr32lspl8rbsig32fnkxp1islf21j6"))))))

(define-public python-ly
  (package
    (name "python-ly")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri name version))
       (sha256
        (base32
         "0x98dv7p8mg26p4816yy8hz4f34zf6hpnnfmr56msgh9jnsm2qfl"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Some tests need network access.
     '(#:tests? #f))
    (synopsis "Tool and library for manipulating LilyPond files")
    (description "This package provides a Python library to parse, manipulate
or create documents in LilyPond format.  A command line program ly is also
provided that can be used to do various manipulations with LilyPond files.")
    (home-page "https://pypi.org/project/python-ly/")
    (license license:gpl2+)))

(define-public python-appdirs
  (package
    (name "python-appdirs")
    (version "1.4.3")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "appdirs" version))
        (sha256
          (base32
            "14id6wxi12lgyw0mg3bcfnf888ad07jz9yj46gfzhn186z8rcn4y"))))
    (build-system python-build-system)
    (home-page "https://github.com/ActiveState/appdirs")
    (synopsis
      "Determine platform-specific dirs, e.g. a \"user data dir\"")
    (description
      "This module provides a portable way of finding out where user data
should be stored on various operating systems.")
    (license license:expat)))

(define-public python-gorilla
  (package
    (name "python-gorilla")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gorilla" version))
              (sha256
               (base32
                "0b40blcp6fih4nvqbilra4qw1dfccv1ahjmr41ac4d9rjadqkcpy"))))
    (build-system python-build-system)
    (home-page "https://github.com/christophercrouzet/gorilla")
    (synopsis "Convenient monkey patching with Python")
    (description
     "Gorilla is a Python library that provides a convenient approach to
monkey patching.  Monkey patching is the process of modifying module and
class attributes at runtime with the purpose of replacing or extending
third-party code.")
    (license license:expat)))

(define-public python-llfuse
  (package
    (name "python-llfuse")
    (version "1.4.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "llfuse" version))
              (sha256
               (base32
                "1jaf790rsxvz3hs9fbr3hrnmg0xzl6a2bqfa10bbbsjsdbcpk762"))))
    (build-system python-build-system)
    (inputs
     (list fuse attr))
    (native-inputs
     (list pkg-config python-pytest))
    (synopsis "Python bindings for FUSE")
    (description
     "Python-LLFUSE is a set of Python bindings for the low level FUSE API.")
    (home-page "https://bitbucket.org/nikratio/python-llfuse/")
    (license license:lgpl2.0+)))

(define-public python-msgpack
  (package
    (name "python-msgpack")
    (version "1.0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "msgpack" version))
              (sha256
               (base32
                "0pqzy1zclyhd42gfibhkcqymbspy5a6v421g87mh40h3iz0nkn7m"))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build python-build-system)
                  (ice-9 ftw)
                  (srfi srfi-1)
                  (srfi srfi-26))
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-v" "test"))))))
    (native-inputs
     (list python-pytest))
    (synopsis "MessagePack (de)serializer")
    (description "MessagePack is a fast, compact binary serialization format,
suitable for similar data to JSON.  This package provides CPython bindings for
reading and writing MessagePack data.")
    (home-page "https://pypi.org/project/msgpack/")
    (license license:asl2.0)))

(define-public python-msgpack-1.0.2
  (package
    (inherit python-msgpack)
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "msgpack" version))
              (sha256
               (base32
                "1109s2yynrahwi64ikax68hx0mbclz8p35afmpphw5dwynb49q7s"))))))

;; This msgpack library's name changed from "python-msgpack" to "msgpack" with
;; release 0.5. Some packages like borg still call it by the old name for now.
;; <https://bugs.gnu.org/30662>
(define-public python-msgpack-transitional
  (package
    (inherit python-msgpack)
    (name "python-msgpack-transitional")
    (version "0.5.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "msgpack" version))
              (sha256
               (base32
                "1hz2dba1nvvn52afg34liijsm7kn65cmn06dl0xbwld6bb4cis0f"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-msgpack)
       ((#:phases phases)
        `(modify-phases ,phases
           (add-after 'unpack 'configure-transitional
             (lambda _
               ;; Keep using the old name.
               (substitute* "setup.py"
                 (("TRANSITIONAL = False")
                   "TRANSITIONAL = 1"))
               ;; This old version is not compatible with Python 3.9
               (substitute* '("test/test_buffer.py" "test/test_extension.py")
                 ((".tostring\\(") ".tobytes("))
               (substitute* '("test/test_buffer.py" "test/test_extension.py")
                 ((".fromstring\\(") ".frombytes("))
               #t))))))))

(define-public python-netaddr
  (package
    (name "python-netaddr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "netaddr" version))
       (sha256
         (base32
          "0hx2npi0wnhwlcybilgwlddw6qffx1mb7a3sj4p9s7bvl33mgk6n"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ;; No tests.
    (home-page "https://github.com/drkjam/netaddr/")
    (synopsis "Pythonic manipulation of  network addresses")
    (description
      "A Python library for representing and manipulating IPv4, IPv6, CIDR, EUI
and MAC network addresses.")
    (license license:bsd-3)))

(define-public python-openstep-plist
 (package
  (name "python-openstep-plist")
  (version "0.3.0")
  (home-page "https://github.com/fonttools/openstep-plist")
  (source (origin
            (method git-fetch)
            (uri (git-reference
                  (url home-page)
                  (commit (string-append "v" version))))
            (file-name (git-file-name name version))
            (sha256
             (base32
              "1rxjgzh0p069ncsr2986rn32vhdqyq35irbqg2559jh18456mkca"))))
  (build-system python-build-system)
  (arguments
   (list #:phases
         #~(modify-phases %standard-phases
             (add-after 'unpack 'pretend-version
               (lambda _
                 (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                         #$(package-version this-package))))
             (replace 'check
               (lambda* (#:key tests? #:allow-other-keys)
                 (when tests?
                   (invoke "pytest" "-vv")))))))
  (native-inputs
   (list python-cython python-pytest python-setuptools-scm))
  (synopsis "OpenStep plist parser and writer")
  (description
   "This package provides a parser for the \"old style\" OpenStep property
list format (also known as ASCII plist), written in Cython.")
  (license license:expat)))

(define-public python-wrapt
  (package
    (name "python-wrapt")
    (version "1.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wrapt" version))
       (sha256
        (base32
         "1q81762dgsgrd12f8qc39zk8s5wll3m5xc32jdmlf6cls4gh4njn"))))
    (build-system python-build-system)
    (arguments
     ;; Tests are not included in the tarball, they are only available in the
     ;; git repository.
     `(#:tests? #f))
    (home-page "https://github.com/GrahamDumpleton/wrapt")
    (synopsis "Module for decorators, wrappers and monkey patching")
    (description
     "The aim of the wrapt module is to provide a transparent object proxy for
  Python, which can be used as the basis for the construction of function
  wrappers and decorator functions.")
    (license license:bsd-2)))

(define-public python-commentjson
  (package
    (name "python-commentjson")
    (version "0.9.0")
    (source (origin
              ;; The PyPI release is missing some test files.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/vaidik/commentjson")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "01iscgrc6bkyrxbzmf46csbf9c0n7g6dygdmxs3fq8fkzrrciybl"))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((guix build python-build-system)
                  (guix build utils)
                  (ice-9 ftw)
                  (ice-9 textual-ports))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "setup.py"
               (("lark-parser>=0.7.1,<0.8.0")
                "lark-parser>=0.7.1"))))
         (add-after 'unpack 'delete-unspported-tests
           ;; Some tests rely on the 'test' module of Python itself,
           ;; which is not available with the Python package in Guix;
           ;; remove them.
           (lambda _
             ;; XXX: Copied from (guix build dub-build-system).
             (define (grep string file-name)
               (string-contains (call-with-input-file file-name get-string-all)
                                string))

             (with-directory-excursion "commentjson/tests/test_json"
               (let* ((dot? (lambda (x) (member x '("." ".."))))
                      (test-files (scandir "." (negate dot?))))
                 (for-each delete-file
                           (filter (lambda (f) (grep "from test." f))
                                   test-files)))))))))
    (propagated-inputs
     (list python-lark-parser))
    (native-inputs
     (list python-six))
    (home-page "https://github.com/vaidik/commentjson")
    (synopsis "Python library for adding comments to JSON files")
    (description "Comment JSON is a Python package that helps you create JSON
files with Python and JavaScript style inline comments.  Its API is very
similar to the Python standard library's @code{json} module.")
    (license license:expat)))

(define-public python-resolvelib
  (package
    (name "python-resolvelib")
    (version "0.7.1")
    (source
     (origin
       ;; Tests are missing from the PyPI release.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sarugaku/resolvelib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fqz75riagizihvf4j7wc3zjw6kmg1dd8sf49aszyml105kb33n8"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest")))))))
    (native-inputs
     (list python-commentjson python-packaging python-pytest))
    (home-page "https://github.com/sarugaku/resolvelib")
    (synopsis "Abstract dependencies resolver")
    (description "The ResolveLib library provides a @code{Resolver} class that
includes dependency resolution logic.")
    (license license:isc)))

;;; This older version is required by ansible-core.
(define-public python-resolvelib-0.5
  (package/inherit python-resolvelib
    (name "python-resolvelib")
    (version "0.5.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sarugaku/resolvelib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0697y330sqhiclk25v151qxg7aixzpj434lbg5qib0qlna5zg9la"))))))

(define-public python-commonmark
  (package
    (name "python-commonmark")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "commonmark" version))
       (sha256
        (base32 "0q7d39lm8kcingpmykk5r959hrwwj6v2icyw3mihczxyb749sbs5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "python" "setup.py" "test"))))))
    (home-page "https://github.com/readthedocs/commonmark.py")
    (synopsis "Python parser for the CommonMark Markdown spec")
    (description
     "This module is a pure Python port of jgm's @code{commonmark.js}, a
Markdown parser and renderer for the CommonMark specification, using only
native modules.")
    (license license:bsd-3)))

(define-public python-xlrd
  (package
    (name "python-xlrd")
    (version "2.0.1")
    (source (origin
              ;; The tests are not included in the PyPI archive.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/python-excel/xlrd")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "170asszffvf6rh5w169ic4h5kxgjkmdl3060vw737d4g1qfifvzz"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "http://www.python-excel.org/")
    (synopsis "Library for extracting data from Excel files")
    (description "This package provides a library to extract data from
spreadsheets using Microsoft Excel proprietary file formats @samp{.xls} and
@samp{.xlsx} (versions 2.0 onwards).  It has support for Excel dates and is
Unicode-aware.  It is not intended as an end-user tool.")
    (license license:bsd-3)))

;;; Note: this package is unmaintained since 2018 (archived on GitHub).
(define-public python-xlwt
  (package
    (name "python-xlwt")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xlwt" version))
       (sha256
        (base32 "123c2pdamshkq75wwvck8fq0cjq1843xd3x9qaiz2a4vg9qi56f5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (setenv "GUIX_PYTHONPATH"
                       (string-append (getcwd) "/build/lib:"
                                      (getenv "GUIX_PYTHONPATH")))
               (invoke "nosetests" "-v")))))))
    (native-inputs
     `(("nose" ,python-nose)))
    (home-page "http://www.python-excel.org/")
    (synopsis "Library for creating spreadsheet Excel files")
    (description "@code{xlwt} is a library for writing data and formatting
information to older Excel files (i.e. .xls).  The package itself is pure
Python with no dependencies on modules or packages outside the standard Python
distribution.  It is not intended as an end-user tool.")
    (license license:bsd-3)))

(define-public python-immutables
  (package
    (name "python-immutables")
    (version "0.18")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "immutables" version))
       (sha256
        (base32 "1x4cinh0xbl6p6p2yfm2s07mxxy3lf0zzai9gqpydk4482bwfdjk"))))
    (build-system python-build-system)
    (native-inputs (list python-mypy python-pytest))
    (home-page "https://github.com/MagicStack/immutables")
    (synopsis "High-performance immutable mapping type for Python")
    (description
     "An immutable mapping type for Python.  The underlying datastructure is a
Hash Array Mapped Trie (HAMT) used in Clojure, Scala, Haskell, and other
functional languages.")
    (license license:asl2.0)))

(define-public python-prettytable
  (package
    (name "python-prettytable")
    (version "3.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "prettytable" version))
       (sha256
        (base32
         "1c599w31i2ndzbkn85xwsgv9sd2j16r56dl922w4jh3rs97vb3hi"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest
           python-pytest-lazy-fixture
           python-setuptools-scm))
    (propagated-inputs (list python-wcwidth))
    (home-page "https://github.com/jazzband/prettytable")
    (synopsis "Display tabular data in an ASCII table format")
    (description
      "A library designed to represent tabular data in visually appealing ASCII
tables.  PrettyTable allows for selection of which columns are to be printed,
independent alignment of columns (left or right justified or centred) and
printing of sub-tables by specifying a row range.")
    (license license:bsd-3)))

(define-public python-rtf-tokenize
  (package
    (name "python-rtf-tokenize")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rtf_tokenize" version))
              (sha256
               (base32
                "026njb9iwznycda83bln3gfivcnzdz6vy8y86xvbsy84s28g6gaw"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/benoit-pierre/rtf_tokenize")
    (synopsis "Simple RTF tokenizer")
    (description "This package is a simple RTF tokenizer.")
    (license license:gpl2+)))

(define-public python-curio
  (package
    (name "python-curio")
    (version "1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "curio" version))
       (sha256
        (base32 "045wwg16qadsalhicbv21p14sj8i4w0l57639j7dmdqbb4p2225g"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv" "-k"
                       (string-append
                        ;; Tries to open an outgoing connection.
                        "not test_ssl_outgoing "
                        ;; This test fails since Python 3.9.9 (see:
                        ;; https://github.com/dabeaz/curio/issues/347).
                        "and not test_timeout"))))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/dabeaz/curio")
    (synopsis "Coroutine-based library for concurrent Python")
    (description
     "Curio is a coroutine-based library for concurrent Python systems
programming.  It provides standard programming abstractions such as as
tasks, sockets, files, locks, and queues.")
    (license license:bsd-3)))

(define-public python-tables
  (package
    (name "python-tables")
    (version "3.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tables" version))
       (sha256
        (base32
         "0j8vnxh2m5n0cyk9z3ndcj5n1zj5rdxgc1gb78bqlyn2lyw75aa9"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Remove pre-compiled .pyc files from source.
           (for-each delete-file-recursively
                     (find-files "." "__pycache__" #:directories? #t))
           (for-each delete-file (find-files "." "\\.pyc$"))
           #t))))
    (build-system python-build-system)
    (arguments
     `(;; FIXME: python-build-system does not pass configure-flags to "build"
       ;; or "check", so we must override the build and check phases.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'use-gcc
           (lambda _
             (substitute* "setup.py"
               (("^( +)compiler = new_compiler\\(\\)" line indent)
                (string-append line
                               "\n"
                               indent
                               "compiler.set_executables(compiler='gcc',"
                               "compiler_so='gcc',"
                               "linker_exe='gcc',"
                               "linker_so='gcc -shared')")))
             #t))
         (add-after 'unpack 'disable-tuning
           (lambda _
             (substitute* "setup.py"
               (("cpu_flags = .*")
                "cpu_flags = ['sse2']\n"))
             #t))
         (replace 'build
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "python" "setup.py" "build"
                     (string-append "--hdf5="
                                    (assoc-ref inputs "hdf5")))))
         (replace 'check
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "python" "setup.py" "check"
                     (string-append "--hdf5="
                                    (assoc-ref inputs "hdf5"))))))))
    (propagated-inputs
     (list python-numexpr python-numpy))
    (native-inputs
     (list python-cython pkg-config))
    (inputs
     (list hdf5-1.10 bzip2 zlib))
    (home-page "https://www.pytables.org/")
    (synopsis "Hierarchical datasets for Python")
    (description "PyTables is a package for managing hierarchical datasets and
designed to efficiently cope with extremely large amounts of data.")
    (license license:bsd-3)))

(define-public python-sniffio
  (package
    (name "python-sniffio")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sniffio" version))
       (sha256
        (base32 "1pnkvi6wvn4qd37y69n1ls6n8l63gfmn3pvb1jb50gqxxkn6wrn4"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-curio python-pytest python-pytest-cov))
    (home-page "https://github.com/python-trio/sniffio")
    (synopsis "Detect which async library a program is running under")
    (description "This package detects which async library a program is
running under.  It supports multiple async I/O packages, like Trio, and
asyncio.")
    ;; Either license applies.
    (license (list license:expat license:asl2.0))))

(define-public python-pytest-black
  (package
    (name "python-pytest-black")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pytest-black" version))
       (sha256
        (base32
         "19bmbcnaq02md8nnj6pywri3vps8sxnhysbfy386qkbn9w09ncqx"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pytest python-black python-toml))
    (native-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/shopkeep/pytest-black")
    (synopsis "Pytest plugin to enable format checking with black")
    (description
     "This package provides a pytest plugin to enable format checking with the
Python code formatter \"black\".")
    (license license:expat)))

(define-public python-geojson
  (package
    (name "python-geojson")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "geojson" version))
       (sha256
        (base32 "12k5bzqskvq3gqzkryarhdjl0df47y5k9cf8r3clasi2wjnbfjvf"))))
    (build-system python-build-system)
    (arguments
     ;; https://github.com/jazzband/geojson/issues/175
     `(#:tests? #f))
    (home-page "https://github.com/jazzband/geojson")
    (synopsis "Python bindings and utilities for GeoJSON")
    (description
     "This package provides Python bindings and utilities for
@uref{http://geojson.org/, GeoJSON}, a format for encoding geographic data
structures.")
    (license license:bsd-3)))

(define-public wfetch
  (let ((commit "e1cfa37814aebc9eb56ce994ebe877b6a6f9a715")
        (revision "1"))
    (package
      (name "wfetch")
      (version (git-version "0.1-pre" revision commit))
      (home-page "https://github.com/Gcat101/Wfetch")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference (url home-page)
                             (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1dmr85plx8zr6s14ym3r32g6crwxghkval5a24ah90ijx4dbn5q5"))))
      (build-system python-build-system)
      (arguments
       `(#:use-setuptools? #f           ; no setup.py
         #:tests? #f                    ; no test suite
         #:phases
         (modify-phases %standard-phases
           (delete 'build)
           (replace 'install
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out (assoc-ref outputs "out"))
                      (bin (string-append out "/bin"))
                      (share (string-append out "/share")))
                 (mkdir-p share)
                 (substitute* "wfetch/wfetch.py"
                   (("os.sep, 'opt', 'wfetch'") (string-append "'" share "'")))
                 (install-file "wfetch/wfetch.py" bin)
                 (copy-recursively "wfetch/icons" share)))))))
      (inputs (list python-pyowm python-fire python-termcolor python-requests))
      (synopsis "Command-line tool to display weather info")
      (description
       "This package provides a tool similar to Neofetch/pfetch, but for
weather: it can display the weather condition, temperature, humidity, etc.

To use it, you must first run:

@example
export WEATHER_CLI_API=@var{your OpenWeatherMap API key}
@end example\n")
      (license license:gpl3+))))

(define-public python-get-version
  (package
    (name "python-get-version")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "get_version" version))
       (sha256
        (base32
         "1g15jyx33vkxavv9hwv275cs4g9bp2i1y942raw3fxamq8kbaml1"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pygments
           python-pytest
           python-pytest-black
           python-pytest-cov
           python-setuptools
           python-testpath))
    (home-page "https://github.com/flying-sheep/get_version")
    (synopsis "Version helper in the spirit of versioneer")
    (description
     "This package provides a version helper that lets you automatically use
the latest @code{vX.X.X} Git tag as the version in your Python package.  It
also supports getting the version from Python source distributions or, once
your package is installed, via @code{pkg_resources} (part of
@code{setuptools}).")
    (license license:gpl3+)))

(define-public python-filetype
  (package
    (name "python-filetype")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filetype" version))
       (sha256
        (base32 "05mkinkcn36v1cnb5hzay3zxmv7jmmflckxxp08rgzbkkf3i9pvp"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest" "-k"
                       (string-append
                        ;; Both tests fail with FileNotFoundError.
                        "not test_infer_zip_from_disk"
                        " and not test_infer_tar_from_disk"))))))))
    (native-inputs
     (list python-pytest python-pytest-benchmark))
    (home-page "https://github.com/h2non/filetype.py")
    (synopsis "Infer file type and MIME type of any file/buffer")
    (description "@code{filetype} is a small and dependency free Python
package to infer file type and MIME type checking the magic numbers
signature of a file or buffer.")
    (license license:expat)))

(define-public python-cachelib
  (package
    (name "python-cachelib")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachelib" version))
       (sha256
        (base32 "0p4chkvbvffcllsny5rpzmsq2vyr24ql3kzif4ha0fxp3fp7vqk8"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest")))))))
    (native-inputs
     (list python-pytest python-pytest-xprocess))
    (home-page "https://github.com/pallets/cachelib")
    (synopsis "Collection of cache libraries")
    (description "Cachelib is a library extracted from @code{werkzeug} which
provides a collection of cache libraries in the same API interface.")
    (license license:bsd-3)))

(define-public python-pylru
  (package
    (name "python-pylru")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pylru" version))
       (sha256
        (base32 "15yj46307sw703vjfkgnr04dqvaicmfcj0hc6yrciildp55r6bs9"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "test.py")))))))
    (home-page "https://github.com/jlhutch/pylru")
    (synopsis "Least recently used (LRU) cache implementation")
    (description
     "Pylru implements a true LRU cache along with several support classes.
Pylru provides a cache class with a simple dict interface.  It also provides
classes to wrap any object that has a dict interface with a cache.  Both
write-through and write-back semantics are supported.  Pylru also provides
classes to wrap functions in a similar way, including a function decorator.")
    (license license:gpl2+)))

(define-public python-legacy-api-wrap
  (package
    (name "python-legacy-api-wrap")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "legacy-api-wrap" version))
       (sha256
        (base32
         "06qhp0g543dy98vpa41hwdalvdbsjfc3ldk474yr9sd75mhl8jh3"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-get-version python-pytest python-pytest-black
           python-pytest-cov python-setuptools))
    (home-page "https://github.com/flying-sheep/legacy-api-wrap")
    (synopsis "Legacy API wrapper")
    (description "This module defines a decorator to wrap legacy APIs.  The
primary use case is APIs defined before keyword-only parameters existed.")
    (license license:gpl3+)))

(define-public python-langdetect
  (package
    (name "python-langdetect")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "langdetect" version))
       (sha256
        (base32 "1805svvb7xjm4sf1j7b6nc3409x37pd1xmabfwwjf1ldkzwgxhfb"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/Mimino666/langdetect")
    (synopsis "Language detection library")
    (description
     "This library is a port of Nakatani Shuyo's language-detection library
(version from 03/03/2014) to Python.")
    (license license:expat)))

(define-public python-pyasn1
  (package
    (name "python-pyasn1")
    (version "0.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyasn1" version))
       (sha256
        (base32
         "1fnhbi3rmk47l9851gbik0flfr64vs5j0hbqx24cafjap6gprxxf"))))
    (build-system python-build-system)
    (home-page "http://pyasn1.sourceforge.net/")
    (synopsis "ASN.1 types and codecs")
    (description
     "This is an implementation of ASN.1 types and codecs in Python.  It is
suitable for a wide range of protocols based on the ASN.1 specification.")
    (license license:bsd-2)))

(define-public python-pyasn1-modules
  (package
    (name "python-pyasn1-modules")
    (version "0.2.8")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyasn1-modules" version))
        (sha256
         (base32
          "0pp6dcagd8c2c9qx3lahc1rdwlnmm0y0siqr5icjq2r32b3q8pwh"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pyasn1))
    (home-page "https://sourceforge.net/projects/pyasn1/")
    (synopsis "ASN.1 codec implementations")
    (description
     "Pyasn1-modules is a collection of Python modules providing ASN.1 types and
implementations of ASN.1-based codecs and protocols.")
    (license license:bsd-3)))

(define-public python-ipaddress
  (package
    (name "python-ipaddress")
    (version "1.0.23")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ipaddress" version))
              (sha256
               (base32
                "1qp743h30s04m3cg3yk3fycad930jv17q7dsslj4mfw0jlvf1y5p"))))
    (build-system python-build-system)
    (home-page "https://github.com/phihag/ipaddress")
    (synopsis "IP address manipulation library")
    (description
      "This package provides a fast, lightweight IPv4/IPv6 manipulation library
 in Python.  This library is used to create, poke at, and manipulate IPv4 and
 IPv6 addresses and networks.")
    (license license:psfl)))

(define-public python-asn1tools
  (package
    (name "python-asn1tools")
    (version "0.158.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asn1tools" version))
       (sha256
        (base32 "1k88a1azmyvp2ab6qcf2i40dig5abhyn7cmlyhmwwh8kr3syvma0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-bitstruct python-diskcache python-prompt-toolkit
           python-pyparsing))
    (home-page "https://github.com/eerimoq/asn1tools")
    (synopsis  "ASN.1 parsing, encoding and decoding")
    (description "This package provides ASN.1 parsing, encoding and decoding
for Python, including constraints checking.  It supports several
codecs (e.g. BER, PER, UPER, XER) as well as limited C source code generating
for OER and UPER.")
    (license license:expat)))

(define-public python-idna
  (package
    (name "python-idna")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "idna" version))
       (sha256
        (base32
         "0v8f6qjfi5i7qc5icsbv2pi24qy6k6m8wjqjvdf2sxjvlpq3yr4x"))))
    (build-system python-build-system)
    (home-page "https://github.com/kjd/idna")
    (synopsis "Internationalized domain names in applications")
    (description
     "This is a library to support the Internationalised Domain Names in
Applications (IDNA) protocol as specified in RFC 5891.  This version of the
protocol is often referred to as “IDNA2008” and can produce different results
from the earlier standard from 2003.  The library is also intended to act as a
suitable drop-in replacement for the “encodings.idna” module that comes with
the Python standard library but currently only supports the older 2003
specification.")
    (license license:bsd-4)))

(define-public python-libsass
  (package
    (name "python-libsass")
    (version "0.20.1")
    (source
     (origin
       ;; PyPI tarball is missing some test files.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sass/libsass-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r0kgl7i6nnhgjl44sjw57k08gh2qr7l8slqih550dyxbf1akbxh"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; Use Guix package of libsass instead of compiling from a checkout.
         (add-before 'build 'set-libsass
           (lambda _ (setenv "SYSTEM_SASS" "indeed")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "sasstests.py"))))
         (add-after 'install 'delete-test
           (lambda* (#:key inputs outputs #:allow-other-keys)
             ;; Delete sasstests.py because it attempts to open a file
             ;; that is not installed when loaded, which breaks the sanity
             ;; check.
             (delete-file (string-append
                           (assoc-ref outputs "out")
                           "/lib/python"
                           (python-version
                            (dirname (dirname
                                      (search-input-file inputs "bin/python"))))
                           "/site-packages/sasstests.py")))))))
    (native-inputs
     (list python-pytest python-werkzeug))
    (inputs
     (list libsass))
    (propagated-inputs
     (list python-six))
    (home-page "https://sass.github.io/libsass-python/")
    (synopsis "Straightforward binding of libsass for Python")
    (description
     "This package provides a simple Python extension module @code{sass} which
is binding LibSass.")
    (license license:expat)))

(define-public python-idna-ssl
  (package
    (name "python-idna-ssl")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "idna-ssl" version))
       (sha256
        (base32
         "0ydrc8hpg9mdr5hqq1lqfsfbn6sjq69slwpfrnlrm3k0phqg14qj"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))          ;circular dependency with python-aiohttp
    (propagated-inputs (list python-idna))
    (home-page "https://github.com/aio-libs/idna-ssl")
    (synopsis "Patch @code{ssl.match_hostname} for Unicode(idna) domains support")
    (description "Patch @code{ssl.match_hostname} for Unicode(idna)
domains support.")
    (license license:expat)))

;;; Variant used to break a cycle with python-pip-run-bootstrap.
(define-public python-path-bootstrap
  (hidden-package
   (package
     (name "python-path-bootstrap")
     (version "16.4.0")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "path" version))
        (sha256
         (base32 "0lig13gxnfv98v790db1smvsbd3mnj7y8rwyiwhfi6xiqibygwms"))))
     (build-system pyproject-build-system)
     (arguments
      (list #:tests? #f))
     (native-inputs (list python-setuptools-scm))
     (home-page "https://github.com/jaraco/path")
     (synopsis "Object-oriented file system path manipulation library")
     (description "@code{path} (formerly @code{path.py}) implements path
objects as first-class entities, allowing common operations on files to be
invoked on those path objects directly.")
     (license license:expat))))

(define-public python-path
  (package/inherit python-path-bootstrap
    (name "python-path")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-path-bootstrap)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:test-flags flags #~'())
        #~(append (list "-k"
                        (string-append
                         ;; Do not test the myproject.toml build as it tries
                         ;; to pull dependencies from the Internet.
                         "not project "
                         ;; This tests assumes a root user exists.
                         "and not test_get_owner"))
                  #$flags))))
    (native-inputs
     (modify-inputs (package-native-inputs python-path-bootstrap)
       (append python-appdirs
               python-packaging
               python-pygments
               python-pytest
               python-pytest-black
               python-pytest-checkdocs
               python-pytest-cov
               python-pytest-enabler
               python-pytest-flake8
               python-pytest-mypy)))
    (properties (alist-delete 'hidden?
                              (package-properties
                               python-path-bootstrap)))))

(define-public python-pathpy
  (deprecated-package "python-pathpy" python-path))

(define-public python-pretend
  (package
    (name "python-pretend")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pretend" version))
       (sha256
        (base32
         "040vm94lcbscg5p81g1icmwwwa2jm7wrd1ybmxnv1sz8rl8bh3n9"))))
    (build-system python-build-system)
    (home-page "https://github.com/alex/pretend")
    (synopsis "Library for stubbing in Python")
    (description
     "Pretend is a library to make stubbing with Python easier.  Stubbing is a
technique for writing tests.  You may hear the term mixed up with mocks,
fakes, or doubles.  Basically, a stub is an object that returns pre-canned
responses, rather than doing any computation.")
    (license license:bsd-3)))

;;; Variant used to break a dependency cycle with
;;; python-pytest-perf-bootstrap.
(define-public python-pip-run-bootstrap
  (hidden-package
   (package
     (name "python-pip-run-bootstrap")
     (version "8.8.0")
     (source (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/jaraco/pip-run")
                     (commit (string-append "v" version))))
               (file-name (git-file-name name version))
               (sha256
                (base32
                 "0ycrjj3jgqcr9c2k7y8vprq65iblg0q0hvwz8zwi13gmb0ffds0c"))))
     (build-system python-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases
       #~(modify-phases %standard-phases
           (add-before 'build 'pretend-version
             ;; The version string is usually derived via setuptools-scm, but
             ;; without the git metadata available this fails.
             (lambda _
               (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
     (native-inputs (list python-setuptools-scm))
     (propagated-inputs (list python-autocommand python-path-bootstrap
                              python-packaging))
     (home-page "https://github.com/jaraco/pip-run")
     (synopsis "Dynamic dependency loader for Python")
     (description "The @command{pip-run} command provides on-demand temporary
package installation for a single interpreter run.  It replaces this series of
commands:
@example
$ virtualenv --python pythonX.X --system-site-packages /tmp/env
$ /tmp/env/bin/pip install pkg1 pkg2 -r reqs.txt
$ /tmp/env/bin/python ...
$ rm -rf /tmp/env
@end example")
     (license license:expat))))

(define-public python-pip-run
  (package/inherit python-pip-run-bootstrap
    (name "python-pip-run")
    (arguments
     (substitute-keyword-arguments (package-arguments python-pip-run-bootstrap)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:phases phases #~%standard-phases)
        #~(modify-phases #$phases
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (invoke "pytest" "-k"
                          (string-append
                           ;; Do not test the myproject.toml build as it tries
                           ;; to pull dependencies from the internet.
                           "not project "
                           ;; These tests attempt to install dependencies from
                           ;; the network and fail.
                           "and not test_pkg_imported "
                           "and not test_pkg_loaded_from_alternate_index ")))))))))
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-pip-run-bootstrap)
       (replace "python-path-bootstrap" python-path)))
    (native-inputs
     (modify-inputs (package-native-inputs python-pip-run-bootstrap)
       (append python-nbformat
               python-pygments
               python-pytest
               python-pytest-black
               python-pytest-checkdocs
               python-pytest-cov
               python-pytest-enabler
               python-pytest-flake8
               python-pytest-mypy)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-pip-run-bootstrap)))))

(define-public python-tlsh
  (package
    (name "python-tlsh")
    (version "4.11.2")
    (home-page "https://github.com/trendmicro/tlsh")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page) (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gb5j73nw3nmx030rf8pm75rns5syxhv44zxr6i74kjicyly1i9w"))))
    (build-system cmake-build-system)
    (arguments
     (list #:out-of-source? #f
           #:phases
           #~(modify-phases %standard-phases
               (replace 'install
                 (lambda _
                   ;; Build and install the Python bindings.  The underlying
                   ;; C++ library is apparently not meant to be installed.
                   (with-directory-excursion "py_ext"
                     (and (system* "python" "setup.py" "build")
                          (system* "python" "setup.py" "install"
                                   (string-append "--prefix=" #$output))))))
               ;; Delay tests until the phase above has run.
               (delete 'check)
               (add-after 'install 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (substitute* "Testing/python_test.sh"
                     ;; The script sets up a working PYTHONPATH, but does not
                     ;; export it for all subsequent test commands.  Fix that.
                     (("^PYTHONPATH=\".*" all)
                      (string-append all "\nexport PYTHONPATH\n")))
                   (when tests?
                     (with-directory-excursion "Testing"
                       (invoke "./python_test.sh"))))))))
    (inputs (list python-wrapper))      ;for the bindings
    (synopsis "Fuzzy matching library for Python")
    (description
     "Trend Micro Locality Sensitive Hash (TLSH) is a fuzzy matching library.
Given a byte stream with a minimum length of 256 bytes, TLSH generates a hash
value which can be used for similarity comparisons.  Similar objects have
similar hash values, which allows for the detection of similar objects by
comparing their hash values.  The byte stream should have a sufficient amount
of complexity; for example, a byte stream of identical bytes will not generate
a hash value.")
    (license license:asl2.0)))

(define-public python-termcolor
  (package
    (name "python-termcolor")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "termcolor" version))
       (sha256
        (base32
         "0fv1vq14rpqwgazxg4981904lfyp84mnammw7y046491cv76jv8x"))))
    (build-system python-build-system)
    (arguments
     ;; There are no tests.
     `(#:tests? #f))
    (home-page "https://pypi.org/project/termcolor/")
    (synopsis "ANSII Color formatting for terminal output")
    (description
     "This package provides ANSII Color formatting for output in terminals.")
    (license license:expat)))

(define-public python-terminaltables
  (package
    (name "python-terminaltables")
    (version "3.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "terminaltables" version))
        (sha256
         (base32
          "109vhldk6nv1z3hzp4dyqf6rjvlhl0y2k5k7qcm9fcrq5swhxszk"))))
    (build-system python-build-system)
    (home-page "https://github.com/Robpol86/terminaltables")
    (synopsis
     "Generate simple tables in terminals from a nested list of strings")
    (description
     "This package makes it easy to draw tables in terminal/console
applications from a list of lists of strings.  It supports multi-line rows.")
    (license license:expat)))

(define-public python-libarchive-c
  (package
    (name "python-libarchive-c")
    (version "2.9")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "libarchive-c" version))
              (sha256
               (base32
                "0q7g6a97110bk0j5x81555kajyxh4sybaabab6v5sgr0xi6386cr"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-before
                   'build 'reference-libarchive
                   (lambda* (#:key inputs #:allow-other-keys)
                     ;; Retain the absolute file name of libarchive.so.
                     (let ((libarchive (assoc-ref inputs "libarchive")))
                       (substitute* "libarchive/ffi.py"
                         (("find_library\\('archive'\\)")
                          (string-append "'" libarchive
                                         "/lib/libarchive.so'"))))))
                  (replace 'check
                    (lambda _ (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-mock python-pytest))
    (inputs
     (list libarchive))
    (home-page "https://github.com/Changaco/python-libarchive-c")
    (synopsis "Python interface to libarchive")
    (description
     "This package provides Python bindings to libarchive, a C library to
access possibly compressed archives in many different formats.  It uses
Python's @code{ctypes} foreign function interface (FFI).")
    (license license:lgpl2.0+)))

(define-public python-file
  (package/inherit file
    (name "python-file")
    (build-system python-build-system)
    (arguments
     '(#:tests? #f                                ;no tests
       #:configure-flags '("--single-version-externally-managed" "--root=/")
       #:phases (modify-phases %standard-phases
                  (add-before 'build 'change-directory
                    (lambda _
                      (chdir "python")
                      #t))
                  (add-before 'build 'set-library-file-name
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((file (assoc-ref inputs "file")))
                        (substitute* "magic.py"
                          (("find_library\\('magic'\\)")
                           (string-append "'" file "/lib/libmagic.so'")))
                        #t))))))
    (inputs `(("file" ,file)))
    (native-inputs (if (%current-target-system)
                       `(("self" ,this-package))
                       '()))
    (synopsis "Python bindings to the libmagic file type guesser")
    (description "This package provides Python bindings to the libmagic file
type guesser.

Note that this module and the @code{python-magic} module both provide a
@file{magic.py} file; these two modules, which are different and were
developed separately, both serve the same purpose: provide Python bindings for
libmagic.")))

(define-public python-pydevd
  ;; Use the latest commit, which includes cleanups that removes Python 2
  ;; syntax that would fail to build.
  (let ((revision "0")
        (commit "47e298499ef19563bb2ef5941a57046a35ae6868"))
    (package
      (name "python-pydevd")
      (version (git-version "2.8.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fabioz/PyDev.Debugger")
               (commit commit)))
         (modules '((guix build utils)))
         (snippet '(begin
                     ;; Delete pre-built binaries.
                     (for-each delete-file (find-files "." "\\.(so|dylib|dll)"))
                     ;; This source is generated via Cython.
                     (delete-file "_pydevd_bundle/pydevd_cython.c")))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1yd017dh6xgxrqcyf8kk8jrr0a3zw895yfjih0z5jghyf0rck38q"))))
      (build-system python-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'fix-tests
              (lambda _
                (substitute* "tests_python/test_convert_utilities.py"
                  ;; Add missing trailing '/'.
                  (("'\\\\\\\\usr\\\\\\\\bin\\\\\\\\') == '/usr/bin" all)
                   (string-append all "/")))))
            (add-after 'unpack 'patch-command-paths
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute* "_pydevd_bundle/pydevd_api.py"
                  (("'kill'")
                   (format #f "~s" (search-input-file inputs "bin/kill")))
                  (("'pgrep'")
                   (format #f "~s" (search-input-file inputs "bin/pgrep"))))))
            (add-after 'unpack 'generate-sources
              (lambda _
                (setenv "PYTHONPATH" (getcwd))
                (invoke "python" "build_tools/build.py")))
            (add-after 'unpack 'adjust-attach-binary-name
              (lambda _
                (substitute*
                    '("pydevd_tracing.py"
                      "pydevd_attach_to_process/add_code_to_python_process.py")
                  (("def get_(target|python_helper_lib)_filename.*" all)
                   (format #f "~a    return ~s~%" all
                           (string-append #$output "/lib/attach.so"))))))
            (add-after 'unpack 'patch-gdb
              (lambda* (#:key inputs #:allow-other-keys)
                (substitute*
                    "pydevd_attach_to_process/add_code_to_python_process.py"
                  (("'gdb',")
                   (format #f "~s," (search-input-file inputs "bin/gdb"))))))
            (add-after 'build 'build-attach-linux-binary
              (lambda _
                (invoke #+(cxx-for-target) "-shared" "-o" "attach.so"
                        "-fPIC" "-nostartfiles"
                        "pydevd_attach_to_process/linux_and_mac/attach.cpp")))
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (setenv "PYDEVD_USE_CYTHON" "YES")
                  (invoke "pytest" "-vv"
                          "-n" (number->string (parallel-job-count))
                          "-k"
                          (string-append
                           ;; the GUI event loop requires an X server.
                           "not test_gui_event_loop_custom "
                           ;; This test validates that 'pydevd' is not in the
                           ;; exception message, but it is due to being part
                           ;; of the build file name present in the message.
                           "and not test_evaluate_exception_trace "
                           ;; These fail on systems with YAMA LSM’s ptrace
                           ;; scope > 0. Upstream issue:
                           ;; https://github.com/fabioz/PyDev.Debugger/issues/218
                           "and not test_attach_to_pid")))))
            (add-after 'install 'install-attach-binary
              (lambda _
                (install-file "attach.so"
                              (string-append #$output "/lib"))))
            ;; Some modules aren't designed to be loadable by themselves, such
            ;; as 'pydev_app_engine_debug_startup' and fail.
            (delete 'sanity-check))))
      (native-inputs
       (list python-cython
             python-numpy
             python-psutil
             python-pytest
             python-pytest-xdist
             python-trio
             python-untangle))
      (inputs (list coreutils gdb procps))
      (home-page "https://github.com/fabioz/PyDev.Debugger/")
      (synopsis "Python debugger")
      (description "PyDev.Debugger is a capable Python debugger used in PyDev
and other @acronym{IDEs, Integrated Development Environments}.")
      (license license:epl1.0))))

(define-public python-debugpy
  (package
    (name "python-debugpy")
    (version "1.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference              ;no tests in PyPI archive
             (url "https://github.com/microsoft/debugpy")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (modules '((guix build utils)))
       ;; Remove the bundled PyDev-Debugger copy, including its pre-built
       ;; attach binary.
       (snippet '(delete-file-recursively "src/debugpy/_vendored"))
       (patches (search-patches "python-debugpy-unbundle-pydevd.patch"))
       (sha256
        (base32
         "1dpfzs3p51648i7f3fz8dw5d0vrj39iwn1jhn0226idc02ybyqih"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f ; Fail on systems with YAMA LSM’s ptrace scope > 0.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-sh-in-tests
            (lambda _
              (substitute* "tests/debugpy/test_run.py"
                (("#!/bin/sh")
                 (string-append "#!" (which "sh"))))))
          (add-after 'unpack 'fix-version
            ;; Versioneer is useless when there is no git metadata.
            (lambda _
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(),")
                 (format #f "version=~s," #$version)))))
          (add-before 'build 'configure
            (lambda _
              ;; This adjusts the behavior of debugpy to load pydevd from
              ;; Python site packages.
              (setenv "DEBUGPY_BUNDLING_DISABLED" "1")))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv"
                        "-n" (number->string (parallel-job-count))
                        "-k"
                        (string-append
                         ;; These tests cannot be run in parallel because their
                         ;; test data would not be copied by xdist and lead to
                         ;; import errors. (see:
                         ;; https://github.com/microsoft/debugpy/issues/342 and
                         ;; https://github.com/microsoft/debugpy/issues/880).
                         "not test_custom_python_args "
                         "and not test_autokill "))))))))
    (native-inputs
     ;; See: https://raw.githubusercontent.com/microsoft/debugpy/
     ;;      main/tests/requirements.txt.
     (list python-django
           python-gevent
           python-flask
           python-psutil
           python-pytest
           python-pytest-cov
           python-pytest-timeout
           python-pytest-xdist
           python-requests))
    (propagated-inputs (list python-pydevd))
    (home-page "https://aka.ms/debugpy")
    (synopsis "Debug Adapter Protocol Python implementation")
    (description "An implementation of the Debug Adapter Protocol for
Python.")
    (license license:expat)))

(define-public python-debian
  (package
    (name "python-debian")
    (home-page "https://salsa.debian.org/python-debian-team/python-debian")
    (version "0.1.36")
    (source
     (origin
       ;; Use git-fetch, as pypi doesn't include test suite.
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0qy6x28bj6yfikhjww932v5xq4mf5bm1iczl7acy4c7zm6mwhqfa"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'set-version
                    ;; for reproducible builds, otherwise python-debian
                    ;; generates a _version.py including the date
                    (lambda _
                      (copy-file "lib/debian/_version.py.in" "lib/debian/_version.py")
                      (substitute* "lib/debian/_version.py"
                        (("__CHANGELOG_VERSION__") ,version))))
                  (add-after 'unpack 'remove-debian-specific-tests
                    ;; python-apt, apt and dpkg are not yet available in guix,
                    ;; and these tests heavily depend on them.
                    (lambda _
                      (delete-file "lib/debian/tests/test_deb822.py")
                      (delete-file "lib/debian/tests/test_debfile.py")
                      #t)))))
    (propagated-inputs
     (list python-six python-chardet))
    (synopsis "Debian package related modules")
    (description
     ;; XXX: Use @enumerate instead of @itemize to work around
     ;; <http://bugs.gnu.org/21772>.
     "This package provides Python modules that abstract many formats of
Debian-related files, such as:

@enumerate
@item Debtags information;
@item @file{debian/changelog} files;
@item packages files, pdiffs;
@item control files of single or multiple RFC822-style paragraphs---e.g.
   @file{debian/control}, @file{.changes}, @file{.dsc};
@item Raw @file{.deb} and @file{.ar} files, with (read-only) access to
   contained files and meta-information.
@end enumerate\n")

    ;; Modules are either GPLv2+ or GPLv3+.
    (license license:gpl3+)))

(define-public python-json-spec
  (package
    (name "python-json-spec")
    (version "0.10.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "json-spec" version))
        (sha256
          (base32
            "06dpbsq61ja9r89wpa2pzdii47qh3xri9ajdrgn1awfl102znchb"))))
    (build-system python-build-system)
    (propagated-inputs
      (list python-pathlib python-six))
    (native-inputs
      (list python-pytest))
    (home-page "http://py.errorist.io/json-spec")
    (synopsis
      "JSON Schema, JSON Pointer and JSON Reference for Python")
    (description
      "This Python library implements several JSON specs, like JSON Schema,
JSON Reference and JSON Pointer.")
    (license license:bsd-3)))

(define-public python-fastbencode
  (package
    (name "python-fastbencode")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fastbencode" version))
       (modules '((guix build utils)))
       ;; Delete pre-generated Cython C files.
       (snippet '(for-each delete-file (find-files "." "\\.c$")))
       (sha256
        (base32 "1r66w3vpmvfmssshjpgqaj2m14c8p94nymr96mwn61idajz9mg5n"))))
    (build-system python-build-system)
    (native-inputs (list python-cython))
    (home-page "https://github.com/breezy-team/fastbencode")
    (synopsis "Python Bencode (de)serializer with optional fast C extensions")
    (description
     "The fastbencode Python package implements the bencode serialization
format for storing and transmitting loosely structured data, originally used
by BitTorrent.

The format can encode four different types of values: byte strings, integers,
lists, and dictionaries (associative arrays).  It's simple and unaffected by
endianness,

This package includes both a pure-Python version and an optional C extension
based on Cython.  Both provide the same functionality, but the C version has
significantly better performance.")
    (license (list license:expat        ; _bencode_py.py
                   license:gpl2+))))    ; __init__.py

(define-public python-fastjsonschema
  (package
    (name "python-fastjsonschema")
    (version "2.15.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "fastjsonschema" version))
        (sha256
          (base32 "1ln2j60jzyn6p8i8ljygfgrji58hc23452g7nllkcjdk4p93c7v7"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; Fail with a strange backtrace ending in importlib.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
            (when tests?
              (invoke "pytest" "-vv" "-m" "not benchmark")))))))
    (native-inputs
      (list python-colorama
            python-json-spec
            python-jsonschema
            python-pylint
            python-pytest
            python-pytest-benchmark
            python-pytest-cache
            python-validictory))
    (home-page
      "https://github.com/horejsek/python-fastjsonschema")
    (synopsis
      "Fast Python implementation of JSON schema")
    (description
      "This library implements validation of JSON documents by JSON schema for
drafts 04, 06 and 07.")
    (license license:bsd-3)))

(define-public python-nbformat
  (package
    (name "python-nbformat")
    (version "5.3.0")
    ;; The PyPi release tarball lacks some test cases and test data.
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jupyter/nbformat")
                    (commit version)))
              (sha256
               (base32
                "114c5c6cvpxhxj8zrw74351gcfzyzjh1jq3py4xf8wk9rahfay9z"))
              (file-name (git-file-name name version))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-fastjsonschema python-jsonschema python-jupyter-core
           python-traitlets))
    (native-inputs
     (list python-pytest
           python-testpath))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter Notebook format")
    (description "This package provides the reference implementation of the
Jupyter Notebook format and Python APIs for working with notebooks.")
    (license license:bsd-3)))

(define-public python-nb-clean
  (package
    (name "python-nb-clean")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "nb-clean" version))
        (sha256
          (base32 "01qvk9n7rx15dhc23m8bj9bw5wdyxh6y18c5fm8hllmrd3ndsx14"))))
    (build-system python-build-system)
    (propagated-inputs (list python-nbformat))
    (home-page "https://github.com/srstevenson/nb-clean")
    (synopsis "Clean Jupyter notebooks for versioning")
    (description "This package cleans Jupyter notebooks of cell execution
counts, metadata, outputs, and empty cells, preparing them for committing to
version control.  It provides a Git filter to automatically clean notebooks
before they're staged, and can also be used with other version control
systems, as a command line tool, and as a Python library.")
    (license license:isc)))

(define-public python-bleach
  (package
    (name "python-bleach")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bleach" version))
       (sha256
        (base32 "0rc5avysbsl3w3i2qvb6522263zhwlvf50w0ifs8776w9c2wrmn6"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests? (invoke "pytest" "-vv")))))))
    (propagated-inputs (list python-tinycss2 python-webencodings))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/mozilla/bleach")
    (synopsis "Whitelist-based HTML-sanitizing tool")
    (description "Bleach is an easy whitelist-based HTML-sanitizing tool.")
    (license license:asl2.0)))

(define-public python-entrypoints
  (package
    (name "python-entrypoints")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "entrypoints" version))
       (sha256
        (base32
         "0lc4si3xb7hza424414rdqdc3vng3kcrph8jbvjqb32spqddf3f7"))))
    (build-system python-build-system)
    ;; The package does not come with a setup.py file, so we have to generate
    ;; one ourselves.
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'create-setup.py
           (lambda _
             (call-with-output-file "setup.py"
               (lambda (port)
                 (format port "\
from setuptools import setup
setup(name='entrypoints', version='~a', py_modules=['entrypoints'])
" ,version))))))))
    (home-page "https://github.com/takluyver/entrypoints")
    (synopsis "Discover and load entry points from installed Python packages")
    (description "Entry points are a way for Python packages to advertise
objects with some common interface.  The most common examples are
@code{console_scripts} entry points, which define shell commands by
identifying a Python function to run.  The @code{entrypoints} module contains
functions to find and load entry points.")
    (license license:expat)))

(define-public python-epc
  (package
    (name "python-epc")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "epc" version))
       (sha256
        (base32
         "09bx1ln1bwa00917dndlgs4k589h8qx2x080xch5m58p92kjwkd1"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-sexpdata))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/tkf/python-epc")
    (synopsis "Remote procedure call (RPC) stack for Emacs Lisp and Python")
    (description
     "Python-EPC can call elisp functions from Python and Python functions
from elisp.")
    (license license:gpl3)))

(define-public python-forex-python
  (package
    (name "python-forex-python")
    (version "1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "forex-python" version))
       (sha256
        (base32 "1ma8cl1i2dh8aa99pifnlilyy4d1gd1s07fj0yd17wcbpsh532cj"))))
    (build-system python-build-system)
    (arguments
     ;; Tests are not included in the PyPI tarball.  Also, the tests in the
     ;; repository require online data.
     `(#:tests? #f))
    (propagated-inputs
     (list python-requests python-simplejson))
    (home-page "https://github.com/MicroPyramid/forex-python")
    (synopsis "Foreign exchange rates and currency conversion")
    (description
     "@code{python-forex-python} can be used to manipulate foreign
exchange rates and to operate currency conversions.

Features:
@itemize
@item List all currency rates.
@item BitCoin price for all currencies.
@item Converting amount to BitCoins.
@item Get historical rates for any day since 1999.
@item Conversion rate for one currency(ex; USD to INR).
@item Convert amount from one currency to other.('USD 10$' to INR).
@item Currency symbols.
@item Currency names.
@end itemize")
    (license license:expat)))

(define-public python-simpleeval
  (package
    (name "python-simpleeval")
    (version "0.9.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simpleeval" version))
       (sha256
        (base32 "0diysdzvx865yy2rjfah75ha2qfxaxz7r108kp7j2kkd903ya2ry"))))
    (build-system python-build-system)
    (home-page "https://github.com/danthedeckie/simpleeval")
    (synopsis "Simple, safe single expression evaluator library")
    (description
     "This package provides a quick single file library for easily adding
evaluatable expressions into python projects.  Say you want to allow a user
to set an alarm volume, which could depend on the time of day, alarm level,
how many previous alarms had gone off, and if there is music playing at the
time.")
    (license license:expat)))

(define-public python-nbconvert
  (package
    (name "python-nbconvert")
    (version "6.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nbconvert" version))
       (sha256
        (base32
         "17g9xq4za7vvzml6l6d8zrzknhxsvgx02hymmsw9d1dygbi4cgi2"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Use pandoc binary from input.
              (substitute* "nbconvert/utils/pandoc.py"
                (("'pandoc'")
                 (format #f "~s" (search-input-file inputs "bin/pandoc"))))
              ;; Same for LaTeX.
              (substitute* "nbconvert/exporters/pdf.py"
                (("\"xelatex\"")
                 (format #f "~s" (search-input-file inputs "bin/xelatex")))
                (("\"bibtex\"")
                 (format #f "~s" (search-input-file inputs "bin/bibtex"))))
              ;; Likewise for Inkscape.
              (substitute* "nbconvert/preprocessors/svg2pdf.py"
                (("inkscape_path = which\\(\"inkscape\")")
                 (format #f "inkscape_path = ~s"
                         (search-input-file inputs "bin/inkscape"))))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Tests depend on templates installed to output.
                (setenv "JUPYTER_PATH"
                        (string-append #$output "/share/jupyter:"
                                       (getenv "JUPYTER_PATH")))
                ;; Step outside of the source directory to avoid having both
                ;; the installed package *and* the package from the source on
                ;; Python's path.
                (with-directory-excursion "/tmp"
                  (invoke "pytest" "--pyargs" "nbconvert"
                          "-vv" "-n" (number->string (parallel-job-count))
                          "-k"
                          (string-append
                           ;; These tests require pyppeteer, not yet
                           ;; available in Guix.
                           "not test_webpdf_with_chromium "
                           "and not test_webpdf.py "
                           ;; These tests require ipywidgets, which would
                           ;; introduce a dependency cycle.
                           "and not test_execute_widgets_from_nbconvert "
                           "and not test_execute_multiple_notebooks ")))))))))
    (inputs
     (list inkscape/stable pandoc))
    (native-inputs
     (list python-ipykernel
           ;; Adding ipywidgets would create a cycle.
           ;;python-ipywidgets
           ;;python-pyppeteer    ;TODO: package me
           python-pytest
           python-pytest-xdist))
    (propagated-inputs
     (list python-beautifulsoup4
           python-bleach
           python-defusedxml
           python-entrypoints
           python-jinja2
           python-jupyter-core
           python-mistune
           python-nbclient
           python-nbformat
           python-pandocfilters
           python-pygments
           python-jupyterlab-pygments
           python-testpath
           python-traitlets
           ;; Required, even if [serve] is not used.
           python-tornado-6
           ;; Required at runtime for `jupyter nbconvert --to=pdf`.
           texlive-adjustbox
           texlive-booktabs
           texlive-caption
           texlive-enumitem
           texlive-fontspec
           texlive-generic-iftex
           texlive-grffile
           texlive-hyperref
           texlive-latex-fancyvrb
           texlive-latex-float
           texlive-latex-geometry
           texlive-latex-jknapltx
           texlive-latex-ms
           texlive-latex-parskip
           texlive-latex-trimspaces
           texlive-latex-upquote
           texlive-stringenc
           texlive-tcolorbox
           texlive-titling
           texlive-tools
           texlive-ulem
           texlive-unicode-math
           texlive-xcolor
           (texlive-updmap.cfg (list texlive-amsfonts
                                     texlive-amsmath
                                     texlive-eurosym
                                     texlive-fonts-rsfs
                                     texlive-jknappen
                                     texlive-latex-ucs
                                     texlive-lm
                                     texlive-lm-math
                                     texlive-mathpazo
                                     texlive-oberdiek
                                     texlive-zapfding))))
    (home-page "https://jupyter.org")
    (synopsis "Converting Jupyter Notebooks")
    (description "The @code{nbconvert} tool, @code{jupyter nbconvert}, converts
notebooks to various other formats via Jinja templates.  It allows you to
convert an @code{.ipynb} notebook file into various static formats including:

@enumerate
@item HTML
@item LaTeX
@item PDF
@item Reveal JS
@item Markdown (md)
@item ReStructured Text (rst)
@item executable script
@end enumerate\n")
    (license license:bsd-3)))

(define-public python-notebook
  (package
    (name "python-notebook")
    (version "6.4.10")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "notebook" version))
              (sha256
               (base32
                "03p976xq1l9xf4djwk0snmywd0zck3i6gjngxsl874i8qrmsf214"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'use-our-home-for-tests
           (lambda _
             ;; The 'get_patch_env' function in this file reads:
             ;;   'HOME': cls.home_dir
             ;; but for some reason, that definition of HOME is not what the
             ;; GLib/GIO trash mechanism honors, which would cause test
             ;; failures.  Instead, set 'HOME' here to an existing directory
             ;; and let the tests honor it.
             (substitute* "notebook/tests/launchnotebook.py"
               (("'HOME': .*," all)
                (string-append "# " all "\n")))
             (setenv "HOME" (getcwd))))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             ;; These tests require a browser.
             (delete-file-recursively "notebook/tests/selenium")
             (when tests?
               ;; Interferes with test expectations.
               (unsetenv "JUPYTER_CONFIG_PATH")
               ;; Some tests do not expect all files to be installed in the
               ;; same directory, but JUPYTER_PATH contains multiple entries.
               (unsetenv "JUPYTER_PATH")
               (invoke "pytest" "-vv"
                       ;; TODO: This tests fails because nbconvert does not
                       ;; list "python" as a format.
                       "-k" "not test_list_formats")))))))
    (propagated-inputs
     (list python-argon2-cffi
           python-ipykernel
           python-ipython-genutils
           python-jinja2
           python-jupyter-client
           python-jupyter-core
           python-nest-asyncio
           python-nbconvert
           python-nbformat
           python-prometheus-client
           python-pyzmq
           python-send2trash
           python-terminado
           python-tornado-6
           python-traitlets))
    (native-inputs
     (list python-coverage
           python-nbval
           python-pytest
           python-pytest-cov
           python-requests
           python-requests-unixsocket))
    (home-page "https://jupyter.org/")
    (synopsis "Web-based notebook environment for interactive computing")
    (description
     "The Jupyter HTML notebook is a web-based notebook environment for
interactive computing.")
    (license license:bsd-3)))

(define-public python-widgetsnbextension
  (package
    (name "python-widgetsnbextension")
    (version "3.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "widgetsnbextension" version))
       (sha256
        (base32
         "1ismyaxbv9d56yqqqb8xl58hg0iq0bbyy014a53y1g3hfbc8g7q7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-notebook))
    (home-page "https://ipython.org")
    (synopsis "IPython HTML widgets for Jupyter")
    (description "This package provides interactive HTML widgets for Jupyter
notebooks.")
    (license license:bsd-3)))

(define-public python-ipywidgets
  (package
    (name "python-ipywidgets")
    (version "7.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipywidgets" version))
       (sha256
        (base32
         "1w217j8i53x14l7b05fk300k222zs9vkcjaa1rbrw3sk43k466lz"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-ipykernel
           python-ipython
           python-jupyterlab-widgets
           python-nbformat
           python-traitlets
           python-widgetsnbextension))
    (native-inputs
     (list python-mock python-pytest python-pytest-cov))
    (home-page "https://ipython.org")
    (synopsis "IPython HTML widgets for Jupyter")
    (description "Ipywidgets are interactive HTML widgets for Jupyter
notebooks and the IPython kernel.  Notebooks come alive when interactive
widgets are used.  Users gain control of their data and can visualize changes
in the data.")
    (license license:bsd-3)))

(define-public python-jupyter-console
  (package
    (name "python-jupyter-console")
    (version "6.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jupyter_console" version))
       (sha256
        (base32
         "1iqrxhd8hvlyf8cqbc731ssnwm61wrycnbiczy5wsfahd3hlh8i4"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-ipykernel python-jupyter-client python-prompt-toolkit
           python-pygments))
    (native-inputs
     (list python-nose python-pytest))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter terminal console")
    (description "This package provides a terminal-based console frontend for
Jupyter kernels.  It also allows for console-based interaction with non-Python
Jupyter kernels such as IJulia and IRKernel.")
    (license license:bsd-3)))

;; The python-ipython and python-jupyter-console require each other. To get
;; the functionality in both packages working, strip down the
;; python-jupyter-console package when using it as an input to python-ipython.
(define python-jupyter-console-minimal
  (package/inherit python-jupyter-console
    (name "python-jupyter-console-minimal")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-jupyter-console)
       ((#:phases phases)
        `(modify-phases ,phases
           (add-after 'install 'delete-bin
             (lambda* (#:key outputs #:allow-other-keys)
               ;; Delete the bin files, to avoid conflicts in profiles
               ;; where python-ipython and python-jupyter-console are
               ;; both present.
               (delete-file-recursively
                (string-append
                 (assoc-ref outputs "out") "/bin"))))))))
    ;; Remove the python-ipython propagated input, to avoid the cycle
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-jupyter-console)
       (delete "python-ipython")))))

(define-public python-qtconsole
  (package
    (name "python-qtconsole")
    (version "5.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "qtconsole" version))
       (sha256
        (base32 "09anp8g7vqi8z8wyi2lv21a2frd2dyhyrzvcrk2anijyqzyj0dcf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'pre-check
           (lambda _
             (setenv "QT_QPA_PLATFORM" "offscreen")
             (setenv "HOME" "/tmp")
             ;; FIXME: skip a failing test.
             (substitute* "qtconsole/tests/test_jupyter_widget.py"
               (("def test_other_output") "def _test_other_output")))))))
    (propagated-inputs
     (list python-ipykernel python-ipython-genutils python-jupyter-client
           python-jupyter-core python-pygments python-pyqt-without-qtwebkit
           python-pyzmq python-qtpy python-traitlets))
    (native-inputs
     (list python-flaky python-pytest python-pytest-qt))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter Qt console")
    (description "This package provides a Qt-based console for Jupyter with
support for rich media output.")
    (license license:bsd-3)))

(define-public python-jsbeautifier
  (package
    (name "python-jsbeautifier")
    (version "1.10.2")
    (home-page "https://github.com/beautify-web/js-beautify")
    (source (origin
             (method git-fetch)
             (uri (git-reference
                   (url home-page)
                   (commit (string-append "v" version))))
             (file-name (git-file-name name version))
             (sha256
              (base32
               "0wawb070ki1axb3jc9xvsrgpji52vcfif3zmjzc3z4g98m5xw4kg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'chdir
                    (lambda _
                      ;; The upstream Git repository contains all the code,
                      ;; but this package only builds the python code.
                      (chdir "python")
                      #t))
                  (add-after 'unpack 'patch-python-six-requirements
                    (lambda _
                      (substitute* "python/setup.py"
                        (("six>=1.12.0")
                         "six>=1.11.0"))
                      #t)))))
    (propagated-inputs
     (list python-editorconfig python-six))
    (native-inputs
     (list python-pytest))
    (synopsis "JavaScript unobfuscator and beautifier")
    (description "Beautify, unpack or deobfuscate JavaScript, leveraging
popular online obfuscators.")
    (license license:expat)))

(define-public jupyter
  (package
    (name "jupyter")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jupyter" version))
       (sha256
        (base32
         "0pwf3pminkzyzgx5kcplvvbvwrrzd3baa7lmh96f647k30rlpp6r"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; there are none.
    (propagated-inputs
     (list python-ipykernel
           python-ipywidgets
           python-jupyter-console
           python-nbconvert
           python-notebook
           python-qtconsole))
    (home-page "https://jupyter.org")
    (synopsis "Web application for interactive documents")
    (description
     "The Jupyter Notebook is a web application that allows you to create and
share documents that contain live code, equations, visualizations and
explanatory text.  Uses include: data cleaning and transformation, numerical
simulation, statistical modeling, machine learning and much more.")
    (license license:bsd-3)))

(define-public python-chardet
  (package
    (name "python-chardet")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "chardet" version))
       (sha256
        (base32
         "1amqmz8731ly6f9rkbk09w4jqgmmgyxykd1bawhgrdbqzlmxys03"))))
    (native-inputs
     (list python-pytest))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda _
                   (invoke "pytest" "-vv" "-k"
                           ;; Disable test that fails sporadically:
                           ;; https://github.com/chardet/chardet/issues/256
                           "not test_detect_all_and_detect_one_should_agree")))
               ;; This package provides a 'chardetect' executable that only
               ;; depends on Python, so customize the wrap phase to avoid
               ;; adding pytest and friends in order to save size.
               ;; (See also <https://bugs.gnu.org/25235>.)
               (replace 'wrap
                 (lambda* (#:key inputs outputs #:allow-other-keys)
                   (let* ((sitedir (site-packages inputs outputs))
                          (python (dirname (dirname
                                            (search-input-file
                                             inputs "bin/python"))))
                          (python-sitedir
                           (string-append python "/lib/python"
                                          (python-version python)
                                          "/site-packages")))
                     (wrap-program (string-append #$output "/bin/chardetect")
                       `("GUIX_PYTHONPATH" ":" suffix
                         ,(list sitedir python-sitedir)))))))))
    (home-page "https://github.com/chardet/chardet")
    (synopsis "Universal encoding detector for Python 2 and 3")
    (description
     "This package provides @code{chardet}, a Python module that can
automatically detect a wide range of file encodings.")
    (license license:lgpl2.1+)))

(define-public python-charset-normalizer
  (package
    (name "python-charset-normalizer")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "charset-normalizer" version))
       (sha256
        (base32 "04zlajr77f6c7ai59l46as1idi0jjgbvj72lh4v5wfpz2s070pjp"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; This package provides a 'normalizer' executable that only
               ;; depends on Python, so customize the wrap phase to avoid
               ;; adding pytest and friends in order to save size.
               ;; (See also <https://bugs.gnu.org/25235>.)
               (replace 'wrap
                 (lambda* (#:key inputs outputs #:allow-other-keys)
                   (let* ((sitedir (site-packages inputs outputs))
                          (python (dirname (dirname
                                            (search-input-file
                                             inputs "bin/python"))))
                          (python-sitedir
                           (string-append python "/lib/python"
                                          (python-version python)
                                          "/site-packages")))
                     (wrap-program (string-append #$output "/bin/normalizer")
                       `("GUIX_PYTHONPATH" ":" suffix
                         ,(list sitedir python-sitedir)))))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/ousret/charset_normalizer")
    (synopsis "Universal Charset Detector, alternative to Chardet")
    (description "This library helps you read text from an unknown charset
encoding.  Motivated by @code{chardet}, it tries to resolve the issue by
taking a new approach.  All IANA character set names for which the Python core
library provides codecs are supported.")
    (license license:expat)))

(define-public python-docopt
  (package
    (name "python-docopt")
    (version "0.6.2")
    (source
     (origin
       (method git-fetch)
       ;; The release on PyPI does not include tests.
       (uri (git-reference
              (url "https://github.com/docopt/docopt")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0aad9gbswnnhssin2q0m5lmpm0ahyf80ahs2zjigbn5y7fvljnd0"))
       (patches (search-patches "python-docopt-pytest6-compat.patch"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "py.test")))))))
    (home-page "http://docopt.org")
    (synopsis "Command-line interface description language for Python")
    (description "This library allows the user to define a command-line
interface from a program's help message rather than specifying it
programmatically with command-line parsers like @code{getopt} and
@code{argparse}.")
    (license license:expat)))

(define-public python-pythonanywhere
  (package
    (name "python-pythonanywhere")
    (version "0.9.10")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://github.com/pythonanywhere/helper_scripts")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
          (base32
           "0vzzc1g8pl7cb9yvm3n1j5zlzxf0jd423rzspc2kvpb8yhvydklx"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'change-home
           (lambda _
             (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Exclude tests marked as slowtest that assume running
               ;; inside Git repository on system with virtualenvwrapper
               ;; installed.
               (invoke "pytest" "-m" "not slowtest")))))))
    (native-inputs
      (list python-pytest
            python-psutil
            python-responses
            python-pytest-mock))
    (propagated-inputs
      (list python-dateutil
            python-docopt
            python-packaging
            python-requests
            python-schema
            python-tabulate
            python-typer))
    (home-page "https://github.com/pythonanywhere/helper_scripts/")
    (synopsis "PythonAnywhere helper tools for users")
    (description "PythonAnywhere provides a command-line interface and an
application programming interface that allows managing Web apps and scheduled
tasks.  It includes single-command deployment for the Django Girls tutorial.")
    (license license:expat)))

(define-public python-pythondialog
  (package
    (name "python-pythondialog")
    (version "3.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pythondialog" version))
              (sha256
               (base32
                "1728ghsran47jczn9bhlnkvk5bvqmmbihabgif5h705b84r1272c"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'patch-path
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let* ((dialog (assoc-ref inputs "dialog")))
                        (substitute* "dialog.py"
                          (("os.getenv\\(\"PATH\", \":/bin:/usr/bin\"\\)") (string-append
                                                                            "os.getenv(\"PATH\")  + \":"
                                                                            dialog
                                                                            "/bin\"")))
                        #t))))
       #:tests? #f))
    (propagated-inputs (list dialog))
    (home-page "http://pythondialog.sourceforge.net/")
    (synopsis "Python interface to the UNIX dialog utility")
    (description
     "A Python wrapper for the dialog utility.  Its purpose is to
provide an easy to use, pythonic and comprehensive Python interface to dialog.
This allows one to make simple text-mode user interfaces on Unix-like systems")
    (license license:lgpl2.1)))

(define-public python-configobj
  (package
    (name "python-configobj")
    (version "5.0.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "configobj" version))
              (sha256
               (base32
                "00h9rcmws03xvdlfni11yb60bz3kxfvsj6dg6nrpzj71f03nbxd2"))
              ;; Patch setup.py so it looks for python-setuptools, which is
              ;; required to parse the keyword 'install_requires' in setup.py.
              (patches (search-patches "python-configobj-setuptools.patch"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (synopsis "Config file reading, writing and validation")
    (description "ConfigObj is a simple but powerful config file reader and
writer: an ini file round tripper.  Its main feature is that it is very easy to
use, with a straightforward programmer’s interface and a simple syntax for
config files.")
    (home-page "https://github.com/DiffSK/configobj")
    (license license:bsd-3)))

(define-public python-configargparse
  (package
    (name "python-configargparse")
    (version "1.2.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ConfigArgParse" version))
              (sha256
               (base32
                "1p1pzpf5qpf80bfxsx1mbw9blyhhypjvhl3i60pbmhfmhvlpplgd"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pyyaml))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; Bypass setuptools-shim because one test relies on "setup.py"
             ;; being the first argument passed to the python call.
             ;;
             ;; NOTE: Many tests do not run because they rely on Python's
             ;; built-in test.test_argparse, but we remove the unit tests from
             ;; our Python installation.
             (invoke "python" "setup.py" "test"))))))
    (synopsis "Replacement for argparse")
    (description "A drop-in replacement for argparse that allows options to also
be set via config files and/or environment variables.")
    (home-page "https://github.com/bw2/ConfigArgParse")
    (license license:expat)))

(define-public python-connection-pool
  (package
    (name "python-connection-pool")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "connection_pool" version))
       (sha256
        (base32 "1p6hfkcl4n3hhhcgjbaxn21i7b1yipag6j7dnilir4k5xxx9whmz"))))
    (build-system python-build-system)
    (home-page "https://github.com/zhouyl/ConnectionPool")
    (synopsis "Thread-safe connection pool")
    (description "This package provides a library implementing a thread-safe
connection pool.")
    (license license:expat)))

(define-public python-argparse-manpage
  (package
    (name "python-argparse-manpage")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argparse-manpage" version))
       (sha256
        (base32
         "0blh31zns68anina9lba5wh81d1414s97p60zw5l0d0shhh0wj5p"))))
    (build-system python-build-system)
    (home-page "https://github.com/praiskup/argparse-manpage")
    (synopsis "Build manual page from Python's ArgumentParser object")
    (description
     "This package provides tools to build manual pages from Python's
@code{ArgumentParser} object.")
    (license license:asl2.0)))

(define-public python-contextlib2
  (package
    (name "python-contextlib2")
    (version "0.6.0.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "contextlib2" version))
       (sha256
        (base32
         "0bhnr2ac7wy5l85ji909gyljyk85n92w8pdvslmrvc8qih4r1x01"))))
    (build-system python-build-system)
    (home-page "https://contextlib2.readthedocs.org/")
    (synopsis "Tools for decorators and context managers")
    (description "This module is primarily a backport of the Python
3.2 contextlib to earlier Python versions.  Like contextlib, it
provides utilities for common tasks involving decorators and context
managers.  It also contains additional features that are not part of
the standard library.")
    (license license:psfl)))

(define-public python-texttable
  (package
    (name "python-texttable")
    (version "1.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "texttable" version))
       (sha256
        (base32
         "1sbn821394rix6xgj3zqk743pj6nqm1qz81zgis2bcpp2ng7pvj2"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv" "tests.py")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/foutaise/texttable/")
    (synopsis "Python module for creating simple ASCII tables")
    (description "Texttable is a Python module for creating simple ASCII
tables.")
    (license license:expat)))

(define-public python-atomicwrites
  (package
    (name "python-atomicwrites")
    (version "1.4.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "atomicwrites" version))
             (sha256
              (base32
               "0yla2svfhfqrcj8qbyqzx7wi4jy0dwcxvlkg0k3zjd54s5m3jw5f"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))          ;avoid circular dependency with pytest
    (synopsis "Atomic file writes in Python")
    (description "Library for atomic file writes using platform dependent tools
for atomic file system operations.")
    (home-page "https://github.com/untitaker/python-atomicwrites")
    (license license:expat)))

(define-public python-qstylizer
  (package
    (name "python-qstylizer")
    (version "0.1.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/blambright/qstylizer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0zvkn6g1dn51kkw33v8qrlnwlmf5h6sw1ay3bh14ifjr8b9xsjjz"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"
       #:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-pbr-version
           (lambda _
             (setenv "PBR_VERSION" "3.0.1"))))))
    (native-inputs
     (list python-pbr
           python-pytest
           python-pytest-catchlog
           python-pytest-cov
           python-pytest-mock
           python-pytest-runner
           python-pytest-xdist))
    (propagated-inputs
     (list python-inflection python-tinycss))
    (home-page "https://github.com/blambright/qstylizer")
    (synopsis "Qt stylesheet generation utility for PyQt/PySide")
    (description "@code{qstylizer} is a Python package designed to help with
the construction of PyQt/PySide stylesheets.")
    (license license:expat)))

(define-public python-click-threading
  (package
    (name "python-click-threading")
    (version "0.5.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "click-threading" version))
             (sha256
              (base32
               "0f9lmxwcq0y9lb8w0whbni7gwy12gbv74h1igh85qn9aq0iydkxd"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-click))
    (synopsis "Utilities for multithreading in Click")
    (description "This package provides utilities for multithreading in Click
applications.")
    (home-page "https://github.com/click-contrib/click-threading")
    (license license:expat)))

(define-public python-click-log
  (package
    (name "python-click-log")
    (version "0.3.2")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "click-log" version))
             (sha256
              (base32
               "091i03bhxyzsdbc6kilxhivfda2f8ymz3b33xa6cj5kbzjiirz8n"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-click))
    (synopsis "Logging for click applications")
    (description "This package provides a Python library for logging Click
applications.")
    (home-page "https://github.com/click-contrib/click-log")
    (license license:expat)))

(define-public python-click-default-group
  (package
    (name "python-click-default-group")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "click-default-group" version))
              (sha256
               (base32
                "015r78jk8gznfw0dphpwaqcx5mhg5822b55w5xbb6i7sin70wmnr"))))
    (build-system python-build-system)
    (arguments
      `(#:tests? #f)) ; no target
    (propagated-inputs
     (list python-click))
    (synopsis "Extends click.Group")
    (description "This package extends click.Group to invoke a command without
explicit subcommand name.")
    (home-page "https://github.com/click-contrib/click-default-group")
    (license license:bsd-3)))

(define-public python-structlog
  (package
    (name "python-structlog")
    (version "20.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "structlog" version))
        (sha256
         (base32
          "0x1i21vn3xjfa3j9ijbblia5z0jlzc9aqvpqc26sy16i8yjxyydg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest"))
             #t)))))
    (native-inputs
     (list python-coverage
           python-freezegun
           python-pretend
           python-pytest
           python-pytest-asyncio
           python-simplejson
           python-twisted))
    (home-page "https://www.structlog.org/")
    (synopsis "Structured Logging for Python")
    (description "@code{structlog} changes logging in Python by adding structure
to your log entries.")
    (license (list license:asl2.0 license:expat))))

(define-public python-apipkg
  (package
    (name "python-apipkg")
    (version "1.5")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "apipkg" version))
             (sha256
              (base32
               "1xhak74yj3lqflvpijg15rnkklrigvsp5q7s4as4h6a157d8q8ip"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (synopsis "Namespace control and lazy-import mechanism")
    (description "With apipkg you can control the exported namespace of a Python
package and greatly reduce the number of imports for your users.  It is a small
pure Python module that works on virtually all Python versions.")
    (home-page "https://github.com/pytest-dev/apipkg")
    (license license:expat)))

(define-public python-execnet
  (package
    (name "python-execnet")
    (version "1.9.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "execnet" version))
              (sha256
               (base32
                "1ia7dvrh0gvzzpi758mx55f9flr16bzdqlmi12swm4ncm4xlyscg"))
              (patches (search-patches "python-execnet-read-only-fix.patch"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key inputs outputs tests? #:allow-other-keys)
                      (when tests?
                        ;; Unset PYTHONDONTWRITEBYTECODE to match the
                        ;; expectations of a test in
                        ;; 'testing/test_gateway.py'.
                        (unsetenv "PYTHONDONTWRITEBYTECODE")

                        (add-installed-pythonpath inputs outputs)
                        (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (synopsis "Rapid multi-Python deployment")
    (description "Execnet provides a share-nothing model with
channel-send/receive communication for distributing execution across many
Python interpreters across version, platform and network barriers.  It has a
minimal and fast API targeting the following uses:
@enumerate
@item distribute tasks to (many) local or remote CPUs
@item write and deploy hybrid multi-process applications
@item write scripts to administer multiple environments
@end enumerate")
    (home-page "https://codespeak.net/execnet/")
    (license license:expat)))

(define-public python-icalendar
  (package
    (name "python-icalendar")
    (version "4.1.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "icalendar" version))
             (sha256
              (base32
               "15dkq42rkqjdi17rpvmd1plnbwn4daby0nk1s1c3xi7w5v0bfj4p"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dateutil python-pytz))
    (synopsis "Python library for parsing iCalendar files")
    (description "The icalendar package is a parser/generator of iCalendar
files for use with Python.")
    (home-page "https://github.com/collective/icalendar")
    (license license:bsd-2)))

(define-public python-args
  (let ((commit "9460f1a35eb3055e9e4de1f0a6932e0883c72d65") (revision "0"))
    (package
      (name "python-args")
      (version (git-version "0.1.0" revision commit))
      (home-page "https://github.com/kennethreitz-archive/args")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url home-page)
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1zfxpbp9vldqdrjmd0c6y3wisl35mx5v8zlyp3nhwpy1730wrc9j"))))
      (build-system python-build-system)
      (arguments
       `(#:phases (modify-phases %standard-phases
                    (add-after 'unpack 'patch-args.py
                      (lambda _
                        (substitute* "args.py"
                          (("basestring") "str"))))
                    (replace 'check
                      (lambda* (#:key tests? #:allow-other-keys)
                        (when tests?
                          (invoke "nosetests" "-v")))))))
      (native-inputs (list python-nose))
      (synopsis "Command-line argument parser")
      (description
       "This library provides a Python module to parse command-line arguments.")
      (license license:bsd-3))))

(define-public python-clint
  (package
    (name "python-clint")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "clint" version))
              (sha256
               (base32
                "1an5lkkqk1zha47198p42ji3m94xmzx1a03dn7866m87n4r4q8h5"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "py.test" "-v"))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-args))
    (home-page "https://github.com/kennethreitz/clint")
    (synopsis "Command-line interface tools")
    (description
     "Clint is a Python module filled with a set of tools for developing
command-line applications, including tools for colored and indented
output, progress bar display, and pipes.")
    (license license:isc)))

(define-public python-rply
  (package
    (name "python-rply")
    (version "0.7.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rply" version))
              (sha256
               (base32
                "1j81nddvnb145x4p81bnfpyai6g26i2dc1633ycsk025bb18m01a"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-appdirs))
    (home-page "https://github.com/alex/rply")
    (synopsis "Parser generator for Python")
    (description
     "This package provides a pure Python based parser generator, that also
works with RPython.  It is a more-or-less direct port of David Bazzley's PLY,
with a new public API, and RPython support.")
    (license license:bsd-3)))

(define-public python-hy
  (package
    (name "python-hy")
    (version "0.24.0")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/hylang/hy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1s458ymd9g3s8k2ccc300jr4w66c7q3vhmhs9z3d3a4qg0xdhs9y"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "pytest" "-k"
                       (string-append   ; skip some failed tests
                        "not test_sys_executable"
                        " and not test_circular_macro_require"
                        " and not test_macro_require"
                        " and not test_requires_pollutes_core"))))))))
    (native-inputs
     (list python-pytest-7.1 python-wheel))
    (propagated-inputs
     (list python-colorama python-funcparserlib))
    (home-page "https://docs.hylang.org/en/stable/")
    (synopsis "Lisp frontend to Python")
    (description
     "Hy is a dialect of Lisp that's embedded in Python.  Since Hy transforms
its Lisp code into the Python Abstract Syntax Tree, you have the whole world of
Python at your fingertips, in Lisp form.")
    (license license:expat)))

(define-public python-hissp
  (package
    (name "python-hissp")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hissp" version))
       (sha256
        (base32
         "0yns7f0q699zn2ziagyas2nkndl7mp1hhssv9x9mpl7jxj2p5myw"))))
    (build-system python-build-system)
    (home-page "https://github.com/gilch/hissp")
    (synopsis "It's Python with a Lissp")
    (description "Hissp is a modular Lisp implementation that compiles to a
functional subset of Python—Syntactic macro metaprogramming with full access
to the Python ecosystem.")
    (license license:asl2.0)))

(define-public python-promise
  (package
    (name "python-promise")
    (version "0.4.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "promise" version))
        (sha256
         (base32
          "1k19ms8l3d5jzjh557rgkxb5sg4mqgfc315rn4hx1z3n8qq6lr3h"))))
    (build-system python-build-system)
    ;; Tests wants python-futures, which is a python2 only program, and
    ;; can't be found by python-promise at test time.
    (arguments `(#:tests? #f))
    (home-page "https://github.com/syrusakbary/promise")
    (synopsis "Promises/A+ implementation for Python")
    (description
     "Promises/A+ implementation for Python")
    (license license:expat)))

(define-public python-progress
  (package
    (name "python-progress")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progress" version))
       (sha256
        (base32 "1k9lpb7lqr6mywpnqcz71y6qny54xlgprdp327za2gy0nnc6xj69"))))
    (build-system python-build-system)
    (home-page "http://github.com/verigak/progress/")
    (synopsis "Progress reporting bars for Python")
    (description "This Python package provides progress reporting for visual
of progress of long running operations.  There are multiple choices of
progress bars and spinners, with customizable options, such as width, fill
character, and suffix.")
    (license license:isc)))

(define-public python-progressbar2
  (package
    (name "python-progressbar2")
    (version "3.51.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progressbar2" version))
       (sha256
        (base32
         "0b2v3mim90rmfvixkaniz2qrs650sk230rzgd5zhcjfldmlqgxpc"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-utils))
    (native-inputs
     (list python-flake8
           python-freezegun
           python-pycodestyle
           python-pytest
           python-pytest-cache
           python-pytest-cov
           python-pytest-flakes
           python-pytest-pep8
           python-sphinx))
    (home-page "https://github.com/WoLpH/python-progressbar")
    (synopsis "Text progress bar library for Python")
    (description
     "This package provides a Python progressbar library to provide
visual (yet text based) progress to long running operations.")
    (license license:bsd-3)))

(define-public python-progressbar33
  (package
    (name "python-progressbar33")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progressbar33" version))
       (sha256
        (base32
         "1zvf6zs5hzrc03p9nfs4p16vhilqikycvv1yk0pxn8s07fdhvzji"))))
    (build-system python-build-system)
    (home-page "https://github.com/germangh/python-progressbar")
    (synopsis "Text progress bar library for Python")
    (description
     "This package provides a text progress bar library for Python.  This
version only differs from the original @code{progressbar} package in that it
uses relative package imports instead of absolute imports, which is necessary
for the module to work under Python 3.3.")
    ;; Either or both of these licenses may be selected.
    (license (list license:lgpl2.1+ license:bsd-3))))

(define-public python-colorama
  (package
   (name "python-colorama")
   (version "0.4.4")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "colorama" version))
     (sha256
      (base32 "16w62sm95hmh55rqxn4zwdz0bkh3fqm1qnz9cwi3s510iasb4har"))))
   (build-system python-build-system)
   (synopsis "Colored terminal text rendering for Python")
   (description "Colorama is a Python library for rendering colored terminal
text.")
   (home-page "https://pypi.org/project/colorama/")
   (license license:bsd-3)))

;; awscli and botocore do not accept version 0.4.4
(define-public python-colorama-for-awscli
  (package
    (inherit python-colorama)
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorama" version))
       (sha256
        (base32 "189n8hpijy14jfan4ha9f5n06mnl33cxz7ay92wjqgkr639s0vg9"))))))

(define-public python-moto
  (package
    (name "python-moto")
    (version "3.1.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "moto" version))
              (sha256
               (base32 "0dfnad1f9d5ybabs69dzc7x357z1r4jbhrhgw57gyic1qnmcw864"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-hardcoded-executable-names
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((bash-exec (search-input-file inputs "/bin/sh")))
               (substitute* "moto/batch/models.py"
                 (("/bin/sh") bash-exec))
               (substitute* (find-files "tests" "\\.py$")
                 (("#!/bin/bash") (string-append "#!" bash-exec))))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv" "-m" "not network" "-k"
                       (string-append
                        ;; XXX: This test is timing sensitive and may
                        ;; fail non-deterministically.
                        "not test_cancel_pending_job"
                        ;; These tests require Docker.
                        " and not test_terminate_job"
                        " and not test_invoke_function_from_sqs_exception"
                        " and not test_create_custom_lambda_resource__verify_cfnresponse_failed"
                        " and not test_lambda_function"

                        ;; These tests also require the network.
                        " and not test_put_record_batch_http_destination"
                        " and not test_put_record_http_destination"
                        " and not test_dependencies"
                        " and not test_cancel_running_job"
                        " and not test_container_overrides"))))))))
    (native-inputs
     (list python-flask
           python-flask-cors
           python-freezegun
           python-graphql-core
           python-pytest
           python-sure))
    (inputs
     (list bash-minimal))
    (propagated-inputs
     (list python-aws-xray-sdk
           python-boto3
           python-botocore
           python-cfn-lint
           python-cryptography
           python-dateutil
           python-docker
           python-importlib-metadata
           python-jinja2
           python-jose
           python-jsondiff
           python-markupsafe
           python-pytz
           python-pyyaml
           python-requests
           python-responses
           python-sshpubkeys
           python-werkzeug
           python-xmltodict))
    (home-page "https://github.com/spulec/moto")
    (synopsis "Mock out the boto library")
    (description
     "@code{moto} is a library designed to easily mock out the
@code{boto} library.")
    (license license:asl2.0)))

(define-public python-rsa
  (package
   (name "python-rsa")
   (version "3.4.2")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "rsa" version))
     (sha256
      (base32
       "1dcxvszbikgzh99ybdc7jq0zb9wspy2ds8z9mjsqiyv3q884xpr5"))))
   (build-system python-build-system)
   (propagated-inputs
    (list python-pyasn1))
   (synopsis "Pure-Python RSA implementation")
   (description "Python-RSA is a pure-Python RSA implementation.  It supports
encryption and decryption, signing and verifying signatures, and key
generation according to PKCS#1 version 1.5.  It can be used as a Python
library as well as on the command line.")
   (home-page "https://stuvel.eu/rsa")
   (license license:asl2.0)))

(define-public python-pluggy
  (package
   (name "python-pluggy")
   (version "0.13.1")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "pluggy" version))
     (sha256
      (base32
       "1c35qyhvy27q9ih9n899f3h4sdnpgq027dbiilly2qb5cvgarchm"))))
   (build-system python-build-system)
   (native-inputs
    (list python-setuptools-scm))
   (synopsis "Plugin and hook calling mechanism for Python")
   (description "Pluggy is an extraction of the plugin manager as used by
Pytest but stripped of Pytest specific details.")
   (home-page "https://pypi.org/project/pluggy/")
   (license license:expat)))

(define-public python-plumbum
  (package
    (name "python-plumbum")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "plumbum" version))
       (sha256
        (base32 "1kidj821k79dw064rlxh84xamb9h79ychg3pgj81jlvm5hs48xri"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;no tests
    (native-inputs
     ;; XXX: Not actually used since there are no tests but required for
     ;; build.
     (list python-pytest))
    (home-page "https://plumbum.readthedocs.io")
    (synopsis "Python shell combinators library")
    (description
     "Plumbum is a library of tools for replacing shell scripts with Python
code.")
    (license license:expat)))

(define-public python-deprecation
  (package
    (name "python-deprecation")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "deprecation" version))
       (sha256
        (base32
         "1zqqjlgmhgkpzg9ss5ki8wamxl83xn51fs6gn2a8cxsx9vkbvcvj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-packaging))
    (native-inputs
     (list python-unittest2))
    (home-page "https://deprecation.readthedocs.io/")
    (synopsis "Python library to handle automated deprecations")
    (description
     "This is a library that enables automated deprecations.  It offers the
@code{deprecated()} decorator to wrap functions, providing proper warnings
both in documentation and via Python’s warnings system, as well as the
@code{deprecation.fail_if_not_removed()} decorator for test methods to ensure
that deprecated code is eventually removed.")
    (license license:asl2.0)))

(define-public python-jmespath
  (package
   (name "python-jmespath")
   (version "1.0.0")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "jmespath" version))
     (sha256
      (base32
       "0pmzfi230zfgiq2rz896kbb9f7mp0lnrjdl6x1npvxfixn0f5454"))))
   (build-system python-build-system)
   (native-inputs
    (list python-nose))
   (synopsis "JSON Matching Expressions")
   (description "JMESPath (pronounced “james path”) is a Python library that
allows one to declaratively specify how to extract elements from a JSON
document.")
   (home-page "https://github.com/jmespath/jmespath.py")
   (license license:expat)))

(define-public python-symengine
  (package
    (name "python-symengine")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "symengine" version))
       (sha256
        (base32 "0qjgdbnb10kfk7jdhxnzfl8cpaps81k8vap7gm7q9ym3pgslazhg"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (if tests?
                  ;; Run tests against installed package.
                  (with-directory-excursion "/tmp"
                    (invoke "nosetests" "-v" "symengine.tests"))
                  (format #t "test suite not run~%")))))))
    (native-inputs
     (list cmake python-cython python-nose))
    (inputs
     (list symengine))
    (home-page "https://github.com/symengine/symengine.py")
    (synopsis "Python library providing wrappers to SymEngine")
    (description
     "This library provides a Python wrapper to SymEngine, a fast C++ symbolic
manipulation library.")
    (license license:expat)))

(define-public python-uncertainties
  (package
    (name "python-uncertainties")
    (version "3.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "uncertainties" version))
       (sha256
        (base32
         "00z9xl40czmqk0vmxjvmjvwb41r893l4dad7nj1nh6blw3kw28li"))))
    (build-system python-build-system)
    ;; While there are test files, there is no "tests" directory, so the tests
    ;; fail.
    (arguments '(#:tests? #false))
    (propagated-inputs
     (list python-future))
    (native-inputs
     (list python-nose python-numpy))
    (home-page "https://uncertainties-python-package.readthedocs.io/")
    (synopsis "Calculations with uncertainties")
    (description
     "The uncertainties package transparently handles calculations with
numbers with uncertainties. It can also yield the derivatives of any
expression.")
    (license license:bsd-3)))

(define-public python-unicodedata2
  (package
    (name "python-unicodedata2")
    (version "14.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "unicodedata2" version))
       (sha256
        (base32 "110nnvh02ssp92xbmswy39aa186jrmb7m41x4220wigl8c0dzxs1"))))
    (build-system python-build-system)
    (home-page "https://github.com/fonttools/unicodedata2")
    (synopsis "Python unicodedata backport")
    (description "This package corresponds to the latest @code{unicodedata}
standard Python module.")
    (license license:asl2.0)))

(define-public python-asteval
  (package
    (name "python-asteval")
    (version "0.9.23")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asteval" version))
       (sha256
        (base32
         "0f54sd4w1a72ij1bcxs2x7dk9xf8bzclawijf1z18bqx9f96l2gm"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/newville/asteval")
    (synopsis "Minimalistic evaluator of Python expressions")
    (description
     "This package provides a minimalistic evaluator of Python expression
using the @code{ast} module")
    (license license:expat)))

(define-public python-lmfit
  (package
    (name "python-lmfit")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lmfit" version))
       (sha256
        (base32
         "0iab33jjb60f8kn0k0cqb0vjp1mdskks2n3kpn97zkw5cvjhq2b7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-asteval python-numpy python-scipy python-uncertainties))
    (native-inputs
     (list python-pytest))
    (home-page "https://lmfit.github.io/lmfit-py/")
    (synopsis "Least-Squares minimization with bounds and constraints")
    (description
     "Lmfit provides a high-level interface to non-linear optimization and
curve fitting problems for Python.  It builds on and extends many of the
optimization methods of @code{scipy.optimize}.  Initially inspired by (and
named for) extending the Levenberg-Marquardt method from
@code{scipy.optimize.leastsq}, lmfit now provides a number of useful
enhancements to optimization and data fitting problems.")
    (license license:bsd-3)))

(define-public python-bokeh
  (package
    (name "python-bokeh")
    (version "2.4.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bokeh" version))
              (sha256
               (base32
                "00sbhya9vfdv3yi07j6mxwx1x1h9497nhd3smdjrcdxgc48q0czg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; These require selenium.
               (delete-file "tests/unit/bokeh/io/test_export.py")
               (delete-file "tests/unit/bokeh/io/test_webdriver.py")
               (delete-file "tests/unit/bokeh/embed/test_standalone.py")

               ;; Doesn't find ManagedServerLoop fixture
               (delete-file "tests/unit/bokeh/test_client_server.py")

               ;; This fails because of the Guix wrapper around pytest
               (delete-file "tests/unit/bokeh/io/test_util__io.py")

               ;; Fixture ipython not found.
               (delete-file "tests/unit/bokeh/application/handlers/test_notebook__handlers.py")
               (delete-file "tests/unit/bokeh/command/subcommands/test_info.py")

               ;; pd fixture not found.
               (delete-file "tests/unit/bokeh/models/test_mappers.py")
               (delete-file "tests/unit/bokeh/models/util/test_structure.py")
               (delete-file "tests/unit/bokeh/plotting/test__plot.py")
               (delete-file "tests/unit/bokeh/plotting/test__graph.py")
               (delete-file "tests/unit/bokeh/plotting/test_figure.py")
               (delete-file "tests/unit/bokeh/core/test_json_encoder.py")
               (delete-file "tests/unit/bokeh/core/property/test_bases.py")
               (delete-file "tests/unit/bokeh/core/property/test_container.py")
               (delete-file "tests/unit/bokeh/core/property/test_dataspec.py")
               (delete-file "tests/unit/bokeh/core/property/test_datetime.py")
               (delete-file "tests/unit/bokeh/core/property/test_pandas.py")

               ;; nx fixture not found.
               (delete-file "tests/unit/bokeh/plotting/test_graph.py")
               (delete-file "tests/unit/bokeh/models/test_graphs.py")
               (delete-file "tests/unit/bokeh/io/test_showing.py")
               (delete-file "tests/unit/bokeh/document/test_events__document.py")

               ;; These tests need external sample data
               (delete-file-recursively "tests/unit/bokeh/sampledata/")

               ;; Attempts to install something via npm.
               (delete-file "tests/unit/bokeh/test_ext.py")

               ;; More failures due to set up problems.
               (delete-file "tests/unit/bokeh/server/test_server__server.py")
               (delete-file "tests/unit/bokeh/server/test_tornado__server.py")
               (delete-file "tests/unit/bokeh/util/test_serialization.py")
               (delete-file "tests/unit/bokeh/util/test_hex.py")
               (delete-file "tests/unit/bokeh/models/test_sources.py")
               (delete-file "tests/unit/bokeh/embed/test_bundle.py")

               (invoke "pytest" "-v")))))))
    (propagated-inputs
     (list node-lts
           python-jinja2
           python-numpy
           python-packaging
           python-pillow
           python-pyyaml
           python-tornado
           python-typing-extensions))
    (native-inputs
     (list python-beautifulsoup4
           python-dateutil
           python-flaky
           python-nbconvert
           python-pandas
           python-pytest
           python-pytz
           python-requests))
    (home-page "https://github.com/bokeh/bokeh")
    (synopsis "Interactive plots and applications in the browser from Python")
    (description
     "This package provides tools for interactive plots and applications in the
browser from Python.")
    (license license:bsd-3)))

(define-public python-boto
  (package
    (name "python-boto")
    (version "2.49.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "boto" version))
              (sha256
               (base32
                "0njy09c4wjx7ipxhwi6vv404nflyiasl78vwwxxpclnql903n3ga"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: This package is unmaintained and has problems with newer versions
     ;; of Python 3 as well as test libraries.  'python-moto' still uses a
     ;; subset of this library, so keep it around for now, but disable tests.
     '(#:tests? #f))
    (propagated-inputs
     (list python-paramiko python-requests))
    (home-page "https://github.com/boto/boto")
    (synopsis "Python interfaces for Amazon Web Services")
    (description
     "This package provides various facilities for interacting with Amazon
Web Services through Python.

This software is unmaintained, and new projects should use @code{boto3} instead.")
    (license license:expat)))

(define-public python-botocore
  ;; Note: When updating botocore, also make sure that boto3 and awscli
  ;; are compatible.
  (package
    (name "python-botocore")
    (version "1.24.35")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "botocore" version))
       (sha256
        (base32
         "0rv8mvhq5s373zdjs2yb45hzvqcqdh2lp2rbb21jjc8ciwnl5d9n"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Many tests are failing.
     '(#:tests? #f))
    (propagated-inputs
     (list python-dateutil python-jmespath python-urllib3))
    (home-page "https://github.com/boto/botocore")
    (synopsis "Low-level interface to AWS")
    (description "Botocore is a Python library that provides a low-level
interface to the Amazon Web Services (AWS) API.")
    (license license:asl2.0)))

(define-public python-boto3
  (package
    (name "python-boto3")
    (version "1.21.35")
    (home-page "https://github.com/boto/boto3")
    (source (origin
              (method git-fetch)
              (uri (git-reference (url home-page) (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1kdyf238rpfldnpzs0rdh3nhjn6hwfym4faskyhzlgzkf1smmbg1"))))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-network-tests
           ;; Deleting integration tests because they are trying to connect to AWS.
           (lambda _
             (delete-file-recursively "tests/integration")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-v")))))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose python-mock python-pytest))
    (propagated-inputs
     (list python-botocore python-jmespath python-s3transfer))
    (synopsis "AWS SDK for Python")
    (description
     "Boto3 is a Python library for writing programs that interact with
@acronym{AWS,Amazon Web Services}.")
    (license license:asl2.0)))

(define-public python-pyfiglet
  (package
    (name "python-pyfiglet")
    (version "0.8.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyfiglet" version))
       (sha256
        (base32
         "0f9n2076ga2ccsg174k2d7n0z4d44ml96yzc72s6g4nhalbk5hn6"))))
    (build-system python-build-system)
    (home-page "https://github.com/pwaller/pyfiglet")
    (synopsis "Draw ASCII art big letters in Python")
    (description "This module lets you draw large letter from ordinary characters
in pure Python.")
    (license license:expat)))

(define-public python-xdo
  (package
    (name "python-xdo")
    (version "0.3")
    (source (origin
              (method url-fetch)
              (uri (string-append
                    "http://http.debian.net/debian/pool/main/p/python-xdo/"
                    "python-xdo_" version ".orig.tar.gz"))
              (sha256
               (base32
                "1vqh1n5yy5dhnq312kwrl90fnck4v26is3lq3lxdvcn60vv19da0"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'install 'patch-libxdo-path
           ;; Hardcode the path of dynamically loaded libxdo library.
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((libxdo (string-append
                            (assoc-ref inputs "xdotool")
                            "/lib/libxdo.so"))
                   (libc (string-append
                          (assoc-ref inputs "libc")
                          "/lib/libc.so.6")))
               (substitute* "xdo/_xdo.py"
                 (("find_library\\(\"xdo\"\\)")
                  (simple-format #f "\"~a\"" libxdo))
                 (("ctypes\\.util\\.find_library\\('libc'\\)")
                  (simple-format #f "\"~a\"" libc)))
               #t))))
       #:tests? #f))  ; no tests provided
    (propagated-inputs
     (list python-six))
    (inputs
     `(("xdotool" ,xdotool)
       ("libX11" ,libx11)))
    (home-page "https://tracker.debian.org/pkg/python-xdo")
    (synopsis "Python library for simulating X11 keyboard/mouse input")
    (description "Provides bindings to libxdo for manipulating X11 via simulated
input.  (Note that this is mostly a legacy library; you may wish to look at
python-xdo for newer bindings.)")
    (license license:bsd-3)))

(define-public python-xdoctest
  (package
    (name "python-xdoctest")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xdoctest" version))
       (sha256
        (base32 "0bgbmb9nqv95f9gfxqifqff1qaz5fnanjqy4hv7ygrjp2kksgfvy"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     ;; A writable HOME is needed by the
                     ;; 'import_module_from_path' test.
                     (setenv "HOME" "/tmp")
                     (invoke "pytest" "-vv")))))))
    (propagated-inputs (list python-six))
    (native-inputs (list python-pytest which))
    (home-page "https://github.com/Erotemic/xdoctest")
    (synopsis "Rewrite of the Python builtin doctest module")
    (description "This package provides a rewrite of the builtin doctest
module which leverages the Python @acronym{AST, Abstract Syntax Tree} instead
of @acronym{REGEXPs, regular expressions}.")
    (license license:asl2.0)))

(define-public python-mako
  (package
    (name "python-mako")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Mako" version))
       (sha256
        (base32
         "09ywrmhr6gdyfx6d5727wwjnz73i6rklqcb4c14m7sqc830wi5c1"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "nosetests" "-v")
                          (format #t "test suite not run~%"))
                      #t)))))
    (propagated-inputs
     (list python-markupsafe))
    (native-inputs
     (list python-mock python-nose))
    (home-page "https://www.makotemplates.org/")
    (synopsis "Templating language for Python")
    (description "Mako is a templating language for Python that compiles
templates into Python modules.")
    (license license:expat)))

(define-public python-waitress
  (package
    (name "python-waitress")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "waitress" version))
       (patches (search-patches "python-waitress-fix-tests.patch"))
       (sha256
        (base32
         "1a85gyji0kajc3p0s1pwwfm06w4wfxjkvvl4rnrz3h164kbd6g6k"))))
    (build-system python-build-system)
    (home-page "https://github.com/Pylons/waitress")
    (synopsis "Waitress WSGI server")
    (description "Waitress is meant to be a production-quality pure-Python WSGI
server with very acceptable performance.")
    (license license:zpl2.1)))

(define-public python-whichcraft
  (package
    (name "python-whichcraft")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "whichcraft" version))
       (sha256
        (base32
         "11yfkzyplizdgndy34vyd5qlmr1n5mxis3a3svxmx8fnccdvknxc"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/pydanny/whichcraft")
    (synopsis "Cross-platform cross-python shutil.which functionality")
    (description
     "This package provides a shim of the shutil.which function that's
designed to work across multiple versions of Python.")
    (license license:bsd-3)))

(define-public python-cookiecutter
  (package
    (name "python-cookiecutter")
    (version "1.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cookiecutter" version))
       (sha256
        (base32 "0mx49whhwcxmvcak27zr7p7ndzkn3w7psfd7fzh3n91fi1r4v6kb"))))
    (build-system python-build-system)
    (native-inputs
     (list python-freezegun python-pytest python-pytest-catchlog
           python-pytest-cov python-pytest-mock))
    (propagated-inputs
     (list python-binaryornot
           python-click
           python-future
           python-jinja2
           python-jinja2-time
           python-poyo
           python-requests
           python-slugify
           python-text-unidecode
           python-whichcraft))
    (home-page "https://github.com/cookiecutter/cookiecutter")
    (synopsis
     "Command-line utility that creates projects from project templates")
    (description
     "This package provides a command-line utility that creates projects from
project templates, e.g. creating a Python package project from a Python package
project template.")
    (license license:bsd-3)))

(define-public python-pyquery
  (package
    (name "python-pyquery")
    (version "1.2.17")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyquery" version))
       (sha256
        (base32
         "1xia20wm0vx5dk85kcwgh13bylz8qh47ffjxssd2586r60xi783a"))))
    (build-system python-build-system)
    (native-inputs
     (list python-webob python-webtest))
    (propagated-inputs
     (list python-lxml python-cssselect))
    (home-page "https://github.com/gawel/pyquery")
    (synopsis "Make jQuery-like queries on xml documents")
    (description "pyquery allows you to make jQuery queries on xml documents.
The API is as much as possible the similar to jQuery.  pyquery uses lxml for
fast xml and html manipulation.")
    (license license:bsd-3)))

(define-public python-anyjson
  (package
    (name "python-anyjson")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "anyjson" version))
       (sha256
        (base32
         "1fjph4alvcscsl5d4b6qpv1yh31jy05jxi1l0xff7lws7j32v09p"))))
    (build-system python-build-system)
    (arguments
     `(;; We could possibly get tests working, but on Python 3 it's not so easy.
       ;; Very strangely, 2to3 is run *during setup.py install* (or bdist, or
       ;; whatever) so this transformation needs to be done before the tests
       ;; can be run.  Maybe we could add a build step to transform beforehand
       ;; but it could be annoying/difficult.
       ;; We can enable tests for the Python 2 version, though, and do below.
       #:tests? #f))
    (home-page "https://bitbucket.org/runeh/anyjson/")
    (synopsis
     "Wraps best available JSON implementation in a common interface")
    (description
     "Anyjson loads whichever is the fastest JSON module installed
and provides a uniform API regardless of which JSON implementation is used.")
    (license license:bsd-3)))

(define-public python-amqp
  (package
    (name "python-amqp")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "amqp" version))
       (sha256
        (base32 "1qmmffiy48nady7is8529vxcyqbq88v5zgawqr3fk4q8rkz166rc"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv"
                        "-c" "/dev/null" ;take control over pytest options
                        ;; Integration tests require network connectivity.
                        "--ignore" "t/integration")))))))
    (native-inputs (list python-pytest))
    (propagated-inputs (list python-vine))
    (home-page "https://github.com/celery/py-amqp")
    (synopsis "Low-level AMQP client for Python (fork of amqplib)")
    (description
     "This is a fork of amqplib which was originally written by Barry Pederson.
It is maintained by the Celery project, and used by kombu as a pure python
alternative when librabbitmq is not available.")
    (license license:lgpl2.1+)))

(define-public python-beniget
  (package
    (name "python-beniget")
    (version "0.4.1")
    (home-page "https://github.com/serge-sans-paille/beniget")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beniget" version))
       (sha256
        (base32 "035c4f78yllpw2c5p1w92520rilm7nnpsqh7yvi3qmfhi8xlnmbm"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-gast))
    (synopsis "Extract semantic information about static Python code")
    (description
     "Beniget is a collection of analyzers for Python @acronym{AST,
Abstract Syntax Tree}.  It is a building block for writing a static analyzer
or compiler for Python.")
    (license license:bsd-3)))

(define-public python-txamqp
  (package
    (name "python-txamqp")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "txAMQP" version))
       (sha256
        (base32
         "0jd9864k3csc06kipiwzjlk9mq4054s8kzk5q1cfnxj8572s4iv4"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-twisted))
    (home-page "https://github.com/txamqp/txamqp")
    (synopsis "Communicate with AMQP peers and brokers using Twisted")
    (description
     "This package provides a Python library for communicating with AMQP peers
and brokers using the asynchronous networking framework Twisted.  It contains
all the necessary code to connect, send and receive messages to/from an
AMQP-compliant peer or broker (Qpid, OpenAMQ, RabbitMQ) using Twisted.  It
also includes support for using Thrift RPC over AMQP in Twisted
applications.")
    (license license:asl2.0)))

(define-public python-kombu
  (package
    (name "python-kombu")
    (version "5.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kombu" version))
       (sha256
        (base32 "044ng79gj04668kf5fmy7fjkw8302xyapskkn65ym52zfbpf7kip"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv"
                        ;; The transport tests attempt to pass messages to
                        ;; many different databases.
                        "--ignore" "t/unit/transport")))))))
    (native-inputs
     (list python-case python-pyro4 python-pytest-sugar
           python-pytest python-pytz))
    (propagated-inputs
     (list python-amqp python-cached-property python-vine))
    (home-page "https://kombu.readthedocs.io")
    (synopsis "Message passing library for Python")
    (description "The aim of Kombu is to make messaging in Python as easy as
possible by providing an idiomatic high-level interface for the AMQ protocol,
and also provide proven and tested solutions to common messaging problems.
AMQP is the Advanced Message Queuing Protocol, an open standard protocol for
message orientation, queuing, routing, reliability and security, for which the
RabbitMQ messaging server is the most popular implementation.")
    (license license:bsd-3)))

(define-public python-billiard
  (package
    (name "python-billiard")
    (version "3.6.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "billiard" version))
       (sha256
        (base32 "0ismj2p8c66ykpss94rs0bfra5agxxmljz8r3gaq79r8valfb799"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-win-files
           (lambda _
             (for-each delete-file-recursively
                       ;; test_multiprocessing seem to be written in Python2.
                       '("t/integration/tests/test_multiprocessing.py"
                         "t/unit/test_win32.py"
                         "billiard/popen_spawn_win32.py"
                         "billiard/_win.py")))))))
    (native-inputs
     (list python-case python-psutil python-pytest))
    (home-page "https://github.com/celery/billiard")
    (synopsis "Python multiprocessing fork with improvements and bugfixes")
    (description
     "Billiard is a fork of the Python 2.7 multiprocessing package.  The
multiprocessing package itself is a renamed and updated version of R Oudkerk's
pyprocessing package.  This standalone variant is intended to be compatible with
Python 2.4 and 2.5, and will draw its fixes/improvements from python-trunk.")
    (license license:bsd-3)))

(define-public python-celery
  (package
    (name "python-celery")
    (version "5.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "celery" version))
       (sha256
        (base32 "109lcqarrbmh95sk1dm4yxayq1h3i27f4w23ndk64mqgyfnqqffi"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "requirements/default.txt"
               (("pytz.*")
                "pytz\n"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "pytest" "t"
                       "--ignore" "t/integration" ;hangs tests
                       ;; The MongoDB backend test appears to expect an older
                       ;; version of MongoDB which provided its own bson
                       ;; module, fails with " AttributeError: module 'bson'
                       ;; has no attribute 'encode'".
                       "--ignore" "t/unit/backends/test_mongodb.py"
                       ;; AssertionErrors
                       "-k" "not test_check_privileges_no_fchown ")))))))
    (native-inputs
     (list python-case
           python-dnspython
           python-flaky
           python-iniconfig
           python-moto
           python-msgpack
           python-pytest
           python-pytest-celery
           python-pytest-subtests
           python-pytest-timeout
           python-toml))
    (propagated-inputs
     (list python-billiard
           python-click
           python-click-didyoumean
           python-click-plugins
           python-click-repl
           python-kombu
           python-pytz
           python-vine))
    (home-page "https://celeryproject.org")
    (synopsis "Distributed Task Queue")
    (description "Celery is an asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation, but
supports scheduling as well.  The execution units, called tasks, are executed
concurrently on a single or more worker servers using multiprocessing,
Eventlet, or gevent.  Tasks can execute asynchronously (in the background) or
synchronously (wait until ready).")
    (license license:bsd-3)))

(define-public python-translitcodec
  (package
    (name "python-translitcodec")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "translitcodec" version))
       (sha256
        (base32
         "10x6pvblkzky1zhjs8nmx64nb9jdzxad4bxhq4iwv0j4z2aqjnki"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))  ; no tests provided
    (home-page
     "https://github.com/claudep/translitcodec")
    (synopsis
     "Unicode to 8-bit charset transliteration codec")
    (description
     "This package contains codecs for transliterating ISO 10646 texts into
best-effort representations using smaller coded character sets (ASCII,
ISO 8859, etc.).")
    (license license:expat)))

(define-public python-anyqt
  (package
    (name "python-anyqt")
    (version "0.0.13")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "AnyQt" version))
       (sha256
        (base32 "0z7myf0mp1qx4gza6ncqyq9whk67vblmh9n3klk19dv4aakjml2f"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ;there are no tests
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-files
           ;; Delete files related to other operating systems.
           (lambda _
             (delete-file "AnyQt/QtMacExtras.py")
             (delete-file "AnyQt/QtWinExtras.py"))))))
    (home-page "https://github.com/ales-erjavec/anyqt")
    (synopsis "PyQt4/PyQt5 compatibility layer")
    (description "AnyQt is a PyQt4/PyQt5 compatibility layer.")
    (license license:gpl3)))

(define-public python-pyqtgraph
  (package
    (name "python-pyqtgraph")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyqtgraph" version))
       (sha256
        (base32 "0kc7ncv0lr3spni29i9g8nszyr4xinswqi2zzs6v8kqqi593pvyj"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-home-and-qpa
           (lambda _
             (setenv "HOME" "/tmp")
             (setenv "QT_QPA_PLATFORM" "offscreen")
             #t))
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "pytest" "-vv" "-k"
                     (string-append
                      ;; These tests try to download online data.
                      "not test_PolyLineROI"
                      " and not test_getArrayRegion_axisorder"
                      " and not test_getArrayRegion"
                      " and not test_PlotCurveItem"
                      " and not test_NonUniformImage_colormap"
                      " and not test_NonUniformImage_lut"
                      " and not test_ImageItem_axisorder"
                      " and not test_ImageItem"
                      ;; The test_reload test fails and suggests adding
                      ;; "--assert=plain" to the pytest command, but it
                      ;; doesn't solve the failure.
                      " and not test_reload")))))))
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-xdist))
    (inputs
     (list qtbase-5))
    (propagated-inputs
     (list python-h5py python-numpy python-pyopengl python-scipy
           python-pyqt-without-qtwebkit))
    (home-page "http://www.pyqtgraph.org")
    (synopsis "Scientific graphics and GUI library for Python")
    (description
     "PyQtGraph is a Pure-python graphics library for PyQt5, PyQt6, PySide2
and PySide6.  It is intended for use in mathematics, scientific or engineering
applications.")
    (license license:expat)))

(define-public python-qasync
  (package
    (name "python-qasync")
    (version "0.22.0")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/CabbageDevelopment/qasync/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q9cllrwf94whr0f6mipa0hdq1rcyqvklwx19g35g2dav8f3xkjl"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"
       #:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-qpa
           (lambda _
             (setenv "QT_QPA_PLATFORM" "offscreen"))))))
    (native-inputs
     (list python-pytest python-pytest-runner))
    (propagated-inputs
     (list python-pyqt))
    (home-page "https://github.com/CabbageDevelopment/qasync")
    (synopsis "Implementation of the PEP 3156 Event-Loop with Qt")
    (description
     "@code{qasync} allows coroutines to be used in PyQt/PySide applications
by providing an implementation of the PEP 3156 event-loop.")
    (license license:bsd-2)))

(define-public python-editor
  (package
  (name "python-editor")
  (version "1.0.4")
  (source
    (origin
      (method url-fetch)
      (uri (pypi-uri "python-editor" version))
      (sha256
        (base32
          "0yrjh8w72ivqxi4i7xsg5b1vz15x8fg51xra7c3bgfyxqnyadzai"))))
  (build-system python-build-system)
  (arguments
   '(#:tests? #f))   ;XXX: needs a TTY and an editor
  (home-page "https://github.com/fmoo/python-editor")
  (synopsis "Programmatically open an editor, capture the result")
  (description
    "python-editor is a library that provides the editor module for
programmatically interfacing with your system's $EDITOR.")
  (license license:asl2.0)))

(define-public python-multiprocessing-logging
  (package
    (name "python-multiprocessing-logging")
    (version "0.3.1")
    (home-page "https://github.com/jruere/multiprocessing-logging")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1625wy3djlr3b2fpd3vi822f8gw6b75mnls5a4318dbi9za5pf0y"))))
    (build-system python-build-system)
    (synopsis "Manage logs from multiple processes")
    (description
     "This Python module implements a multiprocessing-aware @code{Handler}
that, when set on the root @code{Logger}, will tunnel log records to the
main process so that they are handled correctly.")
    (license license:lgpl3+)))

(define-public python-vobject
  (package
    (name "python-vobject")
    (version "0.9.6.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "vobject" version))
              (sha256
               (base32
                "0081g4gngw28j7vw8101jk600wz4gzfrhf5myrqvn2mrfkn2llcn"))))
    (build-system python-build-system)
    (arguments
     '(;; The test suite relies on some non-portable Windows interfaces.
       #:tests? #f))
    (propagated-inputs
     (list python-dateutil python-pyicu))
    (synopsis "Parse and generate vCard and vCalendar files")
    (description "Vobject is intended to be a full featured Python package for
parsing and generating vCard and vCalendar files.  Currently, iCalendar files
are supported and well tested.  vCard 3.0 files are supported, and all data
should be imported, but only a few components are understood in a sophisticated
way.")
    (home-page "https://eventable.github.io/vobject/")
    (license license:asl2.0)))

(define-public python-munkres
  (package
    (name "python-munkres")
    (version "1.1.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "munkres" version))
              (sha256
               (base32
                "00yvj8bxmhhhhd74v7j0x673is7vizmxwgb3dd5xmnkr74ybyi7w"))))
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-test
           (lambda _
             ;; See https://github.com/bmc/munkres/issues/40
             (substitute* "test/test_munkres.py"
               (("^def test_profit_float" m)
                (string-append "\
import platform
@pytest.mark.skipif(platform.architecture()[0] == \"32bit\",
  reason=\"Fails on 32 bit architectures\")
" m))))))))
    (build-system python-build-system)
    (native-inputs (list python-pytest-6))
    (home-page "https://software.clapper.org/munkres/")
    (synopsis "Implementation of the Munkres algorithm")
    (description "The Munkres module provides an implementation of the Munkres
algorithm (also called the Hungarian algorithm or the Kuhn-Munkres algorithm),
useful for solving the Assignment Problem.")
    (license license:bsd-3)))

(define-public python-whoosh
  (package
    (name "python-whoosh")
    (version "2.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Whoosh" version))
       (sha256
        (base32
         "10qsqdjpbc85fykc1vgcs8xwbgn4l2l52c8d83xf1q59pwyn79bw"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; Test invocation is no longer supported by Python.
    (native-inputs
     (list python-pytest))
    (home-page "https://bitbucket.org/mchaput/whoosh")
    (synopsis "Full text indexing, search, and spell checking library")
    (description
     "Whoosh is a fast, pure-Python full text indexing, search, and spell
checking library.")
    (license license:bsd-2)))

(define-public python-codespell
  (package
    (name "python-codespell")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "codespell" version))
        (sha256
          (base32 "1r9y714cz8m894rxp7pyvicr1lw2iid24vz6fxbl5wzy8ibgxlqr"))))
    (build-system python-build-system)
    (inputs
      (list python-chardet))
    (native-inputs
      (list python-check-manifest python-flake8 python-pytest
            python-pytest-cov python-pytest-dependency))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key outputs tests? #:allow-other-keys)
             (when tests?
               ;; Make installed executable available for running the tests.
               (setenv "PATH"
                       (string-append (assoc-ref outputs "out") "/bin"
                                      ":" (getenv "PATH")))
               (invoke "pytest" "-vv")))))))
    (home-page "https://github.com/codespell-project/codespell/")
    (synopsis "Spellchecker for code")
    (description "Codespell fixes common misspellings in text files.
It's designed primarily for checking misspelled words in source code,
but it can be used with other files as well.  It does not check for word
membership in a complete dictionary, but instead looks for a set of
common misspellings.  Therefore it should catch errors like \"adn\", but
it will not catch \"adnasdfasdf\".  This also means it shouldn't
generate false-positives when you use a niche term it doesn't know
about.")
    (license
      (list
        ; for codespell and codespell_lib
        license:gpl2
        ; for dictionary*.txt
        license:cc-by-sa3.0))))

(define-public python-pathlib
  (package
    (name "python-pathlib")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pathlib" version))
              (sha256
               (base32
                "17zajiw4mjbkkv6ahp3xf025qglkj0805m9s41c45zryzj6p2h39"))))
    (build-system python-build-system)
    ;; The tests depend on the internal "test" module, which does not provide
    ;; a stable interface.
    (arguments `(#:tests? #f))
    (home-page "https://pathlib.readthedocs.org/")
    (synopsis "Object-oriented file system paths")
    (description "Pathlib offers a set of classes to handle file system paths.
It offers the following advantages over using string objects:

@enumerate
@item No more cumbersome use of os and os.path functions.  Everything can
be done easily through operators, attribute accesses, and method calls.
@item Embodies the semantics of different path types.  For example,
comparing Windows paths ignores casing.
@item Well-defined semantics, eliminating any inconsistencies or
ambiguities (forward vs. backward slashes, etc.).
@end enumerate

Note: In Python 3.4, pathlib is now part of the standard library.  For other
Python versions please consider python-pathlib2 instead, which tracks the
standard library module.  This module (python-pathlib) isn't maintained
anymore.")
    (license license:expat)))

(define-public python-jellyfish
  (package
    (name "python-jellyfish")
    (version "0.8.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jellyfish" version))
              (sha256
               (base32
                "0p2s6b30sfffx8sya2i8kz0i0riw9fq1fi0k89s8kdgrmjf0h1h5"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; XXX: Tests cannot find C coded version.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv" "jellyfish/test.py")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/jamesturk/jellyfish")
    (synopsis "Approximate and phonetic matching of strings")
    (description "Jellyfish uses a variety of string comparison and phonetic
encoding algorithms to do fuzzy string matching.")
    (license license:bsd-2)))

(define-public python-pdfminer-six
  (package
    (name "python-pdfminer-six")
    (version "20201018")
    ;; There are no tests in the PyPI tarball.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pdfminer/pdfminer.six")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a2fxxnnjqbx344znpvx7cnv1881dk6585ibw01inhfq3w6yj2lr"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Tests write to the source tree.
         (add-after 'unpack 'make-git-checkout-writable
           (lambda _
             (for-each make-file-writable (find-files "."))
             #t))
         (replace 'check
           (lambda _
             (invoke "make" "test"))))))
    (propagated-inputs
     (list python-chardet python-cryptography python-sortedcontainers))
    (native-inputs
     (list python-nose python-tox))
    (home-page "https://github.com/pdfminer/pdfminer.six")
    (synopsis "PDF parser and analyzer")
    (description "@code{pdfminer.six} is a community maintained fork of
the original PDFMiner.  It is a tool for extracting information from PDF
documents.  It focuses on getting and analyzing text data.  Pdfminer.six
extracts the text from a page directly from the sourcecode of the PDF.  It
can also be used to get the exact location, font or color of the text.")
    (license license:expat)))

(define-public python-rarfile
  (package
    (name "python-rarfile")
    (version "4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rarfile" version))
              (sha256
               (base32
                "1882wv9szcm29mnyhjmspyflyr2l7z73srn14w4dlnww49lqfm37"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ;; The bsdtar utility is very limited and most tests fail.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "rarfile.py"
               ;; Disable unrar and unar, which are unavailable on Guix.
               (("(unrar|unar)=True" all tool) (string-append tool "=False"))
               ;; Hardcode path to bsdtar
               (("\"bsdtar\"")
                (string-append "\"" (assoc-ref inputs "libarchive") "/bin/bsdtar\"")))
             #t))
         (replace 'check
           (lambda* (#:key inputs tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (inputs (list libarchive))
    (home-page "https://github.com/markokr/rarfile")
    (synopsis "RAR archive reader for Python")
    (description "This is Python module for RAR archive reading.  The interface
is made as zipfile like as possible.")
    (license license:isc)))

(define-public python-rich
  (package
    (name "python-rich")
    (version "12.4.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rich" version))
              (sha256
               (base32
                "149vjb4cpf9mz14iig0b6d8065dm8aslp6pc45g9ipmp1wf00ffj"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs tests? #:allow-other-keys)
             (when tests?
               (copy-recursively (string-append
                                  (assoc-ref inputs "tests") "/tests")
                                 "tests")
               (invoke "python" "-m" "pytest" "-vv")))))))
    (propagated-inputs
     (list python-attrs python-colorama python-commonmark python-pygments
           python-typing-extensions))
    (native-inputs
     `(("python-pytest" ,python-pytest)
       ("tests"
        ;; The release on pypi comes without tests.  We can't build from this
        ;; checkout, though, because installation requires an invocation of
        ;; poetry.
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/willmcgugan/rich")
                 (commit (string-append "v" version))))
           (file-name (git-file-name name version))
           (sha256
            (base32
             "17c3gljn8zv32xnpsgd3fqgqn4r7cdfqri41hridcpbhssdgkyp9"))))))
    (home-page "https://github.com/willmcgugan/rich")
    (synopsis "Render rich text and more to the terminal")
    (description
     "This is a Python package for rendering rich text, tables, progress bars,
syntax highlighting, markdown and more to the terminal.")
    (license license:expat)))

(define-public python-textual
  (package
    (name "python-textual")
    (version "0.1.18")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "textual" version))
              (sha256
               (base32
                "08yg5a51hz1axfj5hx28hx31gq5apcj6vpkkmawmiplisa73z25j"))))
    (build-system python-build-system)
    (arguments
     (let ((tests
            ;; The release on pypi comes without tests.  We can't build
            ;; from this checkout, though, because installation requires
            ;; an invocation of poetry.
            (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Textualize/textual")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0b3ycwqhp21mg9fvmadgxhgbvkwq6fd784l2xcmvy77rravrnnax")))))
       (list #:phases
             #~(modify-phases %standard-phases
                 (replace 'check
                   (lambda* (#:key tests? #:allow-other-keys)
                     (when tests?
                       (copy-recursively #$(file-append tests "/tests")
                                         "tests")
                       (invoke "python" "-m" "pytest" "-vv"))))))))
    (propagated-inputs
     (list python-rich python-typing-extensions))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/Textualize/textual")
    (synopsis "Build text user interfaces in Python")
    (description "Textual is a @acronym{TUI, Text User Interface} framework
for Python inspired by modern web development.")
    (license license:expat)))

(define-public python-magic
  (package
    (name "python-magic")
    (version "0.4.24")
    (home-page "https://github.com/ahupp/python-magic")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page) (commit version)))
       (file-name (git-file-name name version))
       (patches (search-patches "python-magic-python-bytecode.patch"))
       (sha256
        (base32
         "17jalhjbfd600lzfz296m0nvgp6c7vx1mgz82jbzn8hgdzknf4w0"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  ;; Replace a specific method call with a hard-coded
                  ;; path to the necessary libmagic.so file in the
                  ;; store.  If we don't do this, then the method call
                  ;; will fail to find the libmagic.so file, which in
                  ;; turn will cause any application using
                  ;; python-magic to fail.
                  (add-before 'build 'hard-code-path-to-libmagic
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((magic (search-input-file inputs "/lib/libmagic.so")))
                        (substitute* "magic/loader.py"
                          (("find_library\\('magic'\\)")
                           (string-append "'" magic "'"))))))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      ;; The test suite mandates this variable.
                      (setenv "LC_ALL" "en_US.UTF-8")
                      (if tests?
                          (with-directory-excursion "test"
                            (invoke "python" "./test.py")
                            (invoke "python" "./libmagic_test.py"))
                          (format #t "test suite not run~%")))))))
    (native-inputs
     (list which))
    (inputs
     ;; python-magic needs to be able to find libmagic.so.
     ;; Use a newer version because 5.39 returns bogus for some archives
     ;; (notably Chromium .crx extensions), which breaks e.g. 'diffoscope'.
     (list file-next))
    (synopsis "File type identification using libmagic")
    (description
     "This module uses ctypes to access the libmagic file type
identification library.  It makes use of the local magic database and
supports both textual and MIME-type output.  Note that this module and
the python-file module both provide a \"magic.py\" file; these two
modules, which are different and were developed separately, both serve
the same purpose: to provide Python bindings for libmagic.")
    (license license:expat)))

(define-public s3cmd
  (package
    (name "s3cmd")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/s3tools/s3cmd")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rdgwwmmp8mdxc84bxq6k9a7v7z2qgc3df47djzs2b84gw81dglx"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'hide-wrapping
                 (lambda _
                   (substitute* "S3/MultiPart.py"
                     (("sys\\.argv\\[0\\]") "\"s3cmd\""))
                   (substitute* "s3cmd"
                     (("optparser\\.get_prog_name\\(\\)") "\"s3cmd\"")))))))
    (inputs
     (list python-dateutil
           python-magic))
    (home-page "https://s3tools.org/s3cmd")
    (synopsis "Command line tool for S3-compatible storage services")
    (description
     "S3cmd is a command line tool for uploading, retrieving and managing data
in storage services that are compatible with the Amazon Simple Storage
Service (S3) protocol, including S3 itself.  It supports rsync-like backup,
GnuPG encryption, and more.  It also supports management of Amazon's
CloudFront content delivery network.")
    (license license:gpl2+)))

(define-public python-pkgconfig
  (package
    (name "python-pkgconfig")
    (version "1.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pkgconfig" version))
        (sha256
          (base32
            "107x2wmchlch8saixb488cgjz9n6inl38wi7nxkb942rbaapxiqb"))))
    (build-system python-build-system)
    (native-inputs
      (list python-nose))
    (inputs
      (list pkg-config))
    (arguments
      `(#:phases
        (modify-phases %standard-phases
          (add-before 'build 'patch
            ;; Hard-code the path to pkg-config.
            (lambda _
              (substitute* "pkgconfig/pkgconfig.py"
                (("'pkg-config'")
                 (string-append "'" (which "pkg-config") "'")))))
          (replace 'check
            (lambda _
              (invoke "nosetests" "test.py"))))))
    (home-page "https://github.com/matze/pkgconfig")
    (synopsis "Python interface for pkg-config")
    (description "This module provides a Python interface to pkg-config.  It
can be used to find all pkg-config packages, check if a package exists,
check if a package meets certain version requirements, query CFLAGS and
LDFLAGS and parse the output to build extensions with setup.py.")
    (license license:expat)))

(define-public python-bz2file
  (package
    (name "python-bz2file")
    (version "0.98")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bz2file" version))
       (sha256
        (base32
         "126s53fkpx04f33a829yqqk8fj4png3qwg4m66cvlmhmwc8zihb4"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; Tests use deprecated python modules.
    (home-page "https://github.com/nvawda/bz2file")
    (synopsis "Read and write bzip2-compressed files")
    (description
     "Bz2file is a Python library for reading and writing bzip2-compressed
files.  It contains a drop-in replacement for the I/O interface in the
standard library's @code{bz2} module, including features from the latest
development version of CPython that are not available in older releases.")
    (license license:asl2.0)))

(define-public python-future
  (package
    (name "python-future")
    (version "0.18.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "future" version))
       (sha256
        (base32
         "0zakvfj87gy6mn1nba06sdha63rn4njm7bhh0wzyrxhcny8avgmi"))))
    (build-system python-build-system)
    ;; Many tests connect to the network or are otherwise flawed.
    ;; https://github.com/PythonCharmers/python-future/issues/210
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (replace 'sanity-check
           (let ((sanity-check (assoc-ref %standard-phases 'sanity-check)))
             (lambda* (#:key inputs outputs #:allow-other-keys #:rest args)
               (let* ((files (find-files (site-packages inputs outputs)
                                         "top_level\\.txt"))
                      (backups (map (lambda (f) (string-append f ".bak"))
                                    files)))
                 (for-each copy-file files backups)
                 (substitute* files
                   ;; Nobody be usin' winreg on Guix
                   ;; Also, don't force users to have tkinter when they don't
                   ;; need it
                   (("(winreg|tkinter)") ""))
                 (apply sanity-check args)
                 (for-each rename-file backups files))))))))
    (home-page "https://python-future.org")
    (synopsis "Single-source support for Python 3 and 2")
    (description
     "@code{python-future} is the missing compatibility layer between Python 2 and
Python 3.  It allows you to use a single, clean Python 3.x-compatible codebase
to support both Python 2 and Python 3 with minimal overhead.")
    (license license:expat)))

(define-public python-cysignals
  (package
    (name "python-cysignals")
    (version "1.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "cysignals" version))
        (sha256
          (base32
            "15ix8crpad26cfl1skyg7qajqqfdrm8q5ahhmlfmqi1aw0jqj2g2"))))
    (build-system python-build-system)
    (native-inputs
      (list python-cython python-sphinx))
    (inputs
      (list pari-gp))
    (arguments
     `(#:modules ((guix build python-build-system)
                  ((guix build gnu-build-system) #:prefix gnu:)
                  (guix build utils))
       ;; FIXME: Tests are executed after installation and currently fail
       ;; when not installing into standard locations; the author is working
       ;; on a fix.
       #:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-before
          'build 'configure
          (assoc-ref gnu:%standard-phases 'configure)))))
    (home-page
      "https://github.com/sagemath/cysignals")
    (synopsis
      "Handling of interrupts and signals for Cython")
    (description
      "The cysignals package provides mechanisms to handle interrupts (and
other signals and errors) in Cython code, using two related approaches,
for mixed Cython/Python code or external C libraries and pure Cython code,
respectively.")
    (license license:lgpl3+)))

(define-public python-rope
  (package
    (name "python-rope")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rope" version))
       (sha256
        (base32
         "0bkzwkllxxdxd3w70xiy137lqvnlmmaplsc2ya3s23ss4kq8y10k"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           `(modify-phases %standard-phases
              (add-after 'unpack 'disable-broken-test
                (lambda _
                  (substitute* "ropetest/contrib/autoimporttest.py"
                    (("def test_search_module")
                     "def __notest_search_module")
                    (("def test_search_submodule")
                     "def __notest_search_submodule")))))))
    (native-inputs
     (list python-pytest-timeout
           python-pytest))
    (home-page "https://github.com/python-rope/rope")
    (synopsis "Refactoring library for Python")
    (description "Rope is a refactoring library for Python.  It facilitates
the renaming, moving and extracting of attributes, functions, modules, fields
and parameters in Python source code.  These refactorings can also be applied
to occurrences in strings and comments.")
    (license license:lgpl3+)))

(define-public python-py3status
  (package
    (name "python-py3status")
    (version "3.21")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py3status" version))
       (sha256
        (base32 "16z8zq83hxy48g6hh4xczbdz50qvxv9k1aahr4fqq7jis60cc262"))))
    (build-system python-build-system)
    (inputs
     (list file))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; 'file' is used for detection of configuration file encoding
         ;; let's make link the dependency to particular input
         (add-before 'build 'patch-file-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((file-path (assoc-ref inputs "file")))
               (substitute* "py3status/parse_config.py"
                 (("\\[\"file\", \"-b\"")
                  (string-append "['" file-path "/bin/file', '-b'")))
               #t))))
       #:tests? #f)) ; TODO: Requires many libraries not in Guix.
    (home-page "https://github.com/ultrabug/py3status")
    (synopsis "Extensible i3status wrapper written in Python")
    (description "py3status is an i3status wrapper which extends i3status
functionality in a modular way, allowing you to extend your panel with your
own code, responding to click events and updating clock every second.")
    (license license:bsd-3)))

(define-public python-tblib
  (package
    (name "python-tblib")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "tblib" version))
              (sha256
               (base32
                "0i136n5pydmd202254wzrdbspkw0br0c9mbxhfs9hpfbahvyx6r2"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "py.test" "-vv" "tests" "README.rst"))))))
    (native-inputs
     (list python-pytest python-six))
    (home-page "https://github.com/ionelmc/python-tblib")
    (synopsis "Traceback serialization library")
    (description
     "Traceback serialization allows you to:

@enumerate
@item Pickle tracebacks and raise exceptions with pickled tracebacks in
different processes.  This allows better error handling when running code over
multiple processes (imagine multiprocessing, billiard, futures, celery etc).

@item Parse traceback strings and raise with the parsed tracebacks.
@end enumerate\n")
    (license license:bsd-3)))

(define-public python-tftpy
  (package
    (name "python-tftpy")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/msoulier/tftpy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1gl04ps8h8r7av3h0zbm8gwmkqs9rkk5vf7n8mv2bzrkwvy9hacc"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? inputs outputs #:allow-other-keys)
                      (when tests?
                        ;; The default DEBUG logging level is way too verbose.
                        (substitute* "t/test.py"
                          (("logging\\.DEBUG")
                           "logging.INFO"))
                        (invoke "python" "-m" "unittest" "t/test.py")))))))
    (home-page "http://tftpy.sourceforge.net/")
    (synopsis "Python trivial file transfer protocol (TFTP) library")
    (description "TFTPy is a trivial file transfer protocol (TFTP) Python
library.  It can be used to act both as a TFTP client or TFTP server.")
    (license license:expat)))

(define-public python-greenlet
  (package
    (name "python-greenlet")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "greenlet" version))
              (sha256
               (base32
                "0jkln5bf6rq7dbvpv7ypin3pp9jqd2jr91yyxlnfcii3msj5w3z3"))))
    (build-system python-build-system)
    (home-page "https://greenlet.readthedocs.io/")
    (synopsis "Lightweight in-process concurrent programming")
    (description
     "Greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called \"tasklets\".  Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads) and
are synchronized with data exchanges on \"channels\".")
    (license (list license:psfl license:expat))))

(define-public python-objgraph
  (package
    (name "python-objgraph")
    (version "3.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "objgraph" version))
       (sha256
        (base32
         "19qmqsh984zq1rzzjy4vqnmviaqnymcyl8h7z99pnicbgwnm2adz"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-graphviz))
    (native-inputs
     (list python-mock graphviz))
    (home-page "https://mg.pov.lt/objgraph/")
    (synopsis "Draw Python object reference graphs with graphviz")
    (description
     "This package provides tools to draw Python object reference graphs with
graphviz.")
    (license license:expat)))

(define-public python-gevent
  (package
    (name "python-gevent")
    (version "21.12.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gevent" version))
              (sha256
               (base32
                "0kh9mmq811mzfgj60n64icybjp4ryjmfmy1vg7x92yrniibn92zl"))
              (modules '((guix build utils)))
              (snippet
               '(begin
                  ;; unbunding libev and c-ares
                  (delete-file-recursively "deps")
                  ;; Remove cythonized files.
                  (with-directory-excursion "src/gevent"
                    (for-each delete-file
                              (append (list "resolver/cares.c"
                                            "queue.c"
                                            "local.c"
                                            "libev/corecext.h"
                                            "libev/corecext.c"
                                            "greenlet.c"
                                            "event.c"
                                            "_waiter.c"
                                            "_tracer.c"
                                            "_semaphore.c"
                                            "_imap.c"
                                            "_ident.c"
                                            "_hub_primitives.c"
                                            "_hub_local.c"
                                            "_greenlet_primitives.c"
                                            "_abstract_linkable.c")
                                      (find-files "." "\\.html$"))))))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((ice-9 ftw)
                  (ice-9 match)
                  (srfi srfi-26)
                  (guix build utils)
                  (guix build python-build-system))
       #:phases (modify-phases %standard-phases
                  (add-before 'patch-source-shebangs 'patch-hard-coded-paths
                    (lambda _
                      (substitute* "src/gevent/subprocess.py"
                        (("/bin/sh") (which "sh")))
                      (for-each (lambda (file)
                                  (substitute* file
                                    (("/bin/sh") (which "sh"))
                                    (("/bin/true") (which "true"))))
                                (find-files "src/greentest" "\\.py$"))))
                  (add-before 'build 'do-not-use-bundled-sources
                    (lambda _
                      (setenv "GEVENTSETUP_EMBED" "0")

                      ;; Prevent building bundled libev.
                      (substitute* "setup.py"
                        (("run_make=_BUILDING")
                         "run_make=False"))))
                  (add-before 'build 'add-greenlet-on-C_INCLUDE_PATH
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((greenlet (string-append
                                       (assoc-ref inputs "python-greenlet")
                                       "/include")))
                        (match (scandir greenlet
                                        (lambda (item)
                                          (string-prefix? "python" item)))
                          ((python)
                           (setenv "C_INCLUDE_PATH"
                                   (string-append greenlet "/" python ":"
                                                  (or (getenv "C_INCLUDE_PATH")
                                                      ""))))))))
                  (add-before 'check 'pretend-to-be-CI
                    (lambda _
                      ;; A few tests are skipped due to network constraints or
                      ;; get longer timeouts when running in a CI environment.
                      ;; Piggy-back on that, as we need the same adjustments.
                      (setenv "TRAVIS" "1")
                      (setenv "APPVEYOR" "1")))
                  (add-before 'check 'adjust-tests
                    (lambda _
                      (let ((disabled-tests
                             '(;; These tests relies on networking which is
                               ;; not available in the build container.
                               "test__getaddrinfo_import.py"
                               "test__server_pywsgi.py"
                               ;; XXX: These tests borrow functionality from the
                               ;; Python builtin 'test' module, but it is not
                               ;; installed with the Guix Python distribution.
                               "test_smtpd.py"
                               "test_wsgiref.py"
                               "test_urllib2.py"
                               "test_thread.py"
                               "test_threading.py"
                               "test__threading_2.py"
                               ;; These tests rely on KeyboardInterrupts which do not
                               ;; work inside the build container for some reason
                               ;; (lack of controlling terminal?).
                               "test_subprocess.py"
                               "test__issues461_471.py"
                               ;; TODO: Patch out the tests that use getprotobyname, etc
                               ;; instead of disabling all the tests from these files.
                               "test__resolver_dnspython.py"
                               "test__doctests.py"
                               "test__all__.py"
                               "test___config.py"
                               "test__execmodules.py"
                               ;; This test contains 'test_unlink', which
                               ;; fails on i686 (see:
                               ;; https://github.com/gevent/gevent/issues/1558).
                               "test__core_stat.py")))
                        (call-with-output-file "skipped_tests.txt"
                          (lambda (port)
                            (format port "~a~%"
                                    (string-join disabled-tests "\n")))))))
                  (replace 'check
                    (lambda _
                      ;; Use the build daemons configured number of workers.
                      (setenv "NWORKERS" (number->string (parallel-job-count)))

                      (invoke "python" "-m" "gevent.tests" "-unone" "--config"
                              "known_failures.py" "--ignore" "skipped_tests.txt"))))))
    (propagated-inputs
     (list python-greenlet python-zope-event python-zope-interface))
    (native-inputs
     (list python-cython
           ;; For tests.
           python-dnspython python-psutil python-objgraph))
    (inputs
     (list c-ares libev))
    (home-page "https://www.gevent.org/")
    (synopsis "Coroutine-based network library")
    (description
     "@code{gevent} is a coroutine-based Python networking library that uses
@code{greenlet} to provide a high-level synchronous API on top of the
@code{libev} event loop.")
    (license license:expat)))

(define-public python-fastimport
  (package
    (name "python-fastimport")
    (version "0.9.9")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "fastimport" version))
        (sha256
          (base32 "06gk14qgm9dxx3pzjn0ckdbywc8ial2bjfzddqwlr4bn1nnqkbll"))))
    (build-system python-build-system)
    (home-page "https://github.com/jelmer/python-fastimport")
    (synopsis "VCS fastimport parser and generator in Python")
    (description "This package provides a parser for and generator of the Git
@url{https://www.kernel.org/pub/software/scm/git/docs/git-fast-import.html,fastimport}
format.")
    (license license:gpl2+)))

(define-public python-twisted
  (package
    (name "python-twisted")
    (version "19.7.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Twisted" version ".tar.bz2"))
              (sha256
               (base32
                "17d3hnxv9qndagzz63mdpyk99xj63p9gq586vjn0rxk8cl197nym"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f                    ; FIXME: some tests fail
       #:phases
       (modify-phases %standard-phases
         ;; Remove scripts, because they depend on [conch]
         (add-after 'unpack 'remove-entrypoint
           (lambda _
             (substitute* "src/twisted/python/_setup.py"
               (("\".+ = twisted\\.conch\\.scripts\\..+\",") "")))))))
    (propagated-inputs
     (list python-zope-interface
           python-pyhamcrest
           python-incremental
           python-hyperlink
           python-constantly
           python-automat))
    (home-page "https://twistedmatrix.com/")
    (synopsis "Asynchronous networking framework written in Python")
    (description
     "Twisted is an extensible framework for Python programming, with special
focus on event-based network programming and multiprotocol integration.")
    (license license:expat)))

(define-public python-pika
  (package
    (name "python-pika")
    (version "1.2.1")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/pika/pika")
              (commit version)))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0sqj3bg6jwign8vwvn337fbwy69sm684ns1vh5kbfnskq4him9i2"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'disable-live-tests
                    (lambda _
                      ;; Disable tests that require RabbitMQ, which is not
                      ;; yet available in Guix.
                      (substitute* "nose2.cfg"
                        (("tests=tests/unit,tests/acceptance")
                         "start-dir=tests/unit"))
                      (with-directory-excursion "tests"
                        (for-each delete-file
                                '("unit/base_connection_tests.py"
                                  "unit/threaded_test_wrapper_test.py")))))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (setenv "PYTHONPATH" (getcwd))
                        (invoke "nose2" "-v")))))))
    (native-inputs
     (list python-mock
           python-nose2
           ;; These are optional at runtime, and provided here for tests.
           python-gevent
           python-tornado
           python-twisted))
    (home-page "https://pika.readthedocs.org")
    (synopsis "Pure Python AMQP Client Library")
    (description
     "Pika is a pure-Python implementation of the AMQP (Advanced Message Queuing
Protocol) 0-9-1 protocol that tries to stay fairly independent of the underlying
network support library.")
    (license license:bsd-3)))

(define-public python-ply
  (package
    (name "python-ply")
    (version "3.11")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ply" version))
        (sha256
          (base32
            "18qx113g9bi1ac4indd5phma82zcdq601lxncp3vjn43m2mc3iq0"))))
    (build-system python-build-system)
    (home-page "http://www.dabeaz.com/ply/")
    (synopsis "Python Lex & Yacc")
    (description "PLY is a @code{lex}/@code{yacc} implemented purely in Python.
It uses LR parsing and does extensive error checking.")
    (license license:bsd-3)))

(define-public python-tabulate
  (package
    (name "python-tabulate")
    (version "0.8.9")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "tabulate" version))
             (sha256
              (base32
               "19qkdz8xwk5jxa5xn53mnk76qnh4ysm81vzj664jw1b0azr167gb"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: The pypi release tarball is missing a 'test/common.py'
     ;; and the latest release is not tagged in the upstream repository.
     '(#:tests? #f))
    (home-page "https://bitbucket.org/astanin/python-tabulate")
    (synopsis "Pretty-print tabular data")
    (description
     "Tabulate is a library and command-line utility to pretty-print tabular
data in Python.")
    (license license:expat)))

(define-public python-kazoo
  (package
    (name "python-kazoo")
    (version "2.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kazoo" version))
       (sha256
        (base32
         "1zpj5cc8624w6i0pxgcxqkjwbkm4pkrv19d7wh5df3jais32g3jq"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; XXX: needs zookeeper
    (propagated-inputs
     (list python-six))
    (home-page "https://kazoo.readthedocs.org")
    (synopsis "High-level Zookeeper client library")
    (description
     "Kazoo is a Python client library for the Apache Zookeeper distributed
application service.  It is designed to be easy to use and to avoid common
programming errors.")
    (license license:asl2.0)))

(define-public python-pykafka
  (package
    (name "python-pykafka")
    (version "2.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pykafka" version))
              (sha256
               (base32
                "1id6sr159p6aa13bxcqyr9gln8sqg1l0ddzns5iws8kk5q1p5cfv"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; XXX: needs zookeeper, kafka, etc.
    (propagated-inputs
     (list python-gevent python-kazoo python-tabulate))
    (inputs
     (list librdkafka))
    (home-page "https://pykafka.readthedocs.io/")
    (synopsis "Apache Kafka client for Python")
    (description
     "PyKafka is a client for the Apache Kafka distributed messaging system.
It includes Python implementations of Kafka producers and consumers, which
are optionally backed by a C extension built on librdkafka.")
    (license license:asl2.0)))

(define-public python-wcwidth
  (package
    (name "python-wcwidth")
    (version "0.1.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "wcwidth" version))
              (sha256
               (base32
                "1a1pzds3xzfylm5mnc5f6c1p8kiig0daqjc9gygd9rc3cj53x2zj"))))
    (build-system python-build-system)
    (home-page "https://github.com/jquast/wcwidth")
    (synopsis "Measure number of terminal column cells of wide-character codes")
    (description "Wcwidth measures the number of terminal column cells of
wide-character codes.  It is useful for those implementing a terminal emulator,
or programs that carefully produce output to be interpreted by one.  It is a
Python implementation of the @code{wcwidth} and @code{wcswidth} C functions
specified in POSIX.1-2001 and POSIX.1-2008.")
    (license license:expat)))

(define-public python-chai
  (package
    (name "python-chai")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "chai" version))
              (sha256
               (base32
                "1k6n6zbgrrs83crp6mr3yqj9zlv40b8rpisyrliwsq7naml2p3gz"))
              (patches (search-patches "python-chai-drop-python2.patch"))))
    (build-system python-build-system)
    (home-page "https://github.com/agoragames/chai")
    (synopsis "Mocking framework for Python")
    (description
     "Chai provides an api for mocking, stubbing and spying your python
objects, patterned after the Mocha library for Ruby.")
    (license license:bsd-3)))

(define-public python-inflection
  (package
    (name "python-inflection")
    (version "0.3.1")
    (source
     (origin (method url-fetch)
             (uri (pypi-uri "inflection" version))
             (sha256
              (base32
               "1jhnxgnw8y3mbzjssixh6qkc7a3afc4fygajhqrqalnilyvpzshq"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/jpvanhal/inflection")
    (synopsis "Python string transformation library")
    (description
     "Inflection is a string transformation library.  It singularizes
and pluralizes English words, and transforms strings from CamelCase to
underscored string.")
    (license license:expat)))

(define-public python-pylev
  (package
    (name "python-pylev")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pylev" version))
              (sha256
               (base32
                "1hz1x9blsbxya1y9nnhnwwdnqmakxi9mc0jkwj0rn6b1h44i0f86"))))
    (build-system python-build-system)
    (home-page "https://github.com/toastdriven/pylev")
    (synopsis "Levenshtein distance implementation in Python")
    (description "Pure Python Levenshtein implementation, based off the
Wikipedia code samples at
@url{http://en.wikipedia.org/wiki/Levenshtein_distance}.")
    (license license:bsd-3)))

(define-public python-cleo
  (package
    (name "python-cleo")
    (version "0.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cleo" version))
              (sha256
               (base32
                "17q6wi3q280kxmxzb2iwnnqih2xbljn18v0bjx2ip18p079j43ix"))))
    (build-system python-build-system)
    (native-inputs
     (list ;; For testing
           python-mock python-pytest-mock python-pytest))
    (propagated-inputs
     (list python-backpack python-clikit python-pastel python-pylev))
    (home-page "https://github.com/sdispater/cleo")
    (synopsis "Command-line arguments library for Python")
    (description
     "Cleo allows you to create command-line commands with signature in
docstring and colored output.")
    (license license:expat)))

(define-public python-tomlkit
  (package
    (name "python-tomlkit")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tomlkit" version))
       (sha256
        (base32 "062n694sfv24ylda6nh8228y2q9hrvy554kqx84y7czsjfbg4mxc"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-pyyaml))
    (home-page "https://github.com/sdispater/tomlkit")
    (synopsis "Style-preserving TOML library")
    (description
     "TOML Kit is a 1.0.0rc1-compliant TOML library.  It includes a parser that
preserves all comments, indentations, whitespace and internal element ordering,
and makes them accessible and editable via an intuitive API.  It can also
create new TOML documents from scratch using the provided helpers.  Part of the
implementation has been adapted, improved, and fixed from Molten.")
    (license license:expat)))

(define-public python-shellingham
  (package
    (name "python-shellingham")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shellingham" version))
       (sha256
        (base32 "07hpndvcv9mf9hp54b4apzpwzmzfzl8ryaacsfdq4139im2w4ma8"))))
    (build-system python-build-system)
    (home-page "https://github.com/sarugaku/shellingham")
    (synopsis "Tool to detect surrounding shell")
    (description
     "Shellingham detects what shell the current Python executable is
running in.")
    (license license:isc)))

(define-public python-memcached
  (package
    (name "python-memcached")
    (version "1.59")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-memcached" version))
       (sha256
        (base32
         "0kvyapavbirk2x3n1jx4yb9nyigrj1s3x15nm3qhpvhkpqvqdqm2"))
       (patches (search-patches "python-memcached-syntax-warnings.patch"))))
    (build-system python-build-system)
    (propagated-inputs (list python-six))
    (home-page
     "https://github.com/linsomniac/python-memcached")
    (synopsis "Pure python memcached client")
    (description
     "This software is a pure Python interface to the memcached memory cache
daemon.  It is the client side software which allows storing values in one or
more, possibly remote, memcached servers.")
    (license license:psfl)))

(define-public python-mergedeep
  (package
    (name "python-mergedeep")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarketm/mergedeep")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1msvvdzk33sxzgyvs4fs8dlsrsi7fjj038z83s0yw5h8m8d78469"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/clarketm/mergedeep")
    (synopsis "Deep merge function for Python")
    (description "This package provides a deep merge function for Python,
useful to combine multiple data objects as one.")
    (license license:expat)))

(define-public python-clikit
  (package
    (name "python-clikit")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "clikit" version))
       (sha256
        (base32
         "0ngdkmb73gkp5y00q7r9k1cdlfn0wyzws2wrqlshc4hlkbdyabj4"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))  ; no test in the PyPI tarball
    (propagated-inputs
     (list python-crashtest python-pastel python-pylev))
    (home-page "https://github.com/sdispater/clikit")
    (synopsis "Group of utilities to build command line interfaces")
    (description
     "CliKit is a group of utilities to build testable command line
interfaces.")
    (license license:expat)))

(define-public python-msgpack-python
  (package
    (name "python-msgpack-python")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "msgpack-python" version))
       (sha256
        (base32
         "16wh8qgybmfh4pjp8vfv78mdlkxfmcasg78lzlnm6nslsfkci31p"))))
    (build-system python-build-system)
    (home-page "https://msgpack.org/")
    (synopsis "Package to deserialize messages in MessagePack binary format")
    (description
     "MessagePack is an efficient binary serialization format.  It lets you
exchange data among multiple languages like JSON.  But it's faster and
smaller.  Small integers are encoded into a single byte, and typical short
strings require only one extra byte in addition to the strings themselves.")
    (license license:asl2.0)))

(define-public python-cattrs
  (package
    (name "python-cattrs")
    (version "22.1.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/python-attrs/cattrs")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1n0h25gj6zd02kqyl040xpdvg4hpy1j92716sz0rg019xjqqijqb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'adjust-for-older-attrs
            ;; Our older attrs package is using the 'attr' rather than 'attrs'
            ;; namespace.
            ;; TODO: Remove after python-attrs is updated to >= 21.4.0.
            (lambda _
              (substitute* (find-files "." "\\.py$")
                (("from attrs\\b")
                 "from attr"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Do not use the 'pytest' binary as it hard-codes an older
                ;; python-hypothesis version near the beginning of its
                ;; GUIX_PYTHONPATH.
                (invoke "python" "-m" "pytest" "-vv" "-c" "/dev/null" "tests"
                        "-n" (number->string (parallel-job-count))
                        ;; This test requires orjson, which needs the maturin
                        ;; build system and new Rust dependencies.
                        "--ignore" "tests/test_preconf.py")))))))
    (native-inputs
     (list python-hypothesis-next
           python-immutables
           python-msgpack
           python-poetry-core
           python-pymongo               ;for the bson module
           python-pytest
           python-pytest-xdist))
    (propagated-inputs
     (list python-attrs
           python-exceptiongroup
           python-typing-extensions))
    (home-page "https://github.com/python-attrs/cattrs")
    (synopsis "Python library for structuring and unstructuring data")
    (description "@code{cattrs} is an Python library for structuring and
unstructuring data.  @code{cattrs} works best with @code{attrs} classes,
@code{dataclasses} and the usual Python collections, but other kinds of
classes can also be supported by manually registering converters.")
    (license license:expat)))

(define-public python-cachy
  (package
    (name "python-cachy")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachy" version))
       (sha256
        (base32
         "1cb9naly8ampzlky7h74n5wj628l7jkpsh0c0jz0namlrvs82r8q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "pifpaf" "run" "memcached" "--port" "11211" "--"
                             "pytest"))))))
    (native-inputs
     (list memcached python-fakeredis python-flexmock python-pifpaf
           python-pytest))
    (propagated-inputs
     (list python-memcached python-msgpack-python python-redis))
    (home-page "https://github.com/sdispater/cachy")
    (synopsis "Simple yet effective caching library")
    (description
     "Cachy provides a simple yet effective caching library.  A simple but
powerful API: thread-safety; decorator syntax; support for memcached, redis,
database, file, dict stores.  Cachy supports python versions 2.7+ and 3.2+.")
    (license license:expat)))

(define-public poetry
  (package
    (name "poetry")
    (version "1.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poetry" version))
       (sha256
        (base32
         "0rr54mvcfcv9cv6vw2122y28xvd2pwqpv2x8c8j5ayz3gwsy4rjw"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f                      ;PyPI does not have tests
       #:phases
       (modify-phases %standard-phases
         (add-before 'build 'patch-setup-py
           (lambda _
             (substitute* "setup.py"
               ;; Relax some of the requirements.
               (("(keyring>=21.2.0),<22.0.0" _ keyring) keyring)
               (("(packaging>=20.4),<21.0" _ packaging) packaging)))))))
    (propagated-inputs
     (list python-cachecontrol
           python-cachy
           python-cleo
           python-crashtest
           python-entrypoints
           python-html5lib
           python-keyring
           ; Use of deprecated version of msgpack reported upstream:
           ; https://github.com/python-poetry/poetry/issues/3607
           python-msgpack-transitional
           python-packaging
           python-pexpect
           python-pip
           python-pkginfo
           python-poetry-core
           python-requests
           python-requests-toolbelt
           python-shellingham
           python-tomlkit
           python-virtualenv))
    (home-page "https://python-poetry.org")
    (synopsis "Python dependency management and packaging made easy")
    (description "Poetry is a tool for dependency management and packaging
in Python.  It allows you to declare the libraries your project depends on and
it will manage (install/update) them for you.")
    (license license:expat)))

(define-public python-lark-parser
  (package
    (name "python-lark-parser")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "lark-parser" version))
              (sha256
               (base32
                "1kd61asrb3h9spgsj4bslfbgp8q4271sw3hblk6f2vbbblv8jxcy"))))
    (build-system python-build-system)
    (home-page "https://github.com/lark-parser/lark")
    (synopsis "Multi-language parser for Python")
    (description
     "Lark is a parser built with a focus on ergonomics, performance and
resilience.  Lark can parse all context-free languages.  That means it is
capable of parsing almost any programming language out there, and to
some degree most natural languages too.")
    (license license:expat)))

(define-public python-libcst
  (package
    (name "python-libcst")
    (version "0.3.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "libcst" version))
              (sha256
               (base32
                "05zsc61gsd2pyb6wiyh58zczndxi6rm4d2jl94rpf5cv1fzw6ks8"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-failing-tests
           (lambda _
             ;; Reported upstream: <https://github.com/Instagram/LibCST/issues/346>.
             (delete-file "libcst/tests/test_fuzz.py")
             ;; Reported upstream: <https://github.com/Instagram/LibCST/issues/347>.
             (delete-file "libcst/tests/test_pyre_integration.py")
             (delete-file "libcst/codemod/tests/test_codemod_cli.py")
             (delete-file "libcst/metadata/tests/test_full_repo_manager.py")
             (delete-file "libcst/metadata/tests/test_type_inference_provider.py")))
         (add-before 'check 'generate-test-data
           (lambda _
             (invoke "python" "-m" "libcst.codegen.generate" "visitors")
             (invoke "python" "-m" "libcst.codegen.generate" "return_types")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "unittest")))))))
    (native-inputs
     (list python-black python-isort))
    (propagated-inputs
     (list python-typing-extensions python-typing-inspect python-pyyaml))
    (home-page "https://github.com/Instagram/LibCST")
    (synopsis "Concrete Syntax Tree (CST) parser and serializer library for Python")
    (description
     "LibCST parses Python source code as a CST tree that keeps all
formatting details (comments, whitespaces, parentheses, etc).  It's useful
for building automated refactoring (codemod) applications and linters.
LibCST creates a compromise between an Abstract Syntax Tree (AST) and
a traditional Concrete Syntax Tree (CST).  By carefully reorganizing and
naming node types and fields, LibCST creates a lossless CST that looks and
feels like an AST.")
    (license (list license:expat
                   ;; Some files unde libcst/_parser/ are under Python Software
                   ;; Foundation license (see LICENSE file for details)
                   license:psfl
                   ;; libcst/_add_slots.py
                   license:asl2.0))))

(define-public python-libcst-minimal
  (hidden-package
   (package
     (inherit python-libcst)
     (name "python-libcst-minimal")
     (arguments '(#:tests? #f))
     (native-inputs '()))))

(define-public python-typing-inspect
  (package
    (name "python-typing-inspect")
    (version "0.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "typing_inspect" version))
              (sha256
               (base32
                "1dzs9a1pr23dhbvmnvms2jv7l7jk26023g5ysf0zvnq8b791s6wg"))
              (patches (search-patches "python-typing-inspect-fix.patch"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-mypy-extensions python-typing-extensions))
    (home-page "https://github.com/ilevkivskyi/typing_inspect")
    (synopsis "API for inspection of types in the Python @code{typing} module")
    (description
     "The @code{typing_inspect} module defines experimental API for runtime
inspection of types defined in the Python standard typing module.")
    (license license:expat)))

(define-public python-lazy-object-proxy
  (package
    (name "python-lazy-object-proxy")
    (version "1.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "lazy-object-proxy" version))
              (sha256
               (base32
                "0hwh29m9wa582ramj30p4pysckdrmki1z1b8iaaxk6mpfx2kc8wp"))))
    (native-inputs
     (list python-setuptools-scm))
    (build-system python-build-system)
    (home-page "https://github.com/ionelmc/python-lazy-object-proxy")
    (synopsis "Lazy object proxy for python")
    (description
     "Lazy object proxy is an object that wraps a callable but defers the call
until the object is actually required, and caches the result of said call.")
    (license license:bsd-2)))

(define-public python-dnspython
  (package
    (name "python-dnspython")
    (version "2.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dnspython" version ".zip"))
              (sha256
               (base32
                "1m0xvyby8baaxp6pfm0fgq8d2pq5dd8qm8bzfbrs009jaw5pza74"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f                      ; XXX: requires internet access
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-getprotobyname-calls
           ;; These calls are problematic in the build environment as there is
           ;; no /etc/protocols.  This breaks the sanity-check phase of any
           ;; package depnding on this one.
           (lambda _
             (substitute* "dns/rdtypes/IN/WKS.py"
               (("socket.getprotobyname\\('tcp'\\)")
                "6")
               (("socket.getprotobyname\\('udp'\\)")
                "17")))))))
    (native-inputs (list unzip))
    (home-page "https://www.dnspython.org")
    (synopsis "DNS toolkit for Python")
    (description
     "dnspython is a DNS toolkit for Python.  It supports almost all record
types.  It can be used for queries, zone transfers, and dynamic updates.
It supports TSIG authenticated messages and EDNS0.")
    (license license:expat)))

(define-public python-dnspython-1.16
  (package
    (inherit python-dnspython)
    (version "1.16.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "http://www.dnspython.org/kits/"
                                  version "/dnspython-" version ".tar.gz"))
              (sha256
               (base32
                "1yaw7irazy42n0kdhlk7wyg8ki34rxcnc5xbc1wfwy245b0wbxab"))))
    (native-inputs '())))

(define-public python-py3dns
  (package
    (name "python-py3dns")
    (version "3.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "py3dns" version))
        (sha256
         (base32
          "1r25f0ys5p37bhld7m7n4gb0lrysaym3w318w2f8bncq7r3d81qz"))))
    (build-system python-build-system)
    ;; This package wants to read /etc/resolv.conf. We can't patch it without
    ;; removing functionality so we copy from Nix and "just don't build it".
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-source
           (lambda _
             (substitute* "setup.py"
               (("import DNS") "")
               (("DNS.__version__") (string-append "\"" ,version "\"")))))
         ;; For the same reason, drop the sanity check because the library
         ;; fails to load without /etc/resolv.conf.
         (delete 'sanity-check))
       #:tests? #f)) ; Also skip the tests.
    (home-page "https://launchpad.net/py3dns")
    (synopsis "Python 3 DNS library")
    (description "This Python 3 module provides a DNS API for looking up DNS
entries from within Python 3 modules and applications.  This module is a
simple, lightweight implementation.")
    (license license:psfl)))

(define-public python-email-validator
  (package
    (name "python-email-validator")
    (version "1.0.2")
    (source
     (origin (method url-fetch)
             (uri (pypi-uri "email_validator" version))
             (sha256
              (base32
               "1ja9149l9ck5n45a72h3is7v476hjny5ybxbcamx1nw6iplsm7k6"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'use-dnspython
           (lambda _
             (substitute* "setup.py"
               (("dnspython3") "dnspython"))
             #t)))))
    (propagated-inputs
     (list python-dnspython python-idna))
    (home-page "https://github.com/JoshData/python-email-validator")
    (synopsis "Email address validation library for Python")
    (description
     "This library validates email address syntax and deliverability.")
    (license license:cc0)))

(define-public python-ukpostcodeparser
  (package
    (name "python-ukpostcodeparser")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "UkPostcodeParser" version))
              (sha256
               (base32
                "03jkf1ygbwq3akzbcjyjk1akc1hv2sfgx90306pq1nwklbpn80lk"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Tests for lowercase postcodes fail.
               (invoke "pytest" "-vv" "ukpostcodeparser/test/parser.py" "-k"
                       (string-append "not test_091 "
                                      "and not test_097 "
                                      "and not test_098 "
                                      "and not test_125 "
                                      "and not test_131"))))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/hamstah/ukpostcodeparser")
    (synopsis "UK Postcode parser for Python")
    (description
     "This library provides the @code{parse_uk_postcode} function for
parsing UK postcodes.")
    (license license:expat)))

(define-public python-faker
  (package
    (name "python-faker")
    (version "13.3.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Faker" version))
              (sha256
               (base32
                "04855dqvvi2mr739l5x3qf82rxq0a7spc8gl76k8xixmbw36328q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "pytest" "-v")))))))
    (native-inputs
     (list python-freezegun
           python-pytest
           python-random2
           python-ukpostcodeparser
           python-validators))
    (propagated-inputs (list python-dateutil))
    (home-page "https://github.com/joke2k/faker")
    (synopsis "Python package that generates fake data")
    (description
     "Faker is a Python package that generates fake data such as names,
addresses, and phone numbers.")
    (license license:expat)))

(define-public python-pyaml
  (package
    (name "python-pyaml")
    (version "21.10.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyaml" version))
              (sha256
               (base32
                "10w3frzqir5sbpglc9bwb8w414dsivmcvji07yxy61mz2gp9ylf6"))))
    (build-system python-build-system)
    (native-inputs
     (list python-unidecode))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/mk-fg/pretty-yaml")
    (synopsis "YAML pretty-print library for Python")
    (description
     "pyaml is a PyYAML based python module to produce pretty and readable
YAML-serialized data.")
    (license license:wtfpl2)))

(define-public python-pyyaml-env-tag
  (package
    (name "python-pyyaml-env-tag")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyyaml_env_tag" version))
       (sha256
        (base32 "1nsva88jsmwn0cb9jnrfiz4dvs9xakkpgfii7g1xwkx1pmsjc2bh"))))
    (build-system python-build-system)
    (propagated-inputs (list python-pyyaml))
    (home-page "https://github.com/waylan/pyyaml-env-tag")
    (synopsis "Custom YAML tag for environment variables")
    (description "This package provides a custom YAML tag for referencing
environment variables in YAML files.")
    (license license:expat)))

(define-public python-backpack
  (package
    (name "python-backpack")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backpack" version))
       (sha256
        (base32
         "14rq1mvm0jda90lcx9gyyby9dvq4x3js2cmxvd6vl4686ixwyqh1"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-nose python-toml))
    (propagated-inputs
     (list python-simplejson))
    (home-page "https://github.com/sdispater/backpack")
    (synopsis "Utilities for working with Python collections")
    (description "Backpack provides some useful utilities for working with
collections of data.")
    (license license:expat)))

(define-public python-prompt-toolkit
  (package
    (name "python-prompt-toolkit")
    (version "3.0.29")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "prompt_toolkit" version))
       (sha256
        (base32 "19vf5cahp3imdpwhgvk55g3dvqmc6ga175r4vkq79kffx1h0yr5x"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; HOME is needed for the test
               ;; "test_pathcompleter_can_expanduser".
               (setenv "HOME" "/tmp")
               (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-wcwidth))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/prompt-toolkit/python-prompt-toolkit")
    (synopsis "Library for building command line interfaces in Python")
    (description
     "Prompt-Toolkit is a library for building interactive command line
interfaces in Python.  It's like GNU Readline but it also features syntax
highlighting while typing, out-of-the-box multi-line input editing, advanced
code completion, incremental search, support for Chinese double-width
characters, mouse support, and auto suggestions.")
    (license license:bsd-3)))

(define-public python-proselint
  (package
    (name "python-proselint")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "proselint" version))
       (sha256
        (base32
         "0n1ahnq2mkgvh94g05xhc3l1fs3hh0ycskqlqivhhfdaq8ybdlkx"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-home-directory
           (lambda _
             (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-click python-future python-six))
    (home-page "https://github.com/amperser/proselint")
    (synopsis "Linter for prose")
    (description "@code{python-proselint} is a linter for English prose, that
scans through a file and detects issues.")
    (license license:bsd-3)))

(define-public python-jedi
  (package
    (name "python-jedi")
    (version "0.18.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/davidhalter/jedi")
             (commit (string-append "v" version))
             (recursive? #true)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "07drmi3ai49jw5n23ibkambcgijqcw073ihypjgxfnks5lv4yqy1"))
       (modules '((guix build utils)))
       (snippet
        ;; Adjust comprehension syntax for Python > 3.8.
        ;; From <https://github.com/davidhalter/jedi/issues/1824>.
        '(substitute* "test/completion/lambdas.py"
           (("if lambda: 3")
            "if (lambda: 3)")))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-completion-test
           (lambda _
             ;; This resolves a failure in the 'test_completion' test (see:
             ;; https://github.com/davidhalter/jedi/issues/1824).
             ;; TODO: Remove after a new release is made (currently: 0.18.1).
             (substitute* "test/completion/lambdas.py"
               (("\\[a for a in \\[1,2\\] if lambda: 3\\]\\[0\\]")
                "[a for a in [1,2] if (lambda: 3)][0]"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (setenv "HOME" "/tmp")
               (invoke "python" "-m" "pytest" "-vv")))))))
    (native-inputs
     (list python-colorama python-docopt python-pytest))
    (propagated-inputs
     (list python-parso))
    (home-page "https://github.com/davidhalter/jedi")
    (synopsis "Autocompletion and static analysis library for Python")
    (description
     "Jedi is a static analysis tool for Python that can be used in Integrated
Development Environments (@dfn{IDE}s) and text editors.  It understands Python
on a deeper level than many other static analysis frameworks for Python.

Jedi understands docstrings and you can use Jedi autocompletion in your REPL
as well.")
    (license license:expat)))

(define-public ptpython
  (package
    (name "ptpython")
    (version "3.0.20")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ptpython" version))
              (sha256
               (base32
                "1mjfyr5gwrs1qbizh6nki0nv6hahmg8mhhqxi1qc6pfa4znlrzga"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ;there are no tests
    (propagated-inputs
     (list python-appdirs python-black python-jedi python-prompt-toolkit
           python-pygments))
    (home-page "https://github.com/jonathanslenders/ptpython")
    (synopsis "Python Read-Eval-Print-Loop with nice IDE-like features")
    (description
     "ptpython is a Python read-eval-print loop with IDE-like features.
It supports syntax highlighting, multiline editing, autocompletion, mouse,
color schemes, bracketed paste, Vi and Emacs keybindings, Chinese characters
etc.")
    (license license:bsd-3)))

(define-public python-easyprocess
  (package
    (name "python-easyprocess")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "EasyProcess" version))
       (sha256
        (base32 "115rzzr0hx4af4m6krf7dxn8851n4l8jfxahjzjc2r0zq2m8v57v"))))
    (build-system python-build-system)
    (arguments
     ;; Tests require pyvirtualdisplay, which requires this package.
     `(#:tests? #f))
    (home-page "https://github.com/ponty/easyprocess")
    (synopsis "Python subprocess interface")
    (description
     "@code{easyprocess} is an easy to use Python subprocess interface.")
    (license license:bsd-3)))

(define-public python-entrypoint2
  (package
    (name "python-entrypoint2")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "entrypoint2" version))
       (sha256
        (base32 "1qyxq54r2fbh09ab5sffbxajy8arbk6czxz5lq3ccr9qrypw6w27"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"))
    (native-inputs
     (list python-easyprocess python-pytest python-pytest-runner))
    (home-page "https://github.com/ponty/entrypoint2")
    (synopsis "Command-line interface for Python modules")
    (description
     "@code{entrypoint2} is an easy to use command-line interface for Python
     modules based on @code{argparse}.  It translates function signature and
     documentation to argparse configuration.")
    (license license:bsd-3)))

(define-public python-pyvirtualdisplay
  (package
    (name "python-pyvirtualdisplay")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyVirtualDisplay" version))
       (sha256
        (base32 "1z2fzgiw3xv3m1d9ppn53g07zhnpj05addiz56sm6ircxibnjk4x"))))
    (build-system python-build-system)
    (arguments
     ;; Tests fail with:
     ;; FileNotFoundError: [Errno 2] No such file or directory: 'Xvnc'.
     `(#:tests? #f))
    (native-inputs
     (list python-entrypoint2 python-psutil python-pytest
           python-pytest-runner))
    (propagated-inputs
     (list python-easyprocess python-pillow))
    (home-page "https://github.com/ponty/pyvirtualdisplay")
    (synopsis "Python wrapper for Xvfb, Xephyr and Xvnc")
    (description
     "@code{pyvirtualdisplay} is a Python wrapper for Xvfb, Xephyr and Xvnc.")
    (license license:bsd-3)))

(define-public python-stem
  (package
    (name "python-stem")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "stem" version))
       (sha256
        (base32
         "1hk8alc0r4m669ggngdfvryndd0fbx0w62sclcmg55af4ak8xd50"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-tests
           ;; See https://github.com/torproject/stem/issues/56
           (lambda _
             (substitute* "run_tests.py"
               (("test\\.task\\.MOCK_VERSION,")
                ""))))
         (replace 'check
           (lambda _
             (invoke "./run_tests.py" "--unit")
             #t)))))
    (native-inputs
     (list python-mock python-pycodestyle python-pyflakes))
    (home-page "https://stem.torproject.org/")
    (synopsis
     "Python controller library that allows applications to interact with Tor")
    (description
     "Stem is a Python controller library for Tor.  With it you can use Tor's
     control protocol to script against the Tor process and read descriptor data
     relays publish about themselves.")
    (license license:lgpl3)))

(define-public python-pyserial
  (package
    (name "python-pyserial")
    (version "3.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyserial" version))
        (sha256
          (base32
            "1nyd4m4mnrz8scbfqn4zpq8gnbl4x42w5zz62vcgpzqd2waf0xrw"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; FIXME: 3/49 tests are failing.
       ;; #:phases
       ;; (modify-phases %standard-phases
       ;;   (replace 'check
       ;;     (lambda _
       ;;       (zero? (system* "python" "test/run_all_tests.py" "loop://")))))))
    (home-page
      "https://github.com/pyserial/pyserial")
    (synopsis "Python Serial Port Bindings")
    (description "@code{pyserial} provide serial port bindings for Python.  It
     supports different byte sizes, stop bits, parity and flow control with RTS/CTS
     and/or Xon/Xoff.  The port is accessed in RAW mode.")
    (license license:bsd-3)))

(define-public python-pyserial-asyncio
  (package
    (name "python-pyserial-asyncio")
    (version "0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyserial-asyncio" version))
       (sha256
        (base32 "0cwd2cjz859v6jrm3y6hikfqjyhyfj5vhfjb8vvflvl6791yah8n"))))
    (build-system python-build-system)
    (propagated-inputs (list python-pyserial))
    (home-page "https://github.com/pyserial/pyserial-asyncio")
    (synopsis "Pyserial asynchronous I/O extension")
    (description "This package extends Pyserial with asynchronous I/O
     support.")
    (license license:bsd-3)))

(define-public python-pymodbus
  (package
    (name "python-pymodbus")
    (version "2.5.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/riptideio/pymodbus")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0kjjrx7xrlx0pf3y67hhr4xvqrly3xzmvf6ic5as61m6z19m7zd5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'disable-problematic-tests
                    (lambda _
                      ;; The following test modules rely on Python's own
                      ;; 'test' module, which is not distributed in the Python
                      ;; package of Guix.
                      (delete-file "test/test_client_async_asyncio.py")
                      (delete-file "test/test_client_sync_diag.py")
                      ;; The following test module requires the asynctest
                      ;; library, abandoned without support for Python 3.9+
                      ;; (see:
                      ;; https://github.com/riptideio/pymodbus/issues/681).
                      (delete-file "test/test_server_asyncio.py")))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-mock
           python-pytest
           python-redis
           python-sqlalchemy
           python-tornado
           python-twisted))
    (propagated-inputs
     (list python-pyserial
           python-six
           ;; For the REPL.
           python-aiohttp
           python-click
           python-prompt-toolkit
           python-pygments
           python-pyserial-asyncio))
    (home-page "https://github.com/riptideio/pymodbus/")
    (synopsis "Modbus protocol stack in Python")
    (description "Pymodbus is a full Modbus protocol implementation using
     @code{asyncio}, @code{tornado} or @code{twisted} for its asynchronous
     communications core.  It includes the following @emph{client} features:
     @itemize
     @item full read/write protocol on discrete and register
     @item most of the extended protocol (diagnostic/file/pipe/setting/information)
     @item TCP, UDP, Serial ASCII, Serial RTU, and Serial Binary
     @item asynchronous and synchronous versions
     @item payload builder/decoder utilities
     @item pymodbus read eval print loop (REPL).
     @end itemize
     It also includes the following @emph{server} features:
     @itemize
     @item can function as a fully implemented Modbus server
     @item TCP, UDP, Serial ASCII, Serial RTU, and Serial Binary
     @item asynchronous and synchronous versions
     @item full server control context (device information, counters, etc)
     @item a number of backing contexts (database, redis, sqlite, a slave device).
     @end itemize")
    (license license:bsd-3)))

(define-public python-exodriver
  (package
    (name "python-exodriver")
    (version "2.6.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/labjack/exodriver")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1ikjz8147p14s814yabdq821y691klnr2yg54zgsymcc97kvwp2q"))))
    (outputs (list "out"
                   "doc"))              ;544 KiB of examples
    (build-system gnu-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:make-flags #~(list (string-append "CC=" #$(cc-for-target))
                           (string-append "PREFIX=" #$output)
                           "RUN_LDCONFIG=0"
                           "LINK_SO=1")
      #:phases
      #~(modify-phases %standard-phases
          (delete 'configure)
          (replace 'build
            (lambda* (#:key make-flags #:allow-other-keys #:rest args)
              (with-directory-excursion "liblabjackusb"
                (apply (assoc-ref %standard-phases 'build)
                       `(,@args #:make-flags ,make-flags)))))
          (replace 'install
            (lambda* (#:key make-flags #:allow-other-keys #:rest args)
              (with-directory-excursion "liblabjackusb"
                (apply (assoc-ref %standard-phases 'install)
                       `(,@args #:make-flags ,make-flags)))
              ;; Install udev rules.
              (install-file "90-labjack.rules"
                            (string-append #$output "/lib/udev/rules.d"))
              ;; Install examples.
              (let ((doc (string-append #$output:doc "/share/doc/" #$name)))
                (mkdir-p doc)
                (copy-recursively "examples"
                                  (string-append doc "/examples"))))))))
    (inputs (list libusb))
    (home-page "https://github.com/labjack/exodriver")
    (synopsis "USB driver for LabJack data acquisition instruments")
    (description "This package provides @code{liblabjackusb}, a USB library for low-level
communication with the U3, U6, UE9, Digit, T4 and T7 LabJack data acquisition
instruments.  A udev rule is also included to allow unprivileged users to
communicate with the instruments via USB.")
    (license license:expat)))           ;see README

(define-public python-labjack
  (package
    (name "python-labjack")
    (version "2.0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "LabJackPython" version))
              (sha256
               (base32
                "013bjqdi05vlbdqprr6kqi8gs4qhqc7rnyp1klw8k6fng77rpdzz"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-liblabjackusb.so
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* (find-files "." "\\.py$")
                (("ctypes.CDLL\\(\"liblabjackusb.so\"")
                 (format #f "ctypes.CDLL(~s"
                         (search-input-file inputs
                                            "lib/liblabjackusb.so")))))))))
    ;; exodriver is provided as a regular input, as only its shared object is
    ;; used, not its Python API.
    (inputs (list python-exodriver))
    (home-page "https://labjack.com/support/software/examples/ud/labjackpython")
    (synopsis "Python library for LabJack U3, U6, UE9 and U12")
    (description "This Python library allows communicating with the U3, U6,
UE9 and U12 LabJack data acquisition (DAQ) modules.")
    (license license:expat)))          ;see setup.py

(define-public python-kivy-garden
  (package
    (name "python-kivy-garden")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kivy-garden" version))
       (sha256
        (base32 "0wkcpr2zc1q5jb0bi7v2dgc0vs5h1y7j42mviyh764j2i0kz8mn2"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-after 'install 'remove-bat-file
                    (lambda* (#:key outputs #:allow-other-keys)
                      (let ((out (assoc-ref outputs "out")))
                        (delete-file
                         (string-append out "/bin/garden.bat"))))))))
    (propagated-inputs
     (list python-requests))
    (home-page "https://github.com/kivy-garden/garden")
    (synopsis "Garden tool for Kivy flowers")
    (description
     "This package provides the @command{garden} command to install packages
for Kivy, the multitouch application platform.")
    (license license:expat)))

(define-public python-kivy
  (package
    (name "python-kivy")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Kivy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cq4djfn7h8560mvz94dydsldg2jpp5w9rby7nafgmbh7fxg65is"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f              ; Tests require many optional packages
       #:phases
       (modify-phases %standard-phases
         (add-after 'patch-generated-file-shebangs 'set-sdl-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "KIVY_SDL2_PATH"
                     (search-input-directory inputs "/include/SDL2"))))
         (add-before 'build 'set-home
           (lambda _
             ;; 'kivy/__init__.py' wants to create $HOME/.kivy.
             (setenv "HOME" (getcwd)))))))
    (native-inputs
     (list pkg-config python-cython))
    (inputs
     (list gstreamer
           mesa
           (sdl-union (list sdl2 sdl2-image sdl2-mixer sdl2-ttf))
           python-docutils
           python-kivy-garden
           python-pygments))
    (home-page "https://kivy.org")
    (synopsis "Multitouch application framework")
    (description
     "Kivy is a software library for rapid development of hardware-accelerated
multitouch applications.")
    (license license:expat)))

(define-public python-kivymd
  (package
    (name "python-kivymd")
    (version "0.104.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kivymd" version))
       (sha256
        (base32 "04lwy6j0agrdwa4a6dl6qs97nx9ysmscmm8psvdzjpyj8aa1zg4p"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f                                ;tests require network
       #:phases
       (modify-phases %standard-phases
         (add-before 'sanity-check 'set-home
           (lambda _
             ;; 'kivy/__init__.py' wants to create $HOME/.kivy.
             (setenv "HOME" (getcwd)))))))
    (native-inputs (list python-docutils))
    (propagated-inputs
     (list python-kivy python-pillow python-pygments python-kivy-garden))
    (home-page "https://github.com/kivymd/KivyMD")
    (synopsis "Material Design compliant widgets for use with Kivy")
    (description
     "This package provides Kivy widgets that approximate Google's Material
Design spec without sacrificing ease of use or application performance.")
    (license license:expat)))

(define-public python-asynckivy
  (package
    (name "python-asynckivy")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "asynckivy" version))
       (sha256
        (base32 "0ivjvch8yn3k1ybfp7c1nm8mhc0ymg7d04mq54lly7yjvg0jvcni"))))
    (build-system python-build-system)
    (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'set-home
             (lambda _
               ;; 'kivy/__init__.py' wants to create $HOME/.kivy.
               (setenv "HOME" (getcwd)))))))
    (propagated-inputs (list python-kivy python-asyncgui))
    (home-page "https://github.com/gottadiveintopython/asynckivy")
    (synopsis "Async library for Kivy")
    (description
     "This package provides async versions of Kivy functions to avoid the
callback-heavy mode of interaction typical in some Kivy applications.")
    (license license:expat)))

(define-public python-asyncgui
  (package
    (name "python-asyncgui")
    (version "0.5.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "asyncgui" version))
              (sha256
               (base32
                "0614130afg2qc1qq4p82piskvvx6lpjl4nlsakbjzdyd78xywnb7"))))
    (build-system python-build-system)
    (home-page "https://github.com/gottadiveintopython/asyncgui")
    (synopsis "Enables async/await without an event loop")
    (description "This package provides support for async/await applications
without requiring an event loop, useful for creative responsive GUIs.")
    (license license:expat)))

(define-public python-binaryornot
  (package
    (name "python-binaryornot")
    (version "0.4.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "binaryornot" version))
              (sha256
               (base32
                "0qc006986rb6bcbmiymwgcl1mns2jphr1j7sr7nk41nlr7gh359m"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-tests
           (lambda _
             ;; TypeError: binary() got an unexpected keyword argument
             ;; 'average_size'.
             (substitute* "tests/test_check.py"
              (("average_size=512") ""))
             #t)))))
    (propagated-inputs
     (list python-chardet python-hypothesis))
    (home-page "https://github.com/audreyr/binaryornot")
    (synopsis "Package to check if a file is binary or text")
    (description "Ultra-lightweight pure Python package to check if a file is
     binary or text.")
    (license license:bsd-3)))

(define-public binwalk
  (package
    (name "binwalk")
    (version "2.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ReFirmLabs/binwalk")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0phqyqv34vhh80dgipiggs4n3iq2vfjk9ywx2c5d8g61vzgbd2g8"))
       (modules '((guix build utils)))
       (snippet
        #~(begin
            (for-each delete-file
                      (list "testing/tests/input-vectors/firmware.zip"
                            "testing/tests/test_firmware_zip.py"))))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-home
           (lambda _
             (setenv "HOME" ""))))))
    (native-inputs
     (list python-coverage python-nose))
    (home-page "https://github.com/ReFirmLabs/binwalk")
    (synopsis "Firmware analysis tool")
    (description "Binwalk is a tool for analyzing, reverse engineering, and
     extracting firmware images")
    (license license:expat)))

(define-public python-binwalk
  (deprecated-package "python-binwalk" binwalk))

(define-public python-bson
  (package
    (name "python-bson")
    (version "0.5.10")
    (source
     (origin
       (method git-fetch)               ;for tests
       (uri (git-reference
             (url "https://github.com/py-bson/bson")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1vpy4rsvm3hhawvbg9rbw4j36ck8qylkhm8cjy0q6imvinkd2als"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "./test.py")))))))
    (propagated-inputs (list python-dateutil python-six))
    (home-page "https://github.com/py-bson/bson")
    (synopsis "BSON (Binary JSON) codec for Python")
    (description "@code{bson} is a Python library implementing a BSON (Binary
JSON) codec.")
    (license license:asl2.0)))

(define-public python-nltk
  (package
    (name "python-nltk")
    (version "3.6.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "nltk" version ".zip"))
              (sha256
               (base32
                "1sq32lwgij9h8rsksymnxxr7bqfw3vgx5ijw4azbj6k2xnmmdmap"))))
    (build-system python-build-system)
    (arguments
     '(;; The tests require some extra resources to be downloaded.
       ;; TODO Try packaging these resources.
       #:tests? #f))
    (propagated-inputs
     (list python-click python-joblib python-regex python-tqdm))
    (native-inputs
     (list unzip))
    (home-page "http://nltk.org/")
    (synopsis "Natural Language Toolkit")
    (description "It provides interfaces to over 50 corpora and lexical
     resources such as WordNet, along with a suite of text processing libraries
     for classification, tokenization, stemming, tagging, parsing, and semantic
     reasoning, wrappers for natural language processing libraries.")
    (license license:asl2.0)))

;; Versions >=3.5 breaks backward-compatibility,
;; so we keep version 3.4.x around for a while.
(define-public python-nltk-3.4
  (package
    (inherit python-nltk)
    (version "3.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nltk" version ".zip"))
       (sha256
        (base32 "153x2clrnigs74jdgnn3qmljdjj4gprmvpdvh49i18ls4m8mbm5y"))))
    (propagated-inputs (list python-six))))

(define-public python-pymongo
  (package
    (name "python-pymongo")
    (version "4.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pymongo" version))
              (sha256
               (base32
                "1m9hc2a4kgg10xy3g5x00z4a7rrk9s0rbf5qfypwnhq0kdfg5f6p"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-certifi))
    (home-page "https://github.com/mongodb/mongo-python-driver")
    (synopsis "Python driver for MongoDB")
    (description "Python driver for MongoDB.")
    (license license:asl2.0)))

(define-public python-consul
  (package
    (name "python-consul")
    (version "0.6.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "python-consul" version))
        (sha256
         (base32
          "0rfyxcy4cr3x848vhx876ifalxd5ghq6l5x813m49h4vq2d4jiq8"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; The tests are not distributed
    (propagated-inputs
     (list python-requests python-six))
    (home-page "https://github.com/cablehead/python-consul")
    (synopsis "Python client for Consul")
    (description
     "Python client for @url{http://www.consul.io/,Consul}, a tool for service
     discovery, monitoring and configuration.")
    (license license:expat)))

(define-public python-schematics
  (package
    (name "python-schematics")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/schematics/schematics")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xdqskycznqc7mfp60bhw1zq8wx7yx1dvmbq3brnm1dx3xnqa0zd"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (arguments
     ;; The tests require a bunch of not very nice packages with fixed
     ;; version requirements (e.g. python-coveralls).
     `(#:tests? #f))
    (home-page "https://github.com/schematics/schematics")
    (synopsis "Python Data Structures for Humans")
    (description "Python Data Structures for Humans.")
    (license license:bsd-3)))

(define-public python-odfpy
  (package
    (name "python-odfpy")
    (version "1.4.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "odfpy" version))
              (sha256
               (base32
                "1v1qqk9p12qla85yscq2g413l3qasn6yr4ncyc934465b5p6lxnv"))))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv"))))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-defusedxml))
    (home-page "https://github.com/eea/odfpy")
    (synopsis "Python API and tools to manipulate OpenDocument files")
    (description "Collection of libraries and utility programs written in
     Python to manipulate OpenDocument 1.2 files.")
    (license
     ;; The software is mainly dual GPL2+ and ASL2.0, but includes a
     ;; number of files with other licenses.
     (list license:gpl2+ license:asl2.0 license:lgpl2.1+ license:cc-by-sa3.0))))

(define-public python-natsort
  (package
    (name "python-natsort")
    (version "7.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "natsort" version))
              (sha256
               (base32
                "00y49bfsi7rrsd1s42gc2w95a6arl9ipdsx2493hr0v54fj07ih0"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-test-hypothesis-deadlines
           (lambda _
             (substitute* "tests/test_utils.py"
               (("from hypothesis import given")
                "from hypothesis import given, settings")
               (("( +)@given" all spaces)
                (string-append spaces "@settings(deadline=None)\n" all)))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-v")))))))
    (native-inputs
     (list python-hypothesis python-pytest-cov python-pytest-mock
           python-pytest))
    (propagated-inputs ; TODO: Add python-fastnumbers.
     (list python-pyicu))
    (home-page "https://github.com/SethMMorton/natsort")
    (synopsis "Natural sorting for python and shell")
    (description
     "Natsort lets you apply natural sorting on lists instead of
lexicographical.  If you use the built-in @code{sorted} method in python on a
list such as @code{[@code{a20}, @code{a9}, @code{a1}, @code{a4}, @code{a10}]},
it would be returned as @code{[@code{a1}, @code{a10}, @code{a20}, @code{a4},
@code{a9}]}.  Natsort provides a function @code{natsorted} that identifies
numbers and sorts them separately from strings.  It can also sort version
numbers, real numbers, mixed types and more, and comes with a shell command
@command{natsort} that exposes this functionality in the command line.")
    (license license:expat)))

(define-public glances
  (package
  (name "glances")
  (version "3.1.7")
  (source
    (origin
      (method url-fetch)
      (uri (pypi-uri "Glances" version))
      (sha256
        (base32 "020vb38qrb0m3sdr7xjr43cmcfxpnyg4hmb97wgxsa9zvwsjwa5x"))
      (modules '((guix build utils)))
      (snippet
       '(begin
          ;; Glances phones PyPI for weekly update checks by default.
          ;; Disable these.  The user can re-enable them if desired.
          (substitute* "glances/outdated.py"
            (("^(.*)self\\.load_config\\(config\\)\n" line indentation)
             (string-append indentation
                            "self.args.disable_check_update = True\n"
                            line)))
          #t))))
  (build-system python-build-system)
  (propagated-inputs
   (list python-future python-psutil))
  (home-page "https://github.com/nicolargo/glances")
  (synopsis "Cross-platform curses-based monitoring tool")
  (description
    "Glances is a curses-based monitoring tool for a wide variety of platforms.
     Glances uses the PsUtil library to get information from your system.  It
     monitors CPU, load, memory, network bandwidth, disk I/O, disk use, and more.")
  (license license:lgpl3+)))

(define-public python-graphql-core
  (package
    (name "python-graphql-core")
    (version "3.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphql-core" version))
        (sha256
         (base32
          "0fjv5w2wvgdr8gb27v241bavliipyir9fdz48rsgc3xapm644mn0"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; Tests require the unpackaged pytest-benchmark.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-hardcoded-version
           (lambda _ (substitute*
                       "setup.py"
                       (("'gevent==1.1rc1'") "'gevent'"))
             #t)))))
    (native-inputs
     (list python-gevent python-mock python-pytest-mock))
    (propagated-inputs
     (list python-promise python-six))
    (home-page "https://github.com/graphql-python/graphql-core")
    (synopsis "GraphQL implementation for Python")
    (description
     "GraphQL implementation for Python.  GraphQL is a data query language and
     runtime designed and used to request and deliver data to mobile and web apps.
     This library is a port of @url{https://github.com/graphql/graphql-js,graphql-js}
     to Python.")
    (license license:expat)))

(define-public python-graphql-relay
  (package
    (name "python-graphql-relay")
    (version "3.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphql-relay" version))
        (sha256
         (base32
          "1d70vwam9gjhx7fqzsa03x7lc6ivcqki5r9pk8m7rslmb7pagmbh"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "tests")))))))
    (native-inputs
     (list
       python-pytest
       python-pytest-asyncio))
    (propagated-inputs
     (list python-graphql-core))
    (home-page "https://github.com/graphql-python/graphql-relay-py")
    (synopsis "Relay implementation for Python")
    (description
     "This is a library to allow the easy creation of Relay-compliant servers
     using the GraphQL Python reference implementation of a GraphQL server.  It
     should be noted that the code is a exact port of the original
     @url{https://github.com/graphql/graphql-relay-js,graphql-relay js implementation}
     from Facebook.")
    (license license:expat)))

(define-public python-graphene
  (package
    (name "python-graphene")
    (version "3.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphene" version))
        (sha256
         (base32
          "08m1n2ydk48c18cvl8474v3pwwacjl1vgq61m9qs00122mp0cj5g"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-graphql-core python-graphql-relay python-aniso8601
           python-promise python-six))
    (arguments
     `(#:tests? #f))                    ; no tests/ in the PyPI tarball
    (home-page "https://graphene-python.org/")
    (synopsis "GraphQL Framework for Python")
    (description
     "Graphene is a Python library for building GraphQL schemas/types.
     A GraphQL schema describes your data model, and provides a GraphQL server
     with an associated set of resolve methods that know how to fetch data.")
    (license license:expat)))

(define-public python-random2
  (package
    (name "python-random2")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "random2" version ".zip"))
              (sha256
               (base32
                "01y0s4747plsx8fdnxy0nz83dp69naddz58m81r9h0s1qfm31b9l"))
              (patches
               (search-patches "python-random2-getrandbits-test.patch"))))
    (build-system python-build-system)
    (native-inputs (list unzip))
    (home-page "http://pypi.python.org/pypi/random2")
    (synopsis "Python 3 version of the Python 2 @code{random} module")
    (description
     "This package provides a Python 3 ported version of Python 2.7’s
     @code{random} module.  It has also been back-ported to work in Python 2.6.

     In Python 3, the implementation of @code{randrange()} was changed, so that
     even with the same seed you get different sequences in Python 2 and 3.

     This package closes that gap, allowing stable random number generation
     between the different Python versions.")
    (license license:psfl)))

(define-public python-snowballstemmer
  (package
    (name "python-snowballstemmer")
    (version "2.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "snowballstemmer" version))
              (sha256
               (base32
                "0ligk61idlz8kkgd5hpip5whm172riwglb6xydii7h62yhysqfyz"))))
    (build-system python-build-system)
    (arguments
     `(;; No tests exist
       #:tests? #f))
    (home-page "https://github.com/shibukawa/snowball_py")
    (synopsis "Snowball stemming library collection for Python")
    (description "This package provides 16 word stemmer algorithms generated
     from Snowball algorithms.  It includes the 15 original ones plus the Poerter
     English stemmer.")
    (license license:bsd-3)))

(define-public python-setproctitle
  (package
    (name "python-setproctitle")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setproctitle" version))
       (sha256
        (base32
         "1zbp6kyzfbrmbh9j3idai0mnpa28zn5db3k5l07jc3c3gj89gyxr"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (setenv "PYTHON" (or (which "python3") (which "python")))
             (setenv "PYCONFIG" (if (which "python3-config")
                                    "python3-config --embed"
                                    "python-config"))
             (substitute* "tests/conftest.py"
               (("cc") "gcc"))
             (when tests?
               (invoke "pytest" "tests/")))))))
    (native-inputs
     (list procps python-pytest))   ; required for tests
    (home-page "https://github.com/dvarrazzo/py-setproctitle")
    (synopsis
     "Setproctitle implementation for Python to customize the process title")
    (description "The library allows a process to change its title (as displayed
by system tools such as @code{ps} and @code{top}).

Changing the title is mostly useful in multi-process systems, for example when a
master process is forked: changing the children's title allows identifying the
task each process is busy with.  The technique is used by PostgreSQL and the
OpenSSH Server for example.")
    (license license:bsd-3)))

(define-public python-validictory
  (package
    (name "python-validictory")
    (version "1.0.1")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "validictory" version))
      (sha256
       (base32
        "1zf1g9sw47xzp5f80bd94pb42j9yqv82lcrgcvdwr6nkaphfi37q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'bootstrap
           ;; Move the tests out of the package directory to avoid
           ;; packaging them.
           (lambda* _
             (rename-file "validictory/tests" "tests")
             (delete-file "tests/__init__.py")))
         (replace 'check
           (lambda _
             (invoke "py.test" "-vv" ))))))
    (native-inputs
     (list python-pytest))
    (home-page
     "https://github.com/jamesturk/validictory")
    (synopsis "General purpose Python data validator")
    (description "It allows validation of arbitrary Python data structures.

     The schema format is based on the JSON Schema
     proposal (http://json-schema.org), so combined with json the library is also
     useful as a validator for JSON data.")
  (license license:expat)))

(define-public python-pyelftools
  (package
    (name "python-pyelftools")
    (version "0.28")
    (home-page "https://github.com/eliben/pyelftools")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page)
                           (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1z4fx39c9rds0bd4d2fjjq7n05b1nfxl36pmy523x8knm38l4gpr"))
       (snippet
        ;; Delete bundled readelf executable.
        '(delete-file "test/external_tools/readelf"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        ;; Taken from tox.ini.
                        (invoke "python" "test/run_all_unittests.py")
                        (invoke "python" "test/run_examples_test.py")
                        (invoke "python" "test/run_readelf_tests.py")))))))
    (synopsis
     "Analyze binary and library file information")
    (description "This Python library provides interfaces for parsing and
     analyzing two binary and library file formats ; the Executable and Linking
     Format (ELF), and debugging information in the Debugging With Attributed
     Record Format (DWARF).")
    (license license:public-domain)))

(define-public python-pefile
  (package
    (name "python-pefile")
    (version "2022.5.30")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/erocarrera/pefile")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1qj90a0s2gd5hn2zggypqc1077inid5dcl1fp5973b04kf2b9z8a"))))
    (build-system python-build-system)
    (propagated-inputs (list python-future))
    (home-page "https://github.com/erocarrera/pefile")
    (synopsis "Portable Executable (PE) file parser")
    (description "This python library provides interfaces for parsing and
working with Portable Executable (PE) files.  It makes to most information
from the header, as well as section details and data available.")
    (license license:expat)))

(define-public python-pyev
  (package
    (name "python-pyev")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyev" version))
        (sha256
         (base32
          "0rf603lc0s6zpa1nb25vhd8g4y337wg2wyz56i0agsdh7jchl0sx"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; no test suite
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((libev (search-input-file inputs "/lib/libev.so.4")))
               (substitute* "setup.py"
                 (("libev_dll_name = find_library\\(\\\"ev\\\"\\)")
                  (string-append "libev_dll_name = \"" libev "\"")))))))))
    (inputs
     (list libev))
    (home-page "https://github.com/gabrielfalcao/pyev")
    (synopsis "Python libev interface")
    (description "Pyev provides a Python interface to libev.")
    (license license:gpl3)))

(define-public python-imagesize
  (package
    (name "python-imagesize")
    (version "1.2.0")
    (source
      (origin
      (method url-fetch)
      (uri (pypi-uri "imagesize" version))
      (sha256
       (base32
        "1cd24x0vqbd6c8ym1n21qc0aj54mfb7rzdqglmwk9xxixajbbxmi"))))
    (build-system python-build-system)
    (home-page "https://github.com/shibukawa/imagesize_py")
    (synopsis "Gets image size of files in various formats in Python")
    (description
      "This package allows determination of image size from
     PNG, JPEG, JPEG2000 and GIF files in pure Python.")
    (license license:expat)))

(define-public python-termstyle
  (package
    (name "python-termstyle")
    (version "0.1.11")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "termstyle" version))
        (sha256
          (base32
            "17wzkkcqy5zc0g68xlad3kcv66iw14d2pwqc0h9420gak0vbhx7g"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "test3.py"))))))
    (home-page "https://github.com/gfxmonk/termstyle")
    (synopsis "Console text coloring for Python")
    (description "This package provides console text coloring for Python.")
    (license license:bsd-3)))

(define-public python-argcomplete
  (package
    (name "python-argcomplete")
    (version "1.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argcomplete" version))
       (sha256
        (base32
         "0h1przxffrhqvi46k40pzjsvdrq4zc3sl1pc96kkigqppq0vdrss"))
       (patches (search-patches "python-argcomplete-1.11.1-fish31.patch"))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage
           python-flake8
           python-pexpect
           python-wheel
           tcsh
           fish
           bash))            ;full Bash for 'test_file_completion'
    (home-page "https://github.com/kislyuk/argcomplete")
    (synopsis "Shell tab completion for Python argparse")
    (description "argcomplete provides extensible command line tab completion
     of arguments and options for Python scripts using @code{argparse}.  It's
     particularly useful for programs with many options or sub-parsers that can
     dynamically suggest completions ; for example, when browsing resources over the
     network.")
    (license license:asl2.0)))

(define-public python-csscompressor
  (package
    (name "python-csscompressor")
    (version "0.9.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "csscompressor" version))
        (sha256
         (base32
          "018ssffvlpnc1salmnpyl52c11glzzwj4k9f757hl4pkpjnjp8mg"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "py.test"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/sprymix/csscompressor")
    (synopsis "Python port of YUI CSS Compressor")
    (description
     "This package provides a python port of YUI CSS Compressor.")
    (license license:bsd-3)))

(define-public python-rcssmin
  (package
    (name "python-rcssmin")
    (version "1.0.6")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "rcssmin" version))
        (sha256
         (base32
          "0w42l4dhxghcz7pj3q7hkxp015mvb8z2cq9sfxbl31npsfavd1ya"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "run_tests.py" "tests"))))))
    (home-page "http://opensource.perlig.de/rcssmin/")
    (synopsis "CSS Minifier")
    (description "The minifier is based on the semantics of the YUI compressor,
     which itself is based on the rule list by Isaac Schlueter.")
    (license license:asl2.0)))

(define-public python-rjsmin
  (package
    (name "python-rjsmin")
    (version "1.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "rjsmin" version))
        (sha256
         (base32
          "0cmc72rlkvzz8fl89bc83czkx0pcvhzj7yn7m29r8pgnf5fcfpdi"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (for-each delete-file (find-files "bench" "\\.js$"))
            #t))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f  ; Not all test files included.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (if tests?
               (invoke "py.test" "-vv" "tests")
               #t))))))
    (native-inputs
     (list python-pytest))
    (home-page "http://opensource.perlig.de/rjsmin/")
    (synopsis "Javascript Minifier")
    (description "@code{rJSmin} is a javascript minifier written in Python.  The
     minifier is based on the semantics of jsmin.c by Douglas Crockford.  The module
     is a re-implementation aiming for speed, so it can be used at runtime (rather
                                                                            than during a preprocessing step).")
    (license license:asl2.0)))

(define-public python-xopen
  (package
    (name "python-xopen")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xopen" version))
       (sha256
        (base32
         "1xrlcnd6fri3w97zzzp6vyk4l21yq1lc8r4wksi06hgpkbh4jdq0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/marcelm/xopen/")
    (synopsis "Open compressed files transparently")
    (description "This module provides an @code{xopen} function that works like
     Python's built-in @code{open} function, but can also deal with compressed files.
     Supported compression formats are gzip, bzip2 and, xz, and are automatically
     recognized by their file extensions.  The focus is on being as efficient as
     possible on all supported Python versions.")
    (license license:expat)))

(define-public python-cheetah
  (package
    (name "python-cheetah")
    (version "3.2.4")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "Cheetah3" version))
        (sha256
          (base32
           "0ar5dqjnqaw0c17mymd6xgd81jn9br9fblawr0x438v1571bkaya"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'use-absolute-python
                    (lambda _
                      (substitute* "Cheetah/CheetahWrapper.py"
                        (("#!/usr/bin/env python")
                         (string-append "#!" (which "python"))))))
                  (add-after 'unpack 'fix-tests
                    (lambda _
                      (substitute* "Cheetah/Tests/ImportHooks.py"
                        (("os.path.dirname\\(__file__\\)")
                         (string-append "'" (getcwd) "/Cheetah/Tests'")))))
                  (replace 'check
                    (lambda _
                      (setenv "TMPDIR" "/tmp")
                      (substitute* "Cheetah/Tests/Test.py"
                        (("unittest.TextTestRunner\\(\\)")
                         "unittest.TextTestRunner(verbosity=2)"))

                      (invoke "python" "Cheetah/Tests/Test.py"))))))
    (propagated-inputs
     (list python-markdown))    ;optional
    (home-page "https://cheetahtemplate.org/")
    (synopsis "Template engine")
    (description "Cheetah is a text-based template engine and Python code
     generator.

     Cheetah can be used as a standalone templating utility or referenced as
     a library from other Python applications.  It has many potential uses,
     but web developers looking for a viable alternative to ASP, JSP, PHP and
     PSP are expected to be its principle user group.

     Features:
     @enumerate
     @item Generates HTML, SGML, XML, SQL, Postscript, form email, LaTeX, or any other
     text-based format.
     @item Cleanly separates content, graphic design, and program code.
     @item Blends the power and flexibility of Python with a simple template language
     that non-programmers can understand.
     @item Gives template writers full access to any Python data structure, module,
     function, object, or method in their templates.
     @item Makes code reuse easy by providing an object-orientated interface to
     templates that is accessible from Python code or other Cheetah templates.
     One template can subclass another and selectively reimplement sections of it.
     @item Provides a simple, yet powerful, caching mechanism that can dramatically
     improve the performance of a dynamic website.
     @item Compiles templates into optimized, yet readable, Python code.
     @end enumerate")
    (license (license:x11-style "file://LICENSE"))))

(define-public python-dulwich
  (package
    (name "python-dulwich")
    (version "0.20.30")
    (source
      (origin
        (method url-fetch)
        (uri (list (string-append "https://www.dulwich.io/releases/"
                            "dulwich-" version ".tar.gz")
                   (pypi-uri "dulwich" version)))
        (sha256
          (base32
           "0hafaff30bmkj30b8pwpwsy3fz5h6c1pn98ihqcvl5zndflr1h22"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-tests
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* '("dulwich/tests/test_repository.py"
                            "dulwich/tests/test_porcelain.py"
                            "dulwich/tests/test_hooks.py")
               (("/bin/sh") (search-input-file inputs "/bin/sh")))
             (setenv "TEST_RUNNER" "unittest")
             (setenv "PYTHONHASHSEED" "random"))))))
    (propagated-inputs
     (list python-fastimport python-urllib3))
    (native-inputs
     (list python-mock python-geventhttpclient python-gpg
           git gnupg))
    (home-page "https://www.dulwich.io/")
    (synopsis "Git implementation in Python")
    (description "Dulwich is an implementation of the Git file formats and
     protocols written in pure Python.")
    ;; Can be used with either license.
    (license (list license:asl2.0 license:gpl2+))))

(define-public python-pbkdf2
  (package
    (name "python-pbkdf2")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pbkdf2" version))
       (sha256
        (base32
         "0yb99rl2mbsaamj571s1mf6vgniqh23v98k4632150hjkwv9fqxc"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "test/test_pbkdf2.py"))))))
    (home-page "https://www.dlitz.net/software/python-pbkdf2/")
    (synopsis "Password-based key derivation")
    (description "This module implements the password-based key derivation
     function, PBKDF2, specified in RSA PKCS#5 v2.0.

     PKCS#5 v2.0 Password-Based Key Derivation is a key derivation function which
     is part of the RSA Public Key Cryptography Standards series.  The provided
     implementation takes a password or a passphrase and a salt value (and
                                                                       optionally a iteration count, a digest module, and a MAC module) and provides
     a file-like object from which an arbitrarily-sized key can be read.")
    (license license:expat)))

(define-public python-qrcode
  (package
    (name "python-qrcode")
    (version "7.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "qrcode" version))
       (sha256
        (base32 "0y35jlwfvkgn9341lzshyaqgpp61vysjh107vhdd96ya83r6ynip"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Tests require packaging 'pymaging'.
     '(#:tests? #f))
    (propagated-inputs
     (list python-lxml ; for SVG output
           python-pillow)) ; for PNG output
    (home-page "https://github.com/lincolnloop/python-qrcode")
    (synopsis "QR Code image generator")
    (description "This package provides a pure Python QR Code generator
     module.  It uses the Python Imaging Library (PIL) to allow for the generation
     of QR Codes.

     In addition this package provides a command line tool to generate QR codes and
     either write these QR codes to a file or do the output as ascii art at the
     console.")
    (license license:bsd-3)))

(define-public python-rst2ansi
  (package
    (name "python-rst2ansi")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rst2ansi" version))
       (sha256
        (base32
         "0vzy6gd60l79ff750scl0sz48r1laalkl6md6dwzah4dcadgn5qv"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-docutils))
    (home-page "https://github.com/Snaipe/python-rst-to-ansi")
    (synopsis "Convert RST to ANSI-decorated console output")
    (description
     "Python module dedicated to rendering RST (reStructuredText) documents
     to ansi-escaped strings suitable for display in a terminal.")
    (license license:expat)))

(define-public python-ansi2html
  (package
    (name "python-ansi2html")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ansi2html" version))
       (sha256
        (base32
         "1wa00zffprb78w1mqq90dk47czz1knanys2a40zbw2vyapd5lp9y"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock python-nose))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/ralphbean/ansi2html")
    (synopsis "Convert ANSI-decorated console output to HTML")
    (description
     "@command{ansi2html} is a Python library and command line utility for
     converting text with ANSI color codes to HTML or LaTeX.")
    (license license:gpl3+)))

(define-public python-easy-ansi
  (package
    (name "python-easy-ansi")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/joeysbytes/easy-ansi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0albh55ynzs98qy9pln4qaxw5qhhh3lk09jy9bx19gycrp1c3lc3"))))
    (build-system python-build-system)
    (home-page "https://gitlab.com/joeysbytes/easy-ansi")
    (synopsis "Terminal framework API")
    (description
     "Easy ANSI is a terminal framework API to give you an easy way to use
     colors, cursor control movements, and line/box drawing.  It is not meant as a
     replacement to more full-featured frameworks (such as curses or urwid), but as
     a tool to quickly create nice-looking screens in your terminal window.  You
     can even create animations with the cursor controls.")
    (license license:expat)))

(define-public python-ddt
  (package
    (name "python-ddt")
    (version "1.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ddt" version))
       (sha256
        (base32
         "0y2k756qjz1rhpivi60hy29b4bf0bh3wck39i1mn6pkil9k779k4"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/datadriventests/ddt")
    (synopsis "Data-Driven Tests")
    (description
     "Data-Driven Tests (@dfn{DDT}) allow you to multiply one test case by
     running it with different test data, and make it appear as multiple test
     cases.")
    (license license:expat)))

(define-public python-pycountry
  (package
    (name "python-pycountry")
    (version "22.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycountry" version))
       (sha256
        (base32
         "0ihnkh86zz01vi46gcwgq6h71jrpj7hq71zi13c98n2qdhj3l5mj"))))
    (build-system python-build-system)
    (home-page "https://bitbucket.org/flyingcircus/pycountry")
    (synopsis "ISO databases for languages, countries, currencies, etc.")
    (description
     "@code{pycountry} provides the ISO databases for the standards:
     @enumerate
     @item 639-3 (Languages)
     @item 3166 (Countries)
     @item 3166-3 (Deleted Countries)
     @item 3166-2 (Subdivisions of countries)
     @item 4217 (Currencies)
     @item 15924 (Scripts)
     @end enumerate
     It includes a copy from Debian’s pkg-isocodes and makes the data accessible
     through a Python API.")
    (license license:lgpl2.1+)))

(define-public python-pycountry@20.7.3
  (package
    (inherit python-pycountry)
    (name "python-pycountry")
    (version "20.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycountry" version))
       (sha256
        (base32 "0hnbabsmqimx5hqh0jbd2f64i8fhzhhbrvid57048hs5sd9ll241"))))))

(define-public python-pycosat
  (package
    (name "python-pycosat")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycosat" version ".zip"))
       (sha256
        (base32
         "1vg0f2fwcybpdqv92z0hwdl603n2safh3fqvjjxkksd78r4qg6ac"))))
    ;; TODO: Unundle picosat. http://fmv.jku.at/picosat/
    (build-system python-build-system)
    (native-inputs
     (list unzip))
    (home-page "https://github.com/ContinuumIO/pycosat")
    (synopsis "Bindings to picosat (a SAT solver)")
    (description
     "This package provides efficient Python bindings to @code{picosat} on
     the C level.  When importing pycosat, the @code{picosat} solver becomes part
     of the Python process itself.  @code{picosat} is a @dfn{Boolean Satisfiability
                                                                     Problem} (SAT) solver.")
    (license license:expat)))

(define-public python-pypeg2
  (package
    (name "python-pypeg2")
    (version "2.15.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyPEG2" version))
       (sha256
        (base32
         "0v8ziaam2r637v94ra4dbjw6jzxz99gs5x4i585kgag1v204yb9b"))))
    (build-system python-build-system)
    (propagated-inputs (list python-lxml))
    (arguments
     ;;https://bitbucket.org/fdik/pypeg/issues/36/test-failures-on-py35
     '(#:tests? #f))
    (home-page "https://fdik.org/pyPEG/")
    (synopsis "Parsing Expression Grammars in Python")
    (description "PyPEG is an intrinsic parser interpreter framework for
     Python.  It is based on Parsing Expression Grammars, PEG.  With pyPEG you can
     parse many formal languages.")
    (license license:gpl2)))

(define-public python-incremental
  (package
    (name "python-incremental")
    (version "17.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "incremental" version))
       (sha256
        (base32
         "1cylxdz1cnkm5g3pklna3h2n0i0rks95ir1pnpxfnvpkmab1cxbv"))))
    (build-system python-build-system)
    (home-page "https://github.com/hawkowl/incremental")
    (synopsis "Library for versioning Python projects")
    (description "Incremental is a small library that versions your Python
     projects.")
    (license license:expat)))

(define-public python-invoke
  (package
    (name "python-invoke")
    (home-page "https://www.pyinvoke.org/")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "invoke" version))
              (sha256
               (base32
                "1lsql9daabfr31c7syva5myc5bka45k57ygs9fliv63qrwp1wk9p"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: Requires many dependencies that are not yet in Guix.
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-python2-code
           (lambda _
             (delete-file-recursively "invoke/vendor/yaml2")))
         (add-after 'unpack 'fix-bash-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((bash (assoc-ref inputs "bash")))
               (substitute* "invoke/config.py"
                 (("shell = \"/bin/bash\"")
                  (string-append "shell = \"" bash "/bin/bash\"")))))))))
    (inputs
     `(("bash" ,bash-minimal)))
    (synopsis "Pythonic task execution")
    (description
     "Invoke is a Python task execution tool and library, drawing inspiration
     from various sources to arrive at a powerful and clean feature set.  It is
     evolved from the Fabric project, but focuses on local and abstract concerns
     instead of servers and network commands.")
    (license license:bsd-3)))

(define-public python-automat
  (package
    (name "python-automat")
    (version "20.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Automat" version))
              (sha256
               (base32
                "0cyzrcqiibwdsp4y0djkllnzab8m5faa4s0d1kpi23k1fhy80ybr"))))
    (build-system python-build-system)
    ;; We disable the tests because they require python-twisted, while
    ;; python-twisted depends on python-automat.  Twisted is optional, but the
    ;; tests fail if it is not available.  Also see
    ;; <https://github.com/glyph/automat/issues/71>.
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         ;; Remove script, because it depends on python-twisted.
         (add-after 'unpack 'remove-entrypoint
           (lambda _
             (substitute* "setup.py"
               (("\"automat-visualize = automat._visualize:tool\"") "")))))))
    (native-inputs
     (list python-m2r python-setuptools-scm python-graphviz))
    (propagated-inputs
     (list python-six python-attrs))
    (home-page "https://github.com/glyph/Automat")
    (synopsis "Self-service finite-state machines")
    (description "Automat is a library for concise, idiomatic Python
     expression of finite-state automata (particularly deterministic finite-state
                                                       transducers).")
    (license license:expat)))

(define-public python-m2r
  (package
    (name "python-m2r")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "m2r" version))
              (sha256
               (base32
                "16gdm8i06jjmlpvckpfmlkr4693dh0vs192vgsqn84fsdkbbm45z"))
              (modules '((guix build utils)))
              (snippet
               ;; Adjust test regex for Python 3.10 compatibility.
               ;; Taken from upstream pull request:
               ;; https://github.com/miyakogi/m2r/pull/62
               '(substitute* "tests/test_cli.py"
                  (("self.assertIn\\('optional arguments:', message\\)")
                   "self.assertRegex(message, r'option(s|al arguments):')")))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-docutils python-mistune))
    (native-inputs
     (list python-pygments python-mock))
    (home-page "https://github.com/miyakogi/m2r")
    (synopsis "Markdown to reStructuredText converter")
    (description "M2R converts a markdown file including reST markups to valid
     reST format.")
    (license license:expat)))

(define-public python-constantly
  (package
    (name "python-constantly")
    (version "15.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "constantly" version))
              (sha256
               (base32
                "0dgwdla5kfpqz83hfril716inm41hgn9skxskvi77605jbmp4qsq"))))
    (build-system python-build-system)
    (home-page "https://github.com/twisted/constantly")
    (synopsis "Symbolic constants in Python")
    (description "Constantly is a Python library that provides symbolic
     constant support.  It includes collections and constants with text, numeric,
     and bit flag values.")
    (license license:expat)))

(define-public python-attrdict
  (package
    (name "python-attrdict")
    (version "2.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "attrdict" version))
              (sha256
               (base32
                "0w3vsz64j9npxfgh83hghsh161wwkrx1fxqi1533js2wnnc0dj9m"))))
    (build-system python-build-system)
    ;; The package is no longer maintained and tests need some work.
    (arguments '(#:tests? #f))
    (propagated-inputs (list python-six))
    (home-page "https://github.com/bcj/AttrDict")
    (synopsis "Attribute-style access dictionaries")
    (description
     "This package provides mapping objects whose elements can be accessed
both as keys and as attributes.")
    (license license:expat)))

(define-public python-attrs
  (package
    (name "python-attrs")
    (version "21.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "attrs" version))
              (sha256
               (base32
                "1yzmwi5d197p0qhl7rl4xi9q1w8mk9i3zn6hrl22knbcrb1slspg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'remove-test-hypothesis-deadlines
                    (lambda _
                      (substitute* "tests/test_make.py"
                        (("assume, given") "assume, given, settings")
                        (("( +)@given" all spaces)
                         (string-append spaces "@settings(deadline=None)\n" all)))))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest")))))))
    (native-inputs
     (list python-coverage python-hypothesis python-pympler python-pytest
           python-six))
    (home-page "https://github.com/python-attrs/attrs/")
    (synopsis "Attributes without boilerplate")
    (description "@code{attrs} is a Python package with class decorators that
     ease the chores of implementing the most common attribute-related object
     protocols.")
    (license license:expat)))

(define-public python-attrs-bootstrap
  (package
    (inherit python-attrs)
    (name "python-attrs-bootstrap")
    (native-inputs `())
    (arguments `(#:tests? #f))))

(define-public python-cliapp
  (package
    (name "python-cliapp")
    (version "1.20180812.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "http://git.liw.fi/cgi-bin/cgit/cgit.cgi/cliapp/snapshot/cliapp-"
             version ".tar.gz"))
       (sha256
        (base32
         "1c1jlblbns8qhiaqjpg4xi6lip8xwfc5w643p43rg543havaj45x"))))
    (build-system python-build-system)
    (arguments
     `(;; XXX: The tests only do style and coverage checks, which
       ;; fails due to deprecation warnings, etc.
       #:tests? #f))
    (native-inputs
     (list python-coverage-test-runner python-pep8))
    (propagated-inputs
     (list python-pyaml))
    (home-page "https://liw.fi/cliapp/")
    (synopsis "Python framework for command line programs")
    (description "@code{cliapp} is a Python framework for command line
     programs.  It contains the typical stuff such programs need to do, such
     as parsing the command line for options, and iterating over input files.")
    (license license:gpl2+)))

(define-public python-ttystatus
  (package
    (name "python-ttystatus")
    (version "0.38")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "http://git.liw.fi/ttystatus")
             ;; There are no tags after ttystatus-0.36.
             (commit "e9fc573326c5d1348f5fe56263b4f7a8c32f58c9")))
       (sha256
        (base32 "0v49q839nrwdm19c83wfmj6n2kw80xslwq9k0n5509r2h7wzjiqj"))
       (file-name (git-file-name name version))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage-test-runner python-pep8))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; check phase needs to be run before the build phase. If not,
         ;; coverage-test-runner looks for tests for the built source files,
         ;; and fails.
         (delete 'check)
         (add-before 'build 'check
           (lambda _ (invoke "make" "check"))))))
    (home-page "https://liw.fi/ttystatus/")
    (synopsis "Python library for progress reporting and
     status updates on terminals")
    (description "@code{ttystatus} is a Python library for showing progress
     reporting and status updates on terminals, for command line programs.
     Output is automatically adapted to the width of the terminal: truncated
     if it does not fit, and resized if the terminal size changes.")
    (license license:gpl3+)))

(define-public python-astroid
  (package
    (name "python-astroid")
    (version "2.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/PyCQA/astroid")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19iiys4233cicpm48fd7lrkm31kk47qiv44wvk952rqbcn4rd2dh"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-lazy-object-proxy python-typing-extensions python-wrapt))
    (native-inputs
     (list python-pytest python-pytest-runner))
    (home-page "https://github.com/PyCQA/astroid")
    (synopsis "Python source code base representation")
    (description "@code{python-astroid} provides a common base representation
of Python source code for projects such as pychecker, pyreverse, pylint, etc.
It provides a compatible representation which comes from the _ast module.  It
rebuilds the tree generated by the builtin _ast module by recursively walking
down the AST and building an extended ast.  The new node classes have
additional methods and attributes for different usages.  They include some
support for static inference and local name scopes.  Furthermore, astroid
builds partial trees by inspecting living objects.")
    (license license:lgpl2.1+)))

(define-public python-isbnlib
  (package
    (name "python-isbnlib")
    (version "3.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "isbnlib" version))
       (sha256
        (base32
         "0iin0x2xqwyphyyzd0mzrq5v5xm7b6dlbb294k4dywra5qvbrgzm"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))  ; No test
    (home-page "https://github.com/xlcnd/isbnlib")
    (synopsis "Python library to work with ISBN strings")
    (description "@code{python-isbnlib} is a (pure) python library that provides
     several useful methods and functions to validate, clean, transform, hyphenate and
     get metadata for ISBN strings.  Its origin was as the core of isbntools.  This short
     version, is suitable to be include as a dependency in other projects.")
    (license license:lgpl3+)))

(define-public python-isort
  (package
    (name "python-isort")
    (version "5.10.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             ;; Tests pass only from the Github sources
             (url "https://github.com/timothycrosley/isort")
             (commit version)))
       (file-name (git-file-name name version))
       (modules '((guix build utils)))
       (snippet '(for-each delete-file (find-files "." "\\.whl$")))
       (sha256
        (base32
         "09spgl2k9xrprr5gbpfc91a8p7mx7a0c64ydgc91b3jhrmnd9jg1"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'loosen-requirements
           (lambda _
             ;; Permit newer versions of black.
             (substitute* "example_isort_formatting_plugin/pyproject.toml"
               (("\\^20\\.08b1")
                ">= 20.08b1"))))
         ;; A foretaste of what our future python-build-system will need to
         ;; do.
         (replace 'build
           (lambda _
             (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
         (replace 'install
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out"))
                   (whl (car (find-files "dist" "\\.whl$"))))
               (invoke "pip" "--no-cache-dir" "--no-input"
                       "install" "--no-deps" "--prefix" out whl))))
         (add-after 'install 'install-example-plugins
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               ;; Patch to use the core poetry API.
               (substitute* '("example_isort_formatting_plugin/pyproject.toml"
                              "example_isort_sorting_plugin/pyproject.toml"
                              "example_shared_isort_profile/pyproject.toml")
                 (("poetry>=0.12")
                  "poetry-core>=1.0.0")
                 (("poetry.masonry.api")
                  "poetry.core.masonry.api"))
               ;; Build the example plugins.
               (for-each (lambda (source-directory)
                           (invoke "python" "-m" "build" "--wheel"
                                   "--no-isolation" "--outdir=dist"
                                   source-directory))
                         '("example_isort_formatting_plugin"
                           "example_isort_sorting_plugin"
                           "example_shared_isort_profile"))
               ;; Install them to temporary storage, for the test.
               (setenv "HOME" (getcwd))
               (let ((example-whls (find-files "dist" "^example.*\\.whl$")))
                 (apply invoke "pip" "--no-cache-dir" "--no-input"
                        "install"  "--user" "--no-deps" example-whls)))))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (let ((bin (string-append (assoc-ref outputs "out") "/bin")))
                 (setenv "PATH" (string-append (getenv "PATH") ":" bin)))
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv" "tests/unit/"
                       "-k" "not test_gitignore" ;requires git
                       "--ignore=tests/unit/test_deprecated_finders.py")))))))
    (native-inputs
     (list python-black
           python-colorama
           python-hypothesmith
           python-libcst-minimal
           python-natsort
           python-poetry-core
           python-pylama
           python-pypa-build
           python-pytest-mock
           python-pytest))
    (home-page "https://github.com/PyCQA/isort")
    (synopsis "Python utility/library to sort python imports")
    (description "@code{python-isort} is a python utility/library to sort
     imports alphabetically, and automatically separated into sections.  It
     provides a command line utility, a python library and plugins for various
     editors.")
    (license license:expat)))

(define-public python-configparser
  (package
    (name "python-configparser")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "configparser" version))
       (sha256
        (base32
         "1priacxym85yjcf68hh38w55nqswaxp71ryjyfdk222kg9l85ln7"))))
    (native-inputs
     (list python-setuptools-scm))
    (build-system python-build-system)
    (home-page "https://github.com/jaraco/configparser/")
    (synopsis "Backport of configparser from python 3.5")
    (description "@code{python-configparser} is a backport of
     @code{configparser} from Python 3.5 so that it can be used directly
     in other versions.")
    (license license:expat)))

(define-public python-iniconfig
  (package
    (name "python-iniconfig")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "iniconfig" version))
       (sha256
        (base32
         "0ckzngs3scaa1mcfmsi1w40a1l8cxxnncscrxzjjwjyisx8z0fmw"))))
    (build-system python-build-system)
    (home-page "https://github.com/RonnyPfannschmidt/iniconfig")
    (synopsis "Simple INI-file parser")
    (description "The @code{iniconfig} package provides a small and simple
     INI-file parser module having a unique set of features ; @code{iniconfig}
     @itemize
     @item maintains the order of sections and entries              ;
     @item supports multi-line values with or without line-continuations ;
     @item supports \"#\" comments everywhere                            ;
     @item raises errors with proper line-numbers                        ;
     @item raises an error when two sections have the same name.
     @end itemize")
    (license license:expat)))

(define-public python-mamba
  (package
    (name "python-mamba")
    (version "0.11.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "mamba" version))
              (sha256
               (base32
                "15m4dpnpv9m60pdaygvwgi43fwqaivs3qxfxhspwrp47sbgwdkvm"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))  ; No test
    (propagated-inputs
     (list python-clint python-coverage))
    (home-page "https://nestorsalceda.com/mamba/")
    (synopsis "Test runner for Python")
    (description
     "Mamba is a Behaviour-Driven Development tool for Python developers.
     Is heavily influenced from RSpec, Mocha, Jasmine or Ginkgo.")
    (license license:expat)))

(define-public python-mando
  (package
    (name "python-mando")
    (version "0.7.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "mando" version))
              (sha256
               (base32
                "001mikga36i811pbc95rb45m2kzivkx4xb0fn3pzl4xnnjcskfhq"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-rst2ansi python-six))
    (native-inputs
     (list python-pytest))
    (home-page "https://mando.readthedocs.org/")
    (synopsis
     "Wrapper around argparse, allowing creation of complete CLI applications")
    (description
     "This package is a wrapper around argparse, allowing you to write complete CLI
     applications in seconds while maintaining all the flexibility.")
    (license license:expat)))

(define-public python-mwclient
  (package
    (name "python-mwclient")
    (version "0.10.1")
    (source
     (origin
       (method git-fetch)
       ;; The PyPI version wouldn't contain tests.
       (uri (git-reference
              (url "https://github.com/mwclient/mwclient")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "120snnsh9n5svfwkyj1w9jrxf99jnqm0jk282yypd3lpyca1l9hj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-requests-oauthlib python-six))
    (native-inputs
     (list python-mock python-pytest python-pytest-cov
           python-pytest-runner python-responses))
    (home-page "https://github.com/btongminh/mwclient")
    (synopsis "MediaWiki API client")
    (description "This package provides a MediaWiki API client.")
    (license license:expat)))

(define-public python-kneed
  (package
    (name "python-kneed")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kneed" version))
       (sha256
        (base32 "0vkwi0pr7nfkp3c46hnmx0275yx68v96v10rmspv0wis33x6f39l"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-matplotlib python-numpy python-scipy))
    (home-page "https://github.com/arvkevi/kneed")
    (synopsis "Knee-point detection in Python")
    (description "This package implements the kneedle algorithm.  Given a set
of x and y values, kneed will return the knee point of the function.  The knee
point is the point of maximum curvature.")
    (license license:bsd-3)))

(define-public python-utils
  (package
    (name "python-utils")
    (version "2.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "python-utils" version))
              (sha256
               (base32
                "12c0glzkm81ljgf6pwh0d4rmdm1r7vvgg3ifzp8yp9cfyngw07zj"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (delete-file "pytest.ini")
             (invoke "pytest" "-vv"))))))
    (native-inputs
     `(("pytest-runner" ,python-pytest-runner)
       ("pytest" ,python-pytest)
       ("six" ,python-six)))
    (home-page "https://github.com/WoLpH/python-utils")
    (synopsis "Convenient utilities not included with the standard Python install")
    (description
      "Python Utils is a collection of small Python functions and classes which
     make common patterns shorter and easier.")
    (license license:bsd-2)))

(define-public python-diff-match-patch
  (package
    (name "python-diff-match-patch")
    (version "20121119")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "diff-match-patch" version))
        (sha256
         (base32
          "0k1f3v8nbidcmmrk65m7h8v41jqi37653za9fcs96y7jzc8mdflx"))))
    (build-system python-build-system)
    (home-page "https://code.google.com/p/google-diff-match-patch")
    (synopsis "Synchronize plain text")
    (description "Diff Match and Patch libraries offer robust algorithms to
     perform the operations required for synchronizing plain text.")
    (license license:asl2.0)))

(define-public python-icdiff
  (package
    (name "python-icdiff")
    (version "2.0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jeffkaufman/icdiff")
                    (commit (string-append "release-" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "14gr9j2h7sfw47pwfzspm4zinywhqmzm4a0qz5c2k9wbixz120a4"))))
    (build-system python-build-system)
    (home-page "https://www.jefftk.com/icdiff")
    (synopsis "Improved colored diff")
    (description "This package provides colored diff functions that highlight
parts of the lines that were modified.")
    (license license:psfl)))

(define-public python-dirsync
  (package
    (name "python-dirsync")
    (version "2.2.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "dirsync" version))
        (sha256
         (base32
          "1gm82jddm1lkazdi8lfsl1b3vi1z0252ng60mzjym8irnv94qfhy"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/tkhyn/dirsync")
    (synopsis "Advanced directory tree synchronisation tool")
    (description "Advanced directory tree synchronisation tool.")
    (license license:expat)))

(define-public python-levenshtein
  (package
    (name "python-levenshtein")
    (version "0.12.2")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "python-Levenshtein" version))
      (sha256
       (base32
        "1xj60gymwx1jl2ra9razx2wk8nb9cv1i7l8d14qsp8a8s7xra8yw"))))
    (build-system python-build-system)
    (home-page "https://github.com/ztane/python-Levenshtein")
    (synopsis "Fast computation of Levenshtein distance and string similarity")
    (description
     "The Levenshtein Python C extension module contains functions for fast computation of
     @enumerate
     @item Levenshtein (edit) distance, and edit operations
     @item string similarity
     @item approximate median strings, and generally string averaging
     @item string sequence and set similarity
     @end enumerate
     It supports both normal and Unicode strings.")
    (license license:gpl2+)))

(define-public python-scandir
  (package
    (name "python-scandir")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "scandir" version))
       (sha256
        (base32 "1bkqwmf056pkchf05ywbnf659wqlp6lljcdb0y88wr9f0vv32ijd"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "python" "test/run_tests.py"))))))
    (home-page "https://github.com/benhoyt/scandir")
    (synopsis "Directory iteration function")
    (description
     "Directory iteration function like os.listdir(), except that instead of
     returning a list of bare filenames, it yields DirEntry objects that include
     file type and stat information along with the name.  Using scandir() increases
     the speed of os.walk() by 2-20 times (depending on the platform and file
                                                     system) by avoiding unnecessary calls to os.stat() in most cases.

     This package is part of the Python standard library since version 3.5.")
    (license license:bsd-3)))

(define-public python-factory-boy
  (package
    (name "python-factory-boy")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "factory_boy" version))
       (sha256
        (base32 "0pm5lbvnwm0kg5i6z611rg907yw1gy551f2advmpaz041ixjg3d9"))))
    (build-system python-build-system)
    (arguments
     ;; Tests are not included in the tarball.
     `(#:tests? #f))
    (propagated-inputs (list python-faker))
    (home-page "https://github.com/benhoyt/scandir")
    (synopsis "Versatile test fixtures replacement")
    (description "Factory_boy is a fixtures replacement based on thoughtbot’s
factory_girl.  As a fixtures replacement tool, it aims to replace static, hard
to maintain fixtures with easy-to-use factories for complex object.  Instead
of building an exhaustive test setup with every possible combination of corner
cases, factory_boy allows you to use objects customized for the current test,
while only declaring the test-specific fields.")
    (license license:expat)))

(define-public python-translate-toolkit
  (package
    (name "python-translate-toolkit")
    (version "3.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "translate-toolkit" version ".tar.gz"))
       (sha256
        (base32 "0m4cpsp7x7h5m5agg4ybscf7y86wla46q2lvxpi2myplb6qlgcli"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-sphinx))
    (propagated-inputs
     (list python-babel
           python-beautifulsoup4
           python-chardet
           python-diff-match-patch
           python-levenshtein
           python-lxml
           python-six
           python-vobject
           python-pyyaml))
    (arguments
     ;; TODO: tests are not run, because they end with
     ;; TypeError: parse() missing 2 required positional arguments: 'tree' and
     ;; 'parse_funcs'
     ;; during test setup.
     (list #:tests? #f
           #:phases
           #~(modify-phases %standard-phases
               ;; translate-toolkit has many optional dependencies (see
               ;; optional.txt), which the sanity check does not understand.
               (delete 'sanity-check))))
    (home-page "https://toolkit.translatehouse.org")
    (synopsis "Tools and API for translation and localization engineering")
    (description
     "Tools and API for translation and localization engineering.  It contains
     several utilities, as well as an API for building localization tools.")
    (license license:gpl2+)))


(define-public python-packaging
  (package/inherit python-packaging-bootstrap
    (name "python-packaging")
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv")
                          (format #t "test suite not run~%")))))))
    (native-inputs
     `(("python-pretend" ,python-pretend)
       ("python-pytest" ,python-pytest)))
    (propagated-inputs
     `(("python-pyparsing" ,python-pyparsing)
       ("python-six" ,python-six)))
    (home-page "https://github.com/pypa/packaging")
    (synopsis "Core utilities for Python packages")
    (description "Packaging is a Python module for dealing with Python packages.
     It offers an interface for working with package versions, names, and dependency
     information.")
    ;; From 'LICENSE': This software is made available under the terms of
    ;; *either* of the licenses found in LICENSE.APACHE or LICENSE.BSD.
    ;; Contributions to this software is made under the terms of *both* these
    ;; licenses.
    (license (list license:asl2.0 license:bsd-2))))

(define-public python-relatorio
  (package
    (name "python-relatorio")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "relatorio" version))
       (sha256
        (base32
         "09nhrz80dfm60nssbvjgz4czzy4yzfa8gxczcdlzbgcnnvm914vb"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-lxml python-genshi))
    (native-inputs
     (list python-magic))
    (home-page "https://relatorio.tryton.org/")
    (synopsis "Templating library able to output ODT and PDF files")
    (description "Relatorio is a templating library which provides a way to
     easily output ODT, ODS, PNG, SVG and several other kinds of files.  Support
     for more filetypes can be easily added by creating plugins for them.")
    (license license:gpl3+)))

(define-public python-radon
  (package
    (name "python-radon")
    (version "5.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "radon" version))
       (sha256
        (base32
         "1vmf56zsf3paa1jadjcjghiv2kxwiismyayq42ggnqpqwm98f7fb"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'relax-requirements
                    (lambda _
                      (substitute* "setup.py"
                        ((".*'future'.*")
                         "")
                        (("mando>=0\\.6,<0\\.7")
                         "mando>=0.6")
                        (("colorama==0.4.1")
                         "colorama>=0.4.1"))))
                  (replace 'check
                    (lambda _
                      (invoke "python" "radon/tests/run.py"))))))
    (propagated-inputs (list python-colorama python-mando))
    (native-inputs (list python-pytest python-pytest-mock))
    (home-page "https://radon.readthedocs.org/")
    (synopsis "Code Metrics in Python")
    (description "Radon is a Python tool which computes various code metrics.
     Supported metrics are:
     @itemize @bullet
     @item raw metrics: SLOC, comment lines, blank lines, &c.
     @item Cyclomatic Complexity (i.e., McCabe’s Complexity)
     @item Halstead metrics (all of them)
     @item the Maintainability Index (a Visual Studio metric)
     @end itemize")
    (license license:expat)))

(define-public python-sure
  (package
    (name "python-sure")
    (version "1.4.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sure" version))
       (sha256
        (base32
         "1and0drq8w9iplsic22n2h7hkpyq03a1mbqk4sgcdqhqzdqm539w"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-mock python-six))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/gabrielfalcao/sure")
    (synopsis "Automated testing library in python for python")
    (description
     "Sure is a python library that leverages a DSL for writing assertions.
     Sure is heavily inspired by @code{RSpec Expectations} and @code{should.js}.")
    (license license:gpl3+)))

(define-public python-misaka
  (package
    (name "python-misaka")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "misaka" version))
       (sha256
        (base32
         "1mzc29wwyhyardclj1vg2xsfdibg2lzb7f1azjcxi580ama55wv2"))))
    (build-system python-build-system)
    (arguments
     `(;; Line 37 of setup.py calls self.run_command('develop')
       ;; in the 'check' phase. This command seems to be trying
       ;; to write to
       ;; /gnu/store/...-python-<version>/lib/python<version>/site-packages/
       ;; for which it does not have the permission to write.
       #:tests? #f))
    (propagated-inputs
     (list python-cffi))
    (home-page "https://github.com/FSX/misaka")
    (synopsis "Python binding for Hoedown")
    (description
     "@code{Misaka} is a CFFI-based binding for @code{Hoedown}, a fast markdown processing
     library written in C.  It features a fast HTML renderer and functionality to make custom
     renderers (e.g. man pages or LaTeX).")
    (license license:expat)))

(define-public python-jsonpointer
  (package
    (name "python-jsonpointer")
    (version "1.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonpointer" version))
       (sha256
        (base32
         "1cg0gvgqjysydv6p45v4jywg1jb3v48c7m3cbpi57zgf6nndr9cz"))))
  (build-system python-build-system)
  (home-page "https://github.com/stefankoegl/python-json-pointer")
  (synopsis "Identify specific nodes in a JSON document")
  (description "@code{jsonpointer} allows you to access specific nodes
     by path in a JSON document (see RFC 6901).")
  (license license:bsd-3)))

(define-public python-jsonpatch
  (package
    (name "python-jsonpatch")
    (version "1.16")
    (source
     (origin
       (method git-fetch)
       ;; pypi version lacks tests.js
       (uri (git-reference
              (url "https://github.com/stefankoegl/python-json-patch")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0k9pff06lxama3nhsc7cdxbp83422bdy8ifs52i6xkas8hpyzfzr"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-jsonpointer))
    (home-page "https://github.com/stefankoegl/python-json-patch")
    (synopsis "Applying JSON Patches in Python 2.6+ and 3.x")
    (description "@code{jsonpatch} is a library and program that allows
     applying JSON Patches according to RFC 6902.")
    (license license:bsd-3)))

(define-public python-jsonpatch-0.4
  (package (inherit python-jsonpatch)
    (name "python-jsonpatch")
    (version "0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/stefankoegl/python-json-patch")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fq02y57kinyknxjcav0slcb0k9mwdffqw2hnlhdkpj7palh2mwk"))))))

(define-public python-rfc3986
  (package
    (name "python-rfc3986")
    (version "1.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rfc3986" version))
              (sha256
               (base32
                "17dvx15m3r49bmif5zlli8kzjd6bys6psixzbp14sd5367d9h8qi"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-v"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://rfc3986.readthedocs.io/")
    (synopsis "Parse and validate URI references")
    (description
     "@code{rfc3986} is a Python implementation of RFC@tie{}3986 including
     validation and authority parsing.  This module also supports RFC@tie{}6874
     which adds support for zone identifiers to IPv6 addresses.")
    (license license:asl2.0)))

(define-public python-rfc3987
  (package
    (name "python-rfc3987")
    (version "1.3.7")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "rfc3987" version))
      (sha256
       (base32
        "192pclzs2y0yaywqkrlvd0x73740q310kvqvm6jldhi619mq59wi"))))
    (build-system python-build-system)
    (home-page "https://pypi.org/project/rfc3987/")
    (synopsis "Parsing and validation of URIs (RFC 3986) and IRIs (RFC 3987)")
    (description "@code{rfc3987} provides routines for parsing and
     validation of URIs (see RFC 3986) and IRIs (see RFC 3987).")
    (license license:gpl3+)))

;; The latest commit contains fixes for building with both python3 and python2.
(define-public python-rfc6555
  (let ((commit "1a181b432312731f6742a5eb558dae4761d32361")
        (revision "1"))
    (package
      (name "python-rfc6555")
      (version (git-version "0.0.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                       (url "https://github.com/sethmlarson/rfc6555")
                       (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1bxl17j9vs69cshcqnlwamr03hnykxqnwz3mdgi6x3s2k4q18npp"))))
      (build-system python-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (replace 'check
             (lambda* (#:key tests? #:allow-other-keys)
               (if tests?
                 ;; Other tests require network access.
                 (invoke "pytest" "tests/test_ipv6.py")
                 #t))))))
      (native-inputs
       (list python-pytest))
      (home-page "https://pypi.org/project/rfc6555/")
      (synopsis "Python implementation of RFC 6555")
      (description
       "Python implementation of the Happy Eyeballs Algorithm described in RFC
     6555.  Provided with a single file and dead-simple API to allow easy vendoring
     and integration into other projects.")
      (license license:asl2.0))))

(define-public python-bagit
  (package
    (name "python-bagit")
    (version "1.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "bagit" version))
        (sha256
         (base32
          "1m6y04qmig0b5hzb35lnaw3d2yfydb7alyr1579yblvgs3da6j7j"))))
    (build-system python-build-system)
    (native-inputs
     (list python-setuptools-scm python-coverage python-mock))
    (home-page "https://libraryofcongress.github.io/bagit-python/")
    (synopsis "Create and validate BagIt packages")
    (description "Bagit is a Python library and command line utility for working
     with BagIt style packages.  BagIt is a minimalist packaging format for digital
     preservation.")
    (license license:cc0)))

(define-public python-prov
  (package
    (name "python-prov")
    (version "2.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "prov" version))
        (sha256
         (base32
          "1vi2fj31vygfcqrkimdmk52q2ldw08g9fn4v4zlgdfgcjlhqyhxn"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dateutil python-lxml python-networkx python-rdflib-5))
    (native-inputs
     (list graphviz python-pydot))
    (home-page "https://github.com/trungdong/prov")
    (synopsis
     "W3C Provenance Data Model supporting PROV-JSON, PROV-XML and PROV-O (RDF)")
    (description
     "This package provides a library for W3C Provenance Data Model supporting
     PROV-O (RDF), PROV-XML, PROV-JSON import/export.")
    (license license:expat)))

(define-public python-arcp
  (package
    (name "python-arcp")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "arcp" version))
        (sha256
         (base32
          "1p8mfyjssa6pbn5dp6pyzv9yy6kwm2rz5jn2kjbq5vy9f9wsq5sw"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "http://arcp.readthedocs.io/")
    (synopsis
     "Archive and Package URI parser and generator")
    (description
     "@acronym{arcp, Archive and Package} provides functions for creating
     @code{arcp_} URIs, which can be used for identifying or parsing hypermedia files
     packaged in an archive or package, like a ZIP file.  arcp URIs can be used to
     consume or reference hypermedia resources bundled inside a file archive or an
     application package, as well as to resolve URIs for archive resources within a
     programmatic framework.  This URI scheme provides mechanisms to generate a
     unique base URI to represent the root of the archive, so that relative URI
     references in a bundled resource can be resolved within the archive without
     having to extract the archive content on the local file system.  An arcp URI can
     be used for purposes of isolation (e.g. when consuming multiple archives),
     security constraints (avoiding \"climb out\" from the archive), or for
     externally identiyfing sub-resources referenced by hypermedia formats.")
    (license license:asl2.0)))

(define-public python-shellescape
  (package
    (name "python-shellescape")
    (version "3.8.1")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://github.com/chrissimpkins/shellescape")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0wzccxk139qx1lb2g70f5b2yh9zq15nr2mgvqdbfabg5zm0vf1qw"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "tests/test_shellescape.py"))
             #t)))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/chrissimpkins/shellescape")
    (synopsis
     "Shell escape a string to safely use it as a token in a shell command")
    (description
     "The shellescape Python module defines the @code{shellescape.quote()}
     function that returns a shell-escaped version of a Python string.  This is a
     backport of the @code{shlex.quote()} function from Python 3.8 that makes it
     accessible to users of Python 3 versions < 3.3 and all Python 2.x versions.")
    (license license:expat)))

(define-public python-validators
  (package
    (name "python-validators")
    (version "0.18.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "validators" version))
              (sha256
               (base32
                "19lypf7hm7p203ay3v8zmckc5rv6889zkfdm16nki1972f99mk9p"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest" "-vv"))))))
    (propagated-inputs
     (list python-decorator python-six))
    (native-inputs
     (list python-flake8 python-isort python-pytest))
    (home-page "https://github.com/kvesteri/validators")
    (synopsis "Data validation library")
    (description
     "This package contains validators for different things such as email
     addresses, IP addresses, URLs, hashes and more.  It has been designed to
     be easy to use and not require defining a schema or form just to validate
     some input.")
    (license license:expat)))

(define-public python-validate-email
  (package
    (name "python-validate-email")
    (version "1.3")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "validate_email" version))
      (sha256
       (base32
        "1bxffaf5yz2cph8ki55vdvdypbwkvn2xr1firlcy62vqbzf1jivq"))))
    (build-system python-build-system)
    (home-page "https://github.com/syrusakbary/validate_email")
    (synopsis "Verifies if an email address is valid and really exists")
    (description "@code{validate_email} can be used to verify if an email
     address is valid and really exists.")
    (license license:lgpl3+)))

(define-public python-flex
  (package
    (name "python-flex")
    (version "6.10.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "flex" version))
      (sha256
       (base32
        "00pamnwla3khk8nyla7y28dq9jnh69swd7f4jfsl7sn1izs8n8zk"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-click
           python-iso8601
           python-jsonpointer
           python-pyyaml
           python-requests
           python-rfc3987
           python-six
           python-validate-email))
    (home-page "https://github.com/pipermerriam/flex")
    (synopsis "Validates Swagger schemata")
    (description "@code{flex} can be used to validate Swagger schemata.")
    (license license:bsd-3)))

(define-public python-marshmallow
  (package
    (name "python-marshmallow")
    (version "3.9.1")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "marshmallow" version))
      (sha256
       (base32
        "0kizhh3mnhpa08wfnsv1gagy22bpxzxszgbiylkhpz1d8qvwrykk"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dateutil python-simplejson))
    (native-inputs
     (list python-pytest python-pytz))
    (home-page "https://github.com/marshmallow-code/marshmallow")
    (synopsis "Convert complex datatypes to and from native
     Python datatypes")
    (description "@code{marshmallow} provides a library for converting
     complex datatypes to and from native Python datatypes.")
    (license license:expat)))

(define-public python-marshmallow-jsonapi
  (package
    (name "python-marshmallow-jsonapi")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "marshmallow-jsonapi" version))
       (sha256
        (base32 "1d9pxcgmln4gls99vwj1h24qv0lz7fb2jqmqrsiv1pid1snc125x"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-marshmallow))
    (native-inputs
     (list python-faker
           python-flake8
           python-flake8-bugbear
           python-flask
           python-mock
           python-pre-commit
           python-pytest
           python-tox))
    (home-page "https://github.com/marshmallow-code/marshmallow-jsonapi")
    (synopsis "JSON:API 1.0 formatting with Marshmallow")
    (description
     "The marshmallow-jsonapi package provides a simple way to produce
     @uref{https://jsonapi.org, JSON:API}-compliant data in any Python Web framework.
     It includes optional utilities to integrate with Flask.")
    (license license:expat)))

(define-public python-apispec
  (package
    (name "python-apispec")
    (version "4.0.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "apispec" version))
      (sha256
        (base32
          "12n4w5zkn4drcn8izq68vmixmqvz6abviqkdn4ip0kaax3jjh3in"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest" "-vv"
                              ;; Disable validation tests since they require
                              ;; the optional 'prance' library which is not
                              ;; yet in Guix.
                              "-k" "not openapi_tools_validate"))))))
    (propagated-inputs
     (list python-pyyaml))
    (native-inputs
     (list python-pytest python-marshmallow))
    (home-page "https://github.com/marshmallow-code/apispec")
    (synopsis "Swagger/OpenAPI specification generator")
    (description "@code{python-apispec} is a pluggable API specification
     generator.  It currently supports the OpenAPI specification, formerly known
     as Swagger.")
    (license license:expat)))

(define-public python-flasgger
  (package
    (name "python-flasgger")
    (version "0.6.3")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/rochacbruno/flasgger")
              (commit version)))
        (file-name (git-file-name name version))
        (sha256
          (base32 "0yydxsyjnc0clbrjqb1n7587l6cdqvwdagwxk5hkx01qwdfbkvpn"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (substitute* "Makefile"
               (("flake8 flasgger --ignore=F403")
                "flake8 flasgger --ignore=E731,F403"))
             (invoke "py.test"))))))
    (propagated-inputs
     (list python-flask python-pyyaml python-jsonschema python-mistune
           python-six))
    (native-inputs
     (list python-decorator
           python-flake8
           python-flask-restful
           python-flex
           python-pytest
           python-pytest-cov
           python-marshmallow
           python-apispec))
    (home-page "https://github.com/rochacbruno/flasgger/")
    (synopsis "Extract Swagger specs from your Flask project")
    (description "@code{python-flasgger} allows extracting Swagger specs
     from your Flask project.  It is a fork of Flask-Swagger.")
    (license license:expat)))

(define-public python-swagger-spec-validator
  (package
    (name "python-swagger-spec-validator")
    (version "2.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "swagger-spec-validator" version))
       (sha256
        (base32
         "11g627icrsqwazsncwi0sdvprcj6hwaayw5xk3xsj8d97bmrzqjp"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-jsonschema python-pyyaml python-six))
    (home-page
     "https://github.com/Yelp/swagger_spec_validator")
    (synopsis "Validation of Swagger specifications")
    (description "@code{swagger_spec_validator} provides a library for
     validating Swagger API specifications.")
    (license license:asl2.0)))

(define-public python-apache-libcloud
  (package
    (name "python-apache-libcloud")
    (version "3.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "apache-libcloud" version))
        (sha256
         (base32
          "1b28j265kvibgxrgxx0gwfm6cmv252c8ph1j2vb0cpms8ph5if5v"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-ssh
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "libcloud/compute/ssh.py"
               (("'ssh'")
                (string-append "'" (search-input-file inputs "/bin/ssh")
                               "'")))))
         (add-after 'unpack 'patch-tests
           (lambda _
             (substitute* "libcloud/test/compute/test_ssh_client.py"
               (("^class ShellOutSSHClientTests")
                "@unittest.skip(\"Guix container doesn't have ssh service\")
class ShellOutSSHClientTests"))))
         (add-before 'check 'copy-secret
           (lambda _
             (copy-file "libcloud/test/secrets.py-dist"
                        "libcloud/test/secrets.py"))))))
    (inputs
     (list openssh))
    (propagated-inputs
     (list python-paramiko python-requests))
    (native-inputs
     (list python-lockfile python-mock python-pytest python-pytest-runner
           python-requests-mock))
    (home-page "https://libcloud.apache.org/")
    (synopsis "Unified Cloud API")
    (description "@code{libcloud} is a Python library for interacting with
     many of the popular cloud service providers using a unified API.")
    (license license:asl2.0)))

(define-public python-smmap
  (package
    (name "python-smmap")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "smmap" version))
       (sha256
        (base32 "0ijlnv60y8f41py1wnn5n1a1i81cxd9dfpdhr0k3cgkrcbz8850p"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nosexcover))
    (home-page "https://github.com/Byron/smmap")
    (synopsis "Python sliding window memory map manager")
    (description "@code{smmap} is a pure Python implementation of a sliding
     window memory map manager.")
    (license license:bsd-3)))

(define-public python-regex
  (package
    (name "python-regex")
    (version "2022.1.18")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "regex" version))
              (sha256
               (base32
                "05ir92d0cmv8wkafn3r05j5q47l6shg7cpdblp2a8m407b02vwwp"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "python" "-c"
                     "from regex.test_regex import test_main ; test_main()"))))))
     (home-page "https://bitbucket.org/mrabarnett/mrab-regex")
     (synopsis "Alternative regular expression module")
     (description "This regular expression implementation is backwards-
compatible with the standard @code{re} module, but offers additional
functionality like full case-folding for case-insensitive matches in Unicode.")
     (license license:psfl)))

(define-public python-pyopengl
  (package
    (name "python-pyopengl")
    (version "3.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyOpenGL" version))
       (sha256
        (base32
         "091lp9bpqi8yf1nmyg19xmvw611lrzq2q94cl1k5gnlh0c6vl1s1"))))
    (build-system python-build-system)
    (inputs
     (list mesa freeglut glu))
    (arguments
     `(#:tests? #f ; Tests fail: AttributeError: 'GLXPlatform' object has no
                                        ;attribute 'OSMesa'
       #:phases
       (modify-phases %standard-phases
         (add-before 'build 'fix-paths
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (substitute* '("OpenGL/platform/ctypesloader.py")
               (("filenames_to_try = \\[\\]") "filenames_to_try = [name]"))
             (substitute* '("OpenGL/platform/glx.py" "tests/check_glut_load.py")
               (("'GL'")
                (string-append "'" (assoc-ref inputs "mesa") "/lib/libGL.so'"))
               (("'GLU'")
                (string-append "'" (assoc-ref inputs "glu") "/lib/libGLU.so'"))
               (("'glut',")
                (string-append "'" (assoc-ref inputs "freeglut") "/lib/libglut.so',"))
               (("'GLESv1_CM'")
                (string-append "'" (assoc-ref inputs "mesa") "/lib/libGLESv1_CM.so'"))
               (("'GLESv2'")
                (string-append "'" (assoc-ref inputs "mesa") "/lib/libGLESv2.so'")))
               ;; Not providing libgle. It seems to be very old.
             #t)))))
    (home-page "http://pyopengl.sourceforge.net")
    (synopsis "Standard OpenGL bindings for Python")
    (description
     "PyOpenGL is the most common cross platform Python binding to OpenGL and
related APIs.  The binding is created using the standard @code{ctypes}
library.")
    (license license:bsd-3)))

(define-public python-pyopengl-accelerate
  (package
    (inherit python-pyopengl)
    (name "python-pyopengl-accelerate")
    (version "3.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyOpenGL-accelerate" version))
       (sha256
        (base32
         "01iggy5jwxv7lxnj51zbmlbhag9wcb7dvrbwgi97i90n0a5m3r8j"))))
    (inputs
     (list mesa python-numpy)) ; for cython module
                                        ; numpy_formathandler, thus not propagated
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (delete 'fix-paths))))
    (synopsis "Acceleration code for PyOpenGL")
    (description
     "This is the Cython-coded accelerator module for PyOpenGL.")))

(define-public python-rencode
  (package
   (name "python-rencode")
   (version "1.0.5")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "rencode" version))
     (sha256
      (base32
       "0mzwdq1is7kyyr32i5k4iz6g5xxdvmiyc132jnc60p9m6lnwjrpv"))))
   (build-system python-build-system)
   (arguments
    `(#:phases
      (modify-phases %standard-phases
        (add-before 'check 'delete-bogus-test
          ;; This test requires /home/aresch/Downloads, which is not provided by
          ;; the build environment.
          (lambda _
            (delete-file "rencode/t.py")
            #t)))))
   (native-inputs (list pkg-config python-cython))
   (home-page "https://github.com/aresch/rencode")
   (synopsis "Serialization of heterogeneous data structures")
   (description
    "The @code{rencode} module is a data structure serialization library,
similar to @code{bencode} from the BitTorrent project.  For complex,
heterogeneous data structures with many small elements, r-encoding stake up
significantly less space than b-encodings.  This version of rencode is a
complete rewrite in Cython to attempt to increase the performance over the
pure Python module.")
   (license license:bsd-3)))

(define-public python-pysocks
  (package
    (name "python-pysocks")
    (version "1.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PySocks" version))
       (sha256
        (base32
         "184sg65mbmih6ljblfsxcmq5js5l7dj3gpn618w9q5dy3rbh921z"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))
    (home-page "https://github.com/Anorov/PySocks")
    (synopsis "SOCKS client module")
    (description "@code{pysocks} is an updated and semi-actively maintained
version of @code{SocksiPy} with bug fixes and extra features.")
    (license license:bsd-3)))

(define-public python-pydiff
  (package
    (name "python-pydiff")
    (version "0.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pydiff" version))
        (sha256
          (base32
            "1als83h9w0gab24ipyna6khm390qmpnpkc5jksmdbs2xc8hp2z44"))))
    (build-system python-build-system)
    (home-page "https://github.com/myint/pydiff")
    (synopsis "Library to diff two Python files at the bytecode level")
    (description
      "@code{pydiff} makes it easy to look for actual code changes while
ignoring formatting changes.")
    (license license:expat)))

(define-public python-pydub
  (package
    (name "python-pydub")
    (version "0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydub" version))
       (sha256
        (base32
         "03ykn2kp6qglsrzqi5h79z5cp3kl9mknasv0d6jv5jj9k77362lq"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-ffmpeg-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((ffmpeg (assoc-ref inputs "ffmpeg")))
               (substitute* '("pydub/utils.py")
                 (("return \"ffmpeg\"")
                  (string-append "return \"" ffmpeg "/bin/ffmpeg\""))
                 (("return \"ffplay\"")
                  (string-append "return \"" ffmpeg "/bin/ffplay\""))
                 (("return \"ffprobe\"")
                  (string-append "return \"" ffmpeg "/bin/ffprobe\""))
                 (("warn\\(\"Couldn't find ff") "# warn\\(\"Couldn't find ff"))
               #t))))))
    (home-page "https://pydub.com")
    (inputs
     (list ffmpeg))
    (propagated-inputs
     (list python-scipy))
    (synopsis "Manipulate audio with a high level interface in Python")
    (description
     "@code{pydub} makes it easy to manipulate audio in Python.  It relies on
@code{ffmpeg} to open various audio formats.")
    (license license:expat))) ; MIT license

(define-public python-tqdm
  (package
    (name "python-tqdm")
    (version "4.64.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "tqdm" version))
         (sha256
           (base32
             "1r7i9kswpnrx4ppfvzz6discb04j1rqkqxdwa2sc2la900m6hksz"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest" "-vv"
                              "-o" "asyncio_mode=auto"
                              "-k" "not perf"))))))
    (native-inputs
     (list python-pytest python-pytest-asyncio python-pytest-timeout
           python-setuptools-scm python-toml))
    (home-page "https://github.com/tqdm/tqdm")
    (synopsis "Fast, extensible progress meter")
    (description
      "Make loops show a progress bar on the console by just wrapping any
iterable with @code{|tqdm(iterable)|}.  Offers many options to define
design and layout.")
    (license (list license:mpl2.0 license:expat))))

(define-public python-pkginfo
  (package
    (name "python-pkginfo")
    (version "1.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pkginfo" version))
       (sha256
        (base32 "0z46w559hrl79gf7navgzimj21ma821wka27jh58fvyqilqs8kd8"))))
    (build-system python-build-system)
    (native-inputs
     (list python-wheel))
    (home-page "https://code.launchpad.net/~tseaver/pkginfo/trunk")
    (synopsis "Query metadatdata from sdists, bdists, and installed packages")
    (description
     "API to query the distutils metadata written in @file{PKG-INFO} inside a
source distriubtion (an sdist) or a binary distribution (e.g., created by
running bdist_egg).  It can also query the EGG-INFO directory of an installed
distribution, and the *.egg-info stored in a \"development checkout\" (e.g,
created by running @code{python setup.py develop}).")
    (license license:expat)))

(define-public python-twine
  (package
    (name "python-twine")
    (version "1.15.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "twine" version))
        (sha256
         (base32 "11rpd653zcgzkq3sgwkzs3mpxl3r5rij59745ni84ikv8smjmlm3"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-tqdm
           python-packaging
           python-pkginfo
           python-readme-renderer
           python-requests
           python-requests-toolbelt))
    (home-page "https://github.com/pypa/twine")
    (synopsis "Collection of utilities for interacting with PyPI")
    (description
      "@code{twine} currently supports registering projects and uploading
distributions.  It authenticates the user over HTTPS, allows them to pre-sign
their files and supports any packaging format (including wheels).")
    (license license:asl2.0)))

(define-public python-linecache2
  (package
    (name "python-linecache2")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "linecache2" version))
        (sha256
          (base32
            "0z79g3ds5wk2lvnqw0y2jpakjf32h95bd9zmnvp7dnqhf57gy9jb"))))
    (build-system python-build-system)
    (arguments
     `(;; The tests depend on unittest2, and our version is a bit too old.
       #:tests? #f))
    (native-inputs
     `(("python-pbr" ,python-pbr-minimal)))
    (home-page
      "https://github.com/testing-cabal/linecache2")
    (synopsis "Backports of the linecache module")
    (description
      "The linecache module allows one to get any line from any file, while
attempting to optimize internally, using a cache, the common case where many
lines are read from a single file.")
    (license license:psfl)))

(define-public python-traceback2
  (package
    (name "python-traceback2")
    (version "1.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "traceback2" version))
        (sha256
          (base32
            "0c1h3jas1jp1fdbn9z2mrgn3jj0hw1x3yhnkxp7jw34q15xcdb05"))))
    (build-system python-build-system)
    (arguments
     `(;; python-traceback2 and python-unittest2 depend on one another.
       #:tests? #f))
    (native-inputs
     `(("python-pbr" ,python-pbr-minimal)))
    (propagated-inputs
      (list python-linecache2 python-six))
    (home-page
      "https://github.com/testing-cabal/traceback2")
    (synopsis "Backports of the traceback module")
    (description
      "This module provides a standard interface to extract, format and print
stack traces of Python programs.  It exactly mimics the behavior of the Python
interpreter when it prints a stack trace.")
    (license license:psfl)))

(define-public python-ratelimiter
  (package
    (name "python-ratelimiter")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ratelimiter" version))
       (sha256
        (base32
         "1dhz85mj5bqd2mij84ncs6pz32hgidr79hay4aqfmzaa4rbb497p"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f))          ; There are no tests in the pypi archive.
    (home-page "https://github.com/RazerM/ratelimiter")
    (synopsis "Simple rate limiting object")
    (description
     "The @code{ratelimiter} module ensures that an operation will not be
executed more than a given number of times during a given period.")
    (license license:asl2.0)))

(define-public python-jsonrpclib-pelix
  (package
    (name "python-jsonrpclib-pelix")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonrpclib-pelix" version))
       (sha256
        (base32
         "0f83z5zi7w32vprhk1dyc94ir1bh4hdd57bjdbwkq9ykng8qilhl"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; no tests in PyPI tarball
    (home-page "https://github.com/tcalmant/jsonrpclib/")
    (synopsis "JSON-RPC 2.0 client library for Python")
    (description
     "This library implements the JSON-RPC v2.0
specification (backwards-compatible) as a client library for Python.  This
version is a fork of jsonrpclib by Josh Marshall, usable with Pelix remote
services.")
    (license license:asl2.0)))

(define-public python-setuptools-scm-git-archive
  (package
    (name "python-setuptools-scm-git-archive")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setuptools_scm_git_archive" version))
       (sha256
        (base32
         "1nii1sz5jq75ilf18bjnr11l9rz1lvdmyk66bxl7q90qan85yhjj"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'dont-install-defunct-egginfo
                    (lambda _
                      ;; When a ".git" directory is missing, the setup.py
                      ;; script invokes setuptools.setup twice, once with
                      ;; "0" as the version.  Prevent that.
                      (substitute* "setup.py"
                        (("if not isdir\\('\\.git'\\):")
                         "if False:")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/Changaco/setuptools_scm_git_archive/")
    (synopsis "Setuptools_scm plugin for git archives")
    (description
     "The setuptools_scm_git_archive package is a plugin to
setuptools_scm, which supports obtaining versions from git archives that
belong to tagged versions.")
    (license license:expat)))

(define-public python-setuptools-git
  (package
    (name "python-setuptools-git")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setuptools-git" version))
       (sha256
        (base32
         "0i84qjwp5m0l9qagdjww2frdh63r37km1c48mrvbmaqsl1ni6r7z"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; This is needed for tests.
         (add-after 'unpack 'configure-git
           (lambda _
             (setenv "HOME" "/tmp")
             (invoke "git" "config" "--global" "user.email" "guix")
             (invoke "git" "config" "--global" "user.name" "guix")
             #t)))))
    (native-inputs
     `(("git" ,git-minimal)))
    (home-page "https://github.com/msabramo/setuptools-git")
    (synopsis "Setuptools revision control system plugin for Git")
    (description
     "This package provides a plugin for Setuptools for revision control with
Git.")
    (license license:bsd-3)))

(define-public python-setuptools-rust
  (package
    (name "python-setuptools-rust")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setuptools-rust" version))
       (sha256
        (base32 "1lb57qx1azklgzmalflq960agvwci4bwddw0zvlc9zy00fsvkbd0"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ;no tests
    (native-inputs
     (list python-setuptools-scm))
    (propagated-inputs
     (list python-semantic-version python-typing-extensions))
    (home-page "https://github.com/PyO3/setuptools-rust")
    (synopsis "Setuptools plugin for Rust extensions")
    (description
     "@code{setuptools-rust} is a plugin for @code{setuptools} to build
Rust Python extensions implemented with @code{PyO3} or @code{rust-cpython}.")
    (license license:expat)))

(define-public python-pyclipper
  (package
    (name "python-pyclipper")
    (version "1.3.0.post3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyclipper" version))
       (sha256
        (base32 "0vqzbmq2di1jaj6230m5i1ld0mg6wdb1c6r6i5zli54varavr7v3"))
      (modules '((guix build utils)))
      (snippet
       '(begin
          ;; This file is generated by Cython.
          (delete-file "src/pyclipper/_pyclipper.cpp") #t))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'cythonize-sources
           (lambda _
             (with-directory-excursion "src/pyclipper"
               (invoke "cython" "--cplus" "_pyclipper.pyx")))))))
    (native-inputs
     (list python-cython python-setuptools-scm
           python-pytest python-pytest-runner))
    (home-page "https://github.com/greginvm/pyclipper")
    (synopsis "Wrapper for Angus Johnson's Clipper library")
    (description
     "Pyclipper is a Cython wrapper for the C++ translation of the
Angus Johnson's polygon clipping Clipper library (ver. 6.4.2).")
    (license license:expat)))

(define-public python-tempdir
  (package
    (name "python-tempdir")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tempdir" version))
       (sha256
        (base32
         "13msyyxqbicr111a294x7fsqbkl6a31fyrqflx3q7k547gnq15k8"))))
    (build-system python-build-system)
    (home-page "https://pypi.org/project/tempdir/")
    (arguments
     ;; the package has no tests
     '(#:tests? #f))
    (synopsis "Python library for managing temporary directories")
    (description
     "This library manages temporary directories that are automatically
deleted with all their contents when they are no longer needed.  It is
particularly convenient for use in tests.")
    (license license:expat)))

(define-public python-tempora
  (package
    (name "python-tempora")
    (version "5.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tempora" version))
       (sha256
        (base32 "09wirlk5vmxlhl9rnxp7g5qz2nsd6b0gnzk5fczbz0s8lsbz386b"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Do not test the myproject.toml build as it tries to pull
     ;; dependencies from the Internet.
     (list #:test-flags #~'("-k" "not project")))
    (native-inputs
     (list python-freezegun
           python-pytest
           python-pytest-black
           python-pytest-checkdocs
           python-pytest-cov
           python-pytest-enabler
           python-pytest-flake8
           python-pytest-freezegun
           python-pytest-mypy
           python-setuptools-scm
           python-types-freezegun
           python-types-pytz))
    (propagated-inputs (list python-jaraco-functools python-pytz))
    (home-page "https://github.com/jaraco/tempora")
    (synopsis "Python date and time objects and routines")
    (description "The @code{tempora} Python library contains miscellaneous
date and time related utilities and constants, routines for measuring,
profiling, and getting datetime-aware @acronym{UTC, Coordinated Universal
Time} values as well as an event scheduler.")
    (license license:expat)))

(define-public python-activepapers
  (package
    (name "python-activepapers")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ActivePapers.Py" version))
       (sha256
        (base32
         "12wkhjh90ffipjzv10swndp2xv9hd7xrxvg6v0n4n3i411pj4xb8"))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((ice-9 ftw)
                  (srfi srfi-1)
                  (guix build utils)
                  (guix build python-build-system))

       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-python2-code
           (lambda _
             (for-each delete-file
                       '("lib/activepapers/builtins2.py"
                         "lib/activepapers/standardlib2.py"
                         "lib/activepapers/utility2.py"))))
         (replace 'check
           (lambda _
             ;; Deactivate the test cases that download files
             (setenv "NO_NETWORK_ACCESS" "1")
             ;; For some strange reason, some tests fail if nosetests runs all
             ;; test modules in a single execution. They pass if each test
             ;; module is run individually.
             (for-each (lambda (filename)
                         (invoke "nosetests"
                                 (string-append "tests/" filename)))
                       (scandir "tests"
                                (lambda (filename)
                                  (string-suffix? ".py" filename)))))))))
    (native-inputs
     (list python-tempdir python-nose))
    (propagated-inputs
     (list python-h5py))
    (home-page "https://www.activepapers.org/")
    (synopsis "Executable papers for scientific computing")
    (description
     "ActivePapers is a tool for working with executable papers, which
combine data, code, and documentation in single-file packages,
suitable for publication as supplementary material or on repositories
such as figshare or Zenodo.")
    (license license:bsd-3)))

(define-public python-semver
  (package
    (name "python-semver")
    (version "2.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "semver" version))
       (sha256
        (base32
         "183kg1rhzz3hqizvphkd8hlbf1zxfx8737zhfkmqzxi71jmdw7pd"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (delete-file "setup.cfg")
                      (invoke "py.test"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/k-bx/python-semver")
    (synopsis "Python helper for Semantic Versioning")
    (description "This package provides a Python library for
@url{Semantic Versioning, http://semver.org/}.")
    (license license:bsd-3)))

(define-public python-pyro4
  (package
    (name "python-pyro4")
    (version "4.77")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pyro4" version))
       (sha256
        (base32 "0gsjg869y4gpy265s1gj1f2qy6jn5iz8r2bwwnq78r1r5yi15zib"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ;FIXME: Some tests require network access.
    (native-inputs
     (list python-cloudpickle python-dill python-msgpack))
    (propagated-inputs
     (list python-serpent))
    (home-page "https://pyro4.readthedocs.io")
    (synopsis "Distributed object middleware for Python")
    (description
     "Pyro enables you to build applications in which objects can talk to each
other over the network.  You can just use normal Python method calls to call
objects on other machines, also known as remote procedure calls (RPC).")
    (license license:expat)))

(define-public python-phonenumbers
  (package
    (name "python-phonenumbers")
    (version "8.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "phonenumbers" version))
       (sha256
        (base32
         "03fmrgb4r8x3ykmddjs9i3zhs703in8smikj3a6447blqpimwyh1"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/daviddrysdale/python-phonenumbers")
    (synopsis
     "Python library for dealing with international phone numbers")
    (description
     "This package provides a Python port of Google's libphonenumber library.")
    (license license:asl2.0)))

(define-public python-heapdict
  (package
    (name "python-heapdict")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "HeapDict" version))
       (sha256
        (base32
         "1dnd7v9adqd21bf4ih2wzn9a7b41m0nccb0vbxny9n037rxzb5c4"))))
    (build-system python-build-system)
    (home-page "http://stutzbachenterprises.com/")
    (synopsis "Heap with decrease-key and increase-key operations")
    (description
     "heapdict implements the MutableMapping ABC, meaning it works pretty much
like a regular Python @code{dict}.  It’s designed to be used as a priority
queue.")
    (license license:bsd-3)))

(define-public python-zict
  (package
    (name "python-zict")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "zict" version))
       (sha256
        (base32
         "05pd1hyhqvpw87rnbvl3vdyf619snpyccbswaxisdj17frwnjacf"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-heapdict))
    (native-inputs
     (list python-pytest))
    (home-page "https://zict.readthedocs.io/en/latest/")
    (synopsis "Composable mutable mapping tools")
    (description "This package provides abstract @code{MutableMapping} classes
that consume and build on other @code{MutableMappings}.  Several of these can
be composed with one another to form intuitive interfaces over complex storage
systems policies.")
    (license license:bsd-3)))

(define-public python-send2trash
  (package
    (name "python-send2trash")
    (version "1.8.0")
    (source
     (origin (method git-fetch)
             ;; Source tarball on PyPI doesn't include tests.
             (uri (git-reference
                   (url "https://github.com/arsenetar/send2trash")
                   (commit version)))
             (file-name (git-file-name name version))
             (sha256
              (base32
               "1k7dfypaaq4f36fbciaasv72j6wgjihw8d88axmz9c329bz8v5qx"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'pre-check
           (lambda _
             (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/arsenetar/send2trash")
    (synopsis "Send files to the user's @file{~/Trash} directory")
    (description "This package provides a Python library to send files to the
user's @file{~/Trash} directory.")
    (license license:bsd-3)))

(define-public python-pyfavicon
  (package
    (name "python-pyfavicon")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyfavicon" version))
       (sha256
        (base32 "15wfpa99hvcfsv8j0m8iprmydi2p4qkhm86qfx485244y0ia5mgx"))))
    (build-system python-build-system)
    (arguments
     ;; There are no tests in the PyPI tarball and the tests from the
     ;; repository require online data.
     '(#:tests? #f))
    (propagated-inputs
     (list python-aiohttp python-beautifulsoup4 python-pillow))
    (home-page "https://github.com/bilelmoussaoui/pyfavicon")
    (synopsis "Async favicon fetcher")
    (description
     "@code{pyfavicon} is an async favicon fetcher.")
    (license license:expat)))

(define-public python-yamllint
  (package
    (name "python-yamllint")
    (version "1.26.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "yamllint" version))
       (sha256
        (base32 "090krlxj7az0d9yl8i20vjrqi66dfxx7y5xakjhxzsfp7qmldnc7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pathspec python-pyyaml python-setuptools))
    (home-page "https://github.com/adrienverge/yamllint")
    (synopsis "Linter for YAML files")
    (description
     "Yamllint is a linter for YAML files.  yamllint does not only check for
syntax validity, but for weirdnesses like key repetition and cosmetic problems
such as lines length, trailing spaces, indentation, etc.")
    (license license:gpl3+)))

(define-public python-yapf
  (package
    (name "python-yapf")
    (version "0.29.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "yapf" version))
       (sha256
        (base32
         "1pj3xzblmbssshi889b6n9hwqbjpabw6j0fimlng2sshd3226bki"))))
    (build-system python-build-system)
    (home-page "https://github.com/google/yapf")
    (synopsis "Formatter for Python code")
    (description "YAPF is a formatter for Python code.  It's based off of
@dfn{clang-format}, developed by Daniel Jasper.  In essence, the algorithm
takes the code and reformats it to the best formatting that conforms to the
style guide, even if the original code didn't violate the style guide.")
    (license license:asl2.0)))

(define-public python-yq
  (package
    (name "python-yq")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "yq" version))
       (sha256
        (base32
         "1wklgs3d9si475nffw9agq5kgk8bdicbsmlj4sx4kiw64ji4ma1h"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "yq/__init__.py"
               (("Popen\\(\\[\"jq")
                (string-append
                 "Popen([\""
                 (assoc-ref inputs "jq")
                 "/bin/jq")))
             #t)))))
    (inputs
     (list python-argcomplete python-pyyaml python-xmltodict python-toml jq))
    (native-inputs
     (list python-coverage python-flake8 python-setuptools-scm python-wheel))
    (home-page "https://github.com/kislyuk/yq")
    (synopsis "Command-line YAML/XML processor")
    (description
     "This package provides @command{yq} and @command{xq} for processing YAML
and XML respectively.  The processing is done through @command{jq}, @command{jq}
filters can be used to process the data as it passes through.")
    (license license:asl2.0)))

(define-public python-gyp
  (let ((commit "5e2b3ddde7cda5eb6bc09a5546a76b00e49d888f")
        (revision "0"))
    (package
      (name "python-gyp")
      ;; Google does not release versions,
      ;; based on second most recent commit date.
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         ;; Google does not release tarballs,
         ;; git checkout is needed.
         (method git-fetch)
         (uri (git-reference
               (url "https://chromium.googlesource.com/external/gyp")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0fr7nxcrk292djmxzpcjaphnsd123k31gp8jnd91vwknhq6snmv9"))))
      (build-system python-build-system)
      (home-page "https://gyp.gsrc.io/")
      (synopsis "GYP is a Meta-Build system")
      (description
       "GYP builds build systems for large, cross platform applications.
It can be used to generate XCode projects, Visual Studio projects, Ninja build
files, and Makefiles.")
      (license license:bsd-3))))

(define-public python-whatever
  (package
    (name "python-whatever")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/Suor/whatever")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q7ajgqjfivxqsqgnhp4lc4p6jxyh4zprcsdbpd6dw54inaf0av5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
        (replace 'check
          (lambda _
            (invoke "py.test"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/Suor/whatever")
    (synopsis "Make anonymous functions by partial application of operators")
    (description "@code{whatever} provides an easy way to make anonymous
functions by partial application of operators.")
    (license license:bsd-3)))

(define-public python-funcy
  (package
    (name "python-funcy")
    (version "1.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Suor/funcy")
             (commit version)))
       (sha256
        (base32 "1s98vkjnq3zq71737hn8xa15kssvmy1sfzsll3vrlv53902418mw"))
       (file-name (git-file-name name version))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "py.test"))))))
    (native-inputs
     (list python-pytest python-whatever))
    (home-page "https://github.com/Suor/funcy")
    (synopsis "Functional tools")
    (description "@code{funcy} is a library that provides functional tools.
Examples are:
@enumerate
@item merge - Merges collections of the same type
@item walk - Type-preserving map
@item select - Selects a part of a collection
@item take - Takes the first n items of a collection
@item first - Takes the first item of a collection
@item remove - Predicated-removes items of a collection
@item concat - Concatenates two collections
@item flatten - Flattens a collection with subcollections
@item distinct - Returns only distinct items
@item split - Predicated-splits a collection
@item split_at - Splits a collection at a given item
@item group_by - Groups items by group
@item pairwise - Pairs off adjacent items
@item partial - Partially-applies a function
@item curry - Curries a function
@item compose - Composes functions
@item complement - Complements a predicate
@item all_fn - \"all\" with predicate
@end enumerate")
    (license license:bsd-3)))

(define-public python-isoweek
  (package
    (name "python-isoweek")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "isoweek" version))
       (sha256
        (base32
         "1s7zsf0pab0l9gn6456qadnz5i5h90hafcjwnhx5mq23qjxggwvk"))))
    (build-system python-build-system)
    (home-page "https://github.com/gisle/isoweek")
    (synopsis "Objects representing a week")
    (description "The @code{isoweek} module provide the class Week that
implements the week definition of ISO 8601.  This standard also defines
a notation for identifying weeks; yyyyWww (where the W is a literal).
Week instances stringify to this form.")
    (license license:bsd-3)))

(define-public python-pyzbar
  (package
    (name "python-pyzbar")
    (version "0.1.8")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/NaturalHistoryMuseum/pyzbar")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fqlfg5p2v9lzzzi0si2sz54lblprk6jjjhjw54b64lp58c1yhsl"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-failing-test
           (lambda _
             ;; This tests if find_library was called once, but we remove
             ;; the call in the stage below to make the library find libzbar.
             (delete-file "pyzbar/tests/test_zbar_library.py")
             #t))
         (add-before 'build 'set-library-file-name
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((libzbar (assoc-ref inputs "zbar")))
               (substitute* "pyzbar/zbar_library.py"
                 (("find_library\\('zbar'\\)")
                  (string-append "'" libzbar "/lib/libzbar.so.0'")))
               #t))))))
    (native-inputs
     (list pkg-config python-numpy python-pillow))
    (inputs
     (list zbar))
    (home-page "https://github.com/NaturalHistoryMuseum/pyzbar/")
    (synopsis "Read one-dimensional barcodes and QR codes")
    (description
     "Read one-dimensional barcodes and QR codes using the zbar library.

Features:

@itemize
@item Pure python
@item Works with PIL / Pillow images, OpenCV / numpy ndarrays, and raw bytes
@item Decodes locations of barcodes
@item No dependencies, other than the zbar library itself
@end itemize")
    (license license:expat)))

(define-public python-tokenize-rt
  (package
    (name "python-tokenize-rt")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tokenize-rt" version))
       (sha256
        (base32
         "1yjvbz7rvrz31zjyax1cgy3xhf4wb3j18jwnj4bnl77ca4gliyiw"))))
    (build-system python-build-system)
    (home-page "https://github.com/asottile/tokenize-rt")
    (synopsis "Wrapper around the stdlib tokenize which roundtrips")
    (description
     "This Python library is a wrapper around @code{tokenize} from the Python
standard library.  It provides two additional tokens @code{ESCAPED_NL} and
@code{UNIMPORTANT_WS}, and a @code{Token} data type.  Use @code{src_to_tokens}
and @code{tokens_to_src} to roundtrip.")
    (license license:expat)))

(define-public python-future-fstrings
  (package
    (name "python-future-fstrings")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "future_fstrings" version))
       (sha256
        (base32
         "0ydxqz2dvns44g55p8ix2x18qkfk3aaz0m0dc70f3g6n8js35h47"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-tokenize-rt))
    (home-page "https://github.com/asottile/future-fstrings")
    (synopsis "Backport of fstrings to Python < 3.6")
    (description
     "This package provides a UTF-8 compatible encoding
@code{future_fstrings}, which performs source manipulation.  It decodes the
source bytes using the UTF-8 encoding and then rewrites Python 3.6 style
@code{f} strings.")
    (license license:expat)))

(define-public python-typed-ast
  (package
    (name "python-typed-ast")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python/typed_ast")
             (commit version)))
       (sha256
        (base32 "1xfcs5246c8v5600aaa8zs7ii4sxb62q6r3sb2fgazyjx97wrxd9"))
       (file-name (git-file-name name version))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest"))))))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/python/typed_ast")
    (synopsis "Fork of Python @code{ast} modules with type comment support")
    (description "This package provides a parser similar to the standard
@code{ast} library.  Unlike @code{ast}, the parsers in @code{typed_ast}
include PEP 484 type comments and are independent of the version of Python
under which they are run.  The @code{typed_ast} parsers produce the standard
Python AST (plus type comments), and are both fast and correct, as they are
based on the CPython 2.7 and 3.7 parsers.")
    ;; See the file "LICENSE" for the details.
    (license (list license:psfl
                   license:asl2.0
                   license:expat))))    ;ast27/Parser/spark.py

(define-public python-typer
  (package
    (name "python-typer")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tiangolo/typer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1knv353qhkl2imav3jfp6bgq47m8wkkqhq1dzmqg2sv8rsy7zgl7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       ,#~(modify-phases %standard-phases
            ;; Unfortunately, this doesn't seem to be enough to fix these two
            ;; tests, but we'll patch this anyway.
            (add-after 'unpack 'patch-shell-reference
              (lambda _
                (substitute* "tests/test_completion/test_completion.py"
                  (("\"bash\"") (string-append "\"" (which "bash") "\""))
                  (("\"/bin/bash\"")
                   (string-append "\"" (which "bash") "\"")))))
            (replace 'build
              (lambda _
                (invoke "flit" "build")))
            (replace 'install
              (lambda* (#:key inputs outputs #:allow-other-keys)
                (add-installed-pythonpath inputs outputs)
                (for-each
                 (lambda (wheel)
                   (format #true wheel)
                   (invoke "python" "-m" "pip" "install"
                           wheel (string-append "--prefix=" #$output)))
                 (find-files "dist" "\\.whl$"))))
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (setenv "HOME" "/tmp") ; some tests need it

                  ;; This is for completion tests
                  (with-output-to-file "/tmp/.bashrc"
                    (lambda _ (display "# dummy")))

                  (setenv "GUIX_PYTHONPATH"
                          (string-append (getcwd) ":"
                                         (getenv "GUIX_PYTHONPATH")))
                  (let ((disabled-tests (list "test_show_completion"
                                              "test_install_completion")))
                    (invoke "python" "-m" "pytest" "tests/"
                            "-k"
                            (string-append "not "
                                           (string-join disabled-tests
                                                        " and not "))))))))))
    (propagated-inputs
     (list python-click))
    (native-inputs
     (list python-coverage python-flit python-pytest python-rich
           python-shellingham))
    (home-page "https://github.com/tiangolo/typer")
    (synopsis
     "Typer builds CLI based on Python type hints")
    (description
     "Typer is a library for building CLI applications.  It's based on
Python 3.6+ type hints.")
    ;; MIT license
    (license license:expat)))

(define-public python-typeguard
  (package
    (name "python-typeguard")
    (version "2.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "typeguard" version))
       (sha256
        (base32 "1i5qzcyw2715h1g1hvj7fxykck2bkxyshpngjr3nfcx1lf6smv80"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "-k"
                        ;; XXX: These fail when installed as a library:
                        ;; https://github.com/agronholm/typeguard/issues/176
                        "not usefixtures and not test_cached_module")))))))
    (native-inputs
     (list python-mypy python-pytest python-typing-extensions))
    (home-page "https://github.com/agronholm/typeguard")
    (synopsis "Run-time type checker for Python")
    (description
     "@code{typeguard} provides run-time type checking for functions defined
with PEP 484 argument (and return) type annotations.")
    (license license:expat)))

(define-public python-typing-extensions
  (package
    (name "python-typing-extensions")
    (version "4.0.1")
    (source (origin
              ;; The test script is missing from the PyPI archive.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/python/typing")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0a35fh5wk9s538x0w3dz95y0avnhd2srzyv9s1a372711n8hdl4p"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f       ;requires Python's test module, not available in Guix
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'enter-source-directory
            (lambda _
              (chdir "typing_extensions")))
          ;; XXX: PEP 517 manual build copied from python-isort.
          (replace 'build
            (lambda _
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "python" "src/test_typing_extensions.py"))))
          (replace 'install
            (lambda _
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl)))))))
    (native-inputs (list python-pypa-build python-flit-core))
    (home-page "https://github.com/python/typing/typing_extensions")
    (synopsis "Experimental type hints for Python")
    (description
     "The typing_extensions module contains additional @code{typing} hints not
yet present in the of the @code{typing} standard library.
Included are implementations of:
@enumerate
@item ClassVar
@item ContextManager
@item Counter
@item DefaultDict
@item Deque
@item NewType
@item NoReturn
@item overload
@item Protocol
@item runtime
@item Text
@item Type
@item TYPE_CHECKING
@item AsyncGenerator
@end enumerate\n")
    (license license:psfl)))

(define-public python-typing-extensions-next
  (package
    (inherit python-typing-extensions)
    (name "python-typing-extensions")
    (version "4.2.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/python/typing")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1bbry1rg7q5ppkgzdk4nwl7q1w8bbhajm4q68wb9dm6rf7hg1023"))))))

(define-public bpython
  (package
    (name "bpython")
    (version "0.23")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bpython" version))
       (sha256
        (base32 "0ah5giynavyh70yc0jqgmjaajv3xg5j2y7k9i3q8mi47r2mph04z"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-failing-test
           (lambda _
             ;; Remove failing test. FIXME: make it pass
             (delete-file "bpython/test/test_args.py")
             #t))
         (add-after 'wrap 'add-aliases
           ;; for symmetry to bpython2, add symlinks bypthon3, bpdb3, etc.
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               (for-each
                (lambda (old new)
                  (symlink old (string-append out "/bin/" new)))
                '("bpython" "bpython-curses" "bpython-urwid" "bpdb")
                '("bpython3" "bpython3-curses" "bpython3-urwid" "bpdb3")))
             #t)))))
    (propagated-inputs
     (list python-pygments
           python-requests
           python-curtsies
           python-greenlet
           python-six
           python-cwcwidth
           python-pyxdg
           ;; optional dependencies
           python-urwid ; for bpython-urwid only
           python-watchdog
           python-jedi))
    (native-inputs
     (list python-sphinx python-mock python-tox python-wheel))
    (home-page "https://bpython-interpreter.org/")
    (synopsis "Fancy interface to the Python interpreter")
    (description "Bpython is a fancy interface to the Python
interpreter. bpython's main features are

@enumerate
@item in-line syntax highlighting,
@item readline-like autocomplete with suggestions displayed as you type,
@item expected parameter list for any Python function,
@item \"rewind\" function to pop the last line of code from memory and
      re-evaluate,
@item send the code you've entered off to a pastebin,
@item save the code you've entered to a file, and
@item auto-indentation.
@end enumerate")
    (license license:expat)))

(define-public python-pyinotify
  (package
    (name "python-pyinotify")
    (version "0.9.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyinotify" version))
              (sha256
               (base32
                "1x3i9wmzw33fpkis203alygfnrkcmq9w1aydcm887jh6frfqm6cw"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))          ;no tests
    (home-page "https://github.com/seb-m/pyinotify")
    (synopsis "Python library for monitoring inotify events")
    (description
     "@code{pyinotify} provides a Python interface for monitoring
file system events on Linux.")
    (license license:expat)))


(define-public python-more-itertools
  (package
    (name "python-more-itertools")
    (version "8.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "more-itertools" version))
       (sha256
        (base32
         "01x5nwm1zxmnd06cllbdd095xxc2nd25ing1a726m2kd30rbkpdi"))))
    (build-system python-build-system)
    (home-page "https://github.com/erikrose/more-itertools")
    (synopsis "More routines for operating on iterables, beyond itertools")
    (description "Python's built-in @code{itertools} module implements a
number of iterator building blocks inspired by constructs from APL, Haskell,
and SML.  @code{more-itertools} includes additional building blocks for
working with iterables.")
    (license license:expat)))

(define-public python-latexcodec
  (package
    (name "python-latexcodec")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "latexcodec" version))
       (sha256
        (base32 "16pynfnn8y8xp55yp06i721fccv5dlx9ba6k5bzcwq9j6wf5b8ia"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://readthedocs.org/projects/latexcodec/")
    (synopsis "Work with LaTeX code in Python")
    (description "Lexer and codec to work with LaTeX code in Python.")
    (license license:expat)))

(define-public python-pybtex
  (package
    (name "python-pybtex")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pybtex" version))
       (sha256
        (base32 "0ma7sc10hk6caq5zghbk865vrlaynz7x5z630z0facqpnqssx3l1"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-latexcodec python-pyyaml python-six))
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (invoke "pytest")))))))
    (home-page "https://pybtex.org/")
    (synopsis "BibTeX-compatible bibliography processor")
    (description "Pybtex is a BibTeX-compatible bibliography processor written
in Python.  You can simply type pybtex instead of bibtex.")
    (license license:expat)))

(define-public python-onetimepass
  (package
    (name "python-onetimepass")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "onetimepass" version))
       (sha256
        (base32 "09vagxgbq78wvq4xbikmn2hpqqsa2i96kqsmphf7dqynfv0dlsd5"))))
    (build-system python-build-system)
    (propagated-inputs (list python-six))
    (home-page "https://github.com/tadeck/onetimepass/")
    (synopsis "One-time password library")
    (description "Python one-time password library for HMAC-based (HOTP) and
time-based (TOTP) passwords.")
    (license license:expat)))

(define-public python-parso
  (package
    (name "python-parso")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "parso" version))
       (sha256
        (base32 "185gkxq92kqiw2h5zp1cmyn04055x0lix4hmi5c077xm1clvw1wc"))))
    (native-inputs
     (list python-pytest))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (home-page "https://github.com/davidhalter/parso")
    (synopsis "Python Parser")
    (description "Parso is a Python parser that supports error recovery and
round-trip parsing for different Python versions (in multiple Python versions).
Parso is also able to list multiple syntax errors in your Python file.")
    (license license:expat)))

(define-public python-async-generator
  (package
    (name "python-async-generator")
    (version "1.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "async_generator" version))
       (sha256
        (base32
         "0i11f6z6lix8ixi3vsk6s76zvvpmgrw6zjrcwjm0m4hjdh83vfvf"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/python-trio/async_generator")
    (synopsis "Async generators and context managers for Python 3.5+")
    (description "@code{async_generator} back-ports Python 3.6's native async
generators and Python 3.7's context managers into Python 3.5.")
    ;; Dual licensed.
    (license (list license:expat license:asl2.0))))

(define-public python-async-timeout
  (package
    (name "python-async-timeout")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "async-timeout" version))
       (sha256
        (base32
         "05bbjz16n1a7m1s3lmcwri2x5rc7hnh6f2hdr2lbflnv1mjf2qr1"))))
    (build-system python-build-system)
    (home-page "https://github.com/aio-libs/async-timeout")
    (synopsis "Timeout context manager for asyncio programs")
    (description "@code{async-timeout} provides a timeout timeout context
manager compatible with @code{asyncio}.")
    (license license:asl2.0)))

(define-public python-glob2
  (package
    (name "python-glob2")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/miracle2k/python-glob2")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "160nh2ay9lw2hi0rixpzb2k87r6ql56k0j2cm87lqz8xc8zbw919"))))
    (build-system python-build-system)
    (home-page "https://github.com/miracle2k/python-glob2/")
    (synopsis "Extended Version of the python buildin glob module")
    (description "This is an extended version of the Python
@url{http://docs.python.org/library/glob.html, built-in glob module} which
adds:

@itemize
@item The ability to capture the text matched by glob patterns, and return
those matches alongside the file names.
@item A recursive @code{**} globbing syntax, akin for example to the
@code{globstar} option of Bash.
@item The ability to replace the file system functions used, in order to glob
on virtual file systems.
@item Compatible with Python 2 and Python 3 (tested with 3.3).
@end itemize

Glob2 currently based on the glob code from Python 3.3.1.")
    (license license:bsd-2)))

(define-public python-gipc
  (package
    (name "python-gipc")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gipc" version ".zip"))
       (sha256
        (base32
         "0pd9by719qh882hqs6xpby61sn1x5h98hms5p2p8yqnycrf1s0h2"))))
    (build-system python-build-system)
    (native-inputs
     (list unzip))
    (propagated-inputs
     (list python-gevent))
    (home-page "https://gehrcke.de/gipc/")
    (synopsis "Child process management in the context of gevent")
    (description "Usage of Python's multiprocessing package in a
gevent-powered application may raise problems.  With @code{gipc},
process-based child processes can safely be created anywhere within a
gevent-powered application.")
    (license license:expat)))

(define-public python-beautifultable
  (package
    (name "python-beautifultable")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beautifultable" version))
       (sha256
        (base32
         "0wwlbifcbpzy3wfv6yzsxncarsngzizmmxbn6cy5gazlcq7h4k5x"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-wcwidth))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-setup.py
           (lambda _
             (substitute* "setup.py"
               (("setup\\(")
                "setup(\n    test_suite=\"test\",")))))))
    (home-page "https://github.com/pri22296/beautifultable")
    (synopsis "Print ASCII tables for terminals")
    (description "@code{python-beautifultable} provides a class for easily
printing tabular data in a visually appealing ASCII format to a terminal.

Features include, but are not limited to:
@itemize
@item Full customization of the look and feel of the table
@item Row and column accessors.
@item Full support for colors using ANSI sequences or any library.
@item Plenty of predefined styles and option to create custom ones.
@item Support for Unicode characters.
@item Supports streaming table when data is slow to retrieve.
@end itemize")
    (license license:expat)))

(define-public python-globber
  (package
    (name "python-globber")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/asharov/globber")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "055xf7ja7zjhxis0ab5fnfsx16fsvr5fvc6mixqybanwxh8sgfjk"))))
    (build-system python-build-system)
    (home-page "https://github.com/asharov/globber")
    (synopsis "Library for string matching with glob patterns")
    (description
     "Globber is a Python library for matching file names against glob patterns.
In contrast to other glob-matching libraries, it matches arbitrary strings and
doesn't require the matched names to be existing files.  In addition, it
supports the globstar @code{**} operator to match an arbitrary number of
path components.")
    (license license:asl2.0)))

(define-public python-git-hammer
  (package
    (name "python-git-hammer")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/asharov/git-hammer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0f9xlk86ijzpdj25hr1q4wcy8k72v3w470ngwm9mpdkfj8ng84wr"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-setup.py
           (lambda _
             (substitute* "setup.py"
               (("setup\\(")
                "setup(\n    test_suite=\"test\",")))))))
    (propagated-inputs
     (list python-beautifultable
           python-dateutil
           python-gitpython
           python-globber
           python-matplotlib
           python-sqlalchemy
           python-sqlalchemy-utils))
    (home-page "https://github.com/asharov/git-hammer")
    (synopsis "Provide statistics for git repositories")
    (description
     "Git Hammer is a statistics tool for projects in git repositories.
Its major feature is tracking the number of lines authored by each person for every
commit, but it also includes some other useful statistics.")
    (license license:asl2.0)))

(define-public python-fusepy
  (package
    (name "python-fusepy")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fusepy" version))
       (sha256
        (base32
         "0v5grm4zyf58hsplwsxfbihddw95lz9w8cy3rpzbyha287swgx8h"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-library-file-name
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((fuse (assoc-ref inputs "fuse")))
               (substitute* "fuse.py"
                 (("find_library\\('fuse'\\)")
                  (string-append "'" fuse "/lib/libfuse.so'")))
               #t))))))
    (propagated-inputs
     (list fuse))
    (home-page "https://github.com/fusepy/fusepy")
    (synopsis "Simple ctypes bindings for FUSE")
    (description "Python module that provides a simple interface to FUSE and
MacFUSE.  The binding is created using the standard @code{ctypes} library.")
    (license license:isc)))

(define-public python-fusepyng
  (package
    (name "python-fusepyng")
    (version "1.0.7")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "fusepyng" version))
        (sha256
         (base32
          "17w9iw6m6zjbmnhs4ikd27pq4mb1nan6k4ahlwyz40463vw6wkwb"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-libfuse-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((fuse (assoc-ref inputs "fuse")))
               (substitute* "fusepyng.py"
                 (("os.environ.get\\('FUSE_LIBRARY_PATH'\\)")
                  (string-append "\"" fuse "/lib/libfuse.so\""))))
             #t)))))
    (inputs
     (list fuse))
    (propagated-inputs
     (list python-paramiko))
    (home-page "https://github.com/rianhunter/fusepyng")
    (synopsis "Simple ctypes bindings for FUSE")
    (description "@code{fusepyng} is a Python module that provides a simple
interface to FUSE on various operating systems.  It's just one file and is
implemented using @code{ctypes}.")
    (license license:isc)))

(define-public python-update-checker
  (package
    (name "python-update-checker")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "update-checker" version))
       (sha256
        (base32 "04yb5a9mi45ax50m2m0ih6gdvkk1j7gfmy83dd58i1f59axlabba"))))
    (build-system python-build-system)
    (propagated-inputs (list python-requests))
    (native-inputs (list python-black python-flake8 python-pytest))
    (home-page "https://github.com/bboe/update_checker")
    (synopsis "Python module that will check for package updates")
    (description "This package provides a Python module that will check for
package updates.")
    (license license:bsd-2)))

(define-public python-userspacefs
  (package
    (name "python-userspacefs")
    (version "2.0.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "userspacefs" version))
        (sha256
         (base32
          "0v0qkdwfc61s2yiq7d7amin93x5biypfmi9pfhf8yj1rdpx5yvsx"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-fusepyng))
    (home-page "https://github.com/rianhunter/userspacefs")
    (synopsis "User-space file systems for Python")
    (description
     "@code{userspacefs} is a library that allows you to easily write
user-space file systems in Python.")
    (license license:gpl3+)))

(define-public python-stone
  (package
    (name "python-stone")
    (version "3.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "stone" version))
        (sha256
         (base32
          "0xby5mpsms7b2rv8j6mvxzmzz5i9ii01brb9ylxz6kiv2i08piwv"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'change-version-requirements
           (lambda _
             ;; Match the requirement in test/requirements.txt
             (substitute* "setup.py"
               (("pytest < 5") "pytest < 7"))
             ;; We don't care about a coverage report.
             (substitute* "test/requirements.txt"
               (("coverage.*") "coverage\n"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; These tests don't import currectly.
               (delete-file "test/test_js_client.py")
               (delete-file "test/test_tsd_types.py")
               (delete-file "test/test_python_gen.py")
               (invoke "pytest")))))))
    (propagated-inputs
     (list python-ply python-six))
    (native-inputs
     (list python-coverage python-mock python-pytest python-pytest-runner))
    (home-page "https://github.com/dropbox/stone")
    (synopsis "Official Api Spec Language for Dropbox")
    (description
     "Stone is an interface description language (IDL) for APIs.")
    (license license:expat)))

(define-public pybind11
  (package
    (name "pybind11")
    (version "2.8.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/pybind/pybind11")
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "10hrkrh78sk7k0ydw1ghmp7gvpwmkby0l2s0kf2iaj9sz0vijkhs"))
              (file-name (git-file-name name version))))
    (build-system cmake-build-system)
    (native-inputs
     `(("python" ,python-wrapper)

       ;; The following dependencies are used for tests.
       ("python-pytest" ,python-pytest)
       ("catch" ,catch2-1)
       ("eigen" ,eigen)))
    (arguments
     `(#:configure-flags
       (list (string-append "-DCATCH_INCLUDE_DIR="
                            (assoc-ref %build-inputs "catch")
                            "/include/catch"))

       #:phases (modify-phases %standard-phases
                  (add-after 'install 'install-python
                    (lambda* (#:key outputs #:allow-other-keys)
                      (let ((out (assoc-ref outputs "out")))
                        (with-directory-excursion "../source"
                          (setenv "PYBIND11_USE_CMAKE" "yes")
                          (invoke "python" "setup.py" "install"
                                  "--single-version-externally-managed"
                                  "--root=/"
                                  (string-append "--prefix=" out)))))))

       #:test-target "check"))
    (home-page "https://github.com/pybind/pybind11/")
    (synopsis "Seamless operability between C++11 and Python")
    (description
     "@code{pybind11} is a lightweight header-only library that exposes C++
types in Python and vice versa, mainly to create Python bindings of existing
C++ code.  Its goals and syntax are similar to the @code{Boost.Python}
library: to minimize boilerplate code in traditional extension modules by
inferring type information using compile-time introspection.")
    (license license:bsd-3)))

;; This is needed for python-vaex-core.
(define-public pybind11-2.3
  (package
    (inherit pybind11)
    (name "pybind11")
    (version "2.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/pybind/pybind11")
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "11b6dniri8m05spfd2a19irz82shf4sdca73566bniggrf3zclnf"))
              (file-name (git-file-name name version))))
    (arguments
     (substitute-keyword-arguments (package-arguments pybind11)
       ((#:tests? tests? #false)
        #false)))))

(define-public python-pooch
  (package
    (name "python-pooch")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pooch" version))
       (sha256
        (base32 "1618adsg9r8fsv422sv35z1i723q3a1iir5v7dv2sklh4pl4im1h"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ;requires online data
    (propagated-inputs
     (list python-appdirs python-packaging python-requests))
    (home-page "https://github.com/fatiando/pooch")
    (synopsis "Manage your Python library's sample data files")
    (description
     "Pooch manages your Python library's sample data files: it automatically
downloads and stores them in a local directory, with support for versioning
and corruption checks.")
    (license license:bsd-3)))

(define-public python-fasteners
  (package
    (name "python-fasteners")
    (version "0.15")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fasteners" version))
       (sha256
        (base32
         "1vzmz1xh38b84dv0f4hlp7arwmx8wjlih6lf964bpy8dnyk6s5rs"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-monotonic python-six))
    (native-inputs
     (list python-testtools))
    (home-page "https://github.com/harlowja/fasteners")
    (synopsis "Python package that provides useful locks")
    (description
     "This package provides a Python program that provides following locks:

@itemize
@item Locking decorator
@item Reader-writer locks
@item Inter-process locks
@item Generic helpers
@end itemize\n")
    (license license:asl2.0)))

(define-public python-requests-file
  (package
    (name "python-requests-file")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "requests-file" version))
       (sha256
        (base32 "13kx4k83i9zcv20h0fnmawwwdzhcmw1z97mqib1h379qsc445mq7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "tests/test_requests_file.py")))))))
    (propagated-inputs
     (list python-requests python-six))
    (home-page "https://github.com/dashea/requests-file")
    (synopsis "File transport adapter for Requests")
    (description
     "Requests-File is a transport adapter for use with the Requests Python
library to allow local file system access via @code{file://} URLs.")
    (license license:asl2.0)))

(define-public python-identify
  (package
    (name "python-identify")
    (version "1.4.25")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chriskuehl/identify")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fqgci6skckcq0x5pnxh6k2qjzn1ndsrgha1j6wwv1ld4g9bd3hz"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; system-error "utime" "~A" ("No such file or directory")
         (delete 'ensure-no-mtimes-pre-1980)
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-coverage python-pytest))
    (propagated-inputs
     (list python-editdistance))
    (home-page "https://github.com/chriskuehl/identify")
    (synopsis "File identification library for Python")
    (description
     "@code{identify} is a file identification library for Python.  Given
a file (or some information about a file), return a set of standardized tags
identifying what the file is.")
    (license license:expat)))

(define-public python-tldextract
  (package
    (name "python-tldextract")
    (version "3.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tldextract" version))
       (sha256
        (base32
         "1wac4yvcpgqjvls770mfx165amvy7gr00nnd2w24bqqwyamj9kdd"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-responses python-setuptools-scm))
    (propagated-inputs
     (list python-filelock python-idna python-requests python-requests-file))
    (home-page
     "https://github.com/john-kurkowski/tldextract")
    (synopsis
     "Separate the TLD from the registered domain and subdomains of a URL")
    (description
     "TLDExtract accurately separates the TLD from the registered domain and
subdomains of a URL, using the Public Suffix List.  By default, this includes
the public ICANN TLDs and their exceptions.  It can optionally support the
Public Suffix List's private domains as well.")
    (license license:bsd-3)))

(define-public python-tldr
  (package
    (name "python-tldr")
    (version "3.1.0")
    (source
     (origin
       ;; There's no test in PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tldr-pages/tldr-python-client")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hxmprqg8c4cvs19n7f80f3y7jj74i8sc2dmq2gdjmsdrb54bbzc"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'build 'build-doc
                 (lambda _
                   (invoke "make" "-C" "docs")))
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     ;; This test fails. It tries to open a network socket.
                     (invoke "pytest" "-vv" "-k" "not test_error_message")))))))
    (native-inputs
     (list python-pytest python-pytest-runner python-sphinx-argparse))
    (inputs
     (list python-argcomplete python-colorama python-termcolor python-shtab))
    (home-page "https://github.com/tldr-pages/tldr-python-client")
    (synopsis "Python command-line client for tldr pages")
    (description "This package provides the @code{tldr} command allowing users
to view @code{tldr} pages from a shell.  The @code{tldr} pages are a community
effort to simplify the man pages with practical examples.")
    (license license:expat))) ; MIT license

(define-public python-nodeenv
  (package
    (name "python-nodeenv")
    (version "1.4.0")
    (source
     (origin
       ;; There's no tarball in PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ekalinin/nodeenv")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0y443icx0w7jlzmxmmcm4q8dqfiwgafbb9cp8jpm68mbqxbz40a7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; This test fails. It tries to open a network socket.
             (invoke "pytest" "-vv" "-k" "not test_smoke"))))))
    (native-inputs
     (list python-coverage python-mock python-pytest))
    (home-page "https://ekalinin.github.io/nodeenv/")
    (synopsis "Create isolated node.js environments")
    (description
     "Nodeenv (node.js virtual environment) is a tool to create isolated
node.js environments.  It creates an environment that has its own installation
directories, that doesn't share libraries with other node.js virtual
environments.")
    (license license:bsd-3)))

(define-public python-pynamecheap
  (package
    (name "python-pynamecheap")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyNamecheap" version))
       (sha256
        (base32
         "0wkbwz208j8nfrsmzmclvxg22ymknn0mlz76wbdza9k2bx2zja6l"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-requests))
    (home-page
     "https://github.com/Bemmu/PyNamecheap")
    (synopsis
     "Namecheap API client in Python")
    (description
     "PyNamecheap is a Namecheap API client in Python.")
    (license license:expat)))

(define-public python-dns-lexicon
  (package
    (name "python-dns-lexicon")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dns-lexicon" version))
       (sha256
        (base32
         "0jdn3ns71bsybr7njgsqr9xlxsqh7zh6phn4ld0liazqdn2l5f6m"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;requires internet access
    (propagated-inputs
     (list python-future python-pynamecheap python-requests
           python-tldextract python-urllib3))
    (home-page "https://github.com/AnalogJ/lexicon")
    (synopsis
     "Manipulate DNS records on various DNS providers")
    (description
     "Lexicon provides a way to manipulate DNS records on multiple DNS
providers in a standardized way.  It has a CLI but it can also be used as a
Python library.  It was designed to be used in automation, specifically with
Let's Encrypt.")
    (license license:expat)))

(define-public python-cfgv
  (package
    (name "python-cfgv")
    (version "3.3.1")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/asottile/cfgv")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pci97cmn3v45sfch9s3lshidrl0309ls9byidic0l8drkwnkwcj"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/asottile/cfgv")
    (synopsis "Configuration validation library")
    (description
     "This library helps to validate configuration files and produce human
readable error messages.")
    (license license:expat)))

(define-public python-commandlines
  (package
    (name "python-commandlines")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "commandlines" version))
       (sha256
        (base32
         "0r7xcr0knv02p4mswa2bng61nn8nbhhrs6kvdnb9bb3hhjvm1dl6"))))
    (build-system python-build-system)
    (home-page "https://github.com/chrissimpkins/commandlines")
    (synopsis "Command line argument to object parsing library")
    (description
     "@code{Commandlines} is a Python library for command line application
development that supports command line argument parsing, command string
validation testing and application logic.")
    (license license:expat)))

;; Make sure to upgrade python-llvmlite in (gnu packages llvm) together with
;; python-numba.  They have a very unflexible relationship.
(define-public python-numba
  (package
    (name "python-numba")
    (version "0.55.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numba" version))
       (sha256
        (base32
         "18rf8i32m1045zxglvicpgldvzmqdxqvs3dhjd7wilb64sd0ds83"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-proprietary-features
           (lambda _
             (setenv "NUMBA_DISABLE_HSA" "1")
             (setenv "NUMBA_DISABLE_CUDA" "1")))
         (add-after 'unpack 'disable-failing-tests
           (lambda _
             ;; This one test fails because a deprecation warning is printed.
             (substitute* "numba/tests/test_import.py"
               (("def test_no_accidental_warnings")
                "def disabled_test_no_accidental_warnings"))))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               ;; Something is wrong with the PYTHONPATH when running the
               ;; tests from the build directory, as it complains about not being
               ;; able to import certain modules.
               (with-directory-excursion "/tmp"
                 (setenv "HOME" (getcwd))
                 (invoke "python3" "-m" "numba.runtests" "-v" "-m"))))))))
    (propagated-inputs
     (list python-llvmlite python-numpy python-singledispatch))
    (native-inputs                      ;for tests
     (list python-jinja2 python-pygments))
    (home-page "https://numba.pydata.org")
    (synopsis "Compile Python code using LLVM")
    (description "Numba gives you the power to speed up your applications with
high performance functions written directly in Python.  With a few
annotations, array-oriented and math-heavy Python code can be just-in-time
compiled to native machine instructions, similar in performance to C, C++ and
Fortran, without having to switch languages or Python interpreters.

Numba works by generating optimized machine code using the LLVM compiler
infrastructure at import time, runtime, or statically (using the included pycc
tool).")
    (license license:bsd-3)))

(define-public python-numcodecs
  (package
    (name "python-numcodecs")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numcodecs" version))
       (sha256
        (base32
         "0kbfr8pl3x9glsypbq8hzim003f16ml1b1cvgrh4w1sdvgal6j7g"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (delete-file-recursively "c-blosc")
           (for-each delete-file '("numcodecs/blosc.c"
                                   "numcodecs/compat_ext.c"
                                   "numcodecs/lz4.c"
                                   "numcodecs/vlen.c"
                                   "numcodecs/zstd.c"))))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #false ; TODO: unclear why numcodecs.* are not found
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-avx2
           (lambda _
             (setenv "DISABLE_NUMCODECS_AVX2" "1")))
         (add-after 'unpack 'unbundle
           (lambda _
             (substitute* "setup.py"
               (("sources=sources \\+ blosc_sources,")
                "sources=sources,")
               (("extra_compile_args=extra_compile_args")
                "extra_compile_args=list(base_compile_args)")
               (("'numcodecs.zstd',")
                "'numcodecs.zstd', libraries=['zstd'], ")
               (("'numcodecs.lz4',")
                "'numcodecs.lz4', libraries=['lz4'], ")
               (("'numcodecs.blosc',")
                "'numcodecs.blosc', libraries=['blosc'], "))))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv")))))))
    (inputs
     (list c-blosc lz4 zlib
           `(,zstd "lib")))
    (propagated-inputs
     (list python-numpy python-msgpack))
    (native-inputs
     (list python-cython python-pytest python-setuptools-scm))
    (home-page "https://github.com/zarr-developers/numcodecs")
    (synopsis "Buffer compression and transformation codecs")
    (description
     "This Python package provides buffer compression and transformation
codecs for use in data storage and communication applications.")
    (license license:expat)))

(define-public python-asciitree
  (package
    (name "python-asciitree")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asciitree" version))
       (sha256
        (base32
         "0vhgri2m2xlnibhz4xwn4hpbc7xacisxjqrk6k5kyppq96vbk92a"))))
    (build-system python-build-system)
    (home-page "https://github.com/mbr/asciitree")
    (synopsis "Draws ASCII trees")
    (description "This package draws tree structures using characters.")
    (license license:expat)))

(define-public python-zarr
  (package
    (name "python-zarr")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "zarr" version))
       (sha256
        (base32
         "026n3sjzjv2gmwx6y72b8ij0hk42bc8zdbvfj5gdqzd4i6wj3ajk"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-service-tests
           (lambda _
             (setenv "ZARR_TEST_ABS" "0")
             (setenv "ZARR_TEST_MONGO" "0")
             (setenv "ZARR_TEST_REDIS" "0")
             #t))
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv" "-k" "not lmdb")
             #t)))))
    (propagated-inputs
     (list python-asciitree python-fasteners python-numcodecs
           python-numpy))
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (home-page "https://github.com/zarr-developers/zarr-python")
    (synopsis "Chunked, compressed, N-dimensional arrays for Python")
    (description
     "This package provides an implementation of chunked, compressed,
N-dimensional arrays for Python.")
    (license license:expat)))

(define-public python-anndata
  (package
    (name "python-anndata")
    (version "0.8.0")
    (source
     (origin
       ;; The tarball from PyPi doesn't include tests.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/theislab/anndata")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0v7npqrg1rdm8jzw22a45c0mqrmsv05r3k88i3lhzi0pzzxca1i1"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (delete 'check)
         (replace 'build
           (lambda _
             (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" ,version)
             (substitute* "anndata/_metadata.py"
               (("__version__ =.*")
                (string-append "__version__ = \"" ,version "\"\n")))
             ;; ZIP does not support timestamps before 1980.
             (setenv "SOURCE_DATE_EPOCH" "315532800")
             (invoke "flit" "build")))
         (replace 'install
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (let ((out (assoc-ref outputs "out")))
               (for-each (lambda (wheel)
                           (format #true wheel)
                           (invoke "python" "-m" "pip" "install"
                                   wheel (string-append "--prefix=" out)))
                         (find-files "dist" "\\.whl$"))))))))
    (propagated-inputs
     (list python-h5py
           python-importlib-metadata
           python-natsort
           python-numcodecs
           python-packaging
           python-pandas
           python-scipy
           python-zarr))
    (native-inputs
     (list python-joblib python-pytest python-toml python-flit
           python-setuptools-scm))
    (home-page "https://github.com/theislab/anndata")
    (synopsis "Annotated data for data analysis pipelines")
    (description "Anndata is a package for simple (functional) high-level APIs
for data analysis pipelines.  In this context, it provides an efficient,
scalable way of keeping track of data together with learned annotations and
reduces the code overhead typically encountered when using a mostly
object-oriented library such as @code{scikit-learn}.")
    (license license:bsd-3)))

(define-public python-dill
  (package
    (name "python-dill")
    (version "0.3.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dill" version))
       (sha256
        (base32 "11lc40x37cx2i8qqbc5qklifm65dyjl6prrqsycybvpixzrl2pnp"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (with-directory-excursion "/tmp"
               (invoke "nosetests" "-v"))
             #t)))))
    (native-inputs
     (list python-nose))
    (home-page "https://pypi.org/project/dill/")
    (synopsis "Serialize all of Python")
    (description "Dill extends Python's @code{pickle} module for serializing
and de-serializing Python objects to the majority of the built-in Python
types.  Dill provides the user the same interface as the @code{pickle} module,
and also includes some additional features.  In addition to pickling Python
objects, @code{dill} provides the ability to save the state of an interpreter
session in a single command.  Hence, it would be feasible to save a
interpreter session, close the interpreter, ship the pickled file to another
computer, open a new interpreter, unpickle the session and thus continue from
the saved state of the original interpreter session.")
    (license license:bsd-3)))

(define-public python-multiprocess
  (package
    (name "python-multiprocess")
    (version "0.70.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "multiprocess" version))
       (sha256
        (base32
         "1r882nvd44xqwbrclwqx5rhs80l6809rcvpc7pkpgnij06cvvmcz"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-broken-tests
           (lambda _
             ;; This test is broken as there is no keyboard interrupt.
             (substitute* "py3.7/multiprocess/tests/__init__.py"
               (("^(.*)def test_wait_result"
                 line indent)
                (string-append indent
                               "@unittest.skip(\"Disabled by Guix\")\n"
                               line)))
             #t))
         ;; Tests must be run after installation.
         (delete 'check)
         (add-after 'install 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "python" "-m" "multiprocess.tests")
             #t)))))
    (propagated-inputs
     (list python-dill))
    (home-page "https://pypi.org/project/multiprocess/")
    (synopsis "Multiprocessing and multithreading in Python")
    (description
     "This package is a fork of the multiprocessing Python package, a package
which supports the spawning of processes using the API of the standard
library's @code{threading} module.")
    (license license:bsd-3)))

(define-public python-multiprocessing-on-dill
  (package
    (name "python-multiprocessing-on-dill")
    (version "3.5.0a4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "multiprocessing_on_dill" version))
              (sha256
               (base32
                "1rs5a3hx1fcpfsxxkl5kx6g06c82wqjqgdqyny5l1ggl1wq0rmfn"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv")))))))
    (propagated-inputs (list python-dill))
    (native-inputs (list python-check-manifest python-pytest python-wheel))
    (home-page "https://github.com/sixty-north/multiprocessing_on_dill")
    (synopsis "Multiprocessing using dill instead of pickle")
    (description
     "This package provides a friendly fork of multiprocessing which uses dill
instead of pickle.")
    (license license:psfl)))

(define-public python-toolrack
  (package
    (name "python-toolrack")
    (version "3.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/albertodonato/toolrack")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0ych11b7nchnkhqgf7dgivbvn2lzafjsi7nhb1an5zjjyns39gpx"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-/bin/sh
            (lambda _
              (substitute* "toolrack/aio/tests/test_process.py"
                (("/bin/sh")
                 (which "sh")))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "--pyargs" "toolrack"
                        "-k"
                        (string-append
                         ;; These tests fail for unknown reason comparing the
                         ;; expected output of shell scripts.
                         "not test_parse_stderr "
                         "and not test_parse_no_ending_newline "
                         "and not test_parse_stdout"))))))))
    (native-inputs (list python-pytest python-pytest-asyncio
                         python-pytest-mock))
    (home-page "https://github.com/albertodonato/toolrack")
    (synopsis "Collection of Python utility functions and classes")
    (description "This package provides a collection of miscellaneous utility
functions and classes.")
    (license license:lgpl3+)))

(define-public python-toolz
  (package
    (name "python-toolz")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "toolz" version))
       (sha256
        (base32
         "0cxwlh8dz8gq0l0bzchjnqqwhdp261nfd958ppqm518k2mg2scbb"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest" "--doctest-modules"
                       "--pyargs" "toolz")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/pytoolz/toolz/")
    (synopsis "List processing tools and functional utilities")
    (description
     "This package provides a set of utility functions for iterators,
functions, and dictionaries.")
    (license license:bsd-3)))

(define-public python-cytoolz
  (package
    (name "python-cytoolz")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cytoolz" version))
       (sha256
        (base32
         "1d12mgaippxxhn24w2hj0my3aqkx80fks5g4wzfdsvl0acqnc8za"))
       (modules '((guix build utils)))
       (snippet
        '(for-each delete-file (find-files "cytoolz" "\\.c$")))))
    (build-system python-build-system)
    ;; FIXME: tests fail with "module 'cytoolz.curried' has no attribute
    ;; 'exceptions'"
    (arguments '(#:tests? #f))
    (propagated-inputs
     (list python-toolz))
    (native-inputs
     (list python-cython))
    (home-page "https://github.com/pytoolz/cytoolz")
    (synopsis "High performance functional utilities")
    (description
     "The cytoolz package implements the same API as provided by toolz.  The
main differences are that @code{cytoolz} is faster and cytoolz offers a C API
that is accessible to other projects developed in Cython.")
    (license license:bsd-3)))

(define-public python-sortedcollections
  (package
    (name "python-sortedcollections")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sortedcollections" version))
       (sha256
        (base32
         "1kfabpnjyjm5ml2zspry9jy3xq49aybchgaa4ahic2jqdjfn1sfq"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-sortedcontainers))
    (arguments '(#:tests? #f))  ; Tests not included in release tarball.
    (home-page "http://www.grantjenks.com/docs/sortedcollections/")
    (synopsis "Python Sorted Collections")
    (description "Sorted Collections is a Python sorted collections library.")
    (license license:asl2.0)))

(define-public python-sortedcontainers
  (package
    (name "python-sortedcontainers")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sortedcontainers" version))
       (sha256
        (base32
         "0fm0w5id2yhqld95hg2m636vjgkz377rvgdfqaxc25vbylr9lklp"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Tests require many extra dependencies, and would introduce
     ;; a circular dependency on hypothesis, which uses this package.
     '(#:tests? #f))
    (propagated-inputs
     `(("python-appdirs" ,python-appdirs)
       ("python-distlib" ,python-distlib)
       ("python-filelock" ,python-filelock)
       ("python-six" ,python-six-bootstrap)))
    (home-page "http://www.grantjenks.com/docs/sortedcontainers/")
    (synopsis "Sorted List, Sorted Dict, Sorted Set")
    (description
     "This package provides a sorted collections library, written in
pure-Python.")
    (license license:asl2.0)))

(define python-cloudpickle-testpkg
  (package
    (name "python-cloudpickle-testpkg")
    (version "1.6.0")
    (source
     (origin
       ;; Archive on pypi does not include test infrastructure.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/cloudpipe/cloudpickle")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1584d21d4rcpryn8yfz0pjnjprk4zm367m0razdcz8cjbsh0dxp6"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'chdir
           (lambda _ (chdir "tests/cloudpickle_testpkg"))))))
    (home-page "https://github.com/cloudpipe/cloudpickle")
    (synopsis "Extended pickling support for Python objects")
    (description
     "Cloudpickle makes it possible to serialize Python constructs not
supported by the default pickle module from the Python standard library.  It
is especially useful for cluster computing where Python expressions are
shipped over the network to execute on remote hosts, possibly close to the
data.")
    (license license:bsd-3)))

(define-public python-cloudpickle
  (package
    (inherit python-cloudpickle-testpkg)
    (name "python-cloudpickle")
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (if tests?
                 (invoke "pytest" "-s" "-vv")
                 (format #t "test suite not run~%")))))))
    (native-inputs
     (list ;; For tests.
           python-cloudpickle-testpkg python-psutil python-pytest
           python-tornado-6))
    (home-page "https://github.com/cloudpipe/cloudpickle")
    (synopsis "Extended pickling support for Python objects")
    (description
     "Cloudpickle makes it possible to serialize Python constructs not
supported by the default pickle module from the Python standard library.  It
is especially useful for cluster computing where Python expressions are
shipped over the network to execute on remote hosts, possibly close to the
data.")
    (license license:bsd-3)))

(define-public python-locket
  (package
    (name "python-locket")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "locket" version))
       (sha256
        (base32
         "0cm6290zm3ba62n2x2piy3s8d41hrmffda2nw18ggfwb582lq3aw"))))
    (build-system python-build-system)
    (home-page "https://github.com/mwilliamson/locket.py")
    (synopsis "File-based locks for Python")
    (description
     "Locket implements a lock that can be used by multiple processes provided
they use the same path.")
    (license license:bsd-2)))

(define-public python-blosc
  (package
    (name "python-blosc")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "blosc" version))
       (sha256
        (base32
         "1cm91c6r431yla2mbs4895bgiianjf30dfz14vvv99dslygd65jw"))))
    (build-system python-build-system)
    ;; FIXME: all tests pass, but then this error is printed:
    ;; TypeError: calling <function run at 0x7ffff2568d90> returned None, not a test
    (arguments '(#:tests? #f))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/blosc/python-blosc")
    (synopsis "Python wrapper for the Blosc data compressor library")
    (description "Blosc is a high performance compressor optimized for binary
data.  It has been designed to transmit data to the processor cache faster
than the traditional, non-compressed, direct memory fetch approach via a
@code{memcpy()} system call.

Blosc works well for compressing numerical arrays that contains data with
relatively low entropy, like sparse data, time series, grids with
regular-spaced values, etc.

This Python package wraps the Blosc library.")
    (license license:bsd-3)))

(define-public python-partd
  (package
    (name "python-partd")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "partd" version))
       (sha256
        (base32
         "1sy3vdfyyx3bc5590zb7gwpsmimqz8m992x9hsydq8nmhixqjrxa"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-blosc
           python-locket
           python-numpy
           python-pandas
           python-pyzmq
           python-toolz))
    (home-page "https://github.com/dask/partd/")
    (synopsis "Appendable key-value storage")
    (description "Partd stores key-value pairs.  Values are raw bytes.  We
append on old values.  Partd excels at shuffling operations.")
    (license license:bsd-3)))

(define-public python-fsspec
  (package
    (name "python-fsspec")
    (version "2022.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fsspec" version))
       (sha256
        (base32
         "1d43qiz8g395042a52yswz6j7q41gvrv3k53wvxn1rs4bk3mjm3s"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ; there are none
    (home-page "https://github.com/intake/filesystem_spec")
    (synopsis "File-system specification")
    (description "The purpose of this package is to produce a template or
specification for a file-system interface, that specific implementations
should follow, so that applications making use of them can rely on a common
behavior and not have to worry about the specific internal implementation
decisions with any given backend.")
    (license license:bsd-3)))

;; Note: Remember to update python-distributed when updating dask.
(define-public python-dask
  (package
    (name "python-dask")
    (version "2022.05.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dask/dask/")
             (commit "8db1597c9745543df3129399bead5fbc95a54571")))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1xfk3wml972z502w5ii5mn03ls3rg5p4hqgl0hkicgpmzlyz9kph"))
       (snippet
        ;; Delete generated copy of python-versioneer.  We recreate it below.
        '(delete-file "versioneer.py"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'versioneer
           (lambda _
             (invoke "versioneer" "install")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-cloudpickle
           python-fsspec
           python-numpy
           python-packaging
           python-pandas
           python-partd
           python-toolz
           python-pyyaml))
    (native-inputs
     (list python-pytest python-pytest-runner python-pytest-rerunfailures
           python-versioneer))
    (home-page "https://github.com/dask/dask/")
    (synopsis "Parallel computing with task scheduling")
    (description
     "Dask is a flexible parallel computing library for analytics.  It
consists of two components: dynamic task scheduling optimized for computation,
and large data collections like parallel arrays, dataframes, and lists that
extend common interfaces like NumPy, Pandas, or Python iterators to
larger-than-memory or distributed environments.  These parallel collections
run on top of the dynamic task schedulers.")
    (license license:bsd-3)))

(define-public python-ilinkedlist
  (package
    (name "python-ilinkedlist")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ilinkedlist" version))
       (sha256
        (base32
         "0nrw4sr3afldrp7073hvc0rgdz282s0l819jdmj1i6nn05v33h0l"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (inputs (list python))
    (home-page "https://github.com/luther9/ilinkedlist-py")
    (synopsis "Immutable linked list library")
    (description
     "This is a implementation of immutable linked lists for Python.  It
contains @code{nil} (the empty linked list) and a @code{Pair} class for nodes.
Since a linked list is treated as immutable, it is hashable, and its length
can be retrieved in constant time.  Some of the terminology is inspired by
LISP.  It is possible to create an improper list by creating a @code{Pair}
with a non-list @code{cdr}.")
    (license license:gpl3+)))

(define-public python-readlike
  (package
    (name "python-readlike")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "readlike" version))
       (sha256
        (base32 "027w8fvi50ksl57q0a7kb5zvmq8jxaawnviib1jdqw0p3igvm1j4"))))
    (build-system python-build-system)
    (home-page "https://github.com/jangler/readlike")
    (synopsis "GNU Readline-like line editing module")
    (description
     "This Python module provides line editing functions similar to the default
Emacs-style ones of GNU Readline.  Unlike the Python standard library's
@code{readline} package, this one allows access to those capabilities in settings
outside of a standard command-line interface.  It is especially well-suited to
interfacing with Urwid, due to a shared syntax for describing key inputs.

Currently, all stateless Readline commands are implemented.  Yanking and history
are not supported.")
    (license license:expat)))

(define-public python-reparser
  (package
    (name "python-reparser")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ReParser" version))
       (sha256
        (base32 "0nniqb69xr0fv7ydlmrr877wyyjb61nlayka7xr08vlxl9caz776"))))
    (build-system python-build-system)
    (home-page "https://github.com/xmikos/reparser")
    (synopsis "Simple lexer/parser for inline markup based on regular expressions")
    (description
     "This Python library provides a simple lexer/parser for inline markup based
on regular expressions.")
    (license license:expat)))

(define-public python-retrying
  (package
    (name "python-retrying")
    (version "1.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rholder/retrying")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1kqipkbdaw5s1xg0gi29awm03vp1x8dz24pjidgxagvkvrjpzhi7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/rholder/retrying")
    (synopsis "Library for adding retry behavior")
    (description "Retrying is a general-purpose retrying library to simplify
the task of adding retry behavior to just about anything.

Features:

@itemize
@item Generic Decorator API.
@item Specify stop condition (i.e. limit by number of attempts).
@item Specify wait condition (i.e. exponential backoff sleeping between attempts).
@item Customize retrying on Exceptions.
@item Customize retrying on expected returned result.
@end itemize")
    (license license:asl2.0)))

(define-public python-pre-commit
  (package
    (name "python-pre-commit")
    (version "2.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pre_commit" version))
       (sha256
        (base32 "1ycf6wpxrhxhdzz0vpryhbdxlwik5khgcvp3hxwvfr447a6k84zl"))))
    (build-system python-build-system)
    (arguments
     ;; Tests fail with "AttributeError: module 'pre_commit.resources' has no
     ;; attribute 'empty_template_setup'".
     `(#:tests? #false))
    (propagated-inputs
     (list python-cfgv
           python-identify
           python-importlib-metadata
           python-nodeenv
           python-pyyaml
           python-toml
           python-virtualenv))
    (home-page "https://github.com/pre-commit/pre-commit")
    (synopsis "Framework for managing multi-language pre-commit hooks")
    (description
     "This package provides a framework for managing and maintaining
multi-language pre-commit hooks.")
    (license license:expat)))

(define-public python-precis-i18n
  (package
    (name "python-precis-i18n")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "precis_i18n" version))
       (sha256
        (base32
         "1qfb78zpx565vqkg0xhx75pna9sc35m370vpcz82982c8ix3ypyz"))))
    (build-system python-build-system)
    (home-page "https://github.com/byllyfish/precis_i18n")
    (synopsis "Implementation of the PRECIS framework")
    (description
     "This module implements the PRECIS Framework as described in RFC 8264,
RFC 8265 and RFC 8266.")
    (license license:expat)))

(define-public python-absl-py
  (package
    (name "python-absl-py")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "absl-py" version))
       (sha256
        (base32
         "1mp9lk0b2qa37b7y6ak4lvf6ifw2ylyy6bkf9ik77md3j4xrwlc7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/abseil/abseil-py")
    (synopsis "Abseil Python common libraries")
    (description
     "This package provides the Abseil Python Common Libraries, a collection
of Python libraries for building Python applications.")
    (license license:asl2.0)))

(define-public python-astor
  (package
    (name "python-astor")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "astor" version))
       (sha256
        (base32
         "0ppscdzzvxpznclkmhhj53iz314x3pfv4yc7c6gwxqgljgdgyvka"))))
    (build-system python-build-system)
    ;; FIXME: There are two errors and two test failures.
    (arguments `(#:tests? #f))
    (home-page "https://github.com/berkerpeksag/astor")
    (synopsis "Read and write Python ASTs")
    (description "Astor is designed to allow easy manipulation of Python
source via the Abstract Syntax Tree.")
    (license license:bsd-3)))

(define-public python-astunparse
  (package
    (name "python-astunparse")
    (version "1.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "astunparse" version))
       (sha256
        (base32 "0wh8jjvwafxc7rvbyb13cdwndkicm7cry1bd8p1q9l7has23mnas"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ; there are none
    (propagated-inputs
     (list python-six python-wheel))
    (home-page "https://github.com/simonpercivall/astunparse")
    (synopsis "AST unparser for Python")
    (description "This package provides an AST unparser for Python.  It is a
factored out version of @code{unparse} found in the Python source
distribution.")
    (license license:bsd-3)))

(define-public python-gast
  (package
    (name "python-gast")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gast" version))
       (sha256
        (base32 "1sidaczriw54pfkj3523y9j9q2harrczc1qqgnfaylz641ca5gng"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-astunparse))
    (home-page "https://github.com/serge-sans-paille/gast/")
    (synopsis "Generic Python AST that abstracts the underlying Python version")
    (description
     "GAST provides a compatibility layer between the AST of various Python
versions, as produced by @code{ast.parse} from the standard @code{ast}
module.")
    (license license:bsd-3)))

(define-public python-wikidata
  (package
    (name "python-wikidata")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Wikidata" version))
       (sha256
        (base32
         "08nlnydddfp1jj0cdmshvld1irzngbp3dij928wqsg9ziklm6mw9"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-babel))
    (home-page "https://github.com/dahlia/wikidata")
    (synopsis "Wikidata client library")
    (description
     "This package provides a Python interface to
@url{https://www.wikidata.org/, Wikidata}.")
    (properties '((upstream-name . "Wikidata")))
    (license license:gpl3+)))

(define-public python-doctest-ignore-unicode
  (package
    (name "python-doctest-ignore-unicode")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "doctest-ignore-unicode" version))
       (sha256
        (base32
         "1m9aa4qnyj21lbq4sbvmv1vcz7zksss4rz37ddf2hxv4hk8b547w"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/gnublade/doctest-ignore-unicode")
    (synopsis "Ignore Unicode literal prefixes in doctests")
    (description
     "This package adds support for a flag to ignore Unicode literal prefixes
in doctests.")
    (license license:asl2.0)))

(define-public python-attr
  (package
    (name "python-attr")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "attr" version))
       (sha256
        (base32
         "0pbpskvxp5hzdvcaf766ljwpckshir8sf7z6jqji6zyib20594ch"))))
    (build-system python-build-system)
    (home-page "https://github.com/denis-ryzhkov/attr")
    (synopsis "Decorator for attributes of target function or class")
    (description "Simple decorator to set attributes of target function or
class in a @acronym{DRY, Don't Repeat Yourself} way.")
    (license license:expat)))

(define-public python-construct
  (package
    (name "python-construct")
    (version "2.10.56")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "construct" version))
       (sha256
        (base32
         "0q86jjzsvy835h3c8pjj4619vbp7ihfg8njmyw86ym4qrpni7flp"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; No tests exist.
    (propagated-inputs
     (list python-extras python-arrow python-numpy python-ruamel.yaml))
    (home-page "https://construct.readthedocs.io")
    (synopsis "Declarative and symmetrical parser and builder for binary data")
    (description
     "This package provides both simple, atomic constructs (such as
integers of various sizes), as well as composite ones which allow you
form hierarchical and sequential structures of increasing complexity.
It features bit and byte granularity, easy debugging and testing, an
easy-to-extend subclass system, and lots of primitive constructs to
make your work easier.")
    (license license:expat)))

(define-public python-outcome
  (package
    (name "python-outcome")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "outcome" version))
       (sha256
        (base32 "0vxn04vspmlkkyijjkjnsc46f93ki8g62hr7ag10zpd7ic324y7w"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-asyncio))
    (propagated-inputs
     (list python-async-generator python-attrs))
    (home-page "https://github.com/python-trio/outcome")
    (synopsis "Capture the outcome of Python function calls")
    (description
     "Capture the outcome of Python function calls.  Extracted from the Trio
project.")
    ;; Either license applies.
    (license (list license:expat license:asl2.0))))

(define-public python-trio
  (package
    (name "python-trio")
    (version "0.20.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "trio" version))
       (sha256
        (base32 "0w30cwmdwfa8zq2agqv3h62jzwwsk7ms8f683ag8f3jx279m42k7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-sleep
           (lambda _
             (substitute* "trio/tests/test_subprocess.py"
               (("/bin/sleep")
                (which "sleep")))))
         (add-before 'check 'change-home
           (lambda _
             ;; Tests require a writable home.
             (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv"
                       "-n" (number->string (parallel-job-count))
                       "-k"
                       (string-append
                         ;; This test times out.
                         "not test_ki_protection_works"
                         ;; Assertion errors.
                         " and not test_guest_mode_ki"
                         " and not test_run_in_trio_thread_ki"
                         " and not test_simple_cancel_scope_usage_doesnt_create_cyclic_garbage"
                         " and not test_nursery_cancel_doesnt_create_cyclic_garbage"
                         " and not test_cancel_scope_exit_doesnt_create_cyclic_garbage"
                         " and not test_locals_destroyed_promptly_on_cancel"
                         " and not test_ipython_exc_handler"
                         " and not test_for_leaking_fds"
                         ;; These try to raise KeyboardInterrupt which does not work
                         ;; in the build environment.
                         " and not test_ki_self"
                         " and not test_ki_wakes_us_up"
                         ;; Failure in name resolution.
                         " and not test_getnameinfo"
                         " and not test_SocketType_resolve"
                         ;; OSError: protocol not found.
                         " and not test_getprotobyname"
                         ;; EOFError: Ran out of input.
                         " and not test_static_tool_sees_all_symbols"))))))))
    (native-inputs
     (list python-astor
           python-ipython
           python-jedi
           python-pylint
           python-pyopenssl
           python-pytest
           python-pytest-xdist
           python-pytest-cov
           python-trustme))
    (propagated-inputs
     (list python-async-generator
           python-attrs
           python-idna
           python-outcome
           python-sniffio
           python-sortedcontainers))
    (home-page "https://github.com/python-trio/trio")
    (synopsis "Friendly Python library for async concurrency and I/O")
    (description
     "Trio strives to be a production-quality, async/await-native I/O library
for Python.  Like all async libraries, its main purpose is to help you write
programs that do multiple things at the same time with parallelized I/O.")
    ;; Either license applies.
    (license (list license:expat license:asl2.0))))

(define-public python-trio-typing
  (package
    (name "python-trio-typing")
    (version "0.5.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "trio-typing" version))
      (sha256
       (base32 "1yvlj4vf3wyvp16dw6vyfm4i2idm8lvdc3fvjhi6mhm62zv7s07j"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-attrs python-pytest))
    (propagated-inputs
     (list python-mypy python-mypy-extensions python-trio
           python-typing-extensions))
    (home-page "https://github.com/python-trio/trio-typing")
    (synopsis "Static type checking support for Trio and related projects")
    (description
     "This package provides:

@itemize
@item PEP 561 typing stubs packages for the Trio project packages:

@itemize
@item trio (@code{trio-stubs})
@item outcome (@code{outcome-stubs})
@item async_generator (@code{async_generator-stubs})
@end itemize

@item A package @code{trio_typing} containing types that Trio programs often
want to refer to (@code{AsyncGenerator[Y, S]} and @code{TaskStatus[T])} and
a mypy plugin that smooths over some limitations in the basic type hints.
@end itemize")
    ;; Either license applies.
    (license (list license:expat license:asl2.0))))

(define-public python-trio-websocket
  (package
    (name "python-trio-websocket")
    (version "0.9.2")
    (source
     (origin
       (method git-fetch)               ;no tests in pypi archive
       (uri (git-reference
             (url "https://github.com/HyperionGray/trio-websocket")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1yk2ak991kbl30xg8ldpggack1lwkizd7s5cpr28ir34z8iyjnpi"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest python-pytest-trio python-trustme))
    (propagated-inputs (list python-async-generator python-trio python-wsproto))
    (home-page "https://github.com/HyperionGray/trio-websocket")
    (synopsis "WebSocket library for Trio")
    (description "This library implements both server and client aspects of
the @url{https://tools.ietf.org/html/rfc6455, the WebSocket protocol},
striving for safety, correctness, and ergonomics.  It is based on the
@url{https://wsproto.readthedocs.io/en/latest/, wsproto project}, which is a
@url{https://sans-io.readthedocs.io/, Sans-IO} state machine that implements
the majority of the WebSocket protocol, including framing, codecs, and events.
This library handles I/O using @url{https://trio.readthedocs.io/en/latest/,
the Trio framework}.")
    (license license:expat)))

(define-public python-humanize
  (package
    (name "python-humanize")
    (version "0.5.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "humanize" version))
        (sha256
         (base32
          "06dvhm3k8lf2rayn1gxbd46y0fy1db26m3h9vrq7rb1ib08mfgx4"))))
    (arguments
     '(#:tests? #f)) ; tests not in pypi archive
    (build-system python-build-system)
    (home-page "https://github.com/jmoiron/humanize")
    (synopsis "Print numerical information in a human-readable form")
    (description "This package provides a Python module that displays numbers
and dates in \"human readable\" forms.  For example, it would display
\"12345591313\" as \"12.3 billion\".")
    (license license:expat)))

(define-public python-txaio
  (package
    (name "python-txaio")
    (version "18.8.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "txaio" version))
        (sha256
         (base32
          "1zmpdph6zddgrnkkcykh6qk5s46l7s5mzfqrh82m4b5iffn61qv7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-twisted python-six))
    (home-page "https://github.com/crossbario/txaio")
    (synopsis "Compatibility layer between Python asyncio and Twisted")
    (description "Txaio provides a compatibility layer between the Python
@code{asyncio} module and @code{Twisted}.")
    (license license:expat)))

(define-public python-toolshed
  (package
    (name "python-toolshed")
    (version "0.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "toolshed" version))
       (sha256
        (base32
         "14zvz51gzf9i1i3d1sj363ba4rksl6lcf4lz1arl8hpqgcbir8r3"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/brentp/toolshed/")
    (synopsis "Collection of modules and functions for working with data")
    (description "This is a collection of well-tested, simple modules and
functions that aim to reduce boilerplate when working with data.")
    (license license:bsd-2)))

(define-public python-annoy
  (package
    (name "python-annoy")
    (version "1.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "annoy" version))
       (sha256
        (base32
         "1rxn6snn0r32r07g45hdjhh8aa1xzx6fjrm8g62d8vzp46z7rzrp"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/spotify/annoy/")
    (synopsis "Approximate nearest neighbors library")
    (description
     "Annoy is a C++ library with Python bindings to search for points in
space that are close to a given query point.  It also creates large read-only
file-based data structures that are @code{mmap}ped into memory so that many
processes may share the same data.")
    (license license:asl2.0)))

(define-public python-croniter
  (package
    (name "python-croniter")
    (version "1.3.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "croniter" version))
              (sha256
               (base32
                "1whbm26m9kpn0klgr9dqiqpp83ki9nhpxifaq9afcjw32rckcs9i"))))
    (build-system python-build-system)
    (propagated-inputs (list python-dateutil))
    (home-page "https://github.com/kiorky/croniter")
    (synopsis "Iterate datetime objects with cron-like syntax")
    (description
     "@code{croniter} provides iteration for datetime object with cron-like
format.")
    (license license:expat)))

(define-public python-crontab
  (package
    (name "python-crontab")
    (version "2.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri name version))
       (sha256
        (base32 "0cccrqc10r8781ba81x8r2frs3pl2m4hkm599k5358ak0xr7xgjb"))))
    (build-system python-build-system)
    (arguments
     ;; Comptability tests fail so they are disabled.
     `(#:tests? #f))
    (inputs
     (list python-dateutil))
    (home-page "https://gitlab.com/doctormo/python-crontab/")
    (synopsis "Module for reading and writing crontab files")
    (description "This Python module can read, write crontab files, and
access the system cron automatically and simply using a direct API.")
    (license license:lgpl3+)))

(define-public python-pylzma
  (package
    (name "python-pylzma")
    (version "0.5.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pylzma" version))
        (sha256
          (base32
            "074anvhyjgsv2iby2ql1ixfvjgmhnvcwjbdz8gk70xzkzcm1fx5q"))))
    (build-system python-build-system)
    (home-page "https://www.joachim-bauch.de/projects/pylzma/")
    (synopsis "Python bindings for the LZMA library by Igor Pavlov")
    (description "This package provides Python bindings for the LZMA library
by Igor Pavlov.")
    (license license:lgpl2.1+)))

(define-public python-ifaddr
  (package
    (name "python-ifaddr")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ifaddr" version))
       (sha256
        (base32
         "150sxdlicwrphmhnv03ykxplyd2jdrxz0mikgnivavgilrn8m7hz"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "nosetests"))))))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/pydron/ifaddr")
    (synopsis "Network interface and IP address enumeration library")
    (description "This package provides a network interface and IP address
enumeration library in Python.")
    (license license:expat)))

(define-public python-zeroconf
  (package
    (name "python-zeroconf")
    (version "0.38.1")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/jstasiak/python-zeroconf")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1p1a0ywlg5sq0ilcphmz9h4kayscz0q1lyfk57j7mwxyx4gl9cpi"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest" "-k"
                       (string-append
                        ;; Networking isn't available for these tests.
                        "not test_integration_with_listener_ipv6"
                        " and not test_launch_and_close_v4_v6"
                        " and not test_launch_and_close_context_manager"
                        " and not test_launch_and_close"
                        " and not test_close_multiple_times"))))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-ifaddr))
    (home-page "https://github.com/jstasiak/python-zeroconf")
    (synopsis "Pure Python mDNS service discovery")
    (description "Pure Python multicast DNS (mDNS) service discovery library
(Bonjour/Avahi compatible).")
    (license license:lgpl2.1+)))

(define-public python-bsddb3
  (package
    (name "python-bsddb3")
    (version "6.2.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bsddb3" version))
       (sha256
        (base32 "00bqdsfx8jgmfz5bgkx10nlw5bfsw11a86f91zkl53snvk45xl3h"))))
    (build-system python-build-system)
    (inputs
     (list bdb))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure-locations
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "BERKELEYDB_DIR" (assoc-ref inputs "bdb"))
             (setenv "YES_I_HAVE_THE_RIGHT_TO_USE_THIS_BERKELEY_DB_VERSION" "1")
             #t))
         (replace 'check
           (lambda _
             (invoke "python3" "test3.py" "-v"))))))
    (home-page "https://www.jcea.es/programacion/pybsddb.htm")
    (synopsis "Python bindings for Oracle Berkeley DB")
    (description
     "This module provides a nearly complete wrapping of the Oracle/Sleepycat
C API for the Database Environment, Database, Cursor, Log Cursor, Sequence and
Transaction objects, and each of these is exposed as a Python type in the
bsddb3.db module.  The database objects can use various access methods: btree,
hash, recno, and queue.  Complete support of Berkeley DB distributed
transactions.  Complete support for Berkeley DB Replication Manager.
Complete support for Berkeley DB Base Replication.  Support for RPC.")
    (license license:bsd-3)))

(define-public python-dbfread
  (package
    (name "python-dbfread")
    (version "2.0.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dbfread" version))
              (sha256
               (base32
                "0gdpwdzf1fngsi6jrdyj4qdf6cr7gnnr3zp80dpkzbgz0spskj07"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://dbfread.readthedocs.io")
    (synopsis "Read DBF Files with Python")
    (description
     "This library reads DBF files and returns the data as native Python data
types for further processing.  It is primarily intended for batch jobs and
one-off scripts.")
    (license license:expat)))

(define-public python-cached-property
  (package
    (name "python-cached-property")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cached-property" version))
       (sha256
        (base32
         "0c51i6yzg6dlq6zhk4c6nv33mg8gv05kkan36k9b5jzf71c7b9cz"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; https://github.com/pydanny/cached-property/issues/131
         ;; recent versions of freezegun break one test
         (add-after 'unpack 'disable-broken-test
           (lambda _
             (substitute* "tests/test_cached_property.py"
               (("def test_threads_ttl_expiry\\(self\\)" m)
                (string-append "@unittest.skip(\"Disabled by Guix\")\n"
                               "    " m)))
             #t)))))
    (native-inputs
     (list python-freezegun))
    (home-page
     "https://github.com/pydanny/cached-property")
    (synopsis
     "Decorator for caching properties in classes")
    (description
     "This package provides a decorator which makes caching
time-or-computationally-expensive properties quick and easy and works in Python
2 or 3.")
    (license license:bsd-3)))

(define-public python-folium
  (package
    (name "python-folium")
    (version "0.13.0")
    (source
     (origin
       ;; PyPI has a ".whl" file but not a proper source release.
       ;; Thus, fetch code from Git.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python-visualization/folium")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00adpdi1890zzzg7ffp04hmx59igdcdpyqa129vnmwqh54b5a006"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-branca python-jinja2 python-numpy python-requests))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/python-visualization/folium")
    (synopsis "Make beautiful maps with Leaflet.js & Python")
    (description "@code{folium} makes it easy to visualize data that’s been
manipulated in Python on an interactive leaflet map.  It enables both the
binding of data to a map for @code{choropleth} visualizations as well as
passing rich vector/raster/HTML visualizations as markers on the map.

The library has a number of built-in tilesets from OpenStreetMap, Mapbox, and
Stamen, and supports custom tilesets with Mapbox or Cloudmade API keys.  It
supports Image, Video, GeoJSON and TopoJSON overlays.")
    (license license:expat)))

(define-public python-mercantile
  (package
    (name "python-mercantile")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mercantile" version))
       (sha256
        (base32 "0sxmndhzzrvss5irsgzfrk51k6jihwcb7661992mizdgbnqnsg7s"))))
    (build-system python-build-system)
    (propagated-inputs (list python-click))
    (native-inputs
     (list python-check-manifest python-hypothesis python-pytest))
    (home-page "https://github.com/mapbox/mercantile")
    (synopsis "Web mercator XYZ tile utilities")
    (description "The mercantile module provides @code{ul(xtile, ytile, zoom)}
and @code{bounds(xtile, ytile, zoom)} functions that respectively return the
upper left corner and bounding longitudes and latitudes for XYZ tiles, a
@code{xy(lng, lat)} function that returns spherical mercator x and y
coordinates, a @code{tile(lng, lat, zoom)} function that returns the tile
containing a given point, and quadkey conversion functions
@code{quadkey(xtile, ytile, zoom)} and @code{quadkey_to_tile(quadkey)} for
translating between quadkey and tile coordinates.")
    (license license:bsd-3)))

(define-public python-xyzservices
  (package
    (name "python-xyzservices")
    (version "2022.4.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "xyzservices" version))
        (sha256
          (base32 "1paxv4i0dws85md7csv7pf80jl3xh792mx8rxnsrk61ks3ivbsyg"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest python-mercantile python-requests))
    (home-page "https://github.com/geopandas/xyzservices")
    (synopsis "Source of XYZ tiles providers")
    (description "@code{xyzservices} is a lightweight library providing a
repository of available XYZ services offering raster basemap tiles.  The
repository is provided via Python API and as a compressed JSON file.")
    (license license:bsd-3)))

(define-public jube
  (package
    ;; This is a command-line tool, so no "python-" prefix.
    (name "jube")
    (version "2.2.2")
    (source (origin
              (method url-fetch)
              (uri (string-append
                    "http://apps.fz-juelich.de/jsc/jube/jube2/download.php?version="
                    version))
              (sha256
               (base32
                "0xq4k1q63s1p6swgyp61vahlrd1fqmgbm0gm5kpj8ikwy0yc0nqk"))
              (file-name (string-append "jube-" version ".tar.gz"))))
    (build-system python-build-system)
    (home-page "https://apps.fz-juelich.de/jsc/jube/jube2/docu/index.html")
    (synopsis "Benchmarking environment")
    (description
     "JUBE helps perform and analyze benchmarks in a systematic way.  For each
benchmarked application, benchmark data is stored in a format that allows JUBE
to deduct the desired information.  This data can be parsed by automatic pre-
and post-processing scripts that draw information and store it more densely
for manual interpretation.")
    (license license:gpl3+)))

(define-public python-pyroutelib3
  (package
    (name "python-pyroutelib3")
    (version "1.3.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyroutelib3" version))
       (sha256
        (base32
         "1hpbydpn2alyswiajfbvhzq4c7f36vdmvxy91hgv8l1lb2g2vfrj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dateutil))
    (home-page "https://github.com/MKuranowski/pyroutelib3")
    (synopsis "Library for simple routing on OSM data")
    (description "Library for simple routing on OSM data")
    (license license:gpl3+)))

(define-public python-bibtexparser
  (package
    (name "python-bibtexparser")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bibtexparser" version))
       (sha256
        (base32
         "0zwhfkrzf3n5847dbnfng92k7ak199l9v6x6ax3dgdidfpm6d2fz"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pyparsing))
    (native-inputs
     (list python-future))
    (home-page "https://github.com/sciunto-org/python-bibtexparser")
    (synopsis "Python library to parse BibTeX files")
    (description "BibtexParser is a Python library to parse BibTeX files.")
    (license (list license:bsd-3 license:lgpl3))))

(define-public python-distro
  (package
    (name "python-distro")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "distro" version))
       (sha256
        (base32
         "09441261dd3c8b2gv15vhw1cryzg60lmgpkk07v6hpwwkyhfbxc3"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/nir0s/distro")
    (synopsis
     "OS platform information API")
    (description
     "@code{distro} provides information about the OS distribution it runs on,
such as a reliable machine-readable ID, or version information.

It is the recommended replacement for Python's original
`platform.linux_distribution` function (which will be removed in Python 3.8).
@code{distro} also provides a command-line interface to output the platform
information in various formats.")
    (license license:asl2.0)))

(define-public python-cairosvg
  (package
    (name "python-cairosvg")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "CairoSVG" version))
       (sha256
        (base32 "1ylsisha2cc4w0yydxwhy7idkfw1inl9fsipxsrm7vyby080vi9z"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "pytest"))))))
    (propagated-inputs
     (list python-cairocffi python-cssselect2 python-defusedxml
           python-pillow python-tinycss2))
    (native-inputs
     (list python-pytest-flake8 python-pytest-isort python-pytest-runner))
    (home-page "https://cairosvg.org/")
    (synopsis "SVG to PDF/PS/PNG converter based on Cairo")
    (description "CairoSVG is a SVG converter based on Cairo.  It can export
SVG files to PDF, PostScript and PNG files.  The main part of CairoSVG is a
SVG parser, trying to follow the SVG 1.1 recommendation from the W3C.  Once
parsed, the result is drawn to a Cairo surface that can be exported to
qvarious formats: PDF, PostScript, PNG and even SVG.")
    (license license:lgpl3+)))

(define-public python-pyphen
  (package
    (name "python-pyphen")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pyphen" version))
       (sha256
        (base32 "0a1iwrgs4hzwzz60q4i1813kbzimhm0i4q8grh8vqkxhnkgj36vi"))))
    (build-system python-build-system)
    ;; TODO: Use the Guix system hyphenation packages hyphen-* rather than the
    ;; embedded set provided by upstream - like Debian does.
    (home-page "https://github.com/Kozea/Pyphen")
    (synopsis "Pure Python module to hyphenate text")
    (description "Pyphen is a pure Python module to hyphenate text using
existing Hunspell hyphenation dictionaries.")
    (license (list license:gpl2 license:lgpl2.1 license:mpl1.1))))

(define-public python-intelhex
  (package
    (name "python-intelhex")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "intelhex" version))
       (sha256
        (base32
         "14q04p6qs47ab9w55232ylrdn4wm9rswz36s6x999x0rlxhp6aw9"))))
    (build-system python-build-system)
    (home-page "https://pypi.org/project/IntelHex/")
    (synopsis "Python library for Intel HEX files manipulations")
    (description "The Intel HEX file format is widely used in microprocessors
and microcontrollers area (embedded systems etc.) as the de facto standard for
representation of code to be programmed into microelectronic devices.  This
package provides an intelhex Python library to read, write, create from
scratch and manipulate data from Intel HEX file format.  It also includes
several convenience Python scripts, including \"classic\" hex2bin and bin2hex
converters and more, those based on the library itself.")
    (license license:bsd-3)))

(define-public python-interlap
  (package
    (name "python-interlap")
    (version "0.2.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "interlap" version))
              (sha256
               (base32
                "1jbfh00bkrf0i5psa6n75rlgmqp5389xixa9j29w8rxhah6g7r1i"))))
    (build-system python-build-system)
    (home-page "https://brentp.github.io/interlap")
    (synopsis "Fast, simple interval overlap testing")
    (description "InterLap does fast interval overlap testing with a simple Python data
structure.")
    (license license:expat)))

(define-public python-pykwalify
  (package
    (name "python-pykwalify")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pykwalify" version))
       (sha256
        (base32
         "1cnfzkg1b01f825ikpw2fhjclf9c8akxjfrbd1vc22x1lg2kk2vy"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ;missing dependencies
    (propagated-inputs
     (list python-dateutil python-docopt python-pyyaml))
    (home-page "https://github.com/grokzen/pykwalify")
    (synopsis
     "Python lib/cli for JSON/YAML schema validation")
    (description
     "This package provides a parser, schema validator, and data binding tool
for YAML and JSON.")
    (license license:expat)))

(define-public python-dbusmock
  (package
    (name "python-dbusmock")
    (version "0.25.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-dbusmock" version))
       (sha256
        (base32
         "1nwl0gzzds2g1w1gfxfzlgrkb5hr1rrdyn619ml25c6b1rjyfk3g"))))
    (build-system python-build-system)
    (arguments
     `(#:imported-modules (,@%python-build-system-modules
                           (guix build syscalls))
       #:modules ((guix build python-build-system)
                  (guix build syscalls)
                  (guix build utils)
                  (ice-9 match))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "tests/test_code.py"
               (("/bin/bash") (which "bash")))
             (substitute* "dbusmock/testcase.py"
               (("'dbus-daemon'")
                (string-append "'" (assoc-ref inputs "dbus")
                               "/bin/dbus-daemon'")))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (match (primitive-fork)
                 (0                     ;child process
                  (set-child-subreaper!)
                  ;; Use tini so that signals are properly handled and
                  ;; doubly-forked processes get reaped; otherwise,
                  ;; python-dbusmock would waste time polling for the dbus
                  ;; processes it spawns to be reaped, in vain.
                  (execlp "tini" "--" "pytest" "-vv"))
                 (pid
                  (match (waitpid pid)
                    ((_ . status)
                     (unless (zero? status)
                       (error "`pytest' exited with status"
                              status))))))))))))
    (native-inputs
     (list dbus python-pytest tini which))
    (inputs
     (list dbus))
    (propagated-inputs
     (list python-dbus python-pygobject))
    (home-page "https://github.com/martinpitt/python-dbusmock")
    (synopsis "Python library for mock D-Bus objects")
    (description "python-dbusmock allows for the easy creation of mock objects on
D-Bus.  This is useful for writing tests for software which talks to D-Bus
services such as upower, systemd, logind, gnome-session or others, and it is
hard (or impossible without root privileges) to set the state of the real
services to what you expect in your tests.")
    (license license:lgpl3+)))

(define-public python-jsonplus
  (package
    (name "python-jsonplus")
    (version "0.8.0")
    (home-page "https://github.com/randomir/jsonplus")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonplus" version))
              (sha256
               (base32
                "05yv3dw813zwas9snz124k2hki49y268b3mx0gj9w7v1nrjmglq1"))))
    (build-system python-build-system)
    ;; XXX: No tests on PyPI, and the repository has no tags.
    (arguments '(#:tests? #f))
    (propagated-inputs
     (list python-dateutil python-simplejson python-sortedcontainers))
    (synopsis "Serialize Python types to/from JSON")
    (description
     "This package provides functionality to serialize arbitrary data types
to and from JSON.  Common data types are implemented and it is easy to
register custom encoders and decoders.")
    (license license:expat)))

(define-public python-ujson
  (package
    (name "python-ujson")
    (version "4.0.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ujson" version))
        (sha256
         (base32
          "0k9w0kypy7vlskzzp2vsjswaw8lbqdrplzkbflxki9vqwglsj5f6"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "deps") #t))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'link-to-system-double-conversion
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((d-c (assoc-ref inputs "double-conversion")))
               (substitute* "setup.py"
                 (("./deps/double-conversion/double-conversion\"")
                  (string-append d-c "/include/double-conversion\""))
                 (("-lstdc++" stdc)
                  (string-append "-L" d-c "/lib\","
                                 " \"-ldouble-conversion\","
                                 " \"" stdc)))
               #t)))
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "pytest"))))))
    (native-inputs
     (list double-conversion python-setuptools-scm python-pytest))
    (home-page "https://github.com/ultrajson/ultrajson")
    (synopsis "Ultra fast JSON encoder and decoder for Python")
    (description
     "UltraJSON is an ultra fast JSON encoder and decoder written in pure C with
bindings for Python 3.")
    (license license:bsd-3)))

(define-public python-iocapture
  ;; The latest release is more than a year older than this commit.
  (let ((commit "fdc021c431d0840303908dfc3ca8769db383595c")
        (revision "1"))
    (package
      (name "python-iocapture")
      (version "0.1.2")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/oinume/iocapture")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1mkbhqibxvgwg0p7slr8dfraa3g2s6bsayladhax2jccwj4kcndz"))))
      (build-system python-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (delete 'check)
           (add-after 'install 'check
             (lambda* (#:key inputs outputs #:allow-other-keys)
               (add-installed-pythonpath inputs outputs)
               (invoke "py.test" "-v" "tests")
               #t)))))
      (propagated-inputs
       (list python-flexmock python-pytest python-pytest-cov python-six))
      (home-page "https://github.com/oinume/iocapture")
      (synopsis "Python capturing tool for stdout and stderr")
      (description
       "This package helps you to capture the standard out (stdout) and the
standard error channel (stderr) in your program.")
      (license license:expat))))

(define-public python-anyio
  (package
    (name "python-anyio")
    (version "3.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "anyio" version))
       (sha256
        (base32
         "19m58805wir4i2s45dd5ynwlzb7ky1218isbir53gpqzzgigzbm0"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke
                "pytest" "-vv" "-p" "no:asyncio"
                "-m" "not network"
                "-k"
                (string-append
                 "not test_is_block_device"

                 ;; These fail because of network (or specifically IPv6
                 ;; network) access (see:
                 ;; https://github.com/agronholm/anyio/issues/417).
                 " and not test_accept"
                 " and not test_accept_after_close"
                 " and not test_close_during_receive"
                 " and not test_close_from_other_task"
                 " and not test_concurrent_receive"
                 " and not test_concurrent_send"
                 " and not test_connect_tcp_with_tls"
                 " and not test_connect_tcp_with_tls_cert_check_fail"
                 " and not test_connection_refused"
                 " and not test_extra_attributes"
                 " and not test_getaddrinfo"
                 " and not test_getnameinfo"
                 " and not test_happy_eyeballs"
                 " and not test_iterate"
                 " and not test_receive_after_close"
                 " and not test_receive_timeout"
                 " and not test_reuse_port"
                 " and not test_run_process"
                 " and not test_send_after_close"
                 " and not test_send_after_eof"
                 " and not test_send_after_peer_closed"
                 " and not test_send_eof"
                 " and not test_send_large_buffer"
                 " and not test_send_receive"
                 " and not test_socket_options"
                 " and not test_unretrieved_future_exception_server_crash"))))))))
    (propagated-inputs
     (list python-contextvars
           python-dataclasses
           python-idna
           python-sniffio
           python-typing-extensions))
    (native-inputs
     (list python-contextlib2
           python-coverage
           python-hypothesis
           python-mock
           python-pytest
           python-pytest-mock
           python-setuptools-scm
           python-trio
           python-trustme
           python-uvloop))
    (home-page "https://github.com/agronholm/anyio")
    (synopsis "Compatibility layer for multiple asynchronous event loops")
    (description
     "AnyIO is an asynchronous networking and concurrency library that works
on top of either asyncio or trio.  It implements trio-like structured
concurrency on top of asyncio, and works in harmony with the native SC of trio
itself.")
    (license license:expat)))

(define-public python-argh
  ;; There are 21 commits since the latest release containing important
  ;; improvements.
  (let ((commit "dcd3253f2994400a6a58a700c118c53765bc50a4")
        (revision "1"))
    (package
      (name "python-argh")
      (version (git-version "0.26.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/neithere/argh")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1p5h3dnpbsjmqrvil96s71asc6i3gpinmbrabqmwnrsxprz7r3ns"))))
      (build-system python-build-system)
      (arguments
       '(#:phases
         (modify-phases %standard-phases
           (add-after 'unpack 'patch-tests
             (lambda _
               ;; Fix test failures on Python 3.9.9+.
               ;; Taken via <https://github.com/neithere/argh/issues/148>.
               (substitute* "test/test_integration.py"
                 (("assert run\\(p, '(bar|orig-name|nest bar)', exit=True\\)\
\\.startswith\\('invalid choice'\\)" _ name)
                  (string-append "assert 'invalid choice' in \
run(p, '" name "', exit=True)")))))
           (replace 'check
             (lambda* (#:key tests? #:allow-other-keys)
               (when tests?
                 (invoke "pytest" "-vv")))))))
      (propagated-inputs
       (list python-iocapture python-mock python-pytest python-pytest-cov
             python-pytest-xdist))
      (home-page "https://github.com/neithere/argh/")
      (synopsis "Argparse wrapper with natural syntax")
      (description
       "python-argh is a small library that provides several layers of
abstraction on top of @code{python-argparse}.  The layers can be mixed.  It is
always possible to declare a command with the highest possible (and least
flexible) layer and then tune the behaviour with any of the lower layers
including the native API of @code{python-argparse}.")
      (license license:lgpl3+))))

(define-public python-ppft
  (package
    (name "python-ppft")
    (version "1.6.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ppft" version))
       (sha256
        (base32
         "1z1invkhszc5d2mvgr221v7cszzifcc77mz0pv3wjp6x5q2768cy"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ; there are none
    (propagated-inputs
     (list python-six))
    (home-page "https://pypi.org/project/ppft/")
    (synopsis "Fork of Parallel Python")
    (description
     "This package is a fork of Parallel Python.  The Parallel Python
module (@code{pp}) provides an easy and efficient way to create
parallel-enabled applications for @dfn{symmetric multiprocessing} (SMP)
computers and clusters.  It features cross-platform portability and dynamic
load balancing.")
    (license license:bsd-3)))

(define-public python-pox
  (package
    (name "python-pox")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pox" version))
       (sha256
        (base32
         "0y17ckc2p6i6709s279sjdj4q459mpcc38ymg9zv9y6vl6jf3bq6"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (mkdir-p "/tmp/guix")
             (setenv "SHELL" "bash")
             (setenv "USERNAME" "guix")
             (setenv "HOME" "/tmp/guix") ; must end on USERNAME...
             (invoke "py.test" "-vv")
             #t)))))
    (native-inputs
     (list python-pytest which))
    (home-page "https://pypi.org/project/pox/")
    (synopsis "Python utilities for file system exploration and automated builds")
    (description
     "Pox provides a collection of utilities for navigating and manipulating
file systems.  This module is designed to facilitate some of the low-level
operating system interactions that are useful when exploring a file system on a
remote host.  Pox provides Python equivalents of several shell commands such
as @command{which} and @command{find}.  These commands allow automated
discovery of what has been installed on an operating system, and where the
essential tools are located.")
    (license license:bsd-3)))

(define-public python-pathos
  (package
    (name "python-pathos")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathos" version))
       (sha256
        (base32
         "0in8hxdz7k081ijn6q94gr39ycy7363sx4zysmbwyvd7snqjrbi1"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "./tests/__main__.py"))))))
    (propagated-inputs
     (list python-dill python-multiprocess python-pox python-ppft))
    (native-inputs
     (list python-pytest))
    (home-page "https://pypi.org/project/pathos/")
    (synopsis
     "Parallel graph management and execution in heterogeneous computing")
    (description
     "Python-pathos is a framework for heterogeneous computing.  It provides a
consistent high-level interface for configuring and launching parallel
computations across heterogeneous resources.  Python-pathos provides configurable
launchers for parallel and distributed computing, where each launcher contains
the syntactic logic to configure and launch jobs in an execution environment.")
    (license license:bsd-3)))

(define-public python-flit
  (package
    (name "python-flit")
    (version "3.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flit" version))
       (sha256
        (base32 "04152qj46sqbnlrj7ch9p7svjrrlpzbk0qr39g2yr0s4f5vp6frf"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: PEP 517 manual build copied from python-isort.
          (replace 'build
            (lambda _
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'check
            (lambda* (#:key tests? inputs outputs #:allow-other-keys)
              (when tests?
                (setenv "HOME" "/tmp")
                (setenv "FLIT_NO_NETWORK" "1"))))
          (replace 'install
            (lambda _
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl)))))))
    (propagated-inputs
     (list python-pypa-build
           python-tomli-w
           python-flit-core
           python-docutils
           python-requests))
    (native-inputs
     (list python-responses
           python-pygments-github-lexers
           python-pytest
           python-pytest-cov
           python-sphinx
           python-sphinxcontrib-github-alt
           python-testpath))
    (home-page "https://flit.readthedocs.io/")
    (synopsis "Simple packaging tool for simple packages")
    (description "Flit is a simple way to put Python packages and modules on
PyPI.  Flit packages a single importable module or package at a time, using
the import name as the name on PyPI.  All subpackages and data files within a
package are included automatically.")
    (license license:bsd-3)))

(define-public python-pathtools
  (package
    (name "python-pathtools")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathtools" version))
       (sha256
        (base32
         "1h7iam33vwxk8bvslfj4qlsdprdnwf8bvzhqh3jq5frr391cadbw"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/gorakhargosh/pathtools")
    (synopsis "Path utilities for Python")
    (description "Pattern matching and various utilities for file systems
paths.")
    (license license:expat)))

(define-public python-fastentrypoints
  (package
    (name "python-fastentrypoints")
    (version "0.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fastentrypoints" version))
       (sha256
        (base32
         "02s1j8i2dzbpbwgq2a3fiqwm3cnmhii2qzc0k42l0rdxd4a4ya7z"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/ninjaaron/fast-entry_points")
    (synopsis
     "Makes entry_points specified in setup.py load more quickly")
    (description
     "Using entry_points in your setup.py makes scripts that start really
slowly because it imports pkg_resources.  This package allows such setup
scripts to load entry points more quickly.")
    (license license:bsd-3)))

(define-public python-funcparserlib
  (package
    (name "python-funcparserlib")
    (version "1.0.0")
    (source
      (origin
        ;; Source tarball on PyPi lacks tests.
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/vlasovskikh/funcparserlib")
              (commit version)))
        (file-name (git-file-name name version))
        (sha256
         (base32 "00pswdys5c4hpqpvfcy5zqv30gyjvjvagi12811jizw57hxrm1cs"))))
    (build-system pyproject-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "unittest" "discover" "-v")))))))
    ;; ModuleNotFoundError: No module named 'poetry'
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/vlasovskikh/funcparserlib")
    (synopsis
     "Recursive descent parsing library based on functional combinators")
    (description
     "This package is a recursive descent parsing library for Python based on
functional combinators.  Parser combinators are just higher-order functions
that take parsers as their arguments and return them as result values.")
    (license license:expat)))

(define-public python-speg
  (package
    (name "python-speg")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "speg" version ".zip"))
       (sha256
        (base32 "0w9y4jf4787dzhy6rvhwi0mpl0r8qkqmqmyv2hpwdpv8w53yzjqh"))))
    (arguments
     `(#:tests? #f))                    ;FIXME: tests fail, not sure why
    (native-inputs
     (list unzip))
    (build-system python-build-system)
    (home-page "https://github.com/avakar/speg")
    (synopsis "PEG-based parser interpreter with memoization")
    (description "This package is a PEG-based parser and interpreter with
memoization.")
    (license license:expat)))

(define-public python-cson
  (package
    (name "python-cson")
    (version "0.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cson" version))
       (sha256
        (base32 "00cyvigg4npbph39ghkg77xbxisa6plf75vii24igxfizik0337f"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-speg))
    (home-page "https://github.com/avakar/pycson")
    (synopsis "Parser for Coffeescript Object Notation (CSON)")
    (description "This package is a parser for Coffeescript Object
Notation (CSON).")
    (license license:expat)))

(define-public python-aionotify
  (package
    (name "python-aionotify")
    (version "0.2.0")
    (source
     (origin
       ;; Source tarball on PyPi lacks tests
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rbarrois/aionotify")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1sk9i8czxgsbrswsf1nlb4c82vgnlzi8zrvrxdip92w2z8hqh43y"))
       (patches (search-patches "python-aionotify-0.2.0-py3.8.patch"))))
    (build-system python-build-system)
    (home-page "https://github.com/rbarrois/aionotify")
    (synopsis "Asyncio-powered inotify library")
    (description
     "@code{aionotify} is a simple, asyncio-based inotify library.")
    (license license:bsd-3)))

(define-public python-forbiddenfruit
  (package
    (name "python-forbiddenfruit")
    (version "0.1.3")
    (source
     (origin
       ;; Source tarball on PyPi lacks Makefile that builds and runs tests
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarete/forbiddenfruit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fp2xvdqpi910j9r3q68x38phpxbm700gjdi2m2j5gs91xdnyyh2"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "make" "SKIP_DEPS=1"))))))
    (native-inputs
     (list python-nose python-coverage))
    (home-page "https://github.com/clarete/forbiddenfruit")
    (synopsis "Patch python built-in objects")
    (description "This project allows Python code to extend built-in types.")
    (license (list license:gpl3+ license:expat))))

(define-public python-k5test
  (package
    (name "python-k5test")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "k5test" version))
       (sha256
        (base32
         "1lqp3jgfngyhaxjgj3n230hn90wsylwilh120yjf62h7b1s02mh8"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six
           ;; `which`, `kadmin.local` binaries called inside library
           which mit-krb5))
    (native-inputs (list mit-krb5))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'apply-upstream-fixes
           (lambda* _
             (substitute* "k5test/realm.py"
               ;; Upstream commit f6b302d94dbdce37a1b81cc3faeeac4dc637b0e9.
               (("'kadmin_local'") "'kadmin.local'")
               ;; Upstream commit 3aef84515cf3d1a171c66856c898d0a5cbbd03ea.
               (("\\.stop_daemon") "._stop_daemon")))))))
    (home-page "https://github.com/pythongssapi/k5test")
    (synopsis "Library for setting up self-contained Kerberos 5 environments")
    (description
     "@code{k5test} is a library for setting up self-contained Kerberos 5
environments, and running Python unit tests inside those environments.  It is
based on the file of the same name found alongside the MIT Kerberos 5 unit
tests.")
    (license license:isc)))

(define-public python-gssapi
  (package
    (name "python-gssapi")
    (version "1.6.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gssapi" version))
       (sha256
        (base32
         "1j2idrbrbczykzlb56q1bn0ivc9c0rjjljpk4yz86xn3gxfkpv8n"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-decorator python-six))
    (inputs
     (list mit-krb5))
    ;; for tests
    (native-inputs
     (list python-parameterized python-k5test python-nose))
    (home-page "https://github.com/pythongssapi/python-gssapi")
    (synopsis "Python GSSAPI Wrapper")
    (description
     "Python-GSSAPI provides both low-level and high level wrappers around the
GSSAPI C libraries.  While it focuses on the Kerberos mechanism, it should
also be usable with other GSSAPI mechanisms.")
    (license license:isc)))

(define-public python-check-manifest
  (package
    (name "python-check-manifest")
    (version "0.48")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "check-manifest" version))
        (sha256
         (base32
          "0my6ammldi8mddrbq798qxbl90qr8nlk7gzliq3v7gp7mlfmymrv"))))
    (build-system pyproject-build-system)
    (arguments
     '(;; This test requires setting up a venv which does not work
       ;; properly in the build environment.
       #:test-flags '("-k" "not test_build_sdist_pep517_isolated")
       #:phases
       (modify-phases %standard-phases
         ;; Tests use git submodule commands over the file transport, which
         ;; has been disabled in git, see CVE-2022-39253. Enable these
         ;; commands to allow checks to succeed.
         (add-before 'check 'allow-git-submodule-add
           (lambda _
             (setenv "HOME" "/tmp")
             (invoke "git" "config" "--global"
                     "protocol.file.allow" "always"))))))
    (native-inputs
     (list git-minimal/fixed python-pytest))
    (propagated-inputs
     (list python-pypa-build python-setuptools python-tomli))
    (home-page "https://github.com/mgedmin/check-manifest")
    (synopsis "Check MANIFEST.in in a Python source package for completeness")
    (description "Python package can include a MANIFEST.in file to help with
sending package files to the Python Package Index.  This package checks that
file to ensure it completely and accurately describes your project.")
    (license license:expat)))

(define-public python-android-stringslib
  (package
    (name "python-android-stringslib")
    (version "0.1.2")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://framagit.org/tyreunom/python-android-strings-lib")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0gij55qzzq1h83kfpvhai1vf78kkhyvxa6l17m2nl24454lhfin4"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (home-page "https://framagit.org/tyreunom/python-android-strings-lib")
    (synopsis "Android strings.xml support")
    (description "Android Strings Lib provides support for android's strings.xml
files.  These files are used to translate strings in android apps.")
    (license license:expat)))

(define-public python-watchdog
  (package
    (name "python-watchdog")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "watchdog" version))
       (sha256
        (base32 "1rx2nyl0cyj0v4ja795cl3gi26577c5wg48syr3byz3ndkgpavm3"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest" "-k"
                       ;; This test failed.
                       "not test_kill_auto_restart")))))))
    (propagated-inputs
     (list python-pathtools python-pyyaml))
    (native-inputs
     (list python-pytest-cov python-pytest-timeout))
    (home-page "https://github.com/gorakhargosh/watchdog")
    (synopsis "File system events monitoring")
    (description "This package provides a way to monitor file system events
such as a file modification and trigger an action.  This is similar to inotify,
but portable.")
    (license license:asl2.0)))

(define-public python-watchgod
  (package
    (name "python-watchgod")
    (version "0.7")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/samuelcolvin/watchgod")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1w2xsidwp9n4giqhja0bzw7rwrh01db0kdxf2n54mv3dkx545jpq"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest"  "-vv"
                       "-o" "asyncio_mode=auto")))))))
    (native-inputs
     (list python-coverage
           python-pygments
           python-pytest
           python-pytest-asyncio
           python-pytest-cov
           python-pytest-mock
           python-pytest-sugar
           python-pytest-toolbox))
    (home-page "https://github.com/samuelcolvin/watchgod")
    (synopsis "Simple, modern file watching and code reload in Python")
    (description
     "Simple, modern file watching and code reload in Python inspired by
@code{watchdog}.  Among the differences are a unified approach for each
operating systems and an elegant approach to concurrency using threading.")
    (license license:expat)))

(define-public python-wget
  (package
    (name "python-wget")
    (version "3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wget" version ".zip"))
       (sha256
        (base32
         "0qb0y7ipby42m4m7h0ipazpdyc3bn9xi46lvifcwwl5albn31rim"))))
    (build-system python-build-system)
    (native-inputs (list unzip))
    (home-page "https://bitbucket.org/techtonik/python-wget/")
    (synopsis "Pure Python download utility")
    (description "The python-wget library provides an API to download files
with features similar to the @command{wget} utility.")
    (license license:unlicense)))

(define-public offlate
  (package
    (name "offlate")
    (version "0.6.1")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://framagit.org/tyreunom/offlate")
               (commit version)))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "1sx5cv8pamyw1m089b6x8ykaxdkx26jk9cblhbzlf0m3ckz52jik"))))
    (build-system python-build-system)
    (arguments
     ;; No tests
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-before 'build 'generate-fonts
           (lambda _
             (invoke "make" "fonts")))
         (add-before 'build 'generate-translations
           (lambda _
             (invoke "make" "update-langs"))))))
    (propagated-inputs
      (list python-android-stringslib
            python-dateutil
            python-gitlab
            python-lxml
            python-polib
            python-pycountry
            python-pyenchant
            python-pygit2
            python-pygithub
            python-pyqt
            python-requests
            python-ruamel.yaml
            python-translate-toolkit
            python-translation-finder
            python-watchdog))
    (native-inputs
     (list qttools-5 fontforge))
    (home-page "https://framagit.org/tyreunom/offlate")
    (synopsis "Offline translation interface for online translation tools")
    (description "Offlate offers a unified interface for different translation
file formats, as well as many different online translation platforms.  You can
use it to get work from online platforms, specialized such as the Translation
Project, or not such a gitlab instance when your upstream doesn't use any
dedicated platform.  The tool proposes a unified interface for any format and
an upload option to send your work back to the platform.")
    (license license:gpl3+)))

(define-public python-titlecase
  (package
    (name "python-titlecase")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "titlecase" version))
       (sha256
        (base32
         "0486i99wf8ssa7sgn81fn6fv6i4rhhq6n751bc740b3hzfbpmpl4"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/ppannuto/python-titlecase")
    (synopsis "Capitalize strings similar to book titles")
    (description
     "Python-Titlecase is a Python port of John Gruber's titlecase.pl.
It capitalizes (predominantly English) strings in a way that is similar to
book titles, using the New York Times Manual of Style to leave certain words
lowercase.")
    (license license:expat)))

(define-public python-pypng
  (package
    (name "python-pypng")
    (version "0.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pypng" version))
       (sha256
        (base32 "02qpa22ls41vwsrzw9r9qhj1nhq05p03hb5473pay6y980s86chh"))))
    (build-system python-build-system)
    (home-page "https://github.com/drj11/pypng")
    (synopsis "Pure Python PNG image encoder/decoder")
    (description
     "The PyPNG module implements support for PNG images.  It reads and writes
PNG files with all allowable bit depths (1/2/4/8/16/24/32/48/64 bits per
pixel) and colour combinations: greyscale (1/2/4/8/16 bit); RGB, RGBA,
LA (greyscale with alpha) with 8/16 bits per channel; colour mapped
images (1/2/4/8 bit).  Adam7 interlacing is supported for reading and writing.
A number of optional chunks can be specified (when writing) and
understood (when reading): tRNS, bKGD, gAMA.

PyPNG is not a high level toolkit for image processing (like PIL) and does not
aim at being a replacement or competitor.  Its strength lies in fine-grained
extensive support of PNG features.  It can also read and write Netpbm PAM
files, with a focus on its use as an intermediate format for implementing
custom PNG processing.")
    (license license:expat)))

(define-public python-fuzzywuzzy
  (package
    (name "python-fuzzywuzzy")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fuzzywuzzy" version))
       (sha256
        (base32
         "1s00zn75y2dkxgnbw8kl8dw4p1mc77cv78fwfa4yb0274s96w0a5"))))
    (build-system python-build-system)
    (native-inputs
     (list python-hypothesis python-pycodestyle python-pytest))
    (propagated-inputs
     (list python-levenshtein))
    (home-page "https://github.com/seatgeek/fuzzywuzzy")
    (synopsis "Fuzzy string matching in Python")
    (description "Approximate string matching using
@emph{Levenshtein Distance} to calculate the differences between
sequences.")
    (license license:gpl2)))

(define-public python-block-tracing
  (package
    (name "python-block-tracing")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "block_tracing" version))
        (sha256
         (base32
          "0s2y729qr5rs7n506qfh8cssk8m2bi6k2y5vbrh2z3raf2d01alz"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))  ; no tests
    (home-page "https://github.com/rianhunter/block_tracing")
    (synopsis "Protect process memory")
    (description
     "@code{block_tracing} is a tiny Python library that can be used to
prevent debuggers and other applications from inspecting the memory within
your process.")
    (license license:expat)))

(define-public python-gcovr
  (package
    (name "python-gcovr")
    (version "4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gcovr" version))
       (sha256
        (base32
          "0gyady7x3v3l9fm1zan0idaggqqcm31y7g5vxk7h05p5h7f39bjs"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-lxml python-jinja2))
    (home-page "https://gcovr.com/")
    (synopsis "Utility for generating code coverage results")
    (description
      "Gcovr provides a utility for managing the use of the GNU gcov
utility and generating summarized code coverage results.  It is inspired
by the Python coverage.py package, which provides a similar utility for
Python.")
    (license license:bsd-3)))

(define-public python-owslib
  (package
    (name "python-owslib")
    (version "0.19.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "OWSLib" version))
       (sha256
        (base32 "0v8vg0naa9rywvd31cpq65ljbdclpsrx09788v4xj7lg10np8nk0"))))
    (build-system python-build-system)
    (arguments
     ;; TODO: package dependencies required for tests.
     '(#:tests? #f
       #:phases (modify-phases %standard-phases
                  (delete 'sanity-check))))
    (synopsis "Interface for Open Geospatial Consortium web service")
    (description
     "OWSLib is a Python package for client programming with Open Geospatial
Consortium (OGC) web service (hence OWS) interface standards, and their related
content models.")
    (home-page "https://geopython.github.io/OWSLib/")
    (license license:bsd-3)))

(define-public python-docusign-esign
  (package
    (name "python-docusign-esign")
    (version "3.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docusign_esign" version))
              (sha256
               (base32
                "01f3h03vc97syjlmqyl7xa5j90pzgmwpspc5a0gra9saynnbkx37"))))
    (build-system python-build-system)
    ;; Testing requires undocumented setup changes, and so testing is disabled here.
    (arguments `(#:tests? #f))
    (propagated-inputs
      (list python-certifi
            python-six
            python-dateutil
            python-urllib3
            python-pyjwt
            python-cryptography
            python-nose))
    (synopsis "DocuSign Python Client")
    (description "The Official DocuSign Python Client Library used to interact
 with the eSign REST API.  Send, sign, and approve documents using this client.")
    (home-page "https://www.docusign.com/devcenter")
    (license license:expat)))

(define-public python-xattr
  (package
    (name "python-xattr")
    (version "0.9.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xattr" version))
       (sha256
        (base32
         "0ipkfblyvp5hylahjkw9zss1ii9xnwjypr3b3ncv989szcg7xjq9"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-cffi))
    (home-page "https://github.com/xattr/xattr")
    (synopsis
     "Python wrapper for extended file system attributes")
    (description "This package provides a Python wrapper for using extended
file system attributes.  Extended attributes extend the basic attributes of files
and directories in the file system.  They are stored as name:data pairs
associated with file system objects (files, directories, symlinks, etc).")
    (license license:expat)))

(define-public python-json-logger
  (package
    (name "python-json-logger")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-json-logger" version))
       (sha256
        (base32
         "10g2ya6nsvn5vxzvq2wb8q4d43i3d7756i5rxyjna6d0y9i138xp"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/madzak/python-json-logger")
    (synopsis "JSON log formatter in Python")
    (description "This library allows standard Python logging to output log data
as JSON objects.  With JSON we can make our logs more readable by machines and
we can stop writing custom parsers for syslog-type records.")
    (license license:bsd-3)))

(define-public python-daiquiri
  (package
    (name "python-daiquiri")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "daiquiri" version))
       (sha256
        (base32
         "1qmank3c217ddiig3xr8ps0mqaydcp0q5a62in9a9g4zf72zjnqd"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-json-logger))
    (native-inputs
     (list python-mock python-pytest python-setuptools-scm python-six))
    (home-page "https://github.com/jd/daiquiri")
    (synopsis
     "Library to configure Python logging easily")
    (description "The daiquiri library provides an easy way to configure
logging in Python.  It also provides some custom formatters and handlers.")
    (license license:asl2.0)))

(define-public python-pifpaf
  (package
    (name "python-pifpaf")
    (version "3.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pifpaf" version))
       (sha256
        (base32
         "19bdmxldc2m570isl7hbqgbb20si4sin7pi5fw8sv9py8dyv2s4n"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "setup.py" "testr" "--slowest"
                     "--testr-args=until-failure"))))))
    (propagated-inputs
     (list python-click
           python-daiquiri
           python-fixtures
           python-jinja2
           python-pbr
           python-psutil
           python-xattr))
    (native-inputs
     (list python-mock python-os-testr python-requests
           python-testrepository python-testtools))
    (home-page "https://github.com/jd/pifpaf")
    (synopsis "Tools and fixtures to manage daemons for testing in Python")
    (description "Pifpaf is a suite of fixtures and a command-line tool that
starts and stops daemons for a quick throw-away usage.  This is typically
useful when needing these daemons to run integration testing.  It originally
evolved from its precursor @code{overtest}.")
    (license license:asl2.0)))

(define-public python-pytest-check-links
  (package
    (name "python-pytest-check-links")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       ;; URI uses underscores
       (uri (pypi-uri "pytest_check_links" version))
       (sha256
        (base32
         "12x3wmrdzm6wgk0vz02hb769h68nr49q47w5q1pj95pc89hsa34v"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-docutils
           python-html5lib
           python-nbconvert
           python-nbformat
           python-pytest
           python-six))
    (native-inputs
     (list python-pbr-minimal))
    (home-page "https://github.com/minrk/pytest-check-links")
    (synopsis "Check links in files")
    (description "This package provides a pytest plugin that checks URLs for
HTML-containing files.")
    (license license:bsd-3)))

(define-public python-json5
  (package
    (name "python-json5")
    (version "0.8.5")
    (source
     (origin
       ;; sample.json5 is missing from PyPi source tarball
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dpranke/pyjson5")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nyngj18jlkgvm1177lc3cj47wm4yh3dqigygvcvw7xkyryafsqn"))))
    (build-system python-build-system)
    (home-page "https://github.com/dpranke/pyjson5")
    (synopsis
     "Python implementation of the JSON5 data format")
    (description
     "JSON5 extends the JSON data interchange format to make it slightly more
usable as a configuration language.  This Python package implements parsing and
dumping of JSON5 data structures.")
    (license license:asl2.0)))

(define-public python-freetype-py
  (package
    (name "python-freetype-py")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "freetype-py" version ".zip"))
       (sha256
        (base32 "1l55wzy21jmdayjna29ahzxrf2fp68580978rs6kap1a4zilrdpr"))))
    (build-system python-build-system)
    (native-inputs
     (list python-setuptools-scm
           unzip))
    (inputs (list freetype))
    (arguments
     `(#:phases
       ;; Note: the pypi archive does not contain tests, but running the check
       ;; phase will at least test whether the module loads correctly.
       (modify-phases %standard-phases
         (add-before 'build 'embed-library-reference
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "freetype/raw.py"
               (("^(filename = ).*" _ >)
                (string-append > "\"" (search-input-file inputs "/lib/libfreetype.so")
                               "\"\n"))))))))
    (home-page "https://github.com/rougier/freetype-py")
    (synopsis "Freetype python bindings")
    (description "Freetype Python provides bindings for the FreeType
library.  Only the high-level API is bound.")
    (license license:bsd-3)))

(define-public python-frozendict
  (package
    (name "python-frozendict")
    (version "2.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "frozendict" version))
       (sha256
        (base32 "0y3zn57i1q5192f7l4w2z2zsy3rrx50g563msaq954r58s1v3d0m"))))
    (build-system python-build-system)
    (home-page "https://github.com/Marco-Sulla/python-frozendict")
    (synopsis "Simple immutable mapping for Python")
    (description
     "@dfn{frozendict} is an immutable wrapper around dictionaries that
implements the complete mapping interface.  It can be used as a drop-in
replacement for dictionaries where immutability is desired.")
    (license license:expat)))

(define-public python-unpaddedbase64
  (package
    (name "python-unpaddedbase64")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "unpaddedbase64" version))
       (sha256
        (base32 "01ghlmw63fgslwj8j74vkpf1kqvr7a4agm6nyn89vqwx106ccwvj"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs tests? #:allow-other-keys)
             (when tests?
               (copy-recursively (string-append
                                  (assoc-ref inputs "tests") "/tests")
                                 "tests")
               (invoke "python" "-m" "pytest" "-vv")))))))
    (native-inputs
     `(("python-pytest" ,python-pytest)
       ("tests"
        ;; The release on pypi comes without tests.  We can't build from this
        ;; checkout, though, because installation requires an invocation of
        ;; poetry.
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/matrix-org/python-unpaddedbase64")
                 (commit (string-append "v" version))))
           (file-name (git-file-name name version))
           (sha256
            (base32
             "1n6har8pxv0mqb96lanzihp1xf76aa17jw3977drb1fgz947pnmz"))))))
    (home-page "https://github.com/matrix-org/python-unpaddedbase64")
    (synopsis "Encode and decode Base64 without “=” padding")
    (description
     "RFC 4648 specifies that Base64 should be padded to a multiple of 4 bytes
using “=” characters.  However this conveys no benefit so many protocols
choose to use Base64 without the “=” padding.")
    (license license:asl2.0)))

(define-public python-py-cpuinfo
  ;; This is the first commit where riscv64-linux support is available.
  ;; We can move back to pypi releases with the next release.
  (let ((commit "4d6987e5c30f2ebacb20781892c01329042cce60")
        (revision "1"))
    (package
      (name "python-py-cpuinfo")
      (version (git-version "8.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/workhorsy/py-cpuinfo")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0h5wi1bfcqqr1x3j1pa7dmkx7siprsyksbsy80fl2sdrrgpji0b0"))))
      (build-system python-build-system)
      (home-page "https://github.com/workhorsy/py-cpuinfo")
      (synopsis "Get CPU info with Python")
      (description
       "This Python module returns the CPU info by using the best sources of
information for your operating system.")
      (license license:expat))))

(define-public python-canonicaljson
  (package
    (name "python-canonicaljson")
    (version "1.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "canonicaljson" version))
       (sha256
        (base32 "0j5lq191jkd483q6xzc16c9fahxf15lrv03mvah9ka3lq85pcnfa"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'loosen-requirements
           (lambda _
             ;; Permit newer versions of setuptools_scm
             (substitute* "pyproject.toml"
               ((">= 2.0.0, <3") ">= 2.0.0"))))
          (replace 'build
            (lambda _
              ;; ZIP does not support timestamps before 1980.
              (setenv "SOURCE_DATE_EPOCH" "315532800")
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest"))))
          (replace 'install
            (lambda _
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl)))))))
    (native-inputs
     (list python-pypa-build python-pytest python-setuptools python-setuptools-scm))
    (propagated-inputs
     (list python-six python-frozendict python-simplejson))
    (home-page "https://github.com/matrix-org/python-canonicaljson")
    (synopsis "Canonical JSON")
    (description
     "Deterministically encode JSON.

@itemize
@item Encodes objects and arrays as RFC 7159 JSON.
@item Sorts object keys so that you get the same result each time.
@item Has no insignificant whitespace to make the output as small as possible.
@item Escapes only the characters that must be escaped, U+0000 to
 U+0019 / U+0022 / U+0056, to keep the output as small as possible.
@item Uses the shortest escape sequence for each escaped character.
@item Encodes the JSON as UTF-8.
@item Can encode frozendict immutable dictionaries.
@end itemize")
    (license license:asl2.0)))

(define-public python-signedjson
  (package
    (name "python-signedjson")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "signedjson" version))
       (sha256
        (base32 "0280f8zyycsmd7iy65bs438flm7m8ffs1kcxfbvhi8hbazkqc19m"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-canonicaljson python-importlib-metadata python-pynacl
           python-typing-extensions python-unpaddedbase64))
    (native-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/matrix-org/python-signedjson")
    (synopsis "Sign JSON objects with ED25519 signatures")
    (description
     "Sign JSON objects with ED25519 signatures.

@itemize
@item More than one entity can sign the same object.
@item Each entity can sign the object with more than one key making it easier to
rotate keys
@item ED25519 can be replaced with a different algorithm.
@item Unprotected data can be added to the object under the @dfn{\"unsigned\"}
key.
@end itemize")
    (license license:asl2.0)))

(define-public python-daemonize
  (package
    (name "python-daemonize")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "daemonize" version))
       (sha256
        (base32 "1hwbl3gf9fdds9sc14zgjyjisjvxidrvqc11xlbb0b6jz17nw0nx"))))
    (build-system python-build-system)
    (home-page "https://github.com/thesharp/daemonize")
    (synopsis "Library for writing system daemons in Python")
    (description "Daemonize is a library for writing system daemons in Python.")
    (license license:expat)))

(define-public python-pymacaroons
  (package
    (name "python-pymacaroons")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymacaroons" version))
       (sha256
        (base32 "1f0357a6g1h96sk6wy030xmc1p4rd80a999qvxd28v7nlm1blsqy"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-pynacl))
    (home-page "https://github.com/ecordell/pymacaroons")
    (synopsis "Python Macaroon Library")
    (description
     "Macaroons, like cookies, are a form of bearer credential.  Unlike opaque
tokens, macaroons embed caveats that define specific authorization
requirements for the target service, the service that issued the root macaroon
and which is capable of verifying the integrity of macaroons it receives.

Macaroons allow for delegation and attenuation of authorization.  They are
simple and fast to verify, and decouple authorization policy from the
enforcement of that policy.")
    (license license:expat)))

(define-public python-ldap3
  (package
    (name "python-ldap3")
    (version "2.7")
    (home-page "https://github.com/cannatag/ldap3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page)
                           (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xw9fkqld21xsvdpaqir8ccc2l805xnn9gxahsnl70xzp3mwl0xv"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f ;TODO: Tests need a real LDAP server to run
       #:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "nosetests" "-s" "test"))
                      #t)))))
    (native-inputs
     (list python-nose))
    (propagated-inputs
     (list python-gssapi python-pyasn1))
    (synopsis "Python LDAP client")
    (description
     "LDAP3 is a strictly RFC 4510 conforming LDAP V3 pure Python client
library.")
    (license license:lgpl3+)))

(define-public python-boltons
  (package
    (name "python-boltons")
    (version "20.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "boltons" version))
       (sha256
        (base32
         "0lrr40qqj3ch8xarvyzbnbjs79pz5aywklllq53l347h1b8xnkg4"))))
    (build-system python-build-system)
    (home-page "https://github.com/mahmoud/boltons")
    (synopsis "Extensions to the Python standard library")
    (description
     "Boltons is a set of over 230 pure-Python utilities in the same spirit
as — and yet conspicuously missing from — the standard library, including:

@itemize
@item Atomic file saving, bolted on with fileutils
@item A highly-optimized OrderedMultiDict, in dictutils
@item Two types of PriorityQueue, in queueutils
@item Chunked and windowed iteration, in iterutils
@item Recursive data structure iteration and merging, with iterutils.remap
@item Exponential backoff functionality, including jitter, through
iterutils.backoff
@item A full-featured TracebackInfo type, for representing stack traces, in
tbutils
@end itemize")
    (license license:bsd-3)))

(define-public python-eliot
  (package
    (name "python-eliot")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "eliot" version))
       (sha256
        (base32 "1xzzhsjrrw430dc84vamf683bwp9i0nr86xf2iav6yla615ijq2p"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-journald-support
           (lambda _
             (for-each delete-file
                     '("eliot/tests/test_journald.py"
                       "eliot/journald.py"))
             #t))
         (add-after 'remove-journald-support 'remove-eliot-prettyprint-tests
           ;; remove command-line tool's tests. TODO eliot-prettyprint should
           ;; be installed and these tests should pass.
           (lambda _
             (delete-file "eliot/tests/test_prettyprint.py")
             #t))
         (add-after 'remove-eliot-prettyprint-tests 'remove-failing-tests
           (lambda _
             ;; These tests started to fail after updating python-pandas to
             ;; 1.3.3 and python-dask to 2021.9.1.
             (substitute* "eliot/tests/test_validation.py"
               (("test_omitLoggerFromActionType")
                "_test_omitLoggerFromActionType")
               (("test_logCallsDefaultLoggerWrite")
                "_test_logCallsDefaultLoggerWrite"))
             #t)))))
    (propagated-inputs
     (list python-boltons python-pyrsistent python-six
           python-zope-interface))
    (native-inputs
     (list python-black
           python-coverage
           python-dask
           python-flake8
           python-hypothesis
           python-pytest
           python-setuptools
           python-sphinx
           python-sphinx-rtd-theme
           python-testtools
           python-twine
           python-twisted))
    (home-page "https://github.com/itamarst/eliot/")
    (synopsis "Eliot: the logging system that tells you why it happened")
    (description
     "@dfn{eliot} is a Python logging system that outputs causal chains of
actions: actions can spawn other actions, and eventually they either succeed
or fail. The resulting logs tell you the story of what your software did: what
happened, and what caused it.")
    (license license:asl2.0)))

(define-public python-pem
  (package
    (name "python-pem")
    (version "20.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pem" version))
       (sha256
        (base32
         "1xh88ss279fprxnzd10dczmqwjhppbyvljm33zrg2mgybwd66qr7"))))
    (build-system python-build-system)
    (native-inputs
     (list python-certifi
           python-coverage
           python-pretend
           python-pyopenssl
           python-pytest
           python-sphinx
           python-twisted))
    (home-page "https://pem.readthedocs.io/")
    (synopsis "Easy PEM file parsing in Python")
    (description
     "This package provides a Python module for parsing and splitting PEM files.")
    (license license:expat)))

(define-public python-txsni
  ;; We need a few commits on top of 0.1.9 for compatibility with newer
  ;; Python and OpenSSL.
  (let ((commit "5014c141a7acef63e20fcf6c36fa07f0cd754ce1")
        (revision "0"))
    (package
      (name "python-txsni")
      (version (git-version "0.1.9" revision commit))
      (home-page "https://github.com/glyph/txsni")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference (url home-page) (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0imfxx4yjj1lbq0n5ad45al3wvv4qv96sivnc1r51i66mxi658z8"))))
      (build-system python-build-system)
      (propagated-inputs
       (list python-pyopenssl python-service-identity python-twisted))
      (synopsis "Run TLS servers with Twisted")
      (description
       "This package provides an easy-to-use SNI endpoint for use
with the Twisted web framework.")
      (license license:expat))))

(define-public python-txacme
  (package
    (name "python-txacme")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "txacme" version))
       (sha256
        (base32 "1cplx4llq7i508w6fgwjdv9di7rsz9k9irfmzdfbiz6q6a0ykf1d"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-acme
           python-attrs
           python-eliot
           python-josepy
           python-pem
           python-treq
           python-twisted
           python-txsni))
    (native-inputs
     (list python-fixtures
           python-hypothesis
           python-mock
           python-service-identity
           python-testrepository
           python-testscenarios
           python-testtools))
    (home-page "https://github.com/twisted/txacme")
    (synopsis "Twisted implexmentation of the ACME protocol")
    (description
     "ACME is Automatic Certificate Management Environment, a protocol that
allows clients and certificate authorities to automate verification and
certificate issuance.  The ACME protocol is used by the free Let's Encrypt
Certificate Authority.

txacme is an implementation of the protocol for Twisted, the event-driven
networking engine for Python.")
    (license license:expat)))

(define-public python-pysaml2
  (package
    (name "python-pysaml2")
    (version "6.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pysaml2" version))
       (sha256
        (base32
         "1xk2x0slz1f8cqv7vn77qx99xfd1mshhswiwrljk9m72w2m9iivd"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-cryptography
           python-dateutil
           python-defusedxml
           python-importlib-resources
           python-pyopenssl
           python-pytz
           python-requests
           python-six
           python-xmlschema))
    (home-page "https://idpy.org")
    (synopsis "Python implementation of SAML Version 2 Standard")
    (description
     "PySAML2 is a pure python implementation of SAML Version 2 Standard.
It contains all necessary pieces for building a SAML2 service provider or
an identity provider.  The distribution contains examples of both.

This package was originally written to work in a WSGI environment, but
there are extensions that allow you to use it with other frameworks.")
    (license license:asl2.0)))

(define-public python-click-plugins
  (package
    (name "python-click-plugins")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click-plugins" version))
       (sha256
        (base32 "0jr6bxj67vg988vkm6nz8jj98v9lg46bn49lkhak3n598jbrkas6"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-click))
    (synopsis "Extension for Click to register external CLI commands")
    (description "This package provides n extension module for Click to
register external CLI commands via setuptools entry-points.")
    (home-page "https://github.com/click-contrib/click-plugins")
    (license license:bsd-3)))

(define-public python-diceware
  (package
    (name "python-diceware")
    (version "0.9.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "diceware" version))
       (sha256
        (base32
         "0klb0ysybzlh2wihvir82hgq62v0jjmlcqklwajyms7c0p529yby"))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage python-pytest python-pytest-runner))
    (home-page "https://github.com/ulif/diceware/")
    (synopsis "Generates memorable passphrases")
    (description "This package generates passphrases by concatenating words
randomly picked from wordlists.  It supports several sources of
randomness (including real life dice) and different wordlists (including
cryptographically signed ones).")
    (license license:gpl3+)))

(define-public python-dictdiffer
  (package
    (name "python-dictdiffer")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dictdiffer" version))
              (sha256
               (base32
                "0y3mk74qm2q9hsm37892i1wzn8bbdrvbs4nmnvqwq4z6pxgwzfhp"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: The PyPI tarball lacks tests and the git repository
     ;; fails to determine version.
     '(#:tests? #f))
    (native-inputs
     (list python-pytest-runner python-setuptools-scm))
    (home-page "https://github.com/inveniosoftware/dictdiffer")
    (synopsis "Diff and patch Python dictionary objects")
    (description
     "Dictdiffer is a Python module that helps you to diff and patch
dictionaries.")
    (license license:expat)))

(define-public python-dictpath
  (package
    (name "python-dictpath")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dictpath" version))
       (sha256
        (base32 "1n4hq4wbgaw59bbb16nhkgg5wk8sl4iw940vjrgx4xmifqxxw73m"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest python-pytest-cov python-pytest-flake8))
    (home-page "https://github.com/p1c2u/pathable")
    (synopsis "Object-oriented path library for Python")
    (description "This object-oriented dictionary path Python library enables
traversing resources like paths or accessing resources on demand with separate
accessor layer.")
    (license license:asl2.0)))

(define-public pyzo
  (package
    (name "pyzo")
    (version "4.12.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pyzo/pyzo.git")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0v6rgp52bf9za2spxx9c1yc6wmskvlsj81iw0gipjy7y8vpypgn2"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-home-directory
           (lambda _
             ;; Tests fail with "Permission denied: '/homeless-shelter'".
             (setenv "HOME" "/tmp"))))
       ;; Tests fail with "Uncaught Python exception: python: undefined
       ;; symbol: objc_getClass".
       #:tests? #f))
    (propagated-inputs
     (list python-pyqt))
    (home-page "https://pyzo.org")
    (synopsis
     "Python IDE for scientific computing")
    (description
     "Pyzo is a Python IDE focused on interactivity and introspection,
which makes it very suitable for scientific computing.  Its practical
design is aimed at simplicity and efficiency.

It consists of two main components, the editor and the shell, and uses
a set of pluggable tools to help the programmer in various ways.  Some
example tools are source structure, project manager, interactive help,
workspace...")
    (license license:bsd-2)))

(define-public python-osc
  (package
    (name "python-osc")
    (version "1.7.4")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "python-osc" version))
        (sha256
          (base32
            "0cnh0z5lnng7fh48nmfaqqn8j25k13gkd4rhxd3m6sjqiix9s3vn"))))
    (build-system python-build-system)
    (home-page "https://github.com/attwad/python-osc")
    (synopsis "Open Sound Control server and client implementations")
    (description
      "@code{python-osc} is a pure Python library with no external
dependencies.  It implements the @uref{http://opensoundcontrol.org/spec-1_0,
Open Sound Control 1.0} specification.")
    (license license:unlicense)))

(define-public python-voluptuous
  (package
    (name "python-voluptuous")
    (version "0.11.7")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "voluptuous" version))
        (sha256
          (base32
            "0mplkcpb5d8wjf8vk195fys4y6a3wbibiyf708imw33lphfk9g1a"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/alecthomas/voluptuous")
    (synopsis "Python data validation library")
    (description
     "Voluptuous is a Python data validation library.  It is primarily
intended for validating data coming into Python as JSON, YAML, etc.")
    (license license:bsd-3)))

(define-public python-cmd2
  (package
    (name "python-cmd2")
    (version "2.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cmd2" version))
       (sha256
        (base32
         "0h1naik558qh48gx2iyy0a0khvw5fz0in69y84mbrhsm9nq7w3bm"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (if tests?
                 (invoke "pytest" "-vv" "-k"
                         ;; These tests fail because no EDITOR is in PATH.
                         "not test_find_editor_not_specified \
and not test_transcript")
                 (format #t "test suite not run~%")))))))
    (propagated-inputs
     (list python-attrs python-colorama python-pyperclip python-wcwidth))
    (native-inputs
     (list python-invoke
           python-mock
           python-pytest
           python-pytest-cov
           python-pytest-mock
           python-setuptools-scm))
    (home-page "https://github.com/python-cmd2/cmd2")
    (synopsis "Tool for building interactive command line applications")
    (description
     "Cmd2 is a tool for building interactive command line applications in
Python.  Its goal is to make it quick and easy for developers to build
feature-rich and user-friendly interactive command line applications.  It
provides a simple API which is an extension of Python's built-in @code{cmd}
module.  @code{cmd2} provides a wealth of features on top of @code{cmd} to
make your life easier and eliminates much of the boilerplate code which would
be necessary when using @code{cmd}.")
    (license license:expat)))

(define-public python-pytidylib
  (package
    (name "python-pytidylib")
    (version "0.3.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pytidylib" version))
              (sha256
               (base32
                "1wqa9dv5d7swka14rnky862hc7dgk2g3dhlrz57hdn3hb7bwic92"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'qualify-libtidy
