/*!
 * \file
 *
 * \brief Source file for TestClass methods.
 *
 * Do not edit this file, it is automatically generated. Please look at generator.c.
 *
 * \author Marcelo Roberto Jimenez
 */
#include "config.h"

#include <stdlib.h> /* for calloc(), free() */
#include <string.h> /* for strlen(), strdup() */


#include "TestClass.h"

struct s_TestClass
{
	UpnpListHead m_TheList;
	int m_TheInteger;
	unsigned long m_TheUnsignedLong;
	char * m_TheCharPointer;
	struct TheStruct m_TheBuffer;
	UpnpActionComplete *m_TheActionComplete;
	UpnpString *m_TheString;
	DOMString m_TheDomString;
};

TestClass *TestClass_new()
{
	struct s_TestClass *p = calloc(1, sizeof (struct s_TestClass));

	if (!p) return 0;

	UpnpListInit(&p->m_TheList);
	/*p->m_TheInteger = 0;*/
	/*p->m_TheUnsignedLong = 0;*/
	/*p->m_TheCharPointer = 0;*/
	/* memset(&p->m_TheBuffer, 0, sizeof (struct TheStruct)); */
	p->m_TheActionComplete = UpnpActionComplete_new();
	p->m_TheString = UpnpString_new();
	/*p->m_TheDomString = 0;*/

	return (TestClass *)p;
}

void TestClass_delete(TestClass *q)
{
	struct s_TestClass *p = (struct s_TestClass *)q;

	if (!p) return;

	ixmlFreeDOMString(p->m_TheDomString);
	p->m_TheDomString = 0;
	UpnpString_delete(p->m_TheString);
	p->m_TheString = 0;
	UpnpActionComplete_delete(p->m_TheActionComplete);
	p->m_TheActionComplete = 0;
	memset(&p->m_TheBuffer, 0, sizeof (struct TheStruct));
	p->m_TheCharPointer = 0;
	p->m_TheUnsignedLong = 0;
	p->m_TheInteger = 0;
	UpnpListInit(&p->m_TheList);

	free(p);
}

int TestClass_assign(TestClass *p, const TestClass *q)
{
	int ok = 1;

	if (p != q) {
		ok = ok && TestClass_set_TheList(p, TestClass_get_TheList(q));
		ok = ok && TestClass_set_TheInteger(p, TestClass_get_TheInteger(q));
		ok = ok && TestClass_set_TheUnsignedLong(p, TestClass_get_TheUnsignedLong(q));
		ok = ok && TestClass_set_TheCharPointer(p, TestClass_get_TheCharPointer(q));
		ok = ok && TestClass_set_TheBuffer(p, TestClass_get_TheBuffer(q));
		ok = ok && TestClass_set_TheActionComplete(p, TestClass_get_TheActionComplete(q));
		ok = ok && TestClass_set_TheString(p, TestClass_get_TheString(q));
		ok = ok && TestClass_set_TheDomString(p, TestClass_get_TheDomString(q));
	}

	return ok;
}

TestClass *TestClass_dup(const TestClass *q)
{
	TestClass *p = TestClass_new();

	if (!p) return 0;

	TestClass_assign(p, q);

	return p;
}

const UpnpListHead *TestClass_get_TheList(const TestClass *p)
{
	return &p->m_TheList;
}

int TestClass_set_TheList(TestClass *p, const UpnpListHead *q)
{
	p->m_TheList = *q;

	return 1;
}

void TestClass_add_to_list_TheList(TestClass *p, struct UpnpListHead *head)
{
	UpnpListHead *list = &p->m_TheList;
	UpnpListInsert(list, UpnpListEnd(list), head);
}

int TestClass_get_TheInteger(const TestClass *p)
{
	return p->m_TheInteger;
}

int TestClass_set_TheInteger(TestClass *p, int n)
{
	p->m_TheInteger = n;

	return 1;
}

unsigned long TestClass_get_TheUnsignedLong(const TestClass *p)
{
	return p->m_TheUnsignedLong;
}

int TestClass_set_TheUnsignedLong(TestClass *p, unsigned long n)
{
	p->m_TheUnsignedLong = n;

	return 1;
}

char * TestClass_get_TheCharPointer(const TestClass *p)
{
	return p->m_TheCharPointer;
}

int TestClass_set_TheCharPointer(TestClass *p, char * n)
{
	p->m_TheCharPointer = n;

	return 1;
}

const struct TheStruct *TestClass_get_TheBuffer(const TestClass *p)
{
	return &p->m_TheBuffer;
}

int TestClass_set_TheBuffer(TestClass *p, const struct TheStruct *buf)
{
	p->m_TheBuffer = *buf;

	return 1;
}

void TestClass_clear_TheBuffer(TestClass *p)
{
	memset(&p->m_TheBuffer, 0, sizeof(struct TheStruct));
}

const UpnpActionComplete *TestClass_get_TheActionComplete(const TestClass *p)
{
	return p->m_TheActionComplete;
}

int TestClass_set_TheActionComplete(TestClass *p, const UpnpActionComplete *s)
{
	UpnpActionComplete *q = UpnpActionComplete_dup(s);
	if (!q) return 0;
	UpnpActionComplete_delete(p->m_TheActionComplete);
	p->m_TheActionComplete = q;

	return 1;
}

const UpnpString *TestClass_get_TheString(const TestClass *p)
{
	return p->m_TheString;
}

int TestClass_set_TheString(TestClass *p, const UpnpString *s)
{
	const char *q = UpnpString_get_String(s);

	return UpnpString_set_String(p->m_TheString, q);
}

size_t TestClass_get_TheString_Length(const TestClass *p)
{
	return UpnpString_get_Length(TestClass_get_TheString(p));
}

const char *TestClass_get_TheString_cstr(const TestClass *p)
{
	return UpnpString_get_String(TestClass_get_TheString(p));
}

int TestClass_strcpy_TheString(TestClass *p, const char *s)
{
	return UpnpString_set_String(p->m_TheString, s);
}

int TestClass_strncpy_TheString(TestClass *p, const char *s, size_t n)
{
	return UpnpString_set_StringN(p->m_TheString, s, n);
}

void TestClass_clear_TheString(TestClass *p)
{
	UpnpString_clear(p->m_TheString);
}

const DOMString TestClass_get_TheDomString(const TestClass *p)
{
	return p->m_TheDomString;
}

int TestClass_set_TheDomString(TestClass *p, const DOMString s)
{
	DOMString q = ixmlCloneDOMString(s);
	if (!q) return 0;
	ixmlFreeDOMString(p->m_TheDomString);
	p->m_TheDomString = q;

	return 1;
}

const char *TestClass_get_TheDomString_cstr(const TestClass *p)
{
	return (const char *)TestClass_get_TheDomString(p);
}

