/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.TypesStack;

public class OPcondtnl
extends OPfunction {
    OPlist trueList;
    OPlist falseList;

    public OPcondtnl(TypesStack typesStk, OPlist list, OPlist trueList, OPlist falseList) throws CompilationException {
        int type2ID = typesStk.peekID();
        Class type2 = typesStk.pop();
        int type1ID = typesStk.peekID();
        Class type1 = typesStk.pop();
        int argID = typesStk.peekID();
        if (TypesStack.unwrapType[argID] != 0) {
            throw new CompilationException(-1, 23, null);
        }
        if (argID != 0) {
            list.addLast(new OPunary(typesStk, 0, null, false));
        }
        typesStk.pop();
        if (type2 == type1) {
            this.resID = type1ID;
            this.resType = type1;
        } else {
            byte type1IDunwrp = TypesStack.baseType[TypesStack.unwrapType[type1ID]];
            byte type2IDunwrp = TypesStack.baseType[TypesStack.unwrapType[type2ID]];
            boolean found = false;
            if (TypesStack.baseType[type1ID] == 8 && TypesStack.baseType[type2ID] == 8) {
                this.resID = 8;
                found = true;
                if (type1 == null && type2 == null) {
                    this.resType = null;
                } else if (type1 == null && type2 != null || type2.isAssignableFrom(type1)) {
                    this.resType = type2;
                    this.resID = type2ID;
                } else if (type1 != null && type2 == null || type1.isAssignableFrom(type2)) {
                    this.resID = type1ID;
                    this.resType = type1;
                } else {
                    if (type1IDunwrp == type1ID && type2IDunwrp == type2ID) {
                        Object[] paramsExc = new Object[]{type1, type2};
                        throw new CompilationException(-1, 24, paramsExc);
                    }
                    found = false;
                }
            }
            if (!found) {
                if (type1IDunwrp == 1 && type2IDunwrp == 3 || type1IDunwrp == 3 && type2IDunwrp == 1) {
                    this.resID = 3;
                } else {
                    this.resID = OPbinary.promotions[type1IDunwrp][type2IDunwrp];
                    if (this.resID < 0) {
                        Object[] paramsExc = new Object[]{type1, type2};
                        throw new CompilationException(-1, 24, paramsExc);
                    }
                }
            }
        }
        if (type1ID != this.resID || this.resID == 8 && type1 != null && type1 != this.resType) {
            typesStk.pushID(type1ID, type1);
            trueList.addLast(new OPunary(typesStk, this.resID, this.resType, false));
            typesStk.pop();
        }
        if (type2ID != this.resID || this.resID == 8 && type2 != null && type2 != this.resType) {
            typesStk.pushID(type2ID, type1);
            falseList.addLast(new OPunary(typesStk, this.resID, this.resType, false));
            typesStk.pop();
        }
        typesStk.pushID(this.resID, this.resType);
        this.trueList = trueList;
        this.falseList = falseList;
    }

    public int getNParams() {
        return 1;
    }

    protected void compile(ClassFile cf) {
        cf.branch_true();
        this.trueList.compile(cf);
        cf.branch_false();
        this.falseList.compile(cf);
        cf.branch_end();
    }

    protected void eval(OPlist list) {
        this.trueList.performCF();
        this.falseList.performCF();
        if (!(this.prev instanceof OPload)) {
            return;
        }
        OPload opl = (OPload)this.prev;
        OPlist replList = (Boolean)opl.what != false ? this.trueList : this.falseList;
        OP curr = replList.getLast();
        while (curr != null) {
            OP prv = curr.prev;
            list.addAfter(this, curr);
            curr = prv;
        }
        list.remove(this.prev);
        list.remove(this);
    }

    public String toString() {
        StringBuffer res = new StringBuffer("?(");
        res.append(this.trueList.toString());
        res.append("):(");
        res.append(this.falseList.toString());
        res.append(")");
        return res.toString();
    }
}

