/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.VariableProvider;

public class IntegralVirtualTest
extends TestingUtils {
    Library lib;
    Object[] rtp;

    public IntegralVirtualTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Class[] dynamicLib = new Class[1];
        this.rtp = new Object[1];
        VariableProvider vp = new VariableProvider();
        Class[] staticLib = new Class[]{Class.forName("java.lang.Math"), vp.getClass()};
        vp.xvar = 5.0;
        vp.strVar = "strVar";
        this.rtp[0] = vp;
        dynamicLib[0] = vp.getClass();
        this.lib = new Library(staticLib, dynamicLib, null, null, null);
    }

    public void test1() throws Throwable {
        IntegralVirtualTest.simExpression("sin(x/5)", Math.sin(1.0), null, this.rtp, this.lib, null);
    }

    public void test2() throws Throwable {
        IntegralVirtualTest.simExpression("255+5+7+9-x", 271.0, null, this.rtp, this.lib, null);
    }

    public void test3() throws Throwable {
        IntegralVirtualTest.simExpression("-x+255+5+7+9", 271.0, null, this.rtp, this.lib, null);
    }

    public void test4() throws Throwable {
        IntegralVirtualTest.simExpression("-x+(255+5+7+9)", 271.0, null, this.rtp, this.lib, null);
    }

    public void test5() throws Throwable {
        IntegralVirtualTest.simExpression("5*x-66", -41.0, Double.TYPE, this.rtp, this.lib, null);
    }

    public void test6() throws Throwable {
        IntegralVirtualTest.simExpression("7+(int)4-(int)6.0+(int)x-(int)round((double)((float)((long)x+1)+2)+3)+6", 5, null, this.rtp, this.lib, null);
    }

    public void test7() throws Throwable {
        IntegralVirtualTest.simExpression("x", 5.0, null, this.rtp, this.lib, null);
    }

    public void test8() throws Throwable {
        IntegralVirtualTest.simExpression("(x)", 5.0, null, this.rtp, this.lib, null);
    }

    public void test9() throws Throwable {
        IntegralVirtualTest.simExpression("(-x)", -5.0, null, this.rtp, this.lib, null);
    }

    public void test10() throws Throwable {
        IntegralVirtualTest.simExpression("(x())", 5.0, null, this.rtp, this.lib, null);
    }

    public void test11() throws Throwable {
        IntegralVirtualTest.simExpression("xS<4.0", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test12() throws Throwable {
        IntegralVirtualTest.simExpression("xXS<4.0", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test13() throws Throwable {
        IntegralVirtualTest.simExpression("x<4.0", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test14() throws Throwable {
        IntegralVirtualTest.simExpression("xX<4.0", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test15() throws Throwable {
        IntegralVirtualTest.simExpression("xS<4.0", Boolean.FALSE, Boolean.TYPE, this.rtp, this.lib, null);
    }

    public void test16() throws Throwable {
        IntegralVirtualTest.simExpression("xXS<4.0", Boolean.FALSE, Boolean.TYPE, this.rtp, this.lib, null);
    }

    public void test17() throws Throwable {
        IntegralVirtualTest.simExpression("x<4.0", Boolean.FALSE, Boolean.TYPE, this.rtp, this.lib, null);
    }

    public void test18() throws Throwable {
        IntegralVirtualTest.simExpression("xX<4.0", Boolean.FALSE, Boolean.TYPE, this.rtp, this.lib, null);
    }

    public void test19() throws Throwable {
        IntegralVirtualTest.simExpression("voidf(\"test\")", Void.TYPE, null, this.rtp, this.lib, null);
    }
}

