
;;(setq flyspell-default-dictionary "british")
;;(ispell-change-dictionary "british")

(when (and os-type--mswindows-p emacs-dialect--gnuemacs-p)
  (setq-default ispell-program-name "aspell")
  (setq-default ispell-extra-args '("--reverse"))
  (setenv "PATH" (concat "C:\\Program Files\\Aspell\\bin;" (getenv "PATH")))
  )

(setq ispell-dictionary "british")

(add-hook 'find-file-hook 'maybe-turn-on-flyspell-mode)
;;(remove-hook 'find-file-hook 'turn-on-flyspell)

(global-set-key "\C-v" 'ispell-word)

(defun maybe-turn-on-flyspell-mode ()
  (if (or (eq major-mode 'text-mode)
          ;;(eq major-mode 'fundamental-mode)
          (eq major-mode 'latex-mode)
          (eq major-mode 'html-mode))
      (progn
;;        (if (< (point-max) 10000)
;;            (flyspell-buffer))
        (flyspell-mode)
        (define-key flyspell-mode-map [mouse-3] 'flyspell-correct-word/local-keymap))))

(defun turn-on-flyspell ()
  (interactive)
  (flyspell-buffer)
  (flyspell-mode))

(add-hook 'flyspell-post-command-hook 'd-flyspell-post-command-hook)

(defun d-flyspell-post-command-hook ()
  ;;(d-foo)
  )

(defun fsb ()
  (interactive)
  (flyspell-mode)
  (flyspell-buffer)
  (local-unset-key [mouse-3])
  (define-key flyspell-mode-map [mouse-3] 'flyspell-correct-word/local-keymap)
  )

(global-set-key [mouse-3] 'flyspell-correct-word)

(provide 'd-flyspell)
;;; d-flyspell.el ends here
