/*
    This file is part of jwhois
    Copyright (C) 1999,2001  Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif
#ifdef HAVE_LOCALE_H
# include <locale.h>
#endif

#include <jconfig.h>
#include <jwhois.h>
#include <regex.h>
#include <whois.h>
#include <http.h>

#ifdef HAVE_LIBINTL_H
# include <libintl.h>
# define _(s)  gettext(s)
#else
# define _(s)  (s)
#endif

int
main(argc, argv)
     int argc;
     char **argv;
{
  int optind, count = 0, port = 0, ret;
  char *qstring = NULL, *host, *text, *tmp, *tmp2;
  struct s_whois_query wq;

#ifdef HAVE_LIBINTL_H
  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);
#endif

  re_syntax_options = RE_SYNTAX_EMACS;
  wq.host = NULL;
  wq.port = 0;
  wq.query = NULL;
  wq.domain = NULL;

  /* Parse command line arguments and initialize the cache */
  optind = parse_args(&argc, &argv);
  cache_init();

  /* Parse remaining arguments and place them into the wq
     structure. */
  while (optind < argc)
    {
      count += strlen(argv[optind])+1;
      if (!qstring)
	qstring = malloc(count+1);
      else
	qstring = realloc(qstring, count+1);
      if (!qstring)
        {
          printf("[%s]\n", _("Error allocating memory"));
          exit(1);
        }
      memcpy(qstring+count-strlen(argv[optind])-1,
	     argv[optind],
	     strlen(argv[optind])+1);
      strcat(qstring, " ");
      optind++;
    }
  qstring[strlen(qstring)-1] = '\0';
  wq.query = qstring;

  if (ghost)
    {
      if (verbose>1) printf("[Calling %s:%d directly]\n", ghost, gport);
      wq.host = ghost;
      wq.port = gport;
    }
  else if (split_host_from_query(&wq))
    {
      if (verbose>1) printf("[Calling %s directly]\n", wq.host);
    }
  else
    {
      ret = lookup_host(&wq, NULL);
      if (ret < 0)
	{
	  printf("[%s]\n", _("Fatal error searching for host to query"));
	  exit(1);
	}
    }

  text = NULL;

#ifndef NOCACHE
  if (!forcelookup && cache) {
    if (verbose>1) printf("[Looking up entry in cache]\n");
    ret = cache_read(wq.query, &text);
    if (ret < 0)
      {
	printf("[%s]\n", _("Error reading cache"));
	exit(1);
      }
    else if (ret > 0)
      {
	printf("[%s]\n%s", _("Cached"), text);
	exit(0);
      }
  }
#endif

  jwhois_query(&wq, &text);

#ifndef NOCACHE
  if (cache) {
    if (verbose>1) printf("[Storing in cache]\n");
    ret = cache_store(wq.query, text);
    if (ret < 0)
      {
	printf("[%s]\n", _("Error writing to cache"));
      }
  }
#endif

  printf("%s", text);
  exit(0);
}

/*
 *  This is the routine that actually performs a query. It selects
 *  the method to use for the host and then calls the correct routine
 *  to make the query. If the return value of the subroutine is above
 *  0, it found a redirect to another server, so jwhois_query() promptly
 *  follows it there. A return value of -1 is always a fatal error.
 */
int
jwhois_query(wq, text)
     struct s_whois_query *wq;
     char **text;
{
  char *tmp, *tmp2, *oldquery;
  int ret;

  if (!display_redirections)
    *text = NULL;
  
  if (!raw_query)
    {
      oldquery = malloc(strlen(wq->query)+1);
      strncpy(oldquery, wq->query, strlen(wq->query)+1);
      wq->query = (char *)lookup_query_format(wq);
    }

  tmp = (char *)get_whois_server_option(wq->host, "rwhois");
  tmp2 = (char *)get_whois_server_option(wq->host, "http");

  if ( (tmp && 0 == strcasecmp(tmp, "true")) || rwhois )
    {
      ret = rwhois_query(wq, text);
    }
  else
    {
      if (tmp2 && 0 == strcasecmp(tmp2, "true"))
	{
	  ret = http_query(wq, text);
	}
      else
	{
	  ret = whois_query(wq, text);
	}
    }

  if (!raw_query)
    wq->query = oldquery;

  if (ret < 0)
    {
      exit(1);
    }
  if (ret > 0)
    jwhois_query(wq, text);
  else
    return 0;
}


