/* -*-c-*- -------------- mixgtk.c :
 * Main function of the mix gtk front-end
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "01/03/14 23:08:50 jose"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <mixlib/mix.h>
#include "mixgtk_widgets.h"
#include "mixgtk_cmd_dispatcher.h"
#include "mixgtk_device.h"
#include "mixgtk_mixvm.h"
#include "mixgtk_mixal.h"
#include "mixgtk_input.h"

int
main(int argc, char *argv[])
{
  mix_vm_t *vm;
  
  gtk_init(&argc, &argv);

  mix_init_lib ();
  
  if (!mixgtk_widget_factory_init (GLADE_FILE)
      && !mixgtk_widget_factory_init (LOCAL_GLADE_FILE))
    {
      g_error ("Unable to initialise application (using %s and %s)\n",
	       GLADE_FILE, LOCAL_GLADE_FILE);
      return EXIT_FAILURE;
    }

  if (!mixgtk_cmd_dispatcher_init ())
    {
      g_error ("Unable to initialise application (command dispatcher)\n");
      return EXIT_FAILURE;
    }

  vm = mixgtk_cmd_dispatcher_get_vm ();
  
  if (!mixgtk_device_init (GTK_NOTEBOOK
			   (mixgtk_widget_factory_get (MIXGTK_WIDGET_DEVICE)),
			   vm))
    {
      g_error ("Unable to initialise application (devices)\n");
      return EXIT_FAILURE;
    }

  if (!mixgtk_mixvm_init (vm))
    {
      g_error ("Unable to initialise application (mixvm widgets)\n");
      return EXIT_FAILURE;
    }

  if (!mixgtk_mixal_init (vm))
    {
      g_error ("Unable to initialise application (mixal widgets)\n");
      return EXIT_FAILURE;
    }

  if (!mixgtk_input_init ())
    {
      g_error ("Unable to initialise application (word input widgets)\n");
      return EXIT_FAILURE;
    }
    
  
  gtk_main();

  mix_release_lib ();
  
  return EXIT_SUCCESS;
}
