/* -*-c-*- -------------- xmix_device.c :
 * Implementation of the functions declared in xmix_device.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "01/03/02 23:14:57 jose"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#include "xmix_device.h"

const char *DEV_EXT_ = ".dev";

const char *DEF_NAMES_[] = {
  "tape0", "tape1", "tape2", "tape3", "tape4", "tape5", "tape6", "tape7",
  "disk0", "disk1", "disk2", "disk3", "disk4", "disk5", "disk6", "disk7",
  "cardrd", "cardwr", "printer", "console", "paper"
};

const size_t SIZES_[] = {
  100, 100, 100, 100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100,
  16, 16, 24, 14, 14
};

const mix_device_mode_t MODES_[] = {
  mix_dev_BIN, mix_dev_BIN, mix_dev_BIN, mix_dev_BIN, mix_dev_BIN,  
  mix_dev_BIN, mix_dev_BIN, mix_dev_BIN, mix_dev_BIN, mix_dev_BIN,  
  mix_dev_BIN, mix_dev_BIN, mix_dev_BIN, mix_dev_BIN, mix_dev_BIN,
  mix_dev_BIN, mix_dev_CHAR, mix_dev_CHAR, mix_dev_CHAR, mix_dev_CHAR,
  mix_dev_CHAR
};

const mix_fmode_t FMODES_[] = {
  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,
  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,
  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,
  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,  mix_io_RDWRT,
  mix_io_READ, mix_io_WRITE, mix_io_WRITE, mix_io_WRITE, mix_io_WRITE
};

/*
  Write a block to the device.
*/
static gboolean
write_ (mix_device_t *dev, const mix_word_t *block) 
{
  gboolean result;

  if (FMODES_[dev->type] == mix_io_READ) return FALSE;
  if (MODES_[dev->type] == mix_dev_CHAR)
    result = mix_io_write_word_array_as_char (GET_CHANNEL_ (dev),
					      block, SIZES_[dev->type]);
  else
    result = mix_io_write_word_array (GET_CHANNEL_ (dev),
				      block, SIZES_[dev->type]);
  if (result && mix_device_mode(dev) == mix_dev_CHAR) 
    putc ('\n', mix_io_to_FILE (GET_CHANNEL_ (dev)));

  fflush (mix_io_to_FILE (GET_CHANNEL_ (dev)));
  
  return result;
}

static gboolean
read_ (mix_device_t *dev, mix_word_t *block) 
{
  if (FMODES_[dev->type] == mix_io_WRITE) return FALSE;
  if (MODES_[dev->type] == mix_dev_CHAR)
    return mix_io_read_word_array_as_char (GET_CHANNEL_ (dev),
					   block, SIZES_[dev->type]);
  else
    return mix_io_read_word_array (GET_CHANNEL_ (dev),
				   block, SIZES_[dev->type]);
}

static gboolean
ioc_ (mix_device_t *dev, mix_short_t arg) 
{
  int m;
  FILE *file;
  
  m = mix_short_magnitude(arg);
  if (mix_short_is_negative(arg)) m = -m;
  m *= sizeof (mix_word_t) * SIZES_[dev->type];
  file = mix_io_to_FILE (GET_CHANNEL_(dev));
  
  if (dev->type >= mix_dev_TAPE_0 && dev->type <= mix_dev_TAPE_7)
    {
      if (m == 0) rewind (file);
      else fseek (file, m, SEEK_CUR);
    }
  if (dev->type >= mix_dev_DISK_0 && dev->type <= mix_dev_DISK_7)
    {
      g_return_val_if_fail (m == 0, FALSE);
      // position disk
    }
  if (dev->type == mix_dev_PAPER_TAPE)
    {
      g_return_val_if_fail (m == 0, FALSE);
      rewind (file);
    }
  return TRUE;
}

static gboolean
busy_ (const mix_device_t *dev)
{
  return (!mix_io_is_ready (GET_CHANNEL_(dev)));
}

static mix_device_vtable_t VTABLE_ = {
  write_, read_, ioc_, busy_
};

const mix_device_vtable_t * DEF_DEV_VTABLE_ = &VTABLE_;
