/* parser.h: -*- C -*-  Functions which make it easy to parse Meta-HTML. */

/* Author: Brian J. Fox (bfox@ai.mit.edu) Tue Sep 26 22:17:39 1995.

   This file is part of <Meta-HTML>(tm), a system for the rapid deployment
   of Internet and Intranet applications via the use of the Meta-HTML
   language.

   Copyright (c) 1995, 1996, Brian J. Fox (bfox@ai.mit.edu).
   Copyright (c) 1996, Universal Access Inc. (http://www.ua.com).

   Meta-HTML is free software; you can redistribute it and/or modify
   it under the terms of the UAI Free Software License as published
   by Universal Access Inc.; either version 1, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   UAI Free Software License for more details.

   You should have received a copy of the UAI Free Software License
   along with this program; if you have not, you may obtain one by
   writing to:

   Universal Access Inc.
   129 El Paseo Court
   Santa Barbara, CA
   93101  */

#include "pagefuncs.h"

#if !defined (_PARSER_H_)
#define _PARSER_H_

#define var_present_p(pack, name) \
    (symbol_lookup_in_package (pack, name) != (Symbol *)NULL)

#undef whitespace
#define whitespace(c) \
     (((c) == ' ') || ((c) == '\t') || ((c) == '\r') || ((c) == '\n'))

#if defined LANGUAGE_DEFINITIONS_FILE
#define PACKAGE_INITIALIZER(name)

typedef struct
{
  jmp_buf env;
  PAGE *page;
  int offset;
} PageEnv;

extern PageEnv *pagefunc_save_environment (void);
extern void pagefunc_restore_environment (PageEnv *env);

#endif

extern void page_process_page (volatile PAGE *page);
extern void page_process_page_internal (PAGE *page);
extern int empty_string_p (char *string);
extern char *get_value (Package *package, char *name);
extern char *get_one_of (Package *package, char *tag, ...);
extern char **get_vars_names (Package *package);
extern char **get_vars_vals (Package *package);
extern char *get_positional_arg (Package *package, int position);
extern char *read_sexp (char *string, int *start, int stop_at_equals_p);
extern char *read_sexp_1 (char *string, int *start, int stop_at_equals_p,
			  int one_list);
extern PFunDesc *pagefunc_get_descriptor (char *tag);
extern void page_return_this_page (PAGE *page);
extern char *page_evaluate_string (char *body);
extern char *html_quote_string (char *string);
extern char *metahtml_copyright_string;
#endif (_PARSER_H_)
