/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011
    Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


class Buffer_handle
  {
  Buffer * bufferp_;	// handled buffer

public:
  Point top_left;	// buffer coordinates of window top-left corner
  Point cursor;		// buffer coordinates of window cursor
  Point pointer;	// current buffer character
  Point pcursor;	// buffer coordinates of current buffer character

  Buffer_handle( Buffer & buffer, const int line = 0 ) throw()
    : bufferp_( &buffer ), top_left( line, 0 ), cursor( line, 0 ),
      pointer( line, 0 ), pcursor( line, 0 ) {}

  Buffer & buffer() throw() { return *bufferp_; }
  const Buffer & buffer() const throw() { return *bufferp_; }
  };


// Bufhandle_vector is the main data structure of the editor.
// It contains the handles for all the buffers being edited.
// Bufhandle_vector is a circular buffer of Buffer_handles
//
namespace Bufhandle_vector {

void init() throw();
void save_all_named() throw();
void show_status() throw();

int absolute_index( const int i ) throw();
int circular_index( const int ai ) throw();
Buffer_handle & handle( const int i ) throw();
int handles() throw();
int handles( const Buffer & buffer ) throw();
int last_visited( const int i ) throw();
void next() throw();
void prev() throw();
void set_first( const int ai ) throw();

int find_or_add_handle( const Buffer::Options & opts,
                        const std::string * const namep = 0,
                        int i = -1, const int line = 0 );
void add_handle_if_pending_input_or_empty( const int line );
void duplicate_handle( int i );
bool delete_handle( int i ) throw();

} // end namespace Bufhandle_vector
