/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <fstream>
#include <sstream>
#include "StdAfx.h"
#include "MapManager.h"
#include <iostream>  // I/O 
#include <istream>
#include <ostream>
#include <cstdlib>
Board MapManager::loadFileMap(std::string filename){
	
	return loadStringMap(loadFileString(filename));

}

std::string MapManager::loadFileString(std::string filename){
	std::string buf;
	std::string line;
	std::ifstream in(filename.c_str());
	 if(!in) { // file couldn't be opened
      std::cerr << "Error: file could not be opened :" <<filename<< std::endl;
	  
      exit(1);
   }

	while(std::getline(in,line))
		buf += line+"\n";
	
	in.close();   
	return buf;

}

Board MapManager::loadStringMap(std::string map){
	
	int width=0;
	int height=0;
	int warped=0,players=0,active_players=0,remaining_players=0,turn=0,n_att=0;

	unsigned int sizeString=map.length();
	unsigned int i=0;
	std::string line="";
	std::string megaMap="";
	bool isMap=false;
	for (i=0;i<sizeString;i++)
	{
		
		if (map.at(i)=='\n')
		{
			unsigned int j=0;
			std::string key="";
			std::string value="";
			bool isKey=true;
			
			for (j=0;j<line.length();j++)
			{
				if (line.at(j)==' ')
				{
					isKey=false;
				}
				else if (j==line.length()-1){
					if (isKey)
					{
						key+=line.at(j);
					}
					else
					{
						value+=line.at(j);
					}
					//std::cout <<"Key="<<key<<std::endl;
					//std::cout <<"Value="<<value<<std::endl;
					if (key.compare("width")==0)
					{

						width=atoi(value.c_str());
					}
					else if (key.compare("height")==0)
					{
						height=atoi(value.c_str());
					}
					else if (key.compare("warped")==0)
					{
						warped=atoi(value.c_str());
					}
					else if (key.compare("players")==0)
					{
						players=atoi(value.c_str());
					}
					else if (key.compare("active_players")==0)
					{
						active_players=atoi(value.c_str());
					}
					else if (key.compare("remaining_players")==0)
					{
						remaining_players=atoi(value.c_str());
					}
					else if (key.compare("turn")==0)
					{
						turn=atoi(value.c_str());
					}
					else if (key.compare("n_att")==0)
					{
						n_att=atoi(value.c_str());
						isMap=true;
						break;
					}
					
					isKey=true;
					
					key="";
					value="";
				}
				else
				{
					if (isKey)
					{
						key+=line.at(j);
					}
					else
					{
						value+=line.at(j);
					}
				}
			}

			line="";
		}
		else
		{
			if (isMap)
				megaMap+=map.at(i);
			
			line +=map.at(i);
		}

	}
	Board bBoard(width,height,warped,players,active_players,remaining_players,turn,n_att);
	int xCoor=0;
	int yCoord=0;
	bool isC=true;
	std::string ac="";
	for (i=0;i<megaMap.length();i++)
	{
		//std::cout <<megaMap.at(i);
		if (megaMap.at(i)==' '||megaMap.at(i)=='.')
		{

			if (isC)
			{
				isC=false;
			}
			else
			{
				
				if (!ac.empty())
				{
					
					//std::cout <<xCoor<<":"<<yCoord<<" name="<<bBoard.getOrCreatePlayerByName(ac)<<std::endl;
					if (megaMap.at(i)=='.')
					{
						bBoard.setCase(xCoor,yCoord,Case(true,bBoard.getOrCreatePlayerByName(ac),Case::FREE));
					}
					else
					{
						bBoard.setCase(xCoor,yCoord,Case(false,bBoard.getOrCreatePlayerByName(ac),Case::FREE));
					}
				}
				xCoor++;
				if (xCoor==width)
				{
					xCoor=0;
					yCoord++;
				}
				isC=true;
				ac="";
			}

		}
		else
		{
			ac+=megaMap.at(i);
			isC=false;
		}
	}

	
	return bBoard;

}
