/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include "Board.h"
#include "RandomGenerator.h"
class MottiRulesManager
{
public:
	MottiRulesManager(void);
	virtual ~MottiRulesManager(void);
	void setBoard(Board *);
	Board* getBoard();
	Player * getActualPlayer();
	void initGame();
	void initTurn();
	void attack(int x,int y);
	void unattack(int x,int y);
	void defend(int x,int y);
	void undefend(int x,int y);
	void guerilla(int x,int y);
	void unguerilla(int x,int y);
	void attack(Player *,int x,int y);
	void unattack(Player *,int x,int y);
	void defend(Player *,int x,int y);
	void undefend(Player *,int x,int y);
	void guerilla(Player *,int x,int y);
	void unguerilla(Player *,int x,int y);
	void cleanSurvyvor();
	void endTurn();
	RandomGenerator &getRandomGenerator();
private:
	void initPlayerGame(Player *);
	void calculateMap();
	void nextPlayer();
	void fixCase();
	void uncolorCase();
	void searchWinner();
	void searchWinner2();
	void affectPlayerMapWinner(Player *a,Player *b);
	bool isEncircled(int x, int y);
	void colorizeEncircled(int x, int y);
	void cleanIFullLocked();
	void cleanIFOne();
	
	RandomGenerator randGen_;
	Board *board_;
	
};

