/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "StringDrawer.h"
#include <stdio.h>
#include <ctype.h>
#include <string>
#include <stdlib.h>
#include <iostream>
#include <sstream>
#ifdef WIN32
#include <windows.h>
#else
#include <sys/ioctl.h>

#include <stdio.h>
#include <cstdlib>
#include <iostream>
 #include <termios.h>
#endif
#include <ctime>
#include "StringMessageBoxDrawable.h"
#include "StringMenuDrawable.h"
//#include <stropts.h>
StringDrawer::StringDrawer(Board &b):x_(0),y_(0),actualBoard_(&b)//,actualScreen_("")
{
	calculateWidthHeight();
	
}

void  StringDrawer::refreshConfig(){

	
	calculateWidthHeight();

}

void StringDrawer::calculateWidthHeight(){
	int savedWidth=realScreenWidth_;
	int savedHeight=realScreenHeight_;
	#ifdef WIN32	
	/*
	struct winsize win;
        ioctl(stdout, TIOCGWINSZ, &winsize);
		*/
	//system("mode con LINES=20 COLS=80");
	//SetConsoleWindowInfo
	CONSOLE_SCREEN_BUFFER_INFO csbiInfo; 
    //SMALL_RECT srctWindow; 
	HANDLE hStdout; 
	hStdout = GetStdHandle(STD_OUTPUT_HANDLE); 

 
    // Get the current screen buffer size and window position. 
 
    if (! GetConsoleScreenBufferInfo(hStdout, &csbiInfo)) 
    {
        printf("GetConsoleScreenBufferInfo (%d)\n", GetLastError()); 
    }
	 clock_t finish(clock());
	realScreenWidth_=csbiInfo.srWindow.Right-csbiInfo.srWindow.Left;
	realScreenHeight_=csbiInfo.srWindow.Bottom-csbiInfo.srWindow.Top;
	contour_=true;
#else
    
    struct winsize  size;

    ioctl(STDIN_FILENO, TIOCGWINSZ, (char *) &size);
    realScreenWidth_=size.ws_col;
	realScreenHeight_=size.ws_row-1;

	
#endif
	if (savedWidth!=realScreenWidth_||savedHeight!=realScreenHeight_)
	{
		//if (actualScreen_.empty())
		{
			//actualScreen_="";
			//actualScreen_.reserve (realScreenWidth_*realScreenHeight_+realScreenHeight_ );	
			drawEmpty( realScreenWidth_,realScreenHeight_);
		}
	}
}


StringDrawer::~StringDrawer(void)
{
}

std::string StringDrawer::drawCase( Case &c)
{
	std::string vStr;
	char oop[2];
	oop[1]=0;
	if (c.getPlayer()!=NULL)
	{
		switch (c.getType())
		{
			default:
			case Case::NOTUSED :
				return " ";
			case Case::LOCKED :
				oop[0]=(char)toupper(c.getPlayer()->getName().at(0));
				vStr=oop;
					if (c.isCityCenter())
				{
					return "O";
				}
				else
				return vStr;
			case Case::SELECTED :
				
				
				return "X";
			case Case::FREE :
				if (c.getPlayer()!=NULL)
				{
					if (c.getPlayer()->getName().empty())
					oop[0]=' ';
					else
				oop[0]=(char)tolower(c.getPlayer()->getName().at(0));
				vStr=oop;
				if (c.isCityCenter())
				{
					return "o";
				}
				else
				return vStr;
				}

		}
		//vStr+=b.getCase(x+j,y+i).getPlayer()->getName();
	}
	else
		vStr+=" ";
	return vStr;
}

void StringDrawer::drawEmpty( int width,int height){

	//actualScreen_="";
	int i=0,j=0;
	for ( i=0;i<height  ;i++)
	{
		
		for ( j=0;j<width ;j++)
		{
			drawByCursor(j,i,' ') ;
			//actualScreen_+=(char)' ';
		}
	}	

	
	
}


void StringDrawer::drawCoordinatedSimpleBoard( int x,int y,int width,int height,bool aroundSelected){
	
	

	int i=0,j=0;
	for (int i=y;i<height  ;i++)	
	{
		for (int j=x;j<width ;j++)
		{
		
			if (aroundSelected){
				if ((i==0 || i==height-1) && j>=0 && j<=width-1)
				{
					writeXY(j,i,'-');
					//car[coor]='-';
				}
				else if ( j==0 )
				{
					writeXY(j,i,'|');
					
					//car[coor]='|';
				}
				else if ( j==width-1	)
				{
					writeXY(j,i,'|');
						
					//car[coor]='|';
				}
				else
				{
					writeXY(j,i,' ');
					
					//car[coor]=' ';
					
				}
			}else
			{
				writeXY(j,i,' ');
					
				//car[coor]=' ';
			}
		}
		
	}	

	
	
}

void StringDrawer::drawCoordinatedBoard( int startX,int startY,int screenWidth,int xBoard,int yBoard,int width,int height){
	

	int i=0,j=0;
	for (int i=0;i<height  ;i++)
	{
		for (int j=0;j<width ;j++)
		{
			//int index=(screenWidth+1)*(startY)+startX+j+((screenWidth+1)*i);
			//if (((unsigned int)index)>=(realScreenWidth_*realScreenHeight_+realScreenHeight_)) 
			//	continue;
			Case *Cass=actualBoard_->getCaseNoThrow(xBoard+j,yBoard+i);
			if (Cass==NULL)
				drawByCursor(startX+j+1,i+startY+1,' ') ;
				//actualScreen_[index]=(char)' ';
			else
				drawByCursor(startX+j,i+startY,drawCase(*Cass).at(0)) ;
				//actualScreen_[index]=drawCase(*Cass).at(0);
					
			
		}
		
	}	

	

	
}


void StringDrawer::writeXY(int X,int Y, char a)
{
	//int yyymax=X+Y*(realScreenWidth_+1);
	//if (a=='\n') return;
	if (X<0||X>realScreenWidth_) return;
	if (Y<0||Y>realScreenHeight_) return;
	//if (yyymax<0) return;
	//if (yyymax>=(realScreenHeight_)*(realScreenWidth_)+realScreenHeight_) return;
	//if (actualScreen_[yyymax]=='\n') return;
	//std::string::iterator it = actualScreen_.begin();  
	//actualScreen_.replace (yyymax , 1,(const char *)&a );
	drawByCursor(X,Y,a);
	//actualScreen_[yyymax]=a;
}

void StringDrawer::writeStringXY(int X,int Y, std::string &a)
{
	size_t i=0;
	for (i=0;i<a.length();i++)
	{
	 
		writeXY(X+i, Y, a.at(i));
	}
	
}

void StringDrawer::drawCoordinatedCompleteBoard( int x,int y,int width,int height,bool aroundSelected){
	 clock_t start(clock());
	std::string ret;
	
	if (actualBoard_->getWinner()==NULL)
	{
		ret+="Actual player:'";
		if (actualBoard_->getActualPlayer()==NULL)
		{
			ret+="No Player";
		}else{
			ret+=actualBoard_->getActualPlayer()->getName();
		}
		ret+="',Action:";
		switch (actualBoard_->getActionMode())
		{
			default:
			case Board::NOTCHOOSE:
				ret+="No action";
				break;
			case Board::ATTACK:
				ret+="Attack";
				break;
			case Board::DEFEND:
				ret+="Defend";
				break;
			case Board::GUERILLA:
				ret+="Guerilla";
				break;
		}
	
		char buffer [33];
#ifdef __CYGWIN32__
	sprintf(buffer, "%d", actualBoard_->getNbCoutRestant());

	
#else
#ifdef WIN32
	_itoa_s(actualBoard_->getNbCoutRestant(),buffer,33,10);
#else
	sprintf(buffer, "%d", actualBoard_->getNbCoutRestant());
#endif
#endif
		
		ret+=",Nb Free Action:"+std::string(buffer);
		ret+="/";
		switch (actualBoard_->getActionMode())
		{
			case Board::ATTACK:
#ifdef __CYGWIN32__
	sprintf(buffer, "%d", actualBoard_->getNbCoupperTurnAttack());
#else
#ifdef WIN32
	_itoa_s(actualBoard_->getNbCoupperTurnAttack(),buffer,33,10);
#else
	sprintf(buffer, "%d", actualBoard_->getNbCoupperTurnAttack());
#endif
#endif
				
				ret+=std::string(buffer);
				break;
			case Board::DEFEND:
#ifdef __CYGWIN32__
	sprintf(buffer, "%d", actualBoard_->getNbCoupperTurnDefend());
#else
#ifdef WIN32
	_itoa_s(actualBoard_->getNbCoupperTurnDefend(),buffer,33,10);
#else
	sprintf(buffer, "%d", actualBoard_->getNbCoupperTurnDefend());
#endif
#endif
				
				ret+=std::string(buffer);
				break;
			case Board::GUERILLA:
#ifdef __CYGWIN32__
	sprintf(buffer, "%d", actualBoard_->getNbCoupperTurnGuerilla());
#else
#ifdef WIN32
	_itoa_s(actualBoard_->getNbCoupperTurnGuerilla(),buffer,33,10);
#else
	sprintf(buffer, "%d", actualBoard_->getNbCoupperTurnGuerilla());
#endif
#endif
				
				ret+=std::string(buffer);
				break;
			default:
				ret+="0";
				break;
		}
	}else
	{
		ret+="Winner:";
		ret+=actualBoard_->getWinner()->getName();
	}
	unsigned int k=realScreenWidth_-ret.size();
	for (k=0;k<realScreenWidth_-ret.size();k++)
	{
		ret+=" ";
	}
	ret+="";
	
	
	
	
	drawCoordinatedSimpleBoard( 0, 1, realScreenWidth_+1, realScreenHeight_+1, aroundSelected);
	calculateRectifiedCoordinate( );
	int xx=0;
	if (realScreenWidth_>=actualBoard_->getWidth())
	{
		xx=-(realScreenWidth_/2-actualBoard_->getWidth()/2)+1;
	}else
	{
		xx=rectifiedx_;
	}
	
	int yy=0;
	if (realScreenHeight_>=actualBoard_->getHeight())
	{
		yy=-(realScreenHeight_/2-actualBoard_->getHeight()/2);
	}
	else
	{
		yy=rectifiedy_;
	}	
	drawCoordinatedBoard( 1,1,realScreenWidth_,xx,yy,realScreenWidth_-2,realScreenHeight_-1);
	//ret+=ret2;
	writeStringXY(0,0, ret);
	

	clock_t finish(clock());

	

}


void StringDrawer::drawScreen( ){
	
	
	
	
	

 //std::cout << "Process sleep clock difference: " 
   //        << finish-start << '\n';
	int wCorrX=0;
	int wCorrY=0;
	
	drawCoordinatedCompleteBoard(0,0,realScreenWidth_,realScreenHeight_,contour_);

}
void StringDrawer::calculateRectifiedCoordinate( ){

	//Test center
	int millieux=realScreenWidth_/2;
	int millieuy=realScreenHeight_/2;
	if (realScreenWidth_>=actualBoard_->getWidth())
	{
		rectifiedx_=-(realScreenWidth_-actualBoard_->getWidth())/2;
	
	}else
	{
		
		rectifiedx_=x_;
		if (x_>=actualBoard_->getWidth()-realScreenWidth_)
		{
			rectifiedx_=actualBoard_->getWidth()-realScreenWidth_;

			if(contour_)
				rectifiedx_+=2;
		
		}
		if (x_<0)
			rectifiedx_=0;

	}
	if (realScreenHeight_>=actualBoard_->getHeight()){
		rectifiedy_=-(realScreenHeight_-actualBoard_->getHeight())/2;
		
	}
	else
	{
		rectifiedy_=y_;
		if (y_>=actualBoard_->getHeight()-realScreenHeight_)
		{
			rectifiedy_=actualBoard_->getHeight()-realScreenHeight_;
				if(contour_)
				rectifiedy_+=2;
		
		}
			if (y_<0)
			{
				rectifiedy_=0;
			
			}
	}
	/*
	std::cout << "rectifiedx_="<<rectifiedx_<<std::endl;
	std::cout << "rectifiedy_="<<rectifiedy_<<std::endl;
	std::cout << "realScreenWidth_="<<realScreenWidth_<<std::endl;
	std::cout << "realScreenHeight_="<<realScreenHeight_<<std::endl;
	std::cout << "b.getWidth()="<<b.getWidth()<<std::endl;
	std::cout << "b.getHeight()="<<b.getHeight()<<std::endl;
	*/
	//rectifiedx_;
//	rectifiedy_;

}
/* Standard error macro for reporting API errors */ 
 /*#define PERR(bSuccess, api){if(!(bSuccess)) printf("%s:Error %d from %s \ 
    on line %d\n", __FILE__, GetLastError(), api, __LINE__);}
	*/
#ifdef WIN32
 void StringDrawer::clears(  )
 {
	 HANDLE hStdout; 
	hStdout = GetStdHandle(STD_OUTPUT_HANDLE); 
    COORD coordScreen = { 0, 0 };    /* here's where we'll home the
                                        cursor */ 
    BOOL bSuccess;
    DWORD cCharsWritten;
    CONSOLE_SCREEN_BUFFER_INFO csbi; /* to get buffer info */ 
    DWORD dwConSize;                 /* number of character cells in
                                        the current buffer */ 

    /* get the number of character cells in the current buffer */ 

    bSuccess = GetConsoleScreenBufferInfo( hStdout, &csbi );
    //PERR( bSuccess, "GetConsoleScreenBufferInfo" );
    dwConSize = csbi.dwSize.X * csbi.dwSize.Y;

    /* fill the entire screen with blanks */ 

    bSuccess = FillConsoleOutputCharacter( hStdout, (TCHAR) ' ',
       dwConSize, coordScreen, &cCharsWritten );
    //PERR( bSuccess, "FillConsoleOutputCharacter" );

    /* get the current text attribute */ 

    bSuccess = GetConsoleScreenBufferInfo( hStdout, &csbi );
    //PERR( bSuccess, "ConsoleScreenBufferInfo" );

    /* now set the buffer's attributes accordingly */ 

    bSuccess = FillConsoleOutputAttribute( hStdout, csbi.wAttributes,
       dwConSize, coordScreen, &cCharsWritten );
    //PERR( bSuccess, "FillConsoleOutputAttribute" );

    /* put the cursor at (0, 0) */ 

    bSuccess = SetConsoleCursorPosition( hStdout, coordScreen );
    //PERR( bSuccess, "SetConsoleCursorPosition" );
    return;
 }
 #else
   void  StringDrawer::clears( ){
 std::cout <<"\033[2J";
   }	 
 
#endif
 void StringDrawer::drawDirectConsoe( ){
	
	//clears(  );
	clock_t start(clock()); 
	drawScreen( );
	 //if (clear_)
	//	clears(  );
	precursorx_=cursorx_;
	precursory_=cursory_;
	setCursor(0,0);
	 drawAllByCursor();
	//std::cout<<"\n"<<actualScreen_;
	cursorx_=precursorx_;
	cursory_=precursory_;
	clock_t finish(clock());

 //std::cout << "Process sleep clock difference: " 
   //        << finish-start << '\n';
	
 }

 void  StringDrawer::setCoord( int x, int y){
	x_=x;
	y_=y;
 
 }
#ifdef __CYGWIN32__
  void  StringDrawer::setCursor( int x, int y){
  int X=x;
  int Y=y;
	if (cursorx_> realScreenWidth_)
	{
		cursorx_= realScreenWidth_;
	}
	
	if (cursorx_< 0)
	{
		cursorx_= 0;
	}
	
	if (cursory_> realScreenHeight_)
	{
		cursory_= realScreenHeight_;
	}
	
	if (cursory_< 0)
	{
		cursory_= 0;
	}
	
	//std::cout <<"\033["<<y<<";"<<x<<"H";
	   //std::cout <<"\033[1;5m\033[1;47m\033["<<y<<";"<<x<<"f \033[1;49m\033[1;39m\n";
	 std::cout <<"\033[1;47m\033["<<Y<<";"<<X<<"f \033[1;49m\033[1;39m\n";
	   //std::cout <<"\033[5m sss \033[0m";
   }
#else
#ifdef WIN32
  void  StringDrawer::setCursor( int x, int y){
	  if (x>=realScreenWidth_-1 || x<0 || y<0 || y>=realScreenHeight_-1) return;
	cursorx_=x;
	cursory_=y;
	 HANDLE hStdout; 
	hStdout = GetStdHandle(STD_OUTPUT_HANDLE); 
	COORD  off;
	if (contour_)
	{
		off.X=x+1;
		off.Y=y+2;
	}else
	{
		off.X=x;
		off.Y=y+1;
	}
	SetConsoleCursorPosition(hStdout,off);

 
	
 }
#else
   void  StringDrawer::setCursor( int x, int y){
	if (cursorx_> realScreenWidth_)
	{
		cursorx_= realScreenWidth_;
	}
	
	if (cursorx_< 0)
	{
		cursorx_= 0;
	}
	
	if (cursory_> realScreenHeight_)
	{
		cursory_= realScreenHeight_;
	}
	
	if (cursory_< 0)
	{
		cursory_= 0;
	}
	
	//std::cout <<"\033["<<y<<";"<<x<<"H";
	   //std::cout <<"\033[1;5m\033[1;47m\033["<<y<<";"<<x<<"f \033[1;49m\033[1;39m\n";
	 std::cout <<"\033[1;47m\033["<<y<<";"<<x<<"f \033[1;49m\033[1;39m\n";
	   //std::cout <<"\033[5m sss \033[0m";
   }
#endif
#endif
void  StringDrawer::setCursorPlacement( int x, int y){
	cursorx_=x;
	cursory_=y;
	if (cursorx_> realScreenWidth_)
	{
		cursorx_= realScreenWidth_;
	}
	
	if (cursorx_< 0)
	{
		cursorx_= 0;
	}
	
	if (cursory_> realScreenHeight_)
	{
		cursory_= realScreenHeight_;
	}
	
	if (cursory_< 0)
	{
		cursory_= 0;
	}
   }
 
 
  void  StringDrawer::setClearScreen(bool p){
  clear_=p;
  }


void  StringDrawer::right(){
	cursorx_++;
	if (cursorx_> realScreenWidth_-1)
	{
		cursorx_=realScreenWidth_-1;
		x_++;
	}
		setCursor( cursorx_, cursory_);
}

void  StringDrawer::left(){
	cursorx_--;
	if (cursorx_<0)
	{
		x_--;
		cursorx_=0;
	}
	setCursor( cursorx_, cursory_);
}

void  StringDrawer::up(){
  cursory_--;
	if (cursory_<0)
	{
		cursory_=0;
		y_--;
	}
	setCursor( cursorx_, cursory_);
  }

void  StringDrawer::down(){
 cursory_++;
	if (cursory_> realScreenHeight_)
	{
		cursory_=realScreenHeight_;
		y_++;
	}
	setCursor( cursorx_, cursory_);
  }

void StringDrawer::redrawCursor(){
	setCursor( cursorx_, cursory_);
}


int &StringDrawer::getWidth(){
	return realScreenWidth_;
}

int &StringDrawer::getHeight(){
	return realScreenHeight_;
}

int StringDrawer::getXMap(){
#if defined __CYGWIN32__ 
if (realScreenWidth_>=actualBoard_->getWidth())
	{
		return cursorx_-(realScreenWidth_/2-actualBoard_->getWidth()/2)-1;
	}else
	{
		return rectifiedx_+cursorx_-2;
	}
#else
#ifndef WIN32
	if (realScreenWidth_>=actualBoard_->getWidth())
	{
		return cursorx_-(realScreenWidth_/2-actualBoard_->getWidth()/2)-1;
	}else
	{
		return rectifiedx_+cursorx_-2;
	}
#else
	if (realScreenWidth_>=actualBoard_->getWidth())
	{
		return cursorx_-(realScreenWidth_/2-actualBoard_->getWidth()/2);
	}else
	{
		return rectifiedx_+cursorx_;
	}
	
#endif
#endif
}

int StringDrawer::getYMap(){
#ifndef WIN32

	if (realScreenHeight_>=actualBoard_->getHeight())
	{
		return cursory_-(realScreenHeight_/2-actualBoard_->getHeight()/2)-2;
	}
	else
	{
	return rectifiedy_+cursory_-2;
	}
#else

	if (realScreenHeight_>=actualBoard_->getHeight())
	{
		return cursory_-(realScreenHeight_/2-actualBoard_->getHeight()/2)-1;
	}
	else
	{
	return rectifiedy_+cursory_-2;
	}
#endif	

	
}

MessageBoxDrawable *StringDrawer::createMessageBox(std::string message,std::string title){
	return new StringMessageBoxDrawable(message,title,realScreenWidth_/2,realScreenHeight_/2,realScreenWidth_,realScreenHeight_,this);
}

 
MenuDrawable *StringDrawer::createMenu(std::vector<BoxElement *> ll,std::string title){
	return (MenuDrawable *)new StringMenuDrawable(ll,title,realScreenWidth_/2,realScreenHeight_/2,realScreenWidth_,realScreenHeight_,this);
}

void StringDrawer::draw(Drawable *dr) {

	
	dr->draw();
	precursorx_=cursorx_;
	precursory_=cursory_;
	setCursor(0,0);
	 
	//std::cout<<"\n"<<actualScreen_;
	cursorx_=precursorx_;
	cursory_=precursory_;
		
	
}

void StringDrawer::draw() {
	
	calculateWidthHeight();
	drawDirectConsoe();
	redrawCursor();
	
}
void StringDrawer::drawAllByCursor() {
	
	int i=0,j=0;
	for ( i=0;i<realScreenHeight_  ;i++)
	{
		
		for ( j=0;j<realScreenWidth_ ;j++)
		{
			int coor=j+i*(realScreenWidth_+1);
			//drawByCursor(j,i,actualScreen_[coor]); 
		}
	}
	
}
void StringDrawer::drawByCursor(int x,int y,char a) {
	
	std::cout <<"\033["<<y+1<<";"<<x+1<<"f"<<a;
	
}



	
	 
	 
	 
	 
