#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation script (enumerations)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 2001, 2003 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Dragomir Milivojevic
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  print "/* Automatically generated, do not edit! */"
  print "#include <stdio.h>"
  print "#include <stdlib.h>"
  print "#include <glib.h>"
  print "#include <glib-object.h>"
  print "#include <atk/atk.h>"
  print "#include <pango/pango.h>"
  print "#include <gtk/gtk.h>"
  print "#include <gdk/gdk.h>"
}

FNR == 1 {
  enum_class = get_enum_class(FILENAME)
}

# store declaration in decl[filename]
/^(typedef )?enum/ {
  split("", declaration)

  do
    getline
  while (/^{/)

  while (! /^}/) {
    # Strip the comments --------------------------------
    gsub (/\/\*[^*]*\*\//, "", $0)
    if ($1 == "/*") {
      do
        getline
      while ($0 !~ /\*\/$/)
    } else if (/[A-Z]/) {
      sub(/,/, "", $1)
      declaration[$1] = ""
    }
    getline
  }

  # On the last line, read the enum's name --------------
  if (NF != 2)
    enum_category = "enumerations"
  else {
    enum_category = $2
    sub(/;$/, "", enum_category)
    enum_class = get_enum_class(enum_category)
  }

  # And finally emit the code ---------------------------
  for (each in declaration) {
    selector = smalltalkize(tolower(each))
    decl[n++] = "  printf(\"\\n" selector " ^%d!\", " each ");"
  }

  decl[n++] = "  printf(\" !\\n\\n\");"

  enums[m++] = enum_class " " enum_category " " n
}

END {
  print "int"
  print "main() {"
  print "  printf (\"\\\"Automatically generated, do not edit!\\\"\\n\");"
  n = 0
  for (i = 0; i < m; i++)
    {
      $0 = enums[i]
      print "  printf(\"!" $1 " class methodsFor: '" $2 "'!\\n\");"
      while(n < $3)
        print decl[n++]
    }

  print "  exit(0);"
  print "}"
}

function get_enum_class( res )
{
  if (tolower (res) ~ /pango/) return "Pango"
  if (tolower (res) ~ /gdk/) return "Gdk"
  if (tolower (res) ~ /gtk/) return "Gtk"
  if (tolower (res) ~ /atk/) return "Atk"
  if (tolower (res) ~ /g/) return "GLib"
  return ""
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (i = index (res, "_")) {
    first = first substr(res, 1, i - 1) toupper( substr (res, i + 1, 1))
    res = substr (res, i + 2)
  }

  return first res
}
