# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import solfege_c_midi


class AbstractSynth:
    NUM_CHANNELS = 16
    def __init__(self, device, devnum, verbose_init):
        self.m_device = device
        self.m_devnum = devnum
        self.open_device()
        if verbose_init:
            self.print_soundcard_info()
    def open_device(self):
        solfege_c_midi.cvar.seqfd = os.open(self.m_device, os.O_WRONLY, 0)
        if not solfege_c_midi.sndctl_seq_reset():
            raise "Error initializing synth"
        if self.m_devnum >= solfege_c_midi.sndctl_seq_nrsynths():
            raise "devnum > nrsynth"
        self.m_num_voices = solfege_c_midi.get_synth_nr_voices(self.m_devnum)
    def print_soundcard_info(self):
        print "Devicefile:", self.m_device
        print "The following sound devices has been found:"
        assert solfege_c_midi.cvar.seqfd
        nrsynths = solfege_c_midi.sndctl_seq_nrsynths()
        for x in range(nrsynths):        
            print "%i: %s" % (x, solfege_c_midi.get_synth_name(x));
        print "--- using %s ---" % solfege_c_midi.get_synth_name(self.m_devnum)
    def close(self):
        if solfege_c_midi.cvar.seqfd != -1:
            solfege_c_midi.sndctl_seq_reset()
            os.close(solfege_c_midi.cvar.seqfd)
            solfege_c_midi.cvar.seqfd = -1


