/* 
   This file is public domain.

   The data is a matter of public record, and comes from
   http://sqlzoo.net/
 */


SET search_path TO sqltutor;

--- createbuses, 1, 50
DROP TABLE route;
DROP TABLE stops;

CREATE TABLE stops (
  id INTEGER NOT NULL
 ,name VARCHAR(30)
 ,PRIMARY KEY(id)
 );
CREATE TABLE route (
  num VARCHAR(5) NOT NULL
 ,company VARCHAR(3) NOT NULL
 ,pos INTEGER NOT NULL
 ,stop INTEGER
 ,FOREIGN KEY(stop) REFERENCES stops(id)
 ,PRIMARY KEY(num,company,pos)
 );

BEGIN;

--- tabstops, 1, 50
insert into stops values (1,'Aberlady');
insert into stops values (2,'Abington');
insert into stops values (3,'Amisfield Park');
insert into stops values (4,'Ancrum');
insert into stops values (5,'Armadale');
insert into stops values (6,'ASDA');
insert into stops values (7,'ASDA/Brunstane');
insert into stops values (8,'Auchendinny');
insert into stops values (9,'Baberton');
insert into stops values (10,'Balerno');
insert into stops values (11,'Balerno Church');
insert into stops values (12,'Ballingry');
insert into stops values (13,'Barnton');
insert into stops values (14,'Bathgate');
insert into stops values (15,'Bellevue');
insert into stops values (16,'Berwick upon Tweed');
insert into stops values (17,'Biggar');
insert into stops values (18,'Bilston');
insert into stops values (19,'Bingham');
insert into stops values (20,'Blackburn');
insert into stops values (21,'Blackford');
insert into stops values (22,'Blackhall');
insert into stops values (23,'Blackridge');
insert into stops values (24,'Bonaly Avenue');
insert into stops values (25,'Bo???ness'); 
insert into stops values (26,'Bonnington');
insert into stops values (27,'Bonnyrigg');
insert into stops values (28,'Boswall');
insert into stops values (29,'Bridges');
insert into stops values (30,'Bristo');
insert into stops values (31,'Broomhouse');
insert into stops values (32,'Broxburn');
insert into stops values (33,'Brunstane');
insert into stops values (34,'Brunstane/ASDA');
insert into stops values (35,'Bush Estate');
insert into stops values (36,'Cameron Toll');
insert into stops values (37,'Canonmills');
insert into stops values (38,'Captains Road');
insert into stops values (39,'Charlotte Square');
insert into stops values (40,'Charlotte Street');
insert into stops values (41,'City Hospital');
insert into stops values (42,'Clermiston');
insert into stops values (43,'Clerwood');
insert into stops values (44,'Clovenstone');
insert into stops values (45,'Cockburn Crescent');
insert into stops values (46,'Colinton');
insert into stops values (47,'Comely Bank');
insert into stops values (48,'Corstorphine');
insert into stops values (49,'Cowdenbeath');
insert into stops values (50,'Craigentinny');
--- tabstops, 51, 50
insert into stops values (51,'Craighouse Campus');
insert into stops values (52,'Craigleith');
insert into stops values (53,'Craiglockhart');
insert into stops values (54,'Craigmillar');
insert into stops values (55,'Craigour');
insert into stops values (56,'Craigs Road');
insert into stops values (57,'Cramond');
insert into stops values (59,'Crewe Toll');
insert into stops values (60,'Currie');
insert into stops values (61,'Dalgety Bay');
insert into stops values (62,'Dalkeith');
insert into stops values (63,'Dalmahoy');
insert into stops values (64,'Dalmeny');
insert into stops values (65,'Danderhall');
insert into stops values (66,'Davidsons Mains');
insert into stops values (67,'Deanburn');
insert into stops values (68,'Deans Road/Royston Roundabout');
insert into stops values (69,'Deans South');
insert into stops values (70,'Drylaw');
insert into stops values (71,'Duddingston');
insert into stops values (72,'Dumbiedykes');
insert into stops values (73,'Dumfries');
insert into stops values (74,'Dunbar');
insert into stops values (75,'Dunfermline');
insert into stops values (76,'Earlston');
insert into stops values (77,'East Calder');
insert into stops values (78,'East Craigs');
insert into stops values (79,'East Linton');
insert into stops values (80,'Easter Road');
insert into stops values (81,'Eastern General Hospital');
insert into stops values (82,'Eastfield');
insert into stops values (83,'Edinburgh Airport');
insert into stops values (84,'Eskbank');
insert into stops values (85,'Fairmilehead');
insert into stops values (86,'Fala');
insert into stops values (87,'Falkirk');
insert into stops values (88,'Fauldhouse');
insert into stops values (89,'Ferniehill');
insert into stops values (90,'Ferry Road');
insert into stops values (91,'Forth Bridge');
insert into stops values (92,'Fountainbridge');
insert into stops values (93,'Galashiels');
insert into stops values (94,'George IV Bridge');
insert into stops values (95,'George Street');
insert into stops values (96,'Gilmerton');
insert into stops values (97,'Gilmerton  Bridges');
insert into stops values (98,'Gogar Station');
insert into stops values (99,'Goldenacre');
insert into stops values (100,'Gorebridge');
insert into stops values (101,'Gorgie');
--- tabstops, 101, 50
insert into stops values (102,'Gracemount');
insert into stops values (103,'Grange');
insert into stops values (104,'Grangemouth');
insert into stops values (105,'Granton');
insert into stops values (106,'Granton Square');
insert into stops values (107,'Grassmarket');
insert into stops values (108,'Greendykes');
insert into stops values (109,'Gyle');
insert into stops values (110,'Haddington');
insert into stops values (111,'Hailes');
insert into stops values (112,'Hanover Street');
insert into stops values (113,'Harthill');
insert into stops values (114,'Hawick');
insert into stops values (115,'Haymarket');
insert into stops values (116,'High Street');
insert into stops values (117,'Hillend');
insert into stops values (119,'Humbie');
insert into stops values (120,'Hunters Tryst');
insert into stops values (121,'Hyvots Bank');
insert into stops values (122,'Inglis Green Road');
insert into stops values (123,'Innerleithen');
insert into stops values (124,'Inverkeithing');
insert into stops values (125,'Jedburgh');
insert into stops values (126,'Kelso');
insert into stops values (127,'Kelty');
insert into stops values (128,'Kingsknowe');
insert into stops values (129,'Kinnaird Park');
insert into stops values (130,'Kirkliston');
insert into stops values (131,'Kirknewton');
insert into stops values (132,'Knightsridge');
insert into stops values (133,'Lady Neurone');
insert into stops values (134,'Ladywood');
insert into stops values (135,'Lasswade');
insert into stops values (136,'Lauder');
insert into stops values (137,'Leith');
insert into stops values (139,'Leith (Commercial Street)');
insert into stops values (140,'Leith Docks');
insert into stops values (141,'Leith Walk');
insert into stops values (142,'Liberton');
insert into stops values (143,'Linlithgow');
insert into stops values (144,'Linlithgow Cross');
insert into stops values (145,'Livingstone');
insert into stops values (146,'Loanhead');
insert into stops values (147,'Lochend');
insert into stops values (148,'Lochend (Findlay Gardens)');
insert into stops values (149,'London Road');
insert into stops values (150,'London Street');
insert into stops values (151,'Longniddry');
insert into stops values (152,'Longstone');
insert into stops values (153,'Marchmont');
--- tabstops, 151, 50
insert into stops values (154,'Mayfield');
insert into stops values (155,'Meadowfield Drive');
insert into stops values (156,'Melrose');
insert into stops values (157,'Mid Calder');
insert into stops values (158,'Milton Road');
insert into stops values (159,'Moantcastle');
insert into stops values (160,'Morningside');
insert into stops values (161,'Mountcastle');
insert into stops values (162,'Muirhouse');
insert into stops values (163,'Musselburgh');
insert into stops values (164,'Myreside');
insert into stops values (165,'Newbridge');
insert into stops values (166,'Newcraighall');
insert into stops values (167,'Newhaven');
insert into stops values (168,'Newhaven Road');
insert into stops values (169,'Newington');
insert into stops values (170,'Newton Grange');
insert into stops values (171,'Newtongrange');
insert into stops values (172,'Newtongrange Mayfield');
insert into stops values (173,'Niddrie');
insert into stops values (174,'North Berwick');
insert into stops values (175,'North Bridge');
insert into stops values (176,'North Road');
insert into stops values (177,'Northfield');
insert into stops values (178,'Orchard Brae');
insert into stops values (179,'Oxgangs');
insert into stops values (180,'Parkhead');
insert into stops values (181,'Pathhead');
insert into stops values (182,'Peebles');
insert into stops values (183,'Pencaitland');
insert into stops values (184,'Penicuik');
insert into stops values (185,'Philipstoun');
insert into stops values (186,'Pilrig -Princes Street');
insert into stops values (187,'Pinkie');
insert into stops values (188,'Polmont');
insert into stops values (189,'Polton Mill');
insert into stops values (190,'Port Seton');
insert into stops values (191,'Portobello');
insert into stops values (192,'Prestonfield');
insert into stops values (193,'Prestonpans');
insert into stops values (194,'Princes Street');
insert into stops values (195,'Pumpherston');
insert into stops values (196,'Queensferry Road');
insert into stops values (197,'Ratho');
insert into stops values (198,'Ravelston');
insert into stops values (199,'Regent Road');
insert into stops values (200,'Restalrig');
insert into stops values (201,'Riccarton Campus');
insert into stops values (202,'Rosewell');
insert into stops values (203,'Roslin');
--- tabstops, 201, 50
insert into stops values (204,'Rosyth');
insert into stops values (205,'Royal Mile');
insert into stops values (206,'Royston');
insert into stops values (207,'Saughton');
insert into stops values (208,'Scotstoun');
insert into stops values (209,'Seafield');
insert into stops values (210,'Seafield Garage');
insert into stops values (211,'Selkirk');
insert into stops values (212,'Seton Sands');
insert into stops values (213,'Sighthill');
insert into stops values (215,'Silverknowes');
insert into stops values (216,'Slateford');
insert into stops values (217,'South Gyle');
insert into stops values (218,'South Queensferry');
insert into stops values (219,'St Andrew Square');
insert into stops values (220,'St Boswells');
insert into stops values (221,'St John''s Hospital');
insert into stops values (222,'St Leonards');
insert into stops values (223,'Stenhouse');
insert into stops values (224,'Stirling');
insert into stops values (225,'Stockbridge');
insert into stops values (226,'Stoneybank');
insert into stops values (227,'Stow');
insert into stops values (228,'Straiton Road Sainsbury');
insert into stops values (229,'Thornhill');
insert into stops values (230,'Tollcross');
insert into stops values (231,'Torphin');
insert into stops values (232,'Trances');
insert into stops values (233,'Tranent');
insert into stops values (234,'Trinity');
insert into stops values (235,'Turnhouse');
insert into stops values (236,'Uphall');
insert into stops values (237,'Wallyford');
insert into stops values (238,'Wallyford');
insert into stops values (239,'Wardie');
insert into stops values (240,'Waverley Bridge');
insert into stops values (241,'West Linton');
insert into stops values (242,'West Mains');
insert into stops values (243,'Westburn');
insert into stops values (244,'Wester Hailes');
insert into stops values (245,'Wester Hailes Centre');
insert into stops values (246,'Whitburn');
insert into stops values (247,'Whitecraig');
insert into stops values (248,'Wilkieston');
insert into stops values (249,'Willowbrae');
insert into stops values (250,'Winchburgh');
--- tabroute, 1, 50
insert into route values ('1','LRT',1,137);
insert into route values ('1','LRT',2,99);
insert into route values ('1','LRT',3,59);
insert into route values ('1','LRT',4,66);
insert into route values ('1','LRT',5,42);
insert into route values ('1','LRT',6,48);
insert into route values ('1','LRT',7,223);
insert into route values ('1','LRT',8,92);
insert into route values ('1','LRT',9,205);
insert into route values ('1','LRT',10,80);
insert into route values ('1','LRT',11,137);
insert into route values ('2','LRT',1,173);
insert into route values ('2','LRT',2,191);
insert into route values ('2','LRT',3,50);
insert into route values ('2','LRT',4,137);
insert into route values ('2','LRT',5,141);
insert into route values ('2','LRT',6,194);
insert into route values ('2','LRT',7,115);
insert into route values ('2','LRT',8,48);
insert into route values ('2','LRT',9,31);
insert into route values ('2','LRT',10,31);
insert into route values ('2','LRT',11,223);
insert into route values ('2','LRT',12,101);
insert into route values ('2','LRT',13,115);
insert into route values ('2','LRT',14,107);
insert into route values ('2','LRT',15,192);
insert into route values ('2','LRT',16,54);
insert into route values ('2','LRT',17,173);
insert into route values ('2A','LRT',1,173);
insert into route values ('2A','LRT',2,191);
insert into route values ('2A','LRT',3,50);
insert into route values ('2A','LRT',4,137);
insert into route values ('2A','LRT',5,141);
insert into route values ('2A','LRT',6,194);
insert into route values ('2A','LRT',7,115);
insert into route values ('2A','LRT',8,48);
insert into route values ('2A','LRT',9,31);
insert into route values ('2A','LRT',10,109);
insert into route values ('2A','LRT',11,31);
insert into route values ('2A','LRT',12,223);
insert into route values ('2A','LRT',13,101);
insert into route values ('2A','LRT',14,115);
insert into route values ('2A','LRT',15,107);
insert into route values ('2A','LRT',16,192);
insert into route values ('2A','LRT',17,54);
insert into route values ('2A','LRT',18,173);
insert into route values ('3','LRT',1,154);
insert into route values ('3','LRT',2,62);
insert into route values ('3','LRT',3,97);
insert into route values ('3','LRT',4,194);
--- tabroute, 51, 50
insert into route values ('3','LRT',5,115);
insert into route values ('3','LRT',6,101);
insert into route values ('3','LRT',7,213);
insert into route values ('3','LRT',8,244);
insert into route values ('3','LRT',9,44);
insert into route values ('3A','LRJ',1,100);
insert into route values ('3A','LRJ',2,172);
insert into route values ('3A','LRJ',3,62);
insert into route values ('3A','LRJ',4,65);
insert into route values ('3A','LRJ',5,29);
insert into route values ('3A','LRJ',6,194);
insert into route values ('3A','LRJ',7,115);
insert into route values ('3A','LRJ',8,101);
insert into route values ('3A','LRJ',9,213);
insert into route values ('3A','LRJ',10,244);
insert into route values ('3A','LRJ',11,44);
insert into route values ('4','LRT',1,19);
insert into route values ('4','LRT',2,177);
insert into route values ('4','LRT',3,149);
insert into route values ('4','LRT',4,194);
insert into route values ('4','LRT',5,115);
insert into route values ('4','LRT',6,53);
insert into route values ('4','LRT',7,179);
insert into route values ('4','LRT',8,85);
insert into route values ('4','LRT',9,117);
insert into route values ('5','LRT',1,24);
insert into route values ('5','LRT',2,46);
insert into route values ('5','LRT',3,179);
insert into route values ('5','LRT',4,160);
insert into route values ('5','LRT',5,103);
insert into route values ('5','LRT',6,29);
insert into route values ('5','LRT',7,149);
insert into route values ('5','LRT',8,177);
insert into route values ('5','LRT',9,161);
insert into route values ('5','LRT',10,34);
insert into route values ('6','LRT',1,137);
insert into route values ('6','LRT',2,80);
insert into route values ('6','LRT',3,205);
insert into route values ('6','LRT',4,92);
insert into route values ('6','LRT',5,48);
insert into route values ('6','LRT',6,223);
insert into route values ('6','LRT',7,42);
insert into route values ('6','LRT',8,66);
insert into route values ('6','LRT',9,59);
insert into route values ('6','LRT',10,99);
insert into route values ('6','LRT',11,137);
insert into route values ('7','LRT',1,167);
insert into route values ('7','LRT',2,137);
insert into route values ('7','LRT',3,141);
insert into route values ('7','LRT',4,29);
--- tabroute, 101, 50
insert into route values ('7','LRT',5,142);
insert into route values ('7','LRT',6,102);
insert into route values ('7','LRT',7,38);
insert into route values ('7A','LRT',1,206);
insert into route values ('7A','LRT',2,239);
insert into route values ('7A','LRT',3,99);
insert into route values ('7A','LRT',4,37);
insert into route values ('7A','LRT',5,15);
insert into route values ('7A','LRT',6,29);
insert into route values ('7A','LRT',7,142);
insert into route values ('7A','LRT',8,102);
insert into route values ('7A','LRT',9,38);
insert into route values ('8','LRT',1,96);
insert into route values ('8','LRT',2,29);
insert into route values ('8','LRT',3,15);
insert into route values ('8','LRT',4,37);
insert into route values ('8','LRT',5,99);
insert into route values ('8','LRT',6,105);
insert into route values ('8','LRT',7,162);
insert into route values ('8','LRT',8,215);
insert into route values ('9','LRT',1,121);
insert into route values ('9','LRT',2,96);
insert into route values ('9','LRT',3,29);
insert into route values ('9','LRT',4,15);
insert into route values ('9','LRT',5,37);
insert into route values ('9','LRT',6,99);
insert into route values ('9','LRT',7,105);
insert into route values ('9','LRT',8,162);
insert into route values ('9','LRT',9,215);
insert into route values ('10','LRT',1,215);
insert into route values ('10','LRT',2,162);
insert into route values ('10','LRT',3,167);
insert into route values ('10','LRT',4,137);
insert into route values ('10','LRT',5,141);
insert into route values ('10','LRT',6,194);
insert into route values ('10','LRT',7,230);
insert into route values ('10','LRT',8,53);
insert into route values ('10','LRT',9,46);
insert into route values ('10','LRT',10,231);
insert into route values ('11','LRT',1,167);
insert into route values ('11','LRT',2,186);
insert into route values ('11','LRT',3,230);
insert into route values ('11','LRT',4,160);
insert into route values ('11','LRT',5,85);
insert into route values ('11','LRT',6,38);
insert into route values ('12','LRT',1,173);
insert into route values ('12','LRT',2,54);
insert into route values ('12','LRT',3,192);
insert into route values ('12','LRT',4,107);
insert into route values ('12','LRT',5,115);
--- tabroute, 151, 50
insert into route values ('12','LRT',6,101);
insert into route values ('12','LRT',7,223);
insert into route values ('12','LRT',8,31);
insert into route values ('12','LRT',9,109);
insert into route values ('12','LRT',10,31);
insert into route values ('12','LRT',11,48);
insert into route values ('12','LRT',12,115);
insert into route values ('12','LRT',13,194);
insert into route values ('12','LRT',14,141);
insert into route values ('12','LRT',15,137);
insert into route values ('12','LRT',16,50);
insert into route values ('12','LRT',17,191);
insert into route values ('12','LRT',18,173);
insert into route values ('13','LRT',1,148);
insert into route values ('13','LRT',2,80);
insert into route values ('13','LRT',3,150);
insert into route values ('13','LRT',4,39);
insert into route values ('13','LRT',5,198);
insert into route values ('13','LRT',6,22);
insert into route values ('14','LRT',1,215);
insert into route values ('14','LRT',2,162);
insert into route values ('14','LRT',3,28);
insert into route values ('14','LRT',4,99);
insert into route values ('14','LRT',5,137);
insert into route values ('14','LRT',6,141);
insert into route values ('14','LRT',7,29);
insert into route values ('14','LRT',8,192);
insert into route values ('14','LRT',9,54);
insert into route values ('14','LRT',10,173);
insert into route values ('14','LRT',11,166);
insert into route values ('14','LRT',12,215);
insert into route values ('15','LRT',1,226);
insert into route values ('15','LRT',2,163);
insert into route values ('15','LRT',3,82);
insert into route values ('15','LRT',4,191);
insert into route values ('15','LRT',5,149);
insert into route values ('15','LRT',6,194);
insert into route values ('15','LRT',7,230);
insert into route values ('15','LRT',8,160);
insert into route values ('15','LRT',9,85);
insert into route values ('16','LRT',1,167);
insert into route values ('16','LRT',2,140);
insert into route values ('16','LRT',3,141);
insert into route values ('16','LRT',4,194);
insert into route values ('16','LRT',5,230);
insert into route values ('16','LRT',6,160);
insert into route values ('16','LRT',7,179);
insert into route values ('16','LRT',8,120);
insert into route values ('16','SMT',1,219);
insert into route values ('16','SMT',2,48);
--- tabroute, 201, 50
insert into route values ('16','SMT',3,109);
insert into route values ('16','SMT',4,165);
insert into route values ('16','SMT',5,32);
insert into route values ('16','SMT',6,236);
insert into route values ('16','SMT',7,14);
insert into route values ('16','SMT',8,5);
insert into route values ('16','SMT',9,23);
insert into route values ('17','LRT',1,167);
insert into route values ('17','LRT',2,137);
insert into route values ('17','LRT',3,141);
insert into route values ('17','LRT',4,194);
insert into route values ('17','LRT',5,230);
insert into route values ('17','LRT',6,160);
insert into route values ('17','LRT',7,179);
insert into route values ('18','SMT',1,219);
insert into route values ('18','SMT',2,48);
insert into route values ('18','SMT',3,109);
insert into route values ('18','SMT',4,165);
insert into route values ('18','SMT',5,32);
insert into route values ('18','SMT',6,236);
insert into route values ('18','SMT',7,14);
insert into route values ('18','SMT',8,246);
insert into route values ('19','SMT',1,14);
insert into route values ('19','SMT',2,68);
insert into route values ('19','SMT',3,69);
insert into route values ('19','SMT',4,132);
insert into route values ('19','SMT',5,236);
insert into route values ('19','SMT',6,32);
insert into route values ('19','SMT',7,165);
insert into route values ('19','SMT',8,48);
insert into route values ('19','SMT',9,219);
insert into route values ('19','LRT',1,28);
insert into route values ('19','LRT',2,59);
insert into route values ('19','LRT',3,47);
insert into route values ('19','LRT',4,178);
insert into route values ('19','LRT',5,39);
insert into route values ('19','LRT',6,95);
insert into route values ('19','LRT',7,15);
insert into route values ('19','LRT',8,37);
insert into route values ('19','LRT',9,99);
insert into route values ('19','LRT',10,28);
insert into route values ('19A','LRT',1,28);
insert into route values ('19A','LRT',2,59);
insert into route values ('19A','LRT',3,47);
insert into route values ('19A','LRT',4,95);
insert into route values ('19A','LRT',5,37);
insert into route values ('19A','LRT',6,99);
insert into route values ('19A','LRT',7,28);
insert into route values ('20','LRT',1,105);
insert into route values ('20','LRT',2,59);
--- tabroute, 251, 50
insert into route values ('20','LRT',3,225);
insert into route values ('20','LRT',4,95);
insert into route values ('20','LRT',5,149);
insert into route values ('20','LRT',6,147);
insert into route values ('20','LRT',7,200);
insert into route values ('20','LRT',8,191);
insert into route values ('20','LRT',9,82);
insert into route values ('21','LRT',1,109);
insert into route values ('21','LRT',2,31);
insert into route values ('21','LRT',3,223);
insert into route values ('21','LRT',4,101);
insert into route values ('21','LRT',5,115);
insert into route values ('21','LRT',6,194);
insert into route values ('21','LRT',7,29);
insert into route values ('21','LRT',8,222);
insert into route values ('21','LRT',9,192);
insert into route values ('21','LRT',10,54);
insert into route values ('21','LRT',11,108);
insert into route values ('22','LRT',1,167);
insert into route values ('22','LRT',2,137);
insert into route values ('22','LRT',3,141);
insert into route values ('22','LRT',4,219);
insert into route values ('22','LRT',5,115);
insert into route values ('22','LRT',6,101);
insert into route values ('22','LRT',7,223);
insert into route values ('22','LRT',8,213);
insert into route values ('22A','LRT',1,139);
insert into route values ('22A','LRT',2,141);
insert into route values ('22A','LRT',3,219);
insert into route values ('22A','LRT',4,115);
insert into route values ('22A','LRT',5,101);
insert into route values ('22A','LRT',6,223);
insert into route values ('22A','LRT',7,213);
insert into route values ('22A','LRT',8,201);
insert into route values ('23','LRT',1,234);
insert into route values ('23','LRT',2,37);
insert into route values ('23','LRT',3,112);
insert into route values ('23','LRT',4,230);
insert into route values ('23','LRT',5,160);
insert into route values ('23','LRT',6,51);
insert into route values ('24','LRT',1,80);
insert into route values ('24','LRT',2,219);
insert into route values ('24','LRT',3,230);
insert into route values ('24','LRT',4,153);
insert into route values ('24','LRT',5,21);
insert into route values ('24','LRT',6,36);
insert into route values ('25','LRT',1,167);
insert into route values ('25','LRT',2,168);
insert into route values ('25','LRT',3,137);
insert into route values ('25','LRT',4,141);
--- tabroute, 301, 50
insert into route values ('25','LRT',5,219);
insert into route values ('25','LRT',6,115);
insert into route values ('25','LRT',7,101);
insert into route values ('25','LRT',8,223);
insert into route values ('25','LRT',9,213);
insert into route values ('26','LRT',1,43);
insert into route values ('26','LRT',2,42);
insert into route values ('26','LRT',3,48);
insert into route values ('26','LRT',4,115);
insert into route values ('26','LRT',5,194);
insert into route values ('26','LRT',6,199);
insert into route values ('26','LRT',7,191);
insert into route values ('26','LRT',8,82);
insert into route values ('26','LRT',9,163);
insert into route values ('26','LRT',10,193);
insert into route values ('26','LRT',11,190);
insert into route values ('26','LRT',12,212);
insert into route values ('26A','LRT',1,43);
insert into route values ('26A','LRT',2,42);
insert into route values ('26A','LRT',3,48);
insert into route values ('26A','LRT',4,115);
insert into route values ('26A','LRT',5,194);
insert into route values ('26A','LRT',6,149);
insert into route values ('26A','LRT',7,191);
insert into route values ('26A','LRT',8,82);
insert into route values ('26A','LRT',9,163);
insert into route values ('26A','LRT',10,193);
insert into route values ('26A','LRT',11,233);
insert into route values ('27','LRT',1,215);
insert into route values ('27','LRT',2,59);
insert into route values ('27','LRT',3,37);
insert into route values ('27','LRT',4,112);
insert into route values ('27','LRT',5,230);
insert into route values ('27','LRT',6,53);
insert into route values ('27','LRT',7,179);
insert into route values ('27','LRT',8,120);
insert into route values ('27','MID',1,246);
insert into route values ('27','MID',2,20);
insert into route values ('27','MID',3,145);
insert into route values ('27','MID',4,157);
insert into route values ('27','MID',5,77);
insert into route values ('27','MID',6,213);
insert into route values ('27','MID',7,219);
insert into route values ('28','LRT',1,162);
insert into route values ('28','LRT',2,70);
insert into route values ('28','LRT',3,59);
insert into route values ('28','LRT',4,47);
insert into route values ('28','LRT',5,112);
insert into route values ('28','LRT',6,92);
insert into route values ('28','LRT',7,152);
--- tabroute, 351, 50
insert into route values ('28','LRT',8,244);
insert into route values ('28','LRT',9,44);
insert into route values ('29','LOW',1,219);
insert into route values ('29','LOW',2,65);
insert into route values ('29','LOW',3,62);
insert into route values ('29','LOW',4,181);
insert into route values ('29','LOW',5,136);
insert into route values ('29','LOW',6,76);
insert into route values ('29','LOW',7,220);
insert into route values ('29','LOW',8,4);
insert into route values ('29','LOW',9,125);
insert into route values ('30','LOW',1,219);
insert into route values ('30','LOW',2,65);
insert into route values ('30','LOW',3,62);
insert into route values ('30','LOW',4,181);
insert into route values ('30','LOW',5,136);
insert into route values ('30','LOW',6,76);
insert into route values ('30','LOW',7,220);
insert into route values ('30','LOW',8,126);
insert into route values ('30','LRT',1,100);
insert into route values ('30','LRT',2,170);
insert into route values ('30','LRT',3,154);
insert into route values ('30','LRT',4,62);
insert into route values ('30','LRT',5,65);
insert into route values ('30','LRT',6,29);
insert into route values ('30','LRT',7,194);
insert into route values ('30','LRT',8,115);
insert into route values ('30','LRT',9,101);
insert into route values ('30','LRT',10,213);
insert into route values ('30','LRT',11,244);
insert into route values ('30','LRT',12,44);
insert into route values ('31','LRT',1,89);
insert into route values ('31','LRT',2,96);
insert into route values ('31','LRT',3,121);
insert into route values ('31','LRT',4,142);
insert into route values ('31','LRT',5,29);
insert into route values ('31','LRT',6,194);
insert into route values ('31','LRT',7,115);
insert into route values ('31','LRT',8,48);
insert into route values ('31','LRT',9,78);
insert into route values ('32','LRT',1,173);
insert into route values ('32','LRT',2,33);
insert into route values ('32','LRT',3,191);
insert into route values ('32','LRT',4,50);
insert into route values ('32','LRT',5,200);
insert into route values ('32','LRT',6,137);
insert into route values ('32','LRT',7,167);
insert into route values ('32','LRT',8,105);
insert into route values ('32','LRT',9,162);
insert into route values ('32','LRT',10,70);
--- tabroute, 401, 50
insert into route values ('32','LRT',11,42);
insert into route values ('32','LRT',12,48);
insert into route values ('32','LRT',13,31);
insert into route values ('32','LRT',14,213);
insert into route values ('32','LRT',15,244);
insert into route values ('32','LRT',16,46);
insert into route values ('32','LRT',17,179);
insert into route values ('32','LRT',18,85);
insert into route values ('32','LRT',19,121);
insert into route values ('32','LRT',20,96);
insert into route values ('32','LRT',21,36);
insert into route values ('32','LRT',22,54);
insert into route values ('32','LRT',23,173);
insert into route values ('33','LRT',1,89);
insert into route values ('33','LRT',2,36);
insert into route values ('33','LRT',3,29);
insert into route values ('33','LRT',4,194);
insert into route values ('33','LRT',5,115);
insert into route values ('33','LRT',6,101);
insert into route values ('33','LRT',7,152);
insert into route values ('33','LRT',8,245);
insert into route values ('33','LRT',9,243);
insert into route values ('33','LRT',10,9);
insert into route values ('34','LRT',1,213);
insert into route values ('34','LRT',2,101);
insert into route values ('34','LRT',3,92);
insert into route values ('34','LRT',4,39);
insert into route values ('34','LRT',5,225);
insert into route values ('34','LRT',6,37);
insert into route values ('34','LRT',7,26);
insert into route values ('34','LRT',8,137);
insert into route values ('34','LRT',9,147);
insert into route values ('34','LRT',10,149);
insert into route values ('34','LRT',11,176);
insert into route values ('34','LRT',12,116);
insert into route values ('34','LRT',13,92);
insert into route values ('34','LRT',14,152);
insert into route values ('34','LRT',15,213);
insert into route values ('35','LRT',1,213);
insert into route values ('35','LRT',2,152);
insert into route values ('35','LRT',3,92);
insert into route values ('35','LRT',4,116);
insert into route values ('35','LRT',5,176);
insert into route values ('35','LRT',6,149);
insert into route values ('35','LRT',7,147);
insert into route values ('35','LRT',8,137);
insert into route values ('35','LRT',9,26);
insert into route values ('35','LRT',10,37);
insert into route values ('35','LRT',11,225);
insert into route values ('35','LRT',12,39);
--- tabroute, 451, 50
insert into route values ('35','LRT',13,92);
insert into route values ('35','LRT',14,101);
insert into route values ('35','LRT',15,213);
insert into route values ('36','LRT',1,109);
insert into route values ('36','LRT',2,48);
insert into route values ('36','LRT',3,115);
insert into route values ('36','LRT',4,194);
insert into route values ('36','LRT',5,29);
insert into route values ('36','LRT',6,36);
insert into route values ('36','LRT',7,55);
insert into route values ('37','LRT',1,105);
insert into route values ('37','LRT',2,37);
insert into route values ('37','LRT',3,112);
insert into route values ('37','LRT',4,230);
insert into route values ('37','LRT',5,160);
insert into route values ('37','LRT',6,51);
insert into route values ('37','SMT',1,219);
insert into route values ('37','SMT',2,115);
insert into route values ('37','SMT',3,48);
insert into route values ('37','SMT',4,98);
insert into route values ('37','SMT',5,197);
insert into route values ('37','SMT',6,131);
insert into route values ('37','SMT',7,77);
insert into route values ('37','SMT',8,157);
insert into route values ('37','SMT',9,145);
insert into route values ('38','LRT',1,192);
insert into route values ('38','LRT',2,36);
insert into route values ('38','LRT',3,242);
insert into route values ('38','LRT',4,21);
insert into route values ('38','LRT',5,160);
insert into route values ('38','LRT',6,164);
insert into route values ('38','LRT',7,101);
insert into route values ('38','LRT',8,198);
insert into route values ('38','LRT',9,52);
insert into route values ('38','LRT',10,59);
insert into route values ('38','MID',1,219);
insert into route values ('38','MID',2,115);
insert into route values ('38','MID',3,48);
insert into route values ('38','MID',4,109);
insert into route values ('38','MID',5,165);
insert into route values ('38','MID',6,130);
insert into route values ('38','MID',7,250);
insert into route values ('38','MID',8,143);
insert into route values ('38','MID',9,188);
insert into route values ('38','MID',10,87);
insert into route values ('38','MID',11,224);
insert into route values ('40','LRT',1,21);
insert into route values ('40','LRT',2,153);
insert into route values ('40','LRT',3,112);
insert into route values ('40','LRT',4,40);
--- tabroute, 501, 50
insert into route values ('40','LRT',5,196);
insert into route values ('40','LRT',6,66);
insert into route values ('40','LRT',7,57);
insert into route values ('41','LRT',1,41);
insert into route values ('41','LRT',2,160);
insert into route values ('41','LRT',3,21);
insert into route values ('41','LRT',4,153);
insert into route values ('41','LRT',5,112);
insert into route values ('41','LRT',6,39);
insert into route values ('41','LRT',7,196);
insert into route values ('41','LRT',8,66);
insert into route values ('41','LRT',9,13);
insert into route values ('41','LRT',10,57);
insert into route values ('42','LRT',1,36);
insert into route values ('42','LRT',2,54);
insert into route values ('42','LRT',3,71);
insert into route values ('42','LRT',4,191);
insert into route values ('42','LRT',5,50);
insert into route values ('42','LRT',6,147);
insert into route values ('42','LRT',7,149);
insert into route values ('42','LRT',8,219);
insert into route values ('42','LRT',9,242);
insert into route values ('42','LRT',10,36);
insert into route values ('43','SMT',1,219);
insert into route values ('43','SMT',2,196);
insert into route values ('43','SMT',3,13);
insert into route values ('43','SMT',4,64);
insert into route values ('43','SMT',5,218);
insert into route values ('43','SMT',6,208);
insert into route values ('43','LRT',1,237);
insert into route values ('43','LRT',2,163);
insert into route values ('43','LRT',3,158);
insert into route values ('43','LRT',4,149);
insert into route values ('43','LRT',5,194);
insert into route values ('43','LRT',6,115);
insert into route values ('43','LRT',7,216);
insert into route values ('43','LRT',8,128);
insert into route values ('43','LRT',9,60);
insert into route values ('43','LRT',10,10);
insert into route values ('43','LRT',11,11);
insert into route values ('43','LRT',12,45);
insert into route values ('44','LRT',1,45);
insert into route values ('44','LRT',2,11);
insert into route values ('44','LRT',3,10);
insert into route values ('44','LRT',4,60);
insert into route values ('44','LRT',5,128);
insert into route values ('44','LRT',6,216);
insert into route values ('44','LRT',7,115);
insert into route values ('44','LRT',8,194);
insert into route values ('44','LRT',9,149);
--- tabroute, 551, 50
insert into route values ('44','LRT',10,158);
insert into route values ('44','LRT',11,163);
insert into route values ('44','LRT',12,238);
insert into route values ('45','LRT',1,33);
insert into route values ('45','LRT',2,71);
insert into route values ('45','LRT',3,177);
insert into route values ('45','LRT',4,149);
insert into route values ('45','LRT',5,112);
insert into route values ('45','LRT',6,230);
insert into route values ('45','LRT',7,53);
insert into route values ('45','LRT',8,46);
insert into route values ('45','LRT',9,60);
insert into route values ('45','LRT',10,201);
insert into route values ('46A','LRT',1,36);
insert into route values ('46A','LRT',2,242);
insert into route values ('46A','LRT',3,219);
insert into route values ('46A','LRT',4,149);
insert into route values ('46A','LRT',5,147);
insert into route values ('46A','LRT',6,50);
insert into route values ('46A','LRT',7,191);
insert into route values ('46A','LRT',8,71);
insert into route values ('46A','LRT',9,54);
insert into route values ('46A','LRT',10,36);
insert into route values ('47','LRT',1,37);
insert into route values ('47','LRT',2,112);
insert into route values ('47','LRT',3,230);
insert into route values ('47','LRT',4,53);
insert into route values ('47','LRT',5,46);
insert into route values ('47','LRT',6,60);
insert into route values ('47','LRT',7,10);
insert into route values ('47','LRT',8,45);
insert into route values ('47','LRT',9,11);
insert into route values ('47','MID',1,219);
insert into route values ('47','MID',2,196);
insert into route values ('47','MID',3,13);
insert into route values ('47','MID',4,64);
insert into route values ('47','MID',5,218);
insert into route values ('47','MID',6,25);
insert into route values ('47','MID',7,104);
insert into route values ('47','MID',8,87);
insert into route values ('48','WIL',1,48);
insert into route values ('48','WIL',2,56);
insert into route values ('48','WIL',3,109);
insert into route values ('48','WIL',4,235);
insert into route values ('49','SMT',1,191);
insert into route values ('49','SMT',2,177);
insert into route values ('49','SMT',3,249);
insert into route values ('49','SMT',4,155);
insert into route values ('49','SMT',5,133);
insert into route values ('51','LRT',1,160);
--- tabroute, 601, 50
insert into route values ('51','LRT',2,103);
insert into route values ('51','LRT',3,29);
insert into route values ('51','LRT',4,149);
insert into route values ('51','LRT',5,177);
insert into route values ('51','LRT',6,159);
insert into route values ('51','LRT',7,7);
insert into route values ('52','LRT',1,173);
insert into route values ('52','LRT',2,54);
insert into route values ('52','LRT',3,36);
insert into route values ('52','LRT',4,96);
insert into route values ('52','LRT',5,121);
insert into route values ('52','LRT',6,85);
insert into route values ('52','LRT',7,179);
insert into route values ('52','LRT',8,46);
insert into route values ('52','LRT',9,244);
insert into route values ('52','LRT',10,213);
insert into route values ('52','LRT',11,31);
insert into route values ('52','LRT',12,48);
insert into route values ('52','LRT',13,42);
insert into route values ('52','LRT',14,70);
insert into route values ('52','LRT',15,162);
insert into route values ('52','LRT',16,105);
insert into route values ('52','LRT',17,167);
insert into route values ('52','LRT',18,137);
insert into route values ('52','LRT',19,200);
insert into route values ('52','LRT',20,191);
insert into route values ('52','LRT',21,50);
insert into route values ('52','LRT',22,33);
insert into route values ('52','LRT',23,173);
insert into route values ('53','FS',1,175);
insert into route values ('53','FS',2,94);
insert into route values ('53','FS',3,39);
insert into route values ('53','FS',4,22);
insert into route values ('53','FS',5,13);
insert into route values ('53','FS',6,91);
insert into route values ('53','FS',7,124);
insert into route values ('53','FS',8,61);
insert into route values ('55','FS',1,219);
insert into route values ('55','FS',2,196);
insert into route values ('55','FS',3,13);
insert into route values ('55','FS',4,91);
insert into route values ('55','FS',5,124);
insert into route values ('55','FS',6,204);
insert into route values ('55','FS',7,75);
insert into route values ('55','FS',8,127);
insert into route values ('55','LRT',1,215);
insert into route values ('55','LRT',2,59);
insert into route values ('55','LRT',3,47);
insert into route values ('55','LRT',4,219);
insert into route values ('56','FF',1,219);
--- tabroute, 651, 50
insert into route values ('56','FF',2,196);
insert into route values ('56','FF',3,13);
insert into route values ('56','FF',4,91);
insert into route values ('56','FF',5,75);
insert into route values ('56','FF',6,49);
insert into route values ('56','FF',7,12);
insert into route values ('58','LRT',1,109);
insert into route values ('58','LRT',2,217);
insert into route values ('58','LRT',3,111);
insert into route values ('58','LRT',4,128);
insert into route values ('58','LRT',5,122);
insert into route values ('59','LRT',1,109);
insert into route values ('59','LRT',2,217);
insert into route values ('59','LRT',3,245);
insert into route values ('60','JM',1,72);
insert into route values ('60','JM',2,30);
insert into route values ('61','LRT',1,219);
insert into route values ('61','LRT',2,115);
insert into route values ('61','LRT',3,101);
insert into route values ('61','LRT',4,213);
insert into route values ('61','LRT',5,60);
insert into route values ('61','SMT',1,219);
insert into route values ('61','SMT',2,115);
insert into route values ('61','SMT',3,101);
insert into route values ('61','SMT',4,213);
insert into route values ('61','SMT',5,201);
insert into route values ('62','LOW',1,219);
insert into route values ('62','LOW',2,142);
insert into route values ('62','LOW',3,18);
insert into route values ('62','LOW',4,184);
insert into route values ('62','LOW',5,182);
insert into route values ('62','LOW',6,123);
insert into route values ('62','LOW',7,93);
insert into route values ('62','LOW',8,156);
insert into route values ('63','LRT',1,6);
insert into route values ('63','LRT',2,33);
insert into route values ('63','LRT',3,159);
insert into route values ('63','LRT',4,177);
insert into route values ('63','LRT',5,149);
insert into route values ('63','LRT',6,219);
insert into route values ('63','LRT',7,115);
insert into route values ('63','LRT',8,48);
insert into route values ('63','LRT',9,31);
insert into route values ('63','LRT',10,109);
insert into route values ('64','SMT',1,39);
insert into route values ('64','SMT',2,95);
insert into route values ('64','SMT',3,219);
insert into route values ('64','SMT',4,29);
insert into route values ('64','SMT',5,142);
insert into route values ('64','SMT',6,18);
--- tabroute, 701, 50
insert into route values ('64','SMT',7,184);
insert into route values ('64','SMT',8,134);
insert into route values ('64A','SMT',1,39);
insert into route values ('64A','SMT',2,95);
insert into route values ('64A','SMT',3,219);
insert into route values ('64A','SMT',4,29);
insert into route values ('64A','SMT',5,142);
insert into route values ('64A','SMT',6,146);
insert into route values ('64A','SMT',7,18);
insert into route values ('64A','SMT',8,184);
insert into route values ('64A','SMT',9,134);
insert into route values ('65','LRT',1,200);
insert into route values ('65','LRT',2,147);
insert into route values ('65','LRT',3,149);
insert into route values ('65','LRT',4,194);
insert into route values ('65','LRT',5,115);
insert into route values ('65','LRT',6,101);
insert into route values ('65','LRT',7,213);
insert into route values ('65','LRT',8,201);
insert into route values ('65','SMT',1,39);
insert into route values ('65','SMT',2,219);
insert into route values ('65','SMT',3,29);
insert into route values ('65','SMT',4,142);
insert into route values ('65','SMT',5,146);
insert into route values ('65','SMT',6,18);
insert into route values ('65','SMT',7,203);
insert into route values ('65','SMT',8,184);
insert into route values ('65','SMT',9,67);
insert into route values ('66','SMT',1,237);
insert into route values ('66','SMT',2,163);
insert into route values ('66','SMT',3,191);
insert into route values ('66','SMT',4,149);
insert into route values ('66','SMT',5,194);
insert into route values ('66','SMT',6,115);
insert into route values ('66','SMT',7,216);
insert into route values ('66','SMT',8,128);
insert into route values ('66','SMT',9,60);
insert into route values ('66','SMT',10,10);
insert into route values ('66','SMT',11,45);
insert into route values ('66A','SMT',1,212);
insert into route values ('66A','SMT',2,190);
insert into route values ('66A','SMT',3,193);
insert into route values ('66A','SMT',4,163);
insert into route values ('66A','SMT',5,191);
insert into route values ('66A','SMT',6,149);
insert into route values ('66A','SMT',7,194);
insert into route values ('66A','SMT',8,115);
insert into route values ('66A','SMT',9,216);
insert into route values ('66A','SMT',10,128);
insert into route values ('66A','SMT',11,60);
--- tabroute, 751, 50
insert into route values ('66A','SMT',12,10);
insert into route values ('66A','SMT',13,45);
insert into route values ('69','LRT',1,42);
insert into route values ('69','LRT',2,48);
insert into route values ('69','LRT',3,115);
insert into route values ('69','LRT',4,194);
insert into route values ('69','LRT',5,29);
insert into route values ('69','LRT',6,55);
insert into route values ('74','SMT',1,115);
insert into route values ('74','SMT',2,194);
insert into route values ('74','SMT',3,29);
insert into route values ('74','SMT',4,142);
insert into route values ('74','SMT',5,146);
insert into route values ('74','SMT',6,135);
insert into route values ('74','SMT',7,189);
insert into route values ('74','SMT',8,27);
insert into route values ('74','SMT',9,62);
insert into route values ('75','LRT',1,115);
insert into route values ('75','LRT',2,194);
insert into route values ('75','LRT',3,149);
insert into route values ('75','LRT',4,158);
insert into route values ('75','LRT',5,163);
insert into route values ('75','LRT',6,226);
insert into route values ('75','LRT',7,209);
insert into route values ('77','SMT',1,115);
insert into route values ('77','SMT',2,29);
insert into route values ('77','SMT',3,142);
insert into route values ('77','SMT',4,27);
insert into route values ('77','SMT',5,189);
insert into route values ('79','SMT',1,39);
insert into route values ('79','SMT',2,194);
insert into route values ('79','SMT',3,29);
insert into route values ('79','SMT',4,36);
insert into route values ('79','SMT',5,65);
insert into route values ('79','SMT',6,62);
insert into route values ('79','SMT',7,84);
insert into route values ('79','SMT',8,27);
insert into route values ('79','SMT',9,189);
insert into route values ('79','SMT',10,202);
insert into route values ('80','LRT',1,189);
insert into route values ('80','LRT',2,27);
insert into route values ('80','LRT',3,135);
insert into route values ('80','LRT',4,142);
insert into route values ('80','LRT',5,29);
insert into route values ('80','LRT',6,194);
insert into route values ('80','LRT',7,225);
insert into route values ('80','LRT',8,47);
insert into route values ('80','LRT',9,52);
insert into route values ('80','LRT',10,70);
insert into route values ('80','LRT',11,59);
--- tabroute, 801, 50
insert into route values ('80','LRT',12,215);
insert into route values ('80A','LRT',1,189);
insert into route values ('80A','LRT',2,27);
insert into route values ('80A','LRT',3,135);
insert into route values ('80A','LRT',4,142);
insert into route values ('80A','LRT',5,29);
insert into route values ('80A','LRT',6,194);
insert into route values ('80A','LRT',7,225);
insert into route values ('80A','LRT',8,47);
insert into route values ('80A','LRT',9,59);
insert into route values ('80A','LRT',10,215);
insert into route values ('80B','LRT',1,189);
insert into route values ('80B','LRT',2,27);
insert into route values ('80B','LRT',3,135);
insert into route values ('80B','LRT',4,142);
insert into route values ('80B','LRT',5,29);
insert into route values ('80B','LRT',6,194);
insert into route values ('80B','LRT',7,225);
insert into route values ('80B','LRT',8,47);
insert into route values ('80B','LRT',9,52);
insert into route values ('80B','LRT',10,70);
insert into route values ('80B','LRT',11,66);
insert into route values ('80B','LRT',12,215);
insert into route values ('80','SMT',1,115);
insert into route values ('80','SMT',2,194);
insert into route values ('80','SMT',3,29);
insert into route values ('80','SMT',4,96);
insert into route values ('80','SMT',5,62);
insert into route values ('80','SMT',6,84);
insert into route values ('80','SMT',7,171);
insert into route values ('80','SMT',8,100);
insert into route values ('81','LRT',1,67);
insert into route values ('81','LRT',2,184);
insert into route values ('81','LRT',3,142);
insert into route values ('81','LRT',4,29);
insert into route values ('81','LRT',5,219);
insert into route values ('81','LRT',6,47);
insert into route values ('81','LRT',7,59);
insert into route values ('81','LRT',8,162);
insert into route values ('81','LRT',9,219);
insert into route values ('81','LRT',10,47);
insert into route values ('81','LRT',11,59);
insert into route values ('81','LRT',12,162);
insert into route values ('81A','LRT',1,67);
insert into route values ('81A','LRT',2,184);
insert into route values ('81A','LRT',3,146);
insert into route values ('81A','LRT',4,142);
insert into route values ('81A','LRT',5,29);
insert into route values ('81A','LRT',6,219);
insert into route values ('81A','LRT',7,47);
--- tabroute, 851, 50
insert into route values ('81A','LRT',8,59);
insert into route values ('81A','LRT',9,162);
insert into route values ('81A','LRT',10,219);
insert into route values ('81A','LRT',11,47);
insert into route values ('81A','LRT',12,59);
insert into route values ('81A','LRT',13,162);
insert into route values ('82','LRT',1,202);
insert into route values ('82','LRT',2,189);
insert into route values ('82','LRT',3,27);
insert into route values ('82','LRT',4,62);
insert into route values ('82','LRT',5,65);
insert into route values ('82','LRT',6,36);
insert into route values ('82','LRT',7,29);
insert into route values ('82','LRT',8,219);
insert into route values ('82','LRT',9,196);
insert into route values ('82','LRT',10,13);
insert into route values ('82','LRT',11,78);
insert into route values ('84','LRT',1,209);
insert into route values ('84','LRT',2,191);
insert into route values ('84','LRT',3,82);
insert into route values ('84','LRT',4,163);
insert into route values ('84','LRT',5,237);
insert into route values ('84','LRT',6,247);
insert into route values ('84','LRT',7,62);
insert into route values ('85','LRT',1,42);
insert into route values ('85','LRT',2,48);
insert into route values ('85','LRT',3,115);
insert into route values ('85','LRT',4,194);
insert into route values ('85','LRT',5,199);
insert into route values ('85','LRT',6,191);
insert into route values ('85','LRT',7,163);
insert into route values ('85','LRT',8,233);
insert into route values ('85','SMT',1,39);
insert into route values ('85','SMT',2,194);
insert into route values ('85','SMT',3,219);
insert into route values ('85','SMT',4,29);
insert into route values ('85','SMT',5,36);
insert into route values ('85','SMT',6,65);
insert into route values ('85','SMT',7,62);
insert into route values ('85','SMT',8,154);
insert into route values ('85','SMT',9,171);
insert into route values ('85','SMT',10,100);
insert into route values ('86','LRT',1,42);
insert into route values ('86','LRT',2,48);
insert into route values ('86','LRT',3,115);
insert into route values ('86','LRT',4,194);
insert into route values ('86','LRT',5,199);
insert into route values ('86','LRT',6,191);
insert into route values ('86','LRT',7,163);
insert into route values ('86','LRT',8,193);
--- tabroute, 901, 50
insert into route values ('86','LRT',9,233);
insert into route values ('86','SMT',1,43);
insert into route values ('86','SMT',2,42);
insert into route values ('86','SMT',3,48);
insert into route values ('86','SMT',4,115);
insert into route values ('86','SMT',5,194);
insert into route values ('86','SMT',6,29);
insert into route values ('86','SMT',7,36);
insert into route values ('86','SMT',8,65);
insert into route values ('86','SMT',9,62);
insert into route values ('86','SMT',10,154);
insert into route values ('86A','LRT',1,240);
insert into route values ('86A','LRT',2,115);
insert into route values ('86A','LRT',3,48);
insert into route values ('86A','LRT',4,83);
insert into route values ('87','LRT',1,209);
insert into route values ('87','LRT',2,137);
insert into route values ('87','LRT',3,147);
insert into route values ('87','LRT',4,149);
insert into route values ('87','LRT',5,29);
insert into route values ('87','LRT',6,142);
insert into route values ('87','LRT',7,146);
insert into route values ('87','LRT',8,18);
insert into route values ('87','LRT',9,184);
insert into route values ('87','LRT',10,134);
insert into route values ('87','SMT',1,171);
insert into route values ('87','SMT',2,154);
insert into route values ('87','SMT',3,62);
insert into route values ('87','SMT',4,96);
insert into route values ('87','SMT',5,29);
insert into route values ('87','SMT',6,219);
insert into route values ('87','SMT',7,141);
insert into route values ('87','SMT',8,137);
insert into route values ('87A','LRT',1,210);
insert into route values ('87A','LRT',2,147);
insert into route values ('87A','LRT',3,149);
insert into route values ('87A','LRT',4,29);
insert into route values ('87A','LRT',5,142);
insert into route values ('87A','LRT',6,146);
insert into route values ('87A','LRT',7,203);
insert into route values ('93','SMT',1,6);
insert into route values ('93','SMT',2,166);
insert into route values ('93','SMT',3,163);
insert into route values ('93','SMT',4,233);
insert into route values ('94','LOW',1,156);
insert into route values ('94','LOW',2,93);
insert into route values ('94','LOW',3,227);
insert into route values ('94','LOW',4,96);
insert into route values ('94','LOW',5,169);
insert into route values ('94','LOW',6,219);
--- tabroute, 951, 50
insert into route values ('95','LOW',1,219);
insert into route values ('95','LOW',2,65);
insert into route values ('95','LOW',3,62);
insert into route values ('95','LOW',4,84);
insert into route values ('95','LOW',5,171);
insert into route values ('95','LOW',6,227);
insert into route values ('95','LOW',7,93);
insert into route values ('95','LOW',8,211);
insert into route values ('95','LOW',9,114);
insert into route values ('100','LRT',1,240);
insert into route values ('100','LRT',2,115);
insert into route values ('100','LRT',3,48);
insert into route values ('100','LRT',4,83);
insert into route values ('100','MAC',1,219);
insert into route values ('100','MAC',2,160);
insert into route values ('100','MAC',3,184);
insert into route values ('100','MAC',4,241);
insert into route values ('100','MAC',5,17);
insert into route values ('100','MAC',6,2);
insert into route values ('100','MAC',7,229);
insert into route values ('100','MAC',8,73);
insert into route values ('106','SMT',1,115);
insert into route values ('106','SMT',2,194);
insert into route values ('106','SMT',3,149);
insert into route values ('106','SMT',4,158);
insert into route values ('106','SMT',5,163);
insert into route values ('106','SMT',6,233);
insert into route values ('106','SMT',7,110);
insert into route values ('106','SMT',8,3);
insert into route values ('106','SMT',9,74);
insert into route values ('113','SMT',1,219);
insert into route values ('113','SMT',2,149);
insert into route values ('113','SMT',3,158);
insert into route values ('113','SMT',4,163);
insert into route values ('113','SMT',5,187);
insert into route values ('113','SMT',6,237);
insert into route values ('113','SMT',7,233);
insert into route values ('113','SMT',8,183);
insert into route values ('124','SMT',1,39);
insert into route values ('124','SMT',2,95);
insert into route values ('124','SMT',3,219);
insert into route values ('124','SMT',4,149);
insert into route values ('124','SMT',5,158);
insert into route values ('124','SMT',6,163);
insert into route values ('124','SMT',7,193);
insert into route values ('124','SMT',8,151);
insert into route values ('124','SMT',9,1);
insert into route values ('124','SMT',10,174);
insert into route values ('129','SMT',1,215);
insert into route values ('129','SMT',2,90);
--- tabroute, 1001, 50
insert into route values ('129','SMT',3,59);
insert into route values ('129','SMT',4,47);
insert into route values ('129','SMT',5,178);
insert into route values ('129','SMT',6,219);
insert into route values ('129','SMT',7,191);
insert into route values ('129','SMT',8,163);
insert into route values ('129','SMT',9,193);
insert into route values ('129','SMT',10,190);
insert into route values ('129','SMT',11,212);
insert into route values ('134','SMT',1,219);
insert into route values ('134','SMT',2,29);
insert into route values ('134','SMT',3,36);
insert into route values ('134','SMT',4,65);
insert into route values ('134','SMT',5,163);
insert into route values ('134','SMT',6,247);
insert into route values ('134','SMT',7,62);
insert into route values ('137','SMT',1,219);
insert into route values ('137','SMT',2,115);
insert into route values ('137','SMT',3,48);
insert into route values ('137','SMT',4,235);
insert into route values ('137','SMT',5,98);
insert into route values ('137','SMT',6,197);
insert into route values ('137','SMT',7,63);
insert into route values ('137','SMT',8,248);
insert into route values ('142','SMJ',1,6);
insert into route values ('142','SMJ',2,166);
insert into route values ('142','SMJ',3,163);
insert into route values ('142','SMJ',4,65);
insert into route values ('142','SMJ',5,62);
insert into route values ('142','SMJ',6,86);
insert into route values ('142','SMJ',7,119);
insert into route values ('251','CCC',1,219);
insert into route values ('251','CCC',2,158);
insert into route values ('251','CCC',3,110);
insert into route values ('251','CCC',4,79);
insert into route values ('251','CCC',5,74);
insert into route values ('251','CCC',6,16);
insert into route values ('275','SMT',1,219);
insert into route values ('275','SMT',2,48);
insert into route values ('275','SMT',3,165);
insert into route values ('275','SMT',4,48);
insert into route values ('275','SMT',5,165);
insert into route values ('275','SMT',6,32);
insert into route values ('275','SMT',7,236);
insert into route values ('275','SMT',8,195);
insert into route values ('275','SMT',9,145);
insert into route values ('315','LOW',1,219);
insert into route values ('315','LOW',2,230);
insert into route values ('315','LOW',3,160);
insert into route values ('315','LOW',4,85);
--- tabroute, 1051, 50
insert into route values ('315','LOW',5,117);
insert into route values ('315','LOW',6,35);
insert into route values ('315','LOW',7,18);
insert into route values ('315','LOW',8,203);
insert into route values ('315','LOW',9,8);
insert into route values ('315','LOW',10,184);
insert into route values ('455','MID',1,145);
insert into route values ('455','MID',2,221);
insert into route values ('455','MID',3,236);
insert into route values ('455','MID',4,32);
insert into route values ('455','MID',5,130);
insert into route values ('455','MID',6,218);
insert into route values ('455','MID',7,185);
insert into route values ('455','MID',8,144);
insert into route values ('A8','SMT',1,232);
insert into route values ('A8','SMT',2,193);
insert into route values ('A8','SMT',3,163);
insert into route values ('A8','SMT',4,191);
insert into route values ('A8','SMT',5,81);
insert into route values ('C3','SMT',1,167);
insert into route values ('C3','SMT',2,137);
insert into route values ('C3','SMT',3,141);
insert into route values ('C3','SMT',4,29);
insert into route values ('C3','SMT',5,192);
insert into route values ('C3','SMT',6,54);
insert into route values ('C3','SMT',7,173);
insert into route values ('C3','SMT',8,129);
insert into route values ('C33','SMT',1,167);
insert into route values ('C33','SMT',2,137);
insert into route values ('C33','SMT',3,141);
insert into route values ('C33','SMT',4,29);
insert into route values ('C33','SMT',5,192);
insert into route values ('C33','SMT',6,54);
insert into route values ('C33','SMT',7,173);
insert into route values ('C33','SMT',8,166);
insert into route values ('C33','SMT',9,163);
insert into route values ('C33','SMT',10,247);
insert into route values ('C5','SMT',1,244);
insert into route values ('C5','SMT',2,213);
insert into route values ('C5','SMT',3,207);
insert into route values ('C5','SMT',4,101);
insert into route values ('C5','SMT',5,115);
insert into route values ('C5','SMT',6,194);
insert into route values ('C5','SMT',7,149);
insert into route values ('C5','SMT',8,80);
insert into route values ('C5','SMT',9,137);
insert into route values ('C5','SMT',10,147);
insert into route values ('C5','SMT',11,200);
insert into route values ('C12','SMT',1,219);
insert into route values ('C12','SMT',2,115);
--- tabroute, 1101, 50
insert into route values ('C12','SMT',3,48);
insert into route values ('C12','SMT',4,31);
insert into route values ('C12','SMT',5,109);
insert into route values ('C55','SMT',1,245);
insert into route values ('C55','SMT',2,180);
insert into route values ('C55','SMT',3,101);
insert into route values ('C55','SMT',4,115);
insert into route values ('C55','SMT',5,194);
insert into route values ('C55','SMT',6,149);
insert into route values ('C55','SMT',7,200);
insert into route values ('C70','SMT',1,44);
insert into route values ('C70','SMT',2,244);
insert into route values ('C70','SMT',3,213);
insert into route values ('C70','SMT',4,31);
insert into route values ('C70','SMT',5,223);
insert into route values ('C70','SMT',6,101);
insert into route values ('C70','SMT',7,115);
insert into route values ('C70','SMT',8,194);
insert into route values ('C70','SMT',9,29);
insert into route values ('C70','SMT',10,142);
insert into route values ('C70','SMT',11,146);
insert into route values ('C70','SMT',12,228);
insert into route values ('D25','SMT',1,219);
insert into route values ('D25','SMT',2,213);
insert into route values ('D25','SMT',3,131);
insert into route values ('D25','SMT',4,77);
insert into route values ('D25','SMT',5,157);
insert into route values ('D25','SMT',6,145);
insert into route values ('D25','SMT',7,69);
insert into route values ('D25','SMT',8,14);
insert into route values ('D26','SMT',1,219);
insert into route values ('D26','SMT',2,213);
insert into route values ('D26','SMT',3,77);
insert into route values ('D26','SMT',4,157);
insert into route values ('D26','SMT',5,145);
insert into route values ('D26','SMT',6,20);
insert into route values ('D26','SMT',7,246);
insert into route values ('D26','SMT',8,88);
insert into route values ('D27','SMT',1,219);
insert into route values ('D27','SMT',2,213);
insert into route values ('D27','SMT',3,77);
insert into route values ('D27','SMT',4,157);
insert into route values ('D27','SMT',5,145);
insert into route values ('D27','SMT',6,20);
insert into route values ('D27','SMT',7,246);
insert into route values ('D27','SMT',8,113);
insert into route values ('D27','SMT',9,82);
insert into route values ('D28','SMT',1,219);
insert into route values ('D28','SMT',2,213);
insert into route values ('D28','SMT',3,77);
--- tabroute, 1151, 50
insert into route values ('D28','SMT',4,157);
insert into route values ('D28','SMT',5,145);
insert into route values ('D28','SMT',6,69);
insert into route values ('D28','SMT',7,14);
insert into route values ('R1','ROU',1,106);
insert into route values ('R1','ROU',2,167);
insert into route values ('R1','ROU',3,99);
insert into route values ('R1','ROU',4,37);
insert into route values ('R1','ROU',5,95);
insert into route values ('R1','ROU',6,47);
insert into route values ('R1','ROU',7,59);
insert into route values ('R1','ROU',8,106);
insert into route values ('R2','ROU',1,106);
insert into route values ('R2','ROU',2,59);
insert into route values ('R2','ROU',3,47);
insert into route values ('R2','ROU',4,95);
insert into route values ('R2','ROU',5,37);
insert into route values ('R2','ROU',6,99);
insert into route values ('R2','ROU',7,167);
insert into route values ('R2','ROU',8,106);
insert into route values ('VL2','VL',1,109);
insert into route values ('VL2','VL',2,201);
insert into route values ('VL2','VL',3,60);
insert into route values ('VL2','VL',4,10);

COMMIT;
