/*
 * Copyright (C) 1999, 2000, 2002, 2003  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "xhtmldocgenerator.h"

void
XHtmlDocGenerator::generate_doctype()
{
  generateln
    ("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
  generateln
    (" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
}

void
XHtmlDocGenerator::generate_standard_style()
{
  if( css_url.size () == 0 && doc_header.size () == 0 ) {
    generate ("<body style=\"background-color: #FFFFFF; color: #000000; a: #0000EE; ");
    generateln ( "a.visited: #551A8B; a.active: #FF0000\">" );
  }
  else {
    generateln( "<body>" ) ;
  }
}

void
XHtmlDocGenerator::close_meta()
{
  generateln( "\" />" ) ;
}
