//****************************************************************************//
//      Pretranslator class:       
//
//              Base class for text processing before HTML generation
//              Forwards calls to appropriate TextGenerator
//
//      Don Stauffer       Revision: June 2003
//****************************************************************************//
#ifndef	srcPretranslator_H
#define	srcPretranslator_H

#include	<string>

#include "generators.h"

using std::string;

struct Pretranslator
{
  public:


  virtual ~ Pretranslator (void)
    {
    }


    virtual void generate (const string & s)
    {
      GlobalGenerator->generate (s.c_str ());
    }


    virtual void generate (const string & s, int start, int end)
    {
      GlobalGenerator->generate (s.c_str (), start, end);
    }


    virtual void generateln (const string & s)
    {
      GlobalGenerator->generateln (s.c_str ());
    }


    virtual void generate_preproc (const string & s)
    {
      GlobalGenerator->generate_preproc (s.c_str ());
    }


    virtual void generate_normal (const string & s)
    {
      NormalGenerator->generateEntire (s.c_str ());
    }


    virtual void generateTab (void)
    {
      generate ("\t");
    }


    virtual void startComment (const string & s)
    {
      CommentGenerator->beginText (s.c_str ());
    }


    virtual void endComment (const string & s)
    {
      CommentGenerator->endText (s.c_str ());
    }


    virtual void generateComment (const string & s)
    {
      CommentGenerator->generateEntire (s.c_str ());
    }


    virtual void startString (const string & s)
    {
      StringGenerator->beginText (s.c_str ());
    }


    virtual void endString (const string & s)
    {
      StringGenerator->endText (s.c_str ());
    }


    virtual void generateString (const string & s)
    {
      StringGenerator->generateEntire (s.c_str ());
    }


    virtual void generateKeyWord (const string & s)
    {
      KeywordGenerator->generateEntire (s.c_str ());
    }


    virtual void generateBaseType (const string & s)
    {
      TypeGenerator->generateEntire (s.c_str ());
    }


    virtual void generatePreProc (const string & s)
    {
      PreProcGenerator->generateEntire (s.c_str ());
    }


    virtual void generateNumber (const string & s)
    {
      NumberGenerator->generateEntire (s.c_str ());
    }


    virtual void generateSymbol (const string & s)
    {
      SymbolGenerator->generateEntire (s.c_str ());
    }


    virtual void generateFunction (const string & s)
    {
      FunctionGenerator->generateEntire (s.c_str ());
    }


    virtual void generateCBracket (const string & s)
    {
      CBracketGenerator->generateEntire (s.c_str ());
    }


};				//      class           Pretranslator

#endif //      #ifndef srcPretranslator_H
