//
// C++ Interface: lineoutputgenerator
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef LINEOUTPUTGENERATOR_H
#define LINEOUTPUTGENERATOR_H

#include <outputgenerator.h>

class TextGenerator;

/**
a specialized output generator that also generates the line number before each line

@author Lorenzo Bettini
*/
class LineOutputGenerator : public OutputGenerator
{
private:
  bool generate_ref;
  unsigned int line_num;
  TextGenerator *line_num_generator;

public:
    LineOutputGenerator(OutputBuffer& buff, std::ostream& os, bool genref);

    ~LineOutputGenerator();

protected:
    virtual void generate_line(const std::string& line);
    virtual void reset();

    virtual void generate_line_info();
};

#endif
