/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini, bettini@gnu.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <iostream.h>

#include "textgen.h"
#include "chartranslator.h"

extern ostream* sout ;

TextGenerator::TextGenerator(CharTranslator *trans) :
  char_translator (trans)
{
}

void
TextGenerator::generate(const char *s) const
{
  (*sout) << s ;
}

void
TextGenerator::generate( const char *s, int start, int end ) const 
{
  for ( int i = start ; i <= end ; ++i )
    (*sout) << s[i] ;
}

// this version preprocess the string for some special characters
void
TextGenerator::generate_preproc(const char *s) const
{
  char_translator->translate (sout, s);
}

void
TextGenerator::generateln( const char *s ) const
{ 
  generate( s ) ;
  (*sout) << endl ; 
}

void
TextGenerator::generateEntire( const char *s ) const
{
  startTextGeneration() ;
  generate_preproc(s) ;
  endTextGeneration() ;
}

void
TextGenerator::beginText( const char *s ) const
{
  startTextGeneration() ;
  if ( s )
    generate_preproc( s ) ;
}

void
TextGenerator::endText( const char *s ) const
{
  if ( s )
    generate_preproc( s ) ;
  endTextGeneration() ;
}

// TextDecorator
TextDecorator::TextDecorator(TextGenerator *t, CharTranslator *tr) :
  TextGenerator (tr), decorated (t)
{
}

void
TextDecorator::startTextGeneration() const 
{ 
  startDecorate() ;
  if ( decorated )
    decorated->startTextGeneration() ;
}

void
TextDecorator::endTextGeneration() const 
{ 
  if ( decorated )
    decorated->endTextGeneration() ;
  endDecorate() ;
}
