webpackJsonp([3],{

/***/ 168:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2016 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Show contents of the wallet as a tree.
 *
 * @author Florian Dold
 */
const helpers_1 = __webpack_require__(11);
const dbTypes_1 = __webpack_require__(169);
const components_1 = __webpack_require__(8);
const wxApi_1 = __webpack_require__(2);
const renderHtml_1 = __webpack_require__(5);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
class ReserveView extends React.Component {
    render() {
        const r = this.props.reserve;
        return (React.createElement("div", { className: "tree-item" },
            React.createElement("ul", null,
                React.createElement("li", null,
                    "Key: ",
                    r.reserve_pub),
                React.createElement("li", null,
                    "Created: ",
                    (new Date(r.created * 1000).toString())),
                React.createElement("li", null,
                    "Current: ",
                    r.current_amount ? renderHtml_1.renderAmount(r.current_amount) : "null"),
                React.createElement("li", null,
                    "Requested: ",
                    renderHtml_1.renderAmount(r.requested_amount)),
                React.createElement("li", null,
                    "Confirmed: ",
                    r.timestamp_confirmed))));
    }
}
class Toggle extends components_1.ImplicitStateComponent {
    renderButton() {
        const show = () => {
            this.props.expanded(true);
            this.setState({});
        };
        const hide = () => {
            this.props.expanded(false);
            this.setState({});
        };
        if (this.props.expanded()) {
            return React.createElement("button", { onClick: hide }, "hide");
        }
        return React.createElement("button", { onClick: show }, "show");
    }
    render() {
        return (React.createElement("div", { style: { display: "inline" } },
            this.renderButton(),
            this.props.expanded() ? this.props.children : []));
    }
}
class RefreshDialog extends components_1.ImplicitStateComponent {
    constructor() {
        super(...arguments);
        this.refreshRequested = this.makeState(false);
    }
    render() {
        if (!this.refreshRequested()) {
            return (React.createElement("div", { style: { display: "inline" } },
                React.createElement("button", { onClick: () => this.refreshRequested(true) }, "refresh")));
        }
        return (React.createElement("div", null,
            "Refresh amount: ",
            React.createElement("input", { type: "text", size: 10 }),
            React.createElement("button", { onClick: () => wxApi_1.refresh(this.props.coin.coinPub) }, "ok"),
            React.createElement("button", { onClick: () => this.refreshRequested(false) }, "cancel")));
    }
}
class CoinView extends React.Component {
    render() {
        const c = this.props.coin;
        return (React.createElement("div", { className: "tree-item" },
            React.createElement("ul", null,
                React.createElement("li", null,
                    "Key: ",
                    c.coinPub),
                React.createElement("li", null,
                    "Current amount: ",
                    renderHtml_1.renderAmount(c.currentAmount)),
                React.createElement("li", null,
                    "Denomination: ",
                    React.createElement(renderHtml_1.ExpanderText, { text: c.denomPub })),
                React.createElement("li", null,
                    "Suspended: ",
                    (c.suspended || false).toString()),
                React.createElement("li", null,
                    "Status: ",
                    dbTypes_1.CoinStatus[c.status]),
                React.createElement("li", null,
                    React.createElement(RefreshDialog, { coin: c })),
                React.createElement("li", null,
                    React.createElement("button", { onClick: () => wxApi_1.payback(c.coinPub) }, "Payback")))));
    }
}
class PreCoinView extends React.Component {
    render() {
        const c = this.props.precoin;
        return (React.createElement("div", { className: "tree-item" },
            React.createElement("ul", null,
                React.createElement("li", null,
                    "Key: ",
                    c.coinPub))));
    }
}
class CoinList extends components_1.ImplicitStateComponent {
    constructor(props) {
        super(props);
        this.coins = this.makeState(null);
        this.expanded = this.makeState(false);
        this.update(props);
    }
    update(props) {
        return __awaiter(this, void 0, void 0, function* () {
            const coins = yield wxApi_1.getCoins(props.exchangeBaseUrl);
            this.coins(coins);
        });
    }
    componentWillReceiveProps(newProps) {
        this.update(newProps);
    }
    render() {
        if (!this.coins()) {
            return React.createElement("div", null, "...");
        }
        return (React.createElement("div", { className: "tree-item" },
            "Coins (",
            this.coins().length.toString(),
            ")",
            " ",
            React.createElement(Toggle, { expanded: this.expanded }, this.coins().map((c) => React.createElement(CoinView, { coin: c })))));
    }
}
class PreCoinList extends components_1.ImplicitStateComponent {
    constructor(props) {
        super(props);
        this.precoins = this.makeState(null);
        this.expanded = this.makeState(false);
        this.update();
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const precoins = yield wxApi_1.getPreCoins(this.props.exchangeBaseUrl);
            this.precoins(precoins);
        });
    }
    render() {
        if (!this.precoins()) {
            return React.createElement("div", null, "...");
        }
        return (React.createElement("div", { className: "tree-item" },
            "Planchets (",
            this.precoins().length.toString(),
            ")",
            " ",
            React.createElement(Toggle, { expanded: this.expanded }, this.precoins().map((c) => React.createElement(PreCoinView, { precoin: c })))));
    }
}
class DenominationList extends components_1.ImplicitStateComponent {
    constructor(props) {
        super(props);
        this.expanded = this.makeState(false);
        this.denoms = this.makeState(undefined);
        this.update();
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const d = yield wxApi_1.getDenoms(this.props.exchange.baseUrl);
            this.denoms(d);
        });
    }
    renderDenom(d) {
        return (React.createElement("div", { className: "tree-item" },
            React.createElement("ul", null,
                React.createElement("li", null,
                    "Offered: ",
                    d.isOffered ? "yes" : "no"),
                React.createElement("li", null,
                    "Value: ",
                    renderHtml_1.renderAmount(d.value)),
                React.createElement("li", null,
                    "Withdraw fee: ",
                    renderHtml_1.renderAmount(d.feeWithdraw)),
                React.createElement("li", null,
                    "Refresh fee: ",
                    renderHtml_1.renderAmount(d.feeRefresh)),
                React.createElement("li", null,
                    "Deposit fee: ",
                    renderHtml_1.renderAmount(d.feeDeposit)),
                React.createElement("li", null,
                    "Refund fee: ",
                    renderHtml_1.renderAmount(d.feeRefund)),
                React.createElement("li", null,
                    "Start: ",
                    helpers_1.getTalerStampDate(d.stampStart).toString()),
                React.createElement("li", null,
                    "Withdraw expiration: ",
                    helpers_1.getTalerStampDate(d.stampExpireWithdraw).toString()),
                React.createElement("li", null,
                    "Legal expiration: ",
                    helpers_1.getTalerStampDate(d.stampExpireLegal).toString()),
                React.createElement("li", null,
                    "Deposit expiration: ",
                    helpers_1.getTalerStampDate(d.stampExpireDeposit).toString()),
                React.createElement("li", null,
                    "Denom pub: ",
                    React.createElement(renderHtml_1.ExpanderText, { text: d.denomPub })))));
    }
    render() {
        const denoms = this.denoms();
        if (!denoms) {
            return (React.createElement("div", { className: "tree-item" },
                "Denominations (...)",
                " ",
                React.createElement(Toggle, { expanded: this.expanded }, "...")));
        }
        return (React.createElement("div", { className: "tree-item" },
            "Denominations (",
            denoms.length.toString(),
            ")",
            " ",
            React.createElement(Toggle, { expanded: this.expanded }, denoms.map((d) => this.renderDenom(d)))));
    }
}
class ReserveList extends components_1.ImplicitStateComponent {
    constructor(props) {
        super(props);
        this.reserves = this.makeState(null);
        this.expanded = this.makeState(false);
        this.update();
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const reserves = yield wxApi_1.getReserves(this.props.exchangeBaseUrl);
            this.reserves(reserves);
        });
    }
    render() {
        if (!this.reserves()) {
            return React.createElement("div", null, "...");
        }
        return (React.createElement("div", { className: "tree-item" },
            "Reserves (",
            this.reserves().length.toString(),
            ")",
            " ",
            React.createElement(Toggle, { expanded: this.expanded }, this.reserves().map((r) => React.createElement(ReserveView, { reserve: r })))));
    }
}
class ExchangeView extends React.Component {
    render() {
        const e = this.props.exchange;
        return (React.createElement("div", { className: "tree-item" },
            React.createElement("ul", null,
                React.createElement("li", null,
                    "Exchange Base Url: ",
                    this.props.exchange.baseUrl),
                React.createElement("li", null,
                    "Master public key: ",
                    React.createElement(renderHtml_1.ExpanderText, { text: this.props.exchange.masterPublicKey }))),
            React.createElement(DenominationList, { exchange: e }),
            React.createElement(ReserveList, { exchangeBaseUrl: this.props.exchange.baseUrl }),
            React.createElement(CoinList, { exchangeBaseUrl: this.props.exchange.baseUrl }),
            React.createElement(PreCoinList, { exchangeBaseUrl: this.props.exchange.baseUrl })));
    }
}
class ExchangesList extends React.Component {
    constructor(props) {
        super(props);
        const port = chrome.runtime.connect();
        port.onMessage.addListener((msg) => {
            if (msg.notify) {
                console.log("got notified");
                this.update();
            }
        });
        this.update();
        this.state = {};
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const exchanges = yield wxApi_1.getExchanges();
            console.log("exchanges: ", exchanges);
            this.setState({ exchanges });
        });
    }
    render() {
        const exchanges = this.state.exchanges;
        if (!exchanges) {
            return React.createElement("span", null, "...");
        }
        return (React.createElement("div", { className: "tree-item" },
            "Exchanges (",
            exchanges.length.toString(),
            "):",
            exchanges.map((e) => React.createElement(ExchangeView, { exchange: e }))));
    }
}
function main() {
    ReactDOM.render(React.createElement(ExchangesList, null), document.getElementById("container"));
}
document.addEventListener("DOMContentLoaded", main);


/***/ }),

/***/ 169:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2018 GNUnet e.V. and INRIA

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Types for records stored in the wallet's database.
 *
 * Types for the objects in the database should end in "-Record".
 */
/**
 * Imports.
 */
const amounts_1 = __webpack_require__(4);
const checkable_1 = __webpack_require__(9);
const talerTypes_1 = __webpack_require__(137);
const query_1 = __webpack_require__(136);
/**
 * Current database version, should be incremented
 * each time we do incompatible schema changes on the database.
 * In the future we might consider adding migration functions for
 * each version increment.
 */
exports.WALLET_DB_VERSION = 26;
/**
 * Status of a denomination.
 */
var DenominationStatus;
(function (DenominationStatus) {
    /**
     * Verification was delayed.
     */
    DenominationStatus[DenominationStatus["Unverified"] = 0] = "Unverified";
    /**
     * Verified as valid.
     */
    DenominationStatus[DenominationStatus["VerifiedGood"] = 1] = "VerifiedGood";
    /**
     * Verified as invalid.
     */
    DenominationStatus[DenominationStatus["VerifiedBad"] = 2] = "VerifiedBad";
})(DenominationStatus = exports.DenominationStatus || (exports.DenominationStatus = {}));
/**
 * Denomination record as stored in the wallet's database.
 */
let DenominationRecord = class DenominationRecord {
};
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "value", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "denomPub", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "denomPubHash", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeWithdraw", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeDeposit", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeRefresh", void 0);
__decorate([
    checkable_1.Checkable.Value(() => amounts_1.AmountJson)
], DenominationRecord.prototype, "feeRefund", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampStart", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampExpireWithdraw", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampExpireLegal", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "stampExpireDeposit", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "masterSig", void 0);
__decorate([
    checkable_1.Checkable.Number()
], DenominationRecord.prototype, "status", void 0);
__decorate([
    checkable_1.Checkable.Boolean()
], DenominationRecord.prototype, "isOffered", void 0);
__decorate([
    checkable_1.Checkable.String()
], DenominationRecord.prototype, "exchangeBaseUrl", void 0);
DenominationRecord = __decorate([
    checkable_1.Checkable.Class()
], DenominationRecord);
exports.DenominationRecord = DenominationRecord;
/**
 * Status of a coin.
 */
var CoinStatus;
(function (CoinStatus) {
    /**
     * Withdrawn and never shown to anybody.
     */
    CoinStatus[CoinStatus["Fresh"] = 0] = "Fresh";
    /**
     * Currently planned to be sent to a merchant for a purchase.
     */
    CoinStatus[CoinStatus["PurchasePending"] = 1] = "PurchasePending";
    /**
     * Used for a completed transaction and now dirty.
     */
    CoinStatus[CoinStatus["Dirty"] = 2] = "Dirty";
    /**
     * A coin that was refreshed.
     */
    CoinStatus[CoinStatus["Refreshed"] = 3] = "Refreshed";
    /**
     * Coin marked to be paid back, but payback not finished.
     */
    CoinStatus[CoinStatus["PaybackPending"] = 4] = "PaybackPending";
    /**
     * Coin fully paid back.
     */
    CoinStatus[CoinStatus["PaybackDone"] = 5] = "PaybackDone";
    /**
     * Coin was dirty but can't be refreshed.
     */
    CoinStatus[CoinStatus["Useless"] = 6] = "Useless";
    /**
     * The coin was withdrawn for a tip that the user hasn't accepted yet.
     */
    CoinStatus[CoinStatus["TainedByTip"] = 7] = "TainedByTip";
})(CoinStatus = exports.CoinStatus || (exports.CoinStatus = {}));
/**
 * Proposal record, stored in the wallet's database.
 */
let ProposalDownloadRecord = class ProposalDownloadRecord {
};
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "url", void 0);
__decorate([
    checkable_1.Checkable.Value(() => talerTypes_1.ContractTerms)
], ProposalDownloadRecord.prototype, "contractTerms", void 0);
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "merchantSig", void 0);
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "contractTermsHash", void 0);
__decorate([
    checkable_1.Checkable.Optional(checkable_1.Checkable.Number())
], ProposalDownloadRecord.prototype, "id", void 0);
__decorate([
    checkable_1.Checkable.Number()
], ProposalDownloadRecord.prototype, "timestamp", void 0);
__decorate([
    checkable_1.Checkable.String()
], ProposalDownloadRecord.prototype, "noncePriv", void 0);
ProposalDownloadRecord = __decorate([
    checkable_1.Checkable.Class()
], ProposalDownloadRecord);
exports.ProposalDownloadRecord = ProposalDownloadRecord;
/* tslint:disable:completed-docs */
/**
 * The stores and indices for the wallet database.
 */
var Stores;
(function (Stores) {
    class ExchangeStore extends query_1.Store {
        constructor() {
            super("exchanges", { keyPath: "baseUrl" });
            this.pubKeyIndex = new query_1.Index(this, "pubKeyIndex", "masterPublicKey");
        }
    }
    class CoinsStore extends query_1.Store {
        constructor() {
            super("coins", { keyPath: "coinPub" });
            this.exchangeBaseUrlIndex = new query_1.Index(this, "exchangeBaseUrl", "exchangeBaseUrl");
            this.denomPubIndex = new query_1.Index(this, "denomPubIndex", "denomPub");
        }
    }
    class ProposalsStore extends query_1.Store {
        constructor() {
            super("proposals", {
                autoIncrement: true,
                keyPath: "id",
            });
            this.urlIndex = new query_1.Index(this, "urlIndex", "url");
            this.timestampIndex = new query_1.Index(this, "timestampIndex", "timestamp");
        }
    }
    class PurchasesStore extends query_1.Store {
        constructor() {
            super("purchases", { keyPath: "contractTermsHash" });
            this.fulfillmentUrlIndex = new query_1.Index(this, "fulfillmentUrlIndex", "contractTerms.fulfillment_url");
            this.orderIdIndex = new query_1.Index(this, "orderIdIndex", "contractTerms.order_id");
            this.timestampIndex = new query_1.Index(this, "timestampIndex", "timestamp");
        }
    }
    class DenominationsStore extends query_1.Store {
        constructor() {
            // cast needed because of bug in type annotations
            super("denominations", { keyPath: ["exchangeBaseUrl", "denomPub"] });
            this.denomPubHashIndex = new query_1.Index(this, "denomPubHashIndex", "denomPubHash");
            this.exchangeBaseUrlIndex = new query_1.Index(this, "exchangeBaseUrlIndex", "exchangeBaseUrl");
            this.denomPubIndex = new query_1.Index(this, "denomPubIndex", "denomPub");
        }
    }
    class CurrenciesStore extends query_1.Store {
        constructor() {
            super("currencies", { keyPath: "name" });
        }
    }
    class ConfigStore extends query_1.Store {
        constructor() {
            super("config", { keyPath: "key" });
        }
    }
    class ExchangeWireFeesStore extends query_1.Store {
        constructor() {
            super("exchangeWireFees", { keyPath: "exchangeBaseUrl" });
        }
    }
    class ReservesStore extends query_1.Store {
        constructor() {
            super("reserves", { keyPath: "reserve_pub" });
            this.timestampCreatedIndex = new query_1.Index(this, "timestampCreatedIndex", "created");
            this.timestampConfirmedIndex = new query_1.Index(this, "timestampConfirmedIndex", "timestamp_confirmed");
            this.timestampDepletedIndex = new query_1.Index(this, "timestampDepletedIndex", "timestamp_depleted");
        }
    }
    class TipsStore extends query_1.Store {
        constructor() {
            super("tips", { keyPath: ["tipId", "merchantDomain"] });
            this.coinPubIndex = new query_1.Index(this, "coinPubIndex", "coinPubs", { multiEntry: true });
        }
    }
    class SenderWiresStore extends query_1.Store {
        constructor() {
            super("senderWires", { keyPath: "id" });
        }
    }
    Stores.coins = new CoinsStore();
    Stores.coinsReturns = new query_1.Store("coinsReturns", { keyPath: "contractTermsHash" });
    Stores.config = new ConfigStore();
    Stores.currencies = new CurrenciesStore();
    Stores.denominations = new DenominationsStore();
    Stores.exchangeWireFees = new ExchangeWireFeesStore();
    Stores.exchanges = new ExchangeStore();
    Stores.precoins = new query_1.Store("precoins", { keyPath: "coinPub" });
    Stores.proposals = new ProposalsStore();
    Stores.refresh = new query_1.Store("refresh", { keyPath: "id", autoIncrement: true });
    Stores.reserves = new ReservesStore();
    Stores.purchases = new PurchasesStore();
    Stores.tips = new TipsStore();
    Stores.senderWires = new SenderWiresStore();
})(Stores = exports.Stores || (exports.Stores = {}));
/* tslint:enable:completed-docs */


/***/ })

},[168]);
//# sourceMappingURL=tree-bundle.js.map