#ifndef EXTERN_H
#define EXTERN_H
/*
  
  All "extern" definitions for the Xlogmaster
  
*/

#ifndef XLOGMASTER_H
/*{{{  from xlogmaster.cc  */
// GTK based:
extern GtkWidget *window;            // Main window
extern GtkWidget *textwindow;                // Text window
extern GtkWidget *small_logo_xpm;
extern GtkTooltips *tooltips;         // for the help messages
/* Standard style */
extern GtkStyle* stdstyle;

// GDK based:
extern GdkColormap* cmap; // xlogmasters overall colormap
extern GdkColor alert;           // Alert color to start at
extern GdkColor base;           // Colors to fade to
extern GdkColor prelight;      // (prelight to fade to)


// others:
extern display_logs;                  // Display of logs file (ENABLED/DISABLED)
extern Log **entry;
extern int syslogs;                   // Amount of "Log" objects
extern int active;                     // currently active "Log" object
extern int *mode;                  // mode for opening the file / whatever it is
extern char **filename;          // where to find it
extern char **help;                 // helptext to display when holding mouse over button
extern char **buttontext;       // text of button itself
extern int *interval;              // interval to display things... only used for executing/catting stuff
extern char ***commandline;  // commandline parameters for executable
extern char ***filter;                // strings to filter for
extern char ***filter_exec;
extern int **filter_mode;          // and the mode to use
extern int fillups;                   // amount of logs to be created...
extern struct stat status;         // stat-buffer for files
extern int terse;                    // should there be a "are you sure" question for
extern char* read_buffer;        // Pointer to I/O-buffer for file operations
extern long maxtext;               // Number of bytes to be cached
extern int notice_follows_mouse; // should the notice window follow the mouse around ?
extern gint configuration_changed; // did the configuration change ?

// functions:
extern gint delete_event(GtkWidget *, GdkEvent *, gpointer);
extern void quit (GtkWidget*, gpointer*);
extern void request_about();
extern void disable();
extern void enable();
extern gint determine_filter_class(gint);
extern void setup_logs();
extern void unsetup_logs();
extern void create_buttons();
extern void output_text (GtkWidget*, char*, long);
extern int does_match(char*, char*, long, long);

/* error procedures */
extern void file_error(gchar*);
extern void fork_error();


/*}}}*/
#endif /* ! XLOGMASTER_H */


#ifndef MENU_H
/*{{{  from menu.cc  */
// GTK based:

// others:

// functions:
extern void fire_up_menu(GtkWidget*);


/*}}}*/
#endif /* ! MENU_H */


#ifndef FILE_H
/*{{{  from file.cc  */
// GTK based:

// others:
extern char* load_path;
extern char* save_path;
extern char* log_path;

// functions:
extern void create_form();
extern int read_configuration(char*);
extern gint legalize(gint, gint);
extern int write_configuration(char*);
extern int match(char*, char*, int);
extern int searchfor(char, char*, int);
extern char* getstring(char , char* , int );

/*}}}*/
#endif /* ! FILE_H */


#ifndef ALERT_H
/*{{{  from alert.cc  */
// GTK based:


// others:
extern gint steps; // how many steps to use for fading back to original color
extern gdouble fade_base; // fade base (system dependent)
extern gdouble fade_step; // stepsize for fading back

// functions:
extern void trigger_alert(int);
extern void remove_alert(int);
extern void create_notice_window();
extern void notice_alert(gchar*, gchar*);
/*}}}*/
#endif /* ! ALERT_H */


#ifndef WATCHDOG_H
/*{{{  from watchdog.cc  */
// GTK based:


// others:
extern gint class0_filters[];
extern gint class1_filters[];


// functions:
extern void activate();
extern void deactivate();
extern void start_watchdog();
extern void stop_watchdog();


/*}}}*/
#endif /* ! WATCHDOG_H */


#ifndef AUDIO_H
/*{{{  from audio.cc  */
extern gint sound;
extern char* alert_sound;
extern char* notice_sound;
extern char* uniconify_sound;
// functions:
extern void play(gint);

/*}}}*/
#endif /* ! AUDIO_H */


#ifndef EXECUTE_H
/*{{{  from execute.cc  */

extern gint cleanup_tag;
extern gint pid_reference;
extern GList* pid_list;

// functions:
extern void execute_program(gint, gint, gchar*);
extern void reference_child(gint);
extern gint check_terminate(gint);
extern gint my_setenv(const gchar*, const gchar*);


/*}}}*/
#endif /* ! EXECUTE_H */


#ifndef DIALOG_H
/*{{{  from dialog.cc  */

// functions:
extern void popup_dialog(gchar*, gchar*, GList*, GList*);

/*}}}*/
#endif /* ! DIALOG_H */


#endif /* EXTERN_H */
