/* variables.c generated by valac 0.52.0, the Vala compiler
 * generated from variables.vala, do not modify */

/* Zile variables handling functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */
/*
 * Variable type.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <stdarg.h>

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef struct _VarEntryPrivate VarEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecVarEntry ParamSpecVarEntry;
#define _var_entry_unref0(var) ((var == NULL) ? NULL : (var = (var_entry_unref (var), NULL)))

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_COMPLETION (completion_get_type ())
#define COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION, Completion))
#define COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION, CompletionClass))
#define IS_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION))
#define IS_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION))
#define COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION, CompletionClass))

typedef struct _Completion Completion;
typedef struct _CompletionClass CompletionClass;
typedef struct _Block13Data Block13Data;
#define _completion_unref0(var) ((var == NULL) ? NULL : (var = (completion_unref (var), NULL)))
typedef struct _CompletionPrivate CompletionPrivate;
typedef enum  {
	COMPLETION_FLAGS_POPPEDUP = 1 << 0,
	COMPLETION_FLAGS_CLOSE = 1 << 1,
	COMPLETION_FLAGS_FILENAME = 1 << 2
} CompletionFlags;

#define COMPLETION_TYPE_FLAGS (completion_flags_get_type ())

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))

struct _VarEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VarEntryPrivate * priv;
	gchar* name;
	gchar* defval;
	gchar* val;
	gboolean local;
	gchar* doc;
};

struct _VarEntryClass {
	GTypeClass parent_class;
	void (*finalize) (VarEntry *self);
};

struct _ParamSpecVarEntry {
	GParamSpec parent_instance;
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _Block13Data {
	int _ref_count_;
	Completion* cp;
};

struct _Completion {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompletionPrivate * priv;
	gchar* match;
	Buffer* old_bp;
	GeeSortedSet* completions;
	GeeSortedSet* matches;
	glong matchsize;
	CompletionFlags flags;
	gchar* path;
};

struct _CompletionClass {
	GTypeClass parent_class;
	void (*finalize) (Completion *self);
};

static gpointer var_entry_parent_class = NULL;
extern GHashTable* main_vars;
GHashTable* main_vars = NULL;
extern Buffer* cur_bp;

gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
VarEntry* var_entry_new (void);
VarEntry* var_entry_construct (GType object_type);
static void var_entry_finalize (VarEntry * obj);
static GType var_entry_get_type_once (void);
void init_builtin_var (const gchar* name,
                       const gchar* defval,
                       gboolean local,
                       const gchar* doc);
GHashTable* new_varlist (void);
static void _g_free0_ (gpointer var);
static void _var_entry_unref0_ (gpointer var);
void set_variable (const gchar* name,
                   const gchar* val);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VarEntry* get_variable_entry (Buffer* bp,
                              const gchar* name);
const gchar* get_variable_doc (const gchar* name,
                               const gchar* * defval);
const gchar* get_variable (const gchar* name);
gboolean get_variable_bool (const gchar* name);
gchar* minibuf_read_variable_name (const gchar* fmt,
                                   ...);
gpointer completion_ref (gpointer instance);
void completion_unref (gpointer instance);
GParamSpec* param_spec_completion (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_completion (GValue* value,
                           gpointer v_object);
void value_take_completion (GValue* value,
                            gpointer v_object);
gpointer value_get_completion (const GValue* value);
GType completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Completion, completion_unref)
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
Completion* completion_new (gboolean fileflag);
Completion* completion_construct (GType object_type,
                                  gboolean fileflag);
static void __lambda91_ (Block13Data* _data13_,
                  const gchar* key,
                  VarEntry* val);
GType completion_flags_get_type (void) G_GNUC_CONST ;
static void ___lambda91__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_history (GValue* value,
                        gpointer v_object);
void value_take_history (GValue* value,
                         gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
gchar* minibuf_vread_completion (const gchar* fmt,
                                 const gchar* val,
                                 Completion* cp,
                                 History* hp,
                                 const gchar* empty_err,
                                 const gchar* invalid_err,
                                 va_list ap);
void variables_init (void);
static gboolean __lambda136_ (glong uniarg,
                       GeeQueue* args);
gchar* minibuf_read (const gchar* fmt,
                     const gchar* value,
                     ...);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
static gboolean ___lambda136__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)

VarEntry*
var_entry_construct (GType object_type)
{
	VarEntry* self = NULL;
#line 23 "src/variables.vala"
	self = (VarEntry*) g_type_create_instance (object_type);
#line 23 "src/variables.vala"
	return self;
#line 371 "variables.c"
}

VarEntry*
var_entry_new (void)
{
#line 23 "src/variables.vala"
	return var_entry_construct (TYPE_VAR_ENTRY);
#line 379 "variables.c"
}

static void
value_var_entry_init (GValue* value)
{
#line 23 "src/variables.vala"
	value->data[0].v_pointer = NULL;
#line 387 "variables.c"
}

static void
value_var_entry_free_value (GValue* value)
{
#line 23 "src/variables.vala"
	if (value->data[0].v_pointer) {
#line 23 "src/variables.vala"
		var_entry_unref (value->data[0].v_pointer);
#line 397 "variables.c"
	}
}

static void
value_var_entry_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 23 "src/variables.vala"
	if (src_value->data[0].v_pointer) {
#line 23 "src/variables.vala"
		dest_value->data[0].v_pointer = var_entry_ref (src_value->data[0].v_pointer);
#line 409 "variables.c"
	} else {
#line 23 "src/variables.vala"
		dest_value->data[0].v_pointer = NULL;
#line 413 "variables.c"
	}
}

static gpointer
value_var_entry_peek_pointer (const GValue* value)
{
#line 23 "src/variables.vala"
	return value->data[0].v_pointer;
#line 422 "variables.c"
}

static gchar*
value_var_entry_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 23 "src/variables.vala"
	if (collect_values[0].v_pointer) {
#line 433 "variables.c"
		VarEntry * object;
		object = collect_values[0].v_pointer;
#line 23 "src/variables.vala"
		if (object->parent_instance.g_class == NULL) {
#line 23 "src/variables.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 440 "variables.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 23 "src/variables.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 444 "variables.c"
		}
#line 23 "src/variables.vala"
		value->data[0].v_pointer = var_entry_ref (object);
#line 448 "variables.c"
	} else {
#line 23 "src/variables.vala"
		value->data[0].v_pointer = NULL;
#line 452 "variables.c"
	}
#line 23 "src/variables.vala"
	return NULL;
#line 456 "variables.c"
}

static gchar*
value_var_entry_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	VarEntry ** object_p;
	object_p = collect_values[0].v_pointer;
#line 23 "src/variables.vala"
	if (!object_p) {
#line 23 "src/variables.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 471 "variables.c"
	}
#line 23 "src/variables.vala"
	if (!value->data[0].v_pointer) {
#line 23 "src/variables.vala"
		*object_p = NULL;
#line 477 "variables.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 23 "src/variables.vala"
		*object_p = value->data[0].v_pointer;
#line 481 "variables.c"
	} else {
#line 23 "src/variables.vala"
		*object_p = var_entry_ref (value->data[0].v_pointer);
#line 485 "variables.c"
	}
#line 23 "src/variables.vala"
	return NULL;
#line 489 "variables.c"
}

GParamSpec*
param_spec_var_entry (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecVarEntry* spec;
#line 23 "src/variables.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VAR_ENTRY), NULL);
#line 23 "src/variables.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 23 "src/variables.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 23 "src/variables.vala"
	return G_PARAM_SPEC (spec);
#line 508 "variables.c"
}

gpointer
value_get_var_entry (const GValue* value)
{
#line 23 "src/variables.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VAR_ENTRY), NULL);
#line 23 "src/variables.vala"
	return value->data[0].v_pointer;
#line 518 "variables.c"
}

void
value_set_var_entry (GValue* value,
                     gpointer v_object)
{
	VarEntry * old;
#line 23 "src/variables.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VAR_ENTRY));
#line 23 "src/variables.vala"
	old = value->data[0].v_pointer;
#line 23 "src/variables.vala"
	if (v_object) {
#line 23 "src/variables.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VAR_ENTRY));
#line 23 "src/variables.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 23 "src/variables.vala"
		value->data[0].v_pointer = v_object;
#line 23 "src/variables.vala"
		var_entry_ref (value->data[0].v_pointer);
#line 540 "variables.c"
	} else {
#line 23 "src/variables.vala"
		value->data[0].v_pointer = NULL;
#line 544 "variables.c"
	}
#line 23 "src/variables.vala"
	if (old) {
#line 23 "src/variables.vala"
		var_entry_unref (old);
#line 550 "variables.c"
	}
}

void
value_take_var_entry (GValue* value,
                      gpointer v_object)
{
	VarEntry * old;
#line 23 "src/variables.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VAR_ENTRY));
#line 23 "src/variables.vala"
	old = value->data[0].v_pointer;
#line 23 "src/variables.vala"
	if (v_object) {
#line 23 "src/variables.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VAR_ENTRY));
#line 23 "src/variables.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 23 "src/variables.vala"
		value->data[0].v_pointer = v_object;
#line 571 "variables.c"
	} else {
#line 23 "src/variables.vala"
		value->data[0].v_pointer = NULL;
#line 575 "variables.c"
	}
#line 23 "src/variables.vala"
	if (old) {
#line 23 "src/variables.vala"
		var_entry_unref (old);
#line 581 "variables.c"
	}
}

static void
var_entry_class_init (VarEntryClass * klass,
                      gpointer klass_data)
{
#line 23 "src/variables.vala"
	var_entry_parent_class = g_type_class_peek_parent (klass);
#line 23 "src/variables.vala"
	((VarEntryClass *) klass)->finalize = var_entry_finalize;
#line 593 "variables.c"
}

static void
var_entry_instance_init (VarEntry * self,
                         gpointer klass)
{
#line 23 "src/variables.vala"
	self->ref_count = 1;
#line 602 "variables.c"
}

static void
var_entry_finalize (VarEntry * obj)
{
	VarEntry * self;
#line 23 "src/variables.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VAR_ENTRY, VarEntry);
#line 23 "src/variables.vala"
	g_signal_handlers_destroy (self);
#line 24 "src/variables.vala"
	_g_free0 (self->name);
#line 25 "src/variables.vala"
	_g_free0 (self->defval);
#line 26 "src/variables.vala"
	_g_free0 (self->val);
#line 28 "src/variables.vala"
	_g_free0 (self->doc);
#line 621 "variables.c"
}

static GType
var_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_var_entry_init, value_var_entry_free_value, value_var_entry_copy_value, value_var_entry_peek_pointer, "p", value_var_entry_collect_value, "p", value_var_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VarEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) var_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VarEntry), 0, (GInstanceInitFunc) var_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType var_entry_type_id;
	var_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VarEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return var_entry_type_id;
}

GType
var_entry_get_type (void)
{
	static volatile gsize var_entry_type_id__volatile = 0;
	if (g_once_init_enter (&var_entry_type_id__volatile)) {
		GType var_entry_type_id;
		var_entry_type_id = var_entry_get_type_once ();
		g_once_init_leave (&var_entry_type_id__volatile, var_entry_type_id);
	}
	return var_entry_type_id__volatile;
}

gpointer
var_entry_ref (gpointer instance)
{
	VarEntry * self;
	self = instance;
#line 23 "src/variables.vala"
	g_atomic_int_inc (&self->ref_count);
#line 23 "src/variables.vala"
	return instance;
#line 656 "variables.c"
}

void
var_entry_unref (gpointer instance)
{
	VarEntry * self;
	self = instance;
#line 23 "src/variables.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 23 "src/variables.vala"
		VAR_ENTRY_GET_CLASS (self)->finalize (self);
#line 23 "src/variables.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 670 "variables.c"
	}
}

static gpointer
_var_entry_ref0 (gpointer self)
{
#line 39 "src/variables.vala"
	return self ? var_entry_ref (self) : NULL;
#line 679 "variables.c"
}

void
init_builtin_var (const gchar* name,
                  const gchar* defval,
                  gboolean local,
                  const gchar* doc)
{
	VarEntry* v = NULL;
	VarEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	VarEntry* _tmp8_;
#line 33 "src/variables.vala"
	g_return_if_fail (name != NULL);
#line 33 "src/variables.vala"
	g_return_if_fail (defval != NULL);
#line 33 "src/variables.vala"
	g_return_if_fail (doc != NULL);
#line 34 "src/variables.vala"
	_tmp0_ = var_entry_new ();
#line 34 "src/variables.vala"
	v = _tmp0_;
#line 35 "src/variables.vala"
	_tmp1_ = g_strdup (name);
#line 35 "src/variables.vala"
	_g_free0 (v->name);
#line 35 "src/variables.vala"
	v->name = _tmp1_;
#line 36 "src/variables.vala"
	_tmp2_ = g_strdup (defval);
#line 36 "src/variables.vala"
	_g_free0 (v->defval);
#line 36 "src/variables.vala"
	v->defval = _tmp2_;
#line 36 "src/variables.vala"
	_tmp3_ = v->defval;
#line 36 "src/variables.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 36 "src/variables.vala"
	_g_free0 (v->val);
#line 36 "src/variables.vala"
	v->val = _tmp4_;
#line 37 "src/variables.vala"
	v->local = local;
#line 38 "src/variables.vala"
	_tmp5_ = g_strdup (doc);
#line 38 "src/variables.vala"
	_g_free0 (v->doc);
#line 38 "src/variables.vala"
	v->doc = _tmp5_;
#line 39 "src/variables.vala"
	_tmp6_ = main_vars;
#line 39 "src/variables.vala"
	_tmp7_ = g_strdup (name);
#line 39 "src/variables.vala"
	_tmp8_ = _var_entry_ref0 (v);
#line 39 "src/variables.vala"
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
#line 33 "src/variables.vala"
	_var_entry_unref0 (v);
#line 746 "variables.c"
}

static void
_g_free0_ (gpointer var)
{
#line 43 "src/variables.vala"
	var = (g_free (var), NULL);
#line 754 "variables.c"
}

static void
_var_entry_unref0_ (gpointer var)
{
#line 43 "src/variables.vala"
	(var == NULL) ? NULL : (var = (var_entry_unref (var), NULL));
#line 762 "variables.c"
}

GHashTable*
new_varlist (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* result = NULL;
#line 43 "src/variables.vala"
	_tmp0_ = g_str_hash;
#line 43 "src/variables.vala"
	_tmp1_ = g_str_equal;
#line 43 "src/variables.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _var_entry_unref0_);
#line 43 "src/variables.vala"
	result = _tmp2_;
#line 43 "src/variables.vala"
	return result;
#line 782 "variables.c"
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
#line 49 "src/variables.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 790 "variables.c"
}

void
set_variable (const gchar* name,
              const gchar* val)
{
	GHashTable* var_list = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	VarEntry* v = NULL;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	VarEntry* _tmp4_;
	gboolean _tmp5_ = FALSE;
	VarEntry* _tmp6_;
	VarEntry* _tmp15_;
	VarEntry* _tmp22_;
	gchar* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	VarEntry* _tmp26_;
	VarEntry* _tmp27_;
#line 46 "src/variables.vala"
	g_return_if_fail (name != NULL);
#line 46 "src/variables.vala"
	g_return_if_fail (val != NULL);
#line 49 "src/variables.vala"
	_tmp0_ = main_vars;
#line 49 "src/variables.vala"
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
#line 49 "src/variables.vala"
	var_list = _tmp1_;
#line 50 "src/variables.vala"
	_tmp2_ = main_vars;
#line 50 "src/variables.vala"
	_tmp3_ = g_hash_table_lookup (_tmp2_, name);
#line 50 "src/variables.vala"
	_tmp4_ = _var_entry_ref0 ((VarEntry*) _tmp3_);
#line 50 "src/variables.vala"
	v = _tmp4_;
#line 51 "src/variables.vala"
	_tmp6_ = v;
#line 51 "src/variables.vala"
	if (_tmp6_ != NULL) {
#line 835 "variables.c"
		VarEntry* _tmp7_;
#line 51 "src/variables.vala"
		_tmp7_ = v;
#line 51 "src/variables.vala"
		_tmp5_ = _tmp7_->local;
#line 841 "variables.c"
	} else {
#line 51 "src/variables.vala"
		_tmp5_ = FALSE;
#line 845 "variables.c"
	}
#line 51 "src/variables.vala"
	if (_tmp5_) {
#line 849 "variables.c"
		Buffer* _tmp8_;
		GHashTable* _tmp9_;
		Buffer* _tmp12_;
		GHashTable* _tmp13_;
		GHashTable* _tmp14_;
#line 52 "src/variables.vala"
		_tmp8_ = cur_bp;
#line 52 "src/variables.vala"
		_tmp9_ = _tmp8_->vars;
#line 52 "src/variables.vala"
		if (_tmp9_ == NULL) {
#line 861 "variables.c"
			Buffer* _tmp10_;
			GHashTable* _tmp11_;
#line 53 "src/variables.vala"
			_tmp10_ = cur_bp;
#line 53 "src/variables.vala"
			_tmp11_ = new_varlist ();
#line 53 "src/variables.vala"
			_g_hash_table_unref0 (_tmp10_->vars);
#line 53 "src/variables.vala"
			_tmp10_->vars = _tmp11_;
#line 872 "variables.c"
		}
#line 54 "src/variables.vala"
		_tmp12_ = cur_bp;
#line 54 "src/variables.vala"
		_tmp13_ = _tmp12_->vars;
#line 54 "src/variables.vala"
		_tmp14_ = _g_hash_table_ref0 (_tmp13_);
#line 54 "src/variables.vala"
		_g_hash_table_unref0 (var_list);
#line 54 "src/variables.vala"
		var_list = _tmp14_;
#line 884 "variables.c"
	}
#line 58 "src/variables.vala"
	_tmp15_ = v;
#line 58 "src/variables.vala"
	if (_tmp15_ == NULL) {
#line 890 "variables.c"
		VarEntry* _tmp16_;
		VarEntry* _tmp17_;
		gchar* _tmp18_;
		VarEntry* _tmp19_;
		VarEntry* _tmp20_;
		gchar* _tmp21_;
#line 59 "src/variables.vala"
		_tmp16_ = var_entry_new ();
#line 59 "src/variables.vala"
		_var_entry_unref0 (v);
#line 59 "src/variables.vala"
		v = _tmp16_;
#line 60 "src/variables.vala"
		_tmp17_ = v;
#line 60 "src/variables.vala"
		_tmp18_ = g_strdup (val);
#line 60 "src/variables.vala"
		_g_free0 (_tmp17_->defval);
#line 60 "src/variables.vala"
		_tmp17_->defval = _tmp18_;
#line 61 "src/variables.vala"
		_tmp19_ = v;
#line 61 "src/variables.vala"
		_tmp19_->local = FALSE;
#line 62 "src/variables.vala"
		_tmp20_ = v;
#line 62 "src/variables.vala"
		_tmp21_ = g_strdup ("");
#line 62 "src/variables.vala"
		_g_free0 (_tmp20_->doc);
#line 62 "src/variables.vala"
		_tmp20_->doc = _tmp21_;
#line 923 "variables.c"
	}
#line 66 "src/variables.vala"
	_tmp22_ = v;
#line 66 "src/variables.vala"
	_tmp23_ = g_strdup (val);
#line 66 "src/variables.vala"
	_g_free0 (_tmp22_->val);
#line 66 "src/variables.vala"
	_tmp22_->val = _tmp23_;
#line 69 "src/variables.vala"
	_tmp24_ = var_list;
#line 69 "src/variables.vala"
	_tmp25_ = g_strdup (name);
#line 69 "src/variables.vala"
	_tmp26_ = v;
#line 69 "src/variables.vala"
	_tmp27_ = _var_entry_ref0 (_tmp26_);
#line 69 "src/variables.vala"
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp27_);
#line 46 "src/variables.vala"
	_var_entry_unref0 (v);
#line 46 "src/variables.vala"
	_g_hash_table_unref0 (var_list);
#line 947 "variables.c"
}

VarEntry*
get_variable_entry (Buffer* bp,
                    const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	VarEntry* _tmp7_;
	VarEntry* result = NULL;
#line 72 "src/variables.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 73 "src/variables.vala"
	if (bp != NULL) {
#line 963 "variables.c"
		GHashTable* _tmp1_;
#line 73 "src/variables.vala"
		_tmp1_ = bp->vars;
#line 73 "src/variables.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 969 "variables.c"
	} else {
#line 73 "src/variables.vala"
		_tmp0_ = FALSE;
#line 973 "variables.c"
	}
#line 73 "src/variables.vala"
	if (_tmp0_) {
#line 977 "variables.c"
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
		VarEntry* _tmp4_;
#line 74 "src/variables.vala"
		_tmp2_ = bp->vars;
#line 74 "src/variables.vala"
		_tmp3_ = g_hash_table_lookup (_tmp2_, name);
#line 74 "src/variables.vala"
		_tmp4_ = _var_entry_ref0 ((VarEntry*) _tmp3_);
#line 74 "src/variables.vala"
		result = _tmp4_;
#line 74 "src/variables.vala"
		return result;
#line 991 "variables.c"
	}
#line 75 "src/variables.vala"
	_tmp5_ = main_vars;
#line 75 "src/variables.vala"
	_tmp6_ = g_hash_table_lookup (_tmp5_, name);
#line 75 "src/variables.vala"
	_tmp7_ = _var_entry_ref0 ((VarEntry*) _tmp6_);
#line 75 "src/variables.vala"
	result = _tmp7_;
#line 75 "src/variables.vala"
	return result;
#line 1003 "variables.c"
}

const gchar*
get_variable_doc (const gchar* name,
                  const gchar* * defval)
{
	const gchar* _vala_defval = NULL;
	VarEntry* v = NULL;
	VarEntry* _tmp0_;
	VarEntry* _tmp1_;
	VarEntry* _tmp2_;
	const gchar* _tmp3_;
	VarEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* result = NULL;
#line 78 "src/variables.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 79 "src/variables.vala"
	_tmp0_ = get_variable_entry (NULL, name);
#line 79 "src/variables.vala"
	v = _tmp0_;
#line 80 "src/variables.vala"
	_tmp1_ = v;
#line 80 "src/variables.vala"
	if (_tmp1_ == NULL) {
#line 81 "src/variables.vala"
		_vala_defval = NULL;
#line 82 "src/variables.vala"
		result = NULL;
#line 82 "src/variables.vala"
		_var_entry_unref0 (v);
#line 82 "src/variables.vala"
		if (defval) {
#line 82 "src/variables.vala"
			*defval = _vala_defval;
#line 1039 "variables.c"
		}
#line 82 "src/variables.vala"
		return result;
#line 1043 "variables.c"
	}
#line 85 "src/variables.vala"
	_tmp2_ = v;
#line 85 "src/variables.vala"
	_tmp3_ = _tmp2_->defval;
#line 85 "src/variables.vala"
	_vala_defval = _tmp3_;
#line 86 "src/variables.vala"
	_tmp4_ = v;
#line 86 "src/variables.vala"
	_tmp5_ = _tmp4_->doc;
#line 86 "src/variables.vala"
	result = _tmp5_;
#line 86 "src/variables.vala"
	_var_entry_unref0 (v);
#line 86 "src/variables.vala"
	if (defval) {
#line 86 "src/variables.vala"
		*defval = _vala_defval;
#line 1063 "variables.c"
	}
#line 86 "src/variables.vala"
	return result;
#line 1067 "variables.c"
}

const gchar*
get_variable (const gchar* name)
{
	VarEntry* v = NULL;
	Buffer* _tmp0_;
	VarEntry* _tmp1_;
	const gchar* _tmp2_ = NULL;
	VarEntry* _tmp3_;
	const gchar* result = NULL;
#line 89 "src/variables.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 90 "src/variables.vala"
	_tmp0_ = cur_bp;
#line 90 "src/variables.vala"
	_tmp1_ = get_variable_entry (_tmp0_, name);
#line 90 "src/variables.vala"
	v = _tmp1_;
#line 91 "src/variables.vala"
	_tmp3_ = v;
#line 91 "src/variables.vala"
	if (_tmp3_ != NULL) {
#line 1091 "variables.c"
		VarEntry* _tmp4_;
		const gchar* _tmp5_;
#line 91 "src/variables.vala"
		_tmp4_ = v;
#line 91 "src/variables.vala"
		_tmp5_ = _tmp4_->val;
#line 91 "src/variables.vala"
		_tmp2_ = _tmp5_;
#line 1100 "variables.c"
	} else {
#line 91 "src/variables.vala"
		_tmp2_ = NULL;
#line 1104 "variables.c"
	}
#line 91 "src/variables.vala"
	result = _tmp2_;
#line 91 "src/variables.vala"
	_var_entry_unref0 (v);
#line 91 "src/variables.vala"
	return result;
#line 1112 "variables.c"
}

gboolean
get_variable_bool (const gchar* name)
{
	gchar* val = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result = FALSE;
#line 94 "src/variables.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 95 "src/variables.vala"
	_tmp0_ = get_variable (name);
#line 95 "src/variables.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 95 "src/variables.vala"
	val = _tmp1_;
#line 96 "src/variables.vala"
	_tmp2_ = val;
#line 96 "src/variables.vala"
	if (_tmp2_ != NULL) {
#line 1135 "variables.c"
		GEqualFunc _tmp3_;
		const gchar* _tmp4_;
#line 97 "src/variables.vala"
		_tmp3_ = g_str_equal;
#line 97 "src/variables.vala"
		_tmp4_ = val;
#line 97 "src/variables.vala"
		result = !_tmp3_ (_tmp4_, "nil");
#line 97 "src/variables.vala"
		_g_free0 (val);
#line 97 "src/variables.vala"
		return result;
#line 1148 "variables.c"
	}
#line 98 "src/variables.vala"
	result = FALSE;
#line 98 "src/variables.vala"
	_g_free0 (val);
#line 98 "src/variables.vala"
	return result;
#line 1156 "variables.c"
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
#line 101 "src/variables.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 101 "src/variables.vala"
	return _data13_;
#line 1166 "variables.c"
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 101 "src/variables.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 101 "src/variables.vala"
		_completion_unref0 (_data13_->cp);
#line 101 "src/variables.vala"
		g_slice_free (Block13Data, _data13_);
#line 1180 "variables.c"
	}
}

static void
__lambda91_ (Block13Data* _data13_,
             const gchar* key,
             VarEntry* val)
{
	GeeSortedSet* _tmp0_;
	const gchar* _tmp1_;
#line 103 "src/variables.vala"
	g_return_if_fail (key != NULL);
#line 103 "src/variables.vala"
	g_return_if_fail (val != NULL);
#line 104 "src/variables.vala"
	_tmp0_ = _data13_->cp->completions;
#line 104 "src/variables.vala"
	_tmp1_ = val->name;
#line 104 "src/variables.vala"
	gee_collection_add ((GeeCollection*) _tmp0_, _tmp1_);
#line 1201 "variables.c"
}

static void
___lambda91__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
#line 103 "src/variables.vala"
	__lambda91_ (self, (const gchar*) key, (VarEntry*) value);
#line 1211 "variables.c"
}

gchar*
minibuf_read_variable_name (const gchar* fmt,
                            ...)
{
	Block13Data* _data13_;
	Completion* _tmp0_;
	GHashTable* _tmp1_;
	va_list _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 101 "src/variables.vala"
	g_return_val_if_fail (fmt != NULL, NULL);
#line 101 "src/variables.vala"
	_data13_ = g_slice_new0 (Block13Data);
#line 101 "src/variables.vala"
	_data13_->_ref_count_ = 1;
#line 102 "src/variables.vala"
	_tmp0_ = completion_new (FALSE);
#line 102 "src/variables.vala"
	_data13_->cp = _tmp0_;
#line 103 "src/variables.vala"
	_tmp1_ = main_vars;
#line 103 "src/variables.vala"
	g_hash_table_foreach (_tmp1_, ___lambda91__gh_func, _data13_);
#line 107 "src/variables.vala"
	va_start (_tmp2_, fmt);
#line 107 "src/variables.vala"
	_tmp3_ = minibuf_vread_completion (fmt, "", _data13_->cp, NULL, "No variable name given", "Undefined variable name `%s'", _tmp2_);
#line 107 "src/variables.vala"
	_tmp4_ = _tmp3_;
#line 107 "src/variables.vala"
	va_end (_tmp2_);
#line 107 "src/variables.vala"
	result = _tmp4_;
#line 107 "src/variables.vala"
	block13_data_unref (_data13_);
#line 107 "src/variables.vala"
	_data13_ = NULL;
#line 107 "src/variables.vala"
	return result;
#line 1255 "variables.c"
}

static gboolean
__lambda136_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* name = NULL;
	gpointer _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* val = NULL;
	gpointer _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	gboolean result = FALSE;
#line 117 "src/variables.vala"
	ok = TRUE;
#line 118 "src/variables.vala"
	_tmp0_ = gee_queue_poll (args);
#line 118 "src/variables.vala"
	name = (gchar*) _tmp0_;
#line 119 "src/variables.vala"
	_tmp1_ = name;
#line 119 "src/variables.vala"
	if (_tmp1_ == NULL) {
#line 1282 "variables.c"
		gchar* _tmp2_;
#line 120 "src/variables.vala"
		_tmp2_ = minibuf_read_variable_name ("Set variable: ", NULL);
#line 120 "src/variables.vala"
		_g_free0 (name);
#line 120 "src/variables.vala"
		name = _tmp2_;
#line 1290 "variables.c"
	}
#line 121 "src/variables.vala"
	_tmp3_ = name;
#line 121 "src/variables.vala"
	if (_tmp3_ == NULL) {
#line 122 "src/variables.vala"
		result = FALSE;
#line 122 "src/variables.vala"
		_g_free0 (name);
#line 122 "src/variables.vala"
		return result;
#line 1302 "variables.c"
	}
#line 123 "src/variables.vala"
	_tmp4_ = gee_queue_poll (args);
#line 123 "src/variables.vala"
	val = (gchar*) _tmp4_;
#line 124 "src/variables.vala"
	_tmp5_ = val;
#line 124 "src/variables.vala"
	if (_tmp5_ == NULL) {
#line 1312 "variables.c"
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 125 "src/variables.vala"
		_tmp6_ = name;
#line 125 "src/variables.vala"
		_tmp7_ = minibuf_read ("Set %s to value: ", "", _tmp6_, NULL);
#line 125 "src/variables.vala"
		_g_free0 (val);
#line 125 "src/variables.vala"
		val = _tmp7_;
#line 1323 "variables.c"
	}
#line 126 "src/variables.vala"
	_tmp8_ = val;
#line 126 "src/variables.vala"
	if (_tmp8_ == NULL) {
#line 127 "src/variables.vala"
		ok = funcall ("keyboard-quit", NULL, NULL);
#line 1331 "variables.c"
	}
#line 129 "src/variables.vala"
	if (ok) {
#line 1335 "variables.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 130 "src/variables.vala"
		_tmp9_ = name;
#line 130 "src/variables.vala"
		_tmp10_ = val;
#line 130 "src/variables.vala"
		set_variable (_tmp9_, _tmp10_);
#line 1344 "variables.c"
	}
#line 131 "src/variables.vala"
	result = ok;
#line 131 "src/variables.vala"
	_g_free0 (val);
#line 131 "src/variables.vala"
	_g_free0 (name);
#line 131 "src/variables.vala"
	return result;
#line 1354 "variables.c"
}

static gboolean
___lambda136__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda136_ (uniarg, args);
#line 114 "src/variables.vala"
	return result;
#line 1365 "variables.c"
}

void
variables_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
#line 114 "src/variables.vala"
	_tmp0_ = lisp_func_new ("set-variable", ___lambda136__function, TRUE, "Set a variable value to the user-specified value.");
#line 114 "src/variables.vala"
	_tmp1_ = _tmp0_;
#line 114 "src/variables.vala"
	_lisp_func_unref0 (_tmp1_);
#line 1379 "variables.c"
}

