/***************************************************************************
                          kwifimanager.cpp  -  description
                             -------------------
    begin                : Sam Apr  7 11:44:20 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for C++
#include <iostream>
#include <fstream>

// include files for QT
#include <qdatetime.h>
#include <qdir.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qimage.h>

// include files for KDE
#include <kmenubar.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <kdebug.h>
#include <kstdguiitem.h>

// application specific includes
#include "kwifimanager.h"
#include "wirelesstools.h"

extern "C" {
  #include <iwlib.h>
}

#define ID_STATUS_MSG 1

deviceinfo *information = new (deviceinfo);
statistical_data daten;
QStringList APs;

KWiFiManagerApp::KWiFiManagerApp (QWidget *, const char *name):
KMainWindow (0, name)
{
    statistik = 0;
  already_warned = false;
  kdDebug() << "This is KWiFiManager, version is 1.1\n";
  old_net_name = "Softdrinks rule!";
  kdDebug() << "Initializing AccessPoint WHOIS database...\n";
  init_whois_db ();
  repaint_all = 0;
  if ((information->skfd = iw_sockets_open ()) < 0)
    {
      perror ("Error opening socket!");
      exit (-1);
    }

  for (int i = 0; i < 240; i++)
    {
      daten.valid[i] = false;
    }

  // these values have to be initialised since they are used to scale the
  // stats output. A zero-initialision is not good because some cards either
  // always stay above zero or below zero, which would ruin the scaling.
  daten.sigLevelMax = -32000;
  daten.noiseLevelMax = -32000;
  daten.sigLevelMin = 32000;
  daten.noiseLevelMin = 32000;

  information->used_interface="";
  information->used_interface = return_info (information, true);
  if (information->used_interface == "")
    {
      this->setCaption (i18n ("No Interface"));
    }
  else
    {
      this->setCaption (i18n ("Interface %1").arg (information->used_interface.latin1 ()));
    }
  initActions ();
  initView ();

  fileDisableRadio->setEnabled (true);

  counter = new QTimer (this);
  connect (counter, SIGNAL (timeout ()), this, SLOT (slotTheEvilLoop ()));
  counter->start (1000);

  tricorder_trigger = new QTimer ();
  connect (tricorder_trigger, SIGNAL (timeout ()), this, SLOT (tricorder_beep ()));
  trayicon = new KSystemTray(this);
  trayicon->show();
  connect(trayicon,SIGNAL(quitSelected()),this,SLOT(slotFileQuit()));
}

KWiFiManagerApp::~KWiFiManagerApp()
{
    kdDebug() << "Thank you for using KWiFiManager. You have made a simple program very happy.\n";
    delete statistik;
    delete tricorder_trigger;
}

void
KWiFiManagerApp::init_whois_db ()
{
  KStandardDirs finder;
  QString kdedir = finder.findResourceDir ("data", "kwifimanager/locations/NOWHERE.loc");
  kdedir += "kwifimanager/locations/";
  QDir *locations = new QDir (kdedir);
  if (!locations->exists ())
    kdDebug() << "A grave error occurred while searching for files with AccessPoint information.\n";
  QStringList *entries = new QStringList (locations->entryList ());
  QString content;
  QString content2;
  for (QStringList::Iterator it = entries->begin (); it != entries->end (); it++)
    {
      if ((*it) != "." && (*it) != "..")
	{
	  QFile datei (kdedir + (*it));
	  datei.open (IO_ReadOnly);
	  while (datei.readLine (content, 255) != -1)
	    {
	      QString temp (content);
	      content.truncate (content.find (' '));
	      content=content.upper();
	      content2 = temp.right (temp.length () - temp.find (' ') - 1);
	      content2.truncate (content2.length () - 1);
	      APs << content << content2;
	    }
	  datei.close ();
	}
    }
  delete entries;
  delete locations;
}

void
KWiFiManagerApp::slotTheEvilLoop ()
{

  deviceinfo compare = *information;
  // Step 1: detect the interface
  QString temp = information->used_interface;
  information->used_interface = return_info (information, true);
  if (information->used_interface != temp)
    {
      repaint_all = 5;
      if (information->used_interface == "")
	{
	  this->setCaption (i18n ("No Interface"));
	}
      else
	{
	  this->setCaption (i18n ("Interface %1").arg (information->used_interface));
	}
    }

  // Step 2: if interface changed, log the new network name
  if ((information->qual.qual > 0) && (old_net_name != information->essid && old_net_name != "Softdrinks rule!"))
    {
      old_net_name = information->essid;
      QString kdedir = getenv ("HOME");
      kdedir += "/.wireless-log";
      QFile ausgabe2 (kdedir);
      if (!ausgabe2.open (IO_Append))
	kdDebug() << "Logging failed!\n";
      QDateTime zeit;
      ausgabe2.writeBlock (zeit.toString ().latin1 (), 255);
      ausgabe2.writeBlock (" Entering network: ", 255);
      ausgabe2.writeBlock (information->essid.latin1(), 255);
      ausgabe2.writeBlock (" Strength: ", 255);
      QString tempausgabe="%1";
      tempausgabe=tempausgabe.arg(information->qual.qual);
      ausgabe2.writeBlock (tempausgabe.latin1 (), 255);
      ausgabe2.writeBlock ("\n", 2);
      ausgabe2.close ();
    }

  // Step 3: Repaint the widgets
  int differ = compare == *information;	// yes, it's true: the == operator on deviceinfo returns an int!
  if ((differ % 2 == 1) || (repaint_all > 0))
    {
      strength->repaint ();
      if (!strength->isVisible()) strength->updateInfo(NULL);
      differ -= 1;
    }
  if ((differ % 4 == 2) || (repaint_all > 0))
    {
      status->repaint ();
      location->repaint ();
      differ -= 2;
    }
  if ((differ % 8 == 4) || (repaint_all > 0))
    {
      pictogram->repaint ();
      differ -= 4;
    }
  if ((differ == 8) || repaint_all > 0)
    {
      speedmeter->repaint ();
      differ -= 8;
    }
  if (repaint_all > 0)
    repaint_all--;
  // Step 4: Gather statistical information
  if ((information->has_freq == 1) && (information->mode == 2)) {
    daten.valid[daten.current] = true;
    daten.sigLevel[daten.current] = information->qual.level;
    if (information->qual.level < daten.sigLevelMin) daten.sigLevelMin = information->qual.level;
    if (information->qual.level > daten.sigLevelMax) daten.sigLevelMax = information->qual.level;
    daten.noiseLevel[daten.current] = information->qual.noise;
    if (information->qual.noise < daten.noiseLevelMin) daten.noiseLevelMin = information->qual.noise;
    if (information->qual.noise > daten.noiseLevelMax) daten.noiseLevelMax = information->qual.noise;
    daten.qual[daten.current] = information->qual.qual;
  } else {
    daten.valid[daten.current] = false;
  }

  if (statistik != 0 && statistik->isVisible ()) statistik->repaint ();
  daten.current < 239 ? daten.current += 1 : daten.current = 0;
}

void KWiFiManagerApp::slotChangeTrayIcon(QPixmap* newpic, QString& newstrength)
{
  QPixmap temp(30,30);
  QPainter bla(&temp);
  if (paletteBackgroundPixmap()==0) {
	bla.fillRect(0,0,30,30,backgroundBrush()); }
    else {
	bla.drawPixmap(0,0,*paletteBackgroundPixmap()); }
  bla.drawText(0,0,15,15,0,newstrength);
  bla.drawPixmap(1,4,*newpic);
  trayicon->setPixmap(temp);
  this->setIcon(temp);
}

void
KWiFiManagerApp::initActions ()
{
  fileDisableRadio = new KToggleAction (i18n ("&Disable Radio"), 0, this, SLOT (slotDisableRadio ()), actionCollection ());
  fileQuit = KStdAction::quit (this, SLOT (slotFileQuit ()), actionCollection ());
  KAction *conf = new KAction (i18n ("Configuration &Editor"), 0, this,
			       SLOT (slotStartConfigEditor ()), this);
  KAction *stat = new KAction (i18n ("Connection &Statistics"), 0, this,
			       SLOT (slotStartStatViewer ()), this);
  KAction *tric = new KToggleAction (i18n ("&Acoustic Scanning"), 0, this,
				     SLOT (slotToggleTric ()), actionCollection ());
  KPopupMenu *help = helpMenu (QString::null, false);
  QPopupMenu *filemenu = new QPopupMenu;
  QPopupMenu *editmenu = new QPopupMenu;
  conf->plug (editmenu);
  tric->plug (editmenu);
  fileDisableRadio->plug (filemenu);
  stat->plug (filemenu);
  fileQuit->plug (filemenu);
  menuBar ()->insertItem (i18n ("&File"), filemenu);
  menuBar ()->insertItem (i18n ("&Config"), editmenu);
  menuBar ()->insertItem (KStdGuiItem::help().text(), help);
}


void
KWiFiManagerApp::initView ()
{
  view = new QWidget (this, "mainwidget");
  view->setBackgroundMode (PaletteBackground);
  setCentralWidget (view);
  QGridLayout *zentrallayout = new QGridLayout (view);
  speedmeter = new Speed (view);
  status = new Status (view);
  location = new Locator (view);
  strength = new Strength (view);
  pictogram = new Picture (view);
  QToolTip::add (strength, i18n ("Here the current signal strength is displayed."));
  pictogram->setFixedSize (150, 55);
  strength->setFixedSize (150, 120);
  speedmeter->setFixedSize (290, 55);
//      location->setFixedSize(440,20);
  zentrallayout->addWidget (pictogram, 0, 0);
  zentrallayout->addWidget (strength, 1, 0);
  zentrallayout->addWidget (speedmeter, 0, 1);
  zentrallayout->addWidget (status, 1, 1);
  zentrallayout->addMultiCellWidget (location, 2, 2, 0, 1, Qt::AlignLeft);
  connect(strength,SIGNAL(strengthChanged(QPixmap*,QString&)),this,SLOT(slotChangeTrayIcon(QPixmap*,QString&)));
}

void
KWiFiManagerApp::slotStartStatViewer ()
{
    delete statistik;
  statistik = new Statistics (&daten);
  statistik->setFixedSize (590, 300);
  statistik->show ();
}

void
KWiFiManagerApp::slotDisableRadio ()
{
	kdDebug() << "Later, this will deactivate the card's radio.\n";
}

void
KWiFiManagerApp::slotToggleTric ()
{
  if (tricorder_trigger->isActive ())
    {
      tricorder_trigger->stop ();
    }
  else
    {
      tricorder_trigger->start (250);
    }
}

void
KWiFiManagerApp::tricorder_beep ()
{
  sinus_wave (150.0 + information->qual.qual * 20);
  if (information->qual.qual == 0)
    {
      tricorder_trigger->changeInterval (2000);
    }
  else if (information->qual.qual < 10)
    {
      tricorder_trigger->changeInterval (1000);
    }
  else
    {
      tricorder_trigger->changeInterval (500);
    }
}

void
KWiFiManagerApp::slotFileQuit ()
{
  KMainWindow::closeEvent(new QCloseEvent());
}

void
KWiFiManagerApp::slotStartConfigEditor ()
{
  KProcess startConf;
  startConf << "kdesu" << "kcmshell" << "kcmwifi";
  startConf.start (KProcess::DontCare);
}

void
KWiFiManagerApp::closeEvent ( QCloseEvent * )
{
	hide();
}

#include "kwifimanager.moc"

