/***************************************************************************
          kwifimanager.h  -  a graphical interface for wireless LAN cards
                             -------------------
    begin                : Sam Apr  7 11:44:20 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIFIMANAGER_H
#define KWIFIMANAGER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qlabel.h>
#include <qtimer.h>
#include <qpixmap.h>

// include files for KDE
#include <kmainwindow.h>
#include <ksystemtray.h>

// application specific includes
#include "strength.h"
#include "status.h"
#include "picture.h"
#include "locator.h"
#include "speed.h"
#include "statistics.h"

enum speedlevels { AUTO, M1, M2, M55, M11 };
enum packetmode  { UNI, MULTI, BOTH };
enum cryptomodes { OPEN, RESTRICTED };

struct configuration_data
{
  QString net_name[5];
  QString disp_name[5];
  bool managed[5];
  bool crypto_enabled[5];
  int active_crypto_key[5];
  QString active_key_string[5];
  QString crypto1[5], crypto2[5], crypto3[5], crypto4[5];
  bool crypto_is_string1[5], crypto_is_string2[5], crypto_is_string3[5], crypto_is_string4[5];
  cryptomodes crypto_mode[5];
  bool pm_enabled[5];
  int sleep_time[5];
  QString sleep_time_string[5];
  int wake_time[5];
  QString wake_time_string[5];
  speedlevels bitrate[5];
  packetmode packet[5];
};

class KWiFiManagerApp:public KMainWindow
{
Q_OBJECT
  public:
    KWiFiManagerApp (QWidget * parent = 0, const char *name = 0);
   ~KWiFiManagerApp ();
  public slots:
    void slotDisableRadio ();
    void slotFileQuit ();
    void slotStartConfigEditor ();
    void slotStartStatViewer ();
    void slotTheEvilLoop ();
    void slotToggleTric ();
    void slotChangeTrayIcon(QPixmap*,QString&);
    void tricorder_beep ();
  private:
    QString old_net_name;
    void initActions ();
    void initView ();
    void closeEvent ( QCloseEvent *e );
    int socket;
    int repaint_all;		// padding: if a device is detached or inserted, update all widgets repaint_all seconds
    Speed *speedmeter;
    QBoxLayout *bla;
    QLabel *profil;
    Status *status;
    Strength *strength;
    Picture *pictogram;
    Locator *location;
    QWidget *view;
    Statistics *statistik;
    KAction *fileDisableRadio;
    KAction *fileQuit;
    KSystemTray *trayicon;
    void init_whois_db ();
    QTimer *tricorder_trigger, *counter;
    QPixmap *pixmap;
};

#endif /* KWIFIMANAGER_H */
