/*
 * Copyright (c) 2002 Silicon Graphics, Inc.  All Rights Reserved.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it would be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Further, this software is distributed without any warranty that it is
 * free of the rightful claim of any third person regarding infringement
 * or the like.  Any license provided herein, whether implied or
 * otherwise, applies only to this software file.  Patent licenses, if
 * any, provided herein do not apply to combinations of this program with
 * other software, or any other product whatsoever.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston MA 02111-1307, USA.
 * 
 * Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 * Mountain View, CA  94043, or:
 * 
 * http://www.sgi.com 
 * 
 * For further information regarding this notice, see: 
 * 
 * http://oss.sgi.com/projects/GenInfo/SGIGPLNoticeExplan/
 */

#include <xfs/libxfs.h>
#include "xfs_mkfs.h"
#include "maxtrres.h"

/*
 * Maximum transaction reservation tables
 * 
 * Version 1 directories:
 * first dimension log(sectorsize) (base XFS_MIN_SECTORSIZE_LOG)
 * second dimension log(blocksize) (base XFS_MIN_BLOCKSIZE_LOG)
 * third dimension log(inodesize) (base XFS_DINODE_MIN_LOG)
 * 
 * Version 2 directories:
 * first dimension log(sectorsize) (base XFS_MIN_SECTORSIZE_LOG)
 * second dimension log(blocksize) (base XFS_MIN_BLOCKSIZE_LOG)
 * third dimension log(inodesize) (base XFS_DINODE_MIN_LOG)
 * fourth dimension log(dirblocksize) (base XFS_MIN_BLOCKSIZE_LOG)
 */

const int max_trres_v1[DFL_S][DFL_B][DFL_I] = {

    /* ssize (7)  x  bsize[==dsize] (8)  x  isize (4) */

    {   { MAXTRRES_S9_B9_I8_D9_V1,      0,
          0,                            0 },
        { MAXTRRES_S9_B10_I8_D10_V1,    MAXTRRES_S9_B10_I9_D10_V1,
          0,                            0 },
        { MAXTRRES_S9_B11_I8_D11_V1,    MAXTRRES_S9_B11_I9_D11_V1,
          MAXTRRES_S9_B11_I10_D11_V1,   0 },
        { MAXTRRES_S9_B12_I8_D12_V1,    MAXTRRES_S9_B12_I9_D12_V1,
          MAXTRRES_S9_B12_I10_D12_V1,   MAXTRRES_S9_B12_I11_D12_V1 },
        { MAXTRRES_S9_B13_I8_D13_V1,    MAXTRRES_S9_B13_I9_D13_V1,
          MAXTRRES_S9_B13_I10_D13_V1,   MAXTRRES_S9_B13_I11_D13_V1 },
        { MAXTRRES_S9_B14_I8_D14_V1,    MAXTRRES_S9_B14_I9_D14_V1,
          MAXTRRES_S9_B14_I10_D14_V1,   MAXTRRES_S9_B14_I11_D14_V1 },
        { MAXTRRES_S9_B15_I8_D15_V1,    MAXTRRES_S9_B15_I9_D15_V1,
          MAXTRRES_S9_B15_I10_D15_V1,   MAXTRRES_S9_B15_I11_D15_V1 },
        { MAXTRRES_S9_B16_I8_D16_V1,    MAXTRRES_S9_B16_I9_D16_V1,
          MAXTRRES_S9_B16_I10_D16_V1,   MAXTRRES_S9_B16_I11_D16_V1 },
    },

    {   { 0, 0, 0, 0 },
        { MAXTRRES_S10_B10_I8_D10_V1,   MAXTRRES_S10_B10_I9_D10_V1,
          0,                            0 },
        { MAXTRRES_S10_B11_I8_D11_V1,   MAXTRRES_S10_B11_I9_D11_V1,
          MAXTRRES_S10_B11_I10_D11_V1,  0 },
        { MAXTRRES_S10_B12_I8_D12_V1,   MAXTRRES_S10_B12_I9_D12_V1,
          MAXTRRES_S10_B12_I10_D12_V1,  MAXTRRES_S10_B12_I11_D12_V1 },
        { MAXTRRES_S10_B13_I8_D13_V1,   MAXTRRES_S10_B13_I9_D13_V1,
          MAXTRRES_S10_B13_I10_D13_V1,  MAXTRRES_S10_B13_I11_D13_V1 },
        { MAXTRRES_S10_B14_I8_D14_V1,   MAXTRRES_S10_B14_I9_D14_V1,
          MAXTRRES_S10_B14_I10_D14_V1,  MAXTRRES_S10_B14_I11_D14_V1 },
        { MAXTRRES_S10_B15_I8_D15_V1,   MAXTRRES_S10_B15_I9_D15_V1,
          MAXTRRES_S10_B15_I10_D15_V1,  MAXTRRES_S10_B15_I11_D15_V1 },
        { MAXTRRES_S10_B16_I8_D16_V1,   MAXTRRES_S10_B16_I9_D16_V1,
          MAXTRRES_S10_B16_I10_D16_V1,  MAXTRRES_S10_B16_I11_D16_V1 },
    },

    {   { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { MAXTRRES_S11_B11_I8_D11_V1,   MAXTRRES_S11_B11_I9_D11_V1,
          MAXTRRES_S11_B11_I10_D11_V1,  0 },
        { MAXTRRES_S11_B12_I8_D12_V1,   MAXTRRES_S11_B12_I9_D12_V1,
          MAXTRRES_S11_B12_I10_D12_V1,  MAXTRRES_S11_B12_I11_D12_V1 },
        { MAXTRRES_S11_B13_I8_D13_V1,   MAXTRRES_S11_B13_I9_D13_V1,
          MAXTRRES_S11_B13_I10_D13_V1,  MAXTRRES_S11_B13_I11_D13_V1 },
        { MAXTRRES_S11_B14_I8_D14_V1,   MAXTRRES_S11_B14_I9_D14_V1,
          MAXTRRES_S11_B14_I10_D14_V1,  MAXTRRES_S11_B14_I11_D14_V1 },
        { MAXTRRES_S11_B15_I8_D15_V1,   MAXTRRES_S11_B15_I9_D15_V1,
          MAXTRRES_S11_B15_I10_D15_V1,  MAXTRRES_S11_B15_I11_D15_V1 },
        { MAXTRRES_S11_B16_I8_D16_V1,   MAXTRRES_S11_B16_I9_D16_V1,
          MAXTRRES_S11_B16_I10_D16_V1,  MAXTRRES_S11_B16_I11_D16_V1 },
    },

    {   { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { MAXTRRES_S12_B12_I8_D12_V1,   MAXTRRES_S12_B12_I9_D12_V1,
          MAXTRRES_S12_B12_I10_D12_V1,  MAXTRRES_S12_B12_I11_D12_V1 },
        { MAXTRRES_S12_B13_I8_D13_V1,   MAXTRRES_S12_B13_I9_D13_V1,
          MAXTRRES_S12_B13_I10_D13_V1,  MAXTRRES_S12_B13_I11_D13_V1 },
        { MAXTRRES_S12_B14_I8_D14_V1,   MAXTRRES_S12_B14_I9_D14_V1,
          MAXTRRES_S12_B14_I10_D14_V1,  MAXTRRES_S12_B14_I11_D14_V1 },
        { MAXTRRES_S12_B15_I8_D15_V1,   MAXTRRES_S12_B15_I9_D15_V1,
          MAXTRRES_S12_B15_I10_D15_V1,  MAXTRRES_S12_B15_I11_D15_V1 },
        { MAXTRRES_S12_B16_I8_D16_V1,   MAXTRRES_S12_B16_I9_D16_V1,
          MAXTRRES_S12_B16_I10_D16_V1,  MAXTRRES_S12_B16_I11_D16_V1 },
    },

    {   { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { MAXTRRES_S13_B13_I8_D13_V1,   MAXTRRES_S13_B13_I9_D13_V1,
          MAXTRRES_S13_B13_I10_D13_V1,  MAXTRRES_S13_B13_I11_D13_V1 },
        { MAXTRRES_S13_B14_I8_D14_V1,   MAXTRRES_S13_B14_I9_D14_V1,
          MAXTRRES_S13_B14_I10_D14_V1,  MAXTRRES_S13_B14_I11_D14_V1 },
        { MAXTRRES_S13_B15_I8_D15_V1,   MAXTRRES_S13_B15_I9_D15_V1,
          MAXTRRES_S13_B15_I10_D15_V1,  MAXTRRES_S13_B15_I11_D15_V1 },
        { MAXTRRES_S13_B16_I8_D16_V1,   MAXTRRES_S13_B16_I9_D16_V1,
          MAXTRRES_S13_B16_I10_D16_V1,  MAXTRRES_S13_B16_I11_D16_V1 },
    },

    {   { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { MAXTRRES_S14_B14_I8_D14_V1,   MAXTRRES_S14_B14_I9_D14_V1,
          MAXTRRES_S14_B14_I10_D14_V1,  MAXTRRES_S14_B14_I11_D14_V1 },
        { MAXTRRES_S14_B15_I8_D15_V1,   MAXTRRES_S14_B15_I9_D15_V1,
          MAXTRRES_S14_B15_I10_D15_V1,  MAXTRRES_S14_B15_I11_D15_V1 },
        { MAXTRRES_S14_B16_I8_D16_V1,   MAXTRRES_S14_B16_I9_D16_V1,
          MAXTRRES_S14_B16_I10_D16_V1,  MAXTRRES_S14_B16_I11_D16_V1 },
    },

    {   { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { 0, 0, 0, 0 },
        { MAXTRRES_S15_B15_I8_D15_V1,   MAXTRRES_S15_B15_I9_D15_V1,
          MAXTRRES_S15_B15_I10_D15_V1,  MAXTRRES_S15_B15_I11_D15_V1 },
        { MAXTRRES_S15_B16_I8_D16_V1,   MAXTRRES_S15_B16_I9_D16_V1,
          MAXTRRES_S15_B16_I10_D16_V1,  MAXTRRES_S15_B16_I11_D16_V1 },
    },
};


const int max_trres_v2[DFL_S][DFL_B][DFL_I][DFL_D] = {

    /* ssize (7)  x  bsize (8)  x  isize (4)  x  dsize (8) */

    {   {   { MAXTRRES_S9_B9_I8_D9_V2,      MAXTRRES_S9_B9_I8_D10_V2,
              MAXTRRES_S9_B9_I8_D11_V2,     MAXTRRES_S9_B9_I8_D12_V2,
              MAXTRRES_S9_B9_I8_D13_V2,     MAXTRRES_S9_B9_I8_D14_V2,
              MAXTRRES_S9_B9_I8_D15_V2,     MAXTRRES_S9_B9_I8_D16_V2 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            MAXTRRES_S9_B10_I8_D10_V2,
              MAXTRRES_S9_B10_I8_D11_V2,    MAXTRRES_S9_B10_I8_D12_V2,
              MAXTRRES_S9_B10_I8_D13_V2,    MAXTRRES_S9_B10_I8_D14_V2,
              MAXTRRES_S9_B10_I8_D15_V2,    MAXTRRES_S9_B10_I8_D16_V2 },
            { 0,                            MAXTRRES_S9_B10_I9_D10_V2,
              MAXTRRES_S9_B10_I9_D11_V2,    MAXTRRES_S9_B10_I9_D12_V2,
              MAXTRRES_S9_B10_I9_D13_V2,    MAXTRRES_S9_B10_I9_D14_V2,
              MAXTRRES_S9_B10_I9_D15_V2,    MAXTRRES_S9_B10_I9_D16_V2 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              MAXTRRES_S9_B11_I8_D11_V2,    MAXTRRES_S9_B11_I8_D12_V2,
              MAXTRRES_S9_B11_I8_D13_V2,    MAXTRRES_S9_B11_I8_D14_V2,
              MAXTRRES_S9_B11_I8_D15_V2,    MAXTRRES_S9_B11_I8_D16_V2 },
            { 0,                            0,
              MAXTRRES_S9_B11_I9_D11_V2,    MAXTRRES_S9_B11_I9_D12_V2,
              MAXTRRES_S9_B11_I9_D13_V2,    MAXTRRES_S9_B11_I9_D14_V2,
              MAXTRRES_S9_B11_I9_D15_V2,    MAXTRRES_S9_B11_I9_D16_V2 },
            { 0,                            0,
              MAXTRRES_S9_B11_I10_D11_V2,   MAXTRRES_S9_B11_I10_D12_V2,
              MAXTRRES_S9_B11_I10_D13_V2,   MAXTRRES_S9_B11_I10_D14_V2,
              MAXTRRES_S9_B11_I10_D15_V2,   MAXTRRES_S9_B11_I10_D16_V2 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            MAXTRRES_S9_B12_I8_D12_V2,
              MAXTRRES_S9_B12_I8_D13_V2,    MAXTRRES_S9_B12_I8_D14_V2,
              MAXTRRES_S9_B12_I8_D15_V2,    MAXTRRES_S9_B12_I8_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S9_B12_I9_D12_V2,
              MAXTRRES_S9_B12_I9_D13_V2,    MAXTRRES_S9_B12_I9_D14_V2,
              MAXTRRES_S9_B12_I9_D15_V2,    MAXTRRES_S9_B12_I9_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S9_B12_I10_D12_V2,
              MAXTRRES_S9_B12_I10_D13_V2,   MAXTRRES_S9_B12_I10_D14_V2,
              MAXTRRES_S9_B12_I10_D15_V2,   MAXTRRES_S9_B12_I10_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S9_B12_I11_D12_V2,
              MAXTRRES_S9_B12_I11_D13_V2,   MAXTRRES_S9_B12_I11_D14_V2,
              MAXTRRES_S9_B12_I11_D15_V2,   MAXTRRES_S9_B12_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              MAXTRRES_S9_B13_I8_D13_V2,    MAXTRRES_S9_B13_I8_D14_V2,
              MAXTRRES_S9_B13_I8_D15_V2,    MAXTRRES_S9_B13_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S9_B13_I9_D13_V2,    MAXTRRES_S9_B13_I9_D14_V2,
              MAXTRRES_S9_B13_I9_D15_V2,    MAXTRRES_S9_B13_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S9_B13_I10_D13_V2,   MAXTRRES_S9_B13_I10_D14_V2,
              MAXTRRES_S9_B13_I10_D15_V2,   MAXTRRES_S9_B13_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S9_B13_I11_D13_V2,   MAXTRRES_S9_B13_I11_D14_V2,
              MAXTRRES_S9_B13_I11_D15_V2,   MAXTRRES_S9_B13_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B14_I8_D14_V2,
              MAXTRRES_S9_B14_I8_D15_V2,    MAXTRRES_S9_B14_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B14_I9_D14_V2,
              MAXTRRES_S9_B14_I9_D15_V2,    MAXTRRES_S9_B14_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B14_I10_D14_V2,
              MAXTRRES_S9_B14_I10_D15_V2,   MAXTRRES_S9_B14_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B14_I11_D14_V2,
              MAXTRRES_S9_B14_I11_D15_V2,   MAXTRRES_S9_B14_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S9_B15_I8_D15_V2,    MAXTRRES_S9_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S9_B15_I9_D15_V2,    MAXTRRES_S9_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S9_B15_I10_D15_V2,   MAXTRRES_S9_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S9_B15_I11_D15_V2,   MAXTRRES_S9_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S9_B16_I11_D16_V2 },
        },
    },

    {   {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            MAXTRRES_S9_B10_I8_D10_V2,
              MAXTRRES_S10_B10_I8_D11_V2,   MAXTRRES_S10_B10_I8_D12_V2,
              MAXTRRES_S10_B10_I8_D13_V2,   MAXTRRES_S10_B10_I8_D14_V2,
              MAXTRRES_S10_B10_I8_D15_V2,   MAXTRRES_S10_B10_I8_D16_V2 },
            { 0,                            MAXTRRES_S10_B10_I9_D10_V2,
              MAXTRRES_S10_B10_I9_D11_V2,   MAXTRRES_S10_B10_I9_D12_V2,
              MAXTRRES_S10_B10_I9_D13_V2,   MAXTRRES_S10_B10_I9_D14_V2,
              MAXTRRES_S10_B10_I9_D15_V2,   MAXTRRES_S10_B10_I9_D16_V2 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              MAXTRRES_S10_B11_I8_D11_V2,   MAXTRRES_S10_B11_I8_D12_V2,
              MAXTRRES_S10_B11_I8_D13_V2,   MAXTRRES_S10_B11_I8_D14_V2,
              MAXTRRES_S10_B11_I8_D15_V2,   MAXTRRES_S10_B11_I8_D16_V2 },
            { 0,                            0,
              MAXTRRES_S10_B11_I9_D11_V2,   MAXTRRES_S10_B11_I9_D12_V2,
              MAXTRRES_S10_B11_I9_D13_V2,   MAXTRRES_S10_B11_I9_D14_V2,
              MAXTRRES_S10_B11_I9_D15_V2,   MAXTRRES_S10_B11_I9_D16_V2 },
            { 0,                            0,
              MAXTRRES_S10_B11_I10_D11_V2,  MAXTRRES_S10_B11_I10_D12_V2,
              MAXTRRES_S10_B11_I10_D13_V2,  MAXTRRES_S10_B11_I10_D14_V2,
              MAXTRRES_S10_B11_I10_D15_V2,  MAXTRRES_S10_B11_I10_D16_V2 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            MAXTRRES_S10_B12_I8_D12_V2,
              MAXTRRES_S10_B12_I8_D13_V2,   MAXTRRES_S10_B12_I8_D14_V2,
              MAXTRRES_S10_B12_I8_D15_V2,   MAXTRRES_S10_B12_I8_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S10_B12_I9_D12_V2,
              MAXTRRES_S10_B12_I9_D13_V2,   MAXTRRES_S10_B12_I9_D14_V2,
              MAXTRRES_S10_B12_I9_D15_V2,   MAXTRRES_S10_B12_I9_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S10_B12_I10_D12_V2,
              MAXTRRES_S10_B12_I10_D13_V2,  MAXTRRES_S10_B12_I10_D14_V2,
              MAXTRRES_S10_B12_I10_D15_V2,  MAXTRRES_S10_B12_I10_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S10_B12_I11_D12_V2,
              MAXTRRES_S10_B12_I11_D13_V2,  MAXTRRES_S10_B12_I11_D14_V2,
              MAXTRRES_S10_B12_I11_D15_V2,  MAXTRRES_S10_B12_I11_D16_V2 },
        },

        {   { 0,                            0,
              0,                            0,
              MAXTRRES_S10_B13_I8_D13_V2,   MAXTRRES_S10_B13_I8_D14_V2,
              MAXTRRES_S10_B13_I8_D15_V2,   MAXTRRES_S10_B13_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S10_B13_I9_D13_V2,   MAXTRRES_S10_B13_I9_D14_V2,
              MAXTRRES_S10_B13_I9_D15_V2,   MAXTRRES_S10_B13_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S10_B13_I10_D13_V2,  MAXTRRES_S10_B13_I10_D14_V2,
              MAXTRRES_S10_B13_I10_D15_V2,  MAXTRRES_S10_B13_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S10_B13_I11_D13_V2,  MAXTRRES_S10_B13_I11_D14_V2,
              MAXTRRES_S10_B13_I11_D15_V2,  MAXTRRES_S10_B13_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B14_I8_D14_V2,
              MAXTRRES_S10_B14_I8_D15_V2,   MAXTRRES_S10_B14_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B14_I9_D14_V2,
              MAXTRRES_S10_B14_I9_D15_V2,   MAXTRRES_S10_B14_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B14_I10_D14_V2,
              MAXTRRES_S10_B14_I10_D15_V2,  MAXTRRES_S10_B14_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B14_I11_D14_V2,
              MAXTRRES_S10_B14_I11_D15_V2,  MAXTRRES_S10_B14_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S10_B15_I8_D15_V2,   MAXTRRES_S10_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S10_B15_I9_D15_V2,   MAXTRRES_S10_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S10_B15_I10_D15_V2,  MAXTRRES_S10_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S10_B15_I11_D15_V2,  MAXTRRES_S10_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S10_B16_I11_D16_V2 },
        },
    },

    {   {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              MAXTRRES_S11_B11_I8_D11_V2,   MAXTRRES_S11_B11_I8_D12_V2,
              MAXTRRES_S11_B11_I8_D13_V2,   MAXTRRES_S11_B11_I8_D14_V2,
              MAXTRRES_S11_B11_I8_D15_V2,   MAXTRRES_S11_B11_I8_D16_V2 },
            { 0,                            0,
              MAXTRRES_S11_B11_I9_D11_V2,   MAXTRRES_S11_B11_I9_D12_V2,
              MAXTRRES_S11_B11_I9_D13_V2,   MAXTRRES_S11_B11_I9_D14_V2,
              MAXTRRES_S11_B11_I9_D15_V2,   MAXTRRES_S11_B11_I9_D16_V2 },
            { 0,                            0,
              MAXTRRES_S11_B11_I10_D11_V2,  MAXTRRES_S11_B11_I10_D12_V2,
              MAXTRRES_S11_B11_I10_D13_V2,  MAXTRRES_S11_B11_I10_D14_V2,
              MAXTRRES_S11_B11_I10_D15_V2,  MAXTRRES_S11_B11_I10_D16_V2 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            MAXTRRES_S11_B12_I8_D12_V2,
              MAXTRRES_S11_B12_I8_D13_V2,   MAXTRRES_S11_B12_I8_D14_V2,
              MAXTRRES_S11_B12_I8_D15_V2,   MAXTRRES_S11_B12_I8_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S11_B12_I9_D12_V2,
              MAXTRRES_S11_B12_I9_D13_V2,   MAXTRRES_S11_B12_I9_D14_V2,
              MAXTRRES_S11_B12_I9_D15_V2,   MAXTRRES_S11_B12_I9_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S11_B12_I10_D12_V2,
              MAXTRRES_S11_B12_I10_D13_V2,  MAXTRRES_S11_B12_I10_D14_V2,
              MAXTRRES_S11_B12_I10_D15_V2,  MAXTRRES_S11_B12_I10_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S11_B12_I11_D12_V2,
              MAXTRRES_S11_B12_I11_D13_V2,  MAXTRRES_S11_B12_I11_D14_V2,
              MAXTRRES_S11_B12_I11_D15_V2,  MAXTRRES_S11_B12_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              MAXTRRES_S11_B13_I8_D13_V2,   MAXTRRES_S11_B13_I8_D14_V2,
              MAXTRRES_S11_B13_I8_D15_V2,   MAXTRRES_S11_B13_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S11_B13_I9_D13_V2,   MAXTRRES_S11_B13_I9_D14_V2,
              MAXTRRES_S11_B13_I9_D15_V2,   MAXTRRES_S11_B13_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S11_B13_I10_D13_V2,  MAXTRRES_S11_B13_I10_D14_V2,
              MAXTRRES_S11_B13_I10_D15_V2,  MAXTRRES_S11_B13_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S11_B13_I11_D13_V2,  MAXTRRES_S11_B13_I11_D14_V2,
              MAXTRRES_S11_B13_I11_D15_V2,  MAXTRRES_S11_B13_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B14_I8_D14_V2,
              MAXTRRES_S11_B14_I8_D15_V2,   MAXTRRES_S11_B14_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B14_I9_D14_V2,
              MAXTRRES_S11_B14_I9_D15_V2,   MAXTRRES_S11_B14_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B14_I10_D14_V2,
              MAXTRRES_S11_B14_I10_D15_V2,  MAXTRRES_S11_B14_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B14_I11_D14_V2,
              MAXTRRES_S11_B14_I11_D15_V2,  MAXTRRES_S11_B14_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S11_B15_I8_D15_V2,   MAXTRRES_S11_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S11_B15_I9_D15_V2,   MAXTRRES_S11_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S11_B15_I10_D15_V2,  MAXTRRES_S11_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S11_B15_I11_D15_V2,  MAXTRRES_S11_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S11_B16_I11_D16_V2 },
        },
    },

    {   {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            MAXTRRES_S12_B12_I8_D12_V2,
              MAXTRRES_S12_B12_I8_D13_V2,   MAXTRRES_S12_B12_I8_D14_V2,
              MAXTRRES_S12_B12_I8_D15_V2,   MAXTRRES_S12_B12_I8_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S12_B12_I9_D12_V2,
              MAXTRRES_S12_B12_I9_D13_V2,   MAXTRRES_S12_B12_I9_D14_V2,
              MAXTRRES_S12_B12_I9_D15_V2,   MAXTRRES_S12_B12_I9_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S12_B12_I10_D12_V2,
              MAXTRRES_S12_B12_I10_D13_V2,  MAXTRRES_S12_B12_I10_D14_V2,
              MAXTRRES_S12_B12_I10_D15_V2,  MAXTRRES_S12_B12_I10_D16_V2 },
            { 0,                            0,
              0,                            MAXTRRES_S12_B12_I11_D12_V2,
              MAXTRRES_S12_B12_I11_D13_V2,  MAXTRRES_S12_B12_I11_D14_V2,
              MAXTRRES_S12_B12_I11_D15_V2,  MAXTRRES_S12_B12_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              MAXTRRES_S12_B13_I8_D13_V2,   MAXTRRES_S12_B13_I8_D14_V2,
              MAXTRRES_S12_B13_I8_D15_V2,   MAXTRRES_S12_B13_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S12_B13_I9_D13_V2,   MAXTRRES_S12_B13_I9_D14_V2,
              MAXTRRES_S12_B13_I9_D15_V2,   MAXTRRES_S12_B13_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S12_B13_I10_D13_V2,  MAXTRRES_S12_B13_I10_D14_V2,
              MAXTRRES_S12_B13_I10_D15_V2,  MAXTRRES_S12_B13_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S12_B13_I11_D13_V2,  MAXTRRES_S12_B13_I11_D14_V2,
              MAXTRRES_S12_B13_I11_D15_V2,  MAXTRRES_S12_B13_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B14_I8_D14_V2,
              MAXTRRES_S12_B14_I8_D15_V2,   MAXTRRES_S12_B14_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B14_I9_D14_V2,
              MAXTRRES_S12_B14_I9_D15_V2,   MAXTRRES_S12_B14_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B14_I10_D14_V2,
              MAXTRRES_S12_B14_I10_D15_V2,  MAXTRRES_S12_B14_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B14_I11_D14_V2,
              MAXTRRES_S12_B14_I11_D15_V2,  MAXTRRES_S12_B14_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S12_B15_I8_D15_V2,   MAXTRRES_S12_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S12_B15_I9_D15_V2,   MAXTRRES_S12_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S12_B15_I10_D15_V2,  MAXTRRES_S12_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S12_B15_I11_D15_V2,  MAXTRRES_S12_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S12_B16_I11_D16_V2 },
        },
    },

    {   {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            0,
              MAXTRRES_S13_B13_I8_D13_V2,   MAXTRRES_S13_B13_I8_D14_V2,
              MAXTRRES_S13_B13_I8_D15_V2,   MAXTRRES_S13_B13_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S13_B13_I9_D13_V2,   MAXTRRES_S13_B13_I9_D14_V2,
              MAXTRRES_S13_B13_I9_D15_V2,   MAXTRRES_S13_B13_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S13_B13_I10_D13_V2,  MAXTRRES_S13_B13_I10_D14_V2,
              MAXTRRES_S13_B13_I10_D15_V2,  MAXTRRES_S13_B13_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              MAXTRRES_S13_B13_I11_D13_V2,  MAXTRRES_S13_B13_I11_D14_V2,
              MAXTRRES_S13_B13_I11_D15_V2,  MAXTRRES_S13_B13_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B14_I8_D14_V2,
              MAXTRRES_S13_B14_I8_D15_V2,   MAXTRRES_S13_B14_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B14_I9_D14_V2,
              MAXTRRES_S13_B14_I9_D15_V2,   MAXTRRES_S13_B14_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B14_I10_D14_V2,
              MAXTRRES_S13_B14_I10_D15_V2,  MAXTRRES_S13_B14_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B14_I11_D14_V2,
              MAXTRRES_S13_B14_I11_D15_V2,  MAXTRRES_S13_B14_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S13_B15_I8_D15_V2,   MAXTRRES_S13_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S13_B15_I9_D15_V2,   MAXTRRES_S13_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S13_B15_I10_D15_V2,  MAXTRRES_S13_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S13_B15_I11_D15_V2,  MAXTRRES_S13_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S13_B16_I11_D16_V2 },
        },
    },

    {   {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B14_I8_D14_V2,
              MAXTRRES_S14_B14_I8_D15_V2,   MAXTRRES_S14_B14_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B14_I9_D14_V2,
              MAXTRRES_S14_B14_I9_D15_V2,   MAXTRRES_S14_B14_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B14_I10_D14_V2,
              MAXTRRES_S14_B14_I10_D15_V2,  MAXTRRES_S14_B14_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B14_I11_D14_V2,
              MAXTRRES_S14_B14_I11_D15_V2,  MAXTRRES_S14_B14_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S14_B15_I8_D15_V2,   MAXTRRES_S14_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S14_B15_I9_D15_V2,   MAXTRRES_S14_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S14_B15_I10_D15_V2,  MAXTRRES_S14_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S14_B15_I11_D15_V2,  MAXTRRES_S14_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S14_B16_I11_D16_V2 },
        },
    },

    {   {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
            { 0, 0, 0, 0, 0, 0, 0, 0 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S15_B15_I8_D15_V2,   MAXTRRES_S15_B15_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S15_B15_I9_D15_V2,   MAXTRRES_S15_B15_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S15_B15_I10_D15_V2,  MAXTRRES_S15_B15_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              MAXTRRES_S15_B15_I11_D15_V2,  MAXTRRES_S15_B15_I11_D16_V2 },
        },
        {   { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S15_B16_I8_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S15_B16_I9_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S15_B16_I10_D16_V2 },
            { 0,                            0,
              0,                            0,
              0,                            0,
              0,                            MAXTRRES_S15_B16_I11_D16_V2 },
        },
    },
};
