/***************************************************************************
                          plugin_katesymbolviewer.h  -  description
                             -------------------
    begin                : Apr 2 2003
    author               : 2003 Massimo Callegari
    email                : massimocallegari@yahoo.it
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef _PLUGIN_KATE_SYMBOLVIEWER_H_
#define _PLUGIN_KATE_SYMBOLVIEWER_H_

#include <kate/application.h>
#include <kate/documentmanager.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>
#include <kate/toolviewmanager.h>

#include <kdebug.h>
#include <qmemarray.h>
#include <qpopupmenu.h>
#include <qevent.h>
#include <klibloader.h>
#include <klocale.h>
#include <klistview.h>
#include <kiconloader.h>

class KatePluginSymbolViewerView : public QObject, public KXMLGUIClient
{
  Q_OBJECT

  public:
    KatePluginSymbolViewerView (Kate::MainWindow *w);
    virtual ~KatePluginSymbolViewerView ();
      
  public slots:
    void slotInsertSymbol();
    void slotRefreshSymbol();
    void slotChangeMode();
    void slotDocChanged();
    void goToSymbol(QListViewItem *);
    void slotShowContextMenu(QListViewItem *, const QPoint&, int);
    void toggleShowMacros(void);
    void toggleShowStructures(void);
    void toggleShowFunctions(void);
  protected:
    void slotViewChanged(QResizeEvent * e);
  private:
    QPopupMenu *popup;
    KListView *symbols;
    bool m_Active;
    int m_macro, m_struct, m_func;
    bool macro_on, struct_on, func_on;
    bool listMode;
    QMemArray<uint> positions;
    void parseSymbols(void);
    void parseCppSymbols(void);
    void parseTclSymbols(void);
  public:
    Kate::MainWindow *win;
};

class KatePluginSymbolViewer : public Kate::Plugin, Kate::PluginViewInterface
{
  Q_OBJECT

  public:
    KatePluginSymbolViewer( QObject* parent = 0, const char* name = 0, const QStringList& = QStringList() );
    virtual ~KatePluginSymbolViewer();
    
    void addView (Kate::MainWindow *win);
    void removeView (Kate::MainWindow *win);
        
  private:
    QPtrList<KatePluginSymbolViewerView> m_views; 
};

/* XPM */
static const char* const class_xpm[] = { 
"16 16 10 1",
" 	c None",
".	c #000000",
"+	c #A4E8FC",
"@	c #24D0FC",
"#	c #001CD0",
"$	c #0080E8",
"%	c #C0FFFF",
"&	c #00FFFF",
"*	c #008080",
"=	c #00C0C0",
"     ..         ",
"    .++..       ",
"   .+++@@.      ",
"  .@@@@@#...    ",
"  .$$@@##.%%..  ",
"  .$$$##.%%%&&. ",
"  .$$$#.&&&&&*. ",
"   ...#.==&&**. ",
"   .++..===***. ",
"  .+++@@.==**.  ",
" .@@@@@#..=*.   ",
" .$$@@##. ..    ",
" .$$$###.       ",
" .$$$##.        ",
"  ..$#.         ",
"    ..          "};

static const char* const struct_xpm[] = {
"16 16 14 1",
" 	c None",
".	c #000000",
"+	c #C0FFC0",
"@	c #00FF00",
"#	c #008000",
"$	c #00C000",
"%	c #C0FFFF",
"&	c #00FFFF",
"*	c #008080",
"=	c #00C0C0",
"-	c #FFFFC0",
";	c #FFFF00",
">	c #808000",
",	c #C0C000",
"     ..         ",
"    .++..       ",
"   .+++@@.      ",
"  .@@@@@#...    ",
"  .$$@@##.%%..  ",
"  .$$$##.%%%&&. ",
"  .$$$#.&&&&&*. ",
"   ...#.==&&**. ",
"   .--..===***. ",
"  .---;;.==**.  ",
" .;;;;;>..=*.   ",
" .,,;;>>. ..    ",
" .,,,>>>.       ",
" .,,,>>.        ",
"  ..,>.         ",
"    ..          "};

// Sarah's colors...
static const char* const macro_xpm[] = {
"16 16 14 1",
" 	c None",
".	c #000000",
"+	c #FF7FE5",
"@	c #FF00C7",
"#	c #7F0066",
"$	c #BC0096",
"%	c #C0FFFF",
"&	c #00FFFF",
"*	c #008080",
"=	c #00C0C0",
"-	c #D493FF",
";	c #A100FF",
">	c #470082",
",	c #6B00B7",
"     ..         ",
"    .++..       ",
"   .+++@@.      ",
"  .@@@@@#...    ",
"  .$$@@##.%%..  ",
"  .$$$##.%%%&&. ",
"  .$$$#.&&&&&*. ",
"   ...#.==&&**. ",
"   .--..===***. ",
"  .---;;.==**.  ",
" .;;;;;>..=*.   ",
" .,,;;>>. ..    ",
" .,,,>>>.       ",
" .,,,>>.        ",
"  ..,>.         ",
"    ..          "};

#endif
