/***************************************************************************
                              domlistviewitem.h
                             -------------------

    author               : Andreas Schlapbach
    email                : schlpbch@iam.unibe.ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* $Id: domlistviewitem.h,v 1.6 2001/06/08 18:35:32 schlpbch Exp $ */
 
#ifndef DOMLISTVIEWITEMS_H
#define DOMLISTVIEWITEMS_H
 
#include <qlistview.h>
#include <qcolor.h>
#include <qfont.h>

class DOMListViewItem : public QListViewItem
{

 public:
   DOMListViewItem( QListView *parent );
   DOMListViewItem( QListView *parent, QListViewItem *after ); 
   DOMListViewItem( QListViewItem *parent );
   DOMListViewItem( QListViewItem *parent, QListViewItem *after );
   virtual ~DOMListViewItem();
 
  virtual void paintCell( QPainter *p, const QColorGroup &cg,
			  int column, int width, int alignment );  

  void setNamedColor( const QString name) { m_color.setNamedColor(name);} 

  void setFont( const QFont font) { m_font = font;}
  void setItalic( bool b) {m_font.setItalic(b);}
  void setBold( bool b) {m_font.setBold(b);}
  void setUnderline(bool b) {m_font.setUnderline(b);}

 private:
  void init();
  QColor m_color;
  QFont m_font;
};
#endif
