/* This file is part of the KDE project
   Copyright (C) 2002 Alexander Neundorf <neundorf@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef smbmounterplugin_h
#define smbmounterplugin_h

#include <kparts/plugin.h>
#include <klibloader.h>
#include <kio/job.h>

class KonqDirPart;
class KAction;

class SmbmounterPlugin : public KParts::Plugin
{
   Q_OBJECT
   public:
      SmbmounterPlugin( QObject* parent, const char* name, const QStringList & );
      virtual ~SmbmounterPlugin() {}

   protected slots:
      void updateActions();
      void smbmount();
      void smbumount();
      void mountResult(KIO::Job *job);
      void umountResult(KIO::Job *job);
   protected:
      bool isMounted(const QString& path);
      QString buildMountPath(const QString& host, const QString& share);
//      int makeDirHier(const QString& path);
      void getHostAndShare(const KURL& url, QString& host, QString& share);
      KonqDirPart* parentPart() const;

      KAction* m_smbmountAction;
      KAction* m_smbumountAction;
      QString m_share;
      QString m_host;
      QString m_path;
};

#endif
