// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#ifndef VIEW_H
#define VIEW_H

#include <kmainwindow.h>
#include <kaction.h>
#include <klineedit.h>

#include "tree.h"

class View : public KMainWindow
{
Q_OBJECT
	Tree *mTree;

public:
	View(Oblique *oblique, Query *query);

	Tree *tree() { return mTree; }

public slots:
	void addFiles();

signals:
	void listHidden();
	void listShown();

private slots:
	void configureToolBars();
	void newToolBarConfig();
	void jumpTextChanged(const QString &text);

protected:
	virtual void showEvent(QShowEvent *) { emit listShown(); }
	virtual void hideEvent(QHideEvent *) { emit listHidden(); }
	void closeEvent(QCloseEvent*);
};


class LineEditAction : public KWidgetAction
{
Q_OBJECT
public:
	LineEditAction(const QString &text, const QObject *reciever, const char *slot, KActionCollection *parent, const char *name);

	KLineEdit *widget() { return static_cast<KLineEdit*>(KWidgetAction::widget()); }
	KLineEdit *lineEdit() { return widget(); }
};


#endif

