// -*- c++ -*-

// $Id: spraycan.h,v 1.11 2003/01/12 22:42:19 nhasan Exp $

#ifndef SPRAYCAN_H
#define SPRAYCAN_H

#include "tool.h"

class QTimer;

class SprayCan : public Tool
{
  Q_OBJECT

public:
    SprayCan();
    ~SprayCan();
    void mousePressEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    void activating();
    const char* pixmap() const;

signals:
    void modified();

private:
    int density; // Dots per second (approx)
    QTimer *timer;
    int x, y;
    int brushsize;
    bool drawing;
    int activeButton;

private slots:
    void drawDot();
};

#endif // SPRAYCAN_H
