/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmpigment.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmpigmentedit.h"

#include <klocale.h>

PMMetaObject* PMPigment::s_pMetaObject = 0;
PMObject* createNewPigment( PMPart* part )
{
   return new PMPigment( part );
}

PMPigment::PMPigment( PMPart* part )
      : Base( part )
{
}

PMPigment::PMPigment( const PMPigment& p )
      : Base( p )
{
}

PMPigment::~PMPigment( )
{
}

PMMetaObject* PMPigment::metaObject( ) const
{
   if( !s_pMetaObject )
   {
      s_pMetaObject = new PMMetaObject( "Pigment", Base::metaObject( ),
                                        createNewPigment );
   }
   return s_pMetaObject;
}

void PMPigment::cleanUp( ) const
{
   if( s_pMetaObject )
   {
      delete s_pMetaObject;
      s_pMetaObject = 0;
   }
   Base::cleanUp( );
}

QString PMPigment::description( ) const
{
   return i18n( "pigment" );
}

PMDialogEditBase* PMPigment::editWidget( QWidget* parent ) const
{
   return new PMPigmentEdit( parent );
}

