/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2003 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef SETTINGS_H
#define SETTINGS_H

#include <qstring.h>
#include <qstringlist.h>
#include <qfont.h>
#include <qcolor.h>
#include <kurl.h>

#include "catalogsettings.h"

struct SearchSettings
{
   bool autoSearch;
   QString defaultModule;
};

struct EditorSettings
{
   enum DiffSource { File, Database, Msgstr };
   
   bool autoUnsetFuzzy;
   bool beepOnError;
   bool autoCheckColorError;
   
   QStringList autoCheckTools;

   bool cleverEditing;
   bool highlightBg;
   bool whitespacePoints;
   bool quotes;
   bool highlightSyntax;

   bool ledInStatusbar;

   QColor bgColor;
   QColor quotedColor;
   QColor errorColor;
   QColor cformatColor;
   QColor accelColor;
   QColor tagColor;
   QColor ledColor;

   QFont msgFont;

   // diff
   DiffSource diffSource;
   QColor diffAddColor;
   QColor diffDelColor;
   bool diffAddUnderline;
   bool diffDelStrikeOut;
   QString diffBaseDir;
};

struct SpellcheckSettings
{
   bool valid;
   bool noRootAffix;
   bool runTogether;
   int spellEncoding;
   int spellClient;
   QString spellDict;

   bool rememberIgnored;
   QString ignoreURL;

   bool onFlySpellcheck;
   
   SpellcheckSettings() { valid=false; }
};

/**
* This namespace provides static methods and variables to get the default
* values of configuration values
*/
namespace Defaults
{
   class  Editor
   {
    public:
       static const bool autoUnsetFuzzy;
       static const bool beepOnError;
       static const bool autoCheckColorError;

       static const bool cleverEditing;
       static const bool highlightBg;
       static const bool whitespacePoints;
       static const bool quotes;
       static const bool highlightSyntax;

       static const bool ledInStatusbar;

       static const QColor bgColor;
       static const QColor quotedColor;
       static const QColor errorColor;
       static const QColor cformatColor;
       static const QColor accelColor;
       static const QColor tagColor;
       static const QColor ledColor;

       static QFont msgFont();
       static QStringList autoCheckTools();

       static const QColor diffAddColor;
       static const QColor diffDelColor;
       static const bool diffAddUnderline;
       static const bool diffDelStrikeOut;
       static const EditorSettings::DiffSource diffSource;
       static const QString diffBaseDir;
   };


   class Search
   {
    public:
       static const bool autoSearch;
       static const QString defaultModule;
   };
   
   class Spellcheck
   {
    public:
       static const bool rememberIgnored;
       static QString ignoreURL();
       static const bool onFlySpellcheck;
    private:
       static QString _ignoreURL;
   };
}


#endif // SETTINGS_H
