/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

final class ShortBufferImpl
extends ShortBuffer {
    private boolean readOnly;

    ShortBufferImpl(int capacity) {
        this(new short[capacity], 0, capacity, capacity, 0, -1, false);
    }

    ShortBufferImpl(short[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ShortBuffer slice() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public ShortBuffer duplicate() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public ShortBuffer compact() {
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final short get() {
        short result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final ShortBuffer put(short value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final short get(int index) {
        return this.backing_buffer[index];
    }

    public final ShortBuffer put(int index, short value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

